package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Campanha;
import java.util.List;

import com.ejie.y41b.model.TipProtocolo;

/**
 * TipProtocoloDao  
 *  
 */

public interface TipProtocoloDao {
    
    /**
     * Inserts a single row in the TipProtocolo table.
     *
     * @param tipprotocolo TipProtocolo
     * @return TipProtocolo
     */
    TipProtocolo add(TipProtocolo tipprotocolo);

    /**
     * Updates a single row in the TipProtocolo table.
     *
     * @param tipprotocolo TipProtocolo
     * @return TipProtocolo
     */
    TipProtocolo update(TipProtocolo tipprotocolo);

    /**
     * Finds a single row in the TipProtocolo table.
     *
     * @param tipprotocolo TipProtocolo
     * @return TipProtocolo
     */
    TipProtocolo find(TipProtocolo tipprotocolo);

    /**
     * Deletes a single row in the TipProtocolo table.
     *
     * @param tipprotocolo TipProtocolo
     * @return 
     */
    void remove(TipProtocolo tipprotocolo);

    /**
     * Finds a List of rows in the TipProtocolo table.
     *
     * @param tipprotocolo TipProtocolo
     * @param pagination Pagination
     * @return List
     */
    List<TipProtocolo> findAll(TipProtocolo tipprotocolo, Pagination pagination);

    /**
     * Counts rows in the TipProtocolo table.
     *
     * @param tipprotocolo TipProtocolo
     * @return Long
     */
    Long findAllCount(TipProtocolo tipprotocolo);
	
	/**
     * Finds rows in the TipProtocolo table using like.
     *
     * @param tipprotocolo TipProtocolo
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List
     */
	List<TipProtocolo> findAllLike(TipProtocolo tipprotocolo, Pagination pagination, Boolean startsWith);
	
    /**
     * Counts rows in the TipProtocolo table using like.
     *
     * @param tipprotocolo TipProtocolo
     * @param startsWith Boolean
     * @return Long
     */
    Long findAllLikeCount(TipProtocolo tipprotocolo, Boolean startsWith);
	
	/**
	 * Inserts a single row in the CampanhaTipoprotocolo table.
	 *
	 * @param tipprotocolo  TipProtocolo
	 * @return TipProtocolo 
	 */
	TipProtocolo addCampanhaTipoprotocolo(TipProtocolo tipprotocolo);   

    /**
     * Deletes a single row in the CampanhaTipoprotocolo table.
     *
     * @param tipprotocolo TipProtocolo
     * @return 
     */
	void removeCampanhaTipoprotocolo(TipProtocolo tipprotocolo);

    /**
     * Find a single row in the findCampanhaTipoprotocolo Many To Many relationship.
     *
     * @param tipprotocolo TipProtocolo
     * @param  campanha Campanha
     * @param pagination Pagination
     * @return TipProtocolo
     */
	TipProtocolo findCampanhaTipoprotocolo(TipProtocolo tipprotocolo, Campanha campanha, Pagination pagination);

    /**
     * Counts rows rows in the CampanhaTipoprotocolo table.
     *
     * @param tipprotocolo TipProtocolo
     * @param  campanha Campanha
     * @return Long
     */
	Long findCampanhaTipoprotocoloCount(TipProtocolo tipprotocolo, Campanha campanha);
}

