package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Actuacion;
import com.ejie.y41b.model.Campanha;
import com.ejie.y41b.model.Protocol;
import com.ejie.y41b.model.TipPregProtoc;
import com.ejie.y41b.model.TipProtocolo;

/**
 * TipPregProtocDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class TipPregProtocDaoImpl implements TipPregProtocDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<TipPregProtoc> rwMap = new RowMapper<TipPregProtoc>() {
		public TipPregProtoc mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new TipPregProtoc(resultSet.getString("TRCODIGO"), resultSet.getLong("TRNRTIPP"),
					resultSet.getString("TRCOTIPP"), resultSet.getString("TRDETIPP"), resultSet.getString("TRCOTTI"),
					resultSet.getString("TRINTI"), resultSet.getString("TRINRE"), resultSet.getString("TRREES"),
					resultSet.getString("TREXCLUIROBI"),
					new TipProtocolo(resultSet.getString("TipProtocoloTPCODIGO"),
							resultSet.getString("TipProtocoloTPNOMBRE"), resultSet.getString(
									"TipProtocoloTPCOTMO"),
							resultSet.getString("TipProtocoloTPESTANDAR"),
							new Campanha(resultSet.getString("TipProtocoloTPCOCM"), null, null, null, null, null, null,
									null, null, null, null, null, null, null, null, null, null, null, null, null, null,
									null)));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the TipPregProtoc table.
	 * 
	 * @param tippregprotoc
	 *            Pagination
	 * @return TipPregProtoc
	 */
	public TipPregProtoc add(TipPregProtoc tippregprotoc) {
		String query = "INSERT INTO TIP_PREG_PROTOC (TRCODIGO, TRCOTP, TRNRTIPP, TRCOTIPP, TRDETIPP, TRCOTTI, TRINTI, TRINRE, TRREES, TREXCLUIROBI) VALUES (?,?,?,?,?,?,?,?,?,?)";
		Object getTipProtocoloTpcodigoAux = null;
		if (tippregprotoc.getTipProtocolo() != null && tippregprotoc.getTipProtocolo().getTpcodigo() != null) {
			getTipProtocoloTpcodigoAux = tippregprotoc.getTipProtocolo().getTpcodigo();
		}
		this.jdbcTemplate.update(query, tippregprotoc.getTrcodigo(), getTipProtocoloTpcodigoAux,
				tippregprotoc.getTrnrtipp(), tippregprotoc.getTrcotipp(), tippregprotoc.getTrdetipp(),
				tippregprotoc.getTrcotti(), tippregprotoc.getTrinti(), tippregprotoc.getTrinre(),
				tippregprotoc.getTrrees(), tippregprotoc.getTrexcluirobi());
		return tippregprotoc;
	}

	/**
	 * Updates a single row in the TipPregProtoc table.
	 * 
	 * @param tippregprotoc
	 *            Pagination
	 * @return TipPregProtoc
	 */
	public TipPregProtoc update(TipPregProtoc tippregprotoc) {
		String query = "UPDATE TIP_PREG_PROTOC SET TRCOTP=?, TRNRTIPP=?, TRCOTIPP=?, TRDETIPP=?, TRCOTTI=?, TRINTI=?, TRINRE=?, TRREES=?, TREXCLUIROBI=? WHERE TRCODIGO=?";
		Object getTipProtocoloTpcodigoAux = null;
		if (tippregprotoc.getTipProtocolo() != null && tippregprotoc.getTipProtocolo().getTpcodigo() != null) {
			getTipProtocoloTpcodigoAux = tippregprotoc.getTipProtocolo().getTpcodigo();
		}
		this.jdbcTemplate.update(query, getTipProtocoloTpcodigoAux, tippregprotoc.getTrnrtipp(),
				tippregprotoc.getTrcotipp(), tippregprotoc.getTrdetipp(), tippregprotoc.getTrcotti(),
				tippregprotoc.getTrinti(), tippregprotoc.getTrinre(), tippregprotoc.getTrrees(),
				tippregprotoc.getTrexcluirobi(), tippregprotoc.getTrcodigo());
		return tippregprotoc;
	}

	/**
	 * Finds a single row in the TipPregProtoc table.
	 * 
	 * @param tippregprotoc
	 *            Pagination
	 * @return TipPregProtoc
	 */
	@Transactional(readOnly = true)
	public TipPregProtoc find(TipPregProtoc tippregprotoc) {
		String query = "SELECT t1.TRCODIGO TRCODIGO, t1.TRNRTIPP TRNRTIPP, t1.TRCOTIPP TRCOTIPP, t1.TRDETIPP TRDETIPP, t1.TRCOTTI TRCOTTI, t1.TRINTI TRINTI, t1.TRINRE TRINRE, t1.TRREES TRREES, t1.TREXCLUIROBI TREXCLUIROBI, t2.TPCODIGO TIPPROTOCOLOTPCODIGO, t2.TPNOMBRE TIPPROTOCOLOTPNOMBRE, t2.TPCOTMO TIPPROTOCOLOTPCOTMO, t2.TPESTANDAR TIPPROTOCOLOTPESTANDAR, t2.TPCOCM TIPPROTOCOLOTPCOCM FROM TIP_PREG_PROTOC t1 , TIP_PROTOCOLO t2  WHERE t1.TRCODIGO = ?   AND t1.TRCOTP= t2.TPCODIGO(+)";

		List<TipPregProtoc> tippregprotocList = this.jdbcTemplate.query(query, this.rwMap, tippregprotoc.getTrcodigo());
		return (TipPregProtoc) DataAccessUtils.uniqueResult(tippregprotocList);
	}

	/**
	 * Removes a single row in the TipPregProtoc table.
	 * 
	 * @param tippregprotoc
	 *            Pagination
	 * @return
	 */
	public void remove(TipPregProtoc tippregprotoc) {
		String query = "DELETE FROM TIP_PREG_PROTOC WHERE TRCODIGO=?";
		this.jdbcTemplate.update(query, tippregprotoc.getTrcodigo());
	}

	/**
	 * Finds a List of rows in the TipPregProtoc table.
	 * 
	 * @param tippregprotoc
	 *            TipPregProtoc
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<TipPregProtoc> findAll(TipPregProtoc tippregprotoc, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.TRCODIGO TRCODIGO,t1.TRNRTIPP TRNRTIPP,t1.TRCOTIPP TRCOTIPP,t1.TRDETIPP TRDETIPP,t1.TRCOTTI TRCOTTI,t1.TRINTI TRINTI,t1.TRINRE TRINRE,t1.TRREES TRREES, t1.TREXCLUIROBI TREXCLUIROBI,t2.TPCODIGO TIPPROTOCOLOTPCODIGO,t2.TPNOMBRE TIPPROTOCOLOTPNOMBRE,t2.TPCOTMO TIPPROTOCOLOTPCOTMO,t2.TPESTANDAR TIPPROTOCOLOTPESTANDAR,t2.TPCOCM TIPPROTOCOLOTPCOCM ");
		query.append("FROM TIP_PREG_PROTOC t1 ,TIP_PROTOCOLO t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(tippregprotoc);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.TRCOTP= t2.TPCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<TipPregProtoc>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the TipPregProtoc table.
	 * 
	 * @param tippregprotoc
	 *            TipPregProtoc
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(TipPregProtoc tippregprotoc) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM TIP_PREG_PROTOC t1 , TIP_PROTOCOLO t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(tippregprotoc);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.TRCOTP= t2.TPCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds a List of rows in the TipPregProtoc table.
	 * 
	 * @param tippregprotoc
	 *            TipPregProtoc
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<TipPregProtoc> findAllProtocoloOrdenado(TipPregProtoc tippregprotoc) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.TRCOTP= t2.TPCODIGO(+) AND t1.TRCOTTI= t3.TTICODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.TRCODIGO TRCODIGO,t1.TRNRTIPP TRNRTIPP,t1.TRCOTIPP TRCOTIPP,t1.TRDETIPP TRDETIPP,t1.TRINTI TRINTI,t1.TRINRE TRINRE,t1.TRREES TRREES, t1.TREXCLUIROBI TREXCLUIROBI,t2.TPCODIGO TIPPROTOCOLOTPCODIGO,t2.TPNOMBRE TIPPROTOCOLOTPNOMBRE,t2.TPCOTMO TIPPROTOCOLOTPCOTMO,t3.TTICODIGO TIPREQNORMATIVOTTICODIGO,t3.TTINOMBRE TIPREQNORMATIVOTTINOMBRE,t3.TTINOCO TIPREQNORMATIVOTTINOCO,t3.TTITEDE TIPREQNORMATIVOTTITEDE,t3.TTICOSE TIPREQNORMATIVOTTICOSE,t3.TTINOCO2 TIPREQNORMATIVOTTINOCO2,t3.TTIINSEL1 TIPREQNORMATIVOTTIINSEL1,t3.TTICOL4 TIPREQNORMATIVOTTICOL4,t3.TTINOMBREE TIPREQNORMATIVOTTINOMBREE,t3.TTINOMBREI TIPREQNORMATIVOTTINOMBREI,t3.TTINOMBREF TIPREQNORMATIVOTTINOMBREF,t3.TTINOCOE TIPREQNORMATIVOTTINOCOE,t3.TTINOCOI TIPREQNORMATIVOTTINOCOI,t3.TTINOCOF TIPREQNORMATIVOTTINOCOF,t3.TTITEDEE TIPREQNORMATIVOTTITEDEE,t3.TTITEDEI TIPREQNORMATIVOTTITEDEI,t3.TTITEDEF TIPREQNORMATIVOTTITEDEF,t3.TTICODGRUPO TIPREQNORMATIVOTTICODGRUPO,t3.TTINOMBREA TIPREQNORMATIVOTTINOMBREA,t3.TTINOCOA TIPREQNORMATIVOTTINOCOA,t3.TTITEDEA TIPREQNORMATIVOTTITEDEA,t3.TTICOE7 TIPREQNORMATIVOTTICOE7,t3.TTICOINC TIPREQNORMATIVOTTICOINC,t2.TPCOCM TIPPROTOCOLOTPCOCM "
						+ "FROM TIP_PREG_PROTOC t1 ,TIP_PROTOCOLO t2 ,TIP_REQ_NORMATIVO t3 ");

		if (tippregprotoc != null && tippregprotoc.getTrcodigo() != null) {
			where.append(" AND t1.TRCODIGO = ?");
			params.add(tippregprotoc.getTrcodigo());
		}
		if (tippregprotoc != null && tippregprotoc.getTipProtocolo() != null
				&& tippregprotoc.getTipProtocolo().getTpcodigo() != null) {
			where.append(" AND t2.TPCODIGO = ?");
			params.add(tippregprotoc.getTipProtocolo().getTpcodigo());
		}
		if (tippregprotoc != null && tippregprotoc.getTipProtocolo() != null
				&& tippregprotoc.getTipProtocolo().getCampanha() != null
				&& tippregprotoc.getTipProtocolo().getCampanha().getCmcodigo() != null) {
			where.append(" AND t2.TPCOCM = ?");
			params.add(tippregprotoc.getTipProtocolo().getCampanha().getCmcodigo());
		}
		if (tippregprotoc != null && tippregprotoc.getTipProtocolo() != null
				&& tippregprotoc.getTipProtocolo().getTpnombre() != null) {
			where.append(" AND t2.TPNOMBRE = ?");
			params.add(tippregprotoc.getTipProtocolo().getTpnombre());
		}
		if (tippregprotoc != null && tippregprotoc.getTipProtocolo() != null
				&& tippregprotoc.getTipProtocolo().getTpcotmo() != null) {
			where.append(" AND t2.TPCOTMO = ?");
			params.add(tippregprotoc.getTipProtocolo().getTpcotmo());
		}
		if (tippregprotoc != null && tippregprotoc.getTrnrtipp() != null) {
			where.append(" AND t1.TRNRTIPP = ?");
			params.add(tippregprotoc.getTrnrtipp());
		}
		if (tippregprotoc != null && tippregprotoc.getTrcotipp() != null) {
			where.append(" AND t1.TRCOTIPP = ?");
			params.add(tippregprotoc.getTrcotipp());
		}
		if (tippregprotoc != null && tippregprotoc.getTrdetipp() != null) {
			where.append(" AND t1.TRDETIPP = ?");
			params.add(tippregprotoc.getTrdetipp());
		}
		if (tippregprotoc != null && tippregprotoc.getTrinti() != null) {
			where.append(" AND t1.TRINTI = ?");
			params.add(tippregprotoc.getTrinti());
		}
		if (tippregprotoc != null && tippregprotoc.getTrinre() != null) {
			where.append(" AND t1.TRINRE = ?");
			params.add(tippregprotoc.getTrinre());
		}
		if (tippregprotoc != null && tippregprotoc.getTrrees() != null) {
			where.append(" AND t1.TRREES = ?");
			params.add(tippregprotoc.getTrrees());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		order.append(" ORDER BY TRNRTIPP");
		query.append(order);

		return (List<TipPregProtoc>) this.jdbcTemplate.query(query.toString(), rwMap, params.toArray());
	}

	/**
	 * Finds rows in the TipPregProtoc table using like.
	 * 
	 * @param tippregprotoc
	 *            TipPregProtoc
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<TipPregProtoc> findAllLike(TipPregProtoc tippregprotoc, Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.TRCODIGO TRCODIGO,t1.TRNRTIPP TRNRTIPP,t1.TRCOTIPP TRCOTIPP,t1.TRDETIPP TRDETIPP,t1.TRCOTTI TRCOTTI,t1.TRINTI TRINTI,t1.TRINRE TRINRE,t1.TRREES TRREES, t1.TREXCLUIROBI TREXCLUIROBI,t2.TPCODIGO TIPPROTOCOLOTPCODIGO,t2.TPNOMBRE TIPPROTOCOLOTPNOMBRE,t2.TPCOTMO TIPPROTOCOLOTPCOTMO,t2.TPESTANDAR TIPPROTOCOLOTPESTANDAR,t2.TPCOCM TIPPROTOCOLOTPCOCM ");
		query.append("FROM TIP_PREG_PROTOC t1 ,TIP_PROTOCOLO t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(tippregprotoc, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.TRCOTP= t2.TPCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<TipPregProtoc>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the TipPregProtoc table using like.
	 * 
	 * @param tippregprotoc
	 *            TipPregProtoc
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(TipPregProtoc tippregprotoc, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM TIP_PREG_PROTOC t1 ,TIP_PROTOCOLO t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(tippregprotoc, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.TRCOTP= t2.TPCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the TipPregProtoc entity
	 * 
	 * @param tippregprotoc
	 *            TipPregProtoc Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(TipPregProtoc tippregprotoc) {

		StringBuilder where = new StringBuilder(TipPregProtocDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (tippregprotoc != null && tippregprotoc.getTrcodigo() != null) {
			where.append(" AND t1.TRCODIGO = ?");
			params.add(tippregprotoc.getTrcodigo());
		}
		if (tippregprotoc != null && tippregprotoc.getTipProtocolo() != null
				&& tippregprotoc.getTipProtocolo().getTpcodigo() != null) {
			where.append(" AND t2.TPCODIGO = ?");
			params.add(tippregprotoc.getTipProtocolo().getTpcodigo());
		}
		if (tippregprotoc != null && tippregprotoc.getTipProtocolo() != null
				&& tippregprotoc.getTipProtocolo().getCampanha() != null
				&& tippregprotoc.getTipProtocolo().getCampanha().getCmcodigo() != null) {
			where.append(" AND t2.TPCOCM = ?");
			params.add(tippregprotoc.getTipProtocolo().getCampanha().getCmcodigo());
		}
		if (tippregprotoc != null && tippregprotoc.getTipProtocolo() != null
				&& tippregprotoc.getTipProtocolo().getTpnombre() != null) {
			where.append(" AND t2.TPNOMBRE = ?");
			params.add(tippregprotoc.getTipProtocolo().getTpnombre());
		}
		if (tippregprotoc != null && tippregprotoc.getTipProtocolo() != null
				&& tippregprotoc.getTipProtocolo().getTpcotmo() != null) {
			where.append(" AND t2.TPCOTMO = ?");
			params.add(tippregprotoc.getTipProtocolo().getTpcotmo());
		}
		if (tippregprotoc != null && tippregprotoc.getTipProtocolo() != null
				&& tippregprotoc.getTipProtocolo().getTpestandar() != null) {
			where.append(" AND t2.TPESTANDAR = ?");
			params.add(tippregprotoc.getTipProtocolo().getTpestandar());
		}
		if (tippregprotoc != null && tippregprotoc.getTrnrtipp() != null) {
			where.append(" AND t1.TRNRTIPP = ?");
			params.add(tippregprotoc.getTrnrtipp());
		}
		if (tippregprotoc != null && tippregprotoc.getTrcotipp() != null) {
			where.append(" AND t1.TRCOTIPP = ?");
			params.add(tippregprotoc.getTrcotipp());
		}
		if (tippregprotoc != null && tippregprotoc.getTrdetipp() != null) {
			where.append(" AND t1.TRDETIPP = ?");
			params.add(tippregprotoc.getTrdetipp());
		}
		if (tippregprotoc != null && tippregprotoc.getTrcotti() != null) {
			where.append(" AND t1.TRCOTTI = ?");
			params.add(tippregprotoc.getTrcotti());
		}
		if (tippregprotoc != null && tippregprotoc.getTrinti() != null) {
			where.append(" AND t1.TRINTI = ?");
			params.add(tippregprotoc.getTrinti());
		}
		if (tippregprotoc != null && tippregprotoc.getTrinre() != null) {
			where.append(" AND t1.TRINRE = ?");
			params.add(tippregprotoc.getTrinre());
		}
		if (tippregprotoc != null && tippregprotoc.getTrrees() != null) {
			where.append(" AND t1.TRREES = ?");
			params.add(tippregprotoc.getTrrees());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the TipPregProtoc entity
	 * 
	 * @param tippregprotoc
	 *            TipPregProtoc Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(TipPregProtoc tippregprotoc, Boolean startsWith) {

		StringBuilder where = new StringBuilder(TipPregProtocDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (tippregprotoc != null && tippregprotoc.getTrcodigo() != null) {
			where.append(" AND UPPER(t1.TRCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tippregprotoc.getTrcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + tippregprotoc.getTrcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.TRCODIGO IS NOT NULL");
		}
		if (tippregprotoc != null && tippregprotoc.getTipProtocolo() != null
				&& tippregprotoc.getTipProtocolo().getTpcodigo() != null) {
			where.append(" AND t2.TPCODIGO = ?");
			params.add(tippregprotoc.getTipProtocolo().getTpcodigo());
		}
		if (tippregprotoc != null && tippregprotoc.getTipProtocolo() != null
				&& tippregprotoc.getTipProtocolo().getCampanha() != null
				&& tippregprotoc.getTipProtocolo().getCampanha().getCmcodigo() != null) {
			where.append(" AND UPPER(t2.TPCOCM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tippregprotoc.getTipProtocolo().getCampanha().getCmcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + tippregprotoc.getTipProtocolo().getCampanha().getCmcodigo().toUpperCase() + "%");
			}
			where.append(" AND t2.TPCOCM IS NOT NULL");
		}
		if (tippregprotoc != null && tippregprotoc.getTipProtocolo() != null
				&& tippregprotoc.getTipProtocolo().getTpnombre() != null) {
			where.append(" AND UPPER(t2.TPNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tippregprotoc.getTipProtocolo().getTpnombre().toUpperCase() + "%");
			} else {
				params.add("%" + tippregprotoc.getTipProtocolo().getTpnombre().toUpperCase() + "%");
			}
			where.append(" AND t2.TPNOMBRE IS NOT NULL");
		}
		if (tippregprotoc != null && tippregprotoc.getTipProtocolo() != null
				&& tippregprotoc.getTipProtocolo().getTpcotmo() != null) {
			where.append(" AND UPPER(t2.TPCOTMO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tippregprotoc.getTipProtocolo().getTpcotmo().toUpperCase() + "%");
			} else {
				params.add("%" + tippregprotoc.getTipProtocolo().getTpcotmo().toUpperCase() + "%");
			}
			where.append(" AND t2.TPCOTMO IS NOT NULL");
		}
		if (tippregprotoc != null && tippregprotoc.getTipProtocolo() != null
				&& tippregprotoc.getTipProtocolo().getTpestandar() != null) {
			where.append(" AND UPPER(t2.TPESTANDAR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tippregprotoc.getTipProtocolo().getTpestandar().toUpperCase() + "%");
			} else {
				params.add("%" + tippregprotoc.getTipProtocolo().getTpestandar().toUpperCase() + "%");
			}
			where.append(" AND t2.TPESTANDAR IS NOT NULL");
		}
		if (tippregprotoc != null && tippregprotoc.getTrnrtipp() != null) {
			where.append(" AND t1.TRNRTIPP = ?");
			params.add(tippregprotoc.getTrnrtipp());
		}
		if (tippregprotoc != null && tippregprotoc.getTrcotipp() != null) {
			where.append(" AND UPPER(t1.TRCOTIPP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tippregprotoc.getTrcotipp().toUpperCase() + "%");
			} else {
				params.add("%" + tippregprotoc.getTrcotipp().toUpperCase() + "%");
			}
			where.append(" AND t1.TRCOTIPP IS NOT NULL");
		}
		if (tippregprotoc != null && tippregprotoc.getTrdetipp() != null) {
			where.append(" AND UPPER(t1.TRDETIPP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tippregprotoc.getTrdetipp().toUpperCase() + "%");
			} else {
				params.add("%" + tippregprotoc.getTrdetipp().toUpperCase() + "%");
			}
			where.append(" AND t1.TRDETIPP IS NOT NULL");
		}
		if (tippregprotoc != null && tippregprotoc.getTrcotti() != null) {
			where.append(" AND UPPER(t1.TRCOTTI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tippregprotoc.getTrcotti().toUpperCase() + "%");
			} else {
				params.add("%" + tippregprotoc.getTrcotti().toUpperCase() + "%");
			}
			where.append(" AND t1.TRCOTTI IS NOT NULL");
		}
		if (tippregprotoc != null && tippregprotoc.getTrinti() != null) {
			where.append(" AND UPPER(t1.TRINTI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tippregprotoc.getTrinti().toUpperCase() + "%");
			} else {
				params.add("%" + tippregprotoc.getTrinti().toUpperCase() + "%");
			}
			where.append(" AND t1.TRINTI IS NOT NULL");
		}
		if (tippregprotoc != null && tippregprotoc.getTrinre() != null) {
			where.append(" AND UPPER(t1.TRINRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tippregprotoc.getTrinre().toUpperCase() + "%");
			} else {
				params.add("%" + tippregprotoc.getTrinre().toUpperCase() + "%");
			}
			where.append(" AND t1.TRINRE IS NOT NULL");
		}
		if (tippregprotoc != null && tippregprotoc.getTrrees() != null) {
			where.append(" AND UPPER(t1.TRREES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tippregprotoc.getTrrees().toUpperCase() + "%");
			} else {
				params.add("%" + tippregprotoc.getTrrees().toUpperCase() + "%");
			}
			where.append(" AND t1.TRREES IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Inserts a single row in the TipPregProtoc table.
	 * 
	 * @param tipProtocolo
	 *            TipProtocolo
	 * @param codTipoProtocoloAlta
	 *            String
	 */
	public void addAllTipPregProtoc(TipProtocolo tipProtocolo, String codTipoProtocoloAlta) {

		String query = "INSERT INTO TIP_PREG_PROTOC( TRCODIGO,TRCOTP,TRCOTTI,TRNRTIPP,TRCOTIPP,TRDETIPP,TRINTI,TRINRE,TRREES,TREXCLUIROBI) SELECT TRCODIGO,?,TRCOTTI,TRNRTIPP,TRCOTIPP,TRDETIPP,TRINTI,TRINRE,TRREES,TREXCLUIROBI FROM ADJUNTARTIP_PREG_PROTOC WHERE TRCOTP = ? ";
		this.jdbcTemplate.update(query, tipProtocolo.getTpcodigo(), codTipoProtocoloAlta);
	}

	/**
	 * Deletes a single row in the TipPregProtoc table.
	 * 
	 * @param tipProtocolo
	 *            TipProtocolo
	 */
	public void removeAllTipPregProtoc(TipProtocolo tipProtocolo) {
		String query = "DELETE  FROM TIP_PREG_PROTOC " + " WHERE TRCOTP=?";

		this.jdbcTemplate.update(query, tipProtocolo.getTpcodigo());
	}

	/**
	 * Counts rows in the TipPregProtoc table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long preguntasCount(Actuacion actuacion) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM TIP_PREG_PROTOC t1, ACTUACION, CAMPANHA_TIPOPROTOCOLO "
						+ " WHERE ATCOCM = CMCODIGO AND TPCODIGO = TRCOTP AND TRINTI = 'N' AND TRINRE = 'S' AND ATCODIGO = ?");

		List<Object> params = new ArrayList<Object>();
		params.add(actuacion.getAtcodigo().toUpperCase());

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Counts rows in the TipPregProtoc table.
	 * 
	 * @param protocol
	 *            Protocol
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long preguntasProtocoloCount(Protocol protocol) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM TIP_PREG_PROTOC t1, ACTUACION, CAMPANHA_TIPOPROTOCOLO "
						+ " WHERE ATCOCM = CMCODIGO AND TPCODIGO = TRCOTP AND TRINTI = 'N' AND TRINRE = 'S' AND ATCODIGO = ? AND TPCODIGO = ? ");

		List<Object> params = new ArrayList<Object>();
		params.add(protocol.getPtcoat());
		params.add(protocol.getPtcodigo());

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Counts rows in the TipPregProtoc table.
	 * 
	 * @param protocol
	 *            Protocol
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long preguntasProtocoloInspeccionCount(Protocol protocol) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM TIP_PREG_PROTOC t1, PROTOCOLO_INSPECCION "
				+ " WHERE TPCODIGO = TRCOTP AND TRINTI = 'N' AND TRINRE = 'S' AND ATCODIGO = ? AND TPCODIGO = ? ");

		List<Object> params = new ArrayList<Object>();
		params.add(protocol.getPtcoat());
		params.add(protocol.getPtcodigo());

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
}
