package com.ejie.y41b.dao;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Actuacion;
import com.ejie.y41b.model.Protocol;
import com.ejie.y41b.model.TipPregProtoc;
import com.ejie.y41b.model.TipProtocolo;

/**
 * TipPregProtocDao  
 * 
 *  
 */

public interface TipPregProtocDao {

	/**
	 * Inserts a single row in the TipPregProtoc table.
	 * 
	 * @param tippregprotoc
	 *            TipPregProtoc
	 * @return TipPregProtoc
	 */
	TipPregProtoc add(TipPregProtoc tippregprotoc);

	/**
	 * Updates a single row in the TipPregProtoc table.
	 * 
	 * @param tippregprotoc
	 *            TipPregProtoc
	 * @return TipPregProtoc
	 */
	TipPregProtoc update(TipPregProtoc tippregprotoc);

	/**
	 * Finds a single row in the TipPregProtoc table.
	 * 
	 * @param tippregprotoc
	 *            TipPregProtoc
	 * @return TipPregProtoc
	 */
	TipPregProtoc find(TipPregProtoc tippregprotoc);

	/**
	 * Deletes a single row in the TipPregProtoc table.
	 * 
	 * @param tippregprotoc
	 *            TipPregProtoc
	 * @return
	 */
	void remove(TipPregProtoc tippregprotoc);

	/**
	 * Finds a List of rows in the TipPregProtoc table.
	 * 
	 * @param tippregprotoc
	 *            TipPregProtoc
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<TipPregProtoc> findAll(TipPregProtoc tippregprotoc, Pagination pagination);

	/**
	 * Counts rows in the TipPregProtoc table.
	 * 
	 * @param tippregprotoc
	 *            TipPregProtoc
	 * @return Long
	 */
	Long findAllCount(TipPregProtoc tippregprotoc);

	/**
	 * Finds a List of rows in the TipPregProtoc table.
	 * 
	 * @param tippregprotoc
	 *            TipPregProtoc
	 * @return List
	 */
	public List<TipPregProtoc> findAllProtocoloOrdenado(TipPregProtoc tippregprotoc);

	/**
	 * Finds rows in the TipPregProtoc table using like.
	 * 
	 * @param tippregprotoc
	 *            TipPregProtoc
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<TipPregProtoc> findAllLike(TipPregProtoc tippregprotoc, Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the TipPregProtoc table using like.
	 * 
	 * @param tippregprotoc
	 *            TipPregProtoc
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(TipPregProtoc tippregprotoc, Boolean startsWith);

	/**
	 * Inserts a single row in the TipPregProtoc table.
	 * 
	 * @param tipProtocolo
	 *            TipProtocolo
	 * @param codTipoProtocoloAlta
	 *            String
	 */
	public void addAllTipPregProtoc(TipProtocolo tipProtocolo, String codTipoProtocoloAlta);

	/**
	 * Deletes a single row in the TipPregProtoc table.
	 * 
	 * @param tipProtocolo
	 *            TipProtocolo
	 */
	public void removeAllTipPregProtoc(TipProtocolo tipProtocolo);

	/**
	 * Counts rows in the TipPregProtoc table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Long
	 */
	public Long preguntasCount(Actuacion actuacion);

	/**
	 * Counts rows in the TipPregProtoc table.
	 * 
	 * @param protocol
	 *            Protocol
	 * @return Long
	 */
	public Long preguntasProtocoloCount(Protocol protocol);

	/**
	 * Counts rows in the TipPregProtoc table.
	 * 
	 * @param protocol
	 *            Protocol
	 * @return Long
	 */
	public Long preguntasProtocoloInspeccionCount(Protocol protocol);
}
