package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Tctipres;

/**
 * TctipresDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class TctipresDaoImpl implements TctipresDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Tctipres> rwMap = new RowMapper<Tctipres>() {
		public Tctipres mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Tctipres(resultSet.getString("TTRCODIGO"),
					resultSet.getString("TTRNOMBRE"),
					resultSet.getString("TTRNOMBREEU"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Tctipres table.
	 * 
	 * @param tctipres
	 *            Pagination
	 * @return Tctipres
	 */
	public Tctipres add(Tctipres tctipres) {
		String query = "INSERT INTO TCTIPRES (TTRCODIGO, TTRNOMBRE, TTRNOMBREEU) VALUES (?,?,?)";
		this.jdbcTemplate.update(query, tctipres.getTtrcodigo(),
				tctipres.getTtrnombre(), tctipres.getTtrnombreeu());
		return tctipres;
	}

	/**
	 * Updates a single row in the Tctipres table.
	 * 
	 * @param tctipres
	 *            Pagination
	 * @return Tctipres
	 */
	public Tctipres update(Tctipres tctipres) {
		String query = "UPDATE TCTIPRES SET TTRNOMBRE=?, TTRNOMBREEU=? WHERE TTRCODIGO=?";
		this.jdbcTemplate.update(query, tctipres.getTtrnombre(),
				tctipres.getTtrnombreeu(), tctipres.getTtrcodigo());
		return tctipres;
	}

	/**
	 * Finds a single row in the Tctipres table.
	 * 
	 * @param tctipres
	 *            Pagination
	 * @return Tctipres
	 */
	@Transactional(readOnly = true)
	public Tctipres find(Tctipres tctipres) {
		String query = "SELECT t1.TTRCODIGO TTRCODIGO, t1.TTRNOMBRE TTRNOMBRE, t1.TTRNOMBREEU TTRNOMBREEU FROM TCTIPRES t1  WHERE t1.TTRCODIGO = ?  ";

		List<Tctipres> tctipresList = this.jdbcTemplate.query(query,
				this.rwMap, tctipres.getTtrcodigo());
		return (Tctipres) DataAccessUtils.uniqueResult(tctipresList);
	}

	/**
	 * Removes a single row in the Tctipres table.
	 * 
	 * @param tctipres
	 *            Pagination
	 * @return
	 */
	public void remove(Tctipres tctipres) {
		String query = "DELETE FROM TCTIPRES WHERE TTRCODIGO=?";
		this.jdbcTemplate.update(query, tctipres.getTtrcodigo());
	}

	/**
	 * Finds a List of rows in the Tctipres table.
	 * 
	 * @param tctipres
	 *            Tctipres
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Tctipres> findAll(Tctipres tctipres, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.TTRCODIGO TTRCODIGO,t1.TTRNOMBRE TTRNOMBRE,NVL(t1.TTRNOMBREEU,t1.TTRNOMBRE) TTRNOMBREEU ");
		query.append("FROM TCTIPRES t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(tctipres);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Tctipres>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Tctipres table.
	 * 
	 * @param tctipres
	 *            Tctipres
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Tctipres tctipres) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM TCTIPRES t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(tctipres);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Tctipres table using like.
	 * 
	 * @param tctipres
	 *            Tctipres
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Tctipres> findAllLike(Tctipres tctipres, Pagination pagination,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.TTRCODIGO TTRCODIGO,t1.TTRNOMBRE TTRNOMBRE,NVL(t1.TTRNOMBREEU,t1.TTRNOMBRE) TTRNOMBREEU ");
		query.append("FROM TCTIPRES t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(tctipres, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Tctipres>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Tctipres table using like.
	 * 
	 * @param tctipres
	 *            Tctipres
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Tctipres tctipres, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM TCTIPRES t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(tctipres, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Tctipres entity
	 * 
	 * @param tctipres
	 *            Tctipres Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Tctipres tctipres) {

		StringBuilder where = new StringBuilder(
				TctipresDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (tctipres != null && tctipres.getTtrcodigo() != null) {
			where.append(" AND t1.TTRCODIGO = ?");
			params.add(tctipres.getTtrcodigo());
		}
		if (tctipres != null && tctipres.getTtrnombre() != null) {
			where.append(" AND t1.TTRNOMBRE = ?");
			params.add(tctipres.getTtrnombre());
		}
		if (tctipres != null && tctipres.getTtrnombreeu() != null) {
			where.append(" AND t1.TTRNOMBREEU = ?");
			params.add(tctipres.getTtrnombreeu());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Tctipres entity
	 * 
	 * @param tctipres
	 *            Tctipres Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Tctipres tctipres, Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				TctipresDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (tctipres != null && tctipres.getTtrcodigo() != null) {
			where.append(" AND UPPER(t1.TTRCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tctipres.getTtrcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + tctipres.getTtrcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.TTRCODIGO IS NOT NULL");
		}
		if (tctipres != null && tctipres.getTtrnombre() != null) {
			where.append(" AND UPPER(t1.TTRNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tctipres.getTtrnombre().toUpperCase() + "%");
			} else {
				params.add("%" + tctipres.getTtrnombre().toUpperCase() + "%");
			}
			where.append(" AND t1.TTRNOMBRE IS NOT NULL");
		}
		if (tctipres != null && tctipres.getTtrnombreeu() != null) {
			where.append(" AND UPPER(t1.TTRNOMBREEU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tctipres.getTtrnombreeu().toUpperCase() + "%");
			} else {
				params.add("%" + tctipres.getTtrnombreeu().toUpperCase() + "%");
			}
			where.append(" AND t1.TTRNOMBREEU IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
