package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.Tctipres;

/**
 * TctipresDao  
 *  
 */

public interface TctipresDao {
    
    /**
     * Inserts a single row in the Tctipres table.
     *
     * @param tctipres Tctipres
     * @return Tctipres
     */
    Tctipres add(Tctipres tctipres);

    /**
     * Updates a single row in the Tctipres table.
     *
     * @param tctipres Tctipres
     * @return Tctipres
     */
    Tctipres update(Tctipres tctipres);

    /**
     * Finds a single row in the Tctipres table.
     *
     * @param tctipres Tctipres
     * @return Tctipres
     */
    Tctipres find(Tctipres tctipres);

    /**
     * Deletes a single row in the Tctipres table.
     *
     * @param tctipres Tctipres
     * @return 
     */
    void remove(Tctipres tctipres);

    /**
     * Finds a List of rows in the Tctipres table.
     *
     * @param tctipres Tctipres
     * @param pagination Pagination
     * @return List
     */
    List<Tctipres> findAll(Tctipres tctipres, Pagination pagination);

    /**
     * Counts rows in the Tctipres table.
     *
     * @param tctipres Tctipres
     * @return Long
     */
    Long findAllCount(Tctipres tctipres);
	
	/**
     * Finds rows in the Tctipres table using like.
     *
     * @param tctipres Tctipres
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List
     */
	List<Tctipres> findAllLike(Tctipres tctipres, Pagination pagination, Boolean startsWith);
	
    /**
     * Counts rows in the Tctipres table using like.
     *
     * @param tctipres Tctipres
     * @param startsWith Boolean
     * @return Long
     */
    Long findAllLikeCount(Tctipres tctipres, Boolean startsWith);
}

