package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Tctiacre;

/**
 * TctiacreDaoImpl  
 *  
 */
 
@Repository
@Transactional
public class TctiacreDaoImpl implements TctiacreDao {
    private JdbcTemplate jdbcTemplate;
	private RowMapper<Tctiacre> rwMap = new RowMapper<Tctiacre>() {
		public Tctiacre mapRow(ResultSet resultSet, int rowNum) throws SQLException {
           return new Tctiacre(
               resultSet.getString("TARCODIGO"), resultSet.getString("TARNOMBRE")
           ); } } ;

	/**
     * Method use to set the datasource.
     *
     * @param dataSource DataSource
     * @return
     */
    @Resource
    public void setDataSource(DataSource dataSource) {
    	this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    /**
     * Inserts a single row in the Tctiacre table.
     *
     * @param tctiacre Pagination
     * @return Tctiacre
     */
	public Tctiacre add(Tctiacre tctiacre) {
    	String query = "INSERT INTO TCTIACRE (TARCODIGO, TARNOMBRE) VALUES (?,?)";
		this.jdbcTemplate.update(query, tctiacre.getTarcodigo(), tctiacre.getTarnombre());
		return tctiacre;
	}

    /**
     * Updates a single row in the Tctiacre table.
     *
     * @param tctiacre Pagination
     * @return Tctiacre
     */
    public Tctiacre update(Tctiacre tctiacre) {
		String query = "UPDATE TCTIACRE SET TARNOMBRE=? WHERE TARCODIGO=?";
		this.jdbcTemplate.update(query, tctiacre.getTarnombre(), tctiacre.getTarcodigo());
		return tctiacre;
	}

    /**
     * Finds a single row in the Tctiacre table.
     *
     * @param tctiacre Pagination
     * @return Tctiacre
     */
    @Transactional (readOnly = true)
    public Tctiacre find(Tctiacre tctiacre) {
		String query = "SELECT t1.TARCODIGO TARCODIGO, t1.TARNOMBRE TARNOMBRE FROM TCTIACRE t1  WHERE t1.TARCODIGO = ?  ";
		
		List<Tctiacre> tctiacreList = this.jdbcTemplate.query(query, this.rwMap, tctiacre.getTarcodigo());
		return (Tctiacre) DataAccessUtils.uniqueResult(tctiacreList);
    }

    /**
     * Removes a single row in the Tctiacre table.
     *
     * @param tctiacre Pagination
     * @return
     */
    public void remove(Tctiacre tctiacre) {
		String query = "DELETE FROM TCTIACRE WHERE TARCODIGO=?";
		this.jdbcTemplate.update(query, tctiacre.getTarcodigo());
    }
    
   /**
    * Finds a List of rows in the Tctiacre table.
    * 
    * @param tctiacre Tctiacre
    * @param pagination Pagination
    * @return List 
    */
	@Transactional (readOnly = true)
    public List<Tctiacre> findAll(Tctiacre tctiacre, Pagination pagination) {
		StringBuilder query = new StringBuilder("SELECT  t1.TARCODIGO TARCODIGO,t1.TARNOMBRE TARNOMBRE "); 
		query.append("FROM TCTIACRE t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(tctiacre); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		
		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		
		return (List<Tctiacre>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}
	
    /**
     * Counts rows in the Tctiacre table.
     * 
     * @param tctiacre Tctiacre
     * @return Long
     */
    @Transactional (readOnly = true)
    public Long findAllCount(Tctiacre tctiacre) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM TCTIACRE t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(tctiacre); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);		
		
		List<?> params = (List<?>) mapaWhere.get("params");
		
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	
	/**
	 * Finds rows in the Tctiacre table using like.
     * 
     * @param tctiacre Tctiacre
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List 
     */
	@Transactional (readOnly = true)
    public List<Tctiacre> findAllLike(Tctiacre tctiacre, Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT  t1.TARCODIGO TARCODIGO,t1.TARNOMBRE TARNOMBRE "); 
        query.append("FROM TCTIACRE t1 ");
      	
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(tctiacre,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		
		return (List<Tctiacre>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}
	
	/**
	 * Counts rows in the Tctiacre table using like.
     * 
     * @param tctiacre Tctiacre
     * @param startsWith Boolean
     * @return Long 
     */
	@Transactional (readOnly = true)
    public Long findAllLikeCount(Tctiacre tctiacre, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM TCTIACRE t1 ");

		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(tctiacre,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	
	/**
	 * Returns a map with the needed value to create the conditions to filter by 
	 * the Tctiacre entity 
	 * 
	 * @param tctiacre Tctiacre
	 *            Bean with the criteria values to filter by.
	 * @return Map created with two keys
	 *         key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap (Tctiacre tctiacre){
		
		StringBuilder where = new StringBuilder(TctiacreDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (tctiacre  != null  && tctiacre.getTarcodigo() != null ) {
			where.append(" AND t1.TARCODIGO = ?");
			params.add(tctiacre.getTarcodigo());
		}
		if (tctiacre  != null  && tctiacre.getTarnombre() != null ) {
			where.append(" AND t1.TARNOMBRE = ?");
			params.add(tctiacre.getTarnombre());
		}

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		
		return mapWhere;		
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA
	
	/**
	 * Returns a map with the needed value to create the conditions to filter by  
	 * the Tctiacre entity 
	 * 
	 * @param tctiacre Tctiacre
	 *            Bean with the criteria values to filter by.
     * @param startsWith Boolean	 
	 * @return Map created with two keys
	 *         key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap (Tctiacre tctiacre, Boolean startsWith){
		
		StringBuilder where = new StringBuilder(TctiacreDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (tctiacre  != null  && tctiacre.getTarcodigo() != null ) {
			where.append(" AND UPPER(t1.TARCODIGO) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(tctiacre.getTarcodigo().toUpperCase() +"%");
			}else{
				params.add("%"+tctiacre.getTarcodigo().toUpperCase() +"%");
			}
			where.append(" AND t1.TARCODIGO IS NOT NULL");
	     }			
		if (tctiacre  != null  && tctiacre.getTarnombre() != null ) {
			where.append(" AND UPPER(t1.TARNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(tctiacre.getTarnombre().toUpperCase() +"%");
			}else{
				params.add("%"+tctiacre.getTarnombre().toUpperCase() +"%");
			}
			where.append(" AND t1.TARNOMBRE IS NOT NULL");
	     }			

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		
		return mapWhere;		
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA
	
	/**
	 * StringBuilder initilization value
	 */
	 public static final int STRING_BUILDER_INIT = 4096;}

