package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Tcmotina;

/**
 * TcmotinaDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class TcmotinaDaoImpl implements TcmotinaDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Tcmotina> rwMap = new RowMapper<Tcmotina>() {
		public Tcmotina mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Tcmotina(resultSet.getString("T5CODIGO"),
					resultSet.getString("T5NOMBRE"),
					resultSet.getString("T5NOMBREEU"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Tcmotina table.
	 * 
	 * @param tcmotina
	 *            Pagination
	 * @return Tcmotina
	 */
	public Tcmotina add(Tcmotina tcmotina) {
		String query = "INSERT INTO TCMOTINA (T5CODIGO, T5NOMBRE,T5NOMBREEU,T5Y41B) VALUES (?,?)";
		this.jdbcTemplate.update(query, tcmotina.getT5codigo(),
				tcmotina.getT5nombre(), tcmotina.getT5nombreeu(),
				tcmotina.getT5y41b());
		return tcmotina;
	}

	/**
	 * Updates a single row in the Tcmotina table.
	 * 
	 * @param tcmotina
	 *            Pagination
	 * @return Tcmotina
	 */
	public Tcmotina update(Tcmotina tcmotina) {
		String query = "UPDATE TCMOTINA SET T5NOMBRE=?,T5NOMBREEU=?,T5Y41B=?  WHERE T5CODIGO=?";
		this.jdbcTemplate.update(query, tcmotina.getT5nombre(),
				tcmotina.getT5nombreeu(), tcmotina.getT5y41b(),
				tcmotina.getT5codigo());
		return tcmotina;
	}

	/**
	 * Finds a single row in the Tcmotina table.
	 * 
	 * @param tcmotina
	 *            Pagination
	 * @return Tcmotina
	 */
	@Transactional(readOnly = true)
	public Tcmotina find(Tcmotina tcmotina) {
		String query = "SELECT t1.T5CODIGO T5CODIGO, t1.T5NOMBRE T5NOMBRE,t1.T5NOMBREEU T5NOMBREEU  FROM TCMOTINA t1  WHERE t1.T5CODIGO = ?  ";

		List<Tcmotina> tcmotinaList = this.jdbcTemplate.query(query,
				this.rwMap, tcmotina.getT5codigo());
		return (Tcmotina) DataAccessUtils.uniqueResult(tcmotinaList);
	}

	/**
	 * Removes a single row in the Tcmotina table.
	 * 
	 * @param tcmotina
	 *            Pagination
	 * @return
	 */
	public void remove(Tcmotina tcmotina) {
		String query = "DELETE FROM TCMOTINA WHERE T5CODIGO=?";
		this.jdbcTemplate.update(query, tcmotina.getT5codigo());
	}

	/**
	 * Finds a List of rows in the Tcmotina table.
	 * 
	 * @param tcmotina
	 *            Tcmotina
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Tcmotina> findAll(Tcmotina tcmotina, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.T5CODIGO T5CODIGO,t1.T5NOMBRE T5NOMBRE,t1.T5NOMBREEU T5NOMBREEU  ");
		query.append("FROM TCMOTINA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(tcmotina);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Tcmotina>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Tcmotina table.
	 * 
	 * @param tcmotina
	 *            Tcmotina
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Tcmotina tcmotina) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM TCMOTINA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(tcmotina);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Tcmotina table using like.
	 * 
	 * @param tcmotina
	 *            Tcmotina
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Tcmotina> findAllLike(Tcmotina tcmotina, Pagination pagination,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.T5CODIGO T5CODIGO,t1.T5NOMBRE T5NOMBRE,t1.T5NOMBREEU T5NOMBREEU ");
		query.append("FROM TCMOTINA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(tcmotina, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Tcmotina>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Tcmotina table using like.
	 * 
	 * @param tcmotina
	 *            Tcmotina
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Tcmotina tcmotina, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM TCMOTINA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(tcmotina, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Tcmotina entity
	 * 
	 * @param tcmotina
	 *            Tcmotina Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Tcmotina tcmotina) {

		StringBuilder where = new StringBuilder(
				TcmotinaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (tcmotina != null && tcmotina.getT5codigo() != null) {
			where.append(" AND t1.T5CODIGO = ?");
			params.add(tcmotina.getT5codigo());
		}
		if (tcmotina != null && tcmotina.getT5nombre() != null) {
			where.append(" AND t1.T5NOMBRE = ?");
			params.add(tcmotina.getT5nombre());
		}
		if (tcmotina != null && tcmotina.getT5nombreeu() != null) {
			where.append(" AND t1.T5NOMBREEU = ?");
			params.add(tcmotina.getT5nombreeu());
		}
		if (tcmotina != null && tcmotina.getT5y41b() != null) {
			where.append(" AND t1.T5Y41B = ?");
			params.add(tcmotina.getT5y41b());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Tcmotina entity
	 * 
	 * @param tcmotina
	 *            Tcmotina Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Tcmotina tcmotina, Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				TcmotinaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (tcmotina != null && tcmotina.getT5codigo() != null) {
			where.append(" AND UPPER(t1.T5CODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tcmotina.getT5codigo().toUpperCase() + "%");
			} else {
				params.add("%" + tcmotina.getT5codigo().toUpperCase() + "%");
			}
			where.append(" AND t1.T5CODIGO IS NOT NULL");
		}
		if (tcmotina != null && tcmotina.getT5nombre() != null) {
			where.append(" AND UPPER(t1.T5NOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tcmotina.getT5nombre().toUpperCase() + "%");
			} else {
				params.add("%" + tcmotina.getT5nombre().toUpperCase() + "%");
			}
			where.append(" AND t1.T5NOMBRE IS NOT NULL");
		}
		if (tcmotina != null && tcmotina.getT5nombreeu() != null) {
			where.append(" AND UPPER(t1.T5NOMBREEU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tcmotina.getT5nombreeu().toUpperCase() + "%");
			} else {
				params.add("%" + tcmotina.getT5nombreeu().toUpperCase() + "%");
			}
			where.append(" AND t1.T5NOMBREEU IS NOT NULL");
		}
		if (tcmotina != null && tcmotina.getT5y41b() != null) {
			where.append(" AND t1.T5Y41B = ?");
			params.add(tcmotina.getT5y41b());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
