package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.Tcmotina;

/**
 * TcmotinaDao  
 *  
 */

public interface TcmotinaDao {
    
    /**
     * Inserts a single row in the Tcmotina table.
     *
     * @param tcmotina Tcmotina
     * @return Tcmotina
     */
    Tcmotina add(Tcmotina tcmotina);

    /**
     * Updates a single row in the Tcmotina table.
     *
     * @param tcmotina Tcmotina
     * @return Tcmotina
     */
    Tcmotina update(Tcmotina tcmotina);

    /**
     * Finds a single row in the Tcmotina table.
     *
     * @param tcmotina Tcmotina
     * @return Tcmotina
     */
    Tcmotina find(Tcmotina tcmotina);

    /**
     * Deletes a single row in the Tcmotina table.
     *
     * @param tcmotina Tcmotina
     * @return 
     */
    void remove(Tcmotina tcmotina);

    /**
     * Finds a List of rows in the Tcmotina table.
     *
     * @param tcmotina Tcmotina
     * @param pagination Pagination
     * @return List
     */
    List<Tcmotina> findAll(Tcmotina tcmotina, Pagination pagination);

    /**
     * Counts rows in the Tcmotina table.
     *
     * @param tcmotina Tcmotina
     * @return Long
     */
    Long findAllCount(Tcmotina tcmotina);
	
	/**
     * Finds rows in the Tcmotina table using like.
     *
     * @param tcmotina Tcmotina
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List
     */
	List<Tcmotina> findAllLike(Tcmotina tcmotina, Pagination pagination, Boolean startsWith);
	
    /**
     * Counts rows in the Tcmotina table using like.
     *
     * @param tcmotina Tcmotina
     * @param startsWith Boolean
     * @return Long
     */
    Long findAllLikeCount(Tcmotina tcmotina, Boolean startsWith);
}

