package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Tclugaud;
import com.ejie.y41b.utils.Y41bUtils;

/**
 * TclugaudDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class TclugaudDaoImpl implements TclugaudDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Tclugaud> rwMap = new RowMapper<Tclugaud>() {
		public Tclugaud mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Tclugaud(resultSet.getString("T4CODIGO"),
					resultSet.getString("T4NOMBRE"),
					resultSet.getString("T4NOMBREEU"),
					resultSet.getString("T4NORAPROVINCIAID"),
					resultSet.getString("T4NORAMUNICIPIOID"),
					resultSet.getString("T4NORALOCALIDADID"),
					resultSet.getString("T4NORACALLEID"),
					resultSet.getString("T4NORACPID"),
					resultSet.getString("T4NORAPORTALID"),
					resultSet.getString("T4NOMBREPISO"),
					resultSet.getString("T4NODIR"),
					resultSet.getDate("T4FECBAJA"),
					resultSet.getDate("T4FECALTA"),
					resultSet.getDate("T4FECMODIF"),
					resultSet.getString("T4USUALTA"),
					resultSet.getString("T4USUMODIF"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Tclugaud table.
	 * 
	 * @param tclugaud
	 *            Pagination
	 * @return Tclugaud
	 */
	public Tclugaud add(Tclugaud tclugaud) {
		String query = "INSERT INTO TCLUGAUD (T4CODIGO, T4NOMBRE, T4NOMBREEU, T4NORA_PROVINCIA_ID, T4NORA_MUNICIPIO_ID, T4NORA_LOCALIDAD_ID, T4NORA_CALLE_ID, T4NORA_CP_ID, T4NORA_PORTAL_ID, T4NOMBRE_PISO, T4NODIR, T4FECBAJA, T4FECALTA, T4FECMODIF, T4USUALTA, T4USUMODIF) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, tclugaud.getT4codigo(),
				tclugaud.getT4nombre(), tclugaud.getT4nombreeu(),
				tclugaud.getT4noraProvinciaId(),
				tclugaud.getT4noraMunicipioId(),
				tclugaud.getT4noraLocalidadId(), tclugaud.getT4noraCalleId(),
				tclugaud.getT4noraCpId(), tclugaud.getT4noraPortalId(),
				tclugaud.getT4nombrePiso(), tclugaud.getT4nodir(),
				tclugaud.getT4fecbaja(), tclugaud.getT4fecalta(),
				tclugaud.getT4fecmodif(), tclugaud.getT4usualta(),
				tclugaud.getT4usumodif());
		return tclugaud;
	}

	/**
	 * Updates a single row in the Tclugaud table.
	 * 
	 * @param tclugaud
	 *            Pagination
	 * @return Tclugaud
	 */
	public Tclugaud update(Tclugaud tclugaud) {
		String query = "UPDATE TCLUGAUD SET T4NOMBRE=?, T4NOMBREEU=?, T4NORA_PROVINCIA_ID=?, T4NORA_MUNICIPIO_ID=?, T4NORA_LOCALIDAD_ID=?, T4NORA_CALLE_ID=?, T4NORA_CP_ID=?, T4NORA_PORTAL_ID=?, T4NOMBRE_PISO=?, T4NODIR=?, T4FECBAJA=?, T4FECALTA=?, T4FECMODIF=?, T4USUALTA=?, T4USUMODIF=? WHERE T4CODIGO=?";
		this.jdbcTemplate.update(query, tclugaud.getT4nombre(),
				tclugaud.getT4nombreeu(), tclugaud.getT4noraProvinciaId(),
				tclugaud.getT4noraMunicipioId(),
				tclugaud.getT4noraLocalidadId(), tclugaud.getT4noraCalleId(),
				tclugaud.getT4noraCpId(), tclugaud.getT4noraPortalId(),
				tclugaud.getT4nombrePiso(), tclugaud.getT4nodir(),
				tclugaud.getT4fecbaja(), tclugaud.getT4fecalta(),
				tclugaud.getT4fecmodif(), tclugaud.getT4usualta(),
				tclugaud.getT4usumodif(), tclugaud.getT4codigo());
		return tclugaud;
	}

	/**
	 * Finds a single row in the Tclugaud table.
	 * 
	 * @param tclugaud
	 *            Pagination
	 * @return Tclugaud
	 */
	@Transactional(readOnly = true)
	public Tclugaud find(Tclugaud tclugaud) {
		String query = "SELECT t1.T4CODIGO T4CODIGO, t1.T4NOMBRE T4NOMBRE, t1.T4NOMBREEU T4NOMBREEU, t1.T4NORA_PROVINCIA_ID T4NORAPROVINCIAID, t1.T4NORA_MUNICIPIO_ID T4NORAMUNICIPIOID, t1.T4NORA_LOCALIDAD_ID T4NORALOCALIDADID, t1.T4NORA_CALLE_ID T4NORACALLEID, t1.T4NORA_CP_ID T4NORACPID, t1.T4NORA_PORTAL_ID T4NORAPORTALID, t1.T4NOMBRE_PISO T4NOMBREPISO, t1.T4NODIR T4NODIR, t1.T4FECBAJA T4FECBAJA, t1.T4FECALTA T4FECALTA, t1.T4FECMODIF T4FECMODIF, t1.T4USUALTA T4USUALTA, t1.T4USUMODIF T4USUMODIF FROM TCLUGAUD t1  WHERE t1.T4CODIGO = ?  ";

		List<Tclugaud> tclugaudList = this.jdbcTemplate.query(query,
				this.rwMap, tclugaud.getT4codigo());
		return (Tclugaud) DataAccessUtils.uniqueResult(tclugaudList);
	}

	/**
	 * Removes a single row in the Tclugaud table.
	 * 
	 * @param tclugaud
	 *            Pagination
	 * @return
	 */
	public void remove(Tclugaud tclugaud) {
		String query = "DELETE FROM TCLUGAUD WHERE T4CODIGO=?";
		this.jdbcTemplate.update(query, tclugaud.getT4codigo());
	}

	/**
	 * Finds a List of rows in the Tclugaud table.
	 * 
	 * @param tclugaud
	 *            Tclugaud
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Tclugaud> findAll(Tclugaud tclugaud, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT DISTINCT  t1.T4CODIGO T4CODIGO,t1.T4NOMBRE T4NOMBRE,t1.T4NOMBREEU T4NOMBREEU,t1.T4NORA_PROVINCIA_ID T4NORAPROVINCIAID,t1.T4NORA_MUNICIPIO_ID T4NORAMUNICIPIOID,t1.T4NORA_LOCALIDAD_ID T4NORALOCALIDADID,t1.T4NORA_CALLE_ID T4NORACALLEID,t1.T4NORA_CP_ID T4NORACPID,t1.T4NORA_PORTAL_ID T4NORAPORTALID,t1.T4NOMBRE_PISO T4NOMBREPISO,t1.T4NODIR T4NODIR,t1.T4FECBAJA T4FECBAJA,t1.T4FECALTA T4FECALTA,t1.T4FECMODIF T4FECMODIF,t1.T4USUALTA T4USUALTA,t1.T4USUMODIF T4USUMODIF ");
		query.append("FROM TCLUGAUD t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(tclugaud);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Tclugaud>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Tclugaud table.
	 * 
	 * @param tclugaud
	 *            Tclugaud
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Tclugaud tclugaud) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(DISTINCT T4CODIGO) FROM TCLUGAUD t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(tclugaud);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Tclugaud table using like.
	 * 
	 * @param tclugaud
	 *            Tclugaud
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Tclugaud> findAllLike(Tclugaud tclugaud, Pagination pagination,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.T4CODIGO T4CODIGO,t1.T4NOMBRE T4NOMBRE,t1.T4NOMBREEU T4NOMBREEU,t1.T4NORA_PROVINCIA_ID T4NORAPROVINCIAID,t1.T4NORA_MUNICIPIO_ID T4NORAMUNICIPIOID,t1.T4NORA_LOCALIDAD_ID T4NORALOCALIDADID,t1.T4NORA_CALLE_ID T4NORACALLEID,t1.T4NORA_CP_ID T4NORACPID,t1.T4NORA_PORTAL_ID T4NORAPORTALID,t1.T4NOMBRE_PISO T4NOMBREPISO,t1.T4NODIR T4NODIR,t1.T4FECBAJA T4FECBAJA,t1.T4FECALTA T4FECALTA,t1.T4FECMODIF T4FECMODIF,t1.T4USUALTA T4USUALTA,t1.T4USUMODIF T4USUMODIF ");
		query.append("FROM TCLUGAUD t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(tclugaud, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Tclugaud>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Tclugaud table using like.
	 * 
	 * @param tclugaud
	 *            Tclugaud
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Tclugaud tclugaud, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM TCLUGAUD t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(tclugaud, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Tclugaud entity
	 * 
	 * @param tclugaud
	 *            Tclugaud Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Tclugaud tclugaud) {

		StringBuilder where = new StringBuilder(
				TclugaudDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (tclugaud != null
				&& !Y41bUtils.esNullOCadenaVacia(tclugaud.getT4codigo())) {
			where.append(" AND TRANSLATE(UPPER(t1.T4CODIGO),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%"
					+ tclugaud.getT4codigo().toUpperCase().replaceAll("", "A")
							.replaceAll("", "E").replaceAll("", "I")
							.replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t1.T4CODIGO is not null");
		}
		if (tclugaud != null
				&& !Y41bUtils.esNullOCadenaVacia(tclugaud.getT4nombre())) {
			where.append(" AND TRANSLATE(UPPER(t1.T4NOMBRE),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%"
					+ tclugaud.getT4nombre().toUpperCase().replaceAll("", "A")
							.replaceAll("", "E").replaceAll("", "I")
							.replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t1.T4NOMBRE is not null");
		}

		if (tclugaud != null
				&& !Y41bUtils.esNullOCadenaVacia(tclugaud.getT4nombreeu())) {
			where.append(" AND TRANSLATE(UPPER(t1.T4NOMBREEU),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%"
					+ tclugaud.getT4nombreeu().toUpperCase()
							.replaceAll("", "A").replaceAll("", "E")
							.replaceAll("", "I").replaceAll("", "O")
							.replaceAll("", "U") + "%");
			where.append(" AND t1.T4NOMBREEU is not null");
		}

		if (tclugaud != null && !tclugaud.getIndIncluirBaja()) {
			where.append(" AND t1.T4FECBAJA is null ");
		}
		/*
		 * if (tclugaud != null && tclugaud.getT4noraProvinciaId() != null) {
		 * where.append(" AND t1.T4NORA_PROVINCIA_ID = ?");
		 * params.add(tclugaud.getT4noraProvinciaId()); } if (tclugaud != null
		 * && tclugaud.getT4noraMunicipioId() != null) {
		 * where.append(" AND t1.T4NORA_MUNICIPIO_ID = ?");
		 * params.add(tclugaud.getT4noraMunicipioId()); } if (tclugaud != null
		 * && tclugaud.getT4noraLocalidadId() != null) {
		 * where.append(" AND t1.T4NORA_LOCALIDAD_ID = ?");
		 * params.add(tclugaud.getT4noraLocalidadId()); } if (tclugaud != null
		 * && tclugaud.getT4noraCalleId() != null) {
		 * where.append(" AND t1.T4NORA_CALLE_ID = ?");
		 * params.add(tclugaud.getT4noraCalleId()); } if (tclugaud != null &&
		 * tclugaud.getT4noraCpId() != null) {
		 * where.append(" AND t1.T4NORA_CP_ID = ?");
		 * params.add(tclugaud.getT4noraCpId()); } if (tclugaud != null &&
		 * tclugaud.getT4noraPortalId() != null) {
		 * where.append(" AND t1.T4NORA_PORTAL_ID = ?");
		 * params.add(tclugaud.getT4noraPortalId()); } if (tclugaud != null &&
		 * tclugaud.getT4nombrePiso() != null) {
		 * where.append(" AND t1.T4NOMBRE_PISO = ?");
		 * params.add(tclugaud.getT4nombrePiso()); } if (tclugaud != null &&
		 * tclugaud.getT4nodir() != null) { where.append(" AND t1.T4NODIR = ?");
		 * params.add(tclugaud.getT4nodir()); } if (tclugaud != null &&
		 * tclugaud.getT4fecbaja() != null) {
		 * where.append(" AND t1.T4FECBAJA = ?");
		 * params.add(tclugaud.getT4fecbaja()); } if (tclugaud != null &&
		 * tclugaud.getT4fecalta() != null) {
		 * where.append(" AND t1.T4FECALTA = ?");
		 * params.add(tclugaud.getT4fecalta()); } if (tclugaud != null &&
		 * tclugaud.getT4fecmodif() != null) {
		 * where.append(" AND t1.T4FECMODIF = ?");
		 * params.add(tclugaud.getT4fecmodif()); } if (tclugaud != null &&
		 * tclugaud.getT4usualta() != null) {
		 * where.append(" AND t1.T4USUALTA = ?");
		 * params.add(tclugaud.getT4usualta()); } if (tclugaud != null &&
		 * tclugaud.getT4usumodif() != null) {
		 * where.append(" AND t1.T4USUMODIF = ?");
		 * params.add(tclugaud.getT4usumodif()); }
		 */

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Tclugaud entity
	 * 
	 * @param tclugaud
	 *            Tclugaud Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Tclugaud tclugaud, Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				TclugaudDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (tclugaud != null && tclugaud.getT4codigo() != null) {
			where.append(" AND UPPER(t1.T4CODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tclugaud.getT4codigo().toUpperCase() + "%");
			} else {
				params.add("%" + tclugaud.getT4codigo().toUpperCase() + "%");
			}
			where.append(" AND t1.T4CODIGO IS NOT NULL");
		}
		if (tclugaud != null && tclugaud.getT4nombre() != null) {
			where.append(" AND UPPER(t1.T4NOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tclugaud.getT4nombre().toUpperCase() + "%");
			} else {
				params.add("%" + tclugaud.getT4nombre().toUpperCase() + "%");
			}
			where.append(" AND t1.T4NOMBRE IS NOT NULL");
		}
		if (tclugaud != null && tclugaud.getT4nombreeu() != null) {
			where.append(" AND UPPER(t1.T4NOMBREEU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tclugaud.getT4nombreeu().toUpperCase() + "%");
			} else {
				params.add("%" + tclugaud.getT4nombreeu().toUpperCase() + "%");
			}
			where.append(" AND t1.T4NOMBREEU IS NOT NULL");
		}
		if (tclugaud != null && tclugaud.getT4noraProvinciaId() != null) {
			where.append(" AND UPPER(t1.T4NORA_PROVINCIA_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tclugaud.getT4noraProvinciaId().toUpperCase() + "%");
			} else {
				params.add("%" + tclugaud.getT4noraProvinciaId().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.T4NORA_PROVINCIA_ID IS NOT NULL");
		}
		if (tclugaud != null && tclugaud.getT4noraMunicipioId() != null) {
			where.append(" AND UPPER(t1.T4NORA_MUNICIPIO_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tclugaud.getT4noraMunicipioId().toUpperCase() + "%");
			} else {
				params.add("%" + tclugaud.getT4noraMunicipioId().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.T4NORA_MUNICIPIO_ID IS NOT NULL");
		}
		if (tclugaud != null && tclugaud.getT4noraLocalidadId() != null) {
			where.append(" AND UPPER(t1.T4NORA_LOCALIDAD_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tclugaud.getT4noraLocalidadId().toUpperCase() + "%");
			} else {
				params.add("%" + tclugaud.getT4noraLocalidadId().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.T4NORA_LOCALIDAD_ID IS NOT NULL");
		}
		if (tclugaud != null && tclugaud.getT4noraCalleId() != null) {
			where.append(" AND UPPER(t1.T4NORA_CALLE_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tclugaud.getT4noraCalleId().toUpperCase() + "%");
			} else {
				params.add("%" + tclugaud.getT4noraCalleId().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.T4NORA_CALLE_ID IS NOT NULL");
		}
		if (tclugaud != null && tclugaud.getT4noraCpId() != null) {
			where.append(" AND UPPER(t1.T4NORA_CP_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tclugaud.getT4noraCpId().toUpperCase() + "%");
			} else {
				params.add("%" + tclugaud.getT4noraCpId().toUpperCase() + "%");
			}
			where.append(" AND t1.T4NORA_CP_ID IS NOT NULL");
		}
		if (tclugaud != null && tclugaud.getT4noraPortalId() != null) {
			where.append(" AND UPPER(t1.T4NORA_PORTAL_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tclugaud.getT4noraPortalId().toUpperCase() + "%");
			} else {
				params.add("%" + tclugaud.getT4noraPortalId().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.T4NORA_PORTAL_ID IS NOT NULL");
		}
		if (tclugaud != null && tclugaud.getT4nombrePiso() != null) {
			where.append(" AND UPPER(t1.T4NOMBRE_PISO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tclugaud.getT4nombrePiso().toUpperCase() + "%");
			} else {
				params.add("%" + tclugaud.getT4nombrePiso().toUpperCase() + "%");
			}
			where.append(" AND t1.T4NOMBRE_PISO IS NOT NULL");
		}
		if (tclugaud != null && tclugaud.getT4nodir() != null) {
			where.append(" AND UPPER(t1.T4NODIR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tclugaud.getT4nodir().toUpperCase() + "%");
			} else {
				params.add("%" + tclugaud.getT4nodir().toUpperCase() + "%");
			}
			where.append(" AND t1.T4NODIR IS NOT NULL");
		}
		if (tclugaud != null && tclugaud.getT4fecbaja() != null) {
			where.append(" AND t1.T4FECBAJA = ?");
			params.add(tclugaud.getT4fecbaja());
		}
		if (tclugaud != null && tclugaud.getT4fecalta() != null) {
			where.append(" AND t1.T4FECALTA = ?");
			params.add(tclugaud.getT4fecalta());
		}
		if (tclugaud != null && tclugaud.getT4fecmodif() != null) {
			where.append(" AND t1.T4FECMODIF = ?");
			params.add(tclugaud.getT4fecmodif());
		}
		if (tclugaud != null && tclugaud.getT4usualta() != null) {
			where.append(" AND UPPER(t1.T4USUALTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tclugaud.getT4usualta().toUpperCase() + "%");
			} else {
				params.add("%" + tclugaud.getT4usualta().toUpperCase() + "%");
			}
			where.append(" AND t1.T4USUALTA IS NOT NULL");
		}
		if (tclugaud != null && tclugaud.getT4usumodif() != null) {
			where.append(" AND UPPER(t1.T4USUMODIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tclugaud.getT4usumodif().toUpperCase() + "%");
			} else {
				params.add("%" + tclugaud.getT4usumodif().toUpperCase() + "%");
			}
			where.append(" AND t1.T4USUMODIF IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	private RowMapper<Tclugaud> rwMapBusqueda = new RowMapper<Tclugaud>() {
		public Tclugaud mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			Tclugaud tclugaud = new Tclugaud(resultSet.getString("T4CODIGO"),
					resultSet.getString("T4NOMBRE"),
					resultSet.getString("T4NOMBREEU"),
					resultSet.getString("T4NORAPROVINCIAID"),
					resultSet.getString("T4NORAMUNICIPIOID"),
					resultSet.getString("T4NORALOCALIDADID"),
					resultSet.getString("T4NORACALLEID"),
					resultSet.getString("T4NORACPID"),
					resultSet.getString("T4NORAPORTALID"),
					resultSet.getString("T4NOMBREPISO"),
					resultSet.getString("T4NODIR"),
					resultSet.getDate("T4FECBAJA"),
					resultSet.getDate("T4FECALTA"),
					resultSet.getDate("T4FECMODIF"),
					resultSet.getString("T4USUALTA"),
					resultSet.getString("T4USUMODIF"));
			tclugaud.setT4calle(resultSet.getString("T4CALLE"));
			tclugaud.setT4municipio(resultSet.getString("T4MUNICIPIO"));
			tclugaud.setT4provincia(resultSet.getString("T4PROVINCIA"));
			tclugaud.setT4localidad(resultSet.getString("T4LOCALIDAD"));

			return tclugaud;
		}
	};

	/**
	 * Finds a List of rows in the Tclugaud table.
	 * 
	 * @param tclugaud
	 *            Tclugaud
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Tclugaud> findAllBusqueda(Tclugaud tclugaud,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT distinct t1.T4CODIGO T4CODIGO, t1.T4NOMBRE T4NOMBRE, t1.T4NOMBREEU T4NOMBREEU, t1.T4NORA_PROVINCIA_ID T4NORAPROVINCIAID, t1.T4NORA_MUNICIPIO_ID T4NORAMUNICIPIOID, t1.T4NORA_LOCALIDAD_ID T4NORALOCALIDADID, t1.T4NORA_CALLE_ID T4NORACALLEID, t1.T4NORA_CP_ID T4NORACPID, t1.T4NORA_PORTAL_ID T4NORAPORTALID, t1.T4NOMBRE_PISO T4NOMBREPISO, t1.T4NODIR T4NODIR, t1.T4FECBAJA T4FECBAJA, t1.T4FECALTA T4FECALTA, t1.T4FECMODIF T4FECMODIF, t1.T4USUALTA T4USUALTA, t1.T4USUMODIF T4USUMODIF, t2.DS_O T4CALLE, T3.DS_O T4PROVINCIA, T4.DS_O T4LOCALIDAD, T5.DS_O T4MUNICIPIO  FROM TCLUGAUD T1,T17_CALLE T2,T17_PROVINCIA T3,T17_LOCALIDAD T4,T17_MUNICIPIO T5       ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(tclugaud);

		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND T1.T4NORA_CALLE_ID=T2.ID(+) ");
		where.append(" AND T1.T4NORA_PROVINCIA_ID=T3.ID(+)  ");
		where.append(" AND T1.T4NORA_LOCALIDAD_ID=T4.ID(+) ");
		where.append(" AND T1.T4NORA_MUNICIPIO_ID=T5.ID(+) ");
		where.append(" AND T5.PROVINCIA_ID=T1.T4NORA_PROVINCIA_ID ");

		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Tclugaud>) this.jdbcTemplate.query(query.toString(),
				this.rwMapBusqueda, params.toArray());
	}

	/**
	 * Counts rows in the Tclugaud table.
	 * 
	 * @param tclugaud
	 *            Tclugaud
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllBusquedaCount(Tclugaud tclugaud) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(distinct t4codigo)  FROM TCLUGAUD T1,T17_CALLE T2,T17_PROVINCIA T3,T17_LOCALIDAD T4,T17_MUNICIPIO T5 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(tclugaud);

		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND T1.T4NORA_CALLE_ID=T2.ID(+) ");
		where.append(" AND T1.T4NORA_PROVINCIA_ID=T3.ID(+)  ");
		where.append(" AND T1.T4NORA_LOCALIDAD_ID=T4.ID(+) ");
		where.append(" AND T1.T4NORA_MUNICIPIO_ID=T5.ID(+) ");
		where.append(" AND T5.PROVINCIA_ID=T1.T4NORA_PROVINCIA_ID ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}
}
