package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.T17TipoVia;

/**
 * T17TipoViaDaoImpl  
 *  
 */
 
@Repository
@Transactional
public class T17TipoViaDaoImpl implements T17TipoViaDao {
    private JdbcTemplate jdbcTemplate;
	private RowMapper<T17TipoVia> rwMap = new RowMapper<T17TipoVia>() {
		public T17TipoVia mapRow(ResultSet resultSet, int rowNum) throws SQLException {
           return new T17TipoVia(
               resultSet.getString("ID"), resultSet.getString("DSE"), resultSet.getString("DSC")
           ); } } ;

	/**
     * Method use to set the datasource.
     *
     * @param dataSource DataSource
     * @return
     */
    @Resource
    public void setDataSource(DataSource dataSource) {
    	this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    /**
     * Inserts a single row in the T17TipoVia table.
     *
     * @param t17tipovia Pagination
     * @return T17TipoVia
     */
	public T17TipoVia add(T17TipoVia t17tipovia) {
    	String query = "INSERT INTO T17_TIPO_VIA (ID, DS_E, DS_C) VALUES (?,?,?)";
		this.jdbcTemplate.update(query, t17tipovia.getId(), t17tipovia.getDsE(), t17tipovia.getDsC());
		return t17tipovia;
	}

    /**
     * Updates a single row in the T17TipoVia table.
     *
     * @param t17tipovia Pagination
     * @return T17TipoVia
     */
    public T17TipoVia update(T17TipoVia t17tipovia) {
		String query = "UPDATE T17_TIPO_VIA SET DS_E=?, DS_C=? WHERE ID=?";
		this.jdbcTemplate.update(query, t17tipovia.getDsE(), t17tipovia.getDsC(), t17tipovia.getId());
		return t17tipovia;
	}

    /**
     * Finds a single row in the T17TipoVia table.
     *
     * @param t17tipovia Pagination
     * @return T17TipoVia
     */
    @Transactional (readOnly = true)
    public T17TipoVia find(T17TipoVia t17tipovia) {
		String query = "SELECT t1.ID ID, t1.DS_E DSE, t1.DS_C DSC FROM T17_TIPO_VIA t1  WHERE t1.ID = ?  ";
		
		List<T17TipoVia> t17tipoviaList = this.jdbcTemplate.query(query, this.rwMap, t17tipovia.getId());
		return (T17TipoVia) DataAccessUtils.uniqueResult(t17tipoviaList);
    }

    /**
     * Removes a single row in the T17TipoVia table.
     *
     * @param t17tipovia Pagination
     * @return
     */
    public void remove(T17TipoVia t17tipovia) {
		String query = "DELETE FROM T17_TIPO_VIA WHERE ID=?";
		this.jdbcTemplate.update(query, t17tipovia.getId());
    }
    
   /**
    * Finds a List of rows in the T17TipoVia table.
    * 
    * @param t17tipovia T17TipoVia
    * @param pagination Pagination
    * @return List 
    */
	@Transactional (readOnly = true)
    public List<T17TipoVia> findAll(T17TipoVia t17tipovia, Pagination pagination) {
		StringBuilder query = new StringBuilder("SELECT  t1.ID ID,t1.DS_E DSE,t1.DS_C DSC "); 
		query.append("FROM T17_TIPO_VIA t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(t17tipovia); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		
		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		
		return (List<T17TipoVia>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}
	
    /**
     * Counts rows in the T17TipoVia table.
     * 
     * @param t17tipovia T17TipoVia
     * @return Long
     */
    @Transactional (readOnly = true)
    public Long findAllCount(T17TipoVia t17tipovia) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM T17_TIPO_VIA t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(t17tipovia); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);		
		
		List<?> params = (List<?>) mapaWhere.get("params");
		
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	
	/**
	 * Finds rows in the T17TipoVia table using like.
     * 
     * @param t17tipovia T17TipoVia
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List 
     */
	@Transactional (readOnly = true)
    public List<T17TipoVia> findAllLike(T17TipoVia t17tipovia, Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT  t1.ID ID,t1.DS_E DSE,t1.DS_C DSC "); 
        query.append("FROM T17_TIPO_VIA t1 ");
      	
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(t17tipovia,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		
		return (List<T17TipoVia>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}
	
	/**
	 * Counts rows in the T17TipoVia table using like.
     * 
     * @param t17tipovia T17TipoVia
     * @param startsWith Boolean
     * @return Long 
     */
	@Transactional (readOnly = true)
    public Long findAllLikeCount(T17TipoVia t17tipovia, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM T17_TIPO_VIA t1 ");

		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(t17tipovia,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	
	/**
	 * Returns a map with the needed value to create the conditions to filter by 
	 * the T17TipoVia entity 
	 * 
	 * @param t17tipovia T17TipoVia
	 *            Bean with the criteria values to filter by.
	 * @return Map created with two keys
	 *         key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap (T17TipoVia t17tipovia){
		
		StringBuilder where = new StringBuilder(T17TipoViaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (t17tipovia  != null  && t17tipovia.getId() != null ) {
			where.append(" AND t1.ID = ?");
			params.add(t17tipovia.getId());
		}
		if (t17tipovia  != null  && t17tipovia.getDsE() != null ) {
			where.append(" AND t1.DS_E = ?");
			params.add(t17tipovia.getDsE());
		}
		if (t17tipovia  != null  && t17tipovia.getDsC() != null ) {
			where.append(" AND t1.DS_C = ?");
			params.add(t17tipovia.getDsC());
		}

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		
		return mapWhere;		
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA
	
	/**
	 * Returns a map with the needed value to create the conditions to filter by  
	 * the T17TipoVia entity 
	 * 
	 * @param t17tipovia T17TipoVia
	 *            Bean with the criteria values to filter by.
     * @param startsWith Boolean	 
	 * @return Map created with two keys
	 *         key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap (T17TipoVia t17tipovia, Boolean startsWith){
		
		StringBuilder where = new StringBuilder(T17TipoViaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (t17tipovia  != null  && t17tipovia.getId() != null ) {
			where.append(" AND UPPER(t1.ID) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(t17tipovia.getId().toUpperCase() +"%");
			}else{
				params.add("%"+t17tipovia.getId().toUpperCase() +"%");
			}
			where.append(" AND t1.ID IS NOT NULL");
	     }			
		if (t17tipovia  != null  && t17tipovia.getDsE() != null ) {
			where.append(" AND UPPER(t1.DS_E) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(t17tipovia.getDsE().toUpperCase() +"%");
			}else{
				params.add("%"+t17tipovia.getDsE().toUpperCase() +"%");
			}
			where.append(" AND t1.DS_E IS NOT NULL");
	     }			
		if (t17tipovia  != null  && t17tipovia.getDsC() != null ) {
			where.append(" AND UPPER(t1.DS_C) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(t17tipovia.getDsC().toUpperCase() +"%");
			}else{
				params.add("%"+t17tipovia.getDsC().toUpperCase() +"%");
			}
			where.append(" AND t1.DS_C IS NOT NULL");
	     }			

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		
		return mapWhere;		
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA
	
	/**
	 * StringBuilder initilization value
	 */
	 public static final int STRING_BUILDER_INIT = 4096;}

