package com.ejie.y41b.dao;

/**
 * T17PaisDao  
 */

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.T17Pais;
import com.ejie.y41b.model.T17PaisesIso;

/**
 * T17PaisDao  
 * 
 *  
 */
public interface T17PaisDao {
	/**
	 * Inserts a single row in the T17Pais table.
	 * 
	 * @param t17pais
	 *            T17Pais
	 * @return T17Pais
	 */
	T17Pais add(T17Pais t17pais);

	/**
	 * Updates a single row in the T17Pais table.
	 * 
	 * @param t17pais
	 *            T17Pais
	 * @return T17Pais
	 */
	T17Pais update(T17Pais t17pais);

	/**
	 * Finds a single row in the T17Pais table.
	 * 
	 * @param t17pais
	 *            T17Pais
	 * @return T17Pais
	 */
	T17Pais find(T17Pais t17pais);

	/**
	 * Deletes a single row in the T17Pais table.
	 * 
	 * @param t17pais
	 *            T17Pais
	 * 
	 */
	void remove(T17Pais t17pais);

	/**
	 * Finds a List of rows in the T17Pais table.
	 * 
	 * @param t17pais
	 *            T17Pais
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<T17Pais> findAll(T17Pais t17pais, Pagination pagination);

	/**
	 * Finds a List of rows in the T17Pais table.
	 * 
	 * @param t17pais
	 *            T17Pais
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<T17Pais> findAllSinEstado(T17Pais t17pais, Pagination pagination);

	/**
	 * Finds a List of rows in the T17Pais table.
	 * 
	 * @param t17PaisesIso
	 *            T17PaisesIso
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<T17Pais> findAllT17PaisesIsoByAlfa2(T17PaisesIso t17PaisesIso,
			Pagination pagination);

	/**
	 * Counts rows in the T17Pais table.
	 * 
	 * @param t17pais
	 *            T17Pais
	 * @return List
	 */
	Long findAllCount(T17Pais t17pais);

	/**
	 * Finds rows in the T17Pais table using like.
	 * 
	 * @param t17pais
	 *            T17Pais
	 * @return List
	 */
	List<T17Pais> findAllLike(T17Pais t17pais, Pagination pagination,
			Boolean startsWith);
}
