package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y41b.model.T17Municipio;

/**
 * * T17MunicipioDaoImpl  
 * 
 *  
 */
@Repository
@Transactional
public class T17MunicipioDaoImpl implements T17MunicipioDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<T17Municipio> rwMap = new RowMapper<T17Municipio>() {
		public T17Municipio mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new T17Municipio(resultSet.getString("ID"),
					resultSet.getString("PROVINCIAID"),
					resultSet.getString("DSO"),
					resultSet.getString("COMARCAID"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * 
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the T17Municipio table.
	 * 
	 * @param t17municipio
	 *            Pagination
	 * @return T17Municipio
	 */
	public T17Municipio add(T17Municipio t17municipio) {

		String query = "INSERT INTO T17_MUNICIPIO( ID,PROVINCIA_ID,DS_O,COMARCA_ID)"
				+ "VALUES (?,?,?,?)";

		this.jdbcTemplate.update(query, t17municipio.getId(),
				t17municipio.getProvinciaId(), t17municipio.getDsO(),
				t17municipio.getComarcaId());
		return t17municipio;
	}

	/**
	 * Updates a single row in the T17Municipio table.
	 * 
	 * @param t17municipio
	 *            Pagination
	 * @return T17Municipio
	 */
	public T17Municipio update(T17Municipio t17municipio) {
		String query = "UPDATE T17_MUNICIPIO SET DS_O=?,COMARCA_ID=? WHERE ID=? AND PROVINCIA_ID=?";
		this.jdbcTemplate.update(query, t17municipio.getDsO(),
				t17municipio.getComarcaId(), t17municipio.getId(),
				t17municipio.getProvinciaId());
		return t17municipio;

	}

	/**
	 * Finds a single row in the T17Municipio table.
	 * 
	 * @param t17municipio
	 *            Pagination
	 * @return T17Municipio
	 */
	@Transactional(readOnly = true)
	public T17Municipio find(T17Municipio t17municipio) {
		String query = "SELECT t1.ID ID, t1.PROVINCIA_ID PROVINCIAID, t1.DS_O DSO, t1.COMARCA_ID COMARCAID "
				+ "FROM T17_MUNICIPIO t1  "
				+ "WHERE t1.ID = ?   AND t1.PROVINCIA_ID = ?    ";
		return (T17Municipio) this.jdbcTemplate.queryForObject(query, rwMap,
				t17municipio.getId(), t17municipio.getProvinciaId());
	}

	/**
	 * Removes a single row in the T17Municipio table.
	 * 
	 * @param t17municipio
	 *            Pagination
	 * 
	 */
	public void remove(T17Municipio t17municipio) {
		String query = "DELETE  FROM T17_MUNICIPIO WHERE ID=? AND PROVINCIA_ID=?";
		this.jdbcTemplate.update(query, t17municipio.getId(),
				t17municipio.getProvinciaId());

	}

	/**
	 * Finds a List of rows in the T17Municipio table.
	 * 
	 * @param t17municipio
	 *            T17Municipio
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<T17Municipio> findAll(T17Municipio t17municipio,
			Pagination pagination) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");
		StringBuffer query = new StringBuffer(
				"SELECT  t1.ID ID,t1.PROVINCIA_ID PROVINCIAID,t1.DS_O DSO,t1.COMARCA_ID COMARCAID "
						+ "FROM T17_MUNICIPIO t1 ");
		if (t17municipio != null && t17municipio.getId() != null) {
			where.append(" AND t1.ID = ?");
			params.add(t17municipio.getId());
		}

		where.append(" AND t1.PROVINCIA_ID = ?");
		params.add(t17municipio.getProvinciaId());

		if (t17municipio != null && t17municipio.getDsO() != null) {
			where.append(" AND t1.DS_O = ?");
			params.add(t17municipio.getDsO());
		}
		if (t17municipio != null && t17municipio.getComarcaId() != null) {
			where.append(" AND t1.COMARCA_ID = ?");
			params.add(t17municipio.getComarcaId());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}

			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}

		return (List<T17Municipio>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	/**
	 * Counts rows in the T17Municipio table.
	 * 
	 * @param t17municipio
	 *            T17Municipio
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(T17Municipio t17municipio) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  T17_MUNICIPIO t1  ");
		if (t17municipio != null && t17municipio.getId() != null) {
			where.append(" AND t1.ID = ?");
			params.add(t17municipio.getId());
		}
		if (t17municipio != null && t17municipio.getProvinciaId() != null) {
			where.append(" AND t1.PROVINCIA_ID = ?");
			params.add(t17municipio.getProvinciaId());
		}
		if (t17municipio != null && t17municipio.getDsO() != null) {
			where.append(" AND t1.DS_O = ?");
			params.add(t17municipio.getDsO());
		}
		if (t17municipio != null && t17municipio.getComarcaId() != null) {
			where.append(" AND t1.COMARCA_ID = ?");
			params.add(t17municipio.getComarcaId());
		}

		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());

	}

	/**
	 * Finds rows in the T17Municipio table using like.
	 * 
	 * @param t17municipio
	 *            T17Municipio
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<T17Municipio> findAllLike(T17Municipio t17municipio,
			Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");
		StringBuffer query = new StringBuffer(
				"SELECT  t1.ID ID,t1.PROVINCIA_ID PROVINCIAID,t1.DS_O DSO,t1.COMARCA_ID COMARCAID "
						+ "FROM T17_MUNICIPIO t1 ");
		if (t17municipio != null && t17municipio.getId() != null) {
			where.append(" AND UPPER(t1.ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(t17municipio.getId().toUpperCase() + "%");
			} else {
				params.add("%" + t17municipio.getId().toUpperCase() + "%");
			}
			where.append(" AND t1.ID IS NOT NULL");

		}
		if (t17municipio != null && t17municipio.getProvinciaId() != null) {
			where.append(" AND UPPER(t1.PROVINCIA_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(t17municipio.getProvinciaId().toUpperCase() + "%");
			} else {
				params.add("%" + t17municipio.getProvinciaId().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.PROVINCIA_ID IS NOT NULL");

		}
		if (t17municipio != null && t17municipio.getDsO() != null) {
			where.append(" AND UPPER(t1.DS_O) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(t17municipio.getDsO().toUpperCase() + "%");
			} else {
				params.add("%" + t17municipio.getDsO().toUpperCase() + "%");
			}
			where.append(" AND t1.DS_O IS NOT NULL");

		}
		if (t17municipio != null && t17municipio.getComarcaId() != null) {
			where.append(" AND UPPER(t1.COMARCA_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(t17municipio.getComarcaId().toUpperCase() + "%");
			} else {
				params.add("%" + t17municipio.getComarcaId().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.COMARCA_ID IS NOT NULL");

		}

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}

			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}

		return (List<T17Municipio>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

}
