package com.ejie.y41b.dao;

/**
 * Municipio  
 */

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.T17Municipio;

/**
 * MunicipioDao  
 * 
 *  
 */
public interface T17MunicipioDao {
	/**
	 * Inserts a single row in the Municipio table.
	 * 
	 * @param municipio
	 *            Municipio
	 * @return Municipio
	 */
	T17Municipio add(T17Municipio municipio);

	/**
	 * Updates a single row in the Municipio table.
	 * 
	 * @param municipio
	 *            Municipio
	 * @return Municipio
	 */
	T17Municipio update(T17Municipio municipio);

	/**
	 * Finds a single row in the Municipio table.
	 * 
	 * @param municipio
	 *            Municipio
	 * @return Municipio
	 */
	T17Municipio find(T17Municipio municipio);

	/**
	 * Deletes a single row in the Municipio table.
	 * 
	 * @param municipio
	 *            Municipio
	 * 
	 */
	void remove(T17Municipio municipio);

	/**
	 * Finds a List of rows in the Municipio table.
	 * 
	 * @param municipio
	 *            Municipio
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<T17Municipio> findAll(T17Municipio municipio, Pagination pagination);

	/**
	 * Counts rows in the Municipio table.
	 * 
	 * @param municipio
	 *            Municipio
	 * @return List
	 */
	Long findAllCount(T17Municipio municipio);

	/**
	 * Finds rows in the Municipio table using like.
	 * 
	 * @param municipio
	 *            Municipio
	 * @return List
	 */
	List<T17Municipio> findAllLike(T17Municipio municipio,
			Pagination pagination, Boolean startsWith);
}
