package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y41b.model.T17Localidad;

/**
 * * T17LocalidadDaoImpl  
 * 
 *  
 */
@Repository
@Transactional
public class T17LocalidadDaoImpl implements T17LocalidadDao {

	private static final Logger logger = LoggerFactory
			.getLogger(T17LocalidadDaoImpl.class);

	private JdbcTemplate jdbcTemplate;
	private RowMapper<T17Localidad> rwMap = new RowMapper<T17Localidad>() {
		public T17Localidad mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			/*
			 * this.id = id; this.dsO = dsO; this.municipioId = municipioId;
			 * this.provinciaId = provinciaId; this.entidadId = entidadId;
			 */

			// String id, String dsO, String municipioId, String provinciaId,
			// Long entidadId) {
			logger.debug("Provinciaid: " + resultSet.getString("PROVINCIAID"));
			logger.debug("Municipioid: " + resultSet.getString("MUNICIPIOID"));

			return new T17Localidad(resultSet.getString("ID"),
					resultSet.getString("DSO"),
					resultSet.getString("MUNICIPIOID"),
					resultSet.getString("PROVINCIAID"), null);
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * 
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the T17Localidad table.
	 * 
	 * @param t17localidad
	 *            Pagination
	 * @return T17Localidad
	 */
	public T17Localidad add(T17Localidad t17localidad) {

		String query = "INSERT INTO T17_LOCALIDAD( ID,DS_O,MUNICIPIO_ID,PROVINCIA_ID,ENTIDAD_ID)"
				+ "VALUES (?,?,?,?,?)";

		this.jdbcTemplate.update(query, t17localidad.getId(),
				t17localidad.getDsO(), t17localidad.getMunicipioId(),
				t17localidad.getProvinciaId(), t17localidad.getEntidadId());
		return t17localidad;
	}

	/**
	 * Updates a single row in the T17Localidad table.
	 * 
	 * @param t17localidad
	 *            Pagination
	 * @return T17Localidad
	 */
	public T17Localidad update(T17Localidad t17localidad) {
		String query = "UPDATE T17_LOCALIDAD SET DS_O=?,MUNICIPIO_ID=?,PROVINCIA_ID=?,ENTIDAD_ID=? WHERE ID=?";
		this.jdbcTemplate.update(query, t17localidad.getDsO(),
				t17localidad.getMunicipioId(), t17localidad.getProvinciaId(),
				t17localidad.getEntidadId(), t17localidad.getId());
		return t17localidad;

	}

	/**
	 * Finds a single row in the T17Localidad table.
	 * 
	 * @param t17localidad
	 *            Pagination
	 * @return T17Localidad
	 */
	@Transactional(readOnly = true)
	public T17Localidad find(T17Localidad t17localidad) {
		String query = "SELECT t1.ID ID, t1.DS_O DSO, t1.MUNICIPIO_ID MUNICIPIOID, t1.PROVINCIA_ID PROVINCIAID, t1.ENTIDAD_ID ENTIDADID "
				+ "FROM T17_LOCALIDAD t1  " + "WHERE t1.ID = ?    ";
		return (T17Localidad) this.jdbcTemplate.queryForObject(query, rwMap,
				t17localidad.getId());
	}

	/**
	 * Removes a single row in the T17Localidad table.
	 * 
	 * @param t17localidad
	 *            Pagination
	 * 
	 */
	public void remove(T17Localidad t17localidad) {
		String query = "DELETE  FROM T17_LOCALIDAD WHERE ID=?";
		this.jdbcTemplate.update(query, t17localidad.getId());

	}

	/**
	 * Finds a List of rows in the T17Localidad table.
	 * 
	 * @param t17localidad
	 *            T17Localidad
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<T17Localidad> findAll(T17Localidad t17localidad,
			Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");
		StringBuffer query = new StringBuffer(
				"SELECT  t1.ID ID,t1.DS_O DSO,t1.MUNICIPIO_ID MUNICIPIOID,t1.PROVINCIA_ID PROVINCIAID,t1.ENTIDAD_ID ENTIDADID "
						+ "FROM T17_LOCALIDAD t1 ");
		if (t17localidad != null && t17localidad.getId() != null) {
			where.append(" AND t1.ID = ?");
			params.add(t17localidad.getId());
		}
		if (t17localidad != null && t17localidad.getDsO() != null) {
			where.append(" AND t1.DS_O = ?");
			params.add(t17localidad.getDsO());
		}

		where.append(" AND t1.MUNICIPIO_ID = ?");
		params.add(t17localidad.getMunicipioId());

		where.append(" AND t1.PROVINCIA_ID = ?");
		params.add(t17localidad.getProvinciaId());

		if (t17localidad != null && t17localidad.getEntidadId() != null) {
			where.append(" AND t1.ENTIDAD_ID = ?");
			params.add(t17localidad.getEntidadId());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}

			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}

		return (List<T17Localidad>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	/**
	 * Counts rows in the T17Localidad table.
	 * 
	 * @param t17localidad
	 *            T17Localidad
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(T17Localidad t17localidad) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  T17_LOCALIDAD t1  ");
		if (t17localidad != null && t17localidad.getId() != null) {
			where.append(" AND t1.ID = ?");
			params.add(t17localidad.getId());
		}
		if (t17localidad != null && t17localidad.getDsO() != null) {
			where.append(" AND t1.DS_O = ?");
			params.add(t17localidad.getDsO());
		}
		if (t17localidad != null && t17localidad.getMunicipioId() != null) {
			where.append(" AND t1.MUNICIPIO_ID = ?");
			params.add(t17localidad.getMunicipioId());
		}
		if (t17localidad != null && t17localidad.getProvinciaId() != null) {
			where.append(" AND t1.PROVINCIA_ID = ?");
			params.add(t17localidad.getProvinciaId());
		}
		if (t17localidad != null && t17localidad.getEntidadId() != null) {
			where.append(" AND t1.ENTIDAD_ID = ?");
			params.add(t17localidad.getEntidadId());
		}

		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());

	}

	/**
	 * Finds rows in the T17Localidad table using like.
	 * 
	 * @param t17localidad
	 *            T17Localidad
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<T17Localidad> findAllLike(T17Localidad t17localidad,
			Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");
		StringBuffer query = new StringBuffer(
				"SELECT  t1.ID ID,t1.DS_O DSO,t1.MUNICIPIO_ID MUNICIPIOID,t1.PROVINCIA_ID PROVINCIAID,t1.ENTIDAD_ID ENTIDADID "
						+ "FROM T17_LOCALIDAD t1 ");
		if (t17localidad != null && t17localidad.getId() != null) {
			where.append(" AND t1.ID like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(t17localidad.getId() + "%");
			} else {
				params.add("%" + t17localidad.getId() + "%");
			}
			where.append(" AND t1.ID IS NOT NULL");

		}
		if (t17localidad != null && t17localidad.getDsO() != null) {
			where.append(" AND UPPER(t1.DS_O) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(t17localidad.getDsO().toUpperCase() + "%");
			} else {
				params.add("%" + t17localidad.getDsO().toUpperCase() + "%");
			}
			where.append(" AND t1.DS_O IS NOT NULL");

		}
		if (t17localidad != null && t17localidad.getMunicipioId() != null) {
			where.append(" AND UPPER(t1.MUNICIPIO_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(t17localidad.getMunicipioId().toUpperCase() + "%");
			} else {
				params.add("%" + t17localidad.getMunicipioId().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.MUNICIPIO_ID IS NOT NULL");

		}
		if (t17localidad != null && t17localidad.getProvinciaId() != null) {
			where.append(" AND UPPER(t1.PROVINCIA_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(t17localidad.getProvinciaId().toUpperCase() + "%");
			} else {
				params.add("%" + t17localidad.getProvinciaId().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.PROVINCIA_ID IS NOT NULL");

		}
		if (t17localidad != null && t17localidad.getEntidadId() != null) {
			where.append(" AND t1.ENTIDAD_ID like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(t17localidad.getEntidadId() + "%");
			} else {
				params.add("%" + t17localidad.getEntidadId() + "%");
			}
			where.append(" AND t1.ENTIDAD_ID IS NOT NULL");

		}

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}

			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}

		return (List<T17Localidad>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

}
