package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y41b.model.T17Calle;
import com.ejie.y41b.model.T17Portal;

/**
 * * T17CalleDaoImpl  
 * 
 *  
 */
@Repository
@Transactional
public class T17CalleDaoImpl implements T17CalleDao {

	private JdbcTemplate jdbcTemplate;

	private RowMapper<T17Calle> rwMap = new RowMapper<T17Calle>() {
		public T17Calle mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			return new T17Calle(resultSet.getLong("ID"),
					resultSet.getString("DS_O"));
		}
	};

	private RowMapper<T17Calle> rwMapV = new RowMapper<T17Calle>() {
		public T17Calle mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			return new T17Calle(resultSet.getLong("ID"),
					resultSet.getString("DS_O"), resultSet.getString("DS_E"),
					resultSet.getString("TIPO_VIA"));
		}
	};

	private RowMapper<T17Calle> rwMapProvMun = new RowMapper<T17Calle>() {
		public T17Calle mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			T17Calle calle = new T17Calle();
			calle.setProvinciaId(resultSet.getString("PROVINCIA_ID"));
			calle.setMunicipioId(resultSet.getString("MUNICIPIO_ID"));
			return calle;
		}
	};

	private RowMapper<T17Calle> rwMapBusquedaCalle = new RowMapper<T17Calle>() {
		public T17Calle mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			T17Calle calle = new T17Calle();
			calle.setId(resultSet.getLong("ID"));
			calle.setTipoViaId(resultSet.getString("TIPO_VIA_ID"));
			calle.setDsO(resultSet.getString("DS_O"));

			return calle;

		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * 
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Finds a single row in the T17Calle table.
	 * 
	 * @param t17portal
	 *            Pagination
	 * @return T17Calle
	 */
	@Transactional(readOnly = true)
	public T17Calle find(T17Calle t17calle) {
		String query = "SELECT t1.ID ID, t1.DS_O DS_O, t1.DS_E DS_E, t1.TIPO_VIA TIPO_VIA "
				+ "FROM T17_CALLE t1  " + "WHERE t1.ID = ?";
		return (T17Calle) this.jdbcTemplate.queryForObject(query, rwMapV,
				t17calle.getId());
	}

	/**
	 * Metodo que devuelve la calle con su tipo de va
	 * 
	 * @param T17Calle
	 *            t17calle
	 * @return T17Calle
	 */
	@Transactional(readOnly = true)
	public T17Calle findCalleConTipoVia(T17Calle t17calle) {
		String query = "SELECT t1.ID ID, (t1.TIPO_VIA||'  '||t1.DS_O) AS DS_O "
				+ " FROM T17_CALLE t1 " + " WHERE t1.ID = ?";
		return (T17Calle) this.jdbcTemplate.queryForObject(query, rwMap,
				t17calle.getId());
	}

	/**
	 * Finds a List of rows in the T17Calle table.
	 * 
	 * @param t17portal
	 *            T17Calle
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<T17Calle> findAll(T17Calle t17calle, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");
		StringBuffer query = new StringBuffer(
				"SELECT ID, (t1.tipo_via||'  '||t1.ds_o) AS DS_O  FROM T17_CALLE t1");

		where.append(" AND t1.PROVINCIA_ID = ?");
		params.add(t17calle.getProvinciaId());

		where.append(" AND t1.MUNICIPIO_ID = ?");
		params.add(t17calle.getMunicipioId());

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}

			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}

		return (List<T17Calle>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	/**
	 * Counts rows in the T17Calle table.
	 * 
	 * @param t17portal
	 *            T17Calle
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(T17Calle t17calle) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  T17_CALLE t1  ");
		if (t17calle != null && t17calle.getProvinciaId() != null) {
			where.append(" AND t1.PROVINCIA_ID = ?");
			params.add(t17calle.getId());
		}
		if (t17calle != null && t17calle.getMunicipioId() != null) {
			where.append(" AND t1.MUNICIPIO_ID = ?");
			params.add(t17calle.getMunicipioId());
		}

		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());

	}

	/**
	 * Finds rows in the T17Calle table using like.
	 * 
	 * @param t17portal
	 *            T17Calle
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<T17Calle> findAllLike(T17Calle t17calle, Pagination pagination,
			Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");
		StringBuffer query = new StringBuffer(
				"SELECT t1.ID ID, t1.DS_O DS_O FROM T17_CALLE t1  ");

		if (t17calle != null && t17calle.getDsO() != null) {
			where.append(" AND t1.ID like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(t17calle.getDsO() + "%");
			} else {
				params.add("%" + t17calle.getDsO() + "%");
			}
			where.append(" AND t1.DS_O IS NOT NULL");

		}

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}

			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}

		return (List<T17Calle>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	/**
	 * Finds rows in the T17Calle table using like.
	 * 
	 * @param t17portal
	 *            T17Calle
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<T17Calle> findAllLike_Calle(T17Calle t17calle,
			Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");
		StringBuffer query = new StringBuffer(
				"SELECT t1.ID ID, t1.DS_O DS_O FROM T17_CALLE t1  ");

		where.append(" AND t1.PROVINCIA_ID = ?");
		params.add(t17calle.getProvinciaId());

		where.append(" AND t1.MUNICIPIO_ID = ?");
		params.add(t17calle.getMunicipioId());

		if (t17calle != null && t17calle.getDsO() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.DS_O),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(t17calle.getDsO().toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I")
						.replaceAll("", "O").replaceAll("", "U")
						+ "%");
			} else {
				params.add("%"
						+ t17calle.getDsO().toUpperCase().replaceAll("", "A")
								.replaceAll("", "E").replaceAll("", "I")
								.replaceAll("", "O").replaceAll("", "U")
						+ "%");
			}
			where.append(" AND t1.DS_O IS NOT NULL");

		}

		query.append(where);
		query.append(" ORDER BY t1.DS_O ASC");

		return (List<T17Calle>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	@Override
	public T17Calle add(T17Calle t17calle) {
		return null;
	}

	@Override
	public T17Calle update(T17Calle t17calle) {
		return null;
	}

	@Override
	public void remove(T17Calle t17calle) {
	}

	/**
	 * Finds a List of distinct CP rows in the T17Portal table.
	 * 
	 * @param t17Portal
	 *            T17Portal
	 * @return T17Calle
	 */
	@Transactional(readOnly = true)
	public T17Calle findProvMun(T17Portal t17Portal) {
		StringBuffer query = new StringBuffer();
		List<Object> params = new ArrayList<Object>();

		query.append("SELECT t1.MUNICIPIO_ID, t1.PROVINCIA_ID FROM t17_calle t1 WHERE ID=(");
		query.append("SELECT  * FROM ( ");
		query.append("SELECT  distinct(t2.CALLE_ID) CALLE_ID FROM t17_portal t2 ");
		query.append("WHERE 1=1");

		if (t17Portal != null && t17Portal.getCodigoPostal() != null) {
			query.append(" AND TRIM(t2.CODIGO_POSTAL) = ?");
			params.add(t17Portal.getCodigoPostal());
		}
		query.append(" ORDER BY t2.CALLE_ID ASC");
		query.append(") WHERE ROWNUM <= 1");
		query.append(")");

		return (T17Calle) this.jdbcTemplate.queryForObject(query.toString(),
				rwMapProvMun, params.toArray());
	}

	/**
	 * Finds a List of rows in the T17Calle table.
	 * 
	 * @param t17calle
	 *            T17Calle
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<T17Calle> findAllCalleLike(T17Calle t17calle,
			Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();

		StringBuffer query = new StringBuffer(
				"SELECT distinct(t1.id) as ID, t1.tipo_via AS TIPO_VIA_ID, t1.ds_O AS DS_O  FROM T17_CALLE t1, T17_TIPO_VIA t2");

		where.append(" WHERE 1=1 	");
		where.append(" AND t1.PROVINCIA_ID = ?");
		params.add(t17calle.getProvinciaId());

		where.append(" AND t1.MUNICIPIO_ID = ?");
		params.add(t17calle.getMunicipioId());

		if (t17calle != null && t17calle.getTipoViaId() != null) {
			where.append(" AND t1.TIPO_VIA_ID = t2.ID");
			where.append(" AND t2.ID = ?");
			params.add(t17calle.getTipoViaId());
		}

		if (t17calle != null && t17calle.getDsO() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.DS_O),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(t17calle.getDsO().toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I")
						.replaceAll("", "O").replaceAll("", "U")
						+ "%");
			} else {
				params.add("%"
						+ t17calle.getDsO().toUpperCase().replaceAll("", "A")
								.replaceAll("", "E").replaceAll("", "I")
								.replaceAll("", "O").replaceAll("", "U")
						+ "%");
			}
			where.append(" AND t1.DS_O IS NOT NULL");

		}

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}

			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}

		List<T17Calle> miLista = this.jdbcTemplate.query(query.toString(),
				rwMapBusquedaCalle, params.toArray());

		return miLista;
	}

	/**
	 * Counts rows in the T17Calle table.
	 * 
	 * @param t17portal
	 *            T17Calle
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCalleLikeCount(T17Calle t17calle, Boolean startsWith) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(distinct(t1.id)) FROM T17_CALLE t1, T17_TIPO_VIA t2");

		where.append(" WHERE 1=1 	");
		where.append(" AND t1.PROVINCIA_ID = ?");
		params.add(t17calle.getProvinciaId());

		where.append(" AND t1.MUNICIPIO_ID = ?");
		params.add(t17calle.getMunicipioId());

		if (t17calle != null && t17calle.getTipoViaId() != null) {
			where.append(" AND t1.TIPO_VIA_ID = t2.ID");
			where.append(" AND t2.ID = ?");
			params.add(t17calle.getTipoViaId());
		}

		if (t17calle != null && t17calle.getDsO() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.DS_O),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(t17calle.getDsO().toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I")
						.replaceAll("", "O").replaceAll("", "U")
						+ "%");
			} else {
				params.add("%"
						+ t17calle.getDsO().toUpperCase().replaceAll("", "A")
								.replaceAll("", "E").replaceAll("", "I")
								.replaceAll("", "O").replaceAll("", "U")
						+ "%");
			}
			where.append(" AND t1.DS_O IS NOT NULL");

		}

		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());

	}

}
