package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.SolicitudTelematicaEventos;
import com.ejie.y41b.utils.Y41bUtils;

/**
 * BandejaSolicitudesDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class SolicitudesTelematicasEventosDaoImpl implements SolicitudesTelematicasEventosDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<SolicitudTelematicaEventos> rwMap = new RowMapper<SolicitudTelematicaEventos>() {
		public SolicitudTelematicaEventos mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new SolicitudTelematicaEventos(resultSet.getString("ID_SOLICITUD_TELEMATICA"),
					resultSet.getString("TIPO_EXPEDIENTE"), resultSet.getString("PNOMBRE"),
					resultSet.getString("PNOMBREE"), resultSet.getString("NUM_EXPEDIENTE"),
					resultSet.getDate("FECHA_REGISTRO"), resultSet.getString("NUM_REGISTRO"),
					resultSet.getString("ID_ACCION_TELEMATICA"), resultSet.getClob("XML_SOLICITUD"));
		}
	};

	/**
	 * Rowmapper para Jerarquía
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	private RowMapper<SolicitudTelematicaEventos> rwMapXmlSolicitud = new RowMapper<SolicitudTelematicaEventos>() {
		public SolicitudTelematicaEventos mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new SolicitudTelematicaEventos(resultSet.getString("ID_SOLICITUD_TELEMATICA"),
					resultSet.getClob("XML_SOLICITUD"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Finds a List of rows in the SolicitudesTelematicasEventos table.
	 * 
	 * @param filterSolicitudTelematicaEventos
	 *            SolicitudTelematicaEventos
	 * @param fechaRegistroDesde
	 *            Date
	 * @param fechaRegistroHasta
	 *            Date
	 * @param pagination
	 *            Pagination
	 * @return List
	 */

	@Transactional(readOnly = true)
	public List<SolicitudTelematicaEventos> findAllSolicitudesTelematicasEventos(
			SolicitudTelematicaEventos filterSolicitudTelematicaEventos, Date fechaRegistroDesde,
			Date fechaRegistroHasta, Pagination pagination) {

		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_SOLICITUD_TELEMATICA ID_SOLICITUD_TELEMATICA, t1.TIPO_EXPEDIENTE TIPO_EXPEDIENTE, t2.PNOMBRE PNOMBRE,t2.PNOMBREE PNOMBREE, t1.NUM_EXPEDIENTE NUM_EXPEDIENTE, t1.FECHA_REGISTRO FECHA_REGISTRO, t1.NUM_REGISTRO NUM_REGISTRO,t1.ID_ACCION_TELEMATICA ID_ACCION_TELEMATICA, t1.XML_SOLICITUD XML_SOLICITUD ");
		query.append(
				"FROM SOLICITUD_TELEMATICA t1, TIPO_PROCEDIMIENTO t2 WHERE (1=1) AND t1.TIPO_EXPEDIENTE = t2.PCODIGO(+) ");

		StringBuilder where = new StringBuilder();

		List<Object> params = new ArrayList<Object>();

		if (filterSolicitudTelematicaEventos.getStTipoExpediente() != null) {
			where.append(" AND t1.TIPO_EXPEDIENTE= ? ");
			params.add(filterSolicitudTelematicaEventos.getStTipoExpediente());
		}

		if (filterSolicitudTelematicaEventos.getStIdAccionTelematica() != null) {
			where.append(" AND t1.ID_ACCION_TELEMATICA= ? ");
			params.add(filterSolicitudTelematicaEventos.getStIdAccionTelematica());
		}

		if (fechaRegistroDesde != null) {
			where.append(" AND ").append("t1.FECHA_REGISTRO>= to_date ('")
					.append(Y41bUtils.parseDateToString(fechaRegistroDesde, Y41bConstantes.EUSKERA))
					.append("', 'YYYY/MM/DD')");
		}

		if (fechaRegistroHasta != null) {
			where.append(" AND ").append("t1.FECHA_REGISTRO<= to_date ('")
					.append(Y41bUtils.parseDateToString(fechaRegistroHasta, Y41bConstantes.EUSKERA))
					.append("', 'YYYY/MM/DD')");
		}

		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<SolicitudTelematicaEventos>) this.jdbcTemplate.query(query.toString(),
				new RowMapper<SolicitudTelematicaEventos>() {
					public SolicitudTelematicaEventos mapRow(ResultSet resultSet, int rowNum) throws SQLException {
						return new SolicitudTelematicaEventos(resultSet.getString("ID_SOLICITUD_TELEMATICA"),
								resultSet.getString("TIPO_EXPEDIENTE"), resultSet.getString("PNOMBRE"),
								resultSet.getString("PNOMBREE"), resultSet.getString("NUM_EXPEDIENTE"),
								resultSet.getDate("FECHA_REGISTRO"), resultSet.getString("NUM_REGISTRO"),
								resultSet.getString("ID_ACCION_TELEMATICA"), resultSet.getClob("XML_SOLICITUD"));
					}
				}, params.toArray());

	}

	/**
	 * Counts rows in the SolicitudesTelematicasEventos table.
	 * 
	 * @param filterSolicitudTelematicaEventos
	 *            BandejaSolicitudes
	 * @param fechaRegistroDesde
	 *            Date
	 * @param fechaRegistroHasta
	 *            Date
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllSolicitudesTelematicasEventosCount(SolicitudTelematicaEventos filterSolicitudTelematicaEventos,
			Date fechaRegistroDesde, Date fechaRegistroHasta) {

		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM SOLICITUD_TELEMATICA t1, TIPO_PROCEDIMIENTO t2 WHERE (1=1) AND t1.TIPO_EXPEDIENTE = t2.PCODIGO ");

		StringBuilder where = new StringBuilder();

		List<Object> params = new ArrayList<Object>();

		if (filterSolicitudTelematicaEventos.getStNumExpediente() != null) {
			where.append(" AND t1.TIPO_EXPEDIENTE= ? ");
			params.add(filterSolicitudTelematicaEventos.getStTipoExpediente());
		}

		if (filterSolicitudTelematicaEventos.getStNumExpediente() != null) {
			where.append(" AND t1.ID_ACCION_TELEMATICA= ? ");
			params.add(filterSolicitudTelematicaEventos.getStIdAccionTelematica());
		}

		if (fechaRegistroDesde != null) {
			query.append(" AND ").append("t1.FECHA_REGISTRO>= to_date ('")
					.append(Y41bUtils.parseDateToString(fechaRegistroDesde, Y41bConstantes.EUSKERA))
					.append("', 'YYYY/MM/DD')");
		}

		if (fechaRegistroHasta != null) {
			query.append(" AND ").append("t1.FECHA_REGISTRO<= to_date ('")
					.append(Y41bUtils.parseDateToString(fechaRegistroHasta, Y41bConstantes.EUSKERA))
					.append("', 'YYYY/MM/DD')");
		}

		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds a single row with clob in the SolicitudTelematicaEventos table.
	 * 
	 * @param solicitudTelematicaEventos
	 *            SolicitudTelematicaEventos
	 * @return SolicitudTelematicaEventos
	 */
	@Transactional(readOnly = true)
	public SolicitudTelematicaEventos findXmlSolicitud(SolicitudTelematicaEventos solicitudTelematicaEventos) {
		String query = "SELECT ID_SOLICITUD_TELEMATICA, XML_SOLICITUD FROM SOLICITUD_TELEMATICA WHERE ID_SOLICITUD_TELEMATICA = ?  ";

		List<SolicitudTelematicaEventos> solicitudList = this.jdbcTemplate.query(query, this.rwMapXmlSolicitud,
				solicitudTelematicaEventos.getStCodigo());
		return (SolicitudTelematicaEventos) DataAccessUtils.uniqueResult(solicitudList);
	}

	/**
	 * Inserts a single row in the SolicitudTelematicaEventos table.
	 * 
	 * @param solicitudTelematicaEventos
	 *            SolicitudTelematicaEventos
	 * @return SolicitudTelematicaEventos
	 */
	public SolicitudTelematicaEventos add(SolicitudTelematicaEventos solicitudTelematicaEventos) {
		String query = "INSERT INTO SOLICITUD_TELEMATICA (ID_SOLICITUD_TELEMATICA, TIPO_EXPEDIENTE, NUM_EXPEDIENTE, FECHA_REGISTRO, NUM_REGISTRO, ID_ACCION_TELEMATICA, XML_SOLICITUD) VALUES (?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, solicitudTelematicaEventos.getStCodigo(),
				solicitudTelematicaEventos.getStTipoExpediente(), solicitudTelematicaEventos.getStNumExpediente(),
				solicitudTelematicaEventos.getStFechaRegistro(), solicitudTelematicaEventos.getStNumRegistro(),
				solicitudTelematicaEventos.getStIdAccionTelematica(),
				Y41bUtils.clobToString(solicitudTelematicaEventos.getStXMLSolicitud()));
		return solicitudTelematicaEventos;
	}

	/**
	 * Finds a single row in the SolicitudTelematicaEventos table.
	 * 
	 * @param solicitudTelematicaEventos
	 *            SolicitudTelematicaEventos
	 * @return SolicitudTelematicaEventos
	 */
	@Transactional(readOnly = true)
	public SolicitudTelematicaEventos find(SolicitudTelematicaEventos solicitudTelematicaEventos) {
		String query = "SELECT t1.ID_SOLICITUD_TELEMATICA ID_SOLICITUD_TELEMATICA, t1.TIPO_EXPEDIENTE TIPO_EXPEDIENTE, t2.PNOMBRE PNOMBRE, t2.PNOMBREE PNOMBREE, t1.NUM_EXPEDIENTE NUM_EXPEDIENTE, t1.FECHA_REGISTRO FECHA_REGISTRO, t1.NUM_REGISTRO NUM_REGISTRO, t1.ID_ACCION_TELEMATICA ID_ACCION_TELEMATICA FROM SOLICITUD_TELEMATICA t1, TIPO_PROCEDIMIENTO t2 WHERE t1.TIPO_EXPEDIENTE=t2.PCODIGO(+)  AND t1.ID_SOLICITUD_TELEMATICA = ?  ";

		List<SolicitudTelematicaEventos> listaSolicitudTelematicaEventos = this.jdbcTemplate.query(query, this.rwMap,
				solicitudTelematicaEventos.getStCodigo());
		return (SolicitudTelematicaEventos) DataAccessUtils.uniqueResult(listaSolicitudTelematicaEventos);
	}

	/**
	 * Removes a single row in the SolicitudTelematicaEventos table.
	 * 
	 * @param solicitudTelematicaEventos
	 *            SolicitudTelematicaEventos
	 * @return
	 */
	public void removeSolicitudTelematicaEventos(SolicitudTelematicaEventos solicitudTelematicaEventos) {
		String query = "DELETE FROM SOLICITUD_TELEMATICA WHERE ID_SOLICITUD_TELEMATICA=?";
		this.jdbcTemplate.update(query, solicitudTelematicaEventos.getStCodigo());
	}
}
