package com.ejie.y41b.dao;

import java.util.Date;
import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.SolicitudTelematicaEventos;

/**
 * BandejaSolicitudesDao  
 * 
 *  
 */

public interface SolicitudesTelematicasEventosDao {

	/**
	 * Finds a List of rows in the SolicitudesTelematicasEventos table.
	 * 
	 * @param filterSolicitudTelematicaEventos
	 *            SolicitudTelematicaEventos
	 * @param fechaRegistroDesde
	 *            Date
	 * @param fechaRegistroHasta
	 *            Date
	 * @param pagination
	 *            Pagination
	 * @return List
	 */

	public List<SolicitudTelematicaEventos> findAllSolicitudesTelematicasEventos(
			SolicitudTelematicaEventos filterSolicitudTelematicaEventos, Date fechaRegistroDesde,
			Date fechaRegistroHasta, Pagination pagination);

	/**
	 * Counts rows in the SolicitudesTelematicasEventos table.
	 * 
	 * @param filterSolicitudTelematicaEventos
	 *            BandejaSolicitudes
	 * @param fechaRegistroDesde
	 *            Date
	 * @param fechaRegistroHasta
	 *            Date
	 * @return Long
	 */
	public Long findAllSolicitudesTelematicasEventosCount(SolicitudTelematicaEventos filterSolicitudTelematicaEventos,
			Date fechaRegistroDesde, Date fechaRegistroHasta);

	/**
	 * Finds a single row with clob in the Solicitud table.
	 * 
	 * @param solicitudTelematicaEventos
	 *            SolicitudTelematicaEventos
	 * @return SolicitudTelematicaEventos
	 */
	SolicitudTelematicaEventos findXmlSolicitud(SolicitudTelematicaEventos solicitudTelematicaEventos);

	/**
	 * Inserts a single row in the SolicitudTelematicaEventos table.
	 * 
	 * @param solicitudTelematicaEventos
	 *            SolicitudTelematicaEventos
	 * @return SolicitudTelematicaEventos
	 */
	SolicitudTelematicaEventos add(SolicitudTelematicaEventos solicitudTelematicaEventos);

	/**
	 * Finds a single row in the Solicitud table.
	 * 
	 * @param solicitudTelematicaEventos
	 *            SolicitudTelematicaEventos
	 * @return SolicitudTelematicaEventos
	 */
	SolicitudTelematicaEventos find(SolicitudTelematicaEventos solicitudTelematicaEventos);

	/**
	 * Removes a single row in the SolicitudTelematicaEventos table.
	 * 
	 * @param solicitudTelematicaEventos
	 *            SolicitudTelematicaEventos
	 * @return
	 */
	public void removeSolicitudTelematicaEventos(SolicitudTelematicaEventos solicitudTelematicaEventos);
}
