package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.SolicitudArbitraje;
import com.ejie.y41b.model.SolicitudArbitrajeDetalle;

/**
 * * SolicitudArbitrajeDao  
 * 
 *  
 */

public interface SolicitudArbitrajeDao {

	/**
	 * Inserts a single row in the SolicitudArbitraje table.
	 * 
	 * @param solicitudarbitraje
	 *            SolicitudArbitraje
	 * @return SolicitudArbitraje
	 */
	SolicitudArbitraje add(SolicitudArbitraje solicitudarbitraje);

	/**
	 * Updates a single row in the SolicitudArbitraje table.
	 * 
	 * @param solicitudarbitraje
	 *            SolicitudArbitraje
	 * @return SolicitudArbitraje
	 */
	SolicitudArbitraje update(SolicitudArbitraje solicitudarbitraje);

	/**
	 * Finds a single row in the SolicitudArbitraje table.
	 * 
	 * @param solicitudarbitraje
	 *            SolicitudArbitraje
	 * @return SolicitudArbitraje
	 */
	SolicitudArbitraje find(SolicitudArbitraje solicitudarbitraje);

	/**
	 * Finds a single row in the SolicitudArbitraje table.
	 * 
	 * @param solicitudArbitrajeDetalle
	 *            SolicitudArbitrajeDetalle
	 * @return SolicitudArbitrajeDetalle
	 */
	@Transactional(readOnly = true)
	SolicitudArbitrajeDetalle findSolicitudArbitraje(
			SolicitudArbitrajeDetalle solicitudArbitrajeDetalle);

	/**
	 * Deletes a single row in the SolicitudArbitraje table.
	 * 
	 * @param solicitudarbitraje
	 *            SolicitudArbitraje
	 * @return
	 */
	void remove(SolicitudArbitraje solicitudarbitraje);

	/**
	 * Finds a List of rows in the SolicitudArbitraje table.
	 * 
	 * @param solicitudarbitraje
	 *            SolicitudArbitraje
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<SolicitudArbitraje> findAll(SolicitudArbitraje solicitudarbitraje,
			Pagination pagination);

	/**
	 * Counts rows in the SolicitudArbitraje table.
	 * 
	 * @param solicitudarbitraje
	 *            SolicitudArbitraje
	 * @return List
	 */
	Long findAllCount(SolicitudArbitraje solicitudarbitraje);

	/**
	 * Finds rows in the SolicitudArbitraje table using like.
	 * 
	 * @param solicitudarbitraje
	 *            SolicitudArbitraje
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<SolicitudArbitraje> findAllLike(SolicitudArbitraje solicitudarbitraje,
			Pagination pagination, Boolean startsWith);
}
