// CHECKSTYLE:OFF
package com.ejie.y41b.dao;

import com.bea.core.repackaged.springframework.dao.IncorrectResultSizeDataAccessException;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y41b.constantes.Y41bADOConstantes;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Arbexp;
import com.ejie.y41b.model.Arbinterv;
import com.ejie.y41b.model.Arbitro;
import com.ejie.y41b.model.Arbtramexp;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Decision;
import com.ejie.y41b.model.Establecimiento;

import com.ejie.y41b.model.ArbFicheroADO;
import com.ejie.y41b.model.ArbPagoArbitroADO;
import com.ejie.y41b.model.Fase;
import com.ejie.y41b.model.FiltroArbitraje;
import com.ejie.y41b.model.Pagosarbitros;
import com.ejie.y41b.model.Tramite;
import com.ejie.y41b.model.Tclugaud;
import com.ejie.y41b.model.Tcmonola;
import com.ejie.y41b.model.Tcmotdes;
import com.ejie.y41b.model.Tcmotina;
import com.ejie.y41b.model.Zddestad;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Solarb;
import com.ejie.y41b.model.SolarbKgest;
import com.ejie.y41b.utils.Y41bUtils;

/**
 * SolarbDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class SolarbDaoImpl implements SolarbDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Solarb> rwMap = new RowMapper<Solarb>() {
		public Solarb mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			List<String> columnasSeleccionadas = Y41bUtils.cargarDatosBDVO(resultSet);

			Solarb solarb = new Solarb(resultSet.getString("SACODIGO"), resultSet.getString("SACOHD"),
					resultSet.getString("SACOJA"), resultSet.getBigDecimal("SANROR"), resultSet.getBigDecimal("SANRAN"),
					resultSet.getDate("SAFESOLI"), resultSet.getString("SANODIDC"), resultSet.getString("SACOLODC"),
					resultSet.getString("SANOLODC"), resultSet.getString("SACOPVDC"), resultSet.getString("SACOMUDC"),
					resultSet.getString("SANRCPDC"), resultSet.getString("SAINACUO"), resultSet.getString("SACOORPR"),
					resultSet.getString("SACOSERE"), resultSet.getString("SACOTTI"), resultSet.getString("SAINTISO"),
					resultSet.getBigDecimal("SACNRECL"), resultSet.getString("SATEOBRC"), resultSet.getDate("SAFEINAD"),
					resultSet.getString("SATEINAD"), resultSet.getDate("SAFEREIT"), resultSet.getDate("SAFETRAS"),
					resultSet.getString("SACOORTR"), resultSet.getDate("SAFERETT"), resultSet.getDate("SAFERETS"),
					resultSet.getDate("SAFEMEDI"), resultSet.getString("SAINREME"), resultSet.getDate("SAFEREMT"),
					resultSet.getDate("SAFEDESI"), resultSet.getDate("SAFEREDT"), resultSet.getDate("SAFENOCO"),
					resultSet.getDate("SAFEREAR"), resultSet.getDate("SAFEDECO"), resultSet.getString("SACOARPT"),
					resultSet.getString("SAINMENCPT"), resultSet.getString("SAINRENCPT"),
					resultSet.getString("SACOARPS"), resultSet.getString("SAINMENCPS"),
					resultSet.getString("SAINRENCPS"), resultSet.getString("SACOARTT"),
					resultSet.getString("SAINMENCTT"), resultSet.getString("SAINRENCTT"),
					resultSet.getString("SACOARTS"), resultSet.getString("SAINMENCTS"),
					resultSet.getString("SAINRENCTS"), resultSet.getString("SACOCCCO"), resultSet.getString("SACOARDT"),
					resultSet.getString("SAINMENCDT"), resultSet.getString("SAINRENCDT"),
					resultSet.getString("SACOARDS"), resultSet.getString("SAINMENCDS"),
					resultSet.getString("SAINRENCDS"), resultSet.getString("SACOOECO"),
					resultSet.getString("SAINMENCST"), resultSet.getString("SAINRENCST"),
					resultSet.getString("SAINMENCSS"), resultSet.getString("SAINRENCSS"),
					resultSet.getString("SAINMENCT"), resultSet.getString("SAINRENCT"), resultSet.getDate("SAFECIAU"),
					resultSet.getString("SAHRCIAU"), resultSet.getString("SANOLURA"), resultSet.getString("SANODIRA"),
					resultSet.getString("SACOLOA"), resultSet.getString("SANRCPA"), resultSet.getString("SAINSOPR"),
					resultSet.getString("SAININPR"), resultSet.getString("SATEOBPR"), resultSet.getString("SACOPE1"),
					resultSet.getBigDecimal("SACNEUPR1"), resultSet.getString("SACOPE2"),
					resultSet.getBigDecimal("SACNEUPR2"), resultSet.getDate("SAFENOPR"),
					resultSet.getString("SAINMENP1"), resultSet.getString("SAINRENP1"),
					resultSet.getString("SAINMENP2"), resultSet.getString("SAINRENP2"),
					resultSet.getString("SAINMENPT"), resultSet.getString("SAINRENPT"), resultSet.getString("SANOLUP"),
					resultSet.getString("SANODIRP"), resultSet.getString("SACOLOP"), resultSet.getString("SANRCOPOP"),
					resultSet.getString("SANOPVP"), resultSet.getString("SANRTELP"), resultSet.getString("SANRFAXP"),
					resultSet.getDate("SAFEREPR"), resultSet.getString("SAHRREPR"), resultSet.getString("SACOARPT2"),
					resultSet.getString("SAINMENCPT2"), resultSet.getString("SAINRENCPT2"),
					resultSet.getString("SACOARPS2"), resultSet.getString("SAINMENCPS2"),
					resultSet.getString("SAINRENCPS2"), resultSet.getString("SACOARTT2"),
					resultSet.getString("SAINMENCTT2"), resultSet.getString("SAINRENCTT2"),
					resultSet.getString("SACOARTS2"), resultSet.getString("SAINMENCTS2"),
					resultSet.getString("SAINRENCTS2"), resultSet.getString("SACOCCCO2"),
					resultSet.getString("SACOARDT2"), resultSet.getString("SAINMENCDT2"),
					resultSet.getString("SAINRENCDT2"), resultSet.getString("SACOARDS2"),
					resultSet.getString("SAINMENCDS2"), resultSet.getString("SAINRENCDS2"),
					resultSet.getString("SACOOECO2"), resultSet.getString("SAINMENCST2"),
					resultSet.getString("SAINRENCST2"), resultSet.getString("SAINMENCSS2"),
					resultSet.getString("SAINRENCSS2"), resultSet.getString("SAINMENCT2"),
					resultSet.getString("SAINRENCT2"), resultSet.getDate("SAFECIAU2"), resultSet.getString("SAHRCIAU2"),
					resultSet.getString("SANOLURA2"), resultSet.getString("SANODIRA2"), resultSet.getString("SACOLOA2"),
					resultSet.getString("SANRCPA2"), resultSet.getDate("SAFELAUD"), resultSet.getString("SATEOBRE"),
					resultSet.getString("SATEMORE"), resultSet.getBigDecimal("SACNEUIL"),
					resultSet.getString("SAINFDLA"), resultSet.getString("SAINVOLA"), resultSet.getString("SAINARNL"),
					resultSet.getDate("SAFENOLT"), resultSet.getString("SAINMELT"), resultSet.getString("SAINPUBO"),
					resultSet.getString("SACOTA1"), resultSet.getDate("SAFESERA"), resultSet.getString("SAINFDRA"),
					resultSet.getDate("SAFEPEEX"), resultSet.getString("SAINRAIN"), resultSet.getString("SAINEFIN"),
					resultSet.getDate("SAFEINEF"), resultSet.getDate("SAFEAR"), resultSet.getDate("SAFENODE"),
					resultSet.getDate("SAFERELT"), resultSet.getDate("SAFENOCA"), resultSet.getDate("SAFENOCA2"),
					resultSet.getDate("SAFENOAR"), resultSet.getString("SACOCCCOS"), resultSet.getString("SACOCCCO2S"),
					resultSet.getString("SACOOECOS"), resultSet.getString("SACOOECO2S"), resultSet.getDate("SAFESOAC"),
					resultSet.getDate("SAFEENAC"), resultSet.getDate("SAFENOAC"), resultSet.getString("SATEFPR1"),
					resultSet.getString("SATEFPR2"), resultSet.getDate("SAFEFPR1"), resultSet.getDate("SAFEFPR2"),
					resultSet.getString("SANRBOPL"), resultSet.getDate("SAFEENIN"), resultSet.getDate("SAFEOPPE"),
					resultSet.getDate("SAFEOPLA"), resultSet.getDate("SAFERECO"), resultSet.getDate("SAFENOLA"),
					resultSet.getDate("SAFENONA"), resultSet.getDate("SAFERENA"), resultSet.getDate("SAFECONA"),
					resultSet.getString("SAPUB"), resultSet.getString("SAINTICA"), resultSet.getString("SACOTIR"),
					resultSet.getString("SACOPS"),
					new Zddestad(resultSet.getString("ZddestadXJCODIGO"), resultSet.getString("ZddestadXJIDEX"),
							resultSet.getString("ZddestadXJNOMBRE"), resultSet.getString("ZddestadXJVALOR")),
					new Tcmotina(resultSet.getString("TcmotinaT5CODIGO"), resultSet.getString("TcmotinaT5NOMBRE"),
							resultSet.getString("TcmotinaT5NOMBREEU")),
					new Tcmonola(resultSet.getString("TcmonolaT7CODIGO"), resultSet.getString("TcmonolaT7NOMBRE")),
					new Tcmotdes(resultSet.getString("TcmotdesTMDCODIGO"), resultSet.getString("TcmotdesTMDNOMBRE")),
					resultSet.getString("SACOSET2"),
					new Tclugaud(resultSet.getString("TclugaudT4CODIGO"), resultSet.getString("TclugaudT4NOMBRE"),
							resultSet.getString("TclugaudT4NOMBREEU"), null, null, null, null, null, null, null, null,
							null, null, null, null, null),
					resultSet.getString("SACOSET"), resultSet.getString("SACOSAAC"), resultSet.getString("SACOSES2"),
					resultSet.getString("SACOSES"));

			Arbexp arbexp = new Arbexp();
			arbexp.setExcodigo(resultSet.getString("EXCODIGO"));
			arbexp.setFase(new Fase(resultSet.getString("EXFCODIGO")));
			arbexp.setExpartrecl(
					(columnasSeleccionadas.contains("EXPARTRECL")) ? resultSet.getString("EXPARTRECL") : null);
			arbexp.setExidparticipacionreclamado((columnasSeleccionadas.contains("EXIDPARTICIPACIONRECLAMADO"))
					? resultSet.getString("EXIDPARTICIPACIONRECLAMADO") : null);
			arbexp.setExidparticipacionreclamante((columnasSeleccionadas.contains("EXIDPARTICIPACIONRECLAMANTE"))
					? resultSet.getString("EXIDPARTICIPACIONRECLAMANTE") : null);

			solarb.setArbexp(arbexp);

			solarb.setXjactivop(
					(columnasSeleccionadas.contains("XJACTIVOP")) ? resultSet.getString("XJACTIVOP") : null);
			solarb.setXjactivopsup(
					(columnasSeleccionadas.contains("XJACTIVOPSUP")) ? resultSet.getString("XJACTIVOPSUP") : null);
			solarb.setXjactivoaacc(
					(columnasSeleccionadas.contains("XJACTIVOAACC")) ? resultSet.getString("XJACTIVOAACC") : null);
			solarb.setXjactivoaaccsup((columnasSeleccionadas.contains("XJACTIVOAACCSUP"))
					? resultSet.getString("XJACTIVOAACCSUP") : null);
			solarb.setXjactivoooee(
					(columnasSeleccionadas.contains("XJACTIVOOOEE")) ? resultSet.getString("XJACTIVOOOEE") : null);
			solarb.setXjactivoooeesup((columnasSeleccionadas.contains("XJACTIVOOOEESUP"))
					? resultSet.getString("XJACTIVOOOEESUP") : null);

			return solarb;
		}
	};

	private RowMapper<FiltroArbitraje> rwMapBusquedaArbitrajeRel = new RowMapper<FiltroArbitraje>() {
		public FiltroArbitraje mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			CensoMonitor censomonitor = new CensoMonitor(resultSet.getString("monitorMOCODIGO"),
					resultSet.getString("monitorMONOMBRE"), null, null, null, null, null, null, null, null, null, null,
					null, null, null, null, null, null, null, null, null, null);
			Arbexp arbexp = new Arbexp(resultSet.getString("ArbexpEXCODIGO"), null, null,
					resultSet.getString("ArbexpEXDESCES"), resultSet.getString("ArbexpEXDESCEU"),
					resultSet.getDate("ArbexpEXFECPREVFIN"), resultSet.getDate("ArbexpEXFECFIN"), null, null, null,
					null, resultSet.getString("ArbexpEXMOCODIGO"), null, null, null, null, null, null, null, null, null,
					null, resultSet.getDate("ArbexpHDFECHD"), null, null, null, null, null, null, null, null, null,
					null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
					null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
					null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
					null);
			arbexp.setExfecini(resultSet.getDate("ArbexpEXFECINI"));

			Establecimiento establecimiento = new Establecimiento(resultSet.getString("ESCODIGO"));
			return new FiltroArbitraje(resultSet.getString("SACODIGO"), resultSet.getString("SACOJA"),
					resultSet.getBigDecimal("SANRAN"), resultSet.getBigDecimal("SANROR"),
					resultSet.getString("SACOJA") + Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP
							+ resultSet.getBigDecimal("SANROR") + Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP
							+ resultSet.getBigDecimal("SANRAN"),
					resultSet.getDate("SAFESOLI"), resultSet.getString("MOCODIGO"), establecimiento, arbexp, null, null,
					censomonitor, null, null, resultSet.getDate("ArbexpEXFECFIN"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Solarb table.
	 * 
	 * @param solarb
	 *            Pagination
	 * @return Solarb
	 */
	public Solarb add(Solarb solarb) {
		String query = "INSERT INTO SOLARB (SACODIGO, SACOXJ, SACOT5, SACOT7, SACOTMD, SACOSET2, SACOT4, SACOSET, SACOSAAC, SACOSES2, SACOSES, SACOHD, SACOJA, SANROR, SANRAN, SAFESOLI, SANODIDC, SACOLODC, SANOLODC, SACOPVDC, SACOMUDC, SANRCPDC, SAINACUO, SACOORPR, SACOSERE, SACOTTI, SAINTISO, SACNRECL, SATEOBRC, SAFEINAD, SATEINAD, SAFEREIT, SAFETRAS, SACOORTR, SAFERETT, SAFERETS, SAFEMEDI, SAINREME, SAFEREMT, SAFEDESI, SAFEREDT, SAFENOCO, SAFEREAR, SAFEDECO, SACOARPT, SAINMENCPT, SAINRENCPT, SACOARPS, SAINMENCPS, SAINRENCPS, SACOARTT, SAINMENCTT, SAINRENCTT, SACOARTS, SAINMENCTS, SAINRENCTS, SACOCCCO, SACOARDT, SAINMENCDT, SAINRENCDT, SACOARDS, SAINMENCDS, SAINRENCDS, SACOOECO, SAINMENCST, SAINRENCST, SAINMENCSS, SAINRENCSS, SAINMENCT, SAINRENCT, SAFECIAU, SAHRCIAU, SANOLURA, SANODIRA, SACOLOA, SANRCPA, SAINSOPR, SAININPR, SATEOBPR, SACOPE1, SACNEUPR1, SACOPE2, SACNEUPR2, SAFENOPR, SAINMENP1, SAINRENP1, SAINMENP2, SAINRENP2, SAINMENPT, SAINRENPT, SANOLUP, SANODIRP, SACOLOP, SANRCOPOP, SANOPVP, SANRTELP, SANRFAXP, SAFEREPR, SAHRREPR, SACOARPT2, SAINMENCPT2, SAINRENCPT2, SACOARPS2, SAINMENCPS2, SAINRENCPS2, SACOARTT2, SAINMENCTT2, SAINRENCTT2, SACOARTS2, SAINMENCTS2, SAINRENCTS2, SACOCCCO2, SACOARDT2, SAINMENCDT2, SAINRENCDT2, SACOARDS2, SAINMENCDS2, SAINRENCDS2, SACOOECO2, SAINMENCST2, SAINRENCST2, SAINMENCSS2, SAINRENCSS2, SAINMENCT2, SAINRENCT2, SAFECIAU2, SAHRCIAU2, SANOLURA2, SANODIRA2, SACOLOA2, SANRCPA2, SAFELAUD, SATEOBRE, SATEMORE, SACNEUIL, SAINFDLA, SAINVOLA, SAINARNL, SAFENOLT, SAINMELT, SAINPUBO, SACOTA1, SAFESERA, SAINFDRA, SAFEPEEX, SAINRAIN, SAINEFIN, SAFEINEF, SAFEAR, SAFENODE, SAFERELT, SAFENOCA, SAFENOCA2, SAFENOAR, SACOCCCOS, SACOCCCO2S, SACOOECOS, SACOOECO2S, SAFESOAC, SAFEENAC, SAFENOAC, SATEFPR1, SATEFPR2, SAFEFPR1, SAFEFPR2, SANRBOPL, SAFEENIN, SAFEOPPE, SAFEOPLA, SAFERECO, SAFENOLA, SAFENONA, SAFERENA, SAFECONA, SAPUB, SAINTICA, SACOTIR, SACOPS) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		Object getZddestadXjcodigoAux = null;
		if (solarb.getZddestad() != null && solarb.getZddestad().getXjcodigo() != null) {
			getZddestadXjcodigoAux = solarb.getZddestad().getXjcodigo();
		}
		Object getTcmotinaT5codigoAux = null;
		if (solarb.getTcmotina() != null && solarb.getTcmotina().getT5codigo() != null) {
			getTcmotinaT5codigoAux = solarb.getTcmotina().getT5codigo();
		}
		Object getTcmonolaT7codigoAux = null;
		if (solarb.getTcmonola() != null && solarb.getTcmonola().getT7codigo() != null) {
			getTcmonolaT7codigoAux = solarb.getTcmonola().getT7codigo();
		}
		Object getTcmotdesTmdcodigoAux = null;
		if (solarb.getTcmotdes() != null && solarb.getTcmotdes().getTmdcodigo() != null) {
			getTcmotdesTmdcodigoAux = solarb.getTcmotdes().getTmdcodigo();
		}
		Object getTclugaudT4codigoAux = null;
		if (solarb.getTclugaud() != null && solarb.getTclugaud().getT4codigo() != null) {
			getTclugaudT4codigoAux = solarb.getTclugaud().getT4codigo();
		}

		this.jdbcTemplate.update(query, solarb.getSacodigo(), getZddestadXjcodigoAux, getTcmotinaT5codigoAux,
				getTcmonolaT7codigoAux, getTcmotdesTmdcodigoAux, solarb.getSacoset2(), getTclugaudT4codigoAux,
				solarb.getSacoset(), solarb.getSacosaac(), solarb.getSacoses2(), solarb.getSacoses(),
				solarb.getSacohd(), solarb.getSacoja(), solarb.getSanror(), solarb.getSanran(), solarb.getSafesoli(),
				solarb.getSanodidc(), solarb.getSacolodc(), solarb.getSanolodc(), solarb.getSacopvdc(),
				solarb.getSacomudc(), solarb.getSanrcpdc(), solarb.getSainacuo(), solarb.getSacoorpr(),
				solarb.getSacosere(), solarb.getSacotti(), solarb.getSaintiso(), solarb.getSacnrecl(),
				solarb.getSateobrc(), solarb.getSafeinad(), solarb.getSateinad(), solarb.getSafereit(),
				solarb.getSafetras(), solarb.getSacoortr(), solarb.getSaferett(), solarb.getSaferets(),
				solarb.getSafemedi(), solarb.getSainreme(), solarb.getSaferemt(), solarb.getSafedesi(),
				solarb.getSaferedt(), solarb.getSafenoco(), solarb.getSaferear(), solarb.getSafedeco(),
				solarb.getSacoarpt(), solarb.getSainmencpt(), solarb.getSainrencpt(), solarb.getSacoarps(),
				solarb.getSainmencps(), solarb.getSainrencps(), solarb.getSacoartt(), solarb.getSainmenctt(),
				solarb.getSainrenctt(), solarb.getSacoarts(), solarb.getSainmencts(), solarb.getSainrencts(),
				solarb.getSacoccco(), solarb.getSacoardt(), solarb.getSainmencdt(), solarb.getSainrencdt(),
				solarb.getSacoards(), solarb.getSainmencds(), solarb.getSainrencds(), solarb.getSacooeco(),
				solarb.getSainmencst(), solarb.getSainrencst(), solarb.getSainmencss(), solarb.getSainrencss(),
				solarb.getSainmenct(), solarb.getSainrenct(), solarb.getSafeciau(), solarb.getSahrciau(),
				solarb.getSanolura(), solarb.getSanodira(), solarb.getSacoloa(), solarb.getSanrcpa(),
				solarb.getSainsopr(), solarb.getSaininpr(), solarb.getSateobpr(), solarb.getSacope1(),
				solarb.getSacneupr1(), solarb.getSacope2(), solarb.getSacneupr2(), solarb.getSafenopr(),
				solarb.getSainmenp1(), solarb.getSainrenp1(), solarb.getSainmenp2(), solarb.getSainrenp2(),
				solarb.getSainmenpt(), solarb.getSainrenpt(), solarb.getSanolup(), solarb.getSanodirp(),
				solarb.getSacolop(), solarb.getSanrcopop(), solarb.getSanopvp(), solarb.getSanrtelp(),
				solarb.getSanrfaxp(), solarb.getSaferepr(), solarb.getSahrrepr(), solarb.getSacoarpt2(),
				solarb.getSainmencpt2(), solarb.getSainrencpt2(), solarb.getSacoarps2(), solarb.getSainmencps2(),
				solarb.getSainrencps2(), solarb.getSacoartt2(), solarb.getSainmenctt2(), solarb.getSainrenctt2(),
				solarb.getSacoarts2(), solarb.getSainmencts2(), solarb.getSainrencts2(), solarb.getSacoccco2(),
				solarb.getSacoardt2(), solarb.getSainmencdt2(), solarb.getSainrencdt2(), solarb.getSacoards2(),
				solarb.getSainmencds2(), solarb.getSainrencds2(), solarb.getSacooeco2(), solarb.getSainmencst2(),
				solarb.getSainrencst2(), solarb.getSainmencss2(), solarb.getSainrencss2(), solarb.getSainmenct2(),
				solarb.getSainrenct2(), solarb.getSafeciau2(), solarb.getSahrciau2(), solarb.getSanolura2(),
				solarb.getSanodira2(), solarb.getSacoloa2(), solarb.getSanrcpa2(), solarb.getSafelaud(),
				solarb.getSateobre(), solarb.getSatemore(), solarb.getSacneuil(), solarb.getSainfdla(),
				solarb.getSainvola(), solarb.getSainarnl(), solarb.getSafenolt(), solarb.getSainmelt(),
				solarb.getSainpubo(), solarb.getSacota1(), solarb.getSafesera(), solarb.getSainfdra(),
				solarb.getSafepeex(), solarb.getSainrain(), solarb.getSainefin(), solarb.getSafeinef(),
				solarb.getSafear(), solarb.getSafenode(), solarb.getSaferelt(), solarb.getSafenoca(),
				solarb.getSafenoca2(), solarb.getSafenoar(), solarb.getSacocccos(), solarb.getSacoccco2s(),
				solarb.getSacooecos(), solarb.getSacooeco2s(), solarb.getSafesoac(), solarb.getSafeenac(),
				solarb.getSafenoac(), solarb.getSatefpr1(), solarb.getSatefpr2(), solarb.getSafefpr1(),
				solarb.getSafefpr2(), solarb.getSanrbopl(), solarb.getSafeenin(), solarb.getSafeoppe(),
				solarb.getSafeopla(), solarb.getSafereco(), solarb.getSafenola(), solarb.getSafenona(),
				solarb.getSaferena(), solarb.getSafecona(), solarb.getSapub(), solarb.getSaintica(),
				solarb.getSacotir(), solarb.getSacops());
		return solarb;
	}

	/**
	 * Updates a single row in the Solarb table.
	 * 
	 * @param solarb
	 *            Pagination
	 * @return Solarb
	 */
	public Solarb update(Solarb solarb) {
		String query = "UPDATE SOLARB SET SACOXJ=?, SACOT5=?, SACOT7=?, SACOTMD=?, SACOSET2=?, SACOT4=?, SACOSET=?, SACOSAAC=?, SACOSES2=?, SACOSES=?, SACOHD=?, SACOJA=?, SANROR=?, SANRAN=?, SAFESOLI=?, SANODIDC=?, SACOLODC=?, SANOLODC=?, SACOPVDC=?, SACOMUDC=?, SANRCPDC=?, SAINACUO=?, SACOORPR=?, SACOSERE=?, SACOTTI=?, SAINTISO=?, SACNRECL=?, SATEOBRC=?, SAFEINAD=?, SATEINAD=?, SAFEREIT=?, SAFETRAS=?, SACOORTR=?, SAFERETT=?, SAFERETS=?, SAFEMEDI=?, SAINREME=?, SAFEREMT=?, SAFEDESI=?, SAFEREDT=?, SAFENOCO=?, SAFEREAR=?, SAFEDECO=?, SACOARPT=?, SAINMENCPT=?, SAINRENCPT=?, SACOARPS=?, SAINMENCPS=?, SAINRENCPS=?, SACOARTT=?, SAINMENCTT=?, SAINRENCTT=?, SACOARTS=?, SAINMENCTS=?, SAINRENCTS=?, SACOCCCO=?, SACOARDT=?, SAINMENCDT=?, SAINRENCDT=?, SACOARDS=?, SAINMENCDS=?, SAINRENCDS=?, SACOOECO=?, SAINMENCST=?, SAINRENCST=?, SAINMENCSS=?, SAINRENCSS=?, SAINMENCT=?, SAINRENCT=?, SAFECIAU=?, SAHRCIAU=?, SANOLURA=?, SANODIRA=?, SACOLOA=?, SANRCPA=?, SAINSOPR=?, SAININPR=?, SATEOBPR=?, SACOPE1=?, SACNEUPR1=?, SACOPE2=?, SACNEUPR2=?, SAFENOPR=?, SAINMENP1=?, SAINRENP1=?, SAINMENP2=?, SAINRENP2=?, SAINMENPT=?, SAINRENPT=?, SANOLUP=?, SANODIRP=?, SACOLOP=?, SANRCOPOP=?, SANOPVP=?, SANRTELP=?, SANRFAXP=?, SAFEREPR=?, SAHRREPR=?, SACOARPT2=?, SAINMENCPT2=?, SAINRENCPT2=?, SACOARPS2=?, SAINMENCPS2=?, SAINRENCPS2=?, SACOARTT2=?, SAINMENCTT2=?, SAINRENCTT2=?, SACOARTS2=?, SAINMENCTS2=?, SAINRENCTS2=?, SACOCCCO2=?, SACOARDT2=?, SAINMENCDT2=?, SAINRENCDT2=?, SACOARDS2=?, SAINMENCDS2=?, SAINRENCDS2=?, SACOOECO2=?, SAINMENCST2=?, SAINRENCST2=?, SAINMENCSS2=?, SAINRENCSS2=?, SAINMENCT2=?, SAINRENCT2=?, SAFECIAU2=?, SAHRCIAU2=?, SANOLURA2=?, SANODIRA2=?, SACOLOA2=?, SANRCPA2=?, SAFELAUD=?, SATEOBRE=?, SATEMORE=?, SACNEUIL=?, SAINFDLA=?, SAINVOLA=?, SAINARNL=?, SAFENOLT=?, SAINMELT=?, SAINPUBO=?, SACOTA1=?, SAFESERA=?, SAINFDRA=?, SAFEPEEX=?, SAINRAIN=?, SAINEFIN=?, SAFEINEF=?, SAFEAR=?, SAFENODE=?, SAFERELT=?, SAFENOCA=?, SAFENOCA2=?, SAFENOAR=?, SACOCCCOS=?, SACOCCCO2S=?, SACOOECOS=?, SACOOECO2S=?, SAFESOAC=?, SAFEENAC=?, SAFENOAC=?, SATEFPR1=?, SATEFPR2=?, SAFEFPR1=?, SAFEFPR2=?, SANRBOPL=?, SAFEENIN=?, SAFEOPPE=?, SAFEOPLA=?, SAFERECO=?, SAFENOLA=?, SAFENONA=?, SAFERENA=?, SAFECONA=?, SAPUB=?, SAINTICA=?, SACOTIR=?, SACOPS=? WHERE SACODIGO=?";
		Object getZddestadXjcodigoAux = null;
		if (solarb.getZddestad() != null && solarb.getZddestad().getXjcodigo() != null) {
			getZddestadXjcodigoAux = solarb.getZddestad().getXjcodigo();
		}
		Object getTcmotinaT5codigoAux = null;
		if (solarb.getTcmotina() != null && solarb.getTcmotina().getT5codigo() != null) {
			getTcmotinaT5codigoAux = solarb.getTcmotina().getT5codigo();
		}
		Object getTcmonolaT7codigoAux = null;
		if (solarb.getTcmonola() != null && solarb.getTcmonola().getT7codigo() != null) {
			getTcmonolaT7codigoAux = solarb.getTcmonola().getT7codigo();
		}
		Object getTcmotdesTmdcodigoAux = null;
		if (solarb.getTcmotdes() != null && solarb.getTcmotdes().getTmdcodigo() != null) {
			getTcmotdesTmdcodigoAux = solarb.getTcmotdes().getTmdcodigo();
		}
		Object getTclugaudT4codigoAux = null;
		if (solarb.getTclugaud() != null && solarb.getTclugaud().getT4codigo() != null) {
			getTclugaudT4codigoAux = solarb.getTclugaud().getT4codigo();
		}
		this.jdbcTemplate.update(query, getZddestadXjcodigoAux, getTcmotinaT5codigoAux, getTcmonolaT7codigoAux,
				getTcmotdesTmdcodigoAux, solarb.getSacoset2(), getTclugaudT4codigoAux, solarb.getSacoset(),
				solarb.getSacosaac(), solarb.getSacoses2(), solarb.getSacoses(), solarb.getSacohd(), solarb.getSacoja(),
				solarb.getSanror(), solarb.getSanran(), solarb.getSafesoli(), solarb.getSanodidc(),
				solarb.getSacolodc(), solarb.getSanolodc(), solarb.getSacopvdc(), solarb.getSacomudc(),
				solarb.getSanrcpdc(), solarb.getSainacuo(), solarb.getSacoorpr(), solarb.getSacosere(),
				solarb.getSacotti(), solarb.getSaintiso(), solarb.getSacnrecl(), solarb.getSateobrc(),
				solarb.getSafeinad(), solarb.getSateinad(), solarb.getSafereit(), solarb.getSafetras(),
				solarb.getSacoortr(), solarb.getSaferett(), solarb.getSaferets(), solarb.getSafemedi(),
				solarb.getSainreme(), solarb.getSaferemt(), solarb.getSafedesi(), solarb.getSaferedt(),
				solarb.getSafenoco(), solarb.getSaferear(), solarb.getSafedeco(), solarb.getSacoarpt(),
				solarb.getSainmencpt(), solarb.getSainrencpt(), solarb.getSacoarps(), solarb.getSainmencps(),
				solarb.getSainrencps(), solarb.getSacoartt(), solarb.getSainmenctt(), solarb.getSainrenctt(),
				solarb.getSacoarts(), solarb.getSainmencts(), solarb.getSainrencts(), solarb.getSacoccco(),
				solarb.getSacoardt(), solarb.getSainmencdt(), solarb.getSainrencdt(), solarb.getSacoards(),
				solarb.getSainmencds(), solarb.getSainrencds(), solarb.getSacooeco(), solarb.getSainmencst(),
				solarb.getSainrencst(), solarb.getSainmencss(), solarb.getSainrencss(), solarb.getSainmenct(),
				solarb.getSainrenct(), solarb.getSafeciau(), solarb.getSahrciau(), solarb.getSanolura(),
				solarb.getSanodira(), solarb.getSacoloa(), solarb.getSanrcpa(), solarb.getSainsopr(),
				solarb.getSaininpr(), solarb.getSateobpr(), solarb.getSacope1(), solarb.getSacneupr1(),
				solarb.getSacope2(), solarb.getSacneupr2(), solarb.getSafenopr(), solarb.getSainmenp1(),
				solarb.getSainrenp1(), solarb.getSainmenp2(), solarb.getSainrenp2(), solarb.getSainmenpt(),
				solarb.getSainrenpt(), solarb.getSanolup(), solarb.getSanodirp(), solarb.getSacolop(),
				solarb.getSanrcopop(), solarb.getSanopvp(), solarb.getSanrtelp(), solarb.getSanrfaxp(),
				solarb.getSaferepr(), solarb.getSahrrepr(), solarb.getSacoarpt2(), solarb.getSainmencpt2(),
				solarb.getSainrencpt2(), solarb.getSacoarps2(), solarb.getSainmencps2(), solarb.getSainrencps2(),
				solarb.getSacoartt2(), solarb.getSainmenctt2(), solarb.getSainrenctt2(), solarb.getSacoarts2(),
				solarb.getSainmencts2(), solarb.getSainrencts2(), solarb.getSacoccco2(), solarb.getSacoardt2(),
				solarb.getSainmencdt2(), solarb.getSainrencdt2(), solarb.getSacoards2(), solarb.getSainmencds2(),
				solarb.getSainrencds2(), solarb.getSacooeco2(), solarb.getSainmencst2(), solarb.getSainrencst2(),
				solarb.getSainmencss2(), solarb.getSainrencss2(), solarb.getSainmenct2(), solarb.getSainrenct2(),
				solarb.getSafeciau2(), solarb.getSahrciau2(), solarb.getSanolura2(), solarb.getSanodira2(),
				solarb.getSacoloa2(), solarb.getSanrcpa2(), solarb.getSafelaud(), solarb.getSateobre(),
				solarb.getSatemore(), solarb.getSacneuil(), solarb.getSainfdla(), solarb.getSainvola(),
				solarb.getSainarnl(), solarb.getSafenolt(), solarb.getSainmelt(), solarb.getSainpubo(),
				solarb.getSacota1(), solarb.getSafesera(), solarb.getSainfdra(), solarb.getSafepeex(),
				solarb.getSainrain(), solarb.getSainefin(), solarb.getSafeinef(), solarb.getSafear(),
				solarb.getSafenode(), solarb.getSaferelt(), solarb.getSafenoca(), solarb.getSafenoca2(),
				solarb.getSafenoar(), solarb.getSacocccos(), solarb.getSacoccco2s(), solarb.getSacooecos(),
				solarb.getSacooeco2s(), solarb.getSafesoac(), solarb.getSafeenac(), solarb.getSafenoac(),
				solarb.getSatefpr1(), solarb.getSatefpr2(), solarb.getSafefpr1(), solarb.getSafefpr2(),
				solarb.getSanrbopl(), solarb.getSafeenin(), solarb.getSafeoppe(), solarb.getSafeopla(),
				solarb.getSafereco(), solarb.getSafenola(), solarb.getSafenona(), solarb.getSaferena(),
				solarb.getSafecona(), solarb.getSapub(), solarb.getSaintica(), solarb.getSacotir(), solarb.getSacops(),
				solarb.getSacodigo());
		return solarb;
	}

	/**
	 * Finds a single row in the Solarb table.
	 * 
	 * @param solarb
	 *            Pagination
	 * @return Solarb
	 */
	@Transactional(readOnly = true)
	public Solarb find(Solarb solarb) {
		String query = "SELECT t1.SACODIGO SACODIGO, t1.SACOPS SACOPS, t1.SACOHD SACOHD, t1.SACOJA SACOJA, t1.SANROR SANROR, t1.SANRAN SANRAN, t1.SAFESOLI SAFESOLI, t1.SANODIDC SANODIDC, t1.SACOLODC SACOLODC, t1.SANOLODC SANOLODC, t1.SACOPVDC SACOPVDC, t1.SACOMUDC SACOMUDC, t1.SANRCPDC SANRCPDC, t1.SAINACUO SAINACUO, t1.SACOORPR SACOORPR, t1.SACOSERE SACOSERE, t1.SACOTTI SACOTTI, t1.SAINTISO SAINTISO, t1.SACNRECL SACNRECL, t1.SATEOBRC SATEOBRC, t1.SAFEINAD SAFEINAD, t1.SATEINAD SATEINAD, t1.SAFEREIT SAFEREIT, t1.SAFETRAS SAFETRAS, t1.SACOORTR SACOORTR, t1.SAFERETT SAFERETT, t1.SAFERETS SAFERETS, t1.SAFEMEDI SAFEMEDI, t1.SAINREME SAINREME, t1.SAFEREMT SAFEREMT, t1.SAFEDESI SAFEDESI, t1.SAFEREDT SAFEREDT, t1.SAFENOCO SAFENOCO, t1.SAFEREAR SAFEREAR, t1.SAFEDECO SAFEDECO, t1.SACOARPT SACOARPT, t1.SAINMENCPT SAINMENCPT, t1.SAINRENCPT SAINRENCPT, t1.SACOARPS SACOARPS, t1.SAINMENCPS SAINMENCPS, t1.SAINRENCPS SAINRENCPS, t1.SACOARTT SACOARTT, t1.SAINMENCTT SAINMENCTT, t1.SAINRENCTT SAINRENCTT, t1.SACOARTS SACOARTS, t1.SAINMENCTS SAINMENCTS, t1.SAINRENCTS SAINRENCTS, t1.SACOCCCO SACOCCCO, t1.SACOARDT SACOARDT, t1.SAINMENCDT SAINMENCDT, t1.SAINRENCDT SAINRENCDT, t1.SACOARDS SACOARDS, t1.SAINMENCDS SAINMENCDS, t1.SAINRENCDS SAINRENCDS, t1.SACOOECO SACOOECO, t1.SAINMENCST SAINMENCST, t1.SAINRENCST SAINRENCST, t1.SAINMENCSS SAINMENCSS, t1.SAINRENCSS SAINRENCSS, t1.SAINMENCT SAINMENCT, t1.SAINRENCT SAINRENCT, t1.SAFECIAU SAFECIAU, t1.SAHRCIAU SAHRCIAU, t1.SANOLURA SANOLURA, t1.SANODIRA SANODIRA, t1.SACOLOA SACOLOA, t1.SANRCPA SANRCPA, t1.SAINSOPR SAINSOPR, t1.SAININPR SAININPR, t1.SATEOBPR SATEOBPR, t1.SACOPE1 SACOPE1, t1.SACNEUPR1 SACNEUPR1, t1.SACOPE2 SACOPE2, t1.SACNEUPR2 SACNEUPR2, t1.SAFENOPR SAFENOPR, t1.SAINMENP1 SAINMENP1, t1.SAINRENP1 SAINRENP1, t1.SAINMENP2 SAINMENP2, t1.SAINRENP2 SAINRENP2, t1.SAINMENPT SAINMENPT, t1.SAINRENPT SAINRENPT, t1.SANOLUP SANOLUP, t1.SANODIRP SANODIRP, t1.SACOLOP SACOLOP, t1.SANRCOPOP SANRCOPOP, t1.SANOPVP SANOPVP, t1.SANRTELP SANRTELP, t1.SANRFAXP SANRFAXP, t1.SAFEREPR SAFEREPR, t1.SAHRREPR SAHRREPR, t1.SACOARPT2 SACOARPT2, t1.SAINMENCPT2 SAINMENCPT2, t1.SAINRENCPT2 SAINRENCPT2, t1.SACOARPS2 SACOARPS2, t1.SAINMENCPS2 SAINMENCPS2, t1.SAINRENCPS2 SAINRENCPS2, t1.SACOARTT2 SACOARTT2, t1.SAINMENCTT2 SAINMENCTT2, t1.SAINRENCTT2 SAINRENCTT2, t1.SACOARTS2 SACOARTS2, t1.SAINMENCTS2 SAINMENCTS2, t1.SAINRENCTS2 SAINRENCTS2, t1.SACOCCCO2 SACOCCCO2, t1.SACOARDT2 SACOARDT2, t1.SAINMENCDT2 SAINMENCDT2, t1.SAINRENCDT2 SAINRENCDT2, t1.SACOARDS2 SACOARDS2, t1.SAINMENCDS2 SAINMENCDS2, t1.SAINRENCDS2 SAINRENCDS2, t1.SACOOECO2 SACOOECO2, t1.SAINMENCST2 SAINMENCST2, t1.SAINRENCST2 SAINRENCST2, t1.SAINMENCSS2 SAINMENCSS2, t1.SAINRENCSS2 SAINRENCSS2, t1.SAINMENCT2 SAINMENCT2, t1.SAINRENCT2 SAINRENCT2, t1.SAFECIAU2 SAFECIAU2, t1.SAHRCIAU2 SAHRCIAU2, t1.SANOLURA2 SANOLURA2, t1.SANODIRA2 SANODIRA2, t1.SACOLOA2 SACOLOA2, t1.SANRCPA2 SANRCPA2, t1.SAFELAUD SAFELAUD, t1.SATEOBRE SATEOBRE, t1.SATEMORE SATEMORE, t1.SACNEUIL SACNEUIL, t1.SAINFDLA SAINFDLA, t1.SAINVOLA SAINVOLA, t1.SAINARNL SAINARNL, t1.SAFENOLT SAFENOLT, t1.SAINMELT SAINMELT, t1.SAINPUBO SAINPUBO, t1.SACOTA1 SACOTA1, t1.SAFESERA SAFESERA, t1.SAINFDRA SAINFDRA, t1.SAFEPEEX SAFEPEEX, t1.SAINRAIN SAINRAIN, t1.SAINEFIN SAINEFIN, t1.SAFEINEF SAFEINEF, t1.SAFEAR SAFEAR, t1.SAFENODE SAFENODE, t1.SAFERELT SAFERELT, t1.SAFENOCA SAFENOCA, t1.SAFENOCA2 SAFENOCA2, t1.SAFENOAR SAFENOAR, t1.SACOCCCOS SACOCCCOS, t1.SACOCCCO2S SACOCCCO2S, t1.SACOOECOS SACOOECOS, t1.SACOOECO2S SACOOECO2S, t1.SAFESOAC SAFESOAC, t1.SAFEENAC SAFEENAC, t1.SAFENOAC SAFENOAC, t1.SATEFPR1 SATEFPR1, t1.SATEFPR2 SATEFPR2, t1.SAFEFPR1 SAFEFPR1, t1.SAFEFPR2 SAFEFPR2, t1.SANRBOPL SANRBOPL, t1.SAFEENIN SAFEENIN, t1.SAFEOPPE SAFEOPPE, t1.SAFEOPLA SAFEOPLA, t1.SAFERECO SAFERECO, t1.SAFENOLA SAFENOLA, t1.SAFENONA SAFENONA, t1.SAFERENA SAFERENA, t1.SAFECONA SAFECONA, t1.SAPUB SAPUB, t1.SAINTICA SAINTICA, t1.SACOTIR SACOTIR, t1.SACOPS SACOPS, t1.SACOSAAC SACOSAAC, t1.SACOSET2 SACOSET2, t1.SACOSET SACOSET, t1.SACOSES2 SACOSES2,t1.SACOSES SACOSES, t2.XJCODIGO ZDDESTADXJCODIGO, t2.XJIDEX ZDDESTADXJIDEX, t2.XJNOMBRE ZDDESTADXJNOMBRE, t2.XJVALOR ZDDESTADXJVALOR, t3.T5CODIGO TCMOTINAT5CODIGO, t3.T5NOMBRE TCMOTINAT5NOMBRE,t3.T5NOMBREEU TCMOTINAT5NOMBREEU, t4.T7CODIGO TCMONOLAT7CODIGO, t4.T7NOMBRE TCMONOLAT7NOMBRE, t5.TMDCODIGO TCMOTDESTMDCODIGO, t5.TMDNOMBRE TCMOTDESTMDNOMBRE, t7.T4CODIGO TCLUGAUDT4CODIGO, t7.T4NOMBRE TCLUGAUDT4NOMBRE, t7.T4NOMBRE TCLUGAUDT4NOMBREEU, t8.EXIDPARTICIPACIONRECLAMANTE, t8.EXIDPARTICIPACIONRECLAMADO "
				+ " ,t8.EXCODIGO EXCODIGO, t8.EXFCODIGO EXFCODIGO, t8.EXPARTRECL EXPARTRECL "
				+ " FROM SOLARB t1 , ZDDESTAD t2 , TCMOTINA t3 , TCMONOLA t4 , TCMOTDES t5 , TCLUGAUD t7, ARBEXP t8  WHERE t1.SACODIGO = ? AND t1.SACODIGO=t8.EXCODIGO(+) AND t1.SACOXJ= t2.XJCODIGO(+) AND t1.SACOT5= t3.T5CODIGO(+) AND t1.SACOT7= t4.T7CODIGO(+) AND t1.SACOTMD= t5.TMDCODIGO(+) AND t1.SACOT4= t7.T4CODIGO(+) ";

		List<Solarb> solarbList = this.jdbcTemplate.query(query, this.rwMap, solarb.getSacodigo());
		return (Solarb) DataAccessUtils.uniqueResult(solarbList);
	}

	/**
	 * Removes a single row in the Solarb table.
	 * 
	 * @param solarb
	 *            Pagination
	 * @return
	 */
	public void remove(Solarb solarb) {
		String query = "DELETE FROM SOLARB WHERE SACODIGO=?";
		this.jdbcTemplate.update(query, solarb.getSacodigo());
	}

	/**
	 * Finds a List of rows in the Solarb table.
	 * 
	 * @param solarb
	 *            Solarb
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Solarb> findAll(Solarb solarb, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT t1.SACODIGO SACODIGO,t1.SACOHD SACOHD,t1.SACOJA SACOJA,t1.SANROR SANROR,t1.SANRAN SANRAN,t1.SAFESOLI SAFESOLI,t1.SANODIDC SANODIDC,t1.SACOLODC SACOLODC,t1.SANOLODC SANOLODC,t1.SACOPVDC SACOPVDC,t1.SACOMUDC SACOMUDC,t1.SANRCPDC SANRCPDC,t1.SAINACUO SAINACUO,t1.SACOORPR SACOORPR,t1.SACOSERE SACOSERE,t1.SACOTTI SACOTTI,t1.SAINTISO SAINTISO,t1.SACNRECL SACNRECL,t1.SATEOBRC SATEOBRC,t1.SAFEINAD SAFEINAD,t1.SATEINAD SATEINAD,t1.SAFEREIT SAFEREIT,t1.SAFETRAS SAFETRAS,t1.SACOORTR SACOORTR,t1.SAFERETT SAFERETT,t1.SAFERETS SAFERETS,t1.SAFEMEDI SAFEMEDI,t1.SAINREME SAINREME,t1.SAFEREMT SAFEREMT,t1.SAFEDESI SAFEDESI,t1.SAFEREDT SAFEREDT,t1.SAFENOCO SAFENOCO,t1.SAFEREAR SAFEREAR,t1.SAFEDECO SAFEDECO,t1.SACOARPT SACOARPT,t1.SAINMENCPT SAINMENCPT,t1.SAINRENCPT SAINRENCPT,t1.SACOARPS SACOARPS,t1.SAINMENCPS SAINMENCPS,t1.SAINRENCPS SAINRENCPS,t1.SACOARTT SACOARTT,t1.SAINMENCTT SAINMENCTT,t1.SAINRENCTT SAINRENCTT,t1.SACOARTS SACOARTS,t1.SAINMENCTS SAINMENCTS,t1.SAINRENCTS SAINRENCTS,t1.SACOCCCO SACOCCCO,t1.SACOARDT SACOARDT,t1.SAINMENCDT SAINMENCDT,t1.SAINRENCDT SAINRENCDT,t1.SACOARDS SACOARDS,t1.SAINMENCDS SAINMENCDS,t1.SAINRENCDS SAINRENCDS,t1.SACOOECO SACOOECO,t1.SAINMENCST SAINMENCST,t1.SAINRENCST SAINRENCST,t1.SAINMENCSS SAINMENCSS,t1.SAINRENCSS SAINRENCSS,t1.SAINMENCT SAINMENCT,t1.SAINRENCT SAINRENCT,t1.SAFECIAU SAFECIAU,t1.SAHRCIAU SAHRCIAU,t1.SANOLURA SANOLURA,t1.SANODIRA SANODIRA,t1.SACOLOA SACOLOA,t1.SANRCPA SANRCPA,t1.SAINSOPR SAINSOPR,t1.SAININPR SAININPR,t1.SATEOBPR SATEOBPR,t1.SACOPE1 SACOPE1,t1.SACNEUPR1 SACNEUPR1,t1.SACOPE2 SACOPE2,t1.SACNEUPR2 SACNEUPR2,t1.SAFENOPR SAFENOPR,t1.SAINMENP1 SAINMENP1,t1.SAINRENP1 SAINRENP1,t1.SAINMENP2 SAINMENP2,t1.SAINRENP2 SAINRENP2,t1.SAINMENPT SAINMENPT,t1.SAINRENPT SAINRENPT,t1.SANOLUP SANOLUP,t1.SANODIRP SANODIRP,t1.SACOLOP SACOLOP,t1.SANRCOPOP SANRCOPOP,t1.SANOPVP SANOPVP,t1.SANRTELP SANRTELP,t1.SANRFAXP SANRFAXP,t1.SAFEREPR SAFEREPR,t1.SAHRREPR SAHRREPR,t1.SACOARPT2 SACOARPT2,t1.SAINMENCPT2 SAINMENCPT2,t1.SAINRENCPT2 SAINRENCPT2,t1.SACOARPS2 SACOARPS2,t1.SAINMENCPS2 SAINMENCPS2,t1.SAINRENCPS2 SAINRENCPS2,t1.SACOARTT2 SACOARTT2,t1.SAINMENCTT2 SAINMENCTT2,t1.SAINRENCTT2 SAINRENCTT2,t1.SACOARTS2 SACOARTS2,t1.SAINMENCTS2 SAINMENCTS2,t1.SAINRENCTS2 SAINRENCTS2,t1.SACOCCCO2 SACOCCCO2,t1.SACOARDT2 SACOARDT2,t1.SAINMENCDT2 SAINMENCDT2,t1.SAINRENCDT2 SAINRENCDT2,t1.SACOARDS2 SACOARDS2,t1.SAINMENCDS2 SAINMENCDS2,t1.SAINRENCDS2 SAINRENCDS2,t1.SACOOECO2 SACOOECO2,t1.SAINMENCST2 SAINMENCST2,t1.SAINRENCST2 SAINRENCST2,t1.SAINMENCSS2 SAINMENCSS2,t1.SAINRENCSS2 SAINRENCSS2,t1.SAINMENCT2 SAINMENCT2,t1.SAINRENCT2 SAINRENCT2,t1.SAFECIAU2 SAFECIAU2,t1.SAHRCIAU2 SAHRCIAU2,t1.SANOLURA2 SANOLURA2,t1.SANODIRA2 SANODIRA2,t1.SACOLOA2 SACOLOA2,t1.SANRCPA2 SANRCPA2,t1.SAFELAUD SAFELAUD,t1.SATEOBRE SATEOBRE,t1.SATEMORE SATEMORE,t1.SACNEUIL SACNEUIL,t1.SAINFDLA SAINFDLA,t1.SAINVOLA SAINVOLA,t1.SAINARNL SAINARNL,t1.SAFENOLT SAFENOLT,t1.SAINMELT SAINMELT,t1.SAINPUBO SAINPUBO,t1.SACOTA1 SACOTA1,t1.SAFESERA SAFESERA,t1.SAINFDRA SAINFDRA,t1.SAFEPEEX SAFEPEEX,t1.SAINRAIN SAINRAIN,t1.SAINEFIN SAINEFIN,t1.SAFEINEF SAFEINEF,t1.SAFEAR SAFEAR,t1.SAFENODE SAFENODE,t1.SAFERELT SAFERELT,t1.SAFENOCA SAFENOCA,t1.SAFENOCA2 SAFENOCA2,t1.SAFENOAR SAFENOAR,t1.SACOCCCOS SACOCCCOS,t1.SACOCCCO2S SACOCCCO2S,t1.SACOOECOS SACOOECOS,t1.SACOOECO2S SACOOECO2S,t1.SAFESOAC SAFESOAC,t1.SAFEENAC SAFEENAC,t1.SAFENOAC SAFENOAC,t1.SATEFPR1 SATEFPR1,t1.SATEFPR2 SATEFPR2,t1.SAFEFPR1 SAFEFPR1,t1.SAFEFPR2 SAFEFPR2,t1.SANRBOPL SANRBOPL,t1.SAFEENIN SAFEENIN,t1.SAFEOPPE SAFEOPPE,t1.SAFEOPLA SAFEOPLA,t1.SAFERECO SAFERECO,t1.SAFENOLA SAFENOLA,t1.SAFENONA SAFENONA,t1.SAFERENA SAFERENA,t1.SAFECONA SAFECONA,t1.SAPUB SAPUB,t1.SAINTICA SAINTICA,t1.SACOTIR SACOTIR,t1.SACOPS SACOPS,t1.SACOSAAC SACOSAAC,t1.SACOSET2 SACOSET2, t1.SACOSET SACOSET, t1.SACOSES2 SACOSES2,t1.SACOSES SACOSES, t2.XJCODIGO ZDDESTADXJCODIGO,t2.XJIDEX ZDDESTADXJIDEX,t2.XJNOMBRE ZDDESTADXJNOMBRE,t2.XJVALOR ZDDESTADXJVALOR,t3.T5CODIGO TCMOTINAT5CODIGO,t3.T5NOMBRE TCMOTINAT5NOMBRE,t3.T5NOMBREEU TCMOTINAT5NOMBREEU,t4.T7CODIGO TCMONOLAT7CODIGO,t4.T7NOMBRE TCMONOLAT7NOMBRE,t5.TMDCODIGO TCMOTDESTMDCODIGO,t5.TMDNOMBRE TCMOTDESTMDNOMBRE,t7.T4CODIGO TCLUGAUDT4CODIGO,t7.T4NOMBRE TCLUGAUDT4NOMBRE,t7.T4NOMBREEU TCLUGAUDT4NOMBREEU ");
		query.append(
				" ,t8.EXCODIGO EXCODIGO, t8.EXFCODIGO EXFCODIGO, t9.XJACTIVOP, t9.XJACTIVOPSUP, t9.XJACTIVOAACC, t9.XJACTIVOAACCSUP, t9.XJACTIVOOOEE, t9.XJACTIVOOOEESUP, t1.SACOARPT2 SACOARPT2, t1.SACOARTT2 SACOARTT2, t1.SACOARTS2 SACOARTS2");
		query.append(
				" FROM SOLARB t1 ,ZDDESTAD t2 ,TCMOTINA t3 ,TCMONOLA t4 ,TCMOTDES t5 , TCLUGAUD t7, ARBEXP t8, (SELECT TREXCODIGO, XJACTIVOP, XJACTIVOPSUP, XJACTIVOAACC, XJACTIVOAACCSUP, XJACTIVOOOEE, XJACTIVOOOEESUP, filaDesigCol ");
		query.append(
				" FROM (SELECT TREXCODIGO, XJACTIVOP, XJACTIVOPSUP, XJACTIVOAACC, XJACTIVOAACCSUP, XJACTIVOOOEE, XJACTIVOOOEESUP, ROW_NUMBER() OVER (PARTITION BY TREXCODIGO, TRCODIGO ORDER BY TRFECFIN DESC) filaDesigCol")
				.append(" FROM ARBTRAMEXP, ARBCOLEGIO, SOLARB WHERE TRID = XJTRID AND TRCODIGO = '")
				.append(Y41bConstantes.TRAMITE_ARBITRAJE_DESIGNACION_COLEGIO).append("' AND TRESTADO = '")
				.append(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO)
				.append("' AND TREXCODIGO = SACODIGO) WHERE filaDesigCol=1) t9");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(solarb);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.SACODIGO=t8.EXCODIGO(+) AND t1.SACOXJ= t2.XJCODIGO(+) AND t1.SACOT5= t3.T5CODIGO(+) AND t1.SACOT7= t4.T7CODIGO(+) AND t1.SACOTMD= t5.TMDCODIGO(+) AND t1.SACOT4= t7.T4CODIGO(+) AND t1.SACODIGO = t9.TREXCODIGO (+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Solarb>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Solarb table.
	 * 
	 * @param solarb
	 *            Solarb
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Solarb solarb) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM SOLARB t1 , ZDDESTAD t2 , TCMOTINA t3 , TCMONOLA t4 , TCMOTDES t5 , TCLUGAUD t7, ARBEXP t8 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(solarb);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.SACODIGO=t8.EXCODIGO(+) AND t1.SACOXJ= t2.XJCODIGO(+) AND t1.SACOT5= t3.T5CODIGO(+) AND t1.SACOT7= t4.T7CODIGO(+) AND t1.SACOTMD= t5.TMDCODIGO(+) AND t1.SACOT4= t7.T4CODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds rows in the Solarb table using like.
	 * 
	 * @param solarb
	 *            Solarb
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Solarb> findAllLike(Solarb solarb, Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.SACODIGO SACODIGO,t1.SACOHD SACOHD,t1.SACOJA SACOJA,t1.SANROR SANROR,t1.SANRAN SANRAN,t1.SAFESOLI SAFESOLI,t1.SANODIDC SANODIDC,t1.SACOLODC SACOLODC,t1.SANOLODC SANOLODC,t1.SACOPVDC SACOPVDC,t1.SACOMUDC SACOMUDC,t1.SANRCPDC SANRCPDC,t1.SAINACUO SAINACUO,t1.SACOORPR SACOORPR,t1.SACOSERE SACOSERE,t1.SACOTTI SACOTTI,t1.SAINTISO SAINTISO,t1.SACNRECL SACNRECL,t1.SATEOBRC SATEOBRC,t1.SAFEINAD SAFEINAD,t1.SATEINAD SATEINAD,t1.SAFEREIT SAFEREIT,t1.SAFETRAS SAFETRAS,t1.SACOORTR SACOORTR,t1.SAFERETT SAFERETT,t1.SAFERETS SAFERETS,t1.SAFEMEDI SAFEMEDI,t1.SAINREME SAINREME,t1.SAFEREMT SAFEREMT,t1.SAFEDESI SAFEDESI,t1.SAFEREDT SAFEREDT,t1.SAFENOCO SAFENOCO,t1.SAFEREAR SAFEREAR,t1.SAFEDECO SAFEDECO,t1.SACOARPT SACOARPT,t1.SAINMENCPT SAINMENCPT,t1.SAINRENCPT SAINRENCPT,t1.SACOARPS SACOARPS,t1.SAINMENCPS SAINMENCPS,t1.SAINRENCPS SAINRENCPS,t1.SACOARTT SACOARTT,t1.SAINMENCTT SAINMENCTT,t1.SAINRENCTT SAINRENCTT,t1.SACOARTS SACOARTS,t1.SAINMENCTS SAINMENCTS,t1.SAINRENCTS SAINRENCTS,t1.SACOCCCO SACOCCCO,t1.SACOARDT SACOARDT,t1.SAINMENCDT SAINMENCDT,t1.SAINRENCDT SAINRENCDT,t1.SACOARDS SACOARDS,t1.SAINMENCDS SAINMENCDS,t1.SAINRENCDS SAINRENCDS,t1.SACOOECO SACOOECO,t1.SAINMENCST SAINMENCST,t1.SAINRENCST SAINRENCST,t1.SAINMENCSS SAINMENCSS,t1.SAINRENCSS SAINRENCSS,t1.SAINMENCT SAINMENCT,t1.SAINRENCT SAINRENCT,t1.SAFECIAU SAFECIAU,t1.SAHRCIAU SAHRCIAU,t1.SANOLURA SANOLURA,t1.SANODIRA SANODIRA,t1.SACOLOA SACOLOA,t1.SANRCPA SANRCPA,t1.SAINSOPR SAINSOPR,t1.SAININPR SAININPR,t1.SATEOBPR SATEOBPR,t1.SACOPE1 SACOPE1,t1.SACNEUPR1 SACNEUPR1,t1.SACOPE2 SACOPE2,t1.SACNEUPR2 SACNEUPR2,t1.SAFENOPR SAFENOPR,t1.SAINMENP1 SAINMENP1,t1.SAINRENP1 SAINRENP1,t1.SAINMENP2 SAINMENP2,t1.SAINRENP2 SAINRENP2,t1.SAINMENPT SAINMENPT,t1.SAINRENPT SAINRENPT,t1.SANOLUP SANOLUP,t1.SANODIRP SANODIRP,t1.SACOLOP SACOLOP,t1.SANRCOPOP SANRCOPOP,t1.SANOPVP SANOPVP,t1.SANRTELP SANRTELP,t1.SANRFAXP SANRFAXP,t1.SAFEREPR SAFEREPR,t1.SAHRREPR SAHRREPR,t1.SACOARPT2 SACOARPT2,t1.SAINMENCPT2 SAINMENCPT2,t1.SAINRENCPT2 SAINRENCPT2,t1.SACOARPS2 SACOARPS2,t1.SAINMENCPS2 SAINMENCPS2,t1.SAINRENCPS2 SAINRENCPS2,t1.SACOARTT2 SACOARTT2,t1.SAINMENCTT2 SAINMENCTT2,t1.SAINRENCTT2 SAINRENCTT2,t1.SACOARTS2 SACOARTS2,t1.SAINMENCTS2 SAINMENCTS2,t1.SAINRENCTS2 SAINRENCTS2,t1.SACOCCCO2 SACOCCCO2,t1.SACOARDT2 SACOARDT2,t1.SAINMENCDT2 SAINMENCDT2,t1.SAINRENCDT2 SAINRENCDT2,t1.SACOARDS2 SACOARDS2,t1.SAINMENCDS2 SAINMENCDS2,t1.SAINRENCDS2 SAINRENCDS2,t1.SACOOECO2 SACOOECO2,t1.SAINMENCST2 SAINMENCST2,t1.SAINRENCST2 SAINRENCST2,t1.SAINMENCSS2 SAINMENCSS2,t1.SAINRENCSS2 SAINRENCSS2,t1.SAINMENCT2 SAINMENCT2,t1.SAINRENCT2 SAINRENCT2,t1.SAFECIAU2 SAFECIAU2,t1.SAHRCIAU2 SAHRCIAU2,t1.SANOLURA2 SANOLURA2,t1.SANODIRA2 SANODIRA2,t1.SACOLOA2 SACOLOA2,t1.SANRCPA2 SANRCPA2,t1.SAFELAUD SAFELAUD,t1.SATEOBRE SATEOBRE,t1.SATEMORE SATEMORE,t1.SACNEUIL SACNEUIL,t1.SAINFDLA SAINFDLA,t1.SAINVOLA SAINVOLA,t1.SAINARNL SAINARNL,t1.SAFENOLT SAFENOLT,t1.SAINMELT SAINMELT,t1.SAINPUBO SAINPUBO,t1.SACOTA1 SACOTA1,t1.SAFESERA SAFESERA,t1.SAINFDRA SAINFDRA,t1.SAFEPEEX SAFEPEEX,t1.SAINRAIN SAINRAIN,t1.SAINEFIN SAINEFIN,t1.SAFEINEF SAFEINEF,t1.SAFEAR SAFEAR,t1.SAFENODE SAFENODE,t1.SAFERELT SAFERELT,t1.SAFENOCA SAFENOCA,t1.SAFENOCA2 SAFENOCA2,t1.SAFENOAR SAFENOAR,t1.SACOCCCOS SACOCCCOS,t1.SACOCCCO2S SACOCCCO2S,t1.SACOOECOS SACOOECOS,t1.SACOOECO2S SACOOECO2S,t1.SAFESOAC SAFESOAC,t1.SAFEENAC SAFEENAC,t1.SAFENOAC SAFENOAC,t1.SATEFPR1 SATEFPR1,t1.SATEFPR2 SATEFPR2,t1.SAFEFPR1 SAFEFPR1,t1.SAFEFPR2 SAFEFPR2,t1.SANRBOPL SANRBOPL,t1.SAFEENIN SAFEENIN,t1.SAFEOPPE SAFEOPPE,t1.SAFEOPLA SAFEOPLA,t1.SAFERECO SAFERECO,t1.SAFENOLA SAFENOLA,t1.SAFENONA SAFENONA,t1.SAFERENA SAFERENA,t1.SAFECONA SAFECONA,t1.SAPUB SAPUB,t1.SAINTICA SAINTICA,t1.SACOTIR SACOTIR,t1.SACOPS SACOPS,t1.SACOSAAC SACOSAAC, t1.SACOSET2 SACOSET2, t1.SACOSET SACOSET, t1.SACOSES2 SACOSES2,t1.SACOSES SACOSES, t2.XJCODIGO ZDDESTADXJCODIGO,t2.XJIDEX ZDDESTADXJIDEX,t2.XJNOMBRE ZDDESTADXJNOMBRE,t2.XJVALOR ZDDESTADXJVALOR,t3.T5CODIGO TCMOTINAT5CODIGO,t3.T5NOMBRE TCMOTINAT5NOMBRE,t3.T5NOMBREEU TCMOTINAT5NOMBREEU,t4.T7CODIGO TCMONOLAT7CODIGO,t4.T7NOMBRE TCMONOLAT7NOMBRE,t5.TMDCODIGO TCMOTDESTMDCODIGO,t5.TMDNOMBRE TCMOTDESTMDNOMBRE, t7.T4CODIGO TCLUGAUDT4CODIGO,t7.T4NOMBRE TCLUGAUDT4NOMBRE,t7.T4NOMBREEU TCLUGAUDT4NOMBREEU  ");
		query.append(" ,t8.EXCODIGO EXCODIGO, t8.EXFCODIGO EXFCODIGO ");
		query.append("FROM SOLARB t1 ,ZDDESTAD t2 ,TCMOTINA t3 ,TCMONOLA t4 ,TCMOTDES t5 ,TCLUGAUD t7, ARBEXP t8 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(solarb, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.SACODIGO=t8.EXCODIGO(+) AND t1.SACOXJ= t2.XJCODIGO(+) AND t1.SACOT5= t3.T5CODIGO(+) AND t1.SACOT7= t4.T7CODIGO(+) AND t1.SACOTMD= t5.TMDCODIGO(+) AND t1.SACOT4= t7.T4CODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Solarb>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Solarb table using like.
	 * 
	 * @param solarb
	 *            Solarb
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Solarb solarb, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM SOLARB t1 ,ZDDESTAD t2 ,TCMOTINA t3 ,TCMONOLA t4 ,TCMOTDES t5 ,TCLUGAUD t7, ARBEXP t8 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(solarb, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.SACODIGO=t8.EXCODIGO(+) AND t1.SACOXJ= t2.XJCODIGO(+) AND t1.SACOT5= t3.T5CODIGO(+) AND t1.SACOT7= t4.T7CODIGO(+) AND t1.SACOTMD= t5.TMDCODIGO(+) AND t1.SACOT4= t7.T4CODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Solarb entity
	 * 
	 * @param solarb
	 *            Solarb Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */

	private Map<String, ?> getWhereMap(Solarb solarb) {

		StringBuilder where = new StringBuilder(SolarbDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (solarb != null && solarb.getSacodigo() != null) {
			where.append(" AND t1.SACODIGO = ?");
			params.add(solarb.getSacodigo());
		}
		if (solarb != null && solarb.getZddestad() != null && solarb.getZddestad().getXjcodigo() != null) {
			where.append(" AND t2.XJCODIGO = ?");
			params.add(solarb.getZddestad().getXjcodigo());
		}
		if (solarb != null && solarb.getZddestad() != null && solarb.getZddestad().getXjidex() != null) {
			where.append(" AND t2.XJIDEX = ?");
			params.add(solarb.getZddestad().getXjidex());
		}
		if (solarb != null && solarb.getZddestad() != null && solarb.getZddestad().getXjnombre() != null) {
			where.append(" AND t2.XJNOMBRE = ?");
			params.add(solarb.getZddestad().getXjnombre());
		}
		if (solarb != null && solarb.getZddestad() != null && solarb.getZddestad().getXjvalor() != null) {
			where.append(" AND t2.XJVALOR = ?");
			params.add(solarb.getZddestad().getXjvalor());
		}
		if (solarb != null && solarb.getTcmotina() != null && solarb.getTcmotina().getT5codigo() != null) {
			where.append(" AND t3.T5CODIGO = ?");
			params.add(solarb.getTcmotina().getT5codigo());
		}
		if (solarb != null && solarb.getTcmotina() != null && solarb.getTcmotina().getT5nombre() != null) {
			where.append(" AND t3.T5NOMBRE = ?");
			params.add(solarb.getTcmotina().getT5nombre());
		}
		if (solarb != null && solarb.getTcmonola() != null && solarb.getTcmonola().getT7codigo() != null) {
			where.append(" AND t4.T7CODIGO = ?");
			params.add(solarb.getTcmonola().getT7codigo());
		}
		if (solarb != null && solarb.getTcmonola() != null && solarb.getTcmonola().getT7nombre() != null) {
			where.append(" AND t4.T7NOMBRE = ?");
			params.add(solarb.getTcmonola().getT7nombre());
		}
		if (solarb != null && solarb.getTcmotdes() != null && solarb.getTcmotdes().getTmdcodigo() != null) {
			where.append(" AND t5.TMDCODIGO = ?");
			params.add(solarb.getTcmotdes().getTmdcodigo());
		}
		if (solarb != null && solarb.getTcmotdes() != null && solarb.getTcmotdes().getTmdnombre() != null) {
			where.append(" AND t5.TMDNOMBRE = ?");
			params.add(solarb.getTcmotdes().getTmdnombre());
		}
		if (solarb != null && solarb.getSacoset2() != null) {
			where.append(" AND t1.SACOSET2 = ?");
			params.add(solarb.getSacoset2());
		}
		if (solarb != null && solarb.getTclugaud() != null && solarb.getTclugaud().getT4codigo() != null) {
			where.append(" AND t7.T4CODIGO = ?");
			params.add(solarb.getTclugaud().getT4codigo());
		}
		if (solarb != null && solarb.getTclugaud() != null && solarb.getTclugaud().getT4nombre() != null) {
			where.append(" AND t7.T4NOMBRE = ?");
			params.add(solarb.getTclugaud().getT4nombre());
		}
		if (solarb != null && solarb.getSacoset() != null) {
			where.append(" AND t1.SACOSET = ?");
			params.add(solarb.getSacoset());
		}
		if (solarb != null && solarb.getSacoses2() != null) {
			where.append(" AND t1.SACOSES2 = ?");
			params.add(solarb.getSacoses2());
		}
		if (solarb != null && solarb.getSacoses() != null) {
			where.append(" AND t1.SACOSES = ?");
			params.add(solarb.getSacoses());
		}
		if (solarb != null && solarb.getSacohd() != null) {
			where.append(" AND t1.SACOHD = ?");
			params.add(solarb.getSacohd());
		}
		if (solarb != null && solarb.getSacoja() != null) {
			where.append(" AND t1.SACOJA = ?");
			params.add(solarb.getSacoja());
		}
		if (solarb != null && solarb.getSanror() != null) {
			where.append(" AND t1.SANROR = ?");
			params.add(solarb.getSanror());
		}
		if (solarb != null && solarb.getSanran() != null) {
			where.append(" AND t1.SANRAN = ?");
			params.add(solarb.getSanran());
		}
		if (solarb != null && solarb.getSafesoli() != null) {
			where.append(" AND t1.SAFESOLI = ?");
			params.add(solarb.getSafesoli());
		}
		if (solarb != null && solarb.getSanodidc() != null) {
			where.append(" AND t1.SANODIDC = ?");
			params.add(solarb.getSanodidc());
		}
		if (solarb != null && solarb.getSacolodc() != null) {
			where.append(" AND t1.SACOLODC = ?");
			params.add(solarb.getSacolodc());
		}
		if (solarb != null && solarb.getSanolodc() != null) {
			where.append(" AND t1.SANOLODC = ?");
			params.add(solarb.getSanolodc());
		}
		if (solarb != null && solarb.getSacopvdc() != null) {
			where.append(" AND t1.SACOPVDC = ?");
			params.add(solarb.getSacopvdc());
		}
		if (solarb != null && solarb.getSacomudc() != null) {
			where.append(" AND t1.SACOMUDC = ?");
			params.add(solarb.getSacomudc());
		}
		if (solarb != null && solarb.getSanrcpdc() != null) {
			where.append(" AND t1.SANRCPDC = ?");
			params.add(solarb.getSanrcpdc());
		}
		if (solarb != null && solarb.getSainacuo() != null) {
			where.append(" AND t1.SAINACUO = ?");
			params.add(solarb.getSainacuo());
		}
		if (solarb != null && solarb.getSacoorpr() != null) {
			where.append(" AND t1.SACOORPR = ?");
			params.add(solarb.getSacoorpr());
		}
		if (solarb != null && solarb.getSacosere() != null) {
			where.append(" AND t1.SACOSERE = ?");
			params.add(solarb.getSacosere());
		}
		if (solarb != null && solarb.getSacotti() != null) {
			where.append(" AND t1.SACOTTI = ?");
			params.add(solarb.getSacotti());
		}
		if (solarb != null && solarb.getSaintiso() != null) {
			where.append(" AND t1.SAINTISO = ?");
			params.add(solarb.getSaintiso());
		}
		if (solarb != null && solarb.getSacnrecl() != null) {
			where.append(" AND t1.SACNRECL = ?");
			params.add(solarb.getSacnrecl());
		}
		if (solarb != null && solarb.getSateobrc() != null) {
			where.append(" AND t1.SATEOBRC = ?");
			params.add(solarb.getSateobrc());
		}
		if (solarb != null && solarb.getSafeinad() != null) {
			where.append(" AND t1.SAFEINAD = ?");
			params.add(solarb.getSafeinad());
		}
		if (solarb != null && solarb.getSateinad() != null) {
			where.append(" AND t1.SATEINAD = ?");
			params.add(solarb.getSateinad());
		}
		if (solarb != null && solarb.getSafereit() != null) {
			where.append(" AND t1.SAFEREIT = ?");
			params.add(solarb.getSafereit());
		}
		if (solarb != null && solarb.getSafetras() != null) {
			where.append(" AND t1.SAFETRAS = ?");
			params.add(solarb.getSafetras());
		}
		if (solarb != null && solarb.getSacoortr() != null) {
			where.append(" AND t1.SACOORTR = ?");
			params.add(solarb.getSacoortr());
		}
		if (solarb != null && solarb.getSaferett() != null) {
			where.append(" AND t1.SAFERETT = ?");
			params.add(solarb.getSaferett());
		}
		if (solarb != null && solarb.getSaferets() != null) {
			where.append(" AND t1.SAFERETS = ?");
			params.add(solarb.getSaferets());
		}
		if (solarb != null && solarb.getSafemedi() != null) {
			where.append(" AND t1.SAFEMEDI = ?");
			params.add(solarb.getSafemedi());
		}
		if (solarb != null && solarb.getSainreme() != null) {
			where.append(" AND t1.SAINREME = ?");
			params.add(solarb.getSainreme());
		}
		if (solarb != null && solarb.getSaferemt() != null) {
			where.append(" AND t1.SAFEREMT = ?");
			params.add(solarb.getSaferemt());
		}
		if (solarb != null && solarb.getSafedesi() != null) {
			where.append(" AND t1.SAFEDESI = ?");
			params.add(solarb.getSafedesi());
		}
		if (solarb != null && solarb.getSaferedt() != null) {
			where.append(" AND t1.SAFEREDT = ?");
			params.add(solarb.getSaferedt());
		}
		if (solarb != null && solarb.getSafenoco() != null) {
			where.append(" AND t1.SAFENOCO = ?");
			params.add(solarb.getSafenoco());
		}
		if (solarb != null && solarb.getSaferear() != null) {
			where.append(" AND t1.SAFEREAR = ?");
			params.add(solarb.getSaferear());
		}
		if (solarb != null && solarb.getSafedeco() != null) {
			where.append(" AND t1.SAFEDECO = ?");
			params.add(solarb.getSafedeco());
		}
		if (solarb != null && solarb.getSacoarpt() != null) {
			where.append(" AND t1.SACOARPT = ?");
			params.add(solarb.getSacoarpt());
		}
		if (solarb != null && solarb.getSainmencpt() != null) {
			where.append(" AND t1.SAINMENCPT = ?");
			params.add(solarb.getSainmencpt());
		}
		if (solarb != null && solarb.getSainrencpt() != null) {
			where.append(" AND t1.SAINRENCPT = ?");
			params.add(solarb.getSainrencpt());
		}
		if (solarb != null && solarb.getSacoarps() != null) {
			where.append(" AND t1.SACOARPS = ?");
			params.add(solarb.getSacoarps());
		}
		if (solarb != null && solarb.getSainmencps() != null) {
			where.append(" AND t1.SAINMENCPS = ?");
			params.add(solarb.getSainmencps());
		}
		if (solarb != null && solarb.getSainrencps() != null) {
			where.append(" AND t1.SAINRENCPS = ?");
			params.add(solarb.getSainrencps());
		}
		if (solarb != null && solarb.getSacoartt() != null) {
			where.append(" AND t1.SACOARTT = ?");
			params.add(solarb.getSacoartt());
		}
		if (solarb != null && solarb.getSainmenctt() != null) {
			where.append(" AND t1.SAINMENCTT = ?");
			params.add(solarb.getSainmenctt());
		}
		if (solarb != null && solarb.getSainrenctt() != null) {
			where.append(" AND t1.SAINRENCTT = ?");
			params.add(solarb.getSainrenctt());
		}
		if (solarb != null && solarb.getSacoarts() != null) {
			where.append(" AND t1.SACOARTS = ?");
			params.add(solarb.getSacoarts());
		}
		if (solarb != null && solarb.getSainmencts() != null) {
			where.append(" AND t1.SAINMENCTS = ?");
			params.add(solarb.getSainmencts());
		}
		if (solarb != null && solarb.getSainrencts() != null) {
			where.append(" AND t1.SAINRENCTS = ?");
			params.add(solarb.getSainrencts());
		}
		if (solarb != null && solarb.getSacoccco() != null) {
			where.append(" AND t1.SACOCCCO = ?");
			params.add(solarb.getSacoccco());
		}
		if (solarb != null && solarb.getSacoardt() != null) {
			where.append(" AND t1.SACOARDT = ?");
			params.add(solarb.getSacoardt());
		}
		if (solarb != null && solarb.getSainmencdt() != null) {
			where.append(" AND t1.SAINMENCDT = ?");
			params.add(solarb.getSainmencdt());
		}
		if (solarb != null && solarb.getSainrencdt() != null) {
			where.append(" AND t1.SAINRENCDT = ?");
			params.add(solarb.getSainrencdt());
		}
		if (solarb != null && solarb.getSacoards() != null) {
			where.append(" AND t1.SACOARDS = ?");
			params.add(solarb.getSacoards());
		}
		if (solarb != null && solarb.getSainmencds() != null) {
			where.append(" AND t1.SAINMENCDS = ?");
			params.add(solarb.getSainmencds());
		}
		if (solarb != null && solarb.getSainrencds() != null) {
			where.append(" AND t1.SAINRENCDS = ?");
			params.add(solarb.getSainrencds());
		}
		if (solarb != null && solarb.getSacooeco() != null) {
			where.append(" AND t1.SACOOECO = ?");
			params.add(solarb.getSacooeco());
		}
		if (solarb != null && solarb.getSainmencst() != null) {
			where.append(" AND t1.SAINMENCST = ?");
			params.add(solarb.getSainmencst());
		}
		if (solarb != null && solarb.getSainrencst() != null) {
			where.append(" AND t1.SAINRENCST = ?");
			params.add(solarb.getSainrencst());
		}
		if (solarb != null && solarb.getSainmencss() != null) {
			where.append(" AND t1.SAINMENCSS = ?");
			params.add(solarb.getSainmencss());
		}
		if (solarb != null && solarb.getSainrencss() != null) {
			where.append(" AND t1.SAINRENCSS = ?");
			params.add(solarb.getSainrencss());
		}
		if (solarb != null && solarb.getSainmenct() != null) {
			where.append(" AND t1.SAINMENCT = ?");
			params.add(solarb.getSainmenct());
		}
		if (solarb != null && solarb.getSainrenct() != null) {
			where.append(" AND t1.SAINRENCT = ?");
			params.add(solarb.getSainrenct());
		}
		if (solarb != null && solarb.getSafeciau() != null) {
			where.append(" AND t1.SAFECIAU = ?");
			params.add(solarb.getSafeciau());
		}
		if (solarb != null && solarb.getSahrciau() != null) {
			where.append(" AND t1.SAHRCIAU = ?");
			params.add(solarb.getSahrciau());
		}
		if (solarb != null && solarb.getSanolura() != null) {
			where.append(" AND t1.SANOLURA = ?");
			params.add(solarb.getSanolura());
		}
		if (solarb != null && solarb.getSanodira() != null) {
			where.append(" AND t1.SANODIRA = ?");
			params.add(solarb.getSanodira());
		}
		if (solarb != null && solarb.getSacoloa() != null) {
			where.append(" AND t1.SACOLOA = ?");
			params.add(solarb.getSacoloa());
		}
		if (solarb != null && solarb.getSanrcpa() != null) {
			where.append(" AND t1.SANRCPA = ?");
			params.add(solarb.getSanrcpa());
		}
		if (solarb != null && solarb.getSainsopr() != null) {
			where.append(" AND t1.SAINSOPR = ?");
			params.add(solarb.getSainsopr());
		}
		if (solarb != null && solarb.getSaininpr() != null) {
			where.append(" AND t1.SAININPR = ?");
			params.add(solarb.getSaininpr());
		}
		if (solarb != null && solarb.getSateobpr() != null) {
			where.append(" AND t1.SATEOBPR = ?");
			params.add(solarb.getSateobpr());
		}
		if (solarb != null && solarb.getSacope1() != null) {
			where.append(" AND t1.SACOPE1 = ?");
			params.add(solarb.getSacope1());
		}
		if (solarb != null && solarb.getSacneupr1() != null) {
			where.append(" AND t1.SACNEUPR1 = ?");
			params.add(solarb.getSacneupr1());
		}
		if (solarb != null && solarb.getSacope2() != null) {
			where.append(" AND t1.SACOPE2 = ?");
			params.add(solarb.getSacope2());
		}
		if (solarb != null && solarb.getSacneupr2() != null) {
			where.append(" AND t1.SACNEUPR2 = ?");
			params.add(solarb.getSacneupr2());
		}
		if (solarb != null && solarb.getSafenopr() != null) {
			where.append(" AND t1.SAFENOPR = ?");
			params.add(solarb.getSafenopr());
		}
		if (solarb != null && solarb.getSainmenp1() != null) {
			where.append(" AND t1.SAINMENP1 = ?");
			params.add(solarb.getSainmenp1());
		}
		if (solarb != null && solarb.getSainrenp1() != null) {
			where.append(" AND t1.SAINRENP1 = ?");
			params.add(solarb.getSainrenp1());
		}
		if (solarb != null && solarb.getSainmenp2() != null) {
			where.append(" AND t1.SAINMENP2 = ?");
			params.add(solarb.getSainmenp2());
		}
		if (solarb != null && solarb.getSainrenp2() != null) {
			where.append(" AND t1.SAINRENP2 = ?");
			params.add(solarb.getSainrenp2());
		}
		if (solarb != null && solarb.getSainmenpt() != null) {
			where.append(" AND t1.SAINMENPT = ?");
			params.add(solarb.getSainmenpt());
		}
		if (solarb != null && solarb.getSainrenpt() != null) {
			where.append(" AND t1.SAINRENPT = ?");
			params.add(solarb.getSainrenpt());
		}
		if (solarb != null && solarb.getSanolup() != null) {
			where.append(" AND t1.SANOLUP = ?");
			params.add(solarb.getSanolup());
		}
		if (solarb != null && solarb.getSanodirp() != null) {
			where.append(" AND t1.SANODIRP = ?");
			params.add(solarb.getSanodirp());
		}
		if (solarb != null && solarb.getSacolop() != null) {
			where.append(" AND t1.SACOLOP = ?");
			params.add(solarb.getSacolop());
		}
		if (solarb != null && solarb.getSanrcopop() != null) {
			where.append(" AND t1.SANRCOPOP = ?");
			params.add(solarb.getSanrcopop());
		}
		if (solarb != null && solarb.getSanopvp() != null) {
			where.append(" AND t1.SANOPVP = ?");
			params.add(solarb.getSanopvp());
		}
		if (solarb != null && solarb.getSanrtelp() != null) {
			where.append(" AND t1.SANRTELP = ?");
			params.add(solarb.getSanrtelp());
		}
		if (solarb != null && solarb.getSanrfaxp() != null) {
			where.append(" AND t1.SANRFAXP = ?");
			params.add(solarb.getSanrfaxp());
		}
		if (solarb != null && solarb.getSaferepr() != null) {
			where.append(" AND t1.SAFEREPR = ?");
			params.add(solarb.getSaferepr());
		}
		if (solarb != null && solarb.getSahrrepr() != null) {
			where.append(" AND t1.SAHRREPR = ?");
			params.add(solarb.getSahrrepr());
		}
		if (solarb != null && solarb.getSacoarpt2() != null) {
			where.append(" AND t1.SACOARPT2 = ?");
			params.add(solarb.getSacoarpt2());
		}
		if (solarb != null && solarb.getSainmencpt2() != null) {
			where.append(" AND t1.SAINMENCPT2 = ?");
			params.add(solarb.getSainmencpt2());
		}
		if (solarb != null && solarb.getSainrencpt2() != null) {
			where.append(" AND t1.SAINRENCPT2 = ?");
			params.add(solarb.getSainrencpt2());
		}
		if (solarb != null && solarb.getSacoarps2() != null) {
			where.append(" AND t1.SACOARPS2 = ?");
			params.add(solarb.getSacoarps2());
		}
		if (solarb != null && solarb.getSainmencps2() != null) {
			where.append(" AND t1.SAINMENCPS2 = ?");
			params.add(solarb.getSainmencps2());
		}
		if (solarb != null && solarb.getSainrencps2() != null) {
			where.append(" AND t1.SAINRENCPS2 = ?");
			params.add(solarb.getSainrencps2());
		}
		if (solarb != null && solarb.getSacoartt2() != null) {
			where.append(" AND t1.SACOARTT2 = ?");
			params.add(solarb.getSacoartt2());
		}
		if (solarb != null && solarb.getSainmenctt2() != null) {
			where.append(" AND t1.SAINMENCTT2 = ?");
			params.add(solarb.getSainmenctt2());
		}
		if (solarb != null && solarb.getSainrenctt2() != null) {
			where.append(" AND t1.SAINRENCTT2 = ?");
			params.add(solarb.getSainrenctt2());
		}
		if (solarb != null && solarb.getSacoarts2() != null) {
			where.append(" AND t1.SACOARTS2 = ?");
			params.add(solarb.getSacoarts2());
		}
		if (solarb != null && solarb.getSainmencts2() != null) {
			where.append(" AND t1.SAINMENCTS2 = ?");
			params.add(solarb.getSainmencts2());
		}
		if (solarb != null && solarb.getSainrencts2() != null) {
			where.append(" AND t1.SAINRENCTS2 = ?");
			params.add(solarb.getSainrencts2());
		}
		if (solarb != null && solarb.getSacoccco2() != null) {
			where.append(" AND t1.SACOCCCO2 = ?");
			params.add(solarb.getSacoccco2());
		}
		if (solarb != null && solarb.getSacoardt2() != null) {
			where.append(" AND t1.SACOARDT2 = ?");
			params.add(solarb.getSacoardt2());
		}
		if (solarb != null && solarb.getSainmencdt2() != null) {
			where.append(" AND t1.SAINMENCDT2 = ?");
			params.add(solarb.getSainmencdt2());
		}
		if (solarb != null && solarb.getSainrencdt2() != null) {
			where.append(" AND t1.SAINRENCDT2 = ?");
			params.add(solarb.getSainrencdt2());
		}
		if (solarb != null && solarb.getSacoards2() != null) {
			where.append(" AND t1.SACOARDS2 = ?");
			params.add(solarb.getSacoards2());
		}
		if (solarb != null && solarb.getSainmencds2() != null) {
			where.append(" AND t1.SAINMENCDS2 = ?");
			params.add(solarb.getSainmencds2());
		}
		if (solarb != null && solarb.getSainrencds2() != null) {
			where.append(" AND t1.SAINRENCDS2 = ?");
			params.add(solarb.getSainrencds2());
		}
		if (solarb != null && solarb.getSacooeco2() != null) {
			where.append(" AND t1.SACOOECO2 = ?");
			params.add(solarb.getSacooeco2());
		}
		if (solarb != null && solarb.getSainmencst2() != null) {
			where.append(" AND t1.SAINMENCST2 = ?");
			params.add(solarb.getSainmencst2());
		}
		if (solarb != null && solarb.getSainrencst2() != null) {
			where.append(" AND t1.SAINRENCST2 = ?");
			params.add(solarb.getSainrencst2());
		}
		if (solarb != null && solarb.getSainmencss2() != null) {
			where.append(" AND t1.SAINMENCSS2 = ?");
			params.add(solarb.getSainmencss2());
		}
		if (solarb != null && solarb.getSainrencss2() != null) {
			where.append(" AND t1.SAINRENCSS2 = ?");
			params.add(solarb.getSainrencss2());
		}
		if (solarb != null && solarb.getSainmenct2() != null) {
			where.append(" AND t1.SAINMENCT2 = ?");
			params.add(solarb.getSainmenct2());
		}
		if (solarb != null && solarb.getSainrenct2() != null) {
			where.append(" AND t1.SAINRENCT2 = ?");
			params.add(solarb.getSainrenct2());
		}
		if (solarb != null && solarb.getSafeciau2() != null) {
			where.append(" AND t1.SAFECIAU2 = ?");
			params.add(solarb.getSafeciau2());
		}
		if (solarb != null && solarb.getSahrciau2() != null) {
			where.append(" AND t1.SAHRCIAU2 = ?");
			params.add(solarb.getSahrciau2());
		}
		if (solarb != null && solarb.getSanolura2() != null) {
			where.append(" AND t1.SANOLURA2 = ?");
			params.add(solarb.getSanolura2());
		}
		if (solarb != null && solarb.getSanodira2() != null) {
			where.append(" AND t1.SANODIRA2 = ?");
			params.add(solarb.getSanodira2());
		}
		if (solarb != null && solarb.getSacoloa2() != null) {
			where.append(" AND t1.SACOLOA2 = ?");
			params.add(solarb.getSacoloa2());
		}
		if (solarb != null && solarb.getSanrcpa2() != null) {
			where.append(" AND t1.SANRCPA2 = ?");
			params.add(solarb.getSanrcpa2());
		}
		if (solarb != null && solarb.getSafelaud() != null) {
			where.append(" AND t1.SAFELAUD = ?");
			params.add(solarb.getSafelaud());
		}
		if (solarb != null && solarb.getSateobre() != null) {
			where.append(" AND t1.SATEOBRE = ?");
			params.add(solarb.getSateobre());
		}
		if (solarb != null && solarb.getSatemore() != null) {
			where.append(" AND t1.SATEMORE = ?");
			params.add(solarb.getSatemore());
		}
		if (solarb != null && solarb.getSacneuil() != null) {
			where.append(" AND t1.SACNEUIL = ?");
			params.add(solarb.getSacneuil());
		}
		if (solarb != null && solarb.getSainfdla() != null) {
			where.append(" AND t1.SAINFDLA = ?");
			params.add(solarb.getSainfdla());
		}
		if (solarb != null && solarb.getSainvola() != null) {
			where.append(" AND t1.SAINVOLA = ?");
			params.add(solarb.getSainvola());
		}
		if (solarb != null && solarb.getSainarnl() != null) {
			where.append(" AND t1.SAINARNL = ?");
			params.add(solarb.getSainarnl());
		}
		if (solarb != null && solarb.getSafenolt() != null) {
			where.append(" AND t1.SAFENOLT = ?");
			params.add(solarb.getSafenolt());
		}
		if (solarb != null && solarb.getSainmelt() != null) {
			where.append(" AND t1.SAINMELT = ?");
			params.add(solarb.getSainmelt());
		}
		if (solarb != null && solarb.getSainpubo() != null) {
			where.append(" AND t1.SAINPUBO = ?");
			params.add(solarb.getSainpubo());
		}
		if (solarb != null && solarb.getSacota1() != null) {
			where.append(" AND t1.SACOTA1 = ?");
			params.add(solarb.getSacota1());
		}
		if (solarb != null && solarb.getSafesera() != null) {
			where.append(" AND t1.SAFESERA = ?");
			params.add(solarb.getSafesera());
		}
		if (solarb != null && solarb.getSainfdra() != null) {
			where.append(" AND t1.SAINFDRA = ?");
			params.add(solarb.getSainfdra());
		}
		if (solarb != null && solarb.getSafepeex() != null) {
			where.append(" AND t1.SAFEPEEX = ?");
			params.add(solarb.getSafepeex());
		}
		if (solarb != null && solarb.getSainrain() != null) {
			where.append(" AND t1.SAINRAIN = ?");
			params.add(solarb.getSainrain());
		}
		if (solarb != null && solarb.getSainefin() != null) {
			where.append(" AND t1.SAINEFIN = ?");
			params.add(solarb.getSainefin());
		}
		if (solarb != null && solarb.getSafeinef() != null) {
			where.append(" AND t1.SAFEINEF = ?");
			params.add(solarb.getSafeinef());
		}
		if (solarb != null && solarb.getSafear() != null) {
			where.append(" AND t1.SAFEAR = ?");
			params.add(solarb.getSafear());
		}
		if (solarb != null && solarb.getSafenode() != null) {
			where.append(" AND t1.SAFENODE = ?");
			params.add(solarb.getSafenode());
		}
		if (solarb != null && solarb.getSaferelt() != null) {
			where.append(" AND t1.SAFERELT = ?");
			params.add(solarb.getSaferelt());
		}
		if (solarb != null && solarb.getSafenoca() != null) {
			where.append(" AND t1.SAFENOCA = ?");
			params.add(solarb.getSafenoca());
		}
		if (solarb != null && solarb.getSafenoca2() != null) {
			where.append(" AND t1.SAFENOCA2 = ?");
			params.add(solarb.getSafenoca2());
		}
		if (solarb != null && solarb.getSafenoar() != null) {
			where.append(" AND t1.SAFENOAR = ?");
			params.add(solarb.getSafenoar());
		}
		if (solarb != null && solarb.getSacocccos() != null) {
			where.append(" AND t1.SACOCCCOS = ?");
			params.add(solarb.getSacocccos());
		}
		if (solarb != null && solarb.getSacoccco2s() != null) {
			where.append(" AND t1.SACOCCCO2S = ?");
			params.add(solarb.getSacoccco2s());
		}
		if (solarb != null && solarb.getSacooecos() != null) {
			where.append(" AND t1.SACOOECOS = ?");
			params.add(solarb.getSacooecos());
		}
		if (solarb != null && solarb.getSacooeco2s() != null) {
			where.append(" AND t1.SACOOECO2S = ?");
			params.add(solarb.getSacooeco2s());
		}
		if (solarb != null && solarb.getSafesoac() != null) {
			where.append(" AND t1.SAFESOAC = ?");
			params.add(solarb.getSafesoac());
		}
		if (solarb != null && solarb.getSafeenac() != null) {
			where.append(" AND t1.SAFEENAC = ?");
			params.add(solarb.getSafeenac());
		}
		if (solarb != null && solarb.getSafenoac() != null) {
			where.append(" AND t1.SAFENOAC = ?");
			params.add(solarb.getSafenoac());
		}
		if (solarb != null && solarb.getSatefpr1() != null) {
			where.append(" AND t1.SATEFPR1 = ?");
			params.add(solarb.getSatefpr1());
		}
		if (solarb != null && solarb.getSatefpr2() != null) {
			where.append(" AND t1.SATEFPR2 = ?");
			params.add(solarb.getSatefpr2());
		}
		if (solarb != null && solarb.getSafefpr1() != null) {
			where.append(" AND t1.SAFEFPR1 = ?");
			params.add(solarb.getSafefpr1());
		}
		if (solarb != null && solarb.getSafefpr2() != null) {
			where.append(" AND t1.SAFEFPR2 = ?");
			params.add(solarb.getSafefpr2());
		}
		if (solarb != null && solarb.getSanrbopl() != null) {
			where.append(" AND t1.SANRBOPL = ?");
			params.add(solarb.getSanrbopl());
		}
		if (solarb != null && solarb.getSafeenin() != null) {
			where.append(" AND t1.SAFEENIN = ?");
			params.add(solarb.getSafeenin());
		}
		if (solarb != null && solarb.getSafeoppe() != null) {
			where.append(" AND t1.SAFEOPPE = ?");
			params.add(solarb.getSafeoppe());
		}
		if (solarb != null && solarb.getSafeopla() != null) {
			where.append(" AND t1.SAFEOPLA = ?");
			params.add(solarb.getSafeopla());
		}
		if (solarb != null && solarb.getSafereco() != null) {
			where.append(" AND t1.SAFERECO = ?");
			params.add(solarb.getSafereco());
		}
		if (solarb != null && solarb.getSafenola() != null) {
			where.append(" AND t1.SAFENOLA = ?");
			params.add(solarb.getSafenola());
		}
		if (solarb != null && solarb.getSafenona() != null) {
			where.append(" AND t1.SAFENONA = ?");
			params.add(solarb.getSafenona());
		}
		if (solarb != null && solarb.getSaferena() != null) {
			where.append(" AND t1.SAFERENA = ?");
			params.add(solarb.getSaferena());
		}
		if (solarb != null && solarb.getSafecona() != null) {
			where.append(" AND t1.SAFECONA = ?");
			params.add(solarb.getSafecona());
		}
		if (solarb != null && solarb.getSapub() != null) {
			where.append(" AND t1.SAPUB = ?");
			params.add(solarb.getSapub());
		}
		if (solarb != null && solarb.getSaintica() != null) {
			where.append(" AND t1.SAINTICA = ?");
			params.add(solarb.getSaintica());
		}
		if (solarb != null && solarb.getSacotir() != null) {
			where.append(" AND t1.SACOTIR = ?");
			params.add(solarb.getSacotir());
		}
		if (solarb != null && solarb.getSacops() != null) {
			where.append(" AND t1.SACOPS = ?");
			params.add(solarb.getSacops());
		}
		// Busqueda de solicitudes por ooee
		if (solarb != null && solarb.getOoee() != null && solarb.getOoee().getOecodigo() != null) {
			where.append(" AND ( ");
			where.append(" t1.SACOOECO=? ");
			params.add(solarb.getOoee().getOecodigo());
			where.append(" OR t1.SACOOECO2=? ");
			params.add(solarb.getOoee().getOecodigo());
			where.append(" OR t1.SACOOECOS=? ");
			params.add(solarb.getOoee().getOecodigo());
			where.append(" OR t1.SACOOECO2S=? ");
			params.add(solarb.getOoee().getOecodigo());
			where.append(" ) ");
		}
		// Busqueda de solicitudes por aacc
		if (solarb != null && solarb.getAacc() != null && solarb.getAacc().getCccodigo() != null) {
			where.append(" AND ( ");
			where.append(" t1.SACOCCCO=? ");
			params.add(solarb.getAacc().getCccodigo());
			where.append(" OR t1.SACOCCCO2=? ");
			params.add(solarb.getAacc().getCccodigo());
			where.append(" OR t1.SACOCCCOS=? ");
			params.add(solarb.getAacc().getCccodigo());
			where.append(" OR t1.SACOCCCO2S=? ");
			params.add(solarb.getAacc().getCccodigo());
			where.append(" ) ");
		}
		// Busqueda de solicitudes por arbitro
		if (solarb != null && solarb.getArbitro() != null && solarb.getArbitro().getArcodigo() != null) {
			where.append(" AND ( ");
			where.append(" t1.SACOARPT=? ");
			params.add(solarb.getArbitro().getArcodigo());
			where.append(" OR t1.SACOARPS=? ");
			params.add(solarb.getArbitro().getArcodigo());
			where.append(" OR t1.SACOARTT=? ");
			params.add(solarb.getArbitro().getArcodigo());
			where.append(" OR t1.SACOARTS=? ");
			params.add(solarb.getArbitro().getArcodigo());
			where.append(" OR t1.SACOARDT=? ");
			params.add(solarb.getArbitro().getArcodigo());
			where.append(" OR t1.SACOARDS=? ");
			params.add(solarb.getArbitro().getArcodigo());
			where.append(" OR t1.SACOARPT2=? ");
			params.add(solarb.getArbitro().getArcodigo());
			where.append(" OR t1.SACOARPS2=? ");
			params.add(solarb.getArbitro().getArcodigo());
			where.append(" OR t1.SACOARTT2=? ");
			params.add(solarb.getArbitro().getArcodigo());
			where.append(" OR t1.SACOARTS2=? ");
			params.add(solarb.getArbitro().getArcodigo());
			where.append(" OR t1.SACOARDT2=? ");
			params.add(solarb.getArbitro().getArcodigo());
			where.append(" OR t1.SACOARDS2=? ");
			params.add(solarb.getArbitro().getArcodigo());
			where.append(" ) ");
		}
		// Busqueda de solicitudes por perito
		if (solarb != null && solarb.getEmpper() != null && solarb.getEmpper().getPecodigo() != null) {
			where.append(" AND ( ");
			where.append(" t1.SACOPE1=? ");
			params.add(solarb.getEmpper().getPecodigo());
			where.append(" OR t1.SACOPE2=? ");
			params.add(solarb.getEmpper().getPecodigo());
			where.append(" ) ");
		}
		if (solarb != null && solarb.getJjaa() != null && solarb.getJjaa().getJacodigo() != null) {
			where.append(" AND t1.SACOJA=? ");
			params.add(solarb.getJjaa().getJacodigo());
		}

		// Busqueda de solicitudes por lugar de audiencia

		if (solarb != null && solarb.getTclugaud() != null && solarb.getTclugaud().getT4codigo() != null) {
			where.append(" AND ( ");
			where.append(" t1.SACOT4=? ");
			params.add(solarb.getTclugaud().getT4codigo());
			where.append(" ) ");
		}
		// TODO: Busqueda condicin abierto

		// Filtro calendario de audiencias
		if (solarb != null && solarb.getSafeciauDesde() != null && solarb.getSafeciauHasta() != null
				&& solarb.getSafeciau2Desde() != null && solarb.getSafeciau2Hasta() != null) {
			where.append(" AND ( ");
			if (solarb != null && solarb.getSafeciauDesde() != null && solarb.getSafeciauDesde() instanceof Date) {
				where.append(" ( to_char(t1.SAFECIAU,'yyyymmdd') >= ?");
				try {
					params.add(Y41bUtils.formatearDateToString(solarb.getSafeciauDesde(), "yyyyMMdd"));
				} catch (Exception e) {

				}
			}
			if (solarb != null && solarb.getSafeciauHasta() != null && solarb.getSafeciauHasta() instanceof Date) {
				where.append(" AND to_char(t1.SAFECIAU,'yyyymmdd') <= ? )");
				try {
					params.add(Y41bUtils.formatearDateToString(solarb.getSafeciauHasta(), "yyyyMMdd"));
				} catch (Exception e) {

				}
			}
			where.append(" OR ");
			if (solarb != null && solarb.getSafeciau2Desde() != null && solarb.getSafeciau2Desde() instanceof Date) {
				where.append(" ( to_char(t1.SAFECIAU2,'yyyymmdd') >= ?");
				try {
					params.add(Y41bUtils.formatearDateToString(solarb.getSafeciau2Desde(), "yyyyMMdd"));
				} catch (Exception e) {

				}
			}
			if (solarb != null && solarb.getSafeciau2Hasta() != null && solarb.getSafeciau2Hasta() instanceof Date) {
				where.append(" AND to_char(t1.SAFECIAU2,'yyyymmdd') <= ? )");
				try {
					params.add(Y41bUtils.formatearDateToString(solarb.getSafeciau2Hasta(), "yyyyMMdd"));
				} catch (Exception e) {

				}
			}
			where.append(" ) ");
			// EVOLUTIVO 0134898 2.8
			if (solarb != null && solarb.getArbexp() != null && solarb.getArbexp().getExmocodigo() != null) {
				where.append(" AND t8.EXMOCODIGO =?");
				params.add(solarb.getArbexp().getExmocodigo());
			}
			// EVOLUTIVO 0134898 2.8
		}

		// Filtro calendario de pruebas
		if (solarb != null && solarb.getSafereprDesde() != null && solarb.getSafereprHasta() != null) {
			if (solarb != null && solarb.getSafereprDesde() != null && solarb.getSafereprDesde() instanceof Date) {
				where.append(" AND to_char(t1.SAFEREPR,'yyyymmdd') >= ?");
				try {
					params.add(Y41bUtils.formatearDateToString(solarb.getSafereprDesde(), "yyyyMMdd"));
				} catch (Exception e) {

				}
			}
			if (solarb != null && solarb.getSafereprHasta() != null && solarb.getSafereprHasta() instanceof Date) {
				where.append(" AND to_char(t1.SAFEREPR,'yyyymmdd') <= ? ");
				try {
					params.add(Y41bUtils.formatearDateToString(solarb.getSafereprHasta(), "yyyyMMdd"));
				} catch (Exception e) {

				}
			}
		}
		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Solarb entity
	 * 
	 * @param solarb
	 *            Solarb Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Solarb solarb, Boolean startsWith) {

		StringBuilder where = new StringBuilder(SolarbDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (solarb != null && solarb.getSacodigo() != null) {
			where.append(" AND UPPER(t1.SACODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSacodigo().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSacodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.SACODIGO IS NOT NULL");
		}
		if (solarb != null && solarb.getZddestad() != null && solarb.getZddestad().getXjcodigo() != null) {
			where.append(" AND t2.XJCODIGO = ?");
			params.add(solarb.getZddestad().getXjcodigo());
		}
		if (solarb != null && solarb.getZddestad() != null && solarb.getZddestad().getXjidex() != null) {
			where.append(" AND UPPER(t2.XJIDEX) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getZddestad().getXjidex().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getZddestad().getXjidex().toUpperCase() + "%");
			}
			where.append(" AND t2.XJIDEX IS NOT NULL");
		}
		if (solarb != null && solarb.getZddestad() != null && solarb.getZddestad().getXjnombre() != null) {
			where.append(" AND UPPER(t2.XJNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getZddestad().getXjnombre().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getZddestad().getXjnombre().toUpperCase() + "%");
			}
			where.append(" AND t2.XJNOMBRE IS NOT NULL");
		}
		if (solarb != null && solarb.getZddestad() != null && solarb.getZddestad().getXjvalor() != null) {
			where.append(" AND UPPER(t2.XJVALOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getZddestad().getXjvalor().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getZddestad().getXjvalor().toUpperCase() + "%");
			}
			where.append(" AND t2.XJVALOR IS NOT NULL");
		}
		if (solarb != null && solarb.getTcmotina() != null && solarb.getTcmotina().getT5codigo() != null) {
			where.append(" AND t3.T5CODIGO = ?");
			params.add(solarb.getTcmotina().getT5codigo());
		}
		if (solarb != null && solarb.getTcmotina() != null && solarb.getTcmotina().getT5nombre() != null) {
			where.append(" AND UPPER(t3.T5NOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getTcmotina().getT5nombre().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getTcmotina().getT5nombre().toUpperCase() + "%");
			}
			where.append(" AND t3.T5NOMBRE IS NOT NULL");
		}
		if (solarb != null && solarb.getTcmonola() != null && solarb.getTcmonola().getT7codigo() != null) {
			where.append(" AND t4.T7CODIGO = ?");
			params.add(solarb.getTcmonola().getT7codigo());
		}
		if (solarb != null && solarb.getTcmonola() != null && solarb.getTcmonola().getT7nombre() != null) {
			where.append(" AND UPPER(t4.T7NOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getTcmonola().getT7nombre().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getTcmonola().getT7nombre().toUpperCase() + "%");
			}
			where.append(" AND t4.T7NOMBRE IS NOT NULL");
		}
		if (solarb != null && solarb.getTcmotdes() != null && solarb.getTcmotdes().getTmdcodigo() != null) {
			where.append(" AND t5.TMDCODIGO = ?");
			params.add(solarb.getTcmotdes().getTmdcodigo());
		}
		if (solarb != null && solarb.getTcmotdes() != null && solarb.getTcmotdes().getTmdnombre() != null) {
			where.append(" AND UPPER(t5.TMDNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getTcmotdes().getTmdnombre().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getTcmotdes().getTmdnombre().toUpperCase() + "%");
			}
			where.append(" AND t5.TMDNOMBRE IS NOT NULL");
		}
		if (solarb != null && solarb.getSacoset2() != null) {
			where.append(" AND t1.SACOSEST2 = ?");
			params.add(solarb.getSacoset2());
		}

		if (solarb != null && solarb.getTclugaud() != null && solarb.getTclugaud().getT4codigo() != null) {
			where.append(" AND t7.T4CODIGO = ?");
			params.add(solarb.getTclugaud().getT4codigo());
		}
		if (solarb != null && solarb.getTclugaud() != null && solarb.getTclugaud().getT4nombre() != null) {
			where.append(" AND UPPER(t7.T4NOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getTclugaud().getT4nombre().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getTclugaud().getT4nombre().toUpperCase() + "%");
			}
			where.append(" AND t7.T4NOMBRE IS NOT NULL");
		}
		if (solarb != null && solarb.getSacoset() != null) {
			where.append(" AND t1.SACOSET = ?");
			params.add(solarb.getSacoset());
		}
		if (solarb != null && solarb.getSacoses2() != null) {
			where.append(" AND t1.SACOSES2 = ?");
			params.add(solarb.getSacoses2());
		}
		if (solarb != null && solarb.getSacoses() != null) {
			where.append(" AND t1.SACOSES = ?");
			params.add(solarb.getSacoses());
		}
		if (solarb != null && solarb.getSacohd() != null) {
			where.append(" AND UPPER(t1.SACOHD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSacohd().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSacohd().toUpperCase() + "%");
			}
			where.append(" AND t1.SACOHD IS NOT NULL");
		}
		if (solarb != null && solarb.getSacoja() != null) {
			where.append(" AND UPPER(t1.SACOJA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSacoja().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSacoja().toUpperCase() + "%");
			}
			where.append(" AND t1.SACOJA IS NOT NULL");
		}
		if (solarb != null && solarb.getSanror() != null) {
			where.append(" AND t1.SANROR = ?");
			params.add(solarb.getSanror());
		}
		if (solarb != null && solarb.getSanran() != null) {
			where.append(" AND t1.SANRAN = ?");
			params.add(solarb.getSanran());
		}
		if (solarb != null && solarb.getSafesoli() != null) {
			where.append(" AND t1.SAFESOLI = ?");
			params.add(solarb.getSafesoli());
		}
		if (solarb != null && solarb.getSanodidc() != null) {
			where.append(" AND UPPER(t1.SANODIDC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSanodidc().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSanodidc().toUpperCase() + "%");
			}
			where.append(" AND t1.SANODIDC IS NOT NULL");
		}
		if (solarb != null && solarb.getSacolodc() != null) {
			where.append(" AND UPPER(t1.SACOLODC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSacolodc().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSacolodc().toUpperCase() + "%");
			}
			where.append(" AND t1.SACOLODC IS NOT NULL");
		}
		if (solarb != null && solarb.getSanolodc() != null) {
			where.append(" AND UPPER(t1.SANOLODC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSanolodc().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSanolodc().toUpperCase() + "%");
			}
			where.append(" AND t1.SANOLODC IS NOT NULL");
		}
		if (solarb != null && solarb.getSacopvdc() != null) {
			where.append(" AND UPPER(t1.SACOPVDC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSacopvdc().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSacopvdc().toUpperCase() + "%");
			}
			where.append(" AND t1.SACOPVDC IS NOT NULL");
		}
		if (solarb != null && solarb.getSacomudc() != null) {
			where.append(" AND UPPER(t1.SACOMUDC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSacomudc().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSacomudc().toUpperCase() + "%");
			}
			where.append(" AND t1.SACOMUDC IS NOT NULL");
		}
		if (solarb != null && solarb.getSanrcpdc() != null) {
			where.append(" AND UPPER(t1.SANRCPDC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSanrcpdc().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSanrcpdc().toUpperCase() + "%");
			}
			where.append(" AND t1.SANRCPDC IS NOT NULL");
		}
		if (solarb != null && solarb.getSainacuo() != null) {
			where.append(" AND UPPER(t1.SAINACUO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSainacuo().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSainacuo().toUpperCase() + "%");
			}
			where.append(" AND t1.SAINACUO IS NOT NULL");
		}
		if (solarb != null && solarb.getSacoorpr() != null) {
			where.append(" AND UPPER(t1.SACOORPR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSacoorpr().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSacoorpr().toUpperCase() + "%");
			}
			where.append(" AND t1.SACOORPR IS NOT NULL");
		}
		if (solarb != null && solarb.getSacosere() != null) {
			where.append(" AND UPPER(t1.SACOSERE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSacosere().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSacosere().toUpperCase() + "%");
			}
			where.append(" AND t1.SACOSERE IS NOT NULL");
		}
		if (solarb != null && solarb.getSacotti() != null) {
			where.append(" AND UPPER(t1.SACOTTI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSacotti().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSacotti().toUpperCase() + "%");
			}
			where.append(" AND t1.SACOTTI IS NOT NULL");
		}
		if (solarb != null && solarb.getSaintiso() != null) {
			where.append(" AND UPPER(t1.SAINTISO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSaintiso().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSaintiso().toUpperCase() + "%");
			}
			where.append(" AND t1.SAINTISO IS NOT NULL");
		}
		if (solarb != null && solarb.getSacnrecl() != null) {
			where.append(" AND t1.SACNRECL = ?");
			params.add(solarb.getSacnrecl());
		}
		if (solarb != null && solarb.getSateobrc() != null) {
			where.append(" AND UPPER(t1.SATEOBRC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSateobrc().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSateobrc().toUpperCase() + "%");
			}
			where.append(" AND t1.SATEOBRC IS NOT NULL");
		}
		if (solarb != null && solarb.getSafeinad() != null) {
			where.append(" AND t1.SAFEINAD = ?");
			params.add(solarb.getSafeinad());
		}
		if (solarb != null && solarb.getSateinad() != null) {
			where.append(" AND UPPER(t1.SATEINAD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSateinad().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSateinad().toUpperCase() + "%");
			}
			where.append(" AND t1.SATEINAD IS NOT NULL");
		}
		if (solarb != null && solarb.getSafereit() != null) {
			where.append(" AND t1.SAFEREIT = ?");
			params.add(solarb.getSafereit());
		}
		if (solarb != null && solarb.getSafetras() != null) {
			where.append(" AND t1.SAFETRAS = ?");
			params.add(solarb.getSafetras());
		}
		if (solarb != null && solarb.getSacoortr() != null) {
			where.append(" AND UPPER(t1.SACOORTR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSacoortr().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSacoortr().toUpperCase() + "%");
			}
			where.append(" AND t1.SACOORTR IS NOT NULL");
		}
		if (solarb != null && solarb.getSaferett() != null) {
			where.append(" AND t1.SAFERETT = ?");
			params.add(solarb.getSaferett());
		}
		if (solarb != null && solarb.getSaferets() != null) {
			where.append(" AND t1.SAFERETS = ?");
			params.add(solarb.getSaferets());
		}
		if (solarb != null && solarb.getSafemedi() != null) {
			where.append(" AND t1.SAFEMEDI = ?");
			params.add(solarb.getSafemedi());
		}
		if (solarb != null && solarb.getSainreme() != null) {
			where.append(" AND UPPER(t1.SAINREME) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSainreme().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSainreme().toUpperCase() + "%");
			}
			where.append(" AND t1.SAINREME IS NOT NULL");
		}
		if (solarb != null && solarb.getSaferemt() != null) {
			where.append(" AND t1.SAFEREMT = ?");
			params.add(solarb.getSaferemt());
		}
		if (solarb != null && solarb.getSafedesi() != null) {
			where.append(" AND t1.SAFEDESI = ?");
			params.add(solarb.getSafedesi());
		}
		if (solarb != null && solarb.getSaferedt() != null) {
			where.append(" AND t1.SAFEREDT = ?");
			params.add(solarb.getSaferedt());
		}
		if (solarb != null && solarb.getSafenoco() != null) {
			where.append(" AND t1.SAFENOCO = ?");
			params.add(solarb.getSafenoco());
		}
		if (solarb != null && solarb.getSaferear() != null) {
			where.append(" AND t1.SAFEREAR = ?");
			params.add(solarb.getSaferear());
		}
		if (solarb != null && solarb.getSafedeco() != null) {
			where.append(" AND t1.SAFEDECO = ?");
			params.add(solarb.getSafedeco());
		}
		if (solarb != null && solarb.getSacoarpt() != null) {
			where.append(" AND UPPER(t1.SACOARPT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSacoarpt().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSacoarpt().toUpperCase() + "%");
			}
			where.append(" AND t1.SACOARPT IS NOT NULL");
		}
		if (solarb != null && solarb.getSainmencpt() != null) {
			where.append(" AND UPPER(t1.SAINMENCPT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSainmencpt().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSainmencpt().toUpperCase() + "%");
			}
			where.append(" AND t1.SAINMENCPT IS NOT NULL");
		}
		if (solarb != null && solarb.getSainrencpt() != null) {
			where.append(" AND UPPER(t1.SAINRENCPT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSainrencpt().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSainrencpt().toUpperCase() + "%");
			}
			where.append(" AND t1.SAINRENCPT IS NOT NULL");
		}
		if (solarb != null && solarb.getSacoarps() != null) {
			where.append(" AND UPPER(t1.SACOARPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSacoarps().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSacoarps().toUpperCase() + "%");
			}
			where.append(" AND t1.SACOARPS IS NOT NULL");
		}
		if (solarb != null && solarb.getSainmencps() != null) {
			where.append(" AND UPPER(t1.SAINMENCPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSainmencps().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSainmencps().toUpperCase() + "%");
			}
			where.append(" AND t1.SAINMENCPS IS NOT NULL");
		}
		if (solarb != null && solarb.getSainrencps() != null) {
			where.append(" AND UPPER(t1.SAINRENCPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSainrencps().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSainrencps().toUpperCase() + "%");
			}
			where.append(" AND t1.SAINRENCPS IS NOT NULL");
		}
		if (solarb != null && solarb.getSacoartt() != null) {
			where.append(" AND UPPER(t1.SACOARTT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSacoartt().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSacoartt().toUpperCase() + "%");
			}
			where.append(" AND t1.SACOARTT IS NOT NULL");
		}
		if (solarb != null && solarb.getSainmenctt() != null) {
			where.append(" AND UPPER(t1.SAINMENCTT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSainmenctt().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSainmenctt().toUpperCase() + "%");
			}
			where.append(" AND t1.SAINMENCTT IS NOT NULL");
		}
		if (solarb != null && solarb.getSainrenctt() != null) {
			where.append(" AND UPPER(t1.SAINRENCTT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSainrenctt().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSainrenctt().toUpperCase() + "%");
			}
			where.append(" AND t1.SAINRENCTT IS NOT NULL");
		}
		if (solarb != null && solarb.getSacoarts() != null) {
			where.append(" AND UPPER(t1.SACOARTS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSacoarts().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSacoarts().toUpperCase() + "%");
			}
			where.append(" AND t1.SACOARTS IS NOT NULL");
		}
		if (solarb != null && solarb.getSainmencts() != null) {
			where.append(" AND UPPER(t1.SAINMENCTS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSainmencts().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSainmencts().toUpperCase() + "%");
			}
			where.append(" AND t1.SAINMENCTS IS NOT NULL");
		}
		if (solarb != null && solarb.getSainrencts() != null) {
			where.append(" AND UPPER(t1.SAINRENCTS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSainrencts().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSainrencts().toUpperCase() + "%");
			}
			where.append(" AND t1.SAINRENCTS IS NOT NULL");
		}
		if (solarb != null && solarb.getSacoccco() != null) {
			where.append(" AND UPPER(t1.SACOCCCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSacoccco().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSacoccco().toUpperCase() + "%");
			}
			where.append(" AND t1.SACOCCCO IS NOT NULL");
		}
		if (solarb != null && solarb.getSacoardt() != null) {
			where.append(" AND UPPER(t1.SACOARDT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSacoardt().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSacoardt().toUpperCase() + "%");
			}
			where.append(" AND t1.SACOARDT IS NOT NULL");
		}
		if (solarb != null && solarb.getSainmencdt() != null) {
			where.append(" AND UPPER(t1.SAINMENCDT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSainmencdt().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSainmencdt().toUpperCase() + "%");
			}
			where.append(" AND t1.SAINMENCDT IS NOT NULL");
		}
		if (solarb != null && solarb.getSainrencdt() != null) {
			where.append(" AND UPPER(t1.SAINRENCDT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSainrencdt().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSainrencdt().toUpperCase() + "%");
			}
			where.append(" AND t1.SAINRENCDT IS NOT NULL");
		}
		if (solarb != null && solarb.getSacoards() != null) {
			where.append(" AND UPPER(t1.SACOARDS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSacoards().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSacoards().toUpperCase() + "%");
			}
			where.append(" AND t1.SACOARDS IS NOT NULL");
		}
		if (solarb != null && solarb.getSainmencds() != null) {
			where.append(" AND UPPER(t1.SAINMENCDS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSainmencds().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSainmencds().toUpperCase() + "%");
			}
			where.append(" AND t1.SAINMENCDS IS NOT NULL");
		}
		if (solarb != null && solarb.getSainrencds() != null) {
			where.append(" AND UPPER(t1.SAINRENCDS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSainrencds().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSainrencds().toUpperCase() + "%");
			}
			where.append(" AND t1.SAINRENCDS IS NOT NULL");
		}
		if (solarb != null && solarb.getSacooeco() != null) {
			where.append(" AND UPPER(t1.SACOOECO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSacooeco().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSacooeco().toUpperCase() + "%");
			}
			where.append(" AND t1.SACOOECO IS NOT NULL");
		}
		if (solarb != null && solarb.getSainmencst() != null) {
			where.append(" AND UPPER(t1.SAINMENCST) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSainmencst().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSainmencst().toUpperCase() + "%");
			}
			where.append(" AND t1.SAINMENCST IS NOT NULL");
		}
		if (solarb != null && solarb.getSainrencst() != null) {
			where.append(" AND UPPER(t1.SAINRENCST) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSainrencst().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSainrencst().toUpperCase() + "%");
			}
			where.append(" AND t1.SAINRENCST IS NOT NULL");
		}
		if (solarb != null && solarb.getSainmencss() != null) {
			where.append(" AND UPPER(t1.SAINMENCSS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSainmencss().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSainmencss().toUpperCase() + "%");
			}
			where.append(" AND t1.SAINMENCSS IS NOT NULL");
		}
		if (solarb != null && solarb.getSainrencss() != null) {
			where.append(" AND UPPER(t1.SAINRENCSS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSainrencss().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSainrencss().toUpperCase() + "%");
			}
			where.append(" AND t1.SAINRENCSS IS NOT NULL");
		}
		if (solarb != null && solarb.getSainmenct() != null) {
			where.append(" AND UPPER(t1.SAINMENCT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSainmenct().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSainmenct().toUpperCase() + "%");
			}
			where.append(" AND t1.SAINMENCT IS NOT NULL");
		}
		if (solarb != null && solarb.getSainrenct() != null) {
			where.append(" AND UPPER(t1.SAINRENCT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSainrenct().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSainrenct().toUpperCase() + "%");
			}
			where.append(" AND t1.SAINRENCT IS NOT NULL");
		}
		if (solarb != null && solarb.getSafeciau() != null) {
			where.append(" AND t1.SAFECIAU = ?");
			params.add(solarb.getSafeciau());
		}
		if (solarb != null && solarb.getSahrciau() != null) {
			where.append(" AND UPPER(t1.SAHRCIAU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSahrciau().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSahrciau().toUpperCase() + "%");
			}
			where.append(" AND t1.SAHRCIAU IS NOT NULL");
		}
		if (solarb != null && solarb.getSanolura() != null) {
			where.append(" AND UPPER(t1.SANOLURA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSanolura().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSanolura().toUpperCase() + "%");
			}
			where.append(" AND t1.SANOLURA IS NOT NULL");
		}
		if (solarb != null && solarb.getSanodira() != null) {
			where.append(" AND UPPER(t1.SANODIRA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSanodira().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSanodira().toUpperCase() + "%");
			}
			where.append(" AND t1.SANODIRA IS NOT NULL");
		}
		if (solarb != null && solarb.getSacoloa() != null) {
			where.append(" AND UPPER(t1.SACOLOA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSacoloa().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSacoloa().toUpperCase() + "%");
			}
			where.append(" AND t1.SACOLOA IS NOT NULL");
		}
		if (solarb != null && solarb.getSanrcpa() != null) {
			where.append(" AND UPPER(t1.SANRCPA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSanrcpa().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSanrcpa().toUpperCase() + "%");
			}
			where.append(" AND t1.SANRCPA IS NOT NULL");
		}
		if (solarb != null && solarb.getSainsopr() != null) {
			where.append(" AND UPPER(t1.SAINSOPR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSainsopr().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSainsopr().toUpperCase() + "%");
			}
			where.append(" AND t1.SAINSOPR IS NOT NULL");
		}
		if (solarb != null && solarb.getSaininpr() != null) {
			where.append(" AND UPPER(t1.SAININPR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSaininpr().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSaininpr().toUpperCase() + "%");
			}
			where.append(" AND t1.SAININPR IS NOT NULL");
		}
		if (solarb != null && solarb.getSateobpr() != null) {
			where.append(" AND UPPER(t1.SATEOBPR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSateobpr().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSateobpr().toUpperCase() + "%");
			}
			where.append(" AND t1.SATEOBPR IS NOT NULL");
		}
		if (solarb != null && solarb.getSacope1() != null) {
			where.append(" AND UPPER(t1.SACOPE1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSacope1().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSacope1().toUpperCase() + "%");
			}
			where.append(" AND t1.SACOPE1 IS NOT NULL");
		}
		if (solarb != null && solarb.getSacneupr1() != null) {
			where.append(" AND t1.SACNEUPR1 = ?");
			params.add(solarb.getSacneupr1());
		}
		if (solarb != null && solarb.getSacope2() != null) {
			where.append(" AND UPPER(t1.SACOPE2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSacope2().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSacope2().toUpperCase() + "%");
			}
			where.append(" AND t1.SACOPE2 IS NOT NULL");
		}
		if (solarb != null && solarb.getSacneupr2() != null) {
			where.append(" AND t1.SACNEUPR2 = ?");
			params.add(solarb.getSacneupr2());
		}
		if (solarb != null && solarb.getSafenopr() != null) {
			where.append(" AND t1.SAFENOPR = ?");
			params.add(solarb.getSafenopr());
		}
		if (solarb != null && solarb.getSainmenp1() != null) {
			where.append(" AND UPPER(t1.SAINMENP1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSainmenp1().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSainmenp1().toUpperCase() + "%");
			}
			where.append(" AND t1.SAINMENP1 IS NOT NULL");
		}
		if (solarb != null && solarb.getSainrenp1() != null) {
			where.append(" AND UPPER(t1.SAINRENP1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSainrenp1().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSainrenp1().toUpperCase() + "%");
			}
			where.append(" AND t1.SAINRENP1 IS NOT NULL");
		}
		if (solarb != null && solarb.getSainmenp2() != null) {
			where.append(" AND UPPER(t1.SAINMENP2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSainmenp2().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSainmenp2().toUpperCase() + "%");
			}
			where.append(" AND t1.SAINMENP2 IS NOT NULL");
		}
		if (solarb != null && solarb.getSainrenp2() != null) {
			where.append(" AND UPPER(t1.SAINRENP2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSainrenp2().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSainrenp2().toUpperCase() + "%");
			}
			where.append(" AND t1.SAINRENP2 IS NOT NULL");
		}
		if (solarb != null && solarb.getSainmenpt() != null) {
			where.append(" AND UPPER(t1.SAINMENPT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSainmenpt().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSainmenpt().toUpperCase() + "%");
			}
			where.append(" AND t1.SAINMENPT IS NOT NULL");
		}
		if (solarb != null && solarb.getSainrenpt() != null) {
			where.append(" AND UPPER(t1.SAINRENPT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSainrenpt().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSainrenpt().toUpperCase() + "%");
			}
			where.append(" AND t1.SAINRENPT IS NOT NULL");
		}
		if (solarb != null && solarb.getSanolup() != null) {
			where.append(" AND UPPER(t1.SANOLUP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSanolup().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSanolup().toUpperCase() + "%");
			}
			where.append(" AND t1.SANOLUP IS NOT NULL");
		}
		if (solarb != null && solarb.getSanodirp() != null) {
			where.append(" AND UPPER(t1.SANODIRP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSanodirp().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSanodirp().toUpperCase() + "%");
			}
			where.append(" AND t1.SANODIRP IS NOT NULL");
		}
		if (solarb != null && solarb.getSacolop() != null) {
			where.append(" AND UPPER(t1.SACOLOP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSacolop().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSacolop().toUpperCase() + "%");
			}
			where.append(" AND t1.SACOLOP IS NOT NULL");
		}
		if (solarb != null && solarb.getSanrcopop() != null) {
			where.append(" AND UPPER(t1.SANRCOPOP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSanrcopop().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSanrcopop().toUpperCase() + "%");
			}
			where.append(" AND t1.SANRCOPOP IS NOT NULL");
		}
		if (solarb != null && solarb.getSanopvp() != null) {
			where.append(" AND UPPER(t1.SANOPVP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSanopvp().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSanopvp().toUpperCase() + "%");
			}
			where.append(" AND t1.SANOPVP IS NOT NULL");
		}
		if (solarb != null && solarb.getSanrtelp() != null) {
			where.append(" AND UPPER(t1.SANRTELP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSanrtelp().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSanrtelp().toUpperCase() + "%");
			}
			where.append(" AND t1.SANRTELP IS NOT NULL");
		}
		if (solarb != null && solarb.getSanrfaxp() != null) {
			where.append(" AND UPPER(t1.SANRFAXP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSanrfaxp().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSanrfaxp().toUpperCase() + "%");
			}
			where.append(" AND t1.SANRFAXP IS NOT NULL");
		}
		if (solarb != null && solarb.getSaferepr() != null) {
			where.append(" AND t1.SAFEREPR = ?");
			params.add(solarb.getSaferepr());
		}
		if (solarb != null && solarb.getSahrrepr() != null) {
			where.append(" AND UPPER(t1.SAHRREPR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSahrrepr().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSahrrepr().toUpperCase() + "%");
			}
			where.append(" AND t1.SAHRREPR IS NOT NULL");
		}
		if (solarb != null && solarb.getSacoarpt2() != null) {
			where.append(" AND UPPER(t1.SACOARPT2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSacoarpt2().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSacoarpt2().toUpperCase() + "%");
			}
			where.append(" AND t1.SACOARPT2 IS NOT NULL");
		}
		if (solarb != null && solarb.getSainmencpt2() != null) {
			where.append(" AND UPPER(t1.SAINMENCPT2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSainmencpt2().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSainmencpt2().toUpperCase() + "%");
			}
			where.append(" AND t1.SAINMENCPT2 IS NOT NULL");
		}
		if (solarb != null && solarb.getSainrencpt2() != null) {
			where.append(" AND UPPER(t1.SAINRENCPT2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSainrencpt2().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSainrencpt2().toUpperCase() + "%");
			}
			where.append(" AND t1.SAINRENCPT2 IS NOT NULL");
		}
		if (solarb != null && solarb.getSacoarps2() != null) {
			where.append(" AND UPPER(t1.SACOARPS2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSacoarps2().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSacoarps2().toUpperCase() + "%");
			}
			where.append(" AND t1.SACOARPS2 IS NOT NULL");
		}
		if (solarb != null && solarb.getSainmencps2() != null) {
			where.append(" AND UPPER(t1.SAINMENCPS2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSainmencps2().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSainmencps2().toUpperCase() + "%");
			}
			where.append(" AND t1.SAINMENCPS2 IS NOT NULL");
		}
		if (solarb != null && solarb.getSainrencps2() != null) {
			where.append(" AND UPPER(t1.SAINRENCPS2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSainrencps2().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSainrencps2().toUpperCase() + "%");
			}
			where.append(" AND t1.SAINRENCPS2 IS NOT NULL");
		}
		if (solarb != null && solarb.getSacoartt2() != null) {
			where.append(" AND UPPER(t1.SACOARTT2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSacoartt2().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSacoartt2().toUpperCase() + "%");
			}
			where.append(" AND t1.SACOARTT2 IS NOT NULL");
		}
		if (solarb != null && solarb.getSainmenctt2() != null) {
			where.append(" AND UPPER(t1.SAINMENCTT2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSainmenctt2().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSainmenctt2().toUpperCase() + "%");
			}
			where.append(" AND t1.SAINMENCTT2 IS NOT NULL");
		}
		if (solarb != null && solarb.getSainrenctt2() != null) {
			where.append(" AND UPPER(t1.SAINRENCTT2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSainrenctt2().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSainrenctt2().toUpperCase() + "%");
			}
			where.append(" AND t1.SAINRENCTT2 IS NOT NULL");
		}
		if (solarb != null && solarb.getSacoarts2() != null) {
			where.append(" AND UPPER(t1.SACOARTS2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSacoarts2().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSacoarts2().toUpperCase() + "%");
			}
			where.append(" AND t1.SACOARTS2 IS NOT NULL");
		}
		if (solarb != null && solarb.getSainmencts2() != null) {
			where.append(" AND UPPER(t1.SAINMENCTS2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSainmencts2().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSainmencts2().toUpperCase() + "%");
			}
			where.append(" AND t1.SAINMENCTS2 IS NOT NULL");
		}
		if (solarb != null && solarb.getSainrencts2() != null) {
			where.append(" AND UPPER(t1.SAINRENCTS2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSainrencts2().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSainrencts2().toUpperCase() + "%");
			}
			where.append(" AND t1.SAINRENCTS2 IS NOT NULL");
		}
		if (solarb != null && solarb.getSacoccco2() != null) {
			where.append(" AND UPPER(t1.SACOCCCO2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSacoccco2().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSacoccco2().toUpperCase() + "%");
			}
			where.append(" AND t1.SACOCCCO2 IS NOT NULL");
		}
		if (solarb != null && solarb.getSacoardt2() != null) {
			where.append(" AND UPPER(t1.SACOARDT2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSacoardt2().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSacoardt2().toUpperCase() + "%");
			}
			where.append(" AND t1.SACOARDT2 IS NOT NULL");
		}
		if (solarb != null && solarb.getSainmencdt2() != null) {
			where.append(" AND UPPER(t1.SAINMENCDT2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSainmencdt2().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSainmencdt2().toUpperCase() + "%");
			}
			where.append(" AND t1.SAINMENCDT2 IS NOT NULL");
		}
		if (solarb != null && solarb.getSainrencdt2() != null) {
			where.append(" AND UPPER(t1.SAINRENCDT2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSainrencdt2().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSainrencdt2().toUpperCase() + "%");
			}
			where.append(" AND t1.SAINRENCDT2 IS NOT NULL");
		}
		if (solarb != null && solarb.getSacoards2() != null) {
			where.append(" AND UPPER(t1.SACOARDS2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSacoards2().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSacoards2().toUpperCase() + "%");
			}
			where.append(" AND t1.SACOARDS2 IS NOT NULL");
		}
		if (solarb != null && solarb.getSainmencds2() != null) {
			where.append(" AND UPPER(t1.SAINMENCDS2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSainmencds2().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSainmencds2().toUpperCase() + "%");
			}
			where.append(" AND t1.SAINMENCDS2 IS NOT NULL");
		}
		if (solarb != null && solarb.getSainrencds2() != null) {
			where.append(" AND UPPER(t1.SAINRENCDS2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSainrencds2().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSainrencds2().toUpperCase() + "%");
			}
			where.append(" AND t1.SAINRENCDS2 IS NOT NULL");
		}
		if (solarb != null && solarb.getSacooeco2() != null) {
			where.append(" AND UPPER(t1.SACOOECO2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSacooeco2().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSacooeco2().toUpperCase() + "%");
			}
			where.append(" AND t1.SACOOECO2 IS NOT NULL");
		}
		if (solarb != null && solarb.getSainmencst2() != null) {
			where.append(" AND UPPER(t1.SAINMENCST2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSainmencst2().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSainmencst2().toUpperCase() + "%");
			}
			where.append(" AND t1.SAINMENCST2 IS NOT NULL");
		}
		if (solarb != null && solarb.getSainrencst2() != null) {
			where.append(" AND UPPER(t1.SAINRENCST2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSainrencst2().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSainrencst2().toUpperCase() + "%");
			}
			where.append(" AND t1.SAINRENCST2 IS NOT NULL");
		}
		if (solarb != null && solarb.getSainmencss2() != null) {
			where.append(" AND UPPER(t1.SAINMENCSS2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSainmencss2().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSainmencss2().toUpperCase() + "%");
			}
			where.append(" AND t1.SAINMENCSS2 IS NOT NULL");
		}
		if (solarb != null && solarb.getSainrencss2() != null) {
			where.append(" AND UPPER(t1.SAINRENCSS2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSainrencss2().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSainrencss2().toUpperCase() + "%");
			}
			where.append(" AND t1.SAINRENCSS2 IS NOT NULL");
		}
		if (solarb != null && solarb.getSainmenct2() != null) {
			where.append(" AND UPPER(t1.SAINMENCT2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSainmenct2().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSainmenct2().toUpperCase() + "%");
			}
			where.append(" AND t1.SAINMENCT2 IS NOT NULL");
		}
		if (solarb != null && solarb.getSainrenct2() != null) {
			where.append(" AND UPPER(t1.SAINRENCT2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSainrenct2().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSainrenct2().toUpperCase() + "%");
			}
			where.append(" AND t1.SAINRENCT2 IS NOT NULL");
		}
		if (solarb != null && solarb.getSafeciau2() != null) {
			where.append(" AND t1.SAFECIAU2 = ?");
			params.add(solarb.getSafeciau2());
		}
		if (solarb != null && solarb.getSahrciau2() != null) {
			where.append(" AND UPPER(t1.SAHRCIAU2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSahrciau2().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSahrciau2().toUpperCase() + "%");
			}
			where.append(" AND t1.SAHRCIAU2 IS NOT NULL");
		}
		if (solarb != null && solarb.getSanolura2() != null) {
			where.append(" AND UPPER(t1.SANOLURA2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSanolura2().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSanolura2().toUpperCase() + "%");
			}
			where.append(" AND t1.SANOLURA2 IS NOT NULL");
		}
		if (solarb != null && solarb.getSanodira2() != null) {
			where.append(" AND UPPER(t1.SANODIRA2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSanodira2().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSanodira2().toUpperCase() + "%");
			}
			where.append(" AND t1.SANODIRA2 IS NOT NULL");
		}
		if (solarb != null && solarb.getSacoloa2() != null) {
			where.append(" AND UPPER(t1.SACOLOA2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSacoloa2().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSacoloa2().toUpperCase() + "%");
			}
			where.append(" AND t1.SACOLOA2 IS NOT NULL");
		}
		if (solarb != null && solarb.getSanrcpa2() != null) {
			where.append(" AND UPPER(t1.SANRCPA2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSanrcpa2().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSanrcpa2().toUpperCase() + "%");
			}
			where.append(" AND t1.SANRCPA2 IS NOT NULL");
		}
		if (solarb != null && solarb.getSafelaud() != null) {
			where.append(" AND t1.SAFELAUD = ?");
			params.add(solarb.getSafelaud());
		}
		if (solarb != null && solarb.getSateobre() != null) {
			where.append(" AND UPPER(t1.SATEOBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSateobre().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSateobre().toUpperCase() + "%");
			}
			where.append(" AND t1.SATEOBRE IS NOT NULL");
		}
		if (solarb != null && solarb.getSatemore() != null) {
			where.append(" AND UPPER(t1.SATEMORE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSatemore().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSatemore().toUpperCase() + "%");
			}
			where.append(" AND t1.SATEMORE IS NOT NULL");
		}
		if (solarb != null && solarb.getSacneuil() != null) {
			where.append(" AND t1.SACNEUIL = ?");
			params.add(solarb.getSacneuil());
		}
		if (solarb != null && solarb.getSainfdla() != null) {
			where.append(" AND UPPER(t1.SAINFDLA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSainfdla().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSainfdla().toUpperCase() + "%");
			}
			where.append(" AND t1.SAINFDLA IS NOT NULL");
		}
		if (solarb != null && solarb.getSainvola() != null) {
			where.append(" AND UPPER(t1.SAINVOLA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSainvola().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSainvola().toUpperCase() + "%");
			}
			where.append(" AND t1.SAINVOLA IS NOT NULL");
		}
		if (solarb != null && solarb.getSainarnl() != null) {
			where.append(" AND UPPER(t1.SAINARNL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSainarnl().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSainarnl().toUpperCase() + "%");
			}
			where.append(" AND t1.SAINARNL IS NOT NULL");
		}
		if (solarb != null && solarb.getSafenolt() != null) {
			where.append(" AND t1.SAFENOLT = ?");
			params.add(solarb.getSafenolt());
		}
		if (solarb != null && solarb.getSainmelt() != null) {
			where.append(" AND UPPER(t1.SAINMELT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSainmelt().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSainmelt().toUpperCase() + "%");
			}
			where.append(" AND t1.SAINMELT IS NOT NULL");
		}
		if (solarb != null && solarb.getSainpubo() != null) {
			where.append(" AND UPPER(t1.SAINPUBO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSainpubo().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSainpubo().toUpperCase() + "%");
			}
			where.append(" AND t1.SAINPUBO IS NOT NULL");
		}
		if (solarb != null && solarb.getSacota1() != null) {
			where.append(" AND UPPER(t1.SACOTA1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSacota1().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSacota1().toUpperCase() + "%");
			}
			where.append(" AND t1.SACOTA1 IS NOT NULL");
		}
		if (solarb != null && solarb.getSafesera() != null) {
			where.append(" AND t1.SAFESERA = ?");
			params.add(solarb.getSafesera());
		}
		if (solarb != null && solarb.getSainfdra() != null) {
			where.append(" AND UPPER(t1.SAINFDRA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSainfdra().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSainfdra().toUpperCase() + "%");
			}
			where.append(" AND t1.SAINFDRA IS NOT NULL");
		}
		if (solarb != null && solarb.getSafepeex() != null) {
			where.append(" AND t1.SAFEPEEX = ?");
			params.add(solarb.getSafepeex());
		}
		if (solarb != null && solarb.getSainrain() != null) {
			where.append(" AND UPPER(t1.SAINRAIN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSainrain().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSainrain().toUpperCase() + "%");
			}
			where.append(" AND t1.SAINRAIN IS NOT NULL");
		}
		if (solarb != null && solarb.getSainefin() != null) {
			where.append(" AND UPPER(t1.SAINEFIN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSainefin().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSainefin().toUpperCase() + "%");
			}
			where.append(" AND t1.SAINEFIN IS NOT NULL");
		}
		if (solarb != null && solarb.getSafeinef() != null) {
			where.append(" AND t1.SAFEINEF = ?");
			params.add(solarb.getSafeinef());
		}
		if (solarb != null && solarb.getSafear() != null) {
			where.append(" AND t1.SAFEAR = ?");
			params.add(solarb.getSafear());
		}
		if (solarb != null && solarb.getSafenode() != null) {
			where.append(" AND t1.SAFENODE = ?");
			params.add(solarb.getSafenode());
		}
		if (solarb != null && solarb.getSaferelt() != null) {
			where.append(" AND t1.SAFERELT = ?");
			params.add(solarb.getSaferelt());
		}
		if (solarb != null && solarb.getSafenoca() != null) {
			where.append(" AND t1.SAFENOCA = ?");
			params.add(solarb.getSafenoca());
		}
		if (solarb != null && solarb.getSafenoca2() != null) {
			where.append(" AND t1.SAFENOCA2 = ?");
			params.add(solarb.getSafenoca2());
		}
		if (solarb != null && solarb.getSafenoar() != null) {
			where.append(" AND t1.SAFENOAR = ?");
			params.add(solarb.getSafenoar());
		}
		if (solarb != null && solarb.getSacocccos() != null) {
			where.append(" AND UPPER(t1.SACOCCCOS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSacocccos().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSacocccos().toUpperCase() + "%");
			}
			where.append(" AND t1.SACOCCCOS IS NOT NULL");
		}
		if (solarb != null && solarb.getSacoccco2s() != null) {
			where.append(" AND UPPER(t1.SACOCCCO2S) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSacoccco2s().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSacoccco2s().toUpperCase() + "%");
			}
			where.append(" AND t1.SACOCCCO2S IS NOT NULL");
		}
		if (solarb != null && solarb.getSacooecos() != null) {
			where.append(" AND UPPER(t1.SACOOECOS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSacooecos().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSacooecos().toUpperCase() + "%");
			}
			where.append(" AND t1.SACOOECOS IS NOT NULL");
		}
		if (solarb != null && solarb.getSacooeco2s() != null) {
			where.append(" AND UPPER(t1.SACOOECO2S) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSacooeco2s().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSacooeco2s().toUpperCase() + "%");
			}
			where.append(" AND t1.SACOOECO2S IS NOT NULL");
		}
		if (solarb != null && solarb.getSafesoac() != null) {
			where.append(" AND t1.SAFESOAC = ?");
			params.add(solarb.getSafesoac());
		}
		if (solarb != null && solarb.getSafeenac() != null) {
			where.append(" AND t1.SAFEENAC = ?");
			params.add(solarb.getSafeenac());
		}
		if (solarb != null && solarb.getSafenoac() != null) {
			where.append(" AND t1.SAFENOAC = ?");
			params.add(solarb.getSafenoac());
		}
		if (solarb != null && solarb.getSatefpr1() != null) {
			where.append(" AND UPPER(t1.SATEFPR1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSatefpr1().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSatefpr1().toUpperCase() + "%");
			}
			where.append(" AND t1.SATEFPR1 IS NOT NULL");
		}
		if (solarb != null && solarb.getSatefpr2() != null) {
			where.append(" AND UPPER(t1.SATEFPR2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSatefpr2().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSatefpr2().toUpperCase() + "%");
			}
			where.append(" AND t1.SATEFPR2 IS NOT NULL");
		}
		if (solarb != null && solarb.getSafefpr1() != null) {
			where.append(" AND t1.SAFEFPR1 = ?");
			params.add(solarb.getSafefpr1());
		}
		if (solarb != null && solarb.getSafefpr2() != null) {
			where.append(" AND t1.SAFEFPR2 = ?");
			params.add(solarb.getSafefpr2());
		}
		if (solarb != null && solarb.getSanrbopl() != null) {
			where.append(" AND UPPER(t1.SANRBOPL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSanrbopl().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSanrbopl().toUpperCase() + "%");
			}
			where.append(" AND t1.SANRBOPL IS NOT NULL");
		}
		if (solarb != null && solarb.getSafeenin() != null) {
			where.append(" AND t1.SAFEENIN = ?");
			params.add(solarb.getSafeenin());
		}
		if (solarb != null && solarb.getSafeoppe() != null) {
			where.append(" AND t1.SAFEOPPE = ?");
			params.add(solarb.getSafeoppe());
		}
		if (solarb != null && solarb.getSafeopla() != null) {
			where.append(" AND t1.SAFEOPLA = ?");
			params.add(solarb.getSafeopla());
		}
		if (solarb != null && solarb.getSafereco() != null) {
			where.append(" AND t1.SAFERECO = ?");
			params.add(solarb.getSafereco());
		}
		if (solarb != null && solarb.getSafenola() != null) {
			where.append(" AND t1.SAFENOLA = ?");
			params.add(solarb.getSafenola());
		}
		if (solarb != null && solarb.getSafenona() != null) {
			where.append(" AND t1.SAFENONA = ?");
			params.add(solarb.getSafenona());
		}
		if (solarb != null && solarb.getSaferena() != null) {
			where.append(" AND t1.SAFERENA = ?");
			params.add(solarb.getSaferena());
		}
		if (solarb != null && solarb.getSafecona() != null) {
			where.append(" AND t1.SAFECONA = ?");
			params.add(solarb.getSafecona());
		}
		if (solarb != null && solarb.getSapub() != null) {
			where.append(" AND UPPER(t1.SAPUB) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSapub().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSapub().toUpperCase() + "%");
			}
			where.append(" AND t1.SAPUB IS NOT NULL");
		}
		if (solarb != null && solarb.getSaintica() != null) {
			where.append(" AND UPPER(t1.SAINTICA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSaintica().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSaintica().toUpperCase() + "%");
			}
			where.append(" AND t1.SAINTICA IS NOT NULL");
		}
		if (solarb != null && solarb.getSacotir() != null) {
			where.append(" AND UPPER(t1.SACOTIR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSacotir().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSacotir().toUpperCase() + "%");
			}
			where.append(" AND t1.SACOTIR IS NOT NULL");
		}
		if (solarb != null && solarb.getSacops() != null) {
			where.append(" AND UPPER(t1.SACOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solarb.getSacops().toUpperCase() + "%");
			} else {
				params.add("%" + solarb.getSacops().toUpperCase() + "%");
			}
			where.append(" AND t1.SACOPS IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the FiltroArbitraje entity
	 * 
	 * @param filtroArbitraje
	 *            FiltroArbitraje Bean with the criteria values to filter by.
	 * @param filtroArbitraje
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	private Map<String, ?> getWhereMapRelacionarExpedientes(FiltroArbitraje filtroArb) {

		StringBuilder where = new StringBuilder(ExpedienDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (filtroArb != null && filtroArb.getSacoja() != null) {
			where.append(" AND UPPER(t1.SACOJA) like ? ESCAPE  '\\'");
			params.add("%" + filtroArb.getSacoja().toUpperCase() + "%");
			where.append(" AND t1.SACOJA IS NOT NULL");
		}
		if (filtroArb != null && filtroArb.getSanran() != null) {
			where.append(" AND t1.SANRAN = ?");
			params.add(filtroArb.getSanran());
		}
		if (filtroArb != null && filtroArb.getSanror() != null) {
			where.append(" AND t1.SANROR = ?");
			params.add(filtroArb.getSanror());
		}
		if (filtroArb != null && filtroArb.getFechaIniDesde() != null && filtroArb.getFechaIniDesde() instanceof Date) {
			where.append(" AND trunc(t1.SAFESOLI) >= trunc(?)");
			params.add(filtroArb.getFechaIniDesde());
		}
		if (filtroArb != null && filtroArb.getFechaIniHasta() != null && filtroArb.getFechaIniHasta() instanceof Date) {
			where.append(" AND trunc(t1.SAFESOLI) <= trunc(?)");
			params.add(filtroArb.getFechaIniHasta());
		}

		if (filtroArb != null && filtroArb.getFechaHechoDesde() != null
				&& filtroArb.getFechaHechoDesde() instanceof Date) {
			where.append(" AND trunc(NVL(T2.HDFECHD,t6.HDFEHD)) >= trunc(?)");
			params.add(filtroArb.getFechaHechoDesde());
		}
		if (filtroArb != null && filtroArb.getFechaHechoHasta() != null
				&& filtroArb.getFechaHechoHasta() instanceof Date) {
			where.append(" AND trunc(NVL(T2.HDFECHD,t6.HDFEHD)) <= trunc(?)");
			params.add(filtroArb.getFechaHechoHasta());
		}
		if (filtroArb != null && filtroArb.getArbintervReclamado() != null
				&& filtroArb.getArbintervReclamado().getUanif() != null) {
			where.append(" AND t5.ESNIF = ?");
			params.add(filtroArb.getArbintervReclamado().getUanif());
		}
		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * 
	 * @param filtroArbitraje
	 *            FiltroArbitraje
	 * @param sacodigo
	 *            String
	 * @param relacionados
	 *            String
	 * @param pagination
	 *            Pagination
	 * @return List<FiltroArbitraje>
	 */
	public List<FiltroArbitraje> findAllArbitrajeRelacionar(FiltroArbitraje filtroArbitraje, String sacodigo,
			String relacionados, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT DISTINCT t1.SACODIGO SACODIGO, t1.SACOJA SACOJA, t1.SANRAN SANRAN, t1.SANROR SANROR, LPAD(t1.SANROR,12,'0') CORRELATIVOPAD, t1.SAFESOLI  SAFESOLI,  t3.MOCODIGO MOCODIGO, t5.ESCODIGO ESCODIGO, t5.ESNIF ESNIF, t2.EXCODIGO ARBEXPEXCODIGO, NVL(t2.HDFECHD,t6.HDFEHD) ARBEXPHDFECHD, t2.EXDESCES ARBEXPEXDESCES, t2.EXDESCEU ARBEXPEXDESCEU, t2.EXFECINI ARBEXPEXFECINI, t2.EXFECPREVFIN ARBEXPEXFECPREVFIN, t2.EXFECFIN ARBEXPEXFECFIN, t2.EXTIPRES ARBEXPEXTIPRES, t2.EXMOCODIGO ARBEXPEXMOCODIGO, t2.EXFCODIGO ARBEXPEXFCODIGO, t2.EXMOCODIGOULT ARBEXPEXMOCODIGOULT, t2.EXTRPOSCOD ARBEXPEXTRPOSCOD, t3.MOCODIGO monitorMOCODIGO, t3.MONOMBRE monitorMONOMBRE "
						+ "FROM SOLARB t1, ARBEXP t2, CENSO_MONITOR t3,  ESSA t4, ESTABLECIMIENTO t5, HECHO_DENUNCIADO t6 ");
		StringBuilder where = new StringBuilder(
				" WHERE t1.SACODIGO=t2.EXCODIGO(+) AND t1.SACOHD=t6.HDCODIGO(+) AND t2.EXMOCODIGO=t3.MOCODIGO(+) AND t1.SACODIGO=t4.MACOSA AND t4.MACOES=t5.ESCODIGO ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMapRelacionarExpedientes(filtroArbitraje);
		where.append(" AND SACODIGO <> '").append(sacodigo).append("'");
		if (!"".equals(relacionados)) {
			String[] arrayValores = relacionados.split(",");
			for (int i = 0; i < arrayValores.length; i++) {
				where.append("AND SACODIGO <> '").append(arrayValores[i]).append("'");
			}
		}
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<FiltroArbitraje>) this.jdbcTemplate.query(query.toString(), this.rwMapBusquedaArbitrajeRel,
				params.toArray());
	}

	/**
	 * findAllCountArbitrajeRelacionar
	 * 
	 * @param filtroArbitraje
	 *            FiltroArbitraje
	 * @param sacodigo
	 *            String
	 * @param relacionados
	 *            String
	 * @return Long
	 */
	public Long findAllCountArbitrajeRelacionar(FiltroArbitraje filtroArbitraje, String sacodigo, String relacionados) {

		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM SOLARB t1, ARBEXP t2, CENSO_MONITOR t3,  ESSA t4, ESTABLECIMIENTO t5, HECHO_DENUNCIADO t6 ");
		StringBuilder where = new StringBuilder(
				" WHERE t1.SACODIGO=t2.EXCODIGO(+) AND t1.SACOHD=t6.HDCODIGO(+) AND t2.EXMOCODIGO=t3.MOCODIGO(+) AND t1.SACODIGO=t4.MACOSA AND t4.MACOES=t5.ESCODIGO ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMapRelacionarExpedientes(filtroArbitraje);
		where.append(" AND SACODIGO <> '").append(sacodigo).append("'");
		if (!"".equals(relacionados)) {
			String[] arrayValores = relacionados.split(",");
			for (int i = 0; i < arrayValores.length; i++) {
				where.append("AND SACODIGO <> '").append(arrayValores[i]).append("'");
			}
		}
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * @return long
	 */
	public long getNewEsperaPK() {
		List<Object> params = new ArrayList<Object>();

		StringBuffer query = new StringBuffer("SELECT L21D7Q00.NEXTVAL FROM DUAL ");
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * @param arbitro
	 *            Arbitro
	 * @return Arbitro
	 */
	public Arbitro obtenerCargaArbitro(Arbitro arbitro) {
		// arbitro.setNumArbitrajes12(new BigDecimal(cargaArbitro(arbitro,
		// Y41bConstantes.NUM_12)));
		// arbitro.setNumArbitrajes6(new BigDecimal(cargaArbitro(arbitro,
		// Y41bConstantes.NUM_6)));
		// arbitro.setNumArbitrajes3(new BigDecimal(cargaArbitro(arbitro,
		// Y41bConstantes.NUM_3)));
		// arbitro.setNumArbitrajes1(new BigDecimal(cargaArbitro(arbitro,
		// Y41bConstantes.NUM_1)));

		// int numMesesEsteAnyo = Y41bUtils.obtenerFechaHoy().getMonth() + 1;
		arbitro.setNumArbitrajesAnyoNatural(
				new BigDecimal(cargaArbitro(arbitro/* , numMesesEsteAnyo */)));

		return arbitro;
	}

	/**
	 * @param arbitro
	 *            Arbitro
	 * @return Arbitro
	 */
	private int cargaArbitro(Arbitro arbitro) {
		// Contar los arbitrajes de los arbitros activos
		StringBuilder query1 = new StringBuilder("SELECT SUM(NUM) FROM (");
		// query1.append("SELECT COUNT(*) AS NUM FROM ARBCOLEGIO,SOLARB WHERE
		// XJARCODIGOP=SACOARPT AND XJACTIVOP='"
		// + Y41bConstantes.SI
		// +
		// "' AND SACOARPT2 IS NULL AND SAFECIAU<SYSDATE AND SAFECIAU>? AND
		// SACOARPT=? ");
		// query1.append("UNION SELECT COUNT(*) AS NUM FROM ARBCOLEGIO,SOLARB
		// WHERE XJARCODIGOP=SACOARPT2 AND XJACTIVOP='"
		// + Y41bConstantes.SI
		// + "' AND SAFECIAU<SYSDATE AND SAFECIAU2>? AND SACOARPT2=? ");
		// query1.append("UNION SELECT COUNT(*) AS NUM FROM ARBCOLEGIO,SOLARB
		// WHERE XJARCODIGOPSUP=SACOARPS AND XJACTIVOPSUP='"
		// + Y41bConstantes.SI
		// +
		// "' AND SACOARPS2 IS NULL AND SAFECIAU<SYSDATE AND SAFECIAU>? AND
		// SACOARPS=? ");
		// query1.append("UNION SELECT COUNT(*) AS NUM FROM ARBCOLEGIO,SOLARB
		// WHERE XJARCODIGOPSUP=SACOARPS2 AND XJACTIVOPSUP='"
		// + Y41bConstantes.SI
		// + "' AND SAFECIAU<SYSDATE AND SAFECIAU2>? AND SACOARPS2=? ");
		// query1.append("UNION SELECT COUNT(*) AS NUM FROM ARBCOLEGIO,SOLARB
		// WHERE XJARCODIGOAACC=SACOARTT AND XJACTIVOAACC='"
		// + Y41bConstantes.SI
		// +
		// "' AND SACOARTT2 IS NULL AND SAFECIAU<SYSDATE AND SAFECIAU>? AND
		// SACOARTT=? ");
		// query1.append("UNION SELECT COUNT(*) AS NUM FROM ARBCOLEGIO,SOLARB
		// WHERE XJARCODIGOAACC=SACOARTT2 AND XJACTIVOAACC='"
		// + Y41bConstantes.SI
		// + "' AND SAFECIAU<SYSDATE AND SAFECIAU2>? AND SACOARTT2=? ");
		// query1.append("UNION SELECT COUNT(*) AS NUM FROM ARBCOLEGIO,SOLARB
		// WHERE XJARCODIGOAACCSUP=SACOARTS AND XJACTIVOAACCSUP='"
		// + Y41bConstantes.SI
		// +
		// "' AND SACOARTS2 IS NULL AND SAFECIAU<SYSDATE AND SAFECIAU>? AND
		// SACOARTS=? ");
		// query1.append("UNION SELECT COUNT(*) AS NUM FROM ARBCOLEGIO,SOLARB
		// WHERE XJARCODIGOAACCSUP=SACOARTS2 AND XJACTIVOAACCSUP='"
		// + Y41bConstantes.SI
		// + "' AND SAFECIAU<SYSDATE AND SAFECIAU2>? AND SACOARTS2=? ");
		// query1.append("UNION SELECT COUNT(*) AS NUM FROM ARBCOLEGIO,SOLARB
		// WHERE XJARCODIGOOOEE=SACOARDT AND XJACTIVOOOEE='"
		// + Y41bConstantes.SI
		// +
		// "' AND SACOARDT2 IS NULL AND SAFECIAU<SYSDATE AND SAFECIAU>? AND
		// SACOARDT=? ");
		// query1.append("UNION SELECT COUNT(*) AS NUM FROM ARBCOLEGIO,SOLARB
		// WHERE XJARCODIGOOOEE=SACOARDT2 AND XJACTIVOOOEE='"
		// + Y41bConstantes.SI
		// + "' AND SAFECIAU<SYSDATE AND SAFECIAU2>? AND SACOARDT2=? ");
		// query1.append("UNION SELECT COUNT(*) AS NUM FROM ARBCOLEGIO,SOLARB
		// WHERE XJARCODIGOOOEESUP=SACOARDS AND XJACTIVOOOEESUP='"
		// + Y41bConstantes.SI
		// +
		// "' AND SACOARDS2 IS NULL AND SAFECIAU<SYSDATE AND SAFECIAU>? AND
		// SACOARDS=? ");
		// query1.append("UNION SELECT COUNT(*) AS NUM FROM ARBCOLEGIO,SOLARB
		// WHERE XJARCODIGOOOEESUP=SACOARDS2 AND XJACTIVOOOEESUP='"
		// + Y41bConstantes.SI
		// + "' AND SAFECIAU<SYSDATE AND SAFECIAU2>? AND SACOARDS2=?");
		// GUILLE
		query1.append(
				"SELECT COUNT(*) AS NUM FROM ARBCOLEGIO,ARBTRAMEXP,SOLARB WHERE SACODIGO=TREXCODIGO AND TRID = XJTRID AND TRID IN (SELECT TRID FROM (SELECT TRID FROM ARBTRAMEXP,SOLARB WHERE TRCODIGO='"
						+ Y41bConstantes.TRAMITE_ARBITRAJE_DESIGNACION_COLEGIO
						+ "' AND TREXCODIGO=SOLARB.SACODIGO AND TRESTADO='" + Y41bConstantes.ESTADO_TRAMITE_TRAMITADO
						+ "' ORDER BY TRFECFIN DESC) WHERE ROWNUM=1) AND XJACTIVOP='" + Y41bConstantes.SI
						+ "' AND TRFECDESIGNA>? AND XJARCODIGOP=? ");
		query1.append(
				"UNION SELECT COUNT(*) AS NUM FROM ARBCOLEGIO,ARBTRAMEXP,SOLARB WHERE SACODIGO=TREXCODIGO AND TRID = XJTRID AND TRID IN (SELECT TRID FROM (SELECT TRID FROM ARBTRAMEXP,SOLARB WHERE TRCODIGO='"
						+ Y41bConstantes.TRAMITE_ARBITRAJE_DESIGNACION_COLEGIO
						+ "' AND TREXCODIGO=SOLARB.SACODIGO AND TRESTADO='" + Y41bConstantes.ESTADO_TRAMITE_TRAMITADO
						+ "' ORDER BY TRFECFIN DESC) WHERE ROWNUM=1) AND XJACTIVOPSUP='" + Y41bConstantes.SI
						+ "' AND TRFECDESIGNA>? AND XJARCODIGOPSUP=? ");
		query1.append(
				"UNION SELECT COUNT(*) AS NUM FROM ARBCOLEGIO,ARBTRAMEXP,SOLARB WHERE SACODIGO=TREXCODIGO AND TRID = XJTRID AND TRID IN (SELECT TRID FROM (SELECT TRID FROM ARBTRAMEXP,SOLARB WHERE TRCODIGO='"
						+ Y41bConstantes.TRAMITE_ARBITRAJE_DESIGNACION_COLEGIO
						+ "' AND TREXCODIGO=SOLARB.SACODIGO AND TRESTADO='" + Y41bConstantes.ESTADO_TRAMITE_TRAMITADO
						+ "' ORDER BY TRFECFIN DESC) WHERE ROWNUM=1) AND XJACTIVOAACC='" + Y41bConstantes.SI
						+ "' AND TRFECDESIGNA>? AND XJARCODIGOAACC=? ");
		query1.append(
				"UNION SELECT COUNT(*) AS NUM FROM ARBCOLEGIO,ARBTRAMEXP,SOLARB WHERE SACODIGO=TREXCODIGO AND TRID = XJTRID AND TRID IN (SELECT TRID FROM (SELECT TRID FROM ARBTRAMEXP,SOLARB WHERE TRCODIGO='"
						+ Y41bConstantes.TRAMITE_ARBITRAJE_DESIGNACION_COLEGIO
						+ "' AND TREXCODIGO=SOLARB.SACODIGO AND TRESTADO='" + Y41bConstantes.ESTADO_TRAMITE_TRAMITADO
						+ "' ORDER BY TRFECFIN DESC) WHERE ROWNUM=1) AND XJACTIVOAACCSUP='" + Y41bConstantes.SI
						+ "' AND TRFECDESIGNA>? AND XJARCODIGOAACCSUP=? ");
		query1.append(
				"UNION SELECT COUNT(*) AS NUM FROM ARBCOLEGIO,ARBTRAMEXP,SOLARB WHERE SACODIGO=TREXCODIGO AND TRID = XJTRID AND TRID IN (SELECT TRID FROM (SELECT TRID FROM ARBTRAMEXP,SOLARB WHERE TRCODIGO='"
						+ Y41bConstantes.TRAMITE_ARBITRAJE_DESIGNACION_COLEGIO
						+ "' AND TREXCODIGO=SOLARB.SACODIGO AND TRESTADO='" + Y41bConstantes.ESTADO_TRAMITE_TRAMITADO
						+ "' ORDER BY TRFECFIN DESC) WHERE ROWNUM=1) AND XJACTIVOOOEE='" + Y41bConstantes.SI
						+ "' AND TRFECDESIGNA>? AND XJARCODIGOOOEE=? ");
		query1.append(
				"UNION SELECT COUNT(*) AS NUM FROM ARBCOLEGIO,ARBTRAMEXP,SOLARB WHERE SACODIGO=TREXCODIGO AND TRID = XJTRID AND TRID IN (SELECT TRID FROM (SELECT TRID FROM ARBTRAMEXP,SOLARB WHERE TRCODIGO='"
						+ Y41bConstantes.TRAMITE_ARBITRAJE_DESIGNACION_COLEGIO
						+ "' AND TREXCODIGO=SOLARB.SACODIGO AND TRESTADO='" + Y41bConstantes.ESTADO_TRAMITE_TRAMITADO
						+ "' ORDER BY TRFECFIN DESC) WHERE ROWNUM=1) AND XJACTIVOOOEESUP='" + Y41bConstantes.SI
						+ "' AND TRFECDESIGNA>? AND XJARCODIGOOOEESUP=? ");
		query1.append(")");
		// GUILLE
		List<Object> params = new ArrayList<Object>();
		Calendar calendar = Calendar.getInstance();
		calendar.set(Calendar.MONTH, 0);
		calendar.set(Calendar.DAY_OF_MONTH, 1);
		calendar.set(Calendar.HOUR_OF_DAY, 0);
		calendar.set(Calendar.MINUTE, 0);
		calendar.set(Calendar.SECOND, 0);
		calendar.set(Calendar.MILLISECOND, 0);
		params.add(calendar.getTime());
		params.add(arbitro.getArcodigo());
		params.add(calendar.getTime());
		params.add(arbitro.getArcodigo());
		params.add(calendar.getTime());
		params.add(arbitro.getArcodigo());
		params.add(calendar.getTime());
		params.add(arbitro.getArcodigo());
		params.add(calendar.getTime());
		params.add(arbitro.getArcodigo());
		params.add(calendar.getTime());
		params.add(arbitro.getArcodigo());

		return this.jdbcTemplate.queryForInt(query1.toString(), params.toArray());
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.y41b.dao.SolarbDao#findArbitrajeByNumeroExpediente(com.ejie.
	 * y41b.model.Solarb)
	 */
	@Transactional(readOnly = true)
	public Solarb findArbitrajeByNumeroExpediente(Solarb filterSolarb) {
		String query = "SELECT t1.SACODIGO SACODIGO, t1.SACOHD SACOHD, t1.SACOJA SACOJA, t1.SANROR SANROR, t1.SANRAN SANRAN, t1.SAFESOLI SAFESOLI, t1.SANODIDC SANODIDC, t1.SACOLODC SACOLODC, t1.SANOLODC SANOLODC, t1.SACOPVDC SACOPVDC, t1.SACOMUDC SACOMUDC, t1.SANRCPDC SANRCPDC, t1.SAINACUO SAINACUO, t1.SACOORPR SACOORPR, t1.SACOSERE SACOSERE, t1.SACOTTI SACOTTI, t1.SAINTISO SAINTISO, t1.SACNRECL SACNRECL, t1.SATEOBRC SATEOBRC, t1.SAFEINAD SAFEINAD, t1.SATEINAD SATEINAD, t1.SAFEREIT SAFEREIT, t1.SAFETRAS SAFETRAS, t1.SACOORTR SACOORTR, t1.SAFERETT SAFERETT, t1.SAFERETS SAFERETS, t1.SAFEMEDI SAFEMEDI, t1.SAINREME SAINREME, t1.SAFEREMT SAFEREMT, t1.SAFEDESI SAFEDESI, t1.SAFEREDT SAFEREDT, t1.SAFENOCO SAFENOCO, t1.SAFEREAR SAFEREAR, t1.SAFEDECO SAFEDECO, t1.SACOARPT SACOARPT, t1.SAINMENCPT SAINMENCPT, t1.SAINRENCPT SAINRENCPT, t1.SACOARPS SACOARPS, t1.SAINMENCPS SAINMENCPS, t1.SAINRENCPS SAINRENCPS, t1.SACOARTT SACOARTT, t1.SAINMENCTT SAINMENCTT, t1.SAINRENCTT SAINRENCTT, t1.SACOARTS SACOARTS, t1.SAINMENCTS SAINMENCTS, t1.SAINRENCTS SAINRENCTS, t1.SACOCCCO SACOCCCO, t1.SACOARDT SACOARDT, t1.SAINMENCDT SAINMENCDT, t1.SAINRENCDT SAINRENCDT, t1.SACOARDS SACOARDS, t1.SAINMENCDS SAINMENCDS, t1.SAINRENCDS SAINRENCDS, t1.SACOOECO SACOOECO, t1.SAINMENCST SAINMENCST, t1.SAINRENCST SAINRENCST, t1.SAINMENCSS SAINMENCSS, t1.SAINRENCSS SAINRENCSS, t1.SAINMENCT SAINMENCT, t1.SAINRENCT SAINRENCT, t1.SAFECIAU SAFECIAU, t1.SAHRCIAU SAHRCIAU, t1.SANOLURA SANOLURA, t1.SANODIRA SANODIRA, t1.SACOLOA SACOLOA, t1.SANRCPA SANRCPA, t1.SAINSOPR SAINSOPR, t1.SAININPR SAININPR, t1.SATEOBPR SATEOBPR, t1.SACOPE1 SACOPE1, t1.SACNEUPR1 SACNEUPR1, t1.SACOPE2 SACOPE2, t1.SACNEUPR2 SACNEUPR2, t1.SAFENOPR SAFENOPR, t1.SAINMENP1 SAINMENP1, t1.SAINRENP1 SAINRENP1, t1.SAINMENP2 SAINMENP2, t1.SAINRENP2 SAINRENP2, t1.SAINMENPT SAINMENPT, t1.SAINRENPT SAINRENPT, t1.SANOLUP SANOLUP, t1.SANODIRP SANODIRP, t1.SACOLOP SACOLOP, t1.SANRCOPOP SANRCOPOP, t1.SANOPVP SANOPVP, t1.SANRTELP SANRTELP, t1.SANRFAXP SANRFAXP, t1.SAFEREPR SAFEREPR, t1.SAHRREPR SAHRREPR, t1.SACOARPT2 SACOARPT2, t1.SAINMENCPT2 SAINMENCPT2, t1.SAINRENCPT2 SAINRENCPT2, t1.SACOARPS2 SACOARPS2, t1.SAINMENCPS2 SAINMENCPS2, t1.SAINRENCPS2 SAINRENCPS2, t1.SACOARTT2 SACOARTT2, t1.SAINMENCTT2 SAINMENCTT2, t1.SAINRENCTT2 SAINRENCTT2, t1.SACOARTS2 SACOARTS2, t1.SAINMENCTS2 SAINMENCTS2, t1.SAINRENCTS2 SAINRENCTS2, t1.SACOCCCO2 SACOCCCO2, t1.SACOARDT2 SACOARDT2, t1.SAINMENCDT2 SAINMENCDT2, t1.SAINRENCDT2 SAINRENCDT2, t1.SACOARDS2 SACOARDS2, t1.SAINMENCDS2 SAINMENCDS2, t1.SAINRENCDS2 SAINRENCDS2, t1.SACOOECO2 SACOOECO2, t1.SAINMENCST2 SAINMENCST2, t1.SAINRENCST2 SAINRENCST2, t1.SAINMENCSS2 SAINMENCSS2, t1.SAINRENCSS2 SAINRENCSS2, t1.SAINMENCT2 SAINMENCT2, t1.SAINRENCT2 SAINRENCT2, t1.SAFECIAU2 SAFECIAU2, t1.SAHRCIAU2 SAHRCIAU2, t1.SANOLURA2 SANOLURA2, t1.SANODIRA2 SANODIRA2, t1.SACOLOA2 SACOLOA2, t1.SANRCPA2 SANRCPA2, t1.SAFELAUD SAFELAUD, t1.SATEOBRE SATEOBRE, t1.SATEMORE SATEMORE, t1.SACNEUIL SACNEUIL, t1.SAINFDLA SAINFDLA, t1.SAINVOLA SAINVOLA, t1.SAINARNL SAINARNL, t1.SAFENOLT SAFENOLT, t1.SAINMELT SAINMELT, t1.SAINPUBO SAINPUBO, t1.SACOTA1 SACOTA1, t1.SAFESERA SAFESERA, t1.SAINFDRA SAINFDRA, t1.SAFEPEEX SAFEPEEX, t1.SAINRAIN SAINRAIN, t1.SAINEFIN SAINEFIN, t1.SAFEINEF SAFEINEF, t1.SAFEAR SAFEAR, t1.SAFENODE SAFENODE, t1.SAFERELT SAFERELT, t1.SAFENOCA SAFENOCA, t1.SAFENOCA2 SAFENOCA2, t1.SAFENOAR SAFENOAR, t1.SACOCCCOS SACOCCCOS, t1.SACOCCCO2S SACOCCCO2S, t1.SACOOECOS SACOOECOS, t1.SACOOECO2S SACOOECO2S, t1.SAFESOAC SAFESOAC, t1.SAFEENAC SAFEENAC, t1.SAFENOAC SAFENOAC, t1.SATEFPR1 SATEFPR1, t1.SATEFPR2 SATEFPR2, t1.SAFEFPR1 SAFEFPR1, t1.SAFEFPR2 SAFEFPR2, t1.SANRBOPL SANRBOPL, t1.SAFEENIN SAFEENIN, t1.SAFEOPPE SAFEOPPE, t1.SAFEOPLA SAFEOPLA, t1.SAFERECO SAFERECO, t1.SAFENOLA SAFENOLA, t1.SAFENONA SAFENONA, t1.SAFERENA SAFERENA, t1.SAFECONA SAFECONA, t1.SAPUB SAPUB, t1.SAINTICA SAINTICA, t1.SACOTIR SACOTIR, t1.SACOPS SACOPS, t1.SACOSAAC SACOSAAC, t1.SACOSET2 SACOSET2, t1.SACOSET SACOSET, t1.SACOSES2 SACOSES2,t1.SACOSES SACOSES, t2.XJCODIGO ZDDESTADXJCODIGO, t2.XJIDEX ZDDESTADXJIDEX, t2.XJNOMBRE ZDDESTADXJNOMBRE, t2.XJVALOR ZDDESTADXJVALOR, t3.T5CODIGO TCMOTINAT5CODIGO, t3.T5NOMBRE TCMOTINAT5NOMBRE, t3.T5NOMBREEU TCMOTINAT5NOMBREEU,t4.T7CODIGO TCMONOLAT7CODIGO, t4.T7NOMBRE TCMONOLAT7NOMBRE, t5.TMDCODIGO TCMOTDESTMDCODIGO, t5.TMDNOMBRE TCMOTDESTMDNOMBRE, t7.T4CODIGO TCLUGAUDT4CODIGO, t7.T4NOMBRE TCLUGAUDT4NOMBRE,t7.T4NOMBREEU TCLUGAUDT4NOMBREEU, t8.EXIDPARTICIPACIONRECLAMANTE, t8.EXIDPARTICIPACIONRECLAMADO "
				+ " ,t8.EXCODIGO EXCODIGO, t8.EXFCODIGO EXFCODIGO "
				+ " FROM SOLARB t1 , ZDDESTAD t2 , TCMOTINA t3 , TCMONOLA t4 , TCMOTDES t5 , TCLUGAUD t7, ARBEXP t8  WHERE t1.SACOJA = ? AND t1.SANRAN=? AND t1.SANROR=? AND t1.SACODIGO=t8.EXCODIGO(+) AND t1.SACOXJ= t2.XJCODIGO(+) AND t1.SACOT5= t3.T5CODIGO(+) AND t1.SACOT7= t4.T7CODIGO(+) AND t1.SACOTMD= t5.TMDCODIGO(+) AND t1.SACOT4= t7.T4CODIGO(+) ";

		List<Solarb> expedienList = this.jdbcTemplate.query(query, this.rwMap, filterSolarb.getSacoja(),
				filterSolarb.getSanran(), filterSolarb.getSanror());
		return (Solarb) DataAccessUtils.uniqueResult(expedienList);

	}

	/**
	 * findArbitrajeByNumeroRegistro
	 * 
	 * @param filterSolarb
	 *            filtro
	 * @return Solarb
	 */
	@Transactional(readOnly = true)
	public Solarb findArbitrajeByNumeroRegistro(Solarb filterSolarb) {
		String query = "SELECT t1.SACODIGO SACODIGO, t1.SACOHD SACOHD, t1.SACOJA SACOJA, t1.SANROR SANROR, t1.SANRAN SANRAN, t1.SAFESOLI SAFESOLI, t1.SANODIDC SANODIDC, t1.SACOLODC SACOLODC, t1.SANOLODC SANOLODC, t1.SACOPVDC SACOPVDC, t1.SACOMUDC SACOMUDC, t1.SANRCPDC SANRCPDC, t1.SAINACUO SAINACUO, t1.SACOORPR SACOORPR, t1.SACOSERE SACOSERE, t1.SACOTTI SACOTTI, t1.SAINTISO SAINTISO, t1.SACNRECL SACNRECL, t1.SATEOBRC SATEOBRC, t1.SAFEINAD SAFEINAD, t1.SATEINAD SATEINAD, t1.SAFEREIT SAFEREIT, t1.SAFETRAS SAFETRAS, t1.SACOORTR SACOORTR, t1.SAFERETT SAFERETT, t1.SAFERETS SAFERETS, t1.SAFEMEDI SAFEMEDI, t1.SAINREME SAINREME, t1.SAFEREMT SAFEREMT, t1.SAFEDESI SAFEDESI, t1.SAFEREDT SAFEREDT, t1.SAFENOCO SAFENOCO, t1.SAFEREAR SAFEREAR, t1.SAFEDECO SAFEDECO, t1.SACOARPT SACOARPT, t1.SAINMENCPT SAINMENCPT, t1.SAINRENCPT SAINRENCPT, t1.SACOARPS SACOARPS, t1.SAINMENCPS SAINMENCPS, t1.SAINRENCPS SAINRENCPS, t1.SACOARTT SACOARTT, t1.SAINMENCTT SAINMENCTT, t1.SAINRENCTT SAINRENCTT, t1.SACOARTS SACOARTS, t1.SAINMENCTS SAINMENCTS, t1.SAINRENCTS SAINRENCTS, t1.SACOCCCO SACOCCCO, t1.SACOARDT SACOARDT, t1.SAINMENCDT SAINMENCDT, t1.SAINRENCDT SAINRENCDT, t1.SACOARDS SACOARDS, t1.SAINMENCDS SAINMENCDS, t1.SAINRENCDS SAINRENCDS, t1.SACOOECO SACOOECO, t1.SAINMENCST SAINMENCST, t1.SAINRENCST SAINRENCST, t1.SAINMENCSS SAINMENCSS, t1.SAINRENCSS SAINRENCSS, t1.SAINMENCT SAINMENCT, t1.SAINRENCT SAINRENCT, t1.SAFECIAU SAFECIAU, t1.SAHRCIAU SAHRCIAU, t1.SANOLURA SANOLURA, t1.SANODIRA SANODIRA, t1.SACOLOA SACOLOA, t1.SANRCPA SANRCPA, t1.SAINSOPR SAINSOPR, t1.SAININPR SAININPR, t1.SATEOBPR SATEOBPR, t1.SACOPE1 SACOPE1, t1.SACNEUPR1 SACNEUPR1, t1.SACOPE2 SACOPE2, t1.SACNEUPR2 SACNEUPR2, t1.SAFENOPR SAFENOPR, t1.SAINMENP1 SAINMENP1, t1.SAINRENP1 SAINRENP1, t1.SAINMENP2 SAINMENP2, t1.SAINRENP2 SAINRENP2, t1.SAINMENPT SAINMENPT, t1.SAINRENPT SAINRENPT, t1.SANOLUP SANOLUP, t1.SANODIRP SANODIRP, t1.SACOLOP SACOLOP, t1.SANRCOPOP SANRCOPOP, t1.SANOPVP SANOPVP, t1.SANRTELP SANRTELP, t1.SANRFAXP SANRFAXP, t1.SAFEREPR SAFEREPR, t1.SAHRREPR SAHRREPR, t1.SACOARPT2 SACOARPT2, t1.SAINMENCPT2 SAINMENCPT2, t1.SAINRENCPT2 SAINRENCPT2, t1.SACOARPS2 SACOARPS2, t1.SAINMENCPS2 SAINMENCPS2, t1.SAINRENCPS2 SAINRENCPS2, t1.SACOARTT2 SACOARTT2, t1.SAINMENCTT2 SAINMENCTT2, t1.SAINRENCTT2 SAINRENCTT2, t1.SACOARTS2 SACOARTS2, t1.SAINMENCTS2 SAINMENCTS2, t1.SAINRENCTS2 SAINRENCTS2, t1.SACOCCCO2 SACOCCCO2, t1.SACOARDT2 SACOARDT2, t1.SAINMENCDT2 SAINMENCDT2, t1.SAINRENCDT2 SAINRENCDT2, t1.SACOARDS2 SACOARDS2, t1.SAINMENCDS2 SAINMENCDS2, t1.SAINRENCDS2 SAINRENCDS2, t1.SACOOECO2 SACOOECO2, t1.SAINMENCST2 SAINMENCST2, t1.SAINRENCST2 SAINRENCST2, t1.SAINMENCSS2 SAINMENCSS2, t1.SAINRENCSS2 SAINRENCSS2, t1.SAINMENCT2 SAINMENCT2, t1.SAINRENCT2 SAINRENCT2, t1.SAFECIAU2 SAFECIAU2, t1.SAHRCIAU2 SAHRCIAU2, t1.SANOLURA2 SANOLURA2, t1.SANODIRA2 SANODIRA2, t1.SACOLOA2 SACOLOA2, t1.SANRCPA2 SANRCPA2, t1.SAFELAUD SAFELAUD, t1.SATEOBRE SATEOBRE, t1.SATEMORE SATEMORE, t1.SACNEUIL SACNEUIL, t1.SAINFDLA SAINFDLA, t1.SAINVOLA SAINVOLA, t1.SAINARNL SAINARNL, t1.SAFENOLT SAFENOLT, t1.SAINMELT SAINMELT, t1.SAINPUBO SAINPUBO, t1.SACOTA1 SACOTA1, t1.SAFESERA SAFESERA, t1.SAINFDRA SAINFDRA, t1.SAFEPEEX SAFEPEEX, t1.SAINRAIN SAINRAIN, t1.SAINEFIN SAINEFIN, t1.SAFEINEF SAFEINEF, t1.SAFEAR SAFEAR, t1.SAFENODE SAFENODE, t1.SAFERELT SAFERELT, t1.SAFENOCA SAFENOCA, t1.SAFENOCA2 SAFENOCA2, t1.SAFENOAR SAFENOAR, t1.SACOCCCOS SACOCCCOS, t1.SACOCCCO2S SACOCCCO2S, t1.SACOOECOS SACOOECOS, t1.SACOOECO2S SACOOECO2S, t1.SAFESOAC SAFESOAC, t1.SAFEENAC SAFEENAC, t1.SAFENOAC SAFENOAC, t1.SATEFPR1 SATEFPR1, t1.SATEFPR2 SATEFPR2, t1.SAFEFPR1 SAFEFPR1, t1.SAFEFPR2 SAFEFPR2, t1.SANRBOPL SANRBOPL, t1.SAFEENIN SAFEENIN, t1.SAFEOPPE SAFEOPPE, t1.SAFEOPLA SAFEOPLA, t1.SAFERECO SAFERECO, t1.SAFENOLA SAFENOLA, t1.SAFENONA SAFENONA, t1.SAFERENA SAFERENA, t1.SAFECONA SAFECONA, t1.SAPUB SAPUB, t1.SAINTICA SAINTICA, t1.SACOTIR SACOTIR, t1.SACOPS SACOPS, t1.SACOSAAC SACOSAAC, t1.SACOSET2 SACOSET2, t1.SACOSET SACOSET, t1.SACOSES2 SACOSES2,t1.SACOSES SACOSES, t2.XJCODIGO ZDDESTADXJCODIGO, t2.XJIDEX ZDDESTADXJIDEX, t2.XJNOMBRE ZDDESTADXJNOMBRE, t2.XJVALOR ZDDESTADXJVALOR, t3.T5CODIGO TCMOTINAT5CODIGO, t3.T5NOMBRE TCMOTINAT5NOMBRE, t3.T5NOMBREEU TCMOTINAT5NOMBREEU,t4.T7CODIGO TCMONOLAT7CODIGO, t4.T7NOMBRE TCMONOLAT7NOMBRE, t5.TMDCODIGO TCMOTDESTMDCODIGO, t5.TMDNOMBRE TCMOTDESTMDNOMBRE, t7.T4CODIGO TCLUGAUDT4CODIGO, t7.T4NOMBRE TCLUGAUDT4NOMBRE,t7.T4NOMBREEU TCLUGAUDT4NOMBREEU, t8.EXIDPARTICIPACIONRECLAMANTE, t8.EXIDPARTICIPACIONRECLAMADO "
				+ " ,t8.EXCODIGO EXCODIGO, t8.EXFCODIGO EXFCODIGO "
				+ " FROM SOLARB t1 , ZDDESTAD t2 , TCMOTINA t3 , TCMONOLA t4 , TCMOTDES t5 , TCLUGAUD t7, ARBEXP t8  WHERE t8.EXREGEN = ? AND t1.SACODIGO=t8.EXCODIGO(+) AND t1.SACOXJ= t2.XJCODIGO(+) AND t1.SACOT5= t3.T5CODIGO(+) AND t1.SACOT7= t4.T7CODIGO(+) AND t1.SACOTMD= t5.TMDCODIGO(+) AND t1.SACOT4= t7.T4CODIGO(+) ";
		try {
			List<Solarb> expedienList = this.jdbcTemplate.query(query, this.rwMap,
					filterSolarb.getArbexp().getExregen());
			return (Solarb) DataAccessUtils.uniqueResult(expedienList);
		} catch (IncorrectResultSizeDataAccessException e) {
			return new Solarb();
		}
	}

	private RowMapper<SolarbKgest> rwMapKgest = new RowMapper<SolarbKgest>() {
		public SolarbKgest mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			SolarbKgest solarbKgest = new SolarbKgest(resultSet.getString("SACODIGO"), resultSet.getString("SACOHD"),
					resultSet.getString("SACOJA"), resultSet.getBigDecimal("SANROR"), resultSet.getBigDecimal("SANRAN"),
					resultSet.getDate("SAFESOLI"), resultSet.getString("SANODIDC"), resultSet.getString("SACOLODC"),
					resultSet.getString("SANOLODC"), resultSet.getString("SACOPVDC"), resultSet.getString("SACOMUDC"),
					resultSet.getString("SANRCPDC"), resultSet.getString("SAINACUO"), resultSet.getString("SACOORPR"),
					resultSet.getString("SACOSERE"), resultSet.getString("SACOTTI"), resultSet.getString("SAINTISO"),
					resultSet.getBigDecimal("SACNRECL"), resultSet.getString("SATEOBRC"), resultSet.getDate("SAFEINAD"),
					resultSet.getString("SATEINAD"), resultSet.getDate("SAFEREIT"), resultSet.getDate("SAFETRAS"),
					resultSet.getString("SACOORTR"), resultSet.getDate("SAFERETT"), resultSet.getDate("SAFERETS"),
					resultSet.getDate("SAFEMEDI"), resultSet.getString("SAINREME"), resultSet.getDate("SAFEREMT"),
					resultSet.getDate("SAFEDESI"), resultSet.getDate("SAFEREDT"), resultSet.getDate("SAFENOCO"),
					resultSet.getDate("SAFEREAR"), resultSet.getDate("SAFEDECO"), resultSet.getString("SACOARPT"),
					resultSet.getString("SAINMENCPT"), resultSet.getString("SAINRENCPT"),
					resultSet.getString("SACOARPS"), resultSet.getString("SAINMENCPS"),
					resultSet.getString("SAINRENCPS"), resultSet.getString("SACOARTT"),
					resultSet.getString("SAINMENCTT"), resultSet.getString("SAINRENCTT"),
					resultSet.getString("SACOARTS"), resultSet.getString("SAINMENCTS"),
					resultSet.getString("SAINRENCTS"), resultSet.getString("SACOCCCO"), resultSet.getString("SACOARDT"),
					resultSet.getString("SAINMENCDT"), resultSet.getString("SAINRENCDT"),
					resultSet.getString("SACOARDS"), resultSet.getString("SAINMENCDS"),
					resultSet.getString("SAINRENCDS"), resultSet.getString("SACOOECO"),
					resultSet.getString("SAINMENCST"), resultSet.getString("SAINRENCST"),
					resultSet.getString("SAINMENCSS"), resultSet.getString("SAINRENCSS"),
					resultSet.getString("SAINMENCT"), resultSet.getString("SAINRENCT"), resultSet.getDate("SAFECIAU"),
					resultSet.getString("SAHRCIAU"), resultSet.getString("SANOLURA"), resultSet.getString("SANODIRA"),
					resultSet.getString("SACOLOA"), resultSet.getString("SANRCPA"), resultSet.getString("SAINSOPR"),
					resultSet.getString("SAININPR"), resultSet.getString("SATEOBPR"), resultSet.getString("SACOPE1"),
					resultSet.getBigDecimal("SACNEUPR1"), resultSet.getString("SACOPE2"),
					resultSet.getBigDecimal("SACNEUPR2"), resultSet.getDate("SAFENOPR"),
					resultSet.getString("SAINMENP1"), resultSet.getString("SAINRENP1"),
					resultSet.getString("SAINMENP2"), resultSet.getString("SAINRENP2"),
					resultSet.getString("SAINMENPT"), resultSet.getString("SAINRENPT"), resultSet.getString("SANOLUP"),
					resultSet.getString("SANODIRP"), resultSet.getString("SACOLOP"), resultSet.getString("SANRCOPOP"),
					resultSet.getString("SANOPVP"), resultSet.getString("SANRTELP"), resultSet.getString("SANRFAXP"),
					resultSet.getDate("SAFEREPR"), resultSet.getString("SAHRREPR"), resultSet.getString("SACOARPT2"),
					resultSet.getString("SAINMENCPT2"), resultSet.getString("SAINRENCPT2"),
					resultSet.getString("SACOARPS2"), resultSet.getString("SAINMENCPS2"),
					resultSet.getString("SAINRENCPS2"), resultSet.getString("SACOARTT2"),
					resultSet.getString("SAINMENCTT2"), resultSet.getString("SAINRENCTT2"),
					resultSet.getString("SACOARTS2"), resultSet.getString("SAINMENCTS2"),
					resultSet.getString("SAINRENCTS2"), resultSet.getString("SACOCCCO2"),
					resultSet.getString("SACOARDT2"), resultSet.getString("SAINMENCDT2"),
					resultSet.getString("SAINRENCDT2"), resultSet.getString("SACOARDS2"),
					resultSet.getString("SAINMENCDS2"), resultSet.getString("SAINRENCDS2"),
					resultSet.getString("SACOOECO2"), resultSet.getString("SAINMENCST2"),
					resultSet.getString("SAINRENCST2"), resultSet.getString("SAINMENCSS2"),
					resultSet.getString("SAINRENCSS2"), resultSet.getString("SAINMENCT2"),
					resultSet.getString("SAINRENCT2"), resultSet.getDate("SAFECIAU2"), resultSet.getString("SAHRCIAU2"),
					resultSet.getString("SANOLURA2"), resultSet.getString("SANODIRA2"), resultSet.getString("SACOLOA2"),
					resultSet.getString("SANRCPA2"), resultSet.getDate("SAFELAUD"), resultSet.getString("SATEOBRE"),
					resultSet.getString("SATEMORE"), resultSet.getBigDecimal("SACNEUIL"),
					resultSet.getString("SAINFDLA"), resultSet.getString("SAINVOLA"), resultSet.getString("SAINARNL"),
					resultSet.getDate("SAFENOLT"), resultSet.getString("SAINMELT"), resultSet.getString("SAINPUBO"),
					resultSet.getString("SACOTA1"), resultSet.getDate("SAFESERA"), resultSet.getString("SAINFDRA"),
					resultSet.getDate("SAFEPEEX"), resultSet.getString("SAINRAIN"), resultSet.getString("SAINEFIN"),
					resultSet.getDate("SAFEINEF"), resultSet.getDate("SAFEAR"), resultSet.getDate("SAFENODE"),
					resultSet.getDate("SAFERELT"), resultSet.getDate("SAFENOCA"), resultSet.getDate("SAFENOCA2"),
					resultSet.getDate("SAFENOAR"), resultSet.getString("SACOCCCOS"), resultSet.getString("SACOCCCO2S"),
					resultSet.getString("SACOOECOS"), resultSet.getString("SACOOECO2S"), resultSet.getDate("SAFESOAC"),
					resultSet.getDate("SAFEENAC"), resultSet.getDate("SAFENOAC"), resultSet.getString("SATEFPR1"),
					resultSet.getString("SATEFPR2"), resultSet.getDate("SAFEFPR1"), resultSet.getDate("SAFEFPR2"),
					resultSet.getString("SANRBOPL"), resultSet.getDate("SAFEENIN"), resultSet.getDate("SAFEOPPE"),
					resultSet.getDate("SAFEOPLA"), resultSet.getDate("SAFERECO"), resultSet.getDate("SAFENOLA"),
					resultSet.getDate("SAFENONA"), resultSet.getDate("SAFERENA"), resultSet.getDate("SAFECONA"),
					resultSet.getString("SAPUB"), resultSet.getString("SAINTICA"), resultSet.getString("SACOTIR"),
					resultSet.getString("SACOPS"),
					new Zddestad(resultSet.getString("ZddestadXJCODIGO"), resultSet.getString("ZddestadXJIDEX"),
							resultSet.getString("ZddestadXJNOMBRE"), resultSet.getString("ZddestadXJVALOR")),
					new Tcmotina(resultSet.getString("TcmotinaT5CODIGO"), resultSet.getString("TcmotinaT5NOMBRE"),
							resultSet.getString("TcmotinaT5NOMBREEU")),
					new Tcmonola(resultSet.getString("TcmonolaT7CODIGO"), resultSet.getString("TcmonolaT7NOMBRE")),
					new Tcmotdes(resultSet.getString("TcmotdesTMDCODIGO"), resultSet.getString("TcmotdesTMDNOMBRE")),
					resultSet.getString("SACOSET2"),
					new Tclugaud(resultSet.getString("TclugaudT4CODIGO"), resultSet.getString("TclugaudT4NOMBRE"),
							resultSet.getString("TclugaudT4NOMBREEU"), null, null, null, null, null, null, null, null,
							null, null, null, null, null),
					resultSet.getString("SACOSET"), resultSet.getString("SACOSAAC"), resultSet.getString("SACOSES2"),
					resultSet.getString("SACOSES"), resultSet.getString("SACOXJ"), null, // resultSet.getString("ESNOMBRE"),
					null, // resultSet.getString("ESNIF"),
					null, // resultSet.getString("ESNOCO"),
					null, // resultSet.getString("ESNODIR"),
					null, // resultSet.getString("ESNOMBRE_LOCALIDAD"),
					null, // resultSet.getString("ESNOMBRE_MUNICIPIO"),
					null, // resultSet.getString("DTNOMBRE"),
					null, // resultSet.getString("DTNOLO"),
					null, // resultSet.getString("DTNOREP"),
					null, // resultSet.getString("DTCOLO"),
					null, // resultSet.getString("MAINADAR"),
					null, // resultSet.getString("MAINADLI"),
					null, // resultSet.getDate("MAFEREME"),
					null, // resultSet.getString("MAINAD"),
					null, // resultSet.getDate("MAFENOSA"),
					null, // resultSet.getDate("MAFERESA"),
					null, // resultSet.getDate("MAFEFPCO"),
					null// resultSet.getString("MACOT8")
			);
			/*
			 * solarbKgest.setMafenoct(resultSet.getDate("MAFENOCT"));
			 * solarbKgest.setMafersco(resultSet.getDate("MAFERSCO"));
			 * solarbKgest.setMainrsco(resultSet.getString("MAINRSCO"));
			 * solarbKgest.setMacnreco(resultSet.getString("MACNRECO"));
			 * solarbKgest.setMafenoco(resultSet.getDate("MAFENOCO"));
			 * solarbKgest.setMafereco(resultSet.getDate("MAFERECO"));
			 * solarbKgest.setMafealco(resultSet.getDate("MAFEALCO"));
			 * solarbKgest.setMafenoar(resultSet.getDate("MAFENOAR"));
			 * solarbKgest.setMaferear(resultSet.getDate("MAFEREAR"));
			 * solarbKgest.setMaferela(resultSet.getDate("MAFERELA"));
			 * solarbKgest.setMafenoac(resultSet.getDate("MAFENOAC"));
			 * solarbKgest.setMainmelt(resultSet.getString("MAINMELT"));
			 * solarbKgest.setMainpubo(resultSet.getString("MAINPUBO"));
			 * solarbKgest.setManrbopl(resultSet.getString("MANRBOPL"));
			 * solarbKgest.setMaferede(resultSet.getDate("MAFEREDE"));
			 * solarbKgest.setMainmenc(resultSet.getString("MAINMENC"));
			 * solarbKgest.setMainrenc(resultSet.getString("MAINRENC"));
			 * solarbKgest.setMainmenc2(resultSet.getString("MAINMENC2"));
			 * solarbKgest.setMainrenc2(resultSet.getString("MAINRENC2"));
			 * solarbKgest.setMainmenp(resultSet.getString("MAINMENP"));
			 * solarbKgest.setMainrenp(resultSet.getString("MAINRENP"));
			 * solarbKgest.setMafenola(resultSet.getDate("MAFENOLA"));
			 * solarbKgest.setMafesoac(resultSet.getDate("MAFESOAC"));
			 * solarbKgest.setMafeenac(resultSet.getDate("MAFEENAC"));
			 * solarbKgest.setMaferena(resultSet.getDate("MAFERENA"));
			 * solarbKgest.setMafecona(resultSet.getDate("MAFECONA"));
			 * solarbKgest.setSacot4(resultSet.getString("SACOT4"));
			 * solarbKgest.setSacot5(resultSet.getString("SACOT5"));
			 * solarbKgest.setSacot7(resultSet.getString("SACOT7"));
			 * solarbKgest.setSacotmd(resultSet.getString("SACOTMD"));
			 */
			solarbKgest.setTclugaudt4nombre(resultSet.getString("TCLUGAUDT4NOMBRE"));
			solarbKgest.setTclugaudt4nombreeu(resultSet.getString("TCLUGAUDT4NOMBREEU"));
			solarbKgest.setTcmotinat5nombre(resultSet.getString("TCMOTINAT5NOMBRE"));
			solarbKgest.setTcmotinat5nombreeu(resultSet.getString("TCMOTINAT5NOMBREEU"));
			solarbKgest.setTcmonolat7nombre(resultSet.getString("TCMONOLAT7NOMBRE"));
			solarbKgest.setTcmotdestmdnombre(resultSet.getString("TCMOTDESTMDNOMBRE"));
			solarbKgest.setTirnombre(resultSet.getString("TIRNOMBRE"));
			solarbKgest.setTirnombreeu(resultSet.getString("TIRNOMBREEU"));
			solarbKgest.setTa1nombre(resultSet.getString("TA1NOMBRE"));
			solarbKgest.setSenombre(resultSet.getString("SENOMBRE"));
			solarbKgest.setSenombreeu(resultSet.getString("SENOMBREEU"));
			solarbKgest.setPsnombre(resultSet.getString("PSNOMBRE"));
			solarbKgest.setPsnombreeu(resultSet.getString("PSNOMBREEU"));
			solarbKgest.setTtinombre(resultSet.getString("TTINOMBRE"));
			solarbKgest.setTtinombreeu(resultSet.getString("TTINOMBREEU"));
			solarbKgest.setArnombre(resultSet.getString("ARNOMBRE"));
			solarbKgest.setArnombre1(resultSet.getString("ARNOMBRE1"));
			solarbKgest.setArnombre2(resultSet.getString("ARNOMBRE2"));
			solarbKgest.setSrnombre(resultSet.getString("SRNOMBRE"));
			solarbKgest.setArnombre3(resultSet.getString("ARNOMBRE3"));
			solarbKgest.setArnombre4(resultSet.getString("ARNOMBRE4"));
			solarbKgest.setArnombre5(resultSet.getString("ARNOMBRE5"));
			solarbKgest.setSrnombre1(resultSet.getString("SRNOMBRE1"));
			solarbKgest.setArnombre6(resultSet.getString("ARNOMBRE6"));
			solarbKgest.setArnombre7(resultSet.getString("ARNOMBRE7"));
			solarbKgest.setArnombre8(resultSet.getString("ARNOMBRE8"));
			solarbKgest.setSrnombre2(resultSet.getString("SRNOMBRE2"));
			solarbKgest.setArnombre9(resultSet.getString("ARNOMBRE9"));
			solarbKgest.setArnombre10(resultSet.getString("ARNOMBRE10"));
			solarbKgest.setArnombre11(resultSet.getString("ARNOMBRE11"));
			solarbKgest.setSrnombre3(resultSet.getString("SRNOMBRE3"));
			/* solarbKgest.setLonombre(resultSet.getString("LONOMBRE")); */
			solarbKgest.setXjnombre(resultSet.getString("XJNOMBRE"));
			Arbexp arbexp = new Arbexp(resultSet.getString("EXCODIGO"), null, null, null, null, null, null, null, null,
					null, null, null, null, new Fase(resultSet.getString("EXFCODIGO"), null, null, null, null), null,
					null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
					null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
					null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
					null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
					null, null);

			solarbKgest.setArbexp(arbexp);

			// Importes
			if (resultSet.getBigDecimal("SACNEUPR1") != null)
				solarbKgest.setCostePrueba1(Y41bUtils
						.formatDouble2decimalesYcomaYpuntoMiles(resultSet.getBigDecimal("SACNEUPR1").doubleValue()));
			if (resultSet.getBigDecimal("SACNEUPR2") != null)
				solarbKgest.setCostePrueba1(Y41bUtils
						.formatDouble2decimalesYcomaYpuntoMiles(resultSet.getBigDecimal("SACNEUPR2").doubleValue()));
			if (resultSet.getBigDecimal("SACNEUIL") != null)
				solarbKgest.setImporteLaudo(Y41bUtils
						.formatDouble2decimalesYcomaYpuntoMiles(resultSet.getBigDecimal("SACNEUIL").doubleValue()));

			return solarbKgest;
		}
	};

	/**
	 * Finds a single row in the SolarbKgest table.
	 * 
	 * @param solarb
	 *            SolarbKgest
	 * @return SolarbKgest
	 */

	@Transactional(readOnly = true)
	public SolarbKgest findKgest(SolarbKgest solarb) {
		String query = "SELECT t1.SACODIGO SACODIGO, t1.SACOHD SACOHD, t1.SACOJA SACOJA, t1.SANROR SANROR, t1.SANRAN SANRAN, t1.SAFESOLI SAFESOLI, t1.SANODIDC SANODIDC, t1.SACOLODC SACOLODC, t1.SANOLODC SANOLODC, t1.SACOPVDC SACOPVDC, t1.SACOMUDC SACOMUDC, t1.SANRCPDC SANRCPDC, t1.SAINACUO SAINACUO, t1.SACOORPR SACOORPR, t1.SACOSERE SACOSERE, t1.SACOTTI SACOTTI, t1.SAINTISO SAINTISO, t1.SACNRECL SACNRECL, t1.SATEOBRC SATEOBRC, t1.SAFEINAD SAFEINAD, t1.SATEINAD SATEINAD, t1.SAFEREIT SAFEREIT, t1.SAFETRAS SAFETRAS, t1.SACOORTR SACOORTR, t1.SAFERETT SAFERETT, t1.SAFERETS SAFERETS, t1.SAFEMEDI SAFEMEDI, t1.SAINREME SAINREME, t1.SAFEREMT SAFEREMT, t1.SAFEDESI SAFEDESI, t1.SAFEREDT SAFEREDT, t1.SAFENOCO SAFENOCO, t1.SAFEREAR SAFEREAR, t1.SAFEDECO SAFEDECO, t1.SACOARPT SACOARPT, t1.SAINMENCPT SAINMENCPT, t1.SAINRENCPT SAINRENCPT, t1.SACOARPS SACOARPS, t1.SAINMENCPS SAINMENCPS, t1.SAINRENCPS SAINRENCPS, t1.SACOARTT SACOARTT, t1.SAINMENCTT SAINMENCTT, t1.SAINRENCTT SAINRENCTT, t1.SACOARTS SACOARTS, t1.SAINMENCTS SAINMENCTS, t1.SAINRENCTS SAINRENCTS, t1.SACOCCCO SACOCCCO, t1.SACOARDT SACOARDT, t1.SAINMENCDT SAINMENCDT, t1.SAINRENCDT SAINRENCDT, t1.SACOARDS SACOARDS, t1.SAINMENCDS SAINMENCDS, t1.SAINRENCDS SAINRENCDS, t1.SACOOECO SACOOECO, t1.SAINMENCST SAINMENCST, t1.SAINRENCST SAINRENCST, t1.SAINMENCSS SAINMENCSS, t1.SAINRENCSS SAINRENCSS, t1.SAINMENCT SAINMENCT, t1.SAINRENCT SAINRENCT, t1.SAFECIAU SAFECIAU, t1.SAHRCIAU SAHRCIAU, t1.SANOLURA SANOLURA, t1.SANODIRA SANODIRA, t1.SACOLOA SACOLOA, t1.SANRCPA SANRCPA, t1.SAINSOPR SAINSOPR, t1.SAININPR SAININPR, t1.SATEOBPR SATEOBPR, t1.SACOPE1 SACOPE1, t1.SACNEUPR1 SACNEUPR1, t1.SACOPE2 SACOPE2, t1.SACNEUPR2 SACNEUPR2, t1.SAFENOPR SAFENOPR, t1.SAINMENP1 SAINMENP1, t1.SAINRENP1 SAINRENP1, t1.SAINMENP2 SAINMENP2, t1.SAINRENP2 SAINRENP2, t1.SAINMENPT SAINMENPT, t1.SAINRENPT SAINRENPT, t1.SANOLUP SANOLUP, t1.SANODIRP SANODIRP, t1.SACOLOP SACOLOP, t1.SANRCOPOP SANRCOPOP, t1.SANOPVP SANOPVP, t1.SANRTELP SANRTELP, t1.SANRFAXP SANRFAXP, t1.SAFEREPR SAFEREPR, t1.SAHRREPR SAHRREPR, t1.SACOARPT2 SACOARPT2, t1.SAINMENCPT2 SAINMENCPT2, t1.SAINRENCPT2 SAINRENCPT2, t1.SACOARPS2 SACOARPS2, t1.SAINMENCPS2 SAINMENCPS2, t1.SAINRENCPS2 SAINRENCPS2, t1.SACOARTT2 SACOARTT2, t1.SAINMENCTT2 SAINMENCTT2, t1.SAINRENCTT2 SAINRENCTT2, t1.SACOARTS2 SACOARTS2, t1.SAINMENCTS2 SAINMENCTS2, t1.SAINRENCTS2 SAINRENCTS2, t1.SACOCCCO2 SACOCCCO2, t1.SACOARDT2 SACOARDT2, t1.SAINMENCDT2 SAINMENCDT2, t1.SAINRENCDT2 SAINRENCDT2, t1.SACOARDS2 SACOARDS2, t1.SAINMENCDS2 SAINMENCDS2, t1.SAINRENCDS2 SAINRENCDS2, t1.SACOOECO2 SACOOECO2, t1.SAINMENCST2 SAINMENCST2, t1.SAINRENCST2 SAINRENCST2, t1.SAINMENCSS2 SAINMENCSS2, t1.SAINRENCSS2 SAINRENCSS2, t1.SAINMENCT2 SAINMENCT2, t1.SAINRENCT2 SAINRENCT2, t1.SAFECIAU2 SAFECIAU2, t1.SAHRCIAU2 SAHRCIAU2, t1.SANOLURA2 SANOLURA2, t1.SANODIRA2 SANODIRA2, t1.SACOLOA2 SACOLOA2, t1.SANRCPA2 SANRCPA2, t1.SAFELAUD SAFELAUD, t1.SATEOBRE SATEOBRE, t1.SATEMORE SATEMORE, t1.SACNEUIL SACNEUIL, t1.SAINFDLA SAINFDLA, t1.SAINVOLA SAINVOLA, t1.SAINARNL SAINARNL, t1.SAFENOLT SAFENOLT, t1.SAINMELT SAINMELT, t1.SAINPUBO SAINPUBO, t1.SACOTA1 SACOTA1, t1.SAFESERA SAFESERA, t1.SAINFDRA SAINFDRA, t1.SAFEPEEX SAFEPEEX, t1.SAINRAIN SAINRAIN, t1.SAINEFIN SAINEFIN, t1.SAFEINEF SAFEINEF, t1.SAFEAR SAFEAR, t1.SAFENODE SAFENODE, t1.SAFERELT SAFERELT, t1.SAFENOCA SAFENOCA, t1.SAFENOCA2 SAFENOCA2, t1.SAFENOAR SAFENOAR, t1.SACOCCCOS SACOCCCOS, t1.SACOCCCO2S SACOCCCO2S, t1.SACOOECOS SACOOECOS, t1.SACOOECO2S SACOOECO2S, t1.SAFESOAC SAFESOAC, t1.SAFEENAC SAFEENAC, t1.SAFENOAC SAFENOAC, t1.SATEFPR1 SATEFPR1, t1.SATEFPR2 SATEFPR2, t1.SAFEFPR1 SAFEFPR1, t1.SAFEFPR2 SAFEFPR2, t1.SANRBOPL SANRBOPL, t1.SAFEENIN SAFEENIN, t1.SAFEOPPE SAFEOPPE, t1.SAFEOPLA SAFEOPLA, t1.SAFERECO SAFERECO, t1.SAFENOLA SAFENOLA, t1.SAFENONA SAFENONA, t1.SAFERENA SAFERENA, t1.SAFECONA SAFECONA, t1.SAPUB SAPUB, t1.SAINTICA SAINTICA, t1.SACOTIR SACOTIR, t1.SACOPS SACOPS, t1.SACOSAAC SACOSAAC, t1.SACOSET2 SACOSET2, t1.SACOSET SACOSET, t1.SACOSES2 SACOSES2,t1.SACOSES SACOSES, t1.SACOXJ SACOXJ, t2.XJCODIGO ZDDESTADXJCODIGO, t2.XJIDEX ZDDESTADXJIDEX, t2.XJNOMBRE ZDDESTADXJNOMBRE, t2.XJVALOR ZDDESTADXJVALOR, t3.T5CODIGO TCMOTINAT5CODIGO, t3.T5NOMBRE TCMOTINAT5NOMBRE, t3.T5NOMBREEU TCMOTINAT5NOMBREEU, t4.T7CODIGO TCMONOLAT7CODIGO, t4.T7NOMBRE TCMONOLAT7NOMBRE, t5.TMDCODIGO TCMOTDESTMDCODIGO, t5.TMDNOMBRE TCMOTDESTMDNOMBRE, t7.T4CODIGO TCLUGAUDT4CODIGO, t7.T4NOMBRE TCLUGAUDT4NOMBRE, t7.T4NOMBREEU TCLUGAUDT4NOMBREEU "
				+ " ,t8.EXCODIGO EXCODIGO, t8.EXFCODIGO EXFCODIGO, t1.SACOT4 SACOT4, t1.SACOT5 SACOT5, t1.SACOT7 SACOT7, t1.SACOTMD SACOTMD, t13.TIRNOMBRE TIRNOMBRE, t13.TIRNOMBREE TIRNOMBREEU, t14.TA1NOMBRE TA1NOMBRE, t15.SENOMBRE SENOMBRE, t15.SENOMBREE SENOMBREEU, t16.PSNOMBRE PSNOMBRE, t16.PSNOMBREE PSNOMBREEU, t17.TTINOMBRE TTINOMBRE, t17.TTINOMBREE TTINOMBREEU, t18.ARNOMBRE ARNOMBRE, t19.ARNOMBRE ARNOMBRE1, t20.ARNOMBRE ARNOMBRE2, t21.SRNOMBRE SRNOMBRE, t22.ARNOMBRE ARNOMBRE3, t23.ARNOMBRE ARNOMBRE4, t24.ARNOMBRE ARNOMBRE5, t25.SRNOMBRE SRNOMBRE1, t26.ARNOMBRE ARNOMBRE6, t27.ARNOMBRE ARNOMBRE7, t28.ARNOMBRE ARNOMBRE8, t29.SRNOMBRE SRNOMBRE2, t30.ARNOMBRE ARNOMBRE9, t31.ARNOMBRE ARNOMBRE10, t32.ARNOMBRE ARNOMBRE11, t33.SRNOMBRE SRNOMBRE3, t35.XJNOMBRE XJNOMBRE "
				+ " FROM SOLARB t1 , ZDDESTAD t2 , TCMOTINA t3 , TCMONOLA t4 , TCMOTDES t5 , TCLUGAUD t7, ARBEXP t8, MOTIVO t13, TCTERRIT t14, SECTOR t15, PRODUCTO t16, TCTIPINF t17, ARBITRO t18, ARBITRO t19, ARBITRO t20, SECRETAR t21, ARBITRO t22, ARBITRO t23, ARBITRO t24, SECRETAR t25, ARBITRO t26, ARBITRO t27, ARBITRO t28, SECRETAR t29, ARBITRO t30, ARBITRO t31, ARBITRO t32, SECRETAR t33, ZDDESTAD t35 WHERE t1.SACODIGO = ? AND t1.SACODIGO=t8.EXCODIGO(+) AND t1.SACOXJ= t2.XJCODIGO(+) AND t1.SACOT5= t3.T5CODIGO(+) AND t1.SACOT7= t4.T7CODIGO(+) AND t1.SACOTMD= t5.TMDCODIGO(+) AND t1.SACOT4= t7.T4CODIGO(+) AND t1.SACOTIR=t13.TIRCODIGO(+) AND t1.SACOTA1=t14.TA1CODIGO(+) AND t1.SACOSERE=t15.SECODIGO(+) AND t1.SACOPS=t16.PSCODIGO(+) AND t1.SACOTTI=t17.TTICODIGO(+) AND t1.SACOARPT=t18.ARCODIGO(+) AND t1.SACOARTT=t19.ARCODIGO(+) AND t1.SACOARDT=t20.ARCODIGO(+) AND t1.SACOSET=t21.SRCODIGO(+) AND t1.SACOARPS=t22.ARCODIGO(+) AND t1.SACOARTS=t23.ARCODIGO(+) AND t1.SACOARDS=t24.ARCODIGO(+) AND t1.SACOSES=t25.SRCODIGO(+) AND t1.SACOARPT2=t26.ARCODIGO(+) AND t1.SACOARTT2=t27.ARCODIGO(+) AND t1.SACOARDT2=t28.ARCODIGO(+) AND t1.SACOSET2=t29.SRCODIGO(+) AND t1.SACOARPS2=t30.ARCODIGO(+) AND t1.SACOARTS2=t31.ARCODIGO(+) AND t1.SACOARDS2=t32.ARCODIGO(+) AND t1.SACOSES2=t33.SRCODIGO(+) AND t1.SACOXJ=t35.XJCODIGO ";

		List<SolarbKgest> solarbList = this.jdbcTemplate.query(query, this.rwMapKgest, solarb.getSacodigo());
		return (SolarbKgest) DataAccessUtils.uniqueResult(solarbList);
	}

	/**
	 * Finds SANROR
	 * 
	 * @param expedien
	 *            Pagination
	 * @return long
	 */
	public long findSanrorSig(Solarb solarb) {
		String query = "SELECT  MAX(t1.SANROR)+1 " + "FROM SOLARB t1   " + "WHERE t1.SACOJA = ?   AND t1.SANRAN= ? ";

		List<Object> params = new ArrayList<Object>();
		params.add(solarb.getSacoja());
		params.add(solarb.getSanran());

		long correlativo = 0;
		correlativo = this.jdbcTemplate.queryForLong(query, params.toArray());

		if (correlativo == 0) {
			correlativo = 1;
		}
		return correlativo;
	}

	@Override()
	public Long findAllLikeCountArbitrajes(FiltroArbitraje filtroArbitraje, Boolean startsWith) {

		StringBuilder query = new StringBuilder("SELECT COUNT (*) FROM (");

		List<Object> lista = this.dameQueryfindAllLikeArbitrajes(filtroArbitraje, startsWith);
		query.append((StringBuilder) lista.get(0));
		query.append(")");

		return this.jdbcTemplate.queryForLong(query.toString(), ((List<?>) lista.get(1)).toArray());

	}

	/**
	 * dameQueryfindAllLikeArbitrajes
	 * 
	 * @param filtroArbitraje
	 *            FiltroArbitraje
	 * @param startsWith
	 *            Boolean
	 * @return List<Object>
	 */
	private List<Object> dameQueryfindAllLikeArbitrajes(FiltroArbitraje filtroArbitraje, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"( SELECT DISTINCT T1.SACOJA || '-' || T1.SANROR || '-' || T1.SANRAN CODCOMPLETO ,"
						+ " T1.SACODIGO SOLARBSACODIGO, T1.SACOJA SACOJA, T1.SANRAN SANRAN,"
						+ " T1.SANROR SANROR, LPAD(T1.SANROR,12,'0') CORRELATIVOPAD, T1.SAFESOLI SAFESOLI,"
						+ " T2.EXFECFIN SAFECFIN, T2.EXCODIGO ARBEXPEXCODIGO, T2.EXDESCES ARBEXPEXDESCES,"
						+ " T2.EXDESCEU ARBEXPEXDESCEU, T2.EXFECPREVFIN ARBEXPEXFECPREVFIN, T2.EXFECFIN ARBEXPEXFECFIN,"
						+ " T2.EXTIPRES ARBEXPEXTIPRES, T2.EXMOCODIGO ARBEXPEXMOCODIGO, T2.EXFCODIGO ARBEXPEXFCODIGO,"
						+ " T2.EXMOCODIGOULT ARBEXPEXMOCODIGOULT, T2.EXTRPOSCOD ARBEXPEXTRPOSCOD, T2.EXTRENTIDAD ARBEXPEXTRENTIDAD,"
						+ " T3.FCODIGO FASEFCODIGO, T3.FNOMBRE FASEFNOMBRE, T3.FNOMBREE FASEFNOMBREE, T5.UANOMBRE RECLAMADOUANOMBRE,"
						+ " TO_CHAR(T5.UAIDINTERV) RECLAMADOUAIDINTERV, TRIM(T11.UANOMBRE) RECLAMANTEUANOMBRE, TRIM(T11.UAAPELLIDO1) RECLAMANTEUAAPELLIDO1, TRIM(T11.UAAPELLIDO2) RECLAMANTEUAAPELLIDO2, TO_CHAR(T11.UAIDINTERV) RECLAMANTEUAIDINTERV,"
						+ " T7.MOCODIGO MONITORMOCODIGO, T7.MONOMBRE MONITORMONOMBRE, T10.TRCODIGO ARBTRAMEXPTRCODIGO,"
						+ " T10.TRNOMBRE TRAMITETRNOMBRE, T10.TRNOMBREE TRAMITETRNOMBREE, T10.TRNOMTRAMES ARBTRAMEXPTRNOMTRAMES,"
						+ " T13.DECODIGO DECISIONDECODIGO, T13.DENOMBRE DECISIONDENOMBRE, T13.DENOMBREE DECISIONDENOMBREE,"
						+ " (SELECT DS_O FROM T17I.T17_MUNICIPIO WHERE T5.UAPROV_ID = PROVINCIA_ID AND T5.UAMUN_ID = ID) AS NOMBRE_MUNICIPIO,"
						+ " NULL SACOT7, NULL SAFELAUD, NULL SAFEINAD, NULL SAFETRAS, NULL SAFENODE, NULL SAFEMEDI "
						+ this.getFromBusquedaArbitrajes());

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMapArbitrajes(filtroArbitraje, startsWith, false);
		StringBuilder where = new StringBuilder(this.getWhereBusquedaArbitrajes());

		where.append(mapaWhere.get("query"));
		query.append(where);
		query.append(")");

		List<?> params = (List<?>) mapaWhere.get("params");

		// Si estamos buscando por fase-tramite, cerrado, ...
		// no deben aparecer los expedientes antiguos porque no tienen
		// tramitacion
		StringBuilder queryDef = new StringBuilder(query);
		if (filtroArbitraje != null && filtroArbitraje.getArbexp().getExregen() == null
				&& filtroArbitraje.getArbexp().getExfcodigo() == null
				&& filtroArbitraje.getArbtramexp().getTrcodigo() == null
				&& filtroArbitraje.getArbtramexp().getTrmonitor() == null
				&& filtroArbitraje.getFechaTramitacionDesde() == null
				&& filtroArbitraje.getFechaTramitacionHasta() == null
				&& filtroArbitraje.getArbexp().getExmocodigo() == null
				&& (filtroArbitraje.getUltimoTramite() == null || (filtroArbitraje.getUltimoTramite() != null
						&& !filtroArbitraje.getUltimoTramite().booleanValue()))
				&& (filtroArbitraje.getAcuseRecibo() == null || (filtroArbitraje.getAcuseRecibo() != null
						&& !filtroArbitraje.getAcuseRecibo().booleanValue()))
				&& (filtroArbitraje.getIndPendienteFirma() == null || (filtroArbitraje.getIndPendienteFirma() != null
						&& !filtroArbitraje.getIndPendienteFirma().booleanValue()))) {
			StringBuilder query2 = new StringBuilder(
					"( SELECT T1.SACOJA || '-' || T1.SANROR || '-' || T1.SANRAN CODCOMPLETO, T1.SACODIGO SOLARBSACODIGO, T1.SACOJA SACOJA, T1.SANRAN SANRAN,"
							+ " T1.SANROR SANROR, LPAD(T1.SANROR,12,'0') CORRELATIVOPAD, T1.SAFESOLI SAFESOLI, NULL SAFECFIN, NULL ARBEXPEXCODIGO, NULL ARBEXPEXDESCES,"
							+ " NULL ARBEXPEXDESCEU, NULL ARBEXPEXFECPREVFIN, NULL ARBEXPEXFECFIN, NULL ARBEXPEXTIPRES, NULL ARBEXPEXMOCODIGO, NULL ARBEXPEXFCODIGO,"
							+ " NULL ARBEXPEXMOCODIGOULT, NULL ARBEXPEXTRPOSCOD, NULL ARBEXPEXTRENTIDAD, NULL FASEFCODIGO, NULL FASEFNOMBRE, NULL FASEFNOMBREE,"
							+ " T5.ESNOMBRE RECLAMADOUANOMBRE, T5.ESCODIGO	RECLAMADOUAIDINTERV, TRIM(T12.DTNOMBRE) RECLAMANTEDTNOMBRE, TRIM(T12.DTAPELLIDO1) RECLAMANTEDTAPELLIDO1, TRIM(T12.DTAPELLIDO2) RECLAMANTEDTAPELLIDO2, T12.DTCODIGO RECLAMANTEUAIDINTERV,"
							+ " NULL MONITORMOCODIGO, NULL MONITORMONOMBRE, NULL ARBTRAMEXPTRCODIGO, NULL TRAMITETRNOMBRE, NULL TRAMITETRNOMBREE,"
							+ " NULL ARBTRAMEXPTRNOMTRAMES, NULL DECISIONDECODIGO, NULL DECISIONDENOMBRE, NULL DECISIONDENOMBREE, T1.SACOT7	SACOT7, T1.SAFELAUD	SAFELAUD,"
							+ " T1.SAFEINAD	SAFEINAD, T1.SAFETRAS SAFETRAS, T1.SAFENODE SAFENODE, T1.SAFEMEDI SAFEMEDI, (SELECT	DS_O FROM T17I.T17_MUNICIPIO WHERE T5.ESNORA_PROVINCIA_ID = PROVINCIA_ID"
							+ " AND T5.ESNORA_MUNICIPIO_ID = ID) AS NOMBRE_MUNICIPIO "
							+ this.getFromBusquedaArbitrajesHist());

			// Where clause & Params
			Map<String, ?> mapaWhere2 = this.getWhereLikeMapArbitrajesHistoricas(filtroArbitraje, startsWith, false);
			StringBuilder where2 = new StringBuilder(this.getWhereBusquedaArbitrajesHist());
			where2.append(mapaWhere2.get("query"));
			query2.append(where2);
			query2.append(")");

			params.addAll((List) mapaWhere2.get("params"));
			queryDef = queryDef.append(" UNION ").append(query2);
		}

		List<Object> resultado = new ArrayList<Object>();
		resultado.add(queryDef);
		resultado.add(params);
		return resultado;

	}

	/**
	 * @param filtroArbitraje
	 *            FiltroArbitraje
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List<filtroArbitraje>
	 */
	public List<FiltroArbitraje> findAllLikeArbitrajes(FiltroArbitraje filtroArbitraje, Pagination pagination,
			Boolean startsWith) {
		List<Object> lista = this.dameQueryfindAllLikeArbitrajes(filtroArbitraje, startsWith);
		StringBuilder queryDef = (StringBuilder) lista.get(0);
		if (pagination != null) {
			queryDef = pagination.getPaginationQuery(queryDef);
		}

		List<FiltroArbitraje> listaArbitrajes = (List<FiltroArbitraje>) this.jdbcTemplate.query(queryDef.toString(),
				this.rwMapBusquedaArbitrajesFiltro, ((List<?>) lista.get(1)).toArray());
		return listaArbitrajes;

	}

	/*** metodo para obterner el fichero ADO de arbitraje **/

	/**
	 * Finds a single row in the SolarbKgest table.
	 * 
	 * @param arbFicheroADO
	 *            ArbFicheroADO
	 * @return SolarbKgest
	 */

	@Transactional(readOnly = true)
	public List<ArbFicheroADO> findFicheroADO(ArbFicheroADO arbFicheroADO) {
		StringBuilder query = new StringBuilder("");
		List<Object> params = new ArrayList<Object>();

		query.append(
				" SELECT t1.SACODIGO SACODIGO, t1.SACOJA SACOJA, t1.SANROR SANROR, t1.SANRAN SANRAN, t3.SACOARPT SACOARPT, t3.SACOARTT SACOARTT, t3.SACOARDT SACOARDT,");
		query.append(
				" t1.SAFELAUD SAFELAUD, t2.TRID TRIDPAGOLAUDO, t2.TRMOCODIGOEJ, ta1.ARNIF ta1ARNIF, ta1.ARNOMBRE ta1ARNOMBRE, ta1.ARTERCERO ta1ARTERCERO, ta2.ARNIF ta2ARNIF,");
		query.append(
				" ta2.ARNOMBRE ta2ARNOMBRE, ta2.ARTERCERO ta2ARTERCERO, ta3.ARNIF ta3ARNIF, ta3.ARNOMBRE ta3ARNOMBRE, ta3.ARTERCERO ta3ARTERCERO, t2.TRCODIGO ");
		query.append(" FROM SOLARB t1, ARBTRAMEXP t2, ARBITRO ta1, ARBITRO ta2, ARBITRO ta3, ");
		query.append(" (SELECT TREXCODIGO, SACOARPT, SACOARTT, SACOARDT, filaDesigCol FROM (");
		query.append(" SELECT TREXCODIGO, ");
		query.append(" CASE WHEN XJACTIVOPSUP='").append(Y41bConstantes.VALOR_SI)
				.append("' THEN SACOARPS ELSE SACOARPT END SACOARPT, ");
		query.append(" CASE WHEN XJACTIVOAACCSUP='").append(Y41bConstantes.VALOR_SI)
				.append("' THEN SACOARTS ELSE SACOARTT END SACOARTT, ");
		query.append(" CASE WHEN XJACTIVOOOEESUP='").append(Y41bConstantes.VALOR_SI)
				.append("' THEN SACOARDS ELSE SACOARDT END SACOARDT, ")
				.append(" ROW_NUMBER() OVER (PARTITION BY TREXCODIGO, TRCODIGO ORDER BY TRFECFIN DESC) filaDesigCol");
		query.append(
				" FROM SOLARB, ARBTRAMEXP, ARBCOLEGIO WHERE SACODIGO=TREXCODIGO AND TRID = XJTRID AND TRCODIGO = '");
		query.append(Y41bConstantes.TRAMITE_ARBITRAJE_DESIGNACION_COLEGIO);
		query.append("' AND TRESTADO = '");
		query.append(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		query.append("') WHERE filaDesigCol=1) t3");
		query.append(
				" WHERE t3.SACOARPT=ta1.ARCODIGO(+) AND t3.SACOARTT=ta2.ARCODIGO(+) AND t3.SACOARDT=ta3.ARCODIGO(+) AND t2.TREXCODIGO=t1.SACODIGO ");
		query.append(" AND t1.SACODIGO = t3.TREXCODIGO (+)");
		query.append(" AND t2.TRCODIGO= ?");
		params.add(Y41bConstantes.TRAMITE_ARBITRAJE_PAGO_LAUDO);
		query.append("AND t2.TRESTADO= ?");
		params.add(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		// el pago est pendiente de enviar.
		query.append(" AND t2.TRFICHADO IS NULL ");

		// si elige filtrar pagos pendientes con audiencia
		if (!Y41bUtils.esNullOCadenaVacia(arbFicheroADO.getFindByCriterio())
				&& Y41bADOConstantes.CRITERIO_FECHA_AUDIENCIA.equals(arbFicheroADO.getFindByCriterio())) {

			query.append(
					" AND EXISTS (SELECT 1 FROM ARBTRAMEXP t3 where t1.SACODIGO=t3.TREXCODIGO AND t3.TRCODIGO=? AND t3.TRESTADO=? AND t3.TRFECAUDIENCIA IS NOT NULL)  ");
			params.add(Y41bConstantes.TRAMITE_ARBITRAJE_AUDIENCIA);
			params.add(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else if (!Y41bUtils.esNullOCadenaVacia(arbFicheroADO.getFindByCriterio())
				&& Y41bADOConstantes.CRITERIO_FECHA_LAUDO.equals(arbFicheroADO.getFindByCriterio())) {
			query.append(" AND t1.SAFELAUD IS NOT NULL ");
		}
		query.append(" ORDER BY t1.SACOJA ASC, t1.SANRAN ASC, t1.SANROR ASC");

		List<ArbFicheroADO> listaArbitrajes = (List<ArbFicheroADO>) this.jdbcTemplate.query(query.toString(),
				this.rwMapFicheroADO, params.toArray());
		return listaArbitrajes;
	}

	/**
	 * Metodo para recoger los pagos periciales a los arbitros seleccionados del
	 * colegio
	 * 
	 * @param arbFicheroADO
	 *            ArbFicheroADO
	 * @return SolarbKgest
	 */

	@Transactional(readOnly = true)
	public List<ArbFicheroADO> findFicheroADOPagoPericialColegio(ArbFicheroADO arbFicheroADO) {
		StringBuilder query = new StringBuilder("");
		List<Object> params = new ArrayList<Object>();

		query.append(
				" SELECT t1.SACODIGO SACODIGO, t1.SACOJA SACOJA, t1.SANROR SANROR, t1.SANRAN SANRAN, t4.UAIDINTERV SACOARPT, '' SACOARTT, '' SACOARDT,");
		query.append(
				" t1.SAFELAUD SAFELAUD, t6.TRID TRIDPAGOLAUDO, t2.TRMOCODIGOEJ, t4.UANIF ta1ARNIF, t4.UANOMBRE ta1ARNOMBRE, ARTERCERO ta1ARTERCERO, t6.TRCODIGO");
		query.append(" FROM SOLARB t1, ARBTRAMEXP t2, INTERVINIENTES_TRAMITE t3, ARBINTERV t4, ARBITRO t5, ");
		query.append(" (SELECT TRID, TREXCODIGO, TRCODIGO, filaPagoPericialCol FROM (");
		query.append(" SELECT TRID, TREXCODIGO, TRCODIGO, ");
		query.append(" ROW_NUMBER() OVER (PARTITION BY TREXCODIGO ORDER BY TRFECFIN DESC) filaPagoPericialCol");
		query.append(" FROM ARBTRAMEXP WHERE TRCODIGO = '");
		query.append(Y41bConstantes.TRAMITE_ARBITRAJE_PAGO_PERICIAL_COLEGIO);
		query.append("' AND TRESTADO = '"); // el pago est pendiente de enviar.
		query.append(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		query.append("' AND TRFICHADO IS NULL) WHERE filaPagoPericialCol=1) t6");
		query.append(
				" WHERE t1.SACODIGO=t2.TREXCODIGO AND t2.TREXCODIGO=t6.TREXCODIGO AND t2.TRID=t3.Z4TRID AND t3.Z4IDINTERVINIENTE=t4.UAIDINTERV AND t4.UANIF=t5.ARNIF(+) ");
		query.append(" AND t2.TRCODIGO= ? ");
		params.add(Y41bConstantes.TRAMITE_ARBITRAJE_CITACION_A_PRUEBA);
		query.append(" AND t2.TRESTADO= ? ");
		params.add(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		// si elige filtrar pagos pendientes con audiencia
		if (!Y41bUtils.esNullOCadenaVacia(arbFicheroADO.getFindByCriterio())
				&& Y41bADOConstantes.CRITERIO_FECHA_AUDIENCIA.equals(arbFicheroADO.getFindByCriterio())) {

			query.append(
					" AND EXISTS (SELECT 1 FROM ARBTRAMEXP t3 where t1.SACODIGO=t3.TREXCODIGO AND t3.TRCODIGO=? AND t3.TRESTADO=? AND t3.TRFECAUDIENCIA IS NOT NULL)  ");
			params.add(Y41bConstantes.TRAMITE_ARBITRAJE_AUDIENCIA);
			params.add(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else if (!Y41bUtils.esNullOCadenaVacia(arbFicheroADO.getFindByCriterio())
				&& Y41bADOConstantes.CRITERIO_FECHA_LAUDO.equals(arbFicheroADO.getFindByCriterio())) {
			query.append(" AND t1.SAFELAUD IS NOT NULL ");
		}
		query.append(" ORDER BY t1.SACOJA ASC, t1.SANRAN ASC, t1.SANROR ASC");

		List<ArbFicheroADO> listaArbitrajes = (List<ArbFicheroADO>) this.jdbcTemplate.query(query.toString(),
				this.rwMapFicheroADO, params.toArray());
		return listaArbitrajes;
	}

	/**
	 * METODOS DE BUSQUEDA PARA EL FILTRO/BUSQUEDA DE EXPEDIENTES ARBITRAJES
	 */

	private RowMapper<ArbFicheroADO> rwMapFicheroADO = new RowMapper<ArbFicheroADO>() {
		public ArbFicheroADO mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			ArbFicheroADO retorno = new ArbFicheroADO();

			retorno.setTrcodigo(resultSet.getString("TRCODIGO"));
			retorno.setSacodigo(resultSet.getString("SACODIGO"));
			retorno.setSacoja(resultSet.getString("SACOJA"));
			retorno.setSanror(resultSet.getBigDecimal("SANROR"));
			retorno.setSanran(resultSet.getBigDecimal("SANRAN"));
			retorno.setSafelaud(resultSet.getDate("SAFELAUD"));

			retorno.setTridpagolaudo(resultSet.getString("TRIDPAGOLAUDO"));
			retorno.setTrmocodigoEj(resultSet.getString("TRMOCODIGOEJ"));

			List<Arbitro> listaArbitros = new ArrayList<Arbitro>();
			if (resultSet.getString("SACOARPT") != null) {
				Arbitro arbitro1 = new Arbitro();
				arbitro1.setArcodigo(resultSet.getString("SACOARPT"));
				arbitro1.setArnif(resultSet.getString("ta1ARNIF"));
				arbitro1.setArnombre(resultSet.getString("ta1ARNOMBRE"));
				arbitro1.setArtercero(resultSet.getString("ta1ARTERCERO"));
				listaArbitros.add(arbitro1);
			}

			if (resultSet.getString("SACOARTT") != null) {
				Arbitro arbitro2 = new Arbitro();
				arbitro2.setArcodigo(resultSet.getString("SACOARTT"));
				arbitro2.setArnif(resultSet.getString("ta2ARNIF"));
				arbitro2.setArnombre(resultSet.getString("ta2ARNOMBRE"));
				arbitro2.setArtercero(resultSet.getString("ta2ARTERCERO"));
				listaArbitros.add(arbitro2);
			}

			if (resultSet.getString("SACOARDT") != null) {
				Arbitro arbitro3 = new Arbitro();
				arbitro3.setArcodigo(resultSet.getString("SACOARDT"));
				arbitro3.setArnif(resultSet.getString("ta3ARNIF"));
				arbitro3.setArnombre(resultSet.getString("ta3ARNOMBRE"));
				arbitro3.setArtercero(resultSet.getString("ta3ARTERCERO"));
				listaArbitros.add(arbitro3);
			}

			retorno.setArbitrosPagoLaudo(listaArbitros);

			return retorno;
		}
	};

	/**
	 * METODOS DE BUSQUEDA PARA EL FILTRO/BUSQUEDA DE EXPEDIENTES ARBITRAJES
	 */

	private RowMapper<FiltroArbitraje> rwMapBusquedaArbitrajesFiltro = new RowMapper<FiltroArbitraje>() {
		public FiltroArbitraje mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			Fase fase = new Fase(resultSet.getString("fasefcodigo"), resultSet.getString("fasefnombre"),
					resultSet.getString("fasefnombree"), null, null);

			Tramite tramite = new Tramite(resultSet.getString("arbtramexpTRCODIGO"),
					resultSet.getString("tramiteTRNOMBRE"), resultSet.getString("tramiteTRNOMBREE"));

			Arbtramexp arbtramexp = new Arbtramexp(resultSet.getString("ArbexpEXTRPOSCOD"),
					resultSet.getString("arbtramexpTRCODIGO"), null, resultSet.getString("arbtramexpTRNOMTRAMES"), null,
					tramite);

			Arbtramexp arbtramexpEntidad = new Arbtramexp(resultSet.getString("ARBEXPEXTRENTIDAD"), null, null);

			CensoMonitor censomonitor = new CensoMonitor(resultSet.getString("monitorMOCODIGO"),
					resultSet.getString("monitorMONOMBRE"), null, null, null, null, null, null, null, null, null, null,
					null, null, null, null, null, null, null, null, null, null);

			Arbexp arbexp = new Arbexp(resultSet.getString("ArbexpEXCODIGO"), null, null,
					resultSet.getString("ArbexpEXDESCES"), resultSet.getString("ArbexpEXDESCEU"),
					resultSet.getDate("ArbexpEXFECPREVFIN"), resultSet.getDate("ArbexpEXFECFIN"), null,
					resultSet.getString("ArbexpEXTIPRES"), null, null, resultSet.getString("ArbexpEXMOCODIGO"), null,
					fase, null, null, null, null, null, arbtramexp, arbtramexpEntidad, null, null, null, null, null,
					null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
					null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
					null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
					null, null, null, null, null, null, null);

			Decision tipoResolucion = null;
			tipoResolucion = new Decision();
			tipoResolucion.setDecodigo(resultSet.getString("decisionDECODIGO"));
			tipoResolucion.setDenombre(resultSet.getString("decisionDENOMBRE"));
			tipoResolucion.setDenombree(resultSet.getString("decisionDENOMBREE"));

			Arbinterv reclamado = new Arbinterv();
			reclamado.setCodigoTxt(resultSet.getString("reclamadoUAIDINTERV"));
			reclamado.setUanombre(resultSet.getString("reclamadoUANOMBRE"));

			Arbinterv reclamante = new Arbinterv();
			reclamante.setCodigoTxt(resultSet.getString("reclamanteUAIDINTERV"));

			StringBuffer nombreCompleto = new StringBuffer();

			if (Y41bUtils.isFilled(resultSet.getString("reclamanteUANOMBRE"))) {
				nombreCompleto.append(resultSet.getString("reclamanteUANOMBRE"));
			}
			if (Y41bUtils.isFilled(resultSet.getString("reclamanteUAAPELLIDO1"))) {
				nombreCompleto.append(" ").append(resultSet.getString("reclamanteUAAPELLIDO1"));
			}
			if (Y41bUtils.isFilled(resultSet.getString("reclamanteUAAPELLIDO2"))) {
				nombreCompleto.append(" ").append(resultSet.getString("reclamanteUAAPELLIDO2"));
			}

			reclamante.setUanombre(nombreCompleto.toString());

			return new FiltroArbitraje(resultSet.getString("solarbSACODIGO"), resultSet.getString("SACOJA"),
					resultSet.getBigDecimal("SANRAN"), resultSet.getBigDecimal("SANROR"),
					resultSet.getString("SACOJA") + Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP
							+ resultSet.getBigDecimal("SANROR") + Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP
							+ resultSet.getBigDecimal("SANRAN"),
					resultSet.getDate("SAFESOLI"), null, null, arbexp, reclamante, reclamado, censomonitor, arbtramexp,
					fase, resultSet.getDate("SAFECFIN"));
		}
	};

	private String getFromBusquedaArbitrajes() {
		return "FROM SOLARB t1 , ARBEXP t2, FASE t3, ARBINTERV t5, ARBENVIO t6, CENSO_MONITOR t7, (SELECT T8.TRID, T9.TRNOMBRE, T9.TRNOMBREE, T8.TRNOMTRAMES, T8.TRCODIGO, t8.TRFECCIERRE, T8.TRRESOTIPO, T8.TRFECINI, T8.TRMOCODIGO FROM ARBTRAMEXP T8, TRAMITE T9 WHERE T9.TRCODIGO= T8.TRCODIGO) t10, ARBINTERV T11, DECISION t13, ESSA T14, ESTABLECIMIENTO T15";
	}

	private String getWhereBusquedaArbitrajes() {
		return " WHERE 1=1	AND T1.SACODIGO= T2.EXCODIGO(+)	AND T2.EXFCODIGO = T3.FCODIGO(+) AND T5.UAEXCODIGO = T1.SACODIGO AND T1.SACODIGO= T14.MACOSA "
				+ "AND T14.MACOES= T15.ESCODIGO AND T1.SACODIGO = T6.ENEXID(+) AND T2.EXMOCODIGO = T7.MOCODIGO(+)	AND T2.EXTRPOSCOD = T10.TRID(+)	"
				+ "AND T11.UAEXCODIGO = T1.SACODIGO	AND T5.UATIPOINTERV = '"
				+ Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO
				+ "' AND T2.EXTIPRES= T13.DECODIGO(+) AND T11.UATIPOINTERV = '"
				+ Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE + "'";
	}

	private String getWhereBusquedaArbitrajesHist() {
		return " WHERE 1=1 AND T1.SACODIGO= T11.MACOSA(+) AND T11.MACOES= T5.ESCODIGO "
				+ " AND NOT EXISTS (SELECT UAIDINTERV FROM ARBINTERV WHERE UAEXCODIGO = T1.SACODIGO) "
				+ " AND T1.SACODIGO = T13.M9COSA(+) AND T13.M9CODT = T12.DTCODIGO ";

	}

	private String getFromBusquedaArbitrajesHist() {
		return "FROM SOLARB t1 , ESTABLECIMIENTO t5, ESSA t11, CONSUMIDOR t12, DTSA t13 ";
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Arbitraje entity
	 * 
	 * @param filtroArbitrajes
	 *            filtroArbitraje Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generacion de codigo de UDA
	private Map<String, ?> getWhereLikeMapArbitrajes(FiltroArbitraje filtroArbitrajes, Boolean startsWith,
			boolean combinada) {

		StringBuilder where = new StringBuilder(ExpedienDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (filtroArbitrajes != null && filtroArbitrajes.getSacoja() != null
				&& filtroArbitrajes.getSacoja().length() < 6) {
			where.append(" AND UPPER(t1.SACOJA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(filtroArbitrajes.getSacoja().toUpperCase() + "%");
			} else {
				params.add("%" + filtroArbitrajes.getSacoja().toUpperCase() + "%");
			}
			where.append(" AND t1.SACOJA IS NOT NULL");
		} else if (filtroArbitrajes != null && filtroArbitrajes.getSacoja() != null) {
			where.append(" AND UPPER(t1.SACOJA)=? ");
			params.add(filtroArbitrajes.getSacoja().toUpperCase());
		}
		if (filtroArbitrajes != null && filtroArbitrajes.getSanran() != null) {
			where.append(" AND t1.SANRAN = ?");
			params.add(filtroArbitrajes.getSanran().intValue());
		}
		if (filtroArbitrajes != null && filtroArbitrajes.getSanror() != null) {
			where.append(" AND t1.SANROR = ?");
			params.add(filtroArbitrajes.getSanror());
		}
		if (filtroArbitrajes != null && filtroArbitrajes.getArbexp().getExmocodigo() != null) {
			where.append(" AND t2.EXMOCODIGO = ?");
			params.add(filtroArbitrajes.getArbexp().getExmocodigo());
		}
		if (filtroArbitrajes != null && filtroArbitrajes.getFechaIniDesde() != null
				&& filtroArbitrajes.getFechaIniDesde() instanceof Date) {
			where.append(" AND trunc(t1.SAFESOLI) >= trunc(?)");
			params.add(filtroArbitrajes.getFechaIniDesde());
		}
		if (filtroArbitrajes != null && filtroArbitrajes.getFechaIniHasta() != null
				&& filtroArbitrajes.getFechaIniHasta() instanceof Date) {
			where.append(" AND trunc(t1.SAFESOLI) <= trunc(?)");
			params.add(filtroArbitrajes.getFechaIniHasta());
		}

		if (filtroArbitrajes != null && filtroArbitrajes.getArbintervReclamado() != null
				&& (filtroArbitrajes.getArbintervReclamado().getUanif() != null
						|| filtroArbitrajes.getArbintervReclamado().getUanombre() != null
						|| filtroArbitrajes.getArbintervReclamado().getUaprovId() != null
						|| filtroArbitrajes.getArbintervReclamado().getUamunId() != null
						|| filtroArbitrajes.getArbintervReclamado().getUalocId() != null)) {

			// where.append(" AND t5.UATIPOINTERV = '"
			// + Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO + "'");
		}

		if (filtroArbitrajes != null && filtroArbitrajes.getArbintervReclamado().getUanif() != null) {
			where.append(" AND UPPER(t5.UANIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(filtroArbitrajes.getArbintervReclamado().getUanif().toUpperCase() + "%");
			} else {
				params.add("%" + filtroArbitrajes.getArbintervReclamado().getUanif().toUpperCase() + "%");
			}
			where.append(" AND t5.UANIF IS NOT NULL");
		}

		if (!combinada && filtroArbitrajes != null && filtroArbitrajes.getArbintervReclamado().getUanombre() != null) {
			where.append(" AND ((TRANSLATE(UPPER(t5.UANOMBRE),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(filtroArbitrajes.getArbintervReclamado().getUanombre().toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%"
						+ filtroArbitrajes.getArbintervReclamado().getUanombre().toUpperCase().replaceAll("", "A")
								.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U")
						+ "%");
			}
			where.append(") AND t5.UANOMBRE IS NOT NULL ");
			where.append(" OR (TRANSLATE(UPPER(t5.UANOCO),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(filtroArbitrajes.getArbintervReclamado().getUanombre().toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%"
						+ filtroArbitrajes.getArbintervReclamado().getUanombre().toUpperCase().replaceAll("", "A")
								.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U")
						+ "%");
			}
			where.append(") AND t5.UANOCO IS NOT NULL) ");
		}

		if (combinada && filtroArbitrajes != null && filtroArbitrajes.getArbintervReclamado().getUanombre() != null) {
			where.append(" AND (TRANSLATE(UPPER(t5.UANOMBRE),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(filtroArbitrajes.getArbintervReclamado().getUanombre().toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%"
						+ filtroArbitrajes.getArbintervReclamado().getUanombre().toUpperCase().replaceAll("", "A")
								.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U")
						+ "%");
			}
			where.append(") AND t5.UANOMBRE IS NOT NULL ");
		}
		if (combinada && filtroArbitrajes != null && filtroArbitrajes.getArbintervReclamado().getUanoco() != null) {
			where.append(" AND (TRANSLATE(UPPER(t5.UANOCO),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(filtroArbitrajes.getArbintervReclamado().getUanoco().toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%"
						+ filtroArbitrajes.getArbintervReclamado().getUanoco().toUpperCase().replaceAll("", "A")
								.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U")
						+ "%");
			}
			where.append(") AND t5.UANOCO IS NOT NULL ");
		}

		if (filtroArbitrajes != null
				&& "S".equalsIgnoreCase(filtroArbitrajes.getArbintervReclamado().getUaextranjero())) {
			if (filtroArbitrajes != null && filtroArbitrajes.getArbintervReclamado().getUapaisId() != null) {
				where.append(" AND t5.UAPAIS_ID = ?");
				params.add(filtroArbitrajes.getArbintervReclamado().getUapaisId());
			} else if (filtroArbitrajes != null && filtroArbitrajes.getArbintervReclamado().getUapaisId() == null) {
				where.append(" AND t5.UAPAIS_ID != '108'");
			}

			if (filtroArbitrajes != null && filtroArbitrajes.getArbintervReclamado().getUadireNocapv() != null) {
				where.append(" AND t5.UADIRE_NOCAPV = ?");
				params.add(filtroArbitrajes.getArbintervReclamado().getUadireNocapv());
			}
		} else {

			if (filtroArbitrajes != null && filtroArbitrajes.getArbintervReclamado().getUaprovId() != null) {
				where.append(" AND t5.UAPROV_ID = ?");
				params.add(filtroArbitrajes.getArbintervReclamado().getUaprovId());
			}

			if (filtroArbitrajes != null && filtroArbitrajes.getArbintervReclamado().getUamunId() != null) {
				where.append(" AND t5.UAMUN_ID = ?");
				params.add(filtroArbitrajes.getArbintervReclamado().getUamunId());
			}

			if (filtroArbitrajes != null && filtroArbitrajes.getArbintervReclamado().getUalocId() != null) {
				where.append(" AND t5.UALOC_ID = ?");
				params.add(filtroArbitrajes.getArbintervReclamado().getUalocId());
			}
		}

		if (filtroArbitrajes != null && (filtroArbitrajes.getArbexp().getExfcodigo() != null
				|| filtroArbitrajes.getArbtramexp().getTrcodigo() != null
				|| filtroArbitrajes.getFechaTramitacionDesde() != null
				|| filtroArbitrajes.getFechaTramitacionHasta() != null
				|| filtroArbitrajes.getArbtramexp().getTrmonitor() != null
				|| (filtroArbitrajes.getUltimoTramite() != null && filtroArbitrajes.getUltimoTramite().booleanValue())
				|| (filtroArbitrajes.getAcuseRecibo() != null && filtroArbitrajes.getAcuseRecibo().booleanValue())
				|| (filtroArbitrajes.getIndPendienteFirma() != null
						&& filtroArbitrajes.getIndPendienteFirma().booleanValue()))) {
			where.append(" AND EXISTS (SELECT 1 FROM ARBTRAMEXP t12 WHERE t12.TREXCODIGO=t1.SACODIGO ");
			if (filtroArbitrajes != null && filtroArbitrajes.getArbexp().getExfcodigo() != null) {
				where.append(" AND t12.TRFCODIGO = ?");
				params.add(filtroArbitrajes.getArbexp().getExfcodigo());
			}
			if (filtroArbitrajes != null && filtroArbitrajes.getArbtramexp().getTrcodigo() != null) {
				where.append(" AND t12.TRCODIGO = ?");
				params.add(filtroArbitrajes.getArbtramexp().getTrcodigo());
			}
			if (filtroArbitrajes != null && filtroArbitrajes.getFechaTramitacionDesde() != null
					&& filtroArbitrajes.getFechaTramitacionDesde() instanceof Date) {
				where.append(" AND trunc(t12.TRFECINI) >= trunc(?)");
				params.add(filtroArbitrajes.getFechaTramitacionDesde());
			}
			if (filtroArbitrajes != null && filtroArbitrajes.getFechaTramitacionHasta() != null
					&& filtroArbitrajes.getFechaTramitacionHasta() instanceof Date) {
				where.append(" AND trunc(t12.TRFECINI) <= trunc(?)");
				params.add(filtroArbitrajes.getFechaTramitacionHasta());
			}
			if (filtroArbitrajes != null && (filtroArbitrajes.getUltimoTramite() != null
					&& filtroArbitrajes.getUltimoTramite().booleanValue())) {
				where.append(" AND t12.TRID = t2.EXTRPOSCOD ");
			}
			// EVOLUTIVO 0134898 2.10
			if (filtroArbitrajes != null && filtroArbitrajes.getRadioTramite() != null
					&& (filtroArbitrajes.getRadioTramite().equals(Y41bConstantes.BUSQUEDA_ARBITRAJE_ACTUAL_TRAMITE))) {
				where.append(" AND t12.TRESTADO <> '" + Y41bConstantes.ESTADO_TRAMITE_TRAMITADO + "' ");
			}
			//
			// EVOLUTIVO 0134898 2.10
			if (filtroArbitrajes != null && (filtroArbitrajes.getAcuseRecibo() != null
					&& filtroArbitrajes.getAcuseRecibo().booleanValue())) {
				// Las comunicaciones dejan registro en envío pero no tienen
				// acuse
				where.append(" AND t6.ENTRID = t12.TRID AND T12.TRCODIGO != '");
				where.append(Y41bConstantes.TRAMITE_ARBITRAJE_COMUNICACION);
				where.append("' AND t6.ENFECACUSE IS NULL ");
			}
			// Con pendiente firma
			if (filtroArbitrajes != null && filtroArbitrajes.getIndPendienteFirma() != null
					&& filtroArbitrajes.getIndPendienteFirma().booleanValue()) {
				where.append(" AND t12.TRESTADO = ? ");
				params.add(Y41bConstantes.ESTADO_TRAMITE_PENDIENTEFIRMA);
			}
			if (filtroArbitrajes != null && filtroArbitrajes.getArbtramexp().getTrmonitor() != null) {
				where.append(" AND t12.TRMOCODIGO = ?");
				params.add(filtroArbitrajes.getArbtramexp().getTrmonitor());
			}
			where.append(" ) ");
		}

		// TIPO DE RESOLUCIN
		if (filtroArbitrajes != null && filtroArbitrajes.getArbexp().getExtipres() != null) {
			where.append(" AND t2.EXTIPRES = ?");
			params.add(filtroArbitrajes.getArbexp().getExtipres());
		}
		// PENDIENTE DE DECISION
		if (filtroArbitrajes != null && filtroArbitrajes.getIndPendienteDecision() != null
				&& filtroArbitrajes.getIndPendienteDecision().booleanValue()) {
			where.append(" AND t2.EXTIPRES IS NULL ");
		}
		// INCLUIR CERRADOS
		if (filtroArbitrajes != null && filtroArbitrajes.getIndCerrados() != null
				&& !filtroArbitrajes.getIndCerrados().booleanValue()) {
			where.append(" AND t1.SAFEAR IS NULL ");
		}
		if (filtroArbitrajes != null && filtroArbitrajes.getArbintervReclamante() != null
				&& (filtroArbitrajes.getArbintervReclamante().getUanif() != null
						|| filtroArbitrajes.getArbintervReclamante().getUanombre() != null
						|| filtroArbitrajes.getArbintervReclamante().getUaprovId() != null
						|| filtroArbitrajes.getArbintervReclamante().getUamunId() != null
						|| filtroArbitrajes.getArbintervReclamante().getUalocId() != null)) {

			// where.append(" AND t11.UATIPOINTERV = '"
			// + Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE + "'");
		}
		if (filtroArbitrajes != null && filtroArbitrajes.getArbintervReclamante() != null
				&& filtroArbitrajes.getArbintervReclamante().getUanif() != null) {

			where.append(" AND UPPER(t11.UANIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(filtroArbitrajes.getArbintervReclamante().getUanif().toUpperCase() + "%");
			} else {
				params.add("%" + filtroArbitrajes.getArbintervReclamante().getUanif().toUpperCase() + "%");
			}
			where.append(" AND t11.UANIF IS NOT NULL");
		}
		if (filtroArbitrajes != null && filtroArbitrajes.getArbintervReclamante() != null) {

			if (filtroArbitrajes.getArbintervReclamante().getUanombre() != null) {
				where.append(" AND TRIM(TRANSLATE(UPPER(TRIM(t11.UANOMBRE)),'','AEIOU')) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(
							filtroArbitrajes.getArbintervReclamante().getUanombre().toUpperCase().replaceAll("", "A")
									.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U")
									+ "%");
				} else {
					params.add("%"
							+ filtroArbitrajes.getArbintervReclamante().getUanombre().toUpperCase().replaceAll("", "A")
									.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U")
							+ "%");
				}
				where.append(" AND t11.UANOMBRE IS NOT NULL ");
			}

			if (filtroArbitrajes.getArbintervReclamante().getUaapellido1() != null) {
				where.append(" AND TRIM(TRANSLATE(UPPER(TRIM(t11.UAAPELLIDO1)),'','AEIOU')) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(filtroArbitrajes.getArbintervReclamante().getUaapellido1().toUpperCase()
							.replaceAll("", "A").replaceAll("", "E").replaceAll("", "I").replaceAll("", "O")
							.replaceAll("", "U") + "%");
				} else {
					params.add("%" + filtroArbitrajes.getArbintervReclamante().getUaapellido1().toUpperCase()
							.replaceAll("", "A").replaceAll("", "E").replaceAll("", "I").replaceAll("", "O")
							.replaceAll("", "U") + "%");
				}
				where.append(" AND t11.UAAPELLIDO1 IS NOT NULL ");
			}

			if (filtroArbitrajes.getArbintervReclamante().getUaapellido2() != null) {
				where.append(" AND TRIM(TRANSLATE(UPPER(TRIM(t11.UAAPELLIDO2)),'','AEIOU')) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(filtroArbitrajes.getArbintervReclamante().getUaapellido2().toUpperCase()
							.replaceAll("", "A").replaceAll("", "E").replaceAll("", "I").replaceAll("", "O")
							.replaceAll("", "U") + "%");
				} else {
					params.add("%" + filtroArbitrajes.getArbintervReclamante().getUaapellido2().toUpperCase()
							.replaceAll("", "A").replaceAll("", "E").replaceAll("", "I").replaceAll("", "O")
							.replaceAll("", "U") + "%");
				}
				where.append(" AND t11.UAAPELLIDO2 IS NOT NULL ");
			}
		}

		if (filtroArbitrajes != null
				&& "S".equalsIgnoreCase(filtroArbitrajes.getArbintervReclamante().getUaextranjero())) {
			if (filtroArbitrajes != null && filtroArbitrajes.getArbintervReclamante().getUapaisId() != null) {
				where.append(" AND t11.UAPAIS_ID = ?");
				params.add(filtroArbitrajes.getArbintervReclamante().getUapaisId());
			} else if (filtroArbitrajes != null && filtroArbitrajes.getArbintervReclamante().getUapaisId() == null) {
				where.append(" AND t11.UAPAIS_ID != '108'");
			}

			if (filtroArbitrajes != null && filtroArbitrajes.getArbintervReclamante().getUadireNocapv() != null) {
				where.append(" AND t11.UADIRE_NOCAPV = ?");
				params.add(filtroArbitrajes.getArbintervReclamante().getUadireNocapv());
			}
		} else {

			if (filtroArbitrajes != null && filtroArbitrajes.getArbintervReclamante() != null
					&& filtroArbitrajes.getArbintervReclamante().getUaprovId() != null) {
				where.append(" AND t11.UAPROV_ID = ?");
				params.add(filtroArbitrajes.getArbintervReclamante().getUaprovId());
			}
			if (filtroArbitrajes != null && filtroArbitrajes.getArbintervReclamante() != null
					&& filtroArbitrajes.getArbintervReclamante().getUamunId() != null) {
				where.append(" AND t11.UAMUN_ID = ?");
				params.add(filtroArbitrajes.getArbintervReclamante().getUamunId());
			}
			if (filtroArbitrajes != null && filtroArbitrajes.getArbintervReclamante() != null
					&& filtroArbitrajes.getArbintervReclamante().getUalocId() != null) {
				where.append(" AND t11.UALOC_ID = ?");
				params.add(filtroArbitrajes.getArbintervReclamante().getUalocId());
			}
		}

		// para buscar solicitudes de arbitraje desde el alta de arbitraje
		// FILTRO POR DTCODIGO
		if (filtroArbitrajes != null && filtroArbitrajes.getArbintervReclamante() != null
				&& filtroArbitrajes.getArbintervReclamante().getUadtcodigo() != null) {

			where.append(" AND (t11.UADTCODIGO) =?");
			params.add(filtroArbitrajes.getArbintervReclamante().getUadtcodigo());
			where.append(" AND t11.UADTCODIGO IS NOT NULL");
		}

		// Numero de entrada de registro
		if (filtroArbitrajes != null && filtroArbitrajes.getArbexp() != null
				&& filtroArbitrajes.getArbexp().getExregen() != null) {
			where.append(" AND t2.EXREGEN = ?");
			params.add(filtroArbitrajes.getArbexp().getExregen());
		}

		// TODO ODEI
		// Direccion NO CAV
		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Expedien entity
	 * 
	 * @param expedien
	 *            Expedien Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - GeneraciÃ³n de cÃ³digo de UDA
	private Map<String, ?> getWhereLikeMapArbitrajesHistoricas(FiltroArbitraje filtroArbitraje, Boolean startsWith,
			boolean combinada) {

		StringBuilder where = new StringBuilder(ExpedienDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (filtroArbitraje != null && filtroArbitraje.getSacoja() != null
				&& filtroArbitraje.getSacoja().length() < 6) {
			where.append(" AND UPPER(t1.SACOJA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(filtroArbitraje.getSacoja().toUpperCase() + "%");
			} else {
				params.add("%" + filtroArbitraje.getSacoja().toUpperCase() + "%");
			}
			where.append(" AND t1.SACOJA IS NOT NULL");
		} else if (filtroArbitraje != null && filtroArbitraje.getSacoja() != null) {
			where.append(" AND UPPER(t1.SACOJA)=? ");
			params.add(filtroArbitraje.getSacoja().toUpperCase());
		}
		if (filtroArbitraje != null && filtroArbitraje.getSanran() != null) {
			where.append(" AND t1.SANRAN = ?");
			params.add(filtroArbitraje.getSanran().intValue());
		}
		if (filtroArbitraje != null && filtroArbitraje.getSanror() != null) {
			where.append(" AND t1.SANROR = ?");
			params.add(filtroArbitraje.getSanror());
		}

		if (filtroArbitraje != null && filtroArbitraje.getFechaIniDesde() != null
				&& filtroArbitraje.getFechaIniDesde() instanceof Date) {
			where.append(" AND trunc(t1.SAFESOLI) >= trunc(?)");
			params.add(filtroArbitraje.getFechaIniDesde());
		}
		if (filtroArbitraje != null && filtroArbitraje.getFechaIniHasta() != null
				&& filtroArbitraje.getFechaIniHasta() instanceof Date) {
			where.append(" AND trunc(t1.SAFESOLI) <= trunc(?)");
			params.add(filtroArbitraje.getFechaIniHasta());
		}

		/* TABLAS VIEJAS */
		if (filtroArbitraje != null && filtroArbitraje.getArbintervReclamado().getUanif() != null) {
			where.append(" AND UPPER(t5.ESNIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(filtroArbitraje.getArbintervReclamado().getUanif().toUpperCase() + "%");
			} else {
				params.add("%" + filtroArbitraje.getArbintervReclamado().getUanif().toUpperCase() + "%");
			}
			where.append(" AND t5.ESNIF IS NOT NULL");
		}

		if (!combinada && filtroArbitraje != null && filtroArbitraje.getArbintervReclamado().getUanombre() != null) {

			where.append(" AND ((TRANSLATE(UPPER(t5.ESNOCO),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(filtroArbitraje.getArbintervReclamado().getUanombre().toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%"
						+ filtroArbitraje.getArbintervReclamado().getUanombre().toUpperCase().replaceAll("", "A")
								.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U")
						+ "%");
			}
			where.append(" AND t5.ESNOCO IS NOT NULL ");
			where.append(" ) OR ( ");
			where.append(" TRANSLATE(UPPER(t5.ESNOMBRE),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(filtroArbitraje.getArbintervReclamado().getUanombre().toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%"
						+ filtroArbitraje.getArbintervReclamado().getUanombre().toUpperCase().replaceAll("", "A")
								.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U")
						+ "%");
			}
			where.append(" AND t5.ESNOMBRE IS NOT NULL ))");
		}

		if (combinada && filtroArbitraje != null && filtroArbitraje.getArbintervReclamado().getUanombre() != null) {
			where.append(" AND (TRANSLATE(UPPER(t5.ESNOMBRE),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(filtroArbitraje.getArbintervReclamado().getUanombre().toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%"
						+ filtroArbitraje.getArbintervReclamado().getUanombre().toUpperCase().replaceAll("", "A")
								.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U")
						+ "%");
			}
			where.append(") AND t5.ESNOMBRE IS NOT NULL ");
		}
		if (combinada && filtroArbitraje != null && filtroArbitraje.getArbintervReclamado().getUanoco() != null) {
			where.append(" AND (TRANSLATE(UPPER(t5.ESNOCO),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(filtroArbitraje.getArbintervReclamado().getUanoco().toUpperCase().replaceAll("", "A")
						.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			} else {
				params.add("%"
						+ filtroArbitraje.getArbintervReclamado().getUanoco().toUpperCase().replaceAll("", "A")
								.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U")
						+ "%");
			}
			where.append(") AND t5.ESNOCO IS NOT NULL ");
		}

		if (filtroArbitraje != null
				&& "S".equalsIgnoreCase(filtroArbitraje.getArbintervReclamado().getUaextranjero())) {
			if (filtroArbitraje != null && filtroArbitraje.getArbintervReclamado().getUapaisId() != null) {
				where.append(" AND t5.ESNORA_PAIS_ID = ?");
				params.add(filtroArbitraje.getArbintervReclamado().getUapaisId());
			} else if (filtroArbitraje != null && filtroArbitraje.getArbintervReclamado().getUapaisId() == null) {
				where.append(" AND t5.ESNORA_PAIS_ID != '108'");
			}

			if (filtroArbitraje != null && filtroArbitraje.getArbintervReclamado().getUadireNocapv() != null) {
				where.append(" AND t5.ESDIRECCION_NOCAPV = ?");
				params.add(filtroArbitraje.getArbintervReclamado().getUadireNocapv());
			}

		} else {

			if (filtroArbitraje != null && filtroArbitraje.getArbintervReclamado().getUaprovId() != null) {
				where.append(" AND t5.ESNORA_PROVINCIA_ID = ?");
				params.add(filtroArbitraje.getArbintervReclamado().getUaprovId());
			}

			if (filtroArbitraje != null && filtroArbitraje.getArbintervReclamado().getUamunId() != null) {
				where.append(" AND t5.ESNORA_MUNICIPIO_ID = ?");
				params.add(filtroArbitraje.getArbintervReclamado().getUamunId());
			}

			if (filtroArbitraje != null && filtroArbitraje.getArbintervReclamado().getUalocId() != null) {
				where.append(" AND t5.ESNORA_LOCALIDAD_ID = ?");
				params.add(filtroArbitraje.getArbintervReclamado().getUalocId());
			}
		}

		if (filtroArbitraje != null && filtroArbitraje.getArbexp().getExtipres() != null) {
			where.append(dameWhereTipoResoHist(filtroArbitraje.getArbexp().getExtipres()));
			// params.add(filtroArbitraje.getTipoResolucion());
		}

		/*
		 * si le he metido el dato del dtcodigo no tiene que salir para la
		 * busqueda combinada de solicitudes
		 */
		if (filtroArbitraje != null && filtroArbitraje.getArbintervReclamado() != null
				&& filtroArbitraje.getArbintervReclamado().getUadtcodigo() != null) {
			where.append(" AND 1 = 0");
		}

		/* consumidores */

		if (filtroArbitraje != null && filtroArbitraje.getArbintervReclamante() != null
				&& filtroArbitraje.getArbintervReclamante().getUanif() != null) {

			where.append(" AND UPPER(t12.DTNIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(filtroArbitraje.getArbintervReclamante().getUanif().toUpperCase() + "%");
			} else {
				params.add("%" + filtroArbitraje.getArbintervReclamante().getUanif().toUpperCase() + "%");
			}
			where.append(" AND t12.DTNIF IS NOT NULL");
		}

		if (filtroArbitraje != null && filtroArbitraje.getArbintervReclamante() != null) {

			if (filtroArbitraje.getArbintervReclamante().getUanombre() != null) {
				where.append(" AND TRANSLATE(UPPER(t12.DTNOMBRE),'','AEIOU') like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(filtroArbitraje.getArbintervReclamante().getUanombre().toUpperCase().replaceAll("", "A")
							.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
				} else {
					params.add("%"
							+ filtroArbitraje.getArbintervReclamante().getUanombre().toUpperCase().replaceAll("", "A")
									.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U")
							+ "%");
				}
				where.append(" AND t12.DTNOMBRE IS NOT NULL ");
			}

			if (filtroArbitraje.getArbintervReclamante().getUaapellido1() != null) {
				where.append(" AND TRANSLATE(UPPER(t12.DTAPELLIDO1),'','AEIOU') like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(
							filtroArbitraje.getArbintervReclamante().getUaapellido1().toUpperCase().replaceAll("", "A")
									.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U")
									+ "%");
				} else {
					params.add("%" + filtroArbitraje.getArbintervReclamante().getUaapellido1().toUpperCase()
							.replaceAll("", "A").replaceAll("", "E").replaceAll("", "I").replaceAll("", "O")
							.replaceAll("", "U") + "%");
				}
				where.append(" AND t12.DTAPELLIDO1 IS NOT NULL ");
			}

			if (filtroArbitraje.getArbintervReclamante().getUaapellido2() != null) {
				where.append(" AND TRANSLATE(UPPER(t12.DTAPELLIDO2),'','AEIOU') like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(
							filtroArbitraje.getArbintervReclamante().getUaapellido2().toUpperCase().replaceAll("", "A")
									.replaceAll("", "E").replaceAll("", "I").replaceAll("", "O").replaceAll("", "U")
									+ "%");
				} else {
					params.add("%" + filtroArbitraje.getArbintervReclamante().getUaapellido2().toUpperCase()
							.replaceAll("", "A").replaceAll("", "E").replaceAll("", "I").replaceAll("", "O")
							.replaceAll("", "U") + "%");
				}
				where.append(" AND t12.DTAPELLIDO2 IS NOT NULL ");
			}
		}

		if (filtroArbitraje != null
				&& "S".equalsIgnoreCase(filtroArbitraje.getArbintervReclamante().getUaextranjero())) {

			if (filtroArbitraje != null && filtroArbitraje.getArbintervReclamante() != null
					&& filtroArbitraje.getArbintervReclamante().getUapaisId() != null) {
				where.append(" AND t12.DTNORA_PAIS_ID = ?");
				params.add(filtroArbitraje.getArbintervReclamante().getUapaisId());
			} else if (filtroArbitraje != null && filtroArbitraje.getArbintervReclamante() != null
					&& filtroArbitraje.getArbintervReclamante().getUapaisId() == null) {
				where.append(" AND t12.DTNORA_PAIS_ID != '108'");
			}

			if (filtroArbitraje != null && filtroArbitraje.getArbintervReclamante() != null
					&& filtroArbitraje.getArbintervReclamante().getUadireNocapv() != null) {
				where.append(" AND t12.DTDIRECCION_NOCAPV = ?");
				params.add(filtroArbitraje.getArbintervReclamante().getUadireNocapv());
			}
		} else {
			if (filtroArbitraje != null && filtroArbitraje.getArbintervReclamante() != null
					&& filtroArbitraje.getArbintervReclamante().getUaprovId() != null) {
				where.append(" AND t12.DTNORA_PROVINCIA_ID = ?");
				params.add(filtroArbitraje.getArbintervReclamante().getUaprovId());
			}
			if (filtroArbitraje != null && filtroArbitraje.getArbintervReclamante() != null
					&& filtroArbitraje.getArbintervReclamante().getUamunId() != null) {
				where.append(" AND t12.DTNORA_MUNICIPIO_ID = ?");
				params.add(filtroArbitraje.getArbintervReclamante().getUamunId());
			}
			if (filtroArbitraje != null && filtroArbitraje.getArbintervReclamante() != null
					&& filtroArbitraje.getArbintervReclamante().getUalocId() != null) {
				where.append(" AND t12.DTNORA_LOCALIDAD_ID = ?");
				params.add(filtroArbitraje.getArbintervReclamante().getUalocId());
			}
		}

		// para la busqueda de arbitrajes desde el alta de arbitraje
		// FILTRAR POR DTCODIGO
		/* consumidores */

		if (filtroArbitraje != null && filtroArbitraje.getArbintervReclamante() != null
				&& filtroArbitraje.getArbintervReclamante().getUadtcodigo() != null) {

			where.append(" AND (t12.DTCODIGO) = ? ");
			params.add(filtroArbitraje.getArbintervReclamante().getUadtcodigo());
			where.append(" AND t12.DTCODIGO IS NOT NULL");
		}

		if (filtroArbitraje != null && filtroArbitraje.getIndCerrados() != null
				&& !filtroArbitraje.getIndCerrados().booleanValue()) {
			where.append(" AND t1.SAFEAR IS NULL ");
		}

		// TODO ODEI
		// Direccion NO CAV
		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	private String dameWhereTipoResoHist(String tipoReso) {

		String where = "";

		if (tipoReso.equalsIgnoreCase("AR7")) { // Laudo
			where = " AND t1.SAFELAUD IS NOT NULL ";
		} else if (tipoReso.equalsIgnoreCase("AR1")) { // Inadmisin
			where = " AND t1.SAFEINAD IS NOT NULL ";
		} else if (tipoReso.equalsIgnoreCase("AR2")) { // Traslado
			where = " AND t1.SAFETRAS IS NOT NULL ";
		} else if (tipoReso.equalsIgnoreCase("AR3")) { // Desistimiento
			where = " AND t1.SAFENODE IS NOT NULL ";
		} else if (tipoReso.equalsIgnoreCase("AR4")) { // Acuerdo
			where = " AND t1.SAFEMEDI IS NOT NULL AND t1.SAINREME = 'A' ";
		} else if (tipoReso.equalsIgnoreCase("AR5")) { // No localizado
			where = " AND t1.SACOT7 = '5' ";
		} else if (tipoReso.equalsIgnoreCase("AR6")) { // Acumulacin
			where = " AND (t1.SACOT7 = '1' OR t1.SACOT7 = '2' OR t1.SACOT7 = '3') ";
		} else if (tipoReso.equalsIgnoreCase("AR8")) { // Caducidad
			where = " AND t1.SACOT7 = '4' ";
		} else if (tipoReso.equalsIgnoreCase("AR9")) { // No aceptacin
			where = " AND t1.SACOT7= 'N' ";
		} else if (tipoReso.equalsIgnoreCase("AR10")) { // No subsanacin
			// No se mira
			where = " AND 1=0 ";
		} else if (tipoReso.equalsIgnoreCase("AR11")) { // Error
			// No se mira
			where = " AND 1=0 ";
		}

		return where;

	}

	/**
	 * Updates a single row in the Solarb table.
	 * 
	 * @param solarb
	 *            Solarb
	 */
	public void updateEnvioPagoLaudo(Solarb solarb) {
		String query = "UPDATE SOLARB SET SAFEOPLA=? WHERE SACODIGO=?";
		this.jdbcTemplate.update(query, solarb.getSafeopla(), solarb.getSacodigo());
	}

	/**
	 * Metodo para actualizar la fecha de orden pago pericial colegio
	 * 
	 * @param solarb
	 *            Solarb
	 */
	public void updateEnvioPagoPericialColegio(Solarb solarb) {
		String query = "UPDATE SOLARB SET SAFEOPPC=? WHERE SACODIGO=?";
		this.jdbcTemplate.update(query, solarb.getSafeoppc(), solarb.getSacodigo());
	}

	/**
	 * Metodo para actualizar el tipo de arbitraje
	 * 
	 * @param solarb
	 *            Solarb
	 */
	public void updateTipoArbitraje(Solarb solarb) {
		String query = "UPDATE SOLARB SET SAINTISO=? WHERE SACODIGO=?";
		this.jdbcTemplate.update(query, solarb.getSaintiso(), solarb.getSacodigo());
	}

	/**
	 * @param filtroSanciones
	 *            FiltroSanciones
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeArbitrajesBusquedaCombinadaCount(FiltroArbitraje filtroArbitraje, Boolean startsWith) {

		StringBuilder query = new StringBuilder(
				" ( SELECT COUNT (DISTINCT T1.SACODIGO) " + getFromBusquedaArbitrajes());

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMapArbitrajes(filtroArbitraje, startsWith, true);
		StringBuilder where = new StringBuilder(getWhereBusquedaArbitrajes());

		where.append(mapaWhere.get("query"));
		query.append(where);
		query.append(")");

		List<?> params = (List<?>) mapaWhere.get("params");

		Long resultado1 = this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
		StringBuilder query2 = new StringBuilder(
				" ( SELECT COUNT (DISTINCT T1.SACODIGO) " + getFromBusquedaArbitrajesHist());

		// Where clause & Params
		Map<String, ?> mapaWhere2 = this.getWhereLikeMapArbitrajesHistoricas(filtroArbitraje, startsWith, true);
		StringBuilder where2 = new StringBuilder(getWhereBusquedaArbitrajesHist());
		where2.append(mapaWhere2.get("query"));
		query2.append(where2);
		query2.append(")");

		List<?> params2 = ((List<?>) mapaWhere2.get("params"));
		Long resultado2 = this.jdbcTemplate.queryForLong(query2.toString(), params2.toArray());

		return resultado1 + resultado2;
	}

	/**
	 * @param filtroSanciones
	 *            FiltroSanciones
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List<FiltroSanciones>
	 */
	public List<FiltroArbitraje> findAllLikeArbitrajesCombinada(FiltroArbitraje filtroArbitraje, Pagination pagination,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"( SELECT DISTINCT T1.SACOJA || '-' || T1.SANROR || '-' || T1.SANRAN CODCOMPLETO ,"
						+ " T1.SACODIGO SOLARBSACODIGO, T1.SACOJA SACOJA, T1.SANRAN SANRAN,"
						+ " T1.SANROR SANROR, LPAD(T1.SANROR,12,'0') CORRELATIVOPAD, T1.SAFESOLI SAFESOLI,"
						+ " T2.EXFECFIN SAFECFIN, T2.EXCODIGO ARBEXPEXCODIGO, T2.EXDESCES ARBEXPEXDESCES,"
						+ " T2.EXDESCEU ARBEXPEXDESCEU, T2.EXFECPREVFIN ARBEXPEXFECPREVFIN, T2.EXFECFIN ARBEXPEXFECFIN,"
						+ " T2.EXTIPRES ARBEXPEXTIPRES, T2.EXMOCODIGO ARBEXPEXMOCODIGO, T2.EXFCODIGO ARBEXPEXFCODIGO,"
						+ " T2.EXMOCODIGOULT ARBEXPEXMOCODIGOULT, T2.EXTRPOSCOD ARBEXPEXTRPOSCOD, T2.EXTRENTIDAD ARBEXPEXTRENTIDAD,"
						+ " T3.FCODIGO FASEFCODIGO, T3.FNOMBRE FASEFNOMBRE, T3.FNOMBREE FASEFNOMBREE, T5.UANOMBRE RECLAMADOUANOMBRE,"
						+ " TO_CHAR(T5.UAIDINTERV) RECLAMADOUAIDINTERV, TRIM(T11.UANOMBRE) RECLAMANTEUANOMBRE, TRIM(T11.UAAPELLIDO1) RECLAMANTEUAAPELLIDO1, TRIM(T11.UAAPELLIDO2) RECLAMANTEUAAPELLIDO2, TO_CHAR(T11.UAIDINTERV) RECLAMANTEUAIDINTERV,"
						+ " T7.MOCODIGO MONITORMOCODIGO, T7.MONOMBRE MONITORMONOMBRE, T10.TRCODIGO ARBTRAMEXPTRCODIGO,"
						+ " T10.TRNOMBRE TRAMITETRNOMBRE, T10.TRNOMBREE TRAMITETRNOMBREE, T10.TRNOMTRAMES ARBTRAMEXPTRNOMTRAMES,"
						+ " T13.DECODIGO DECISIONDECODIGO, T13.DENOMBRE DECISIONDENOMBRE, T13.DENOMBREE DECISIONDENOMBREE,"
						+ " (SELECT DS_O FROM T17I.T17_MUNICIPIO WHERE T5.UAPROV_ID = PROVINCIA_ID AND T5.UAMUN_ID = ID) AS NOMBRE_MUNICIPIO,"
						+ " NULL SACOT7, NULL SAFELAUD, NULL SAFEINAD, NULL SAFETRAS, NULL SAFENODE, NULL SAFEMEDI "
						+ getFromBusquedaArbitrajes());

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMapArbitrajes(filtroArbitraje, startsWith, true);
		StringBuilder where = new StringBuilder(getWhereBusquedaArbitrajes());

		where.append(mapaWhere.get("query"));
		query.append(where);
		query.append(")");

		List<?> params = (List<?>) mapaWhere.get("params");

		StringBuilder query2 = new StringBuilder(
				"( SELECT T1.SACOJA || '-' || T1.SANROR || '-' || T1.SANRAN CODCOMPLETO, T1.SACODIGO SOLARBSACODIGO, T1.SACOJA SACOJA, T1.SANRAN SANRAN,"
						+ " T1.SANROR SANROR, LPAD(T1.SANROR,12,'0') CORRELATIVOPAD, T1.SAFESOLI SAFESOLI, NULL SAFECFIN, NULL ARBEXPEXCODIGO, NULL ARBEXPEXDESCES,"
						+ " NULL ARBEXPEXDESCEU, NULL ARBEXPEXFECPREVFIN, NULL ARBEXPEXFECFIN, NULL ARBEXPEXTIPRES, NULL ARBEXPEXMOCODIGO, NULL ARBEXPEXFCODIGO,"
						+ " NULL ARBEXPEXMOCODIGOULT, NULL ARBEXPEXTRPOSCOD, NULL ARBEXPEXTRENTIDAD, NULL FASEFCODIGO, NULL FASEFNOMBRE, NULL FASEFNOMBREE,"
						+ " T5.ESNOMBRE RECLAMADOUANOMBRE, T5.ESCODIGO RECLAMADOUAIDINTERV, TRIM(T12.DTNOMBRE) RECLAMANTEDTNOMBRE, TRIM(T12.DTAPELLIDO1) RECLAMANTEDTAPELLIDO1, TRIM(T12.DTAPELLIDO2) RECLAMANTEDTAPELLIDO2, T12.DTCODIGO RECLAMANTEUAIDINTERV,"
						+ " NULL MONITORMOCODIGO, NULL MONITORMONOMBRE, NULL ARBTRAMEXPTRCODIGO, NULL TRAMITETRNOMBRE, NULL TRAMITETRNOMBREE,"
						+ " NULL ARBTRAMEXPTRNOMTRAMES, NULL DECISIONDECODIGO, NULL DECISIONDENOMBRE, NULL DECISIONDENOMBREE, T1.SACOT7	SACOT7, T1.SAFELAUD	SAFELAUD,"
						+ " T1.SAFEINAD	SAFEINAD, T1.SAFETRAS SAFETRAS, T1.SAFENODE SAFENODE, T1.SAFEMEDI SAFEMEDI, (SELECT	DS_O FROM T17I.T17_MUNICIPIO WHERE T5.ESNORA_PROVINCIA_ID = PROVINCIA_ID"
						+ " AND T5.ESNORA_MUNICIPIO_ID = ID) AS NOMBRE_MUNICIPIO " + getFromBusquedaArbitrajesHist());

		// Where clause & Params
		Map<String, ?> mapaWhere2 = this.getWhereLikeMapArbitrajesHistoricas(filtroArbitraje, startsWith, true);
		StringBuilder where2 = new StringBuilder(getWhereBusquedaArbitrajesHist());
		where2.append(mapaWhere2.get("query"));
		query2.append(where2);
		query2.append(")");

		params.addAll((List) mapaWhere2.get("params"));

		StringBuilder queryDef = new StringBuilder(query.append(" UNION ").append(query2));

		if (pagination != null) {
			queryDef = pagination.getPaginationQuery(queryDef);
		}

		return (List<FiltroArbitraje>) this.jdbcTemplate.query(queryDef.toString(), this.rwMapBusquedaArbitrajesFiltro,
				params.toArray());

	}

	/*** metodo para obterner el fichero ADO de arbitraje **/

	/**
	 * 
	 * findAllLikeListaADO
	 * 
	 * @param filterListado
	 *            ArbListaADO
	 * 
	 * @param pagination
	 *            Pagination
	 * 
	 * @param b
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public List<ArbPagoArbitroADO> findlistaADO(ArbPagoArbitroADO arbPagoArbitroADO, Pagination pagination,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder("");
		List<Object> params = new ArrayList<Object>();

		query.append("SELECT * FROM (");

		///// NORMALES/////
		query.append(
				"SELECT t1.SACODIGO SACODIGO, t1.SACOJA SACOJA, t1.SANROR SANROR, t1.SANRAN SANRAN, ta1.ARCODIGO ARCODIGO, t1.SAFELAUD SAFELAUD, t2.TRID TRIDPAGOLAUDO, t2.TRFEOPLA TRFEOPLA, t2.TRMOCODIGOEJ, ta1.ARNIF ARNIF, ta1.ARNOMBRE ARNOMBRE, ta1.ARTERCERO ARTERCERO, t2.TRCODIGO, ");
		query.append(
				"CASE WHEN t2.TRIMPORTE IS NULL AND t2.TRCODIGO ='K71' THEN (select valor/100 AS VALOR from PARAMETROS WHERE PARAMETRO='"
						+ Y41bADOConstantes.NAME_ADO_IMPORTE + "')  ELSE t2.TRIMPORTE END AS TRIMPORTE, ");
		query.append("p1.PAFECCONT PAFECCONT, p1.PAFECULTCON PAFECULTCON, p1.PADOCFI PADOCFI, p1.PANUMEXP PANUMEXP, ");
		query.append(" t1.SACOJA || '" + Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP + "' || t1.SANROR || '"
				+ Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP + "' || t1.SANRAN CODCOMPLETO, NULL as UAIDINTERV ");
		query.append(" FROM SOLARB t1 INNER JOIN ARBTRAMEXP t2 ON t2.TREXCODIGO=t1.SACODIGO ");
		query.append(
				"LEFT JOIN ( SELECT TREXCODIGO, SACOARPT, SACOARTT, SACOARDT FROM ( SELECT TREXCODIGO, CASE WHEN XJACTIVOPSUP='S' THEN SACOARPS ELSE SACOARPT END SACOARPT, CASE WHEN XJACTIVOAACCSUP='S' THEN SACOARTS ELSE SACOARTT END SACOARTT, CASE WHEN XJACTIVOOOEESUP='S' THEN SACOARDS ELSE SACOARDT END SACOARDT FROM SOLARB, ARBTRAMEXP, ARBCOLEGIO WHERE SACODIGO=TREXCODIGO AND TRID = XJTRID AND TRCODIGO = ? AND TRESTADO = ?) ) t3 ON t1.SACODIGO = t3.TREXCODIGO ");
		params.add(Y41bConstantes.TRAMITE_ARBITRAJE_DESIGNACION_COLEGIO);
		params.add(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		query.append(
				"LEFT JOIN ARBITRO ta1 ON ( t3.SACOARPT=ta1.ARCODIGO OR t3.SACOARTT=ta1.ARCODIGO OR t3.SACOARDT=ta1.ARCODIGO) ");
		query.append(
				"LEFT JOIN  L21.L21XLT00 p1 ON t1.SACODIGO = p1.PASACODIGO AND ta1.ARCODIGO = p1.PAARCODIGO AND t2.TRID = p1.PATRID ");

		query.append(" WHERE   ");
		query.append("  t2.TRCODIGO= ?");
		params.add(Y41bConstantes.TRAMITE_ARBITRAJE_PAGO_LAUDO);
		query.append(" AND t2.TRESTADO= ?");
		params.add(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		if ("R".equals(arbPagoArbitroADO.getEstado())) {
			// pendientes de respuesta eika. valor null en la columna respuesta
			// a eika(PAFECCONT)
			query.append(" AND p1.PAFECCONT IS NULL AND p1.PANUMEXP IS NOT NULL ");
		} else if ("Y".equals(arbPagoArbitroADO.getEstado())) {
			// enviados y respondidos . valor NOT null en la columna respuesta
			// eika
			query.append(" AND p1.PAFECCONT IS NOT NULL");
		} else {
			// estado pendiente de enviar a eika
			// que no tenga registro en xl
			query.append(
					" AND NOT EXISTS (SELECT 1 FROM L21.L21XLT00 WHERE t1.SACODIGO = p1.PASACODIGO AND ta1.ARCODIGO = p1.PAARCODIGO AND t2.TRID = p1.PATRID) ");
			// el pago est pendiente de enviar.
			query.append(" AND t2.TRFICHADO IS NULL ");
		}

		if ("E".equals(arbPagoArbitroADO.getEstado())) {
			if ("A".equals(arbPagoArbitroADO.getIncluir())) {
				// la parte de arriba del safelaud
				query.append(
						" AND EXISTS (SELECT 1 FROM ARBTRAMEXP t3 where t1.SACODIGO=t3.TREXCODIGO AND t3.TRCODIGO=? AND t3.TRESTADO=? AND t3.TRFECAUDIENCIA IS NOT NULL  ");
				params.add(Y41bConstantes.TRAMITE_ARBITRAJE_AUDIENCIA);
				params.add(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

				if (arbPagoArbitroADO != null && arbPagoArbitroADO.getFechaDesde() != null
						&& arbPagoArbitroADO.getFechaDesde() instanceof Date) {
					query.append(" AND trunc(t3.TRFECAUDIENCIA) >= trunc(?)");
					params.add(arbPagoArbitroADO.getFechaDesde());
				}
				if (arbPagoArbitroADO != null && arbPagoArbitroADO.getFechaHasta() != null
						&& arbPagoArbitroADO.getFechaHasta() instanceof Date) {
					query.append(" AND trunc(t3.TRFECAUDIENCIA) <= trunc(?)");
					params.add(arbPagoArbitroADO.getFechaHasta());
				}

				query.append(" ) ");
			} else if ("L".equals(arbPagoArbitroADO.getIncluir())) {
				// safelaud is null
				query.append(" AND t1.SAFELAUD IS NOT NULL ");
			}
		}

		if ("E".equals(arbPagoArbitroADO.getEstado()) && "L".equals(arbPagoArbitroADO.getIncluir())) {
			if (arbPagoArbitroADO != null && arbPagoArbitroADO.getFechaDesde() != null
					&& arbPagoArbitroADO.getFechaDesde() instanceof Date) {
				query.append(" AND trunc(t1.SAFELAUD) >= trunc(?)");
				params.add(arbPagoArbitroADO.getFechaDesde());
			}
			if (arbPagoArbitroADO != null && arbPagoArbitroADO.getFechaHasta() != null
					&& arbPagoArbitroADO.getFechaHasta() instanceof Date) {
				query.append(" AND trunc(t1.SAFELAUD) <= trunc(?)");
				params.add(arbPagoArbitroADO.getFechaHasta());
			}
		}

		if ("R".equals(arbPagoArbitroADO.getEstado()) || "Y".equals(arbPagoArbitroADO.getEstado())) {
			if (arbPagoArbitroADO != null && arbPagoArbitroADO.getFechaEnvioEIKADesde() != null
					&& arbPagoArbitroADO.getFechaEnvioEIKADesde() instanceof Date) {
				query.append(" AND trunc(p1.PAFECALTA) >= trunc(?)");
				params.add(arbPagoArbitroADO.getFechaEnvioEIKADesde());
			}
			if (arbPagoArbitroADO != null && arbPagoArbitroADO.getFechaEnvioEIKAHasta() != null
					&& arbPagoArbitroADO.getFechaEnvioEIKAHasta() instanceof Date) {
				query.append(" AND trunc(p1.PAFECALTA) <= trunc(?)");
				params.add(arbPagoArbitroADO.getFechaEnvioEIKAHasta());
			}
		}

		//// NORMALES/////
		query.append(" UNION ");
		//// PAGOS PERICIALES/////
		query.append(
				"SELECT t1.SACODIGO SACODIGO, t1.SACOJA SACOJA, t1.SANROR SANROR, t1.SANRAN SANRAN, t5.ARCODIGO ARCODIGO, "
						+ " t1.SAFELAUD SAFELAUD, t6.TRID TRIDPAGOLAUDO, t6.TRFEOPLA TRFEOPLA, t2.TRMOCODIGOEJ, t4.UANIF ARNIF, t4.UANOMBRE ARNOMBRE, ARTERCERO ARTERCERO, t6.TRCODIGO,");
		query.append(
				"    CASE WHEN t6.TRIMPORTE IS NULL AND t6.TRCODIGO ='K119' THEN (select valor/100 AS VALOR from PARAMETROS WHERE PARAMETRO='"
						+ Y41bADOConstantes.NAME_ADO_IMPORTE_PAGPERCOLEGIO
						+ "')  ELSE t6.TRIMPORTE END AS TRIMPORTE, ");
		query.append("p1.PAFECCONT PAFECCONT, p1.PAFECULTCON PAFECULTCON, p1.PADOCFI PADOCFI, p1.PANUMEXP PANUMEXP, ");
		query.append(" t1.SACOJA || '" + Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP + "' || t1.SANROR || '"
				+ Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP + "' || t1.SANRAN CODCOMPLETO, t4.UAIDINTERV UAIDINTERV ");
		query.append(
				" FROM SOLARB t1 INNER JOIN ARBTRAMEXP t2 ON  t1.SACODIGO=t2.TREXCODIGO INNER JOIN INTERVINIENTES_TRAMITE t3 ON t2.TRID=t3.Z4TRID INNER JOIN ARBINTERV t4 ON t3.Z4IDINTERVINIENTE=t4.UAIDINTERV LEFT JOIN ARBITRO t5 ON t4.UANIF=t5.ARNIF ");
		query.append(
				"INNER JOIN ( SELECT TRID, TREXCODIGO, TRCODIGO, TRIMPORTE, TRFEOPLA, filaPagoPericialCol FROM ( SELECT TRID, TREXCODIGO, TRCODIGO, TRIMPORTE, TRFEOPLA, ROW_NUMBER() OVER (PARTITION BY TREXCODIGO ORDER BY TRFECFIN DESC) filaPagoPericialCol FROM ARBTRAMEXP WHERE TRCODIGO = ? AND TRESTADO = ? ");
		params.add(Y41bConstantes.TRAMITE_ARBITRAJE_PAGO_PERICIAL_COLEGIO);
		params.add(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		if ("R".equals(arbPagoArbitroADO.getEstado())) {
			// pendientes de respuesta eika. valor null en la columna respuesta
			// a eika(PAFECCONT)
			// query.append(" AND p1.PAFECCONT IS NULL ");
		} else if ("Y".equals(arbPagoArbitroADO.getEstado())) {
			// enviados y respondidos . valor NOT null en la columna enviado a
			// eika y respuesta eika
			// query.append(" AND p1.PAFECCONT IS NOT NULL");
		} else {
			// estado pendiente de enviar a eika
			// que no tenga registro en xl
			// query.append(
			// " AND NOT EXISTS (SELECT 1 FROM L21.L21XLT00 WHERE t1.SACODIGO =
			// p1.PASACODIGO AND ta1.ARCODIGO = p1.PAARCODIGO AND t2.TRID =
			// p1.PATRID) ");
			// el pago est pendiente de enviar.
			query.append(" AND TRFICHADO IS NULL ");
		}

		query.append(")");

		query.append("WHERE filaPagoPericialCol=1) t6 ON t2.TREXCODIGO=t6.TREXCODIGO");
		query.append(
				" LEFT JOIN L21.L21XLT00 p1 ON     t1.SACODIGO = p1.PASACODIGO AND t5.ARCODIGO = p1.PAARCODIGO AND t2.TRID = p1.PATRID");

		query.append(" WHERE   ");
		query.append(" t2.TRCODIGO= ? ");
		params.add(Y41bConstantes.TRAMITE_ARBITRAJE_CITACION_A_PRUEBA);
		query.append(" AND t2.TRESTADO= ? ");
		params.add(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		if ("R".equals(arbPagoArbitroADO.getEstado())) {
			// pendientes de respuesta eika. valor null en la columna respuesta
			// a eika(PAFECCONT)
			query.append(" AND p1.PAFECCONT IS NULL AND p1.PANUMEXP IS NOT NULL ");
		} else if ("Y".equals(arbPagoArbitroADO.getEstado())) {
			// enviados y respondidos . valor NOT null en la columna respuesta
			// eika
			query.append(" AND p1.PAFECCONT IS NOT NULL");
		} else {
			// estado pendiente de enviar a eika
			// que no tenga registro en xl
			query.append(
					" AND NOT EXISTS (SELECT 1 FROM L21.L21XLT00 WHERE t1.SACODIGO = p1.PASACODIGO AND t5.ARCODIGO = p1.PAARCODIGO AND t2.TRID = p1.PATRID) ");
			// el pago est pendiente de enviar.
			// query.append(" AND t2.TRFICHADO IS NULL ");
		}

		if ("E".equals(arbPagoArbitroADO.getEstado())) {
			if ("A".equals(arbPagoArbitroADO.getIncluir())) {
				// la parte de arriba del safelaud
				query.append(
						" AND EXISTS (SELECT 1 FROM ARBTRAMEXP t3 where t1.SACODIGO=t3.TREXCODIGO AND t3.TRCODIGO=? AND t3.TRESTADO=? AND t3.TRFECAUDIENCIA IS NOT NULL  ");
				params.add(Y41bConstantes.TRAMITE_ARBITRAJE_AUDIENCIA);
				params.add(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

				if (arbPagoArbitroADO != null && arbPagoArbitroADO.getFechaDesde() != null
						&& arbPagoArbitroADO.getFechaDesde() instanceof Date) {
					query.append(" AND trunc(t3.TRFECAUDIENCIA) >= trunc(?)");
					params.add(arbPagoArbitroADO.getFechaDesde());
				}
				if (arbPagoArbitroADO != null && arbPagoArbitroADO.getFechaHasta() != null
						&& arbPagoArbitroADO.getFechaHasta() instanceof Date) {
					query.append(" AND trunc(t3.TRFECAUDIENCIA) <= trunc(?)");
					params.add(arbPagoArbitroADO.getFechaHasta());
				}

				query.append(" ) ");
			} else if ("L".equals(arbPagoArbitroADO.getIncluir())) {
				// safelaud is null
				query.append(" AND t1.SAFELAUD IS NOT NULL ");
			}
		}

		if ("E".equals(arbPagoArbitroADO.getEstado()) && "L".equals(arbPagoArbitroADO.getIncluir())) {
			if (arbPagoArbitroADO != null && arbPagoArbitroADO.getFechaDesde() != null
					&& arbPagoArbitroADO.getFechaDesde() instanceof Date) {
				query.append(" AND trunc(t1.SAFELAUD) >= trunc(?)");
				params.add(arbPagoArbitroADO.getFechaDesde());
			}
			if (arbPagoArbitroADO != null && arbPagoArbitroADO.getFechaHasta() != null
					&& arbPagoArbitroADO.getFechaHasta() instanceof Date) {
				query.append(" AND trunc(t1.SAFELAUD) <= trunc(?)");
				params.add(arbPagoArbitroADO.getFechaHasta());
			}
		}

		if ("R".equals(arbPagoArbitroADO.getEstado()) || "Y".equals(arbPagoArbitroADO.getEstado())) {
			if (arbPagoArbitroADO != null && arbPagoArbitroADO.getFechaEnvioEIKADesde() != null
					&& arbPagoArbitroADO.getFechaEnvioEIKADesde() instanceof Date) {
				query.append(" AND trunc(p1.PAFECALTA) >= trunc(?)");
				params.add(arbPagoArbitroADO.getFechaEnvioEIKADesde());
			}
			if (arbPagoArbitroADO != null && arbPagoArbitroADO.getFechaEnvioEIKAHasta() != null
					&& arbPagoArbitroADO.getFechaEnvioEIKAHasta() instanceof Date) {
				query.append(" AND trunc(p1.PAFECALTA) <= trunc(?)");
				params.add(arbPagoArbitroADO.getFechaEnvioEIKAHasta());
			}
		}
		//// PAGOS PERICIALES/////
		query.append("  ) ");

		// para busquedas
		if (null != arbPagoArbitroADO.getSacodigo()) {
			query.append(" where SACODIGO = ? ");
			params.add(arbPagoArbitroADO.getSacodigo());
		}

		if (null != arbPagoArbitroADO.getTridpagolaudo()) {
			query.append(" AND TRIDPAGOLAUDO = ? ");
			params.add(arbPagoArbitroADO.getTridpagolaudo());
		}

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuilder(PaginationManager.getQueryLimits(pagination, query.toString()));
		}

		List<ArbPagoArbitroADO> listaArbitrajes = (List<ArbPagoArbitroADO>) this.jdbcTemplate.query(query.toString(),
				this.rwMapListadoADO, params.toArray());
		return listaArbitrajes;
	}

	/**
	 * 
	 * findAllLikeListaADO
	 * 
	 * @param filterListado
	 *            ArbListaADO
	 * 
	 * @param pagination
	 *            Pagination
	 * 
	 * @param b
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findlistaADOCount(ArbPagoArbitroADO arbPagoArbitroADO, Boolean startsWith) {
		StringBuilder query = new StringBuilder("");
		List<Object> params = new ArrayList<Object>();

		query.append("SELECT count(*) from ( ");
		query.append("SELECT * FROM (");

		///// NORMALES/////
		query.append(
				"SELECT t1.SACODIGO SACODIGO, t1.SACOJA SACOJA, t1.SANROR SANROR, t1.SANRAN SANRAN, ta1.ARCODIGO ARCODIGO, t1.SAFELAUD SAFELAUD, t2.TRID TRIDPAGOLAUDO, t2.TRFEOPLA TRFEOPLA, t2.TRMOCODIGOEJ, ta1.ARNIF ARNIF, ta1.ARNOMBRE ARNOMBRE, ta1.ARTERCERO ARTERCERO, t2.TRCODIGO, ");
		query.append(
				"CASE WHEN t2.TRIMPORTE IS NULL AND t2.TRCODIGO ='K71' THEN (select valor/100 AS VALOR from PARAMETROS WHERE PARAMETRO='"
						+ Y41bADOConstantes.NAME_ADO_IMPORTE + "')  ELSE t2.TRIMPORTE END AS TRIMPORTE, ");
		query.append("p1.PAFECCONT PAFECCONT, p1.PAFECULTCON PAFECULTCON, p1.PADOCFI PADOCFI, ");
		query.append(" t1.SACOJA || '" + Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP + "' || t1.SANROR || '"
				+ Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP + "' || t1.SANRAN CODCOMPLETO, NULL as UAIDINTERV ");
		query.append(" FROM SOLARB t1 INNER JOIN ARBTRAMEXP t2 ON t2.TREXCODIGO=t1.SACODIGO ");
		query.append(
				"LEFT JOIN ( SELECT TREXCODIGO, SACOARPT, SACOARTT, SACOARDT FROM ( SELECT TREXCODIGO, CASE WHEN XJACTIVOPSUP='S' THEN SACOARPS ELSE SACOARPT END SACOARPT, CASE WHEN XJACTIVOAACCSUP='S' THEN SACOARTS ELSE SACOARTT END SACOARTT, CASE WHEN XJACTIVOOOEESUP='S' THEN SACOARDS ELSE SACOARDT END SACOARDT FROM SOLARB, ARBTRAMEXP, ARBCOLEGIO WHERE SACODIGO=TREXCODIGO AND TRID = XJTRID AND TRCODIGO = ? AND TRESTADO = ?) ) t3 ON t1.SACODIGO = t3.TREXCODIGO ");
		params.add(Y41bConstantes.TRAMITE_ARBITRAJE_DESIGNACION_COLEGIO);
		params.add(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		query.append(
				"LEFT JOIN ARBITRO ta1 ON ( t3.SACOARPT=ta1.ARCODIGO OR t3.SACOARTT=ta1.ARCODIGO OR t3.SACOARDT=ta1.ARCODIGO) ");
		query.append(
				"LEFT JOIN  L21.L21XLT00 p1 ON t1.SACODIGO = p1.PASACODIGO AND ta1.ARCODIGO = p1.PAARCODIGO AND t2.TRID = p1.PATRID ");

		query.append(" WHERE   ");
		query.append("  t2.TRCODIGO= ?");
		params.add(Y41bConstantes.TRAMITE_ARBITRAJE_PAGO_LAUDO);
		query.append(" AND t2.TRESTADO= ?");
		params.add(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		if ("R".equals(arbPagoArbitroADO.getEstado())) {
			// pendientes de respuesta eika. valor null en la columna respuesta
			// a eika(PAFECCONT)
			query.append(" AND p1.PAFECCONT IS NULL AND p1.PANUMEXP IS NOT NULL ");
		} else if ("Y".equals(arbPagoArbitroADO.getEstado())) {
			// enviados y respondidos . valor NOT null en la columna respuesta
			// eika
			query.append(" AND p1.PAFECCONT IS NOT NULL");
		} else {
			// estado pendiente de enviar a eika
			// que no tenga registro en xl
			query.append(
					" AND NOT EXISTS (SELECT 1 FROM L21.L21XLT00 WHERE t1.SACODIGO = p1.PASACODIGO AND ta1.ARCODIGO = p1.PAARCODIGO AND t2.TRID = p1.PATRID) ");
			// el pago est pendiente de enviar.
			query.append(" AND t2.TRFICHADO IS NULL ");
		}

		if ("E".equals(arbPagoArbitroADO.getEstado())) {
			if ("A".equals(arbPagoArbitroADO.getIncluir())) {
				// la parte de arriba del safelaud
				query.append(
						" AND EXISTS (SELECT 1 FROM ARBTRAMEXP t3 where t1.SACODIGO=t3.TREXCODIGO AND t3.TRCODIGO=? AND t3.TRESTADO=? AND t3.TRFECAUDIENCIA IS NOT NULL  ");
				params.add(Y41bConstantes.TRAMITE_ARBITRAJE_AUDIENCIA);
				params.add(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

				if (arbPagoArbitroADO != null && arbPagoArbitroADO.getFechaDesde() != null
						&& arbPagoArbitroADO.getFechaDesde() instanceof Date) {
					query.append(" AND trunc(t3.TRFECAUDIENCIA) >= trunc(?)");
					params.add(arbPagoArbitroADO.getFechaDesde());
				}
				if (arbPagoArbitroADO != null && arbPagoArbitroADO.getFechaHasta() != null
						&& arbPagoArbitroADO.getFechaHasta() instanceof Date) {
					query.append(" AND trunc(t3.TRFECAUDIENCIA) <= trunc(?)");
					params.add(arbPagoArbitroADO.getFechaHasta());
				}

				query.append(" ) ");
			} else if ("L".equals(arbPagoArbitroADO.getIncluir())) {
				// safelaud is null
				query.append(" AND t1.SAFELAUD IS NOT NULL ");
			}
		}

		if ("E".equals(arbPagoArbitroADO.getEstado()) && "L".equals(arbPagoArbitroADO.getIncluir())) {
			if (arbPagoArbitroADO != null && arbPagoArbitroADO.getFechaDesde() != null
					&& arbPagoArbitroADO.getFechaDesde() instanceof Date) {
				query.append(" AND trunc(t1.SAFELAUD) >= trunc(?)");
				params.add(arbPagoArbitroADO.getFechaDesde());
			}
			if (arbPagoArbitroADO != null && arbPagoArbitroADO.getFechaHasta() != null
					&& arbPagoArbitroADO.getFechaHasta() instanceof Date) {
				query.append(" AND trunc(t1.SAFELAUD) <= trunc(?)");
				params.add(arbPagoArbitroADO.getFechaHasta());
			}
		}

		if ("R".equals(arbPagoArbitroADO.getEstado()) || "Y".equals(arbPagoArbitroADO.getEstado())) {
			if (arbPagoArbitroADO != null && arbPagoArbitroADO.getFechaEnvioEIKADesde() != null
					&& arbPagoArbitroADO.getFechaEnvioEIKADesde() instanceof Date) {
				query.append(" AND trunc(p1.PAFECALTA) >= trunc(?)");
				params.add(arbPagoArbitroADO.getFechaEnvioEIKADesde());
			}
			if (arbPagoArbitroADO != null && arbPagoArbitroADO.getFechaEnvioEIKAHasta() != null
					&& arbPagoArbitroADO.getFechaEnvioEIKAHasta() instanceof Date) {
				query.append(" AND trunc(p1.PAFECALTA) <= trunc(?)");
				params.add(arbPagoArbitroADO.getFechaEnvioEIKAHasta());
			}
		}

		//// NORMALES/////
		query.append(" UNION ");
		//// PAGOS PERICIALES/////
		query.append(
				"SELECT t1.SACODIGO SACODIGO, t1.SACOJA SACOJA, t1.SANROR SANROR, t1.SANRAN SANRAN, t5.ARCODIGO ARCODIGO, "
						+ " t1.SAFELAUD SAFELAUD, t6.TRID TRIDPAGOLAUDO, t6.TRFEOPLA TRFEOPLA, t2.TRMOCODIGOEJ, t4.UANIF ARNIF, t4.UANOMBRE ARNOMBRE, ARTERCERO ARTERCERO, t6.TRCODIGO,");
		query.append(
				"    CASE WHEN t6.TRIMPORTE IS NULL AND t6.TRCODIGO ='K119' THEN (select valor/100 AS VALOR from PARAMETROS WHERE PARAMETRO='"
						+ Y41bADOConstantes.NAME_ADO_IMPORTE_PAGPERCOLEGIO
						+ "')  ELSE t6.TRIMPORTE END AS TRIMPORTE, ");
		query.append("p1.PAFECCONT PAFECCONT, p1.PAFECULTCON PAFECULTCON, p1.PADOCFI PADOCFI, ");
		query.append(" t1.SACOJA || '" + Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP + "' || t1.SANROR || '"
				+ Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP + "' || t1.SANRAN CODCOMPLETO, t4.UAIDINTERV UAIDINTERV ");
		query.append(
				" FROM SOLARB t1 INNER JOIN ARBTRAMEXP t2 ON  t1.SACODIGO=t2.TREXCODIGO INNER JOIN INTERVINIENTES_TRAMITE t3 ON t2.TRID=t3.Z4TRID INNER JOIN ARBINTERV t4 ON t3.Z4IDINTERVINIENTE=t4.UAIDINTERV LEFT JOIN ARBITRO t5 ON t4.UANIF=t5.ARNIF ");
		query.append(
				"INNER JOIN ( SELECT TRID, TREXCODIGO, TRCODIGO, TRIMPORTE, TRFEOPLA, filaPagoPericialCol FROM ( SELECT TRID, TREXCODIGO, TRCODIGO, TRIMPORTE, TRFEOPLA, ROW_NUMBER() OVER (PARTITION BY TREXCODIGO ORDER BY TRFECFIN DESC) filaPagoPericialCol FROM ARBTRAMEXP WHERE TRCODIGO = ? AND TRESTADO = ? ");
		params.add(Y41bConstantes.TRAMITE_ARBITRAJE_PAGO_PERICIAL_COLEGIO);
		params.add(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		if ("R".equals(arbPagoArbitroADO.getEstado())) {
			// pendientes de respuesta eika. valor null en la columna respuesta
			// a eika(PAFECCONT)
			// query.append(" AND p1.PAFECCONT IS NULL ");
		} else if ("Y".equals(arbPagoArbitroADO.getEstado())) {
			// enviados y respondidos . valor NOT null en la columna enviado a
			// eika y respuesta eika
			// query.append(" AND p1.PAFECCONT IS NOT NULL");
		} else {
			// estado pendiente de enviar a eika
			// que no tenga registro en xl
			// query.append(
			// " AND NOT EXISTS (SELECT 1 FROM L21.L21XLT00 WHERE t1.SACODIGO =
			// p1.PASACODIGO AND ta1.ARCODIGO = p1.PAARCODIGO AND t2.TRID =
			// p1.PATRID) ");
			// el pago est pendiente de enviar.
			query.append(" AND TRFICHADO IS NULL ");
		}

		query.append(")");

		query.append("WHERE filaPagoPericialCol=1) t6 ON t2.TREXCODIGO=t6.TREXCODIGO");
		query.append(
				" LEFT JOIN L21.L21XLT00 p1 ON     t1.SACODIGO = p1.PASACODIGO AND t5.ARCODIGO = p1.PAARCODIGO AND t2.TRID = p1.PATRID");

		query.append(" WHERE   ");
		query.append(" t2.TRCODIGO= ? ");
		params.add(Y41bConstantes.TRAMITE_ARBITRAJE_CITACION_A_PRUEBA);
		query.append(" AND t2.TRESTADO= ? ");
		params.add(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		if ("R".equals(arbPagoArbitroADO.getEstado())) {
			// pendientes de respuesta eika. valor null en la columna respuesta
			// a eika(PAFECCONT)
			query.append(" AND p1.PAFECCONT IS NULL AND p1.PANUMEXP IS NOT NULL ");
		} else if ("Y".equals(arbPagoArbitroADO.getEstado())) {
			// enviados y respondidos . valor NOT null en la columna respuesta
			// eika
			query.append(" AND p1.PAFECCONT IS NOT NULL");
		} else {
			// estado pendiente de enviar a eika
			// que no tenga registro en xl
			query.append(
					" AND NOT EXISTS (SELECT 1 FROM L21.L21XLT00 WHERE t1.SACODIGO = p1.PASACODIGO AND t5.ARCODIGO = p1.PAARCODIGO AND t2.TRID = p1.PATRID) ");
			// el pago est pendiente de enviar.
			// query.append(" AND t2.TRFICHADO IS NULL ");
		}

		if ("E".equals(arbPagoArbitroADO.getEstado())) {
			if ("A".equals(arbPagoArbitroADO.getIncluir())) {
				// la parte de arriba del safelaud
				query.append(
						" AND EXISTS (SELECT 1 FROM ARBTRAMEXP t3 where t1.SACODIGO=t3.TREXCODIGO AND t3.TRCODIGO=? AND t3.TRESTADO=? AND t3.TRFECAUDIENCIA IS NOT NULL  ");
				params.add(Y41bConstantes.TRAMITE_ARBITRAJE_AUDIENCIA);
				params.add(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

				if (arbPagoArbitroADO != null && arbPagoArbitroADO.getFechaDesde() != null
						&& arbPagoArbitroADO.getFechaDesde() instanceof Date) {
					query.append(" AND trunc(t3.TRFECAUDIENCIA) >= trunc(?)");
					params.add(arbPagoArbitroADO.getFechaDesde());
				}
				if (arbPagoArbitroADO != null && arbPagoArbitroADO.getFechaHasta() != null
						&& arbPagoArbitroADO.getFechaHasta() instanceof Date) {
					query.append(" AND trunc(t3.TRFECAUDIENCIA) <= trunc(?)");
					params.add(arbPagoArbitroADO.getFechaHasta());
				}

				query.append(" ) ");
			} else if ("L".equals(arbPagoArbitroADO.getIncluir())) {
				// safelaud is null
				query.append(" AND t1.SAFELAUD IS NOT NULL ");
			}
		}

		if ("E".equals(arbPagoArbitroADO.getEstado()) && "L".equals(arbPagoArbitroADO.getIncluir())) {
			if (arbPagoArbitroADO != null && arbPagoArbitroADO.getFechaDesde() != null
					&& arbPagoArbitroADO.getFechaDesde() instanceof Date) {
				query.append(" AND trunc(t1.SAFELAUD) >= trunc(?)");
				params.add(arbPagoArbitroADO.getFechaDesde());
			}
			if (arbPagoArbitroADO != null && arbPagoArbitroADO.getFechaHasta() != null
					&& arbPagoArbitroADO.getFechaHasta() instanceof Date) {
				query.append(" AND trunc(t1.SAFELAUD) <= trunc(?)");
				params.add(arbPagoArbitroADO.getFechaHasta());
			}
		}

		if ("R".equals(arbPagoArbitroADO.getEstado()) || "Y".equals(arbPagoArbitroADO.getEstado())) {
			if (arbPagoArbitroADO != null && arbPagoArbitroADO.getFechaEnvioEIKADesde() != null
					&& arbPagoArbitroADO.getFechaEnvioEIKADesde() instanceof Date) {
				query.append(" AND trunc(p1.PAFECALTA) >= trunc(?)");
				params.add(arbPagoArbitroADO.getFechaEnvioEIKADesde());
			}
			if (arbPagoArbitroADO != null && arbPagoArbitroADO.getFechaEnvioEIKAHasta() != null
					&& arbPagoArbitroADO.getFechaEnvioEIKAHasta() instanceof Date) {
				query.append(" AND trunc(p1.PAFECALTA) <= trunc(?)");
				params.add(arbPagoArbitroADO.getFechaEnvioEIKAHasta());
			}
		}
		//// PAGOS PERICIALES/////
		query.append("  ) ");

		// para busquedas
		if (null != arbPagoArbitroADO.getSacodigo()) {
			query.append(" where SACODIGO = ? ");
			params.add(arbPagoArbitroADO.getSacodigo());
		}

		if (null != arbPagoArbitroADO.getTridpagolaudo()) {
			query.append(" AND TRIDPAGOLAUDO = ? ");
			params.add(arbPagoArbitroADO.getTridpagolaudo());
		}

		query.append("  ) ");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	private RowMapper<ArbPagoArbitroADO> rwMapListadoADO = new RowMapper<ArbPagoArbitroADO>() {
		public ArbPagoArbitroADO mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			ArbPagoArbitroADO retorno = new ArbPagoArbitroADO();

			retorno.setTrcodigo(resultSet.getString("TRCODIGO"));
			retorno.setSacodigo(resultSet.getString("SACODIGO"));
			retorno.setSacoja(resultSet.getString("SACOJA"));
			retorno.setSanror(resultSet.getBigDecimal("SANROR"));
			retorno.setSanran(resultSet.getBigDecimal("SANRAN"));
			retorno.setSafelaud(resultSet.getDate("SAFELAUD"));

			retorno.setTridpagolaudo(resultSet.getString("TRIDPAGOLAUDO"));
			retorno.setTrfeopla(resultSet.getDate("TRFEOPLA"));
			retorno.setTrmocodigoEj(resultSet.getString("TRMOCODIGOEJ"));

			retorno.setTrimporte(resultSet.getString("TRIMPORTE"));
			// retorno.setSacoarpt(resultSet.getString("SACOARPT"));
			// retorno.setSacoartt(resultSet.getString("SACOARTT"));
			// retorno.setSacoardt(resultSet.getString("SACOARDT"));

			retorno.setArnif(resultSet.getString("ARNIF"));
			retorno.setArnombre(resultSet.getString("ARNOMBRE"));
			retorno.setArtercero(resultSet.getString("ARTERCERO"));
			retorno.setArcodigo(resultSet.getString("ARCODIGO"));

			retorno.setPanumexp(resultSet.getString("PANUMEXP"));
			retorno.setPafeccont(resultSet.getDate("PAFECCONT"));
			retorno.setPafeculton(resultSet.getDate("PAFECULTCON"));
			retorno.setPadocfi(resultSet.getString("PADOCFI"));

			retorno.setCodCompleto(resultSet.getString("CODCOMPLETO"));

			retorno.setUaidinterv(resultSet.getString("UAIDINTERV"));

			return retorno;
		}
	};

	/**
	 * Inserts a single row in the Solarb table.
	 * 
	 * @param solarb
	 *            Pagination
	 * @return Solarb
	 */
	public Pagosarbitros insertPagoArbitro(Pagosarbitros pagosarbitros) {
		String query = "INSERT INTO L21.L21XLT00 ( PASACODIGO, PAARCODIGO, PATRID, PANUMEXP, PAFECCONT, PAFECULTCON, PADOCFI ) VALUES ( ?, ? , ?, ?, ?, ? , ?)";

		this.jdbcTemplate.update(query, pagosarbitros.getPasacodigo(), pagosarbitros.getPaarcodigo(),
				pagosarbitros.getPatrid(), pagosarbitros.getPanumexp(), pagosarbitros.getPafeccont(),
				pagosarbitros.getPafecultcon(), pagosarbitros.getPadocfi());
		return pagosarbitros;
	}

	/**
	 * Counts rows in the PagoArbitro table.
	 * 
	 * @param arbPagoArbitroADO
	 *            ArbPagoArbitroADO
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long existePagoArbitro(ArbPagoArbitroADO arbPagoArbitroADO) {

		List<Object> params = new ArrayList<Object>();
		StringBuilder query = new StringBuilder(
				"select count(1) from L21.L21XLT00 where PASACODIGO= ?  AND PAARCODIGO = ? AND PATRID = ? ");
		params.add(arbPagoArbitroADO.getSacodigo());
		params.add(arbPagoArbitroADO.getArcodigo());
		params.add(arbPagoArbitroADO.getTridpagolaudo());

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

}
