package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.ArbFicheroADO;
import com.ejie.y41b.model.ArbPagoArbitroADO;
import com.ejie.y41b.model.Arbitro;
import com.ejie.y41b.model.FiltroArbitraje;
import com.ejie.y41b.model.Pagosarbitros;
import com.ejie.y41b.model.Solarb;
import com.ejie.y41b.model.SolarbKgest;

/**
 * SolarbDao  
 * 
 *  
 */

public interface SolarbDao {

	/**
	 * Inserts a single row in the Solarb table.
	 * 
	 * @param solarb
	 *            Solarb
	 * @return Solarb
	 */
	Solarb add(Solarb solarb);

	/**
	 * Updates a single row in the Solarb table.
	 * 
	 * @param solarb
	 *            Solarb
	 * @return Solarb
	 */
	Solarb update(Solarb solarb);

	/**
	 * Finds a single row in the Solarb table.
	 * 
	 * @param solarb
	 *            Solarb
	 * @return Solarb
	 */
	Solarb find(Solarb solarb);

	/**
	 * Deletes a single row in the Solarb table.
	 * 
	 * @param solarb
	 *            Solarb
	 * @return
	 */
	void remove(Solarb solarb);

	/**
	 * Finds a List of rows in the Solarb table.
	 * 
	 * @param solarb
	 *            Solarb
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Solarb> findAll(Solarb solarb, Pagination pagination);

	/**
	 * Counts rows in the Solarb table.
	 * 
	 * @param solarb
	 *            Solarb
	 * @return Long
	 * @throws Exception
	 */
	Long findAllCount(Solarb solarb);

	/**
	 * Finds rows in the Solarb table using like.
	 * 
	 * @param solarb
	 *            Solarb
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Solarb> findAllLike(Solarb solarb, Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Solarb table using like.
	 * 
	 * @param solarb
	 *            Solarb
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Solarb solarb, Boolean startsWith);

	/**
	 * 
	 * @param filtroArbitraje
	 *            FiltroArbitraje
	 * @param sacodigo
	 *            String
	 * @param relacionados
	 *            String
	 * @param pagination
	 *            Pagination
	 * @return List<FiltroArbitraje>
	 */
	List<FiltroArbitraje> findAllArbitrajeRelacionar(FiltroArbitraje filtroArbitraje, String sacodigo,
			String relacionados, Pagination pagination);

	/**
	 * 
	 * @param filtroArbitraje
	 *            FiltroArbitraje
	 * @param sacodigo
	 *            String
	 * @param relacionados
	 *            String
	 * @return Long
	 */
	Long findAllCountArbitrajeRelacionar(FiltroArbitraje filtroArbitraje, String sacodigo, String relacionados);

	/**
	 * @return long
	 */
	long getNewEsperaPK();

	/**
	 * @param arbitro
	 *            Arbitro
	 * @return Arbitro
	 */
	Arbitro obtenerCargaArbitro(Arbitro arbitro);

	/**
	 * findArbitrajeByNumeroExpediente
	 * 
	 * @param filterSolarb
	 *            Solarb
	 * @return Solarb
	 */
	Solarb findArbitrajeByNumeroExpediente(Solarb filterSolarb);

	/**
	 * findArbitrajeByNumeroRegistro
	 * 
	 * @param filterSolarb
	 *            Solarb
	 * @return Solarb
	 */
	Solarb findArbitrajeByNumeroRegistro(Solarb filterSolarb);

	/**
	 * Finds a single row in the SolarbKgest table.
	 * 
	 * @param solarb
	 *            SolarbKgest
	 * @return SolarbKgest
	 */
	SolarbKgest findKgest(SolarbKgest solarb);

	/**
	 * Counts rows in the FiltroSanciones table using like.
	 * 
	 * @param filtroArbitraje
	 *            FiltroArbitraje
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCountArbitrajes(FiltroArbitraje filtroArbitraje, Boolean startsWith);

	/**
	 * Finds rows in the FiltroArbitraje table using like.
	 * 
	 * @param filtroArbitraje
	 *            FiltroArbitraje
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<FiltroArbitraje> findAllLikeArbitrajes(FiltroArbitraje filtroArbitraje, Pagination pagination,
			Boolean startsWith);

	/**
	 * Finds SANROR
	 * 
	 * @param solarb
	 *            Pagination
	 * @return long
	 */
	long findSanrorSig(Solarb solarb);

	/**
	 * Finds a single row in the SolarbKgest table.
	 * 
	 * @param arbFicheroADO
	 *            ArbFicheroADO
	 * @return SolarbKgest
	 */
	List<ArbFicheroADO> findFicheroADO(ArbFicheroADO arbFicheroADO);

	/**
	 * Metodo para recoger los pagos periciales a los arbitros seleccionados del
	 * colegio
	 * 
	 * @param arbFicheroADO
	 *            ArbFicheroADO
	 * @return SolarbKgest
	 */
	List<ArbFicheroADO> findFicheroADOPagoPericialColegio(ArbFicheroADO arbFicheroADO);

	/**
	 * Updates a single row in the Solarb table.
	 * 
	 * @param solarb
	 *            Solarb
	 */
	void updateEnvioPagoLaudo(Solarb solarb);

	/**
	 * Metodo para actualizar la fecha de orden pago pericial colegio
	 * 
	 * @param solarb
	 *            Solarb
	 */
	void updateEnvioPagoPericialColegio(Solarb solarb);

	/**
	 * Metodo para actualizar el tipo de arbitraje
	 * 
	 * @param solarb
	 *            Solarb
	 */
	public void updateTipoArbitraje(Solarb solarb);

	/**
	 * Find all like sanciones busqueda combinada count.
	 * 
	 * @param filtroArbitraje
	 *            the filtro arbitraje
	 * @param startsWith
	 *            the starts with
	 * @return the long
	 */
	public Long findAllLikeArbitrajesBusquedaCombinadaCount(FiltroArbitraje filtroArbitraje, Boolean startsWith);

	/**
	 * Find all like arbitraje combinada.
	 * 
	 * @param filtroArbitraje
	 *            the filtro arbitraje
	 * @param pagination
	 *            the pagination
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	public List<FiltroArbitraje> findAllLikeArbitrajesCombinada(FiltroArbitraje filtroArbitraje, Pagination pagination,
			Boolean startsWith);

	/**
	 * findlistaADO
	 * 
	 * @param arbPagoArbitroADO
	 *            ArbListaADO
	 * @param pagination
	 *            the pagination
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	public List<ArbPagoArbitroADO> findlistaADO(ArbPagoArbitroADO arbPagoArbitroADO, Pagination pagination,
			Boolean startsWith);

	/**
	 * Find all like sanciones busqueda combinada count.
	 * 
	 * @param arbPagoArbitroADO
	 *            ArbListaADO
	 * @param startsWith
	 *            the starts with
	 * @return the long
	 */
	public Long findlistaADOCount(ArbPagoArbitroADO arbPagoArbitroADO, Boolean startsWith);

	/**
	 * Inserts a single row in the Solarb table.
	 * 
	 * @param solarb
	 *            Pagination
	 * @return Solarb
	 */
	public Pagosarbitros insertPagoArbitro(Pagosarbitros pagosarbitros);

	Long existePagoArbitro(ArbPagoArbitroADO pagoArbitro);

}
