/**
 * 
 */
package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.SituacionY41BConCorreos;

/**
 *  
 * 
 */
@Repository
@Transactional
public class SituacionY41BConCorreosDaoImpl implements
		SituacionY41BConCorreosDao {
	private JdbcTemplate jdbcTemplate;

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	private RowMapper<SituacionY41BConCorreos> rwMap = new RowMapper<SituacionY41BConCorreos>() {
		public SituacionY41BConCorreos mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new SituacionY41BConCorreos(
					resultSet.getString("CODSITCORREOS"),
					resultSet.getString("EHACUSERECIBORECIBIDO"),
					resultSet.getString("SITCONPEE"),
					resultSet.getString("DESC_SIT_CORREOS_ES"),
					resultSet.getString("DESC_SIT_CORREOS_EU"));
		}
	};

	/**
	 * Finds a single row in the SituacionY41BConCorreos table.
	 * 
	 * @param situacionY41BConCorreos
	 *            SituacionY41BConCorreos
	 * @return SituacionY41BConCorreos
	 */
	@Override
	@Transactional(readOnly = true)
	public SituacionY41BConCorreos find(String codSitCorreos) {
		try {
			String query = "SELECT COD_SIT_CORREOS CODSITCORREOS, EHACUSERECIBORECIBIDO, SITCONPEE, DESC_SIT_CORREOS_ES,DESC_SIT_CORREOS_EU FROM SITUACION_Y41B_CON_CORREOS WHERE COD_SIT_CORREOS = ?";
			return (SituacionY41BConCorreos) this.jdbcTemplate.queryForObject(
					query, this.rwMap, codSitCorreos);
		} catch (EmptyResultDataAccessException e) {
			return new SituacionY41BConCorreos();
		} catch (Exception e) {
			return new SituacionY41BConCorreos();
		}
	}
}