package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Establecimiento;
import com.ejie.y41b.model.Sede;

/**
 * SedeDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class SedeDaoImpl implements SedeDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Sede> rwMap = new RowMapper<Sede>() {
		public Sede mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Sede(resultSet.getString("IDDATOSEDE"),
					resultSet.getString("ESCODIGO"),
					resultSet.getString("PCODIGO"),
					resultSet.getString("EXTRANJERO"),
					resultSet.getString("NORAPAISID"),
					resultSet.getString("NORAPAISNOMBRE"),
					resultSet.getString("NORAPROVINCIAID"),
					resultSet.getString("NOMBREPROVINCIA"),
					resultSet.getString("NORAMUNICIPIOID"),
					resultSet.getString("NOMBREMUNICIPIO"),
					resultSet.getString("NORALOCALIDADID"),
					resultSet.getString("NOMBRELOCALIDAD"),
					resultSet.getString("NORACALLEID"),
					resultSet.getString("NOMBRECALLE"),
					resultSet.getString("NORACPID"),
					resultSet.getString("NOMBRECP"),
					resultSet.getString("NORAPORTALID"),
					resultSet.getString("NOMBREPORTAL"),
					resultSet.getString("NOMBREPISO"),
					resultSet.getString("DIRECCIONNOCAPV"),
					resultSet.getString("EMAIL"),
					resultSet.getString("CONTACTO"),
					resultSet.getString("NRTEL1"),
					resultSet.getString("NRTEL2"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Sede table.
	 * 
	 * @param sede
	 *            Pagination
	 * @return Sede
	 */
	public Sede add(Sede sede) {
		String query = "INSERT INTO SEDE (ID_DATOSEDE, ESCODIGO, PCODIGO, EXTRANJERO, NORA_PAIS_ID, NORA_PAIS_NOMBRE, NORA_PROVINCIA_ID, NOMBRE_PROVINCIA, NORA_MUNICIPIO_ID, NOMBRE_MUNICIPIO, NORA_LOCALIDAD_ID, NOMBRE_LOCALIDAD, NORA_CALLE_ID, NOMBRE_CALLE, NORA_CP_ID, NOMBRE_CP, NORA_PORTAL_ID, NOMBRE_PORTAL, NOMBRE_PISO, DIRECCION_NOCAPV, EMAIL, CONTACTO, NRTEL1, NRTEL2) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, sede.getIdDatosede(),
				sede.getEscodigo(), sede.getPcodigo(), sede.getExtranjero(),
				sede.getNoraPaisId(), sede.getNoraPaisNombre(),
				sede.getNoraProvinciaId(), sede.getNombreProvincia(),
				sede.getNoraMunicipioId(), sede.getNombreMunicipio(),
				sede.getNoraLocalidadId(), sede.getNombreLocalidad(),
				sede.getNoraCalleId(), sede.getNombreCalle(),
				sede.getNoraCpId(), sede.getNombreCp(), sede.getNoraPortalId(),
				sede.getNombrePortal(), sede.getNombrePiso(),
				sede.getDireccionNocapv(), sede.getEmail(), sede.getContacto(),
				sede.getNrtel1(), sede.getNrtel2());
		return sede;
	}

	/**
	 * Updates a single row in the Sede table.
	 * 
	 * @param sede
	 *            Pagination
	 * @return Sede
	 */
	public Sede update(Sede sede) {
		String query = "UPDATE SEDE SET ESCODIGO=?, PCODIGO=?, EXTRANJERO=?, NORA_PAIS_ID=?, NORA_PAIS_NOMBRE=?, NORA_PROVINCIA_ID=?, NOMBRE_PROVINCIA=?, NORA_MUNICIPIO_ID=?, NOMBRE_MUNICIPIO=?, NORA_LOCALIDAD_ID=?, NOMBRE_LOCALIDAD=?, NORA_CALLE_ID=?, NOMBRE_CALLE=?, NORA_CP_ID=?, NOMBRE_CP=?, NORA_PORTAL_ID=?, NOMBRE_PORTAL=?, NOMBRE_PISO=?, DIRECCION_NOCAPV=?, EMAIL=?, CONTACTO=?, NRTEL1=?, NRTEL2=? WHERE ID_DATOSEDE=?";
		this.jdbcTemplate.update(query, sede.getEscodigo(), sede.getPcodigo(),
				sede.getExtranjero(), sede.getNoraPaisId(),
				sede.getNoraPaisNombre(), sede.getNoraProvinciaId(),
				sede.getNombreProvincia(), sede.getNoraMunicipioId(),
				sede.getNombreMunicipio(), sede.getNoraLocalidadId(),
				sede.getNombreLocalidad(), sede.getNoraCalleId(),
				sede.getNombreCalle(), sede.getNoraCpId(), sede.getNombreCp(),
				sede.getNoraPortalId(), sede.getNombrePortal(),
				sede.getNombrePiso(), sede.getDireccionNocapv(),
				sede.getEmail(), sede.getContacto(), sede.getNrtel1(),
				sede.getNrtel2(), sede.getIdDatosede());
		return sede;
	}

	/**
	 * Finds a single row in the Sede table.
	 * 
	 * @param sede
	 *            Pagination
	 * @return Sede
	 */
	@Transactional(readOnly = true)
	public Sede find(Sede sede) {
		String query = "SELECT t1.ID_DATOSEDE IDDATOSEDE, t1.ESCODIGO ESCODIGO, t1.PCODIGO PCODIGO, t1.EXTRANJERO EXTRANJERO, t1.NORA_PAIS_ID NORAPAISID, t1.NORA_PAIS_NOMBRE NORAPAISNOMBRE, t1.NORA_PROVINCIA_ID NORAPROVINCIAID, t1.NOMBRE_PROVINCIA NOMBREPROVINCIA, t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID, t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO, t1.NORA_LOCALIDAD_ID NORALOCALIDADID, t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD, t1.NORA_CALLE_ID NORACALLEID, t1.NOMBRE_CALLE NOMBRECALLE, t1.NORA_CP_ID NORACPID, t1.NOMBRE_CP NOMBRECP, t1.NORA_PORTAL_ID NORAPORTALID, t1.NOMBRE_PORTAL NOMBREPORTAL, t1.NOMBRE_PISO NOMBREPISO, t1.DIRECCION_NOCAPV DIRECCIONNOCAPV, t1.EMAIL EMAIL, t1.CONTACTO CONTACTO, t1.NRTEL1 NRTEL1, t1.NRTEL2 NRTEL2 FROM SEDE t1  WHERE t1.ID_DATOSEDE = ?  ";

		List<Sede> sedeList = this.jdbcTemplate.query(query, this.rwMap,
				sede.getIdDatosede());
		return (Sede) DataAccessUtils.uniqueResult(sedeList);
	}

	/**
	 * Removes a single row in the Sede table.
	 * 
	 * @param sede
	 *            Pagination
	 * @return
	 */
	public void remove(Sede sede) {
		String query = "DELETE FROM SEDE WHERE ID_DATOSEDE=?";
		this.jdbcTemplate.update(query, sede.getIdDatosede());
	}

	/**
	 * Removes a single row in the Sede table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return
	 */
	public void removeAllSedes(Establecimiento establecimiento) {
		String query = "DELETE FROM SEDE WHERE ESCODIGO=?";
		this.jdbcTemplate.update(query, establecimiento.getEscodigo());
	}

	/**
	 * Finds a List of rows in the Sede table.
	 * 
	 * @param sede
	 *            Sede
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Sede> findAll(Sede sede, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_DATOSEDE IDDATOSEDE,t1.ESCODIGO ESCODIGO,t1.PCODIGO PCODIGO,t1.EXTRANJERO EXTRANJERO,t1.NORA_PAIS_ID NORAPAISID,t1.NORA_PAIS_NOMBRE NORAPAISNOMBRE,t1.NORA_PROVINCIA_ID NORAPROVINCIAID,t1.NOMBRE_PROVINCIA NOMBREPROVINCIA,t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID,t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO,t1.NORA_LOCALIDAD_ID NORALOCALIDADID,t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD,t1.NORA_CALLE_ID NORACALLEID,t1.NOMBRE_CALLE NOMBRECALLE,t1.NORA_CP_ID NORACPID,t1.NOMBRE_CP NOMBRECP,t1.NORA_PORTAL_ID NORAPORTALID,t1.NOMBRE_PORTAL NOMBREPORTAL,t1.NOMBRE_PISO NOMBREPISO,t1.DIRECCION_NOCAPV DIRECCIONNOCAPV,t1.EMAIL EMAIL,t1.CONTACTO CONTACTO,t1.NRTEL1 NRTEL1,t1.NRTEL2 NRTEL2 ");
		query.append("FROM SEDE t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(sede);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Sede>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Sede table.
	 * 
	 * @param sede
	 *            Sede
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Sede sede) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM SEDE t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(sede);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Sede table using like.
	 * 
	 * @param sede
	 *            Sede
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Sede> findAllLike(Sede sede, Pagination pagination,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_DATOSEDE IDDATOSEDE,t1.ESCODIGO ESCODIGO,t1.PCODIGO PCODIGO,t1.EXTRANJERO EXTRANJERO,t1.NORA_PAIS_ID NORAPAISID,t1.NORA_PAIS_NOMBRE NORAPAISNOMBRE,t1.NORA_PROVINCIA_ID NORAPROVINCIAID,t1.NOMBRE_PROVINCIA NOMBREPROVINCIA,t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID,t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO,t1.NORA_LOCALIDAD_ID NORALOCALIDADID,t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD,t1.NORA_CALLE_ID NORACALLEID,t1.NOMBRE_CALLE NOMBRECALLE,t1.NORA_CP_ID NORACPID,t1.NOMBRE_CP NOMBRECP,t1.NORA_PORTAL_ID NORAPORTALID,t1.NOMBRE_PORTAL NOMBREPORTAL,t1.NOMBRE_PISO NOMBREPISO,t1.DIRECCION_NOCAPV DIRECCIONNOCAPV,t1.EMAIL EMAIL,t1.CONTACTO CONTACTO,t1.NRTEL1 NRTEL1,t1.NRTEL2 NRTEL2 ");
		query.append("FROM SEDE t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(sede, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Sede>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Sede table using like.
	 * 
	 * @param sede
	 *            Sede
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Sede sede, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM SEDE t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(sede, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Sede entity
	 * 
	 * @param sede
	 *            Sede Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Sede sede) {

		StringBuilder where = new StringBuilder(SedeDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (sede != null && sede.getIdDatosede() != null) {
			where.append(" AND t1.ID_DATOSEDE = ?");
			params.add(sede.getIdDatosede());
		}
		if (sede != null && sede.getEscodigo() != null) {
			where.append(" AND t1.ESCODIGO = ?");
			params.add(sede.getEscodigo());
		}
		if (sede != null && sede.getPcodigo() != null) {
			where.append(" AND t1.PCODIGO = ?");
			params.add(sede.getPcodigo());
		}
		if (sede != null && sede.getExtranjero() != null) {
			where.append(" AND t1.EXTRANJERO = ?");
			params.add(sede.getExtranjero());
		}
		if (sede != null && sede.getNoraPaisId() != null) {
			where.append(" AND t1.NORA_PAIS_ID = ?");
			params.add(sede.getNoraPaisId());
		}
		if (sede != null && sede.getNoraPaisNombre() != null) {
			where.append(" AND t1.NORA_PAIS_NOMBRE = ?");
			params.add(sede.getNoraPaisNombre());
		}
		if (sede != null && sede.getNoraProvinciaId() != null) {
			where.append(" AND t1.NORA_PROVINCIA_ID = ?");
			params.add(sede.getNoraProvinciaId());
		}
		if (sede != null && sede.getNombreProvincia() != null) {
			where.append(" AND t1.NOMBRE_PROVINCIA = ?");
			params.add(sede.getNombreProvincia());
		}
		if (sede != null && sede.getNoraMunicipioId() != null) {
			where.append(" AND t1.NORA_MUNICIPIO_ID = ?");
			params.add(sede.getNoraMunicipioId());
		}
		if (sede != null && sede.getNombreMunicipio() != null) {
			where.append(" AND t1.NOMBRE_MUNICIPIO = ?");
			params.add(sede.getNombreMunicipio());
		}
		if (sede != null && sede.getNoraLocalidadId() != null) {
			where.append(" AND t1.NORA_LOCALIDAD_ID = ?");
			params.add(sede.getNoraLocalidadId());
		}
		if (sede != null && sede.getNombreLocalidad() != null) {
			where.append(" AND t1.NOMBRE_LOCALIDAD = ?");
			params.add(sede.getNombreLocalidad());
		}
		if (sede != null && sede.getNoraCalleId() != null) {
			where.append(" AND t1.NORA_CALLE_ID = ?");
			params.add(sede.getNoraCalleId());
		}
		if (sede != null && sede.getNombreCalle() != null) {
			where.append(" AND t1.NOMBRE_CALLE = ?");
			params.add(sede.getNombreCalle());
		}
		if (sede != null && sede.getNoraCpId() != null) {
			where.append(" AND t1.NORA_CP_ID = ?");
			params.add(sede.getNoraCpId());
		}
		if (sede != null && sede.getNombreCp() != null) {
			where.append(" AND t1.NOMBRE_CP = ?");
			params.add(sede.getNombreCp());
		}
		if (sede != null && sede.getNoraPortalId() != null) {
			where.append(" AND t1.NORA_PORTAL_ID = ?");
			params.add(sede.getNoraPortalId());
		}
		if (sede != null && sede.getNombrePortal() != null) {
			where.append(" AND t1.NOMBRE_PORTAL = ?");
			params.add(sede.getNombrePortal());
		}
		if (sede != null && sede.getNombrePiso() != null) {
			where.append(" AND t1.NOMBRE_PISO = ?");
			params.add(sede.getNombrePiso());
		}
		if (sede != null && sede.getDireccionNocapv() != null) {
			where.append(" AND t1.DIRECCION_NOCAPV = ?");
			params.add(sede.getDireccionNocapv());
		}
		if (sede != null && sede.getEmail() != null) {
			where.append(" AND t1.EMAIL = ?");
			params.add(sede.getEmail());
		}
		if (sede != null && sede.getContacto() != null) {
			where.append(" AND t1.CONTACTO = ?");
			params.add(sede.getContacto());
		}
		if (sede != null && sede.getNrtel1() != null) {
			where.append(" AND t1.NRTEL1 = ?");
			params.add(sede.getNrtel1());
		}
		if (sede != null && sede.getNrtel2() != null) {
			where.append(" AND t1.NRTEL2 = ?");
			params.add(sede.getNrtel2());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Sede entity
	 * 
	 * @param sede
	 *            Sede Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Sede sede, Boolean startsWith) {

		StringBuilder where = new StringBuilder(SedeDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (sede != null && sede.getIdDatosede() != null) {
			where.append(" AND UPPER(t1.ID_DATOSEDE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sede.getIdDatosede().toUpperCase() + "%");
			} else {
				params.add("%" + sede.getIdDatosede().toUpperCase() + "%");
			}
			where.append(" AND t1.ID_DATOSEDE IS NOT NULL");
		}
		if (sede != null && sede.getEscodigo() != null) {
			where.append(" AND UPPER(t1.ESCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sede.getEscodigo().toUpperCase() + "%");
			} else {
				params.add("%" + sede.getEscodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.ESCODIGO IS NOT NULL");
		}
		if (sede != null && sede.getPcodigo() != null) {
			where.append(" AND UPPER(t1.PCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sede.getPcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + sede.getPcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.PCODIGO IS NOT NULL");
		}
		if (sede != null && sede.getExtranjero() != null) {
			where.append(" AND UPPER(t1.EXTRANJERO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sede.getExtranjero().toUpperCase() + "%");
			} else {
				params.add("%" + sede.getExtranjero().toUpperCase() + "%");
			}
			where.append(" AND t1.EXTRANJERO IS NOT NULL");
		}
		if (sede != null && sede.getNoraPaisId() != null) {
			where.append(" AND UPPER(t1.NORA_PAIS_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sede.getNoraPaisId().toUpperCase() + "%");
			} else {
				params.add("%" + sede.getNoraPaisId().toUpperCase() + "%");
			}
			where.append(" AND t1.NORA_PAIS_ID IS NOT NULL");
		}
		if (sede != null && sede.getNoraPaisNombre() != null) {
			where.append(" AND UPPER(t1.NORA_PAIS_NOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sede.getNoraPaisNombre().toUpperCase() + "%");
			} else {
				params.add("%" + sede.getNoraPaisNombre().toUpperCase() + "%");
			}
			where.append(" AND t1.NORA_PAIS_NOMBRE IS NOT NULL");
		}
		if (sede != null && sede.getNoraProvinciaId() != null) {
			where.append(" AND UPPER(t1.NORA_PROVINCIA_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sede.getNoraProvinciaId().toUpperCase() + "%");
			} else {
				params.add("%" + sede.getNoraProvinciaId().toUpperCase() + "%");
			}
			where.append(" AND t1.NORA_PROVINCIA_ID IS NOT NULL");
		}
		if (sede != null && sede.getNombreProvincia() != null) {
			where.append(" AND UPPER(t1.NOMBRE_PROVINCIA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sede.getNombreProvincia().toUpperCase() + "%");
			} else {
				params.add("%" + sede.getNombreProvincia().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE_PROVINCIA IS NOT NULL");
		}
		if (sede != null && sede.getNoraMunicipioId() != null) {
			where.append(" AND UPPER(t1.NORA_MUNICIPIO_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sede.getNoraMunicipioId().toUpperCase() + "%");
			} else {
				params.add("%" + sede.getNoraMunicipioId().toUpperCase() + "%");
			}
			where.append(" AND t1.NORA_MUNICIPIO_ID IS NOT NULL");
		}
		if (sede != null && sede.getNombreMunicipio() != null) {
			where.append(" AND UPPER(t1.NOMBRE_MUNICIPIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sede.getNombreMunicipio().toUpperCase() + "%");
			} else {
				params.add("%" + sede.getNombreMunicipio().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE_MUNICIPIO IS NOT NULL");
		}
		if (sede != null && sede.getNoraLocalidadId() != null) {
			where.append(" AND UPPER(t1.NORA_LOCALIDAD_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sede.getNoraLocalidadId().toUpperCase() + "%");
			} else {
				params.add("%" + sede.getNoraLocalidadId().toUpperCase() + "%");
			}
			where.append(" AND t1.NORA_LOCALIDAD_ID IS NOT NULL");
		}
		if (sede != null && sede.getNombreLocalidad() != null) {
			where.append(" AND UPPER(t1.NOMBRE_LOCALIDAD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sede.getNombreLocalidad().toUpperCase() + "%");
			} else {
				params.add("%" + sede.getNombreLocalidad().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE_LOCALIDAD IS NOT NULL");
		}
		if (sede != null && sede.getNoraCalleId() != null) {
			where.append(" AND UPPER(t1.NORA_CALLE_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sede.getNoraCalleId().toUpperCase() + "%");
			} else {
				params.add("%" + sede.getNoraCalleId().toUpperCase() + "%");
			}
			where.append(" AND t1.NORA_CALLE_ID IS NOT NULL");
		}
		if (sede != null && sede.getNombreCalle() != null) {
			where.append(" AND UPPER(t1.NOMBRE_CALLE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sede.getNombreCalle().toUpperCase() + "%");
			} else {
				params.add("%" + sede.getNombreCalle().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE_CALLE IS NOT NULL");
		}
		if (sede != null && sede.getNoraCpId() != null) {
			where.append(" AND UPPER(t1.NORA_CP_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sede.getNoraCpId().toUpperCase() + "%");
			} else {
				params.add("%" + sede.getNoraCpId().toUpperCase() + "%");
			}
			where.append(" AND t1.NORA_CP_ID IS NOT NULL");
		}
		if (sede != null && sede.getNombreCp() != null) {
			where.append(" AND UPPER(t1.NOMBRE_CP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sede.getNombreCp().toUpperCase() + "%");
			} else {
				params.add("%" + sede.getNombreCp().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE_CP IS NOT NULL");
		}
		if (sede != null && sede.getNoraPortalId() != null) {
			where.append(" AND UPPER(t1.NORA_PORTAL_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sede.getNoraPortalId().toUpperCase() + "%");
			} else {
				params.add("%" + sede.getNoraPortalId().toUpperCase() + "%");
			}
			where.append(" AND t1.NORA_PORTAL_ID IS NOT NULL");
		}
		if (sede != null && sede.getNombrePortal() != null) {
			where.append(" AND UPPER(t1.NOMBRE_PORTAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sede.getNombrePortal().toUpperCase() + "%");
			} else {
				params.add("%" + sede.getNombrePortal().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE_PORTAL IS NOT NULL");
		}
		if (sede != null && sede.getNombrePiso() != null) {
			where.append(" AND UPPER(t1.NOMBRE_PISO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sede.getNombrePiso().toUpperCase() + "%");
			} else {
				params.add("%" + sede.getNombrePiso().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE_PISO IS NOT NULL");
		}
		if (sede != null && sede.getDireccionNocapv() != null) {
			where.append(" AND UPPER(t1.DIRECCION_NOCAPV) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sede.getDireccionNocapv().toUpperCase() + "%");
			} else {
				params.add("%" + sede.getDireccionNocapv().toUpperCase() + "%");
			}
			where.append(" AND t1.DIRECCION_NOCAPV IS NOT NULL");
		}
		if (sede != null && sede.getEmail() != null) {
			where.append(" AND UPPER(t1.EMAIL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sede.getEmail().toUpperCase() + "%");
			} else {
				params.add("%" + sede.getEmail().toUpperCase() + "%");
			}
			where.append(" AND t1.EMAIL IS NOT NULL");
		}
		if (sede != null && sede.getContacto() != null) {
			where.append(" AND UPPER(t1.CONTACTO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sede.getContacto().toUpperCase() + "%");
			} else {
				params.add("%" + sede.getContacto().toUpperCase() + "%");
			}
			where.append(" AND t1.CONTACTO IS NOT NULL");
		}
		if (sede != null && sede.getNrtel1() != null) {
			where.append(" AND UPPER(t1.NRTEL1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sede.getNrtel1().toUpperCase() + "%");
			} else {
				params.add("%" + sede.getNrtel1().toUpperCase() + "%");
			}
			where.append(" AND t1.NRTEL1 IS NOT NULL");
		}
		if (sede != null && sede.getNrtel2() != null) {
			where.append(" AND UPPER(t1.NRTEL2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sede.getNrtel2().toUpperCase() + "%");
			} else {
				params.add("%" + sede.getNrtel2().toUpperCase() + "%");
			}
			where.append(" AND t1.NRTEL2 IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
