package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.Establecimiento;
import com.ejie.y41b.model.Sede;

/**
 * SedeDao  
 * 
 *  
 */

public interface SedeDao {

	/**
	 * Inserts a single row in the Sede table.
	 * 
	 * @param sede
	 *            Sede
	 * @return Sede
	 */
	Sede add(Sede sede);

	/**
	 * Updates a single row in the Sede table.
	 * 
	 * @param sede
	 *            Sede
	 * @return Sede
	 */
	Sede update(Sede sede);

	/**
	 * Finds a single row in the Sede table.
	 * 
	 * @param sede
	 *            Sede
	 * @return Sede
	 */
	Sede find(Sede sede);

	/**
	 * Deletes a single row in the Sede table.
	 * 
	 * @param sede
	 *            Sede
	 * @return
	 */
	void remove(Sede sede);

	/**
	 * Removes a single row in the Sede table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return
	 */
	public void removeAllSedes(Establecimiento establecimiento);

	/**
	 * Finds a List of rows in the Sede table.
	 * 
	 * @param sede
	 *            Sede
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Sede> findAll(Sede sede, Pagination pagination);

	/**
	 * Counts rows in the Sede table.
	 * 
	 * @param sede
	 *            Sede
	 * @return Long
	 */
	Long findAllCount(Sede sede);

	/**
	 * Finds rows in the Sede table using like.
	 * 
	 * @param sede
	 *            Sede
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Sede> findAllLike(Sede sede, Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Sede table using like.
	 * 
	 * @param sede
	 *            Sede
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Sede sede, Boolean startsWith);
}
