package com.ejie.y41b.dao;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Descriptor;
import com.ejie.y41b.model.Sector;
import com.ejie.y41b.model.Y41bSectorTree;

/**
 * * SectorDao  
 * 
 *  
 */

public interface SectorDao {

	/**
	 * Inserts a single row in the Sector table.
	 * 
	 * @param sector
	 *            Sector
	 * @return Sector
	 */
	Sector add(Sector sector);

	/**
	 * Updates a single row in the Sector table.
	 * 
	 * @param sector
	 *            Sector
	 * @return Sector
	 */
	Sector update(Sector sector);

	/**
	 * Finds a single row in the Sector table.
	 * 
	 * @param sector
	 *            Sector
	 * @return Sector
	 */
	Sector find(Sector sector);

	/**
	 * Finds a single row in the Sector table.
	 * 
	 * @param sector
	 *            Pagination
	 * @return Sector
	 */
	Sector findSectorSeleccionable(Sector sector);

	/**
	 * Deletes a single row in the Sector table.
	 * 
	 * @param sector
	 *            Sector
	 * @return
	 */
	void remove(Sector sector);

	/**
	 * Finds a List of rows in the Sector table.
	 * 
	 * @param sector
	 *            Sector
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Sector> findAll(Sector sector, Pagination pagination);

	/**
	 * Finds a List of rows in the Sector table.
	 * 
	 * @param y41bSectoresTree
	 *            Y41bSectoresTree
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Y41bSectorTree> findAllSectoresPadre(
			Y41bSectorTree y41bSectoresTree, Pagination pagination);

	/**
	 * Finds a List of rows in the Sector table.
	 * 
	 * @param y41bSectoresTree
	 *            Y41bSectoresTree
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Y41bSectorTree> findAllChildren(
			Y41bSectorTree y41bSectoresTree, Pagination pagination);

	/**
	 * Counts rows in the Sector table.
	 * 
	 * @param y41bSectoresTree
	 *            Y41bSectoresTree
	 * @param sector
	 *            Sector
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long countSectoresHijos(Y41bSectorTree y41bSectoresTree,
			Sector sector, Boolean startsWith);

	/**
	 * Counts rows in the Sector table.
	 * 
	 * @param sector
	 *            Sector
	 * @return List
	 */
	Long findAllCount(Sector sector);

	/**
	 * Finds rows in the Sector table using like.
	 * 
	 * @param sector
	 *            Sector
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Sector> findAllLike(Sector sector, Pagination pagination,
			Boolean startsWith);

	/**
	 * Finds rows in the Sector table using like.
	 * 
	 * @param sector
	 *            Sector
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Sector> findAllLikeSector(Sector sector, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Sector table.
	 * 
	 * @param sector
	 *            Sector
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	Long findAllLikeSectorCount(Sector sector, Boolean startsWith);

	/**
	 * Finds a List of rows in the Sector table.
	 * 
	 * @param sector
	 *            Sector
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Sector> findAllLikeSectorSeleccion(Sector sector,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Sector table.
	 * 
	 * @param sector
	 *            Sector
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeSectorSeleccionCount(Sector sector,
			Boolean startsWith);

	/**
	 * Finds a List of rows in the SectorDescriptor table.
	 * 
	 * @param sector
	 *            Sector
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Sector> findAllSectoresDescriptores(Sector sector,
			Pagination pagination, Boolean startsWith);

	/**
	 * Inserts a single row in the SectorDescriptor table.
	 * 
	 * @param sector
	 *            Sector
	 * @return Sector
	 */
	public Sector addSectorDescriptor(Sector sector);

	/**
	 * Updates a single row in the SectorDescriptor table.
	 * 
	 * @param descriptorAEliminar
	 *            Descriptor
	 * @param descriptorBueno
	 *            Descriptor
	 * @return Descriptor
	 */
	public Descriptor updateSectorDescriptor(Descriptor descriptorAEliminar,
			Descriptor descriptorBueno);

	/**
	 * Deletes a single row in the SectorDescriptor table.
	 * 
	 * @param sector
	 *            Sector
	 * @return
	 */
	public void removeSectorDescriptor(Sector sector);

	/**
	 * Deletes a single row in the SectorDescriptor table.
	 * 
	 * @param sector
	 *            Sector
	 * @return
	 */
	public void removeAllSectorDescriptor(Sector sector);

	/**
	 * Find a single row in the findAllSectorDescriptor Many To Many
	 * relationship.
	 * 
	 * @param sector
	 *            Sector
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Descriptor> findAllSectorDescriptor(Sector sector,
			Pagination pagination);
}
