package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.SectorAgrupado;

/**
 * SectorAgrupadoDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class SectorAgrupadoDaoImpl implements SectorAgrupadoDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<SectorAgrupado> rwMap = new RowMapper<SectorAgrupado>() {
		public SectorAgrupado mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new SectorAgrupado(resultSet.getString("L0CODIGO"),
					resultSet.getString("L0NOMBRE"),
					resultSet.getString("L0NOMBREE"),
					resultSet.getString("L0NOMBREI"),
					resultSet.getString("L0NOMBREF"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the SectorAgrupado table.
	 * 
	 * @param sectoragrupado
	 *            Pagination
	 * @return SectorAgrupado
	 */
	public SectorAgrupado add(SectorAgrupado sectoragrupado) {
		String query = "INSERT INTO SECTOR_AGRUPADO (L0CODIGO, L0NOMBRE, L0NOMBREE, L0NOMBREI, L0NOMBREF) VALUES (?,?,?,?,?)";
		this.jdbcTemplate.update(query, sectoragrupado.getL0codigo(),
				sectoragrupado.getL0nombre(), sectoragrupado.getL0nombree(),
				sectoragrupado.getL0nombrei(), sectoragrupado.getL0nombref());
		return sectoragrupado;
	}

	/**
	 * Updates a single row in the SectorAgrupado table.
	 * 
	 * @param sectoragrupado
	 *            Pagination
	 * @return SectorAgrupado
	 */
	public SectorAgrupado update(SectorAgrupado sectoragrupado) {
		String query = "UPDATE SECTOR_AGRUPADO SET L0NOMBRE=?, L0NOMBREE=?, L0NOMBREI=?, L0NOMBREF=? WHERE L0CODIGO=?";
		this.jdbcTemplate.update(query, sectoragrupado.getL0nombre(),
				sectoragrupado.getL0nombree(), sectoragrupado.getL0nombrei(),
				sectoragrupado.getL0nombref(), sectoragrupado.getL0codigo());
		return sectoragrupado;
	}

	/**
	 * Finds a single row in the SectorAgrupado table.
	 * 
	 * @param sectoragrupado
	 *            Pagination
	 * @return SectorAgrupado
	 */
	@Transactional(readOnly = true)
	public SectorAgrupado find(SectorAgrupado sectoragrupado) {
		String query = "SELECT t1.L0CODIGO L0CODIGO, t1.L0NOMBRE L0NOMBRE, t1.L0NOMBREE L0NOMBREE, t1.L0NOMBREI L0NOMBREI, t1.L0NOMBREF L0NOMBREF FROM SECTOR_AGRUPADO t1  WHERE t1.L0CODIGO = ?  ";

		List<SectorAgrupado> sectoragrupadoList = this.jdbcTemplate.query(
				query, this.rwMap, sectoragrupado.getL0codigo());
		return (SectorAgrupado) DataAccessUtils
				.uniqueResult(sectoragrupadoList);
	}

	/**
	 * Removes a single row in the SectorAgrupado table.
	 * 
	 * @param sectoragrupado
	 *            Pagination
	 * @return
	 */
	public void remove(SectorAgrupado sectoragrupado) {
		String query = "DELETE FROM SECTOR_AGRUPADO WHERE L0CODIGO=?";
		this.jdbcTemplate.update(query, sectoragrupado.getL0codigo());
	}

	/**
	 * Finds a List of rows in the SectorAgrupado table.
	 * 
	 * @param sectoragrupado
	 *            SectorAgrupado
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<SectorAgrupado> findAll(SectorAgrupado sectoragrupado,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.L0CODIGO L0CODIGO,t1.L0NOMBRE L0NOMBRE,NVL(t1.L0NOMBREE,t1.L0NOMBRE) L0NOMBREE,t1.L0NOMBREI L0NOMBREI,t1.L0NOMBREF L0NOMBREF ");
		query.append("FROM SECTOR_AGRUPADO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(sectoragrupado);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<SectorAgrupado>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the SectorAgrupado table.
	 * 
	 * @param sectoragrupado
	 *            SectorAgrupado
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(SectorAgrupado sectoragrupado) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM SECTOR_AGRUPADO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(sectoragrupado);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the SectorAgrupado table using like.
	 * 
	 * @param sectoragrupado
	 *            SectorAgrupado
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<SectorAgrupado> findAllLike(SectorAgrupado sectoragrupado,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.L0CODIGO L0CODIGO,t1.L0NOMBRE L0NOMBRE,NVL(t1.L0NOMBREE,t1.L0NOMBRE) L0NOMBREE,t1.L0NOMBREI L0NOMBREI,t1.L0NOMBREF L0NOMBREF ");
		query.append("FROM SECTOR_AGRUPADO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(sectoragrupado,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<SectorAgrupado>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the SectorAgrupado table using like.
	 * 
	 * @param sectoragrupado
	 *            SectorAgrupado
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(SectorAgrupado sectoragrupado,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM SECTOR_AGRUPADO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(sectoragrupado,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the SectorAgrupado entity
	 * 
	 * @param sectoragrupado
	 *            SectorAgrupado Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(SectorAgrupado sectoragrupado) {

		StringBuilder where = new StringBuilder(
				SectorAgrupadoDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (sectoragrupado != null && sectoragrupado.getL0codigo() != null) {
			where.append(" AND t1.L0CODIGO = ?");
			params.add(sectoragrupado.getL0codigo());
		}
		if (sectoragrupado != null && sectoragrupado.getL0nombre() != null) {
			where.append(" AND t1.L0NOMBRE = ?");
			params.add(sectoragrupado.getL0nombre());
		}
		if (sectoragrupado != null && sectoragrupado.getL0nombree() != null) {
			where.append(" AND t1.L0NOMBREE = ?");
			params.add(sectoragrupado.getL0nombree());
		}
		if (sectoragrupado != null && sectoragrupado.getL0nombrei() != null) {
			where.append(" AND t1.L0NOMBREI = ?");
			params.add(sectoragrupado.getL0nombrei());
		}
		if (sectoragrupado != null && sectoragrupado.getL0nombref() != null) {
			where.append(" AND t1.L0NOMBREF = ?");
			params.add(sectoragrupado.getL0nombref());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the SectorAgrupado entity
	 * 
	 * @param sectoragrupado
	 *            SectorAgrupado Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(SectorAgrupado sectoragrupado,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				SectorAgrupadoDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (sectoragrupado != null && sectoragrupado.getL0codigo() != null) {
			where.append(" AND UPPER(t1.L0CODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sectoragrupado.getL0codigo().toUpperCase() + "%");
			} else {
				params.add("%" + sectoragrupado.getL0codigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.L0CODIGO IS NOT NULL");
		}
		if (sectoragrupado != null && sectoragrupado.getL0nombre() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.L0NOMBRE),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sectoragrupado.getL0nombre().toUpperCase()
						.replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O")
						.replaceAll("", "U")
						+ "%");
			} else {
				params.add("%"
						+ sectoragrupado.getL0nombre().toUpperCase()
								.replaceAll("", "A").replaceAll("", "E")
								.replaceAll("", "I").replaceAll("", "O")
								.replaceAll("", "U") + "%");
			}
			where.append(" AND t1.L0NOMBRE IS NOT NULL");
		}
		if (sectoragrupado != null && sectoragrupado.getL0nombree() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.L0NOMBREE),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sectoragrupado.getL0nombree().toUpperCase()
						.replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O")
						.replaceAll("", "U")
						+ "%");
			} else {
				params.add("%"
						+ sectoragrupado.getL0nombree().toUpperCase()
								.replaceAll("", "A").replaceAll("", "E")
								.replaceAll("", "I").replaceAll("", "O")
								.replaceAll("", "U") + "%");
			}
			where.append(" AND t1.L0NOMBREE IS NOT NULL");
		}
		if (sectoragrupado != null && sectoragrupado.getL0nombrei() != null) {
			where.append(" AND UPPER(t1.L0NOMBREI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sectoragrupado.getL0nombrei().toUpperCase() + "%");
			} else {
				params.add("%" + sectoragrupado.getL0nombrei().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.L0NOMBREI IS NOT NULL");
		}
		if (sectoragrupado != null && sectoragrupado.getL0nombref() != null) {
			where.append(" AND UPPER(t1.L0NOMBREF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sectoragrupado.getL0nombref().toUpperCase() + "%");
			} else {
				params.add("%" + sectoragrupado.getL0nombref().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.L0NOMBREF IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
