package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Secretar;
import com.ejie.y41b.utils.Y41bUtils;

/**
 * SecretarDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class SecretarDaoImpl implements SecretarDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Secretar> rwMap = new RowMapper<Secretar>() {
		public Secretar mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			Secretar secretar = new Secretar(resultSet.getString("SRCODIGO"),
					resultSet.getString("SRNIF"),
					resultSet.getString("SRNOMBRE"),
					resultSet.getString("SRNODIR"),
					resultSet.getString("SRCOLO"),
					resultSet.getString("SRNOLO"),
					resultSet.getString("SRNRCOPO"),
					resultSet.getString("SRCOPV"),
					resultSet.getString("SRNOPV"),
					resultSet.getString("SRNRTEL"),
					resultSet.getString("SRNRTEL2"),
					resultSet.getString("SRNRFAX"),
					resultSet.getString("SRTEEM"),
					resultSet.getString("SRTEURL"),
					resultSet.getString("SRCOTA1"),
					resultSet.getDate("SRFEBA"),
					resultSet.getString("SRTEOBS"),
					resultSet.getString("SRCOJA"),
					resultSet.getString("SRCOZS"),
					resultSet.getString("SRFEMOD"));
			secretar.setSrThActs(resultSet.getString("TA1NOMBRE"));
			return secretar;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Secretar table.
	 * 
	 * @param secretar
	 *            Pagination
	 * @return Secretar
	 */
	public Secretar add(Secretar secretar) {
		String query = "INSERT INTO SECRETAR (SRCODIGO, SRNIF, SRNOMBRE, SRNODIR, SRCOLO, SRNOLO, SRNRCOPO, SRCOPV, SRNOPV, SRNRTEL, SRNRTEL2, SRNRFAX, SRTEEM, SRTEURL, SRCOTA1, SRFEBA, SRTEOBS, SRCOJA, SRCOZS, SRFEMOD) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, secretar.getSrcodigo(),
				secretar.getSrnif(), secretar.getSrnombre(),
				secretar.getSrnodir(), secretar.getSrcolo(),
				secretar.getSrnolo(), secretar.getSrnrcopo(),
				secretar.getSrcopv(), secretar.getSrnopv(),
				secretar.getSrnrtel(), secretar.getSrnrtel2(),
				secretar.getSrnrfax(), secretar.getSrteem(),
				secretar.getSrteurl(), secretar.getSrcota1(),
				secretar.getSrfeba(), secretar.getSrteobs(),
				secretar.getSrcoja(), secretar.getSrcozs(),
				secretar.getSrfemod());
		return secretar;
	}

	/**
	 * Updates a single row in the Secretar table.
	 * 
	 * @param secretar
	 *            Pagination
	 * @return Secretar
	 */
	public Secretar update(Secretar secretar) {
		String query = "UPDATE SECRETAR SET SRNIF=?, SRNOMBRE=?, SRNODIR=?, SRCOLO=?, SRNOLO=?, SRNRCOPO=?, SRCOPV=?, SRNOPV=?, SRNRTEL=?, SRNRTEL2=?, SRNRFAX=?, SRTEEM=?, SRTEURL=?, SRCOTA1=?, SRFEBA=?, SRTEOBS=?, SRCOJA=?, SRCOZS=?, SRFEMOD=? WHERE SRCODIGO=?";
		this.jdbcTemplate.update(query, secretar.getSrnif(),
				secretar.getSrnombre(), secretar.getSrnodir(),
				secretar.getSrcolo(), secretar.getSrnolo(),
				secretar.getSrnrcopo(), secretar.getSrcopv(),
				secretar.getSrnopv(), secretar.getSrnrtel(),
				secretar.getSrnrtel2(), secretar.getSrnrfax(),
				secretar.getSrteem(), secretar.getSrteurl(),
				secretar.getSrcota1(), secretar.getSrfeba(),
				secretar.getSrteobs(), secretar.getSrcoja(),
				secretar.getSrcozs(), secretar.getSrfemod(),
				secretar.getSrcodigo());
		return secretar;
	}

	/**
	 * Finds a single row in the Secretar table.
	 * 
	 * @param secretar
	 *            Pagination
	 * @return Secretar
	 */
	@Transactional(readOnly = true)
	public Secretar find(Secretar secretar) {
		String query = "SELECT t1.SRCODIGO SRCODIGO, t1.SRNIF SRNIF, t1.SRNOMBRE SRNOMBRE, t1.SRNODIR SRNODIR, t1.SRCOLO SRCOLO, t1.SRNOLO SRNOLO, t1.SRNRCOPO SRNRCOPO, t1.SRCOPV SRCOPV, t1.SRNOPV SRNOPV, t1.SRNRTEL SRNRTEL, t1.SRNRTEL2 SRNRTEL2, t1.SRNRFAX SRNRFAX, t1.SRTEEM SRTEEM, t1.SRTEURL SRTEURL, t1.SRCOTA1 SRCOTA1, t1.SRFEBA SRFEBA, t1.SRTEOBS SRTEOBS, t1.SRCOJA SRCOJA, t2.USUARIOXLNET SRCOZS, t1.SRFEMOD SRFEMOD, '' TA1NOMBRE FROM SECRETAR t1,CENSO_MONITOR t2 WHERE t1.SRCOZS=t2.MOCODIGO(+) AND t1.SRCODIGO = ?  ";

		List<Secretar> secretarList = this.jdbcTemplate.query(query,
				this.rwMap, secretar.getSrcodigo());
		return (Secretar) DataAccessUtils.uniqueResult(secretarList);
	}

	/**
	 * Removes a single row in the Secretar table.
	 * 
	 * @param secretar
	 *            Pagination
	 * @return
	 */
	public void remove(Secretar secretar) {
		String query = "DELETE FROM SECRETAR WHERE SRCODIGO=?";
		this.jdbcTemplate.update(query, secretar.getSrcodigo());
	}

	/**
	 * Finds a List of rows in the Secretar table.
	 * 
	 * @param secretar
	 *            Secretar
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Secretar> findAll(Secretar secretar, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.SRCODIGO SRCODIGO,t1.SRNIF SRNIF,t1.SRNOMBRE SRNOMBRE,t1.SRNODIR SRNODIR,t1.SRCOLO SRCOLO,t1.SRNOLO SRNOLO,t1.SRNRCOPO SRNRCOPO,t1.SRCOPV SRCOPV,t1.SRNOPV SRNOPV,t1.SRNRTEL SRNRTEL,t1.SRNRTEL2 SRNRTEL2,t1.SRNRFAX SRNRFAX,t1.SRTEEM SRTEEM,t1.SRTEURL SRTEURL,t1.SRCOTA1 SRCOTA1,t1.SRFEBA SRFEBA,t1.SRTEOBS SRTEOBS,t1.SRCOJA SRCOJA,t1.SRCOZS SRCOZS,t1.SRFEMOD SRFEMOD, NVL(TA1NOMBRE,'') TA1NOMBRE ");
		query.append("FROM SECRETAR t1, TCTERRIT ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(secretar);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND SRCOTA1=TA1CODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Secretar>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Secretar table.
	 * 
	 * @param secretar
	 *            Secretar
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Secretar secretar) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM SECRETAR t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(secretar);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Secretar table using like.
	 * 
	 * @param secretar
	 *            Secretar
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Secretar> findAllLike(Secretar secretar, Pagination pagination,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.SRCODIGO SRCODIGO,t1.SRNIF SRNIF,t1.SRNOMBRE SRNOMBRE,t1.SRNODIR SRNODIR,t1.SRCOLO SRCOLO,t1.SRNOLO SRNOLO,t1.SRNRCOPO SRNRCOPO,t1.SRCOPV SRCOPV,t1.SRNOPV SRNOPV,t1.SRNRTEL SRNRTEL,t1.SRNRTEL2 SRNRTEL2,t1.SRNRFAX SRNRFAX,t1.SRTEEM SRTEEM,t1.SRTEURL SRTEURL,t1.SRCOTA1 SRCOTA1,t1.SRFEBA SRFEBA,t1.SRTEOBS SRTEOBS,t1.SRCOJA SRCOJA,t1.SRCOZS SRCOZS,t1.SRFEMOD SRFEMOD, '' TA1NOMBRE ");
		query.append("FROM SECRETAR t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(secretar, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Secretar>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Secretar table using like.
	 * 
	 * @param secretar
	 *            Secretar
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Secretar secretar, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM SECRETAR t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(secretar, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Secretar entity
	 * 
	 * @param secretar
	 *            Secretar Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Secretar secretar) {

		StringBuilder where = new StringBuilder(
				SecretarDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (secretar != null
				&& !Y41bUtils.esNullOCadenaVacia(secretar.getSrnif())) {
			where.append(" AND TRANSLATE(UPPER(t1.SRNIF),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%"
					+ secretar.getSrnif().toUpperCase().replaceAll("", "A")
							.replaceAll("", "E").replaceAll("", "I")
							.replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t1.SRNIF IS NOT NULL");
		}
		if (secretar != null
				&& !Y41bUtils.esNullOCadenaVacia(secretar.getSrnombre())) {
			where.append(" AND TRANSLATE(UPPER(t1.SRNOMBRE),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%"
					+ secretar.getSrnombre().toUpperCase().replaceAll("", "A")
							.replaceAll("", "E").replaceAll("", "I")
							.replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t1.SRNOMBRE IS NOT NULL");
		}
		// Territorio de actuacion
		if (secretar != null
				&& (!Y41bUtils.esNullOCadenaVacia(secretar.getSrThActAraba())
						|| !Y41bUtils.esNullOCadenaVacia(secretar
								.getSrThActBizkaia()) || !Y41bUtils
						.esNullOCadenaVacia(secretar.getSrThActGipuzkoa()))) {
			where.append(" AND (");
			if (secretar != null
					&& !Y41bUtils
							.esNullOCadenaVacia(secretar.getSrThActAraba())) {
				where.append(" t1.SRCOTA1 = ? ");
				params.add(secretar.getSrThActAraba());
			}
			if (secretar != null
					&& !Y41bUtils.esNullOCadenaVacia(secretar
							.getSrThActBizkaia())) {
				if (secretar != null
						&& !Y41bUtils.esNullOCadenaVacia(secretar
								.getSrThActAraba())) {
					where.append(" OR ");
				}
				where.append("  t1.SRCOTA1 = ? ");
				params.add(secretar.getSrThActBizkaia());
			}
			if (secretar != null
					&& !Y41bUtils.esNullOCadenaVacia(secretar
							.getSrThActGipuzkoa())) {
				if (secretar != null
						&& (!Y41bUtils.esNullOCadenaVacia(secretar
								.getSrThActAraba()) || !Y41bUtils
								.esNullOCadenaVacia(secretar
										.getSrThActBizkaia()))) {
					where.append(" OR ");
				}
				where.append("  t1.SRCOTA1 = ? ");
				params.add(secretar.getSrThActGipuzkoa());
			}
			where.append(" ) ");
		}
		// Tienen que ser secretarios no dados de baja y que sean instructores
		// de arbitraje
		if (secretar != null && secretar.getBaja() != null
				&& Y41bConstantes.VALOR_NO.equals(secretar.getBaja())) {
			where.append(" AND (t1.SRFEBA IS NULL OR ( t1.SRFEBA IS NOT NULL AND t1.SRFEBA >sysdate)) ");
			where.append(
					" AND EXISTS(SELECT 1 FROM CENSO_MONITOR t3 WHERE t3.MODNI=t1.SRNIF AND t3.ID_PERFILARBITRAJE IN ('")
					.append(Y41bConstantes.PERFIL_INSTRUCTOR).append("', '")
					.append(Y41bConstantes.PERFIL_COORDINADOR).append("', '")
					.append(Y41bConstantes.PERFIL_SUPERVISOR).append("'))");
		}
		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Secretar entity
	 * 
	 * @param secretar
	 *            Secretar Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Secretar secretar, Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				SecretarDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (secretar != null && secretar.getSrcodigo() != null) {
			where.append(" AND UPPER(t1.SRCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(secretar.getSrcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + secretar.getSrcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.SRCODIGO IS NOT NULL");
		}
		if (secretar != null && secretar.getSrnif() != null) {
			where.append(" AND UPPER(t1.SRNIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(secretar.getSrnif().toUpperCase() + "%");
			} else {
				params.add("%" + secretar.getSrnif().toUpperCase() + "%");
			}
			where.append(" AND t1.SRNIF IS NOT NULL");
		}
		if (secretar != null && secretar.getSrnombre() != null) {
			where.append(" AND UPPER(t1.SRNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(secretar.getSrnombre().toUpperCase() + "%");
			} else {
				params.add("%" + secretar.getSrnombre().toUpperCase() + "%");
			}
			where.append(" AND t1.SRNOMBRE IS NOT NULL");
		}
		if (secretar != null && secretar.getSrnodir() != null) {
			where.append(" AND UPPER(t1.SRNODIR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(secretar.getSrnodir().toUpperCase() + "%");
			} else {
				params.add("%" + secretar.getSrnodir().toUpperCase() + "%");
			}
			where.append(" AND t1.SRNODIR IS NOT NULL");
		}
		if (secretar != null && secretar.getSrcolo() != null) {
			where.append(" AND UPPER(t1.SRCOLO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(secretar.getSrcolo().toUpperCase() + "%");
			} else {
				params.add("%" + secretar.getSrcolo().toUpperCase() + "%");
			}
			where.append(" AND t1.SRCOLO IS NOT NULL");
		}
		if (secretar != null && secretar.getSrnolo() != null) {
			where.append(" AND UPPER(t1.SRNOLO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(secretar.getSrnolo().toUpperCase() + "%");
			} else {
				params.add("%" + secretar.getSrnolo().toUpperCase() + "%");
			}
			where.append(" AND t1.SRNOLO IS NOT NULL");
		}
		if (secretar != null && secretar.getSrnrcopo() != null) {
			where.append(" AND UPPER(t1.SRNRCOPO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(secretar.getSrnrcopo().toUpperCase() + "%");
			} else {
				params.add("%" + secretar.getSrnrcopo().toUpperCase() + "%");
			}
			where.append(" AND t1.SRNRCOPO IS NOT NULL");
		}
		if (secretar != null && secretar.getSrcopv() != null) {
			where.append(" AND UPPER(t1.SRCOPV) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(secretar.getSrcopv().toUpperCase() + "%");
			} else {
				params.add("%" + secretar.getSrcopv().toUpperCase() + "%");
			}
			where.append(" AND t1.SRCOPV IS NOT NULL");
		}
		if (secretar != null && secretar.getSrnopv() != null) {
			where.append(" AND UPPER(t1.SRNOPV) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(secretar.getSrnopv().toUpperCase() + "%");
			} else {
				params.add("%" + secretar.getSrnopv().toUpperCase() + "%");
			}
			where.append(" AND t1.SRNOPV IS NOT NULL");
		}
		if (secretar != null && secretar.getSrnrtel() != null) {
			where.append(" AND UPPER(t1.SRNRTEL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(secretar.getSrnrtel().toUpperCase() + "%");
			} else {
				params.add("%" + secretar.getSrnrtel().toUpperCase() + "%");
			}
			where.append(" AND t1.SRNRTEL IS NOT NULL");
		}
		if (secretar != null && secretar.getSrnrtel2() != null) {
			where.append(" AND UPPER(t1.SRNRTEL2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(secretar.getSrnrtel2().toUpperCase() + "%");
			} else {
				params.add("%" + secretar.getSrnrtel2().toUpperCase() + "%");
			}
			where.append(" AND t1.SRNRTEL2 IS NOT NULL");
		}
		if (secretar != null && secretar.getSrnrfax() != null) {
			where.append(" AND UPPER(t1.SRNRFAX) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(secretar.getSrnrfax().toUpperCase() + "%");
			} else {
				params.add("%" + secretar.getSrnrfax().toUpperCase() + "%");
			}
			where.append(" AND t1.SRNRFAX IS NOT NULL");
		}
		if (secretar != null && secretar.getSrteem() != null) {
			where.append(" AND UPPER(t1.SRTEEM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(secretar.getSrteem().toUpperCase() + "%");
			} else {
				params.add("%" + secretar.getSrteem().toUpperCase() + "%");
			}
			where.append(" AND t1.SRTEEM IS NOT NULL");
		}
		if (secretar != null && secretar.getSrteurl() != null) {
			where.append(" AND UPPER(t1.SRTEURL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(secretar.getSrteurl().toUpperCase() + "%");
			} else {
				params.add("%" + secretar.getSrteurl().toUpperCase() + "%");
			}
			where.append(" AND t1.SRTEURL IS NOT NULL");
		}
		if (secretar != null && secretar.getSrcota1() != null) {
			where.append(" AND UPPER(t1.SRCOTA1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(secretar.getSrcota1().toUpperCase() + "%");
			} else {
				params.add("%" + secretar.getSrcota1().toUpperCase() + "%");
			}
			where.append(" AND t1.SRCOTA1 IS NOT NULL");
		}
		if (secretar != null && secretar.getSrfeba() != null) {
			where.append(" AND t1.SRFEBA = ?");
			params.add(secretar.getSrfeba());
		}
		if (secretar != null && secretar.getSrteobs() != null) {
			where.append(" AND UPPER(t1.SRTEOBS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(secretar.getSrteobs().toUpperCase() + "%");
			} else {
				params.add("%" + secretar.getSrteobs().toUpperCase() + "%");
			}
			where.append(" AND t1.SRTEOBS IS NOT NULL");
		}
		if (secretar != null && secretar.getSrcoja() != null) {
			where.append(" AND UPPER(t1.SRCOJA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(secretar.getSrcoja().toUpperCase() + "%");
			} else {
				params.add("%" + secretar.getSrcoja().toUpperCase() + "%");
			}
			where.append(" AND t1.SRCOJA IS NOT NULL");
		}
		if (secretar != null && secretar.getSrcozs() != null) {
			where.append(" AND UPPER(t1.SRCOZS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(secretar.getSrcozs().toUpperCase() + "%");
			} else {
				params.add("%" + secretar.getSrcozs().toUpperCase() + "%");
			}
			where.append(" AND t1.SRCOZS IS NOT NULL");
		}
		if (secretar != null && secretar.getSrfemod() != null) {
			where.append(" AND UPPER(t1.SRFEMOD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(secretar.getSrfemod().toUpperCase() + "%");
			} else {
				params.add("%" + secretar.getSrfemod().toUpperCase() + "%");
			}
			where.append(" AND t1.SRFEMOD IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
