package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.Secretar;

/**
 * SecretarDao  
 *  
 */

public interface SecretarDao {
    
    /**
     * Inserts a single row in the Secretar table.
     *
     * @param secretar Secretar
     * @return Secretar
     */
    Secretar add(Secretar secretar);

    /**
     * Updates a single row in the Secretar table.
     *
     * @param secretar Secretar
     * @return Secretar
     */
    Secretar update(Secretar secretar);

    /**
     * Finds a single row in the Secretar table.
     *
     * @param secretar Secretar
     * @return Secretar
     */
    Secretar find(Secretar secretar);

    /**
     * Deletes a single row in the Secretar table.
     *
     * @param secretar Secretar
     * @return 
     */
    void remove(Secretar secretar);

    /**
     * Finds a List of rows in the Secretar table.
     *
     * @param secretar Secretar
     * @param pagination Pagination
     * @return List
     */
    List<Secretar> findAll(Secretar secretar, Pagination pagination);

    /**
     * Counts rows in the Secretar table.
     *
     * @param secretar Secretar
     * @return Long
     */
    Long findAllCount(Secretar secretar);
	
	/**
     * Finds rows in the Secretar table using like.
     *
     * @param secretar Secretar
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List
     */
	List<Secretar> findAllLike(Secretar secretar, Pagination pagination, Boolean startsWith);
	
    /**
     * Counts rows in the Secretar table using like.
     *
     * @param secretar Secretar
     * @param startsWith Boolean
     * @return Long
     */
    Long findAllLikeCount(Secretar secretar, Boolean startsWith);
}

