package com.ejie.y41b.dao;

//import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.horizontalSystemOfNotification.xml.DeliveredNotificationInfoDocument.DeliveredNotificationInfo;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Expedien;
import com.ejie.y41b.model.Fase;
import com.ejie.y41b.model.NotificacionAcuseRecibo;
import com.ejie.y41b.model.NotificacionesComunicacionesBusqueda;
import com.ejie.y41b.model.Sanexp;
import com.ejie.y41b.model.Santramexp;
import com.ejie.y41b.model.Tramite;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * SantramexpDaoImpl  
 * 
 *  
 */

@Repository()
@Transactional()
public class SantramexpDaoImpl implements SantramexpDao {
	private JdbcTemplate jdbcTemplate;

	private static final Logger logger = LoggerFactory.getLogger(SantramexpDaoImpl.class);

	private RowMapper<Santramexp> rwMap = new RowMapper<Santramexp>() {
		public Santramexp mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			try {

				CensoMonitor censoMonitor = new CensoMonitor(resultSet.getString("TRMOCODIGO"),
						resultSet.getString("MONOMBRE"));

				CensoMonitor censoMonitorEj = new CensoMonitor(resultSet.getString("TRMOCODIGOEJ"),
						resultSet.getString("MONOMBREEJ"));

				Expedien expedien = new Expedien(resultSet.getString("ExpedienEXCODIGO"),
						resultSet.getString("ExpedienEXCOOR"), resultSet.getBigDecimal("ExpedienEXNRAN"),
						resultSet.getBigDecimal("ExpedienEXNROR"), resultSet.getDate("ExpedienEXFERE"),
						resultSet.getString("ExpedienEXCOIT"), resultSet.getString("ExpedienEXCOES"),
						resultSet.getDate("ExpedienEXFEACIN"), resultSet.getDate("ExpedienEXFEEMCA"),
						resultSet.getDate("ExpedienEXFEPLCA"), resultSet.getDate("ExpedienEXFPNOPC"),
						resultSet.getDate("ExpedienEXFEDE"), resultSet.getDate("ExpedienEXFECOAL"),
						resultSet.getDate("ExpedienEXFENOPR"), resultSet.getDate("ExpedienEXFEPUPR"),
						resultSet.getString("ExpedienEXCOOSPR"), resultSet.getDate("ExpedienEXFEALPR"),
						resultSet.getDate("ExpedienEXFEEL"), resultSet.getDate("ExpedienEXFERES"),
						resultSet.getDate("ExpedienEXFENORE"), resultSet.getDate("ExpedienEXFEPURE"),
						resultSet.getString("ExpedienEXCOOSRE"), resultSet.getString("ExpedienEXCOTTR"),
						resultSet.getBigDecimal("ExpedienEXCAMURE"), resultSet.getDate("ExpedienEXFETA"),
						resultSet.getString("ExpedienEXCOTSA"), resultSet.getDate("ExpedienEXFECROI"),
						resultSet.getDate("ExpedienEXFEAR"), resultSet.getString("ExpedienEXCOORIE"),
						resultSet.getString("ExpedienEXINRE"), resultSet.getString("ExpedienEXINCOCO"),
						resultSet.getString("ExpedienEXINEXVA"), resultSet.getDate("ExpedienEXFECIRC"),
						resultSet.getDate("ExpedienEXFENOAI"), resultSet.getDate("ExpedienEXFECOLM"),
						resultSet.getString("ExpedienEXNUINLM"), resultSet.getDate("ExpedienEXFEINMU"),
						resultSet.getDate("ExpedienEXFEAVMU"), resultSet.getDate("ExpedienEXFEIMCD"),
						resultSet.getDate("ExpedienEXFECEDE"), resultSet.getString("ExpedienEXCOPS"),
						resultSet.getString("ExpedienEXCOSE"), new Sanexp(resultSet.getString("ExpedienEXCODIGO")),
						null, null, null);
				Fase fase = new Fase(resultSet.getString("FASEFCODIGO"), resultSet.getString("FASEFNOMBRE"),
						resultSet.getString("FASEFNOMBREE"), null, null);
				Santramexp santramexp = new Santramexp(resultSet.getString("TRID"), resultSet.getString("TRCODIGO"),
						resultSet.getString("TRCODIGOREL"), resultSet.getTimestamp("TRFECINI"),
						resultSet.getTimestamp("TRFECFIN"), resultSet.getClob("TROBSERVES"),
						resultSet.getString("TRNOMTRAMES"), resultSet.getString("TRTRIDREL"),
						resultSet.getDate("TRFECACINI"), resultSet.getBigDecimal("TRRESULTADO"),
						resultSet.getString("TRESTIMACION"), resultSet.getDate("TRRESOFECHA"),
						resultSet.getString("TRRESOTIPO"), resultSet.getBigDecimal("TRRESOSAN"),
						resultSet.getBigDecimal("TRRESOIMPORTE"), resultSet.getDate("TRFECREGS"), null,
						resultSet.getString("TRESTADOACUSE"), resultSet.getString("TRNUMREGS"),
						resultSet.getString("TRNUMREGE"), resultSet.getString("TRTIPOCOM"),
						resultSet.getDate("TRFECENVIO"), resultSet.getDate("TRFECCIERRE"),
						resultSet.getString("TRTIPONOT"), resultSet.getString("TRTIPONOTPLATEA"),
						resultSet.getBigDecimal("TRNUMDIAS"), resultSet.getBigDecimal("TRUAIDINTERV"),
						resultSet.getDate("TRFECBOPV"), resultSet.getDate("TRFECINITABL"),
						resultSet.getDate("TRFECNOTIF"), resultSet.getDate("TRFECALTA"),
						resultSet.getDate("TRFECMODIF"), resultSet.getString("TRUSUALTA"),
						resultSet.getString("TRUSUMODIF"), expedien, fase, censoMonitor, censoMonitorEj,
						resultSet.getString("TRESTADO"), resultSet.getClob("TRTEXTO"), null,
						resultSet.getString("TRSEDE"));

				santramexp.setTrreferencia(resultSet.getString("TRREFERENCIA"));
				santramexp.setTrcodrem(resultSet.getString("TRCODREM"));
				santramexp.setTrenvrem(resultSet.getString("TRENVREM"));
				santramexp.setTrfechaEnvioBOPVBOE(resultSet.getDate("TRFECHAENVIOBOPVBOE"));
				santramexp.setTrimporteinicial(resultSet.getBigDecimal("TRIMPORTEINICIAL"));
				santramexp.setTrfecsolred(resultSet.getDate("TRFECSOLRED"));
				santramexp.setTrprontopago(resultSet.getString("TRPRONTOPAGO"));
				santramexp.setTrreconocimiento(resultSet.getString("TRRECONOCIMIENTO"));
				santramexp.setTipoDestOrigen(resultSet.getString("TRDESTORIGEN"));
				try {
					Tramite tramite = new Tramite(resultSet.getString("TRCODIGO"), resultSet.getString("TRNOMBRE"),
							resultSet.getString("TRNOMBREE"), null, null, null, null, null, null);

					santramexp.setTramite(tramite);
				} catch (Exception e) {
					SantramexpDaoImpl.logger.debug("CAMPO TRNOMBRE,TRNOMBREE NO PRESENTE");
				}
				santramexp.setTridnotifplatea(resultSet.getString("TRIDNOTIFPLATEA"));
				santramexp.setTrproceedingsidplatea(resultSet.getString("TRPROCEEDINGSIDPLATEA"));
				santramexp.setTrrespuesta(resultSet.getString("TRRESPUESTA"));
				santramexp.setTrresumenalegaciones(resultSet.getClob("TRRESUMENALEGACIONES"));
				// # INICIO #
				// ADAPTACIONES LEY 39 - COMUNICACION POSTAL INICIO AL
				// SANCIONADO
				santramexp.setTrisComunicacionInicio(resultSet.getString("TRISCOMUNICACIONINICIO"));
				// # FIN #

				santramexp.setTrisNotificacionIncoacion(resultSet.getString("TRISNOTIFICACIONINCOACION"));

				santramexp.setTristelematica(resultSet.getString("TRISTELEMATICA"));

				// EVOLUTIVO 0135083 2.4 nuevo campo para guardar la
				// documentacion requerida
				// en euskera, en castellano se reutilizara el campo
				// trresumenalegaciones
				santramexp.setTrdocreqeus(resultSet.getClob("TRDOCREQEUS"));
				santramexp.setTrIsSir(resultSet.getString("TRISSIR"));
				santramexp.setTrIsSirConNumRegEntOri(resultSet.getString("TRISSIRCONNUMREGENTORI"));
				return santramexp;

			} catch (Exception e) {
				e.printStackTrace();
				SantramexpDaoImpl.logger.error("Error producido en maprow: " + e.getMessage(), e);
				throw new Y41bUDAException("error.generico", true, e);
			}

		}
	};

	private RowMapper<Santramexp> rwMapFichaExpediente = new RowMapper<Santramexp>() {
		public Santramexp mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			List<String> columnasSeleccionadas = Y41bUtils.cargarDatosBDVO(resultSet);

			CensoMonitor censoMonitor = new CensoMonitor(resultSet.getString("TRMOCODIGO"),
					resultSet.getString("MONOMBRE"), null, null, null, null, null, null, null, null, null, null, null,
					null, null, null, null, null, null, null, null, null);

			CensoMonitor censoMonitorEj = new CensoMonitor(resultSet.getString("TRMOCODIGOEJ"),
					resultSet.getString("MONOMBREEJ"), null, null, null, null, null, null, null, null, null, null, null,
					null, null, null, null, null, null, null, null, null);

			Expedien expedien = new Expedien(resultSet.getString("ExpedienEXCODIGO"), null, null, null, null, null,
					null, null, null);

			Fase fase = new Fase(resultSet.getString("FASEFCODIGO"), resultSet.getString("FASEFNOMBRE"),
					resultSet.getString("FASEFNOMBREE"), null, null);

			Tramite tramite = new Tramite(resultSet.getString("TRCODIGO"), resultSet.getString("TRNOMBRE"),
					resultSet.getString("TRNOMBREE"), null, null, null, null, null, null);

			Santramexp resultado = new Santramexp(resultSet.getString("TRID"), resultSet.getString("TRCODIGO"),
					resultSet.getTimestamp("TRFECINI"), resultSet.getTimestamp("TRFECFIN"),
					/* resultSet.getString("TROBSERVES") */null, resultSet.getString("TRNOMTRAMES"), expedien, fase,
					censoMonitor, censoMonitorEj, resultSet.getString("TRESTADO"), tramite,
					resultSet.getBigDecimal("TRRESOIMPORTE"), resultSet.getString("TRESTADOACUSE"),
					resultSet.getString("TRREFERENCIA"), resultSet.getString("TRRESOTIPO"),
					resultSet.getBigDecimal("TRRESOSAN"));

			resultado.setTrfechaEnvioBOPVBOE(resultSet.getDate("TRFECHAENVIOBOPVBOE"));
			resultado.setEnvcdessitcorreoses(resultSet.getString("ENVCDESSITCORREOSES"));
			resultado.setEnvcdessitcorreoseu(resultSet.getString("ENVCDESSITCORREOSEU"));
			resultado.setTrimporteinicial(resultSet.getBigDecimal("TRIMPORTEINICIAL"));
			resultado.setTrfecsolred(resultSet.getDate("TRFECSOLRED"));
			resultado.setTrprontopago(resultSet.getString("TRPRONTOPAGO"));
			resultado.setTrreconocimiento(resultSet.getString("TRRECONOCIMIENTO"));
			resultado.setTipoDestOrigen(resultSet.getString("TRDESTORIGEN"));
			try {
				resultado.setTrtiponot(resultSet.getString("TRTIPONOT"));
				resultado.setTrtipocom(resultSet.getString("TRTIPOCOM"));
				resultado.setTrfecbopv(resultSet.getDate("TRFECBOPV"));
				resultado.setTrfecinitabl(resultSet.getDate("TRFECINITABL"));
				resultado.setTrtridrel(resultSet.getString("TRTRIDREL"));
				resultado.setTrcodigorel(resultSet.getString("TRCODIGOREL"));
			} catch (Exception e) {
				SantramexpDaoImpl.logger.debug("CAMPO TRTRIDREL,TRCODIGOREL NO PRESENTE");
			}
			try {
				resultado.setTrfecnotif(resultSet.getDate("TRFECNOTIF"));
			} catch (Exception e) {
				SantramexpDaoImpl.logger.debug("CAMPO TRFECNOTIF NO PRESENTE");
			}
			try {
				resultado.setTrfecacuse(resultSet.getDate("TRFECACUSE"));
			} catch (Exception e) {
				SantramexpDaoImpl.logger.debug("CAMPO TRFECACUSE NO PRESENTE");
			}
			try {
				resultado.setTrresofecha(resultSet.getDate("TRRESOFECHA"));
			} catch (Exception e) {
				SantramexpDaoImpl.logger.debug("CAMPO TRRESOFECHA NO PRESENTE");
			}
			try {
				resultado.setTrestimacion(resultSet.getString("TRESTIMACION"));
			} catch (Exception e) {
				SantramexpDaoImpl.logger.debug("CAMPO TRESTIMACION NO PRESENTE");
			}
			try {
				resultado.setTrnumDias(resultSet.getBigDecimal("TRNUMDIAS"));
			} catch (Exception e) {
				SantramexpDaoImpl.logger.debug("CAMPO TRNUMDIAS NO PRESENTE");
			}
			try {
				resultado.setTrfecenvio(resultSet.getDate("TRFECENVIO"));
			} catch (Exception e) {
				SantramexpDaoImpl.logger.debug("CAMPO TRFECENVIO NO PRESENTE");
			}
			try {
				resultado.setTruaidinterv(resultSet.getBigDecimal("TRUAIDINTERV"));
			} catch (Exception e) {
				SantramexpDaoImpl.logger.debug("CAMPO TRUAIDINTERV NO PRESENTE");
			}
			resultado.setTrproceedingsidplatea(resultSet.getString("TRPROCEEDINGSIDPLATEA"));

			resultado.setTracusereintentado((columnasSeleccionadas.contains("TRACUSEREINTENTADO"))
					? resultSet.getString("TRACUSEREINTENTADO") : null);

			resultado.setTrrespuesta(resultSet.getString("TRRESPUESTA"));
			resultado.setTrresumenalegaciones(resultSet.getClob("TRRESUMENALEGACIONES"));

			resultado.setTristelematica(resultSet.getString("TRISTELEMATICA"));

			// EVOLUTIVO 0135083 2.4 nuevo campo para guardar la
			// documentacion requerida
			// en euskera, en castellano se reutilizara el campo
			// trresumenalegaciones
			resultado.setTrdocreqeus(resultSet.getClob("TRDOCREQEUS"));

			resultado.setTrIsSir(resultSet.getString("TRISSIR"));
			resultado.setTrIsSirConNumRegEntOri(resultSet.getString("TRISSIRCONNUMREGENTORI"));
			return resultado;
		}
	};

	private RowMapper<NotificacionAcuseRecibo> rwMapNotificacionAcuseRecibo = new RowMapper<NotificacionAcuseRecibo>() {
		public NotificacionAcuseRecibo mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new NotificacionAcuseRecibo(resultSet.getString("EHIDNOTIFICACIONPLATEA"),
					resultSet.getString("EHCODIGOACUSE"), resultSet.getString("EHPCODIGO"));
		}
	};

	private RowMapper<Santramexp> rwMapTRID = new RowMapper<Santramexp>() {
		public Santramexp mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			Santramexp santramexp = new Santramexp();
			santramexp.setTrid(resultSet.getString("TRID"));
			santramexp.setFase(new Fase(resultSet.getString("TRFCODIGO")));
			santramexp.setTrnomtrames(resultSet.getString("TRNOMTRAMES"));
			santramexp.setTrfecini(resultSet.getTimestamp("TRFECINI"));
			santramexp.setTrfecfin(resultSet.getTimestamp("TRFECFIN"));
			Tramite tramite = new Tramite();
			tramite.setTrcodigo(resultSet.getString("TRCODIGO"));
			tramite.setTrnombre(resultSet.getString("TRNOMBRE"));
			tramite.setTrnombree(resultSet.getString("TRNOMBREE"));
			santramexp.setTramite(tramite);
			return santramexp;
		}
	};

	private RowMapper<Santramexp> rwMapFichaTramite = new RowMapper<Santramexp>() {
		/*
		 * (non-Javadoc)
		 * 
		 * @see
		 * org.springframework.jdbc.core.RowMapper#mapRow(java.sql.ResultSet,
		 * int)
		 */
		public Santramexp mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			try {

				List<String> columnasSeleccionadas = Y41bUtils.cargarDatosBDVO(resultSet);

				CensoMonitor censoMonitor = new CensoMonitor(resultSet.getString("TRMOCODIGO"),
						resultSet.getString("MONOMBRE"));
				CensoMonitor censoMonitorEj = new CensoMonitor(resultSet.getString("TRMOCODIGOEJ"),
						resultSet.getString("MONOMBREEJ"));
				Expedien expediente = new Expedien(resultSet.getString("TREXCODIGO"));
				Santramexp santramexp = new Santramexp(resultSet.getString("TRID"), resultSet.getString("TRCODIGO"),
						resultSet.getTimestamp("TRFECINI"), resultSet.getTimestamp("TRFECFIN"),
						resultSet.getClob("TROBSERVES"), resultSet.getString("TRNOMTRAMES"),
						resultSet.getString("TRTRIDREL"), resultSet.getDate("TRFECACINI"),
						resultSet.getBigDecimal("TRRESULTADO"), resultSet.getString("TRESTIMACION"),
						resultSet.getDate("TRRESOFECHA"), resultSet.getString("TRRESOTIPO"),
						resultSet.getBigDecimal("TRRESOSAN"), resultSet.getBigDecimal("TRRESOIMPORTE"),
						resultSet.getDate("TRFECREGS"), null, resultSet.getString("TRESTADOACUSE"),
						resultSet.getString("TRNUMREGS"), resultSet.getString("TRNUMREGE"),
						resultSet.getString("TRTIPOCOM"), resultSet.getDate("TRFECENVIO"),
						resultSet.getDate("TRFECCIERRE"), resultSet.getString("TRTIPONOT"),
						resultSet.getBigDecimal("TRNUMDIAS"), resultSet.getBigDecimal("TRUAIDINTERV"),
						resultSet.getDate("TRFECBOPV"), resultSet.getDate("TRFECINITABL"),
						resultSet.getDate("TRFECNOTIF"), resultSet.getDate("TRFECALTA"),
						resultSet.getDate("TRFECMODIF"), resultSet.getString("TRUSUALTA"),
						resultSet.getString("TRUSUMODIF"), expediente, null, censoMonitor, censoMonitorEj,
						resultSet.getString("TRESTADO"), resultSet.getClob("TRTEXTO"),
						resultSet.getString("TRIDNOTIFPLATEA"), resultSet.getString("TRASUNTOCOMUNICACION"),
						resultSet.getString("TRTIPONOTPLATEA"), resultSet.getDate("TRFECACUSE"),
						resultSet.getString("TRSEDE"), resultSet.getString("TRCODREM"), resultSet.getString("TRENVREM"),
						resultSet.getString("TRIDMAILORIGEN"), resultSet.getString("TRMAILORIGEN"),
						resultSet.getString("TRIDMAILDESTINO"), resultSet.getString("TRMAILDESTINO"),
						resultSet.getString("TRISTELEMATICA"), resultSet.getString("TRISSIR"),
						resultSet.getString("TRISSIRCONNUMREGENTORI"));

				santramexp.setTrfechaEnvioBOPVBOE(resultSet.getDate("TRFECHAENVIOBOPVBOE"));
				santramexp.setTrproceedingsidplatea(resultSet.getString("TRPROCEEDINGSIDPLATEA"));
				santramexp.setTrimporteinicial(resultSet.getBigDecimal("TRIMPORTEINICIAL"));
				santramexp.setTrfecsolred(resultSet.getDate("TRFECSOLRED"));
				santramexp.setTrprontopago(resultSet.getString("TRPRONTOPAGO"));
				santramexp.setTrreconocimiento(resultSet.getString("TRRECONOCIMIENTO"));
				santramexp.setTracusereintentado((columnasSeleccionadas.contains("TRACUSEREINTENTADO"))
						? resultSet.getString("TRACUSEREINTENTADO") : null);
				santramexp.setTrautomatico(
						(columnasSeleccionadas.contains("TRAUTOMATICO")) ? resultSet.getString("TRAUTOMATICO") : null);
				santramexp.setTipoDestOrigen(resultSet.getString("TRDESTORIGEN"));
				santramexp.setTrrespuesta(resultSet.getString("TRRESPUESTA"));
				santramexp.setTrresumenalegaciones(resultSet.getClob("TRRESUMENALEGACIONES"));
				// # INICIO #
				// ADAPTACIONES LEY 39 - COMUNICACION POSTAL INICIO AL
				// SANCIONADO
				santramexp.setTrisComunicacionInicio(resultSet.getString("TRISCOMUNICACIONINICIO"));
				// # FIN #

				santramexp.setTrisNotificacionIncoacion(resultSet.getString("TRISNOTIFICACIONINCOACION"));

				santramexp.setTristelematica(resultSet.getString("TRISTELEMATICA"));

				// EVOLUTIVO 0135083 2.4 nuevo campo para guardar la
				// documentacion requerida
				// en euskera, en castellano se reutilizara el campo
				// trresumenalegaciones
				santramexp.setTrdocreqeus(resultSet.getClob("TRDOCREQEUS"));

				return santramexp;

			} catch (Exception e) {
				e.printStackTrace();
				SantramexpDaoImpl.logger.error("Error producido en rwMapFichaTramite: " + e.getMessage(), e);
				throw new Y41bUDAException("error.generico", true, e);
			}

		}
	};

	private RowMapper<NotificacionesComunicacionesBusqueda> rwMapNotifiComunica = new RowMapper<NotificacionesComunicacionesBusqueda>() {
		public NotificacionesComunicacionesBusqueda mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new NotificacionesComunicacionesBusqueda(resultSet.getString("TRID"),
					resultSet.getString("CODEXPEDIENTE"), resultSet.getString("EXCOOR"), resultSet.getString("EXNRAN"),
					resultSet.getBigDecimal("EXNROR"), null, resultSet.getDate("EHFECHAINICIO"),
					resultSet.getString("EHNUMREGISTROSALIDA"), resultSet.getString("EHTIPONOTIFICACIONPLATEA"),
					resultSet.getString("TRMOCODIGOEJ"), resultSet.getString("MONOMBRE"),
					resultSet.getString("UAIDINTERV"), resultSet.getString("NIF"),
					resultSet.getString("NOMBREDESTINATARIO"), resultSet.getString("NOMBRECOMERCIALDESTINATARIO"),
					resultSet.getString("EXTRANJERO"), resultSet.getString("NOMBRE_PROVINCIA"),
					resultSet.getString("NOMBRE_MUNICIPIO"), resultSet.getString("NOMBRE_LOCALIDAD"),
					resultSet.getString("NOMBRE_CP"), resultSet.getString("NOMBRE_CALLE"),
					resultSet.getString("NOMBREPORTAL"), resultSet.getString("NOMBREPISO"),
					resultSet.getString("NOMBREPAIS"), resultSet.getString("DIRECCIONNOCAPV"),
					resultSet.getString("DIRECCIONANTIGUA"), resultSet.getString("DIRECCION1"),
					resultSet.getString("DIRECCION2"), resultSet.getString("TRASUNTOCOMUNICACION"),
					resultSet.getString("EHESTADOTRAMITE"), resultSet.getString("EHSEDE"),
					resultSet.getString("ESCODIGO"), resultSet.getString("EXCODIGO"), resultSet.getString("CODORG"),
					resultSet.getString("NOMBREES"), resultSet.getString("NOMBREEU"),
					resultSet.getString("NORAPROVINCIAID"), resultSet.getString("NOMBREPROVINCIAORG"),
					resultSet.getString("NORAMUNICIPIOID"), resultSet.getString("NOMBREMUNICIPIOORG"),
					resultSet.getString("NORALOCALIDADID"), resultSet.getString("NOMBRELOCALIDADORG"),
					resultSet.getString("NORACALLEID"), resultSet.getString("NOMBRECALLEORG"),
					resultSet.getString("NORACPID"), resultSet.getString("NOMBRECPORG"),
					resultSet.getString("NORAPORTALID"), resultSet.getString("NOMBREPORTALORG"),
					resultSet.getString("TELEFONOORGANISMO"), resultSet.getString("FAXORGANISMO"),
					resultSet.getString("EMAILORGANISMO"), resultSet.getString("WEBORGANISMO"),
					resultSet.getString("TRCODIGO"), resultSet.getString("TIPOINTERVINIENTE"),
					resultSet.getString("USUARIOXLNET"), resultSet.getString("PUESTOXLNET"),
					resultSet.getString("ENVCESTADO"), resultSet.getString("ENVCDESERRORES"),
					resultSet.getString("ENVCDESERROREU"), resultSet.getInt("ENVCIDENVIO"),
					resultSet.getString("ENVCCODSITCORREOS"), resultSet.getString("ENVCDESSITCORREOSES"),
					resultSet.getString("ENVCDESSITCORREOSEU"), resultSet.getDate("ENVFECHAACTUALIZACION"),
					resultSet.getString("ENVCCODBARRAS"), resultSet.getString("IDTRAMITEACUSERELACIONADO"),
					resultSet.getString("EHACUSERECIBORECIBIDO"));

		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Santramexp table.
	 * 
	 * @param santramexp
	 *            Pagination
	 * @return Santramexp
	 */
	public Santramexp add(Santramexp santramexp) {

		String query = "INSERT INTO SANTRAMEXP (TRID,TREXCODIGO, TRCODIGO, TRFECINI, TRFECFIN, TROBSERVES, TRNOMTRAMES, TRMOCODIGO, TRTRIDREL, TRFECACINI, "
				+ "TRRESULTADO, TRESTIMACION, TRRESOFECHA, TRRESOTIPO, TRRESOSAN,TRRESOIMPORTE, TRFECREGS, TRFECREGE, TRESTADOACUSE, TRNUMREGS, TRNUMREGE, "
				+ "TRTIPOCOM, TRFECENVIO, TRFECCIERRE, TRFCODIGO,TRTIPONOT, TRESTADO, TRMOCODIGOEJ, TRNUMDIAS, TRFECBOPV, TRFECINITABL, TRFECNOTIF, TRUAIDINTERV, "
				+ "TRCODIGOREL, TRIDNOTIFPLATEA,TRASUNTOCOMUNICACION, TRTIPONOTPLATEA, TRFECACUSE, TRSEDE, TRREFERENCIA, TRCODREM, TRENVREM, TRIDMAILORIGEN, "
				+ "TRMAILORIGEN, TRIDMAILDESTINO, TRMAILDESTINO, TRFECHAENVIOBOPVBOE, TRIMPORTEINICIAL, TRFECSOLRED, TRPRONTOPAGO, TRRECONOCIMIENTO, TRIDESPERAPLATEA, "
				+ "TRMATARESPERA, TRAUTOMATICO, TRDESTORIGEN, TRRESPUESTA, TRRESUMENALEGACIONES"
				// # INICIO #
				// ADAPTACIONES LEY 39 - COMUNICACION POSTAL INICIO AL
				// SANCIONADO
				+ ", TRISCOMUNICACIONINICIO"
				// # FIN #
				+ ", TRISNOTIFICACIONINCOACION" + ", TRISTELEMATICA, TRDOCREQEUS, TRISSIR, TRISSIRCONNUMREGENTORI) "
				// EVOLUTIVO 0135083 2.4 nuevo campo para guardar la
				// documentacion requerida
				// en euskera, en castellano se reutilizara el campo
				// trresumenalegaciones
				+ " VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		Object getExpedienExcodigoAux = null;
		Object getCensoMonitorAux = null;
		Object getCensoMonitorEjAux = null;
		Object getFaseAux = null;
		Object getInterviniente = null;
		String sqlCompleta = "";

		if (santramexp.getTrid() == null) {
			santramexp.setTrid(this.getNewPK().toString());
		}
		if (santramexp.getExpedien() != null && santramexp.getExpedien().getExcodigo() != null) {
			getExpedienExcodigoAux = santramexp.getExpedien().getExcodigo();
		}
		if (santramexp.getCensoMonitor() != null && santramexp.getCensoMonitor().getMocodigo() != null) {
			getCensoMonitorAux = santramexp.getCensoMonitor().getMocodigo();
		}
		if (santramexp.getFase() != null && santramexp.getFase().getFcodigo() != null) {
			getFaseAux = santramexp.getFase().getFcodigo();
		}
		if (santramexp.getCensoMonitorEj() != null && santramexp.getCensoMonitorEj().getMocodigo() != null) {
			getCensoMonitorEjAux = santramexp.getCensoMonitorEj().getMocodigo();
		}
		if (santramexp.getTruaidinterv() != null) {
			getInterviniente = santramexp.getTruaidinterv();
		}

		if (Y41bConstantes.ESTADO_TRAMITE_TRAMITADO.equals(santramexp.getTrestado())) {
			santramexp.setTrfecfin(new Date());
		}

		santramexp.setTrfecini(new Date());
		if (Y41bConstantes.ESTADO_TRAMITE_TRAMITADO.equals(santramexp.getTrestado())) {
			santramexp.setTrfecfin(new Date());
		}
		// Control para evitar perder la relacin del acuse
		if (Y41bConstantes.TRAMITE_SANCIONES_ACUSERECIBO.equals(santramexp.getTrcodigo())
				&& santramexp.getTrtridrel() == null) {
			SantramexpDaoImpl.logger.error("ERROR AL CREAR EL ACUSE: SANTRAMEXP.TRTRIDREL NULL: "
					+ santramexp.getExpedien().getExcodigo() + " : " + santramexp.getTrid());
		}
		try {
			Object[] params = { santramexp.getTrid(), getExpedienExcodigoAux, santramexp.getTrcodigo(),
					santramexp.getTrfecini(), santramexp.getTrfecfin(),
					Y41bUtils.clobToString(santramexp.getTrobserves()), santramexp.getTrnomtrames(), getCensoMonitorAux,
					santramexp.getTrtridrel(), santramexp.getTrfecacini(), santramexp.getTrresultado(),
					santramexp.getTrestimacion(), santramexp.getTrresofecha(), santramexp.getTrresotipo(),
					santramexp.getTrresosan(), santramexp.getTrresoimporte(), santramexp.getTrfecregs(),
					santramexp.getTrfecrege(), santramexp.getTrestadoacuse(), santramexp.getTrnumregs(),
					santramexp.getTrnumrege(), santramexp.getTrtipocom(), santramexp.getTrfecenvio(),
					santramexp.getTrfeccierre(), getFaseAux, santramexp.getTrtiponot(), santramexp.getTrestado(),
					getCensoMonitorEjAux, santramexp.getTrnumDias(), santramexp.getTrfecbopv(),
					santramexp.getTrfecinitabl(), santramexp.getTrfecnotif(), getInterviniente,
					santramexp.getTrcodigorel(), santramexp.getTridnotifplatea(), santramexp.getTrasuntocomunicacion(),
					santramexp.getTrtiponotplatea(), santramexp.getTrfecacuse(), santramexp.getTrsede(),
					santramexp.getTrreferencia(), santramexp.getTrcodrem(), santramexp.getTrenvrem(),
					santramexp.getTridmailorigen(), santramexp.getTrmailorigen(), santramexp.getTridmaildestino(),
					santramexp.getTrmaildestino(), santramexp.getTrfechaEnvioBOPVBOE(),
					santramexp.getTrimporteinicial(), santramexp.getTrfecsolred(), santramexp.getTrprontopago(),
					santramexp.getTrreconocimiento(), santramexp.getTridesperaplatea(), santramexp.getTrmatarespera(),
					santramexp.getTrautomatico(), santramexp.getTipoDestOrigen(), santramexp.getTrrespuesta(),
					Y41bUtils.clobToString(santramexp.getTrresumenalegaciones())
					// # INICIO #
					// ADAPTACIONES LEY 39 - COMUNICACION POSTAL INICIO AL
					// SANCIONADO
					, santramexp.getTrisComunicacionInicio(),
					// # FIN #
					santramexp.getTrisNotificacionIncoacion(), santramexp.getTristelematica(),
					// EVOLUTIVO 0135083 2.4 nuevo campo para guardar la
					// documentacion requerida
					// en euskera, en castellano se reutilizara el campo
					// trresumenalegaciones
					Y41bUtils.clobToString(santramexp.getTrdocreqeus()), santramexp.getTrIsSir(),
					santramexp.getTrIsSirConNumRegEntOri() };

			sqlCompleta = Y41bUtils.dameSQL(query, params);

			this.jdbcTemplate.update(query, params);

			// Cuando se trata de una notificacion o comunicacion actualizamos
			// el campo TRTEXTO por separado
			if (Y41bConstantes.TRAMITE_SANCIONES_NOTIFICACION.equals(santramexp.getTrcodigo())
					|| Y41bConstantes.TRAMITE_SANCIONES_COMUNICACION.equals(santramexp.getTrcodigo())) {
				String query1 = "UPDATE SANTRAMEXP SET TRTEXTO = ? WHERE TRID=? ";
				Object[] params1 = { Y41bUtils.clobToString(santramexp.getTrtexto()), santramexp.getTrid() };

				sqlCompleta = Y41bUtils.dameSQL(query1, params1);
				this.jdbcTemplate.update(query1, params1);
			}
		} catch (Exception e) {
			e.printStackTrace();
			SantramexpDaoImpl.logger.error(e.getMessage() + ".SQL FORMATEADA:" + sqlCompleta + ".");
			throw new Y41bUDAException(e.getMessage(), true, e);
		}
		return santramexp;

	}

	/**
	 * Updates a single row in the Santramexp table.
	 * 
	 * @param santramexp
	 *            Pagination
	 * @return Santramexp
	 */
	public Santramexp update(Santramexp santramexp) {
		String sqlCompleta = "";
		try {
			// Hemos quitado TRFECINI de la update para que funcione el guardar
			// con la fecha y hora
			// Campos comentados: TRREFERENCIA=?
			// EVOLUTIVO 0135083 2.4 ANIADIDO TRREQDOCEUS
			String query = "UPDATE SANTRAMEXP SET TREXCODIGO=?, TRCODIGO=?, TRFECFIN=?, TROBSERVES=?, TRNOMTRAMES= ? , TRMOCODIGO=?, TRFECACINI=?, TRRESULTADO=?, "
					+ " TRESTIMACION=?, TRRESOFECHA=?, TRRESOTIPO=?, TRRESOSAN=?, TRRESOIMPORTE=?, TRFECREGS=?,TRFECREGE=?, TRESTADOACUSE=?, TRNUMREGS=?, TRNUMREGE=?, TRTIPOCOM=?, "
					+ "TRFECENVIO=?, TRFECCIERRE=?, TRESTADO = ?, TRMOCODIGOEJ=?, TRNUMDIAS = ?, TRFECBOPV = ?, TRFECINITABL = ?, TRFECNOTIF = ?, TRUAIDINTERV = ?, TRIDNOTIFPLATEA = ?, TRASUNTOCOMUNICACION = ?, TRTIPONOT = ?, TRTIPONOTPLATEA = ?, TRFECACUSE=?, TRSEDE = ?, TRCODREM = ?, TRENVREM = ?, TRIDMAILORIGEN = ?, TRMAILORIGEN = ?, TRIDMAILDESTINO = ?, TRMAILDESTINO = ?, TRFECHAENVIOBOPVBOE=?, TRIMPORTEINICIAL=?, TRFECSOLRED=?, TRPRONTOPAGO=?, TRRECONOCIMIENTO=?, TRDESTORIGEN=?, TRRESPUESTA=?, TRRESUMENALEGACIONES=?, TRDOCREQEUS=?, TRISSIR=?, TRISSIRCONNUMREGENTORI=? WHERE TRID=?";
			Object getExpedienExcodigoAux = null;
			Object getCensoMonitorAux = null;
			Object getCensoMonitorEjAux = null;
			Object getInterviniente = null;
			if (santramexp.getExpedien() != null && santramexp.getExpedien().getExcodigo() != null) {
				getExpedienExcodigoAux = santramexp.getExpedien().getExcodigo();
			}
			if (santramexp.getCensoMonitor() != null && santramexp.getCensoMonitor().getMocodigo() != null) {
				getCensoMonitorAux = santramexp.getCensoMonitor().getMocodigo();
			}
			if (santramexp.getCensoMonitorEj() != null && santramexp.getCensoMonitorEj().getMocodigo() != null) {
				getCensoMonitorEjAux = santramexp.getCensoMonitorEj().getMocodigo();
			}
			if (santramexp.getTruaidinterv() != null) {
				getInterviniente = santramexp.getTruaidinterv();
			}
			if (Y41bConstantes.ESTADO_TRAMITE_TRAMITADO.equals(santramexp.getTrestado())) {
				santramexp.setTrfecfin(new Date());
			}

			/*
			 * Valores comentados del array params santramexp.getTrfecini()
			 * Y41bUtils.clobToString(santramexp.getTrtexto())
			 * santramexp.getTrreferencia()
			 */
			Object[] params = { getExpedienExcodigoAux, santramexp.getTrcodigo(), santramexp.getTrfecfin(),
					Y41bUtils.clobToString(santramexp.getTrobserves()), santramexp.getTrnomtrames(), getCensoMonitorAux,
					santramexp.getTrfecacini(), santramexp.getTrresultado(), santramexp.getTrestimacion(),
					santramexp.getTrresofecha(), santramexp.getTrresotipo(), santramexp.getTrresosan(),
					santramexp.getTrresoimporte(), santramexp.getTrfecregs(), santramexp.getTrfecrege(),
					santramexp.getTrestadoacuse(), santramexp.getTrnumregs(), santramexp.getTrnumrege(),
					santramexp.getTrtipocom(), santramexp.getTrfecenvio(), santramexp.getTrfeccierre(),
					santramexp.getTrestado(), getCensoMonitorEjAux, santramexp.getTrnumDias(),
					santramexp.getTrfecbopv(), santramexp.getTrfecinitabl(), santramexp.getTrfecnotif(),
					getInterviniente, santramexp.getTridnotifplatea(), santramexp.getTrasuntocomunicacion(),
					santramexp.getTrtiponot(), santramexp.getTrtiponotplatea(), santramexp.getTrfecacuse(),
					santramexp.getTrsede(), santramexp.getTrcodrem(), santramexp.getTrenvrem(),
					santramexp.getTridmailorigen(), santramexp.getTrmailorigen(), santramexp.getTridmaildestino(),
					santramexp.getTrmaildestino(), santramexp.getTrfechaEnvioBOPVBOE(),
					santramexp.getTrimporteinicial(), santramexp.getTrfecsolred(), santramexp.getTrprontopago(),
					santramexp.getTrreconocimiento(), santramexp.getTipoDestOrigen(), santramexp.getTrrespuesta(),
					Y41bUtils.clobToString(santramexp.getTrresumenalegaciones()),
					// EVOLUTIVO 0135083 2.4 nuevo campo para guardar la
					// documentacion requerida
					// en euskera, en castellano se reutilizara el campo
					// trresumenalegaciones
					Y41bUtils.clobToString(santramexp.getTrdocreqeus()), santramexp.getTrIsSir(),
					santramexp.getTrIsSirConNumRegEntOri(), santramexp.getTrid() };

			sqlCompleta = Y41bUtils.dameSQL(query, params);

			this.jdbcTemplate.update(query, params);

			// Cuando se trata de una notificacion o comunicacion actualizamos
			// el campo TRTEXTO por separado
			if (Y41bConstantes.TRAMITE_SANCIONES_NOTIFICACION.equals(santramexp.getTrcodigo())
					|| Y41bConstantes.TRAMITE_SANCIONES_COMUNICACION.equals(santramexp.getTrcodigo())) {
				String query1 = "UPDATE SANTRAMEXP SET TRTEXTO = ? WHERE TRID=? ";
				Object[] params1 = { Y41bUtils.clobToString(santramexp.getTrtexto()), santramexp.getTrid() };

				sqlCompleta = Y41bUtils.dameSQL(query1, params1);
				this.jdbcTemplate.update(query1, params1);
			}
		} catch (Exception e) {
			SantramexpDaoImpl.logger.error(e.getMessage() + sqlCompleta);
			throw new Y41bUDAException(e.getMessage(), true, e);
		}
		return santramexp;
	}

	/**
	 * Finds a single row in the Santramexp table.
	 * 
	 * @param santramexp
	 *            Pagination
	 * @return Santramexp
	 */
	@Transactional(readOnly = true)
	public Santramexp find(Santramexp santramexp) {
		try {
			String query = "SELECT  t1.TRID TRID, t1.TRCODIGO TRCODIGO,t1.TRCODIGOREL TRCODIGOREL,t1.TRFECINI TRFECINI,t1.TRFECFIN TRFECFIN,t1.TRNOMTRAMES TRNOMTRAMES, t1.TRNUMDIAS TRNUMDIAS, t1.TRUAIDINTERV TRUAIDINTERV, t1.TRFECBOPV TRFECBOPV, t1.TRFECINITABL TRFECINITABL, t1.TRFECNOTIF TRFECNOTIF,  t1.TRTIPONOT TRTIPONOT,  t1.TRTIPONOTPLATEA TRTIPONOTPLATEA, t1.TRMOCODIGO TRMOCODIGO, t1.TRMOCODIGOEJ TRMOCODIGOEJ,t1.TRFCODIGO, t1.TRTRIDREL TRTRIDREL,t1.TRFECACINI TRFECACINI,t1.TRRESULTADO TRRESULTADO,t1.TRESTIMACION TRESTIMACION,t1.TRRESOFECHA TRRESOFECHA,t1.TRRESOTIPO TRRESOTIPO,t1.TRRESOSAN TRRESOSAN,t1.TRRESOIMPORTE TRRESOIMPORTE,t1.TRFECREGS TRFECREGS,t1.TRESTADOACUSE TRESTADOACUSE,t1.TRESTADO TRESTADO, t1.TRNUMREGS TRNUMREGS,t1.TRNUMREGE TRNUMREGE,t1.TRTIPOCOM TRTIPOCOM,t1.TRFECENVIO TRFECENVIO,t1.TRFECCIERRE TRFECCIERRE,t1.TRFECALTA TRFECALTA,t1.TRFECMODIF TRFECMODIF,t1.TRUSUALTA TRUSUALTA,t1.TRUSUMODIF TRUSUMODIF,t1.TRSEDE TRSEDE, t1.TRREFERENCIA TRREFERENCIA,t1.TRCODREM TRCODREM, t1.TRENVREM TRENVREM, t1.TRFECHAENVIOBOPVBOE TRFECHAENVIOBOPVBOE, t1.TRPROCEEDINGSIDPLATEA TRPROCEEDINGSIDPLATEA, t1.TRIDNOTIFPLATEA TRIDNOTIFPLATEA, t1.TRIMPORTEINICIAL TRIMPORTEINICIAL, t1.TRFECSOLRED TRFECSOLRED, t1.TRPRONTOPAGO TRPRONTOPAGO, t1.TRRECONOCIMIENTO TRRECONOCIMIENTO,  "
					+ " t1.TRTEXTO TRTEXTO, t1.TROBSERVES TROBSERVES, t1.TRDESTORIGEN TRDESTORIGEN, t1.TRRESPUESTA TRRESPUESTA, t1.TRRESUMENALEGACIONES TRRESUMENALEGACIONES, t1.TRISTELEMATICA TRISTELEMATICA, "
					// # INICIO #
					// ADAPTACIONES LEY 39 - COMUNICACION POSTAL INICIO AL
					// SANCIONADO
					+ " t1.TRISCOMUNICACIONINICIO TRISCOMUNICACIONINICIO, "
					// # FIN #
					+ " t1.TRISNOTIFICACIONINCOACION TRISNOTIFICACIONINCOACION, "
					// EVOLUTIVO 0135083 2.4
					+ "t1.TRDOCREQEUS TRDOCREQEUS, t1.TRISSIR TRISSIR, t1.TRISSIRCONNUMREGENTORI TRISSIRCONNUMREGENTORI, "
					+ " t2.EXCODIGO EXPEDIENEXCODIGO,t2.EXCOOR EXPEDIENEXCOOR,t2.EXNRAN EXPEDIENEXNRAN,t2.EXNROR EXPEDIENEXNROR,t2.EXFERE EXPEDIENEXFERE,t2.EXCOIT EXPEDIENEXCOIT,t2.EXCOES EXPEDIENEXCOES,t2.EXFEACIN EXPEDIENEXFEACIN,t2.EXFEEMCA EXPEDIENEXFEEMCA,t2.EXFEPLCA EXPEDIENEXFEPLCA,t2.EXFPNOPC EXPEDIENEXFPNOPC,t2.EXFEDE EXPEDIENEXFEDE,t2.EXFECOAL EXPEDIENEXFECOAL,t2.EXFENOPR EXPEDIENEXFENOPR,t2.EXFEPUPR EXPEDIENEXFEPUPR,t2.EXCOOSPR EXPEDIENEXCOOSPR,t2.EXFEALPR EXPEDIENEXFEALPR,t2.EXFEEL EXPEDIENEXFEEL,t2.EXFERES EXPEDIENEXFERES,t2.EXFENORE EXPEDIENEXFENORE,t2.EXFEPURE EXPEDIENEXFEPURE,t2.EXCOOSRE EXPEDIENEXCOOSRE,t2.EXCOTTR EXPEDIENEXCOTTR,t2.EXCAMURE EXPEDIENEXCAMURE,t2.EXFETA EXPEDIENEXFETA,t2.EXCOTSA EXPEDIENEXCOTSA,t2.EXFECROI EXPEDIENEXFECROI,t2.EXFEAR EXPEDIENEXFEAR,t2.EXCOORIE EXPEDIENEXCOORIE,t2.EXINRE EXPEDIENEXINRE,t2.EXINCOCO EXPEDIENEXINCOCO,t2.EXINEXVA EXPEDIENEXINEXVA,t2.EXFECIRC EXPEDIENEXFECIRC,t2.EXFENOAI EXPEDIENEXFENOAI,t2.EXFECOLM EXPEDIENEXFECOLM,t2.EXNUINLM EXPEDIENEXNUINLM,t2.EXFEINMU EXPEDIENEXFEINMU,t2.EXFEAVMU EXPEDIENEXFEAVMU,t2.EXFEIMCD EXPEDIENEXFEIMCD,t2.EXFECEDE EXPEDIENEXFECEDE,t2.EXCOPS EXPEDIENEXCOPS,t2.EXCOSE EXPEDIENEXCOSE, T3.FCODIGO FASEFCODIGO, T3.FNOMBRE FASEFNOMBRE, T3.FNOMBREE FASEFNOMBREE, t4.MONOMBRE, t5.MONOMBRE MONOMBREEJ, t6.TRNOMBRE TRNOMBRE, t6.TRNOMBREE TRNOMBREE"
					+ " FROM SANTRAMEXP t1 , EXPEDIEN t2, FASE t3, CENSO_MONITOR t4, CENSO_MONITOR t5, TRAMITE t6  "
					+ "WHERE 1=1 AND t1.TRID = ? AND t1.TREXCODIGO= t2.EXCODIGO(+) AND T3.FCODIGO(+) = T1.TRFCODIGO AND t1.TRMOCODIGO = t4.MOCODIGO(+) AND t1.TRMOCODIGOEJ = t5.MOCODIGO(+)  AND t6.TRCODIGO(+) = t1.TRCODIGO ";

			List<Santramexp> santramexpList = this.jdbcTemplate.query(query, this.rwMap, santramexp.getTrid());
			Santramexp resultado = (Santramexp) DataAccessUtils.uniqueResult(santramexpList);
			return resultado;
		} catch (Exception e) {
			e.printStackTrace();
			SantramexpDaoImpl.logger.error("Error producido en find de Santramexpdaoimpl: " + e.getMessage(), e);
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Finds a single row in the Santramexp table.
	 * 
	 * @param santramexp
	 *            Pagination
	 * @return Santramexp
	 */
	@Transactional(readOnly = true)
	public Santramexp findUltimoTramiteConFase(Santramexp santramexp) {
		try {
			String query = "SELECT  t1.TRID TRID, t1.TRCODIGO, t1.TRFECINI TRFECINI,t1.TRFECFIN TRFECFIN,t1.TRNOMTRAMES TRNOMTRAMES,"
					+ " t6.TRNOMBRE, t6.TRNOMBREE , t6.FCODIGO AS TRFCODIGO " + " FROM SANTRAMEXP t1, TRAMITE t6  "
					+ " WHERE t6.TRCODIGO(+) = t1.TRCODIGO "
					+ " AND t6.FCODIGO IS NOT NULL AND t1.TREXCODIGO=? AND t1.TRFECFIN = (SELECT MAX(TRFECFIN) FROM SANTRAMEXP tr2, TRAMITE tr3 WHERE tr2.TRCODIGO = tr3.TRCODIGO AND tr3.FCODIGO IS NOT NULL AND tr2.TREXCODIGO=? )  AND ROWNUM=1";

			List<Santramexp> santramexpList = this.jdbcTemplate.query(query, this.rwMapTRID,
					santramexp.getExpedien().getExcodigo(), santramexp.getExpedien().getExcodigo());
			Santramexp resultado = (Santramexp) DataAccessUtils.uniqueResult(santramexpList);
			return resultado;
		} catch (Exception e) {
			e.printStackTrace();
			SantramexpDaoImpl.logger.error("Error producido en find de Santramexpdaoimpl: " + e.getMessage(), e);
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Finds a single row in the Santramexp table.
	 * 
	 * @param idExpediente
	 *            String
	 * @return Santramexp
	 */
	@Transactional(readOnly = true)
	public Santramexp findUltimoCerradoResolucionComplementaria(String idExpediente) {
		String query = "SELECT aux2.*" + " FROM( " + " SELECT aux.*, rownum rn from " + " ( "
				+ " SELECT t1.TRID TRID, t1.TRSEDE TRSEDE,t1.TRCODIGO TRCODIGO,t1.TRCODIGOREL TRCODIGOREL,t1.TRFECINI TRFECINI,t1.TRFECFIN TRFECFIN,/*t1.TROBSERVES TROBSERVES,*/ t1.TRNOMTRAMES TRNOMTRAMES, t1.TRNUMDIAS TRNUMDIAS, t1.TRUAIDINTERV TRUAIDINTERV, t1.TRFECBOPV TRFECBOPV, t1.TRFECINITABL TRFECINITABL, t1.TRFECNOTIF TRFECNOTIF,  t1.TRTIPONOT TRTIPONOT,  t1.TRTIPONOTPLATEA TRTIPONOTPLATEA, t1.TRMOCODIGO TRMOCODIGO, t1.TRMOCODIGOEJ TRMOCODIGOEJ,t1.TRFCODIGO, t1.TRTRIDREL TRTRIDREL,t1.TRFECACINI TRFECACINI,t1.TRRESULTADO TRRESULTADO,t1.TRESTIMACION TRESTIMACION,t1.TRRESOFECHA TRRESOFECHA,t1.TRRESOTIPO TRRESOTIPO,t1.TRRESOSAN TRRESOSAN,t1.TRRESOIMPORTE TRRESOIMPORTE,t1.TRFECREGS TRFECREGS,t1.TRESTADOACUSE TRESTADOACUSE,t1.TRESTADO TRESTADO, t1.TRNUMREGS TRNUMREGS,t1.TRNUMREGE TRNUMREGE,t1.TRTIPOCOM TRTIPOCOM,t1.TRFECENVIO TRFECENVIO,t1.TRFECCIERRE TRFECCIERRE,t1.TRFECALTA TRFECALTA,t1.TRFECMODIF TRFECMODIF,t1.TRUSUALTA TRUSUALTA,t1.TRUSUMODIF TRUSUMODIF,t1.TRCODREM TRCODREM, t1.TRENVREM TRENVREM, t1.TRDESTORIGEN TRDESTORIGEN, t2.EXCODIGO EXPEDIENEXCODIGO,t2.EXCOOR EXPEDIENEXCOOR,t2.EXNRAN EXPEDIENEXNRAN,t2.EXNROR EXPEDIENEXNROR,t2.EXFERE EXPEDIENEXFERE,t2.EXCOIT EXPEDIENEXCOIT,t2.EXCOES EXPEDIENEXCOES,t2.EXFEACIN EXPEDIENEXFEACIN,t2.EXFEEMCA EXPEDIENEXFEEMCA,t2.EXFEPLCA EXPEDIENEXFEPLCA,t2.EXFPNOPC EXPEDIENEXFPNOPC,t2.EXFEDE EXPEDIENEXFEDE,t2.EXFECOAL EXPEDIENEXFECOAL,t2.EXFENOPR EXPEDIENEXFENOPR,t2.EXFEPUPR EXPEDIENEXFEPUPR,t2.EXCOOSPR EXPEDIENEXCOOSPR,t2.EXFEALPR EXPEDIENEXFEALPR,t2.EXFEEL EXPEDIENEXFEEL,t2.EXFERES EXPEDIENEXFERES,t2.EXFENORE EXPEDIENEXFENORE,t2.EXFEPURE EXPEDIENEXFEPURE,t2.EXCOOSRE EXPEDIENEXCOOSRE,t2.EXCOTTR EXPEDIENEXCOTTR,t2.EXCAMURE EXPEDIENEXCAMURE,t2.EXFETA EXPEDIENEXFETA,t2.EXCOTSA EXPEDIENEXCOTSA,t2.EXFECROI EXPEDIENEXFECROI,t2.EXFEAR EXPEDIENEXFEAR,t2.EXCOORIE EXPEDIENEXCOORIE,t2.EXINRE EXPEDIENEXINRE,t2.EXINCOCO EXPEDIENEXINCOCO,t2.EXINEXVA EXPEDIENEXINEXVA,t2.EXFECIRC EXPEDIENEXFECIRC,t2.EXFENOAI EXPEDIENEXFENOAI,t2.EXFECOLM EXPEDIENEXFECOLM,t2.EXNUINLM EXPEDIENEXNUINLM,t2.EXFEINMU EXPEDIENEXFEINMU,t2.EXFEAVMU EXPEDIENEXFEAVMU,t2.EXFEIMCD EXPEDIENEXFEIMCD,t2.EXFECEDE EXPEDIENEXFECEDE,t2.EXCOPS EXPEDIENEXCOPS,t2.EXCOSE EXPEDIENEXCOSE, T3.FCODIGO FASEFCODIGO, T3.FNOMBRE FASEFNOMBRE, T3.FNOMBREE FASEFNOMBREE, t4.MONOMBRE, t5.MONOMBRE MONOMBREEJ,t1.TRPROCEEDINGSIDPLATEA TRPROCEEDINGSIDPLATEA,t1.TRIDNOTIFPLATEA TRIDNOTIFPLATEA, t1.TRIMPORTEINICIAL TRIMPORTEINICIAL, t1.TRFECSOLRED TRFECSOLRED, t1.TRPRONTOPAGO TRPRONTOPAGO, t1.TRRECONOCIMIENTO TRRECONOCIMIENTO, t1.TRISTELEMATICA TRISTELEMATICA, , t1.TRDOCREQEUS TRDOCREQEUS "
				+ " ,null TRTEXTO, null TROBSERVES "
				+ " FROM SANTRAMEXP t1 , EXPEDIEN t2, FASE t3, CENSO_MONITOR t4, CENSO_MONITOR t5 "
				+ " WHERE 1=1 AND t1.TREXCODIGO = ? "
				+ " AND t1.TREXCODIGO= t2.EXCODIGO(+) AND T3.FCODIGO(+) = T1.TRFCODIGO AND t1.TRMOCODIGO = t4.MOCODIGO(+) AND t1.TRMOCODIGOEJ = t5.MOCODIGO(+) "
				+ " AND TRCODIGO = 'K31' AND t1.TRFECFIN IS NOT NULL  " + " ORDER BY TRFECFIN DESC "
				+ " ) aux) aux2 where rn = 1";

		List<Santramexp> santramexpList = this.jdbcTemplate.query(query, this.rwMap, idExpediente);
		Santramexp resultado = (Santramexp) DataAccessUtils.uniqueResult(santramexpList);
		return resultado;
	}

	/**
	 * Removes a single row in the Santramexp table.
	 * 
	 * @param santramexp
	 *            Pagination
	 * @return
	 */
	public void remove(Santramexp santramexp) {
		String query = "DELETE FROM SANTRAMEXP WHERE TRID=?";
		this.jdbcTemplate.update(query, santramexp.getTrid());
	}

	/**
	 * Finds a List of rows in the Santramexp table.
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Santramexp> findAll(Santramexp santramexp, Pagination pagination) {
		StringBuilder query = new StringBuilder("");
		List<?> params = null;
		try {
			query = new StringBuilder(
					"SELECT  t1.TRID TRID,t1.TRCODIGO TRCODIGO,t1.TRCODIGOREL TRCODIGOREL,t1.TRFECINI TRFECINI,t1.TRESTADOACUSE TRESTADOACUSE,t1.TRFECFIN TRFECFIN, t1.TRNOMTRAMES TRNOMTRAMES, t1.TRTIPONOT TRTIPONOT, t1.TRMOCODIGO TRMOCODIGO, t1.TRMOCODIGOEJ TRMOCODIGOEJ,t1.TRFCODIGO, t1.TRTRIDREL TRTRIDREL,t1.TRFECACINI TRFECACINI,t1.TRRESULTADO TRRESULTADO,t1.TRESTIMACION TRESTIMACION,t1.TRRESOFECHA TRRESOFECHA,t1.TRRESOTIPO TRRESOTIPO,t1.TRRESOSAN TRRESOSAN,t1.TRRESOIMPORTE TRRESOIMPORTE,t1.TRFECREGS TRFECREGS,t1.TRESTADO TRESTADO, t1.TRNUMREGS TRNUMREGS,t1.TRNUMREGE TRNUMREGE,t1.TRTIPOCOM TRTIPOCOM,t1.TRFECENVIO TRFECENVIO,t1.TRFECCIERRE TRFECCIERRE,t1.TRFECALTA TRFECALTA,t1.TRFECMODIF TRFECMODIF,t1.TRUSUALTA TRUSUALTA,t1.TRUSUMODIF TRUSUMODIF, t1.TRSEDE TRSEDE, t1.TRREFERENCIA TRREFERENCIA, t1.TRFECNOTIF TRFECNOTIF, t1.TRFECACUSE TRFECACUSE, t1.TRFECHAENVIOBOPVBOE TRFECHAENVIOBOPVBOE, t1.TRNUMDIAS TRNUMDIAS,t1.TRUAIDINTERV TRUAIDINTERV,t1.TRPROCEEDINGSIDPLATEA TRPROCEEDINGSIDPLATEA,t1.TRFECINITABL TRFECINITABL, t1.TRFECBOPV TRFECBOPV, t1.TRIMPORTEINICIAL TRIMPORTEINICIAL, t1.TRFECSOLRED TRFECSOLRED, t1.TRPRONTOPAGO TRPRONTOPAGO, t1.TRRECONOCIMIENTO TRRECONOCIMIENTO, t1.TRDESTORIGEN TRDESTORIGEN, t1.TRRESPUESTA TRRESPUESTA, t1.TRRESUMENALEGACIONES TRRESUMENALEGACIONES "
							+ ",null TROBSERVES,null TRTEXTO, TRACUSEREINTENTADO, t1.TRISTELEMATICA, t1.TRDOCREQEUS TRDOCREQEUS, t1.TRISSIR TRISSIR, t1.TRISSIRCONNUMREGENTORI TRISSIRCONNUMREGENTORI"
							+ " ,t2.EXCODIGO EXPEDIENEXCODIGO,t2.EXCOOR EXPEDIENEXCOOR,t2.EXNRAN EXPEDIENEXNRAN,t2.EXNROR EXPEDIENEXNROR,t2.EXFERE EXPEDIENEXFERE,t2.EXCOIT EXPEDIENEXCOIT,t2.EXCOES EXPEDIENEXCOES,t2.EXFEACIN EXPEDIENEXFEACIN,t2.EXFEEMCA EXPEDIENEXFEEMCA,t2.EXFEPLCA EXPEDIENEXFEPLCA,t2.EXFPNOPC EXPEDIENEXFPNOPC,t2.EXFEDE EXPEDIENEXFEDE,t2.EXFECOAL EXPEDIENEXFECOAL,t2.EXFENOPR EXPEDIENEXFENOPR,t2.EXFEPUPR EXPEDIENEXFEPUPR,t2.EXCOOSPR EXPEDIENEXCOOSPR,t2.EXFEALPR EXPEDIENEXFEALPR,t2.EXFEEL EXPEDIENEXFEEL,t2.EXFERES EXPEDIENEXFERES,t2.EXFENORE EXPEDIENEXFENORE,t2.EXFEPURE EXPEDIENEXFEPURE,t2.EXCOOSRE EXPEDIENEXCOOSRE,t2.EXCOTTR EXPEDIENEXCOTTR,t2.EXCAMURE EXPEDIENEXCAMURE,t2.EXFETA EXPEDIENEXFETA,t2.EXCOTSA EXPEDIENEXCOTSA,t2.EXFECROI EXPEDIENEXFECROI,t2.EXFEAR EXPEDIENEXFEAR,t2.EXCOORIE EXPEDIENEXCOORIE,t2.EXINRE EXPEDIENEXINRE,t2.EXINCOCO EXPEDIENEXINCOCO,t2.EXINEXVA EXPEDIENEXINEXVA,t2.EXFECIRC EXPEDIENEXFECIRC,t2.EXFENOAI EXPEDIENEXFENOAI,t2.EXFECOLM EXPEDIENEXFECOLM,t2.EXNUINLM EXPEDIENEXNUINLM,t2.EXFEINMU EXPEDIENEXFEINMU,t2.EXFEAVMU EXPEDIENEXFEAVMU,t2.EXFEIMCD EXPEDIENEXFEIMCD,t2.EXFECEDE EXPEDIENEXFECEDE,t2.EXCOPS EXPEDIENEXCOPS,t2.EXCOSE EXPEDIENEXCOSE, T3.FCODIGO FASEFCODIGO, T3.FNOMBRE FASEFNOMBRE, T3.FNOMBREE FASEFNOMBREE, t4.MONOMBRE, t5.MONOMBRE MONOMBREEJ, t6.TRNOMBRE, t6.TRNOMBREE, t7.ENVCDES_SIT_CORREOS_ES ENVCDESSITCORREOSES, t7.ENVCDES_SIT_CORREOS_EU ENVCDESSITCORREOSEU ");
			query.append(
					" FROM SANTRAMEXP t1 ,EXPEDIEN t2, FASE t3, CENSO_MONITOR t4, CENSO_MONITOR t5, TRAMITE t6, ENVIOS_POR_REMESA t7  ");

			// Where clause & Params
			Map<String, ?> mapaWhere = this.getWhereMap(santramexp);
			StringBuilder where = new StringBuilder(
					" WHERE 1=1 AND t1.TREXCODIGO= t2.EXCODIGO(+) AND T3.FCODIGO(+) = T1.TRFCODIGO AND t1.TRMOCODIGO = t4.MOCODIGO(+) AND t1.TRMOCODIGOEJ = t5.MOCODIGO(+) AND t6.TRCODIGO(+) = t1.TRCODIGO AND to_char(t1.TRTRIDREL) = t7.EHCODIGO(+) ");
			where.append(mapaWhere.get("query"));
			query.append(where);

			params = (List<?>) mapaWhere.get("params");

			if (pagination != null) {
				query = pagination.getPaginationQuery(query);
			}

			return (List<Santramexp>) this.jdbcTemplate.query(query.toString(), this.rwMapFichaExpediente,
					params.toArray());
		} catch (Exception e) {
			e.printStackTrace();
			return null;
		}

	}

	/**
	 * Counts rows in the Santramexp table.
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Santramexp santramexp) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM SANTRAMEXP t1 , EXPEDIEN t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(santramexp);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.TREXCODIGO= t2.EXCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds rows in the Santramexp table using like.
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Santramexp> findAllLike(Santramexp santramexp, Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.TRID TRID,t1.TRCODIGO TRCODIGO,t1.TRCODIGOREL TRCODIGOREL,t1.TRSEDE TRSEDE, t1.TRFECINI TRFECINI,t1.TRFECFIN TRFECFIN,t1.TRMOCODIGO TRMOCODIGO,t1.TRTRIDREL TRTRIDREL,t1.TRFECACINI TRFECACINI,t1.TRRESULTADO TRRESULTADO,t1.TRESTIMACION TRESTIMACION,t1.TRRESOFECHA TRRESOFECHA,t1.TRRESOTIPO TRRESOTIPO,t1.TRRESOSAN TRRESOSAN,t1.TRRESOIMPORTE TRRESOIMPORTE,t1.TRFECREGS TRFECREGS,t1.TRNUMREGS TRNUMREGS,t1.TRNUMREGE TRNUMREGE,t1.TRTIPOCOM TRTIPOCOM,t1.TRFECENVIO TRFECENVIO,t1.TRFECCIERRE TRFECCIERRE,t1.TRFECALTA TRFECALTA,t1.TRFECMODIF TRFECMODIF,t1.TRUSUALTA TRUSUALTA,t1.TRUSUMODIF TRUSUMODIF, t1.TRCODREM TRCODREM, t1.TRENVREM TRENVREM, t1.TRFECHAENVIOBOPVBOE TRFECHAENVIOBOPVBOE, t1.TRDESTORIGEN TRDESTORIGEN, t2.EXCODIGO EXPEDIENEXCODIGO,t2.EXCOOR EXPEDIENEXCOOR,t2.EXNRAN EXPEDIENEXNRAN,t2.EXNROR EXPEDIENEXNROR,t2.EXFERE EXPEDIENEXFERE,t2.EXCOIT EXPEDIENEXCOIT,t2.EXCOES EXPEDIENEXCOES,t2.EXFEACIN EXPEDIENEXFEACIN,t2.EXFEEMCA EXPEDIENEXFEEMCA,t2.EXFEPLCA EXPEDIENEXFEPLCA,t2.EXFPNOPC EXPEDIENEXFPNOPC,t2.EXFEDE EXPEDIENEXFEDE,t2.EXFECOAL EXPEDIENEXFECOAL,t2.EXFENOPR EXPEDIENEXFENOPR,t2.EXFEPUPR EXPEDIENEXFEPUPR,t2.EXCOOSPR EXPEDIENEXCOOSPR,t2.EXFEALPR EXPEDIENEXFEALPR,t2.EXFEEL EXPEDIENEXFEEL,t2.EXFERES EXPEDIENEXFERES,t2.EXFENORE EXPEDIENEXFENORE,t2.EXFEPURE EXPEDIENEXFEPURE,t2.EXCOOSRE EXPEDIENEXCOOSRE,t2.EXCOTTR EXPEDIENEXCOTTR,t2.EXCAMURE EXPEDIENEXCAMURE,t2.EXFETA EXPEDIENEXFETA,t2.EXCOTSA EXPEDIENEXCOTSA,t2.EXFECROI EXPEDIENEXFECROI,t2.EXFEAR EXPEDIENEXFEAR,t2.EXCOORIE EXPEDIENEXCOORIE,t2.EXINRE EXPEDIENEXINRE,t2.EXINCOCO EXPEDIENEXINCOCO,t2.EXINEXVA EXPEDIENEXINEXVA,t2.EXFECIRC EXPEDIENEXFECIRC,t2.EXFENOAI EXPEDIENEXFENOAI,t2.EXFECOLM EXPEDIENEXFECOLM,t2.EXNUINLM EXPEDIENEXNUINLM,t2.EXFEINMU EXPEDIENEXFEINMU,t2.EXFEAVMU EXPEDIENEXFEAVMU,t2.EXFEIMCD EXPEDIENEXFEIMCD,t2.EXFECEDE EXPEDIENEXFECEDE,t2.EXCOPS EXPEDIENEXCOPS,t2.EXCOSE EXPEDIENEXCOSE,t1.TRPROCEEDINGSIDPLATEA TRPROCEEDINGSIDPLATEA, t1.TRIDNOTIFPLATEA TRIDNOTIFPLATEA, t1.TRIMPORTEINICIAL TRIMPORTEINICIAL, t1.TRFECSOLRED TRFECSOLRED, t1.TRPRONTOPAGO TRPRONTOPAGO, t1.TRRECONOCIMIENTO TRRECONOCIMIENTO, t1.TRRESPUESTA TRRESPUESTA, t1.TRRESUMENALEGACIONES TRRESUMENALEGACIONES, t1.TRISTELEMATICA TRISTELEMATICA, t1.TRDOCREQEUS TRDOCREQEUS, t1.TRISSIR TRISSIR, t1.TRISSIRCONNUMREGENTORI TRISSIRCONNUMREGENTORI ");
		query.append(" ,null TROBSERVES,null TRTEXTO ");
		query.append("FROM SANTRAMEXP t1 ,EXPEDIEN t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(santramexp, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.TREXCODIGO= t2.EXCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Santramexp>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Santramexp table using like.
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Santramexp santramexp, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM SANTRAMEXP t1 ,EXPEDIEN t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(santramexp, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.TREXCODIGO= t2.EXCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Santramexp entity
	 * 
	 * @param santramexp
	 *            Santramexp Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Santramexp santramexp) {

		StringBuilder where = new StringBuilder(SantramexpDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (santramexp != null && santramexp.getTrid() != null) {
			where.append(" AND t1.TRID = ?");
			params.add(santramexp.getTrid());
		}
		if (santramexp != null && santramexp.getFase() != null && santramexp.getFase().getFcodigo() != null) {
			where.append(" AND t1.TRFCODIGO = ?");
			params.add(santramexp.getFase().getFcodigo());
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExcodigo() != null) {
			where.append(" AND t2.EXCODIGO = ?");
			params.add(santramexp.getExpedien().getExcodigo());
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExcoor() != null) {
			where.append(" AND t2.EXCOOR = ?");
			params.add(santramexp.getExpedien().getExcoor());
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExnran() != null) {
			where.append(" AND t2.EXNRAN = ?");
			params.add(santramexp.getExpedien().getExnran());
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExnror() != null) {
			where.append(" AND t2.EXNROR = ?");
			params.add(santramexp.getExpedien().getExnror());
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExfere() != null) {
			where.append(" AND t2.EXFERE = ?");
			params.add(santramexp.getExpedien().getExfere());
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExcoit() != null) {
			where.append(" AND t2.EXCOIT = ?");
			params.add(santramexp.getExpedien().getExcoit());
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExcoes() != null) {
			where.append(" AND t2.EXCOES = ?");
			params.add(santramexp.getExpedien().getExcoes());
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExfeacin() != null) {
			where.append(" AND t2.EXFEACIN = ?");
			params.add(santramexp.getExpedien().getExfeacin());
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExfeemca() != null) {
			where.append(" AND t2.EXFEEMCA = ?");
			params.add(santramexp.getExpedien().getExfeemca());
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExfeplca() != null) {
			where.append(" AND t2.EXFEPLCA = ?");
			params.add(santramexp.getExpedien().getExfeplca());
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExfpnopc() != null) {
			where.append(" AND t2.EXFPNOPC = ?");
			params.add(santramexp.getExpedien().getExfpnopc());
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExfede() != null) {
			where.append(" AND t2.EXFEDE = ?");
			params.add(santramexp.getExpedien().getExfede());
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExfecoal() != null) {
			where.append(" AND t2.EXFECOAL = ?");
			params.add(santramexp.getExpedien().getExfecoal());
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExfenopr() != null) {
			where.append(" AND t2.EXFENOPR = ?");
			params.add(santramexp.getExpedien().getExfenopr());
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExfepupr() != null) {
			where.append(" AND t2.EXFEPUPR = ?");
			params.add(santramexp.getExpedien().getExfepupr());
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExcoospr() != null) {
			where.append(" AND t2.EXCOOSPR = ?");
			params.add(santramexp.getExpedien().getExcoospr());
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExfealpr() != null) {
			where.append(" AND t2.EXFEALPR = ?");
			params.add(santramexp.getExpedien().getExfealpr());
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExfeel() != null) {
			where.append(" AND t2.EXFEEL = ?");
			params.add(santramexp.getExpedien().getExfeel());
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExferes() != null) {
			where.append(" AND t2.EXFERES = ?");
			params.add(santramexp.getExpedien().getExferes());
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExfenore() != null) {
			where.append(" AND t2.EXFENORE = ?");
			params.add(santramexp.getExpedien().getExfenore());
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExfepure() != null) {
			where.append(" AND t2.EXFEPURE = ?");
			params.add(santramexp.getExpedien().getExfepure());
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExcoosre() != null) {
			where.append(" AND t2.EXCOOSRE = ?");
			params.add(santramexp.getExpedien().getExcoosre());
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExcottr() != null) {
			where.append(" AND t2.EXCOTTR = ?");
			params.add(santramexp.getExpedien().getExcottr());
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExcamure() != null) {
			where.append(" AND t2.EXCAMURE = ?");
			params.add(santramexp.getExpedien().getExcamure());
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExfeta() != null) {
			where.append(" AND t2.EXFETA = ?");
			params.add(santramexp.getExpedien().getExfeta());
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExcotsa() != null) {
			where.append(" AND t2.EXCOTSA = ?");
			params.add(santramexp.getExpedien().getExcotsa());
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExfecroi() != null) {
			where.append(" AND t2.EXFECROI = ?");
			params.add(santramexp.getExpedien().getExfecroi());
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExfear() != null) {
			where.append(" AND t2.EXFEAR = ?");
			params.add(santramexp.getExpedien().getExfear());
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExcoorie() != null) {
			where.append(" AND t2.EXCOORIE = ?");
			params.add(santramexp.getExpedien().getExcoorie());
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExinre() != null) {
			where.append(" AND t2.EXINRE = ?");
			params.add(santramexp.getExpedien().getExinre());
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExincoco() != null) {
			where.append(" AND t2.EXINCOCO = ?");
			params.add(santramexp.getExpedien().getExincoco());
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExinexva() != null) {
			where.append(" AND t2.EXINEXVA = ?");
			params.add(santramexp.getExpedien().getExinexva());
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExfecirc() != null) {
			where.append(" AND t2.EXFECIRC = ?");
			params.add(santramexp.getExpedien().getExfecirc());
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExfenoai() != null) {
			where.append(" AND t2.EXFENOAI = ?");
			params.add(santramexp.getExpedien().getExfenoai());
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExfecolm() != null) {
			where.append(" AND t2.EXFECOLM = ?");
			params.add(santramexp.getExpedien().getExfecolm());
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExnuinlm() != null) {
			where.append(" AND t2.EXNUINLM = ?");
			params.add(santramexp.getExpedien().getExnuinlm());
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExfeinmu() != null) {
			where.append(" AND t2.EXFEINMU = ?");
			params.add(santramexp.getExpedien().getExfeinmu());
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExfeavmu() != null) {
			where.append(" AND t2.EXFEAVMU = ?");
			params.add(santramexp.getExpedien().getExfeavmu());
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExfeimcd() != null) {
			where.append(" AND t2.EXFEIMCD = ?");
			params.add(santramexp.getExpedien().getExfeimcd());
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExfecede() != null) {
			where.append(" AND t2.EXFECEDE = ?");
			params.add(santramexp.getExpedien().getExfecede());
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExcops() != null) {
			where.append(" AND t2.EXCOPS = ?");
			params.add(santramexp.getExpedien().getExcops());
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExcose() != null) {
			where.append(" AND t2.EXCOSE = ?");
			params.add(santramexp.getExpedien().getExcose());
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getSanexp() != null
				&& santramexp.getExpedien().getSanexp().getExcodigo() != null) {
			where.append(" AND t2.EXCODIGO = ?");
			params.add(santramexp.getExpedien().getSanexp().getExcodigo());
		}
		if (santramexp != null && santramexp.getTrcodigo() != null) {
			where.append(" AND t1.TRCODIGO = ?");
			params.add(santramexp.getTrcodigo());
		}
		if (santramexp != null && santramexp.getTrcodigorel() != null) {
			where.append(" AND t1.TRCODIGOREL = ?");
			params.add(santramexp.getTrcodigorel());
		}
		if (santramexp != null && santramexp.getTrfecini() != null) {
			where.append(" AND t1.TRFECINI = ?");
			params.add(santramexp.getTrfecini());
		}
		if (santramexp != null && santramexp.getTrfecfin() != null) {
			where.append(" AND t1.TRFECFIN = ?");
			params.add(santramexp.getTrfecfin());
		}
		if (santramexp != null && santramexp.getTrobserves() != null) {
			where.append(" AND t1.TROBSERVES = ?");
			params.add(santramexp.getTrobserves());
		}
		if (santramexp != null && santramexp.getCensoMonitor() != null
				&& santramexp.getCensoMonitor().getMocodigo() != null) {
			where.append(" AND t1.TRMOCODIGO = ?");
			params.add(santramexp.getCensoMonitor().getMocodigo());
		}
		if (santramexp != null && santramexp.getTrtridrel() != null) {
			where.append(" AND t1.TRTRIDREL = ?");
			params.add(santramexp.getTrtridrel());
		}
		if (santramexp != null && santramexp.getTrfecacini() != null) {
			where.append(" AND t1.TRFECACINI = ?");
			params.add(santramexp.getTrfecacini());
		}
		if (santramexp != null && santramexp.getTrresultado() != null) {
			where.append(" AND t1.TRRESULTADO = ?");
			params.add(santramexp.getTrresultado());
		}
		if (santramexp != null && santramexp.getTrestimacion() != null) {
			where.append(" AND t1.TRESTIMACION = ?");
			params.add(santramexp.getTrestimacion());
		}
		if (santramexp != null && santramexp.getTrresofecha() != null) {
			where.append(" AND t1.TRRESOFECHA = ?");
			params.add(santramexp.getTrresofecha());
		}
		if (santramexp != null && santramexp.getTrresotipo() != null) {
			where.append(" AND t1.TRRESOTIPO = ?");
			params.add(santramexp.getTrresotipo());
		}
		if (santramexp != null && santramexp.getTrestado() != null) {
			where.append(" AND t1.TRESTADO = ?");
			params.add(santramexp.getTrestado());
		}
		if (santramexp != null && santramexp.getTrresosan() != null) {
			where.append(" AND t1.TRRESOSAN = ?");
			params.add(santramexp.getTrresosan());
		}
		if (santramexp != null && santramexp.getTrresoimporte() != null) {
			where.append(" AND t1.TRRESOIMPORTE = ?");
			params.add(santramexp.getTrresoimporte());
		}
		if (santramexp != null && santramexp.getTrfecregs() != null) {
			where.append(" AND t1.TRFECREGS = ?");
			params.add(santramexp.getTrfecregs());
		}
		if (santramexp != null && santramexp.getTrestadoacuse() != null) {
			where.append(" AND t1.TRESTADOACUSE = ?");
			params.add(santramexp.getTrestadoacuse());
		}
		if (santramexp != null && santramexp.getTrnumregs() != null) {
			where.append(" AND t1.TRNUMREGS = ?");
			params.add(santramexp.getTrnumregs());
		}
		if (santramexp != null && santramexp.getTrnumrege() != null) {
			where.append(" AND t1.TRNUMREGE = ?");
			params.add(santramexp.getTrnumrege());
		}
		if (santramexp != null && santramexp.getTrtipocom() != null) {
			where.append(" AND t1.TRTIPOCOM = ?");
			params.add(santramexp.getTrtipocom());
		}
		if (santramexp != null && santramexp.getTrfecenvio() != null) {
			where.append(" AND t1.TRFECENVIO = ?");
			params.add(santramexp.getTrfecenvio());
		}
		if (santramexp != null && santramexp.getTrfeccierre() != null) {
			where.append(" AND t1.TRFECCIERRE = ?");
			params.add(santramexp.getTrfeccierre());
		}
		if (santramexp != null && santramexp.getTrfecalta() != null) {
			where.append(" AND t1.TRFECALTA = ?");
			params.add(santramexp.getTrfecalta());
		}
		if (santramexp != null && santramexp.getTrfecmodif() != null) {
			where.append(" AND t1.TRFECMODIF = ?");
			params.add(santramexp.getTrfecmodif());
		}
		if (santramexp != null && santramexp.getTrusualta() != null) {
			where.append(" AND t1.TRUSUALTA = ?");
			params.add(santramexp.getTrusualta());
		}
		if (santramexp != null && santramexp.getTrusumodif() != null) {
			where.append(" AND t1.TRUSUMODIF = ?");
			params.add(santramexp.getTrusumodif());
		}

		if (santramexp != null && santramexp.getTrnumDias() != null) {
			where.append(" AND t1.TRNUMDIAS = ?");
			params.add(santramexp.getTrnumDias());
		}
		if (santramexp != null && santramexp.getTrnumDias() != null) {
			where.append(" AND t1.TRNUMDIAS = ?");
			params.add(santramexp.getTrnumDias());
		}
		if (santramexp != null && santramexp.getTrfecbopv() != null) {
			where.append(" AND t1.TRFECBOPV = ?");
			params.add(santramexp.getTrfecbopv());
		}
		if (santramexp != null && santramexp.getTrfecinitabl() != null) {
			where.append(" AND t1.TRFECINITABL = ?");
			params.add(santramexp.getTrfecinitabl());
		}
		if (santramexp != null && santramexp.getTrfecnotif() != null) {
			where.append(" AND t1.TRFECNOTIF = ?");
			params.add(santramexp.getTrfecnotif());
		}

		if (santramexp != null && santramexp.getTruaidinterv() != null) {
			where.append(" AND t1.TRUAIDINTERV = ?");
			params.add(santramexp.getTruaidinterv());
		}

		if (santramexp != null && santramexp.getTrcodrem() != null) {
			where.append(" AND t1.TRCODREM = ?");
			params.add(santramexp.getTrcodrem());
		}

		if (santramexp != null && santramexp.getTrenvrem() != null) {
			where.append(" AND t1.TRENVREM = ?");
			params.add(santramexp.getTrenvrem());
		}

		if (santramexp != null && santramexp.getTrreferencia() != null) {
			where.append(" AND t1.TRREFERENCIA = ?");
			params.add(santramexp.getTrreferencia());
		}

		if (santramexp != null && santramexp.getTrreconocimiento() != null) {
			where.append(" AND t1.TRRECONOCIMIENTO = ?");
			params.add(santramexp.getTrreconocimiento());
		}

		if (santramexp != null && santramexp.getTrprontopago() != null) {
			where.append(" AND t1.TRPRONTOPAGO = ?");
			params.add(santramexp.getTrprontopago());
		}

		if (santramexp != null && santramexp.getTipoDestOrigen() != null) {
			where.append(" AND t1.TRDESTORIGEN = ?");
			params.add(santramexp.getTipoDestOrigen());
		}

		if (santramexp != null && santramexp.getTrrespuesta() != null) {
			where.append(" AND t1.TRRESPUESTA = ?");
			params.add(santramexp.getTrrespuesta());
		}

		// if (santramexp != null && santramexp.getTrresumenalegaciones() !=
		// null) {
		// where.append(" AND t1.TRRESUMENALEGACIONES = ?");
		// params.add(santramexp.getTrresumenalegaciones());
		// }

		if (santramexp != null && santramexp.getTristelematica() != null) {
			where.append(" AND t1.TRISTELEMATICA = ?");
			params.add(santramexp.getTristelematica());
		}

		if (santramexp != null && santramexp.getTrIsSir() != null) {
			where.append(" AND t1.TRISSIR = ?");
			params.add(santramexp.getTrIsSir());
		}

		if (santramexp != null && santramexp.getTrIsSirConNumRegEntOri() != null) {
			where.append(" AND t1.TRISSIRCONNUMREGENTORI = ?");
			params.add(santramexp.getTrIsSirConNumRegEntOri());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Santramexp entity
	 * 
	 * @param santramexp
	 *            Santramexp Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Santramexp santramexp, Boolean startsWith) {

		StringBuilder where = new StringBuilder(SantramexpDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (santramexp != null && santramexp.getTrid() != null) {
			where.append(" AND t1.TRID = ?");
			params.add(santramexp.getTrid());
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExcodigo() != null) {
			where.append(" AND t2.EXCODIGO = ?");
			params.add(santramexp.getExpedien().getExcodigo());
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExcoor() != null) {
			where.append(" AND UPPER(t2.EXCOOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(santramexp.getExpedien().getExcoor().toUpperCase() + "%");
			} else {
				params.add("%" + santramexp.getExpedien().getExcoor().toUpperCase() + "%");
			}
			where.append(" AND t2.EXCOOR IS NOT NULL");
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExnran() != null) {
			where.append(" AND t2.EXNRAN = ?");
			params.add(santramexp.getExpedien().getExnran());
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExnror() != null) {
			where.append(" AND t2.EXNROR = ?");
			params.add(santramexp.getExpedien().getExnror());
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExfere() != null) {
			where.append(" AND t2.EXFERE = ?");
			params.add(santramexp.getExpedien().getExfere());
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExcoit() != null) {
			where.append(" AND UPPER(t2.EXCOIT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(santramexp.getExpedien().getExcoit().toUpperCase() + "%");
			} else {
				params.add("%" + santramexp.getExpedien().getExcoit().toUpperCase() + "%");
			}
			where.append(" AND t2.EXCOIT IS NOT NULL");
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExcoes() != null) {
			where.append(" AND UPPER(t2.EXCOES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(santramexp.getExpedien().getExcoes().toUpperCase() + "%");
			} else {
				params.add("%" + santramexp.getExpedien().getExcoes().toUpperCase() + "%");
			}
			where.append(" AND t2.EXCOES IS NOT NULL");
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExfeacin() != null) {
			where.append(" AND t2.EXFEACIN = ?");
			params.add(santramexp.getExpedien().getExfeacin());
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExfeemca() != null) {
			where.append(" AND t2.EXFEEMCA = ?");
			params.add(santramexp.getExpedien().getExfeemca());
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExfeplca() != null) {
			where.append(" AND t2.EXFEPLCA = ?");
			params.add(santramexp.getExpedien().getExfeplca());
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExfpnopc() != null) {
			where.append(" AND t2.EXFPNOPC = ?");
			params.add(santramexp.getExpedien().getExfpnopc());
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExfede() != null) {
			where.append(" AND t2.EXFEDE = ?");
			params.add(santramexp.getExpedien().getExfede());
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExfecoal() != null) {
			where.append(" AND t2.EXFECOAL = ?");
			params.add(santramexp.getExpedien().getExfecoal());
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExfenopr() != null) {
			where.append(" AND t2.EXFENOPR = ?");
			params.add(santramexp.getExpedien().getExfenopr());
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExfepupr() != null) {
			where.append(" AND t2.EXFEPUPR = ?");
			params.add(santramexp.getExpedien().getExfepupr());
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExcoospr() != null) {
			where.append(" AND UPPER(t2.EXCOOSPR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(santramexp.getExpedien().getExcoospr().toUpperCase() + "%");
			} else {
				params.add("%" + santramexp.getExpedien().getExcoospr().toUpperCase() + "%");
			}
			where.append(" AND t2.EXCOOSPR IS NOT NULL");
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExfealpr() != null) {
			where.append(" AND t2.EXFEALPR = ?");
			params.add(santramexp.getExpedien().getExfealpr());
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExfeel() != null) {
			where.append(" AND t2.EXFEEL = ?");
			params.add(santramexp.getExpedien().getExfeel());
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExferes() != null) {
			where.append(" AND t2.EXFERES = ?");
			params.add(santramexp.getExpedien().getExferes());
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExfenore() != null) {
			where.append(" AND t2.EXFENORE = ?");
			params.add(santramexp.getExpedien().getExfenore());
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExfepure() != null) {
			where.append(" AND t2.EXFEPURE = ?");
			params.add(santramexp.getExpedien().getExfepure());
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExcoosre() != null) {
			where.append(" AND UPPER(t2.EXCOOSRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(santramexp.getExpedien().getExcoosre().toUpperCase() + "%");
			} else {
				params.add("%" + santramexp.getExpedien().getExcoosre().toUpperCase() + "%");
			}
			where.append(" AND t2.EXCOOSRE IS NOT NULL");
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExcottr() != null) {
			where.append(" AND UPPER(t2.EXCOTTR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(santramexp.getExpedien().getExcottr().toUpperCase() + "%");
			} else {
				params.add("%" + santramexp.getExpedien().getExcottr().toUpperCase() + "%");
			}
			where.append(" AND t2.EXCOTTR IS NOT NULL");
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExcamure() != null) {
			where.append(" AND t2.EXCAMURE = ?");
			params.add(santramexp.getExpedien().getExcamure());
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExfeta() != null) {
			where.append(" AND t2.EXFETA = ?");
			params.add(santramexp.getExpedien().getExfeta());
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExcotsa() != null) {
			where.append(" AND UPPER(t2.EXCOTSA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(santramexp.getExpedien().getExcotsa().toUpperCase() + "%");
			} else {
				params.add("%" + santramexp.getExpedien().getExcotsa().toUpperCase() + "%");
			}
			where.append(" AND t2.EXCOTSA IS NOT NULL");
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExfecroi() != null) {
			where.append(" AND t2.EXFECROI = ?");
			params.add(santramexp.getExpedien().getExfecroi());
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExfear() != null) {
			where.append(" AND t2.EXFEAR = ?");
			params.add(santramexp.getExpedien().getExfear());
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExcoorie() != null) {
			where.append(" AND UPPER(t2.EXCOORIE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(santramexp.getExpedien().getExcoorie().toUpperCase() + "%");
			} else {
				params.add("%" + santramexp.getExpedien().getExcoorie().toUpperCase() + "%");
			}
			where.append(" AND t2.EXCOORIE IS NOT NULL");
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExinre() != null) {
			where.append(" AND UPPER(t2.EXINRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(santramexp.getExpedien().getExinre().toUpperCase() + "%");
			} else {
				params.add("%" + santramexp.getExpedien().getExinre().toUpperCase() + "%");
			}
			where.append(" AND t2.EXINRE IS NOT NULL");
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExincoco() != null) {
			where.append(" AND UPPER(t2.EXINCOCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(santramexp.getExpedien().getExincoco().toUpperCase() + "%");
			} else {
				params.add("%" + santramexp.getExpedien().getExincoco().toUpperCase() + "%");
			}
			where.append(" AND t2.EXINCOCO IS NOT NULL");
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExinexva() != null) {
			where.append(" AND UPPER(t2.EXINEXVA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(santramexp.getExpedien().getExinexva().toUpperCase() + "%");
			} else {
				params.add("%" + santramexp.getExpedien().getExinexva().toUpperCase() + "%");
			}
			where.append(" AND t2.EXINEXVA IS NOT NULL");
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExfecirc() != null) {
			where.append(" AND t2.EXFECIRC = ?");
			params.add(santramexp.getExpedien().getExfecirc());
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExfenoai() != null) {
			where.append(" AND t2.EXFENOAI = ?");
			params.add(santramexp.getExpedien().getExfenoai());
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExfecolm() != null) {
			where.append(" AND t2.EXFECOLM = ?");
			params.add(santramexp.getExpedien().getExfecolm());
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExnuinlm() != null) {
			where.append(" AND UPPER(t2.EXNUINLM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(santramexp.getExpedien().getExnuinlm().toUpperCase() + "%");
			} else {
				params.add("%" + santramexp.getExpedien().getExnuinlm().toUpperCase() + "%");
			}
			where.append(" AND t2.EXNUINLM IS NOT NULL");
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExfeinmu() != null) {
			where.append(" AND t2.EXFEINMU = ?");
			params.add(santramexp.getExpedien().getExfeinmu());
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExfeavmu() != null) {
			where.append(" AND t2.EXFEAVMU = ?");
			params.add(santramexp.getExpedien().getExfeavmu());
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExfeimcd() != null) {
			where.append(" AND t2.EXFEIMCD = ?");
			params.add(santramexp.getExpedien().getExfeimcd());
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExfecede() != null) {
			where.append(" AND t2.EXFECEDE = ?");
			params.add(santramexp.getExpedien().getExfecede());
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExcops() != null) {
			where.append(" AND UPPER(t2.EXCOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(santramexp.getExpedien().getExcops().toUpperCase() + "%");
			} else {
				params.add("%" + santramexp.getExpedien().getExcops().toUpperCase() + "%");
			}
			where.append(" AND t2.EXCOPS IS NOT NULL");
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getExcose() != null) {
			where.append(" AND UPPER(t2.EXCOSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(santramexp.getExpedien().getExcose().toUpperCase() + "%");
			} else {
				params.add("%" + santramexp.getExpedien().getExcose().toUpperCase() + "%");
			}
			where.append(" AND t2.EXCOSE IS NOT NULL");
		}
		if (santramexp != null && santramexp.getExpedien() != null && santramexp.getExpedien().getSanexp() != null
				&& santramexp.getExpedien().getSanexp().getExcodigo() != null) {
			where.append(" AND UPPER(t2.EXCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(santramexp.getExpedien().getSanexp().getExcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + santramexp.getExpedien().getSanexp().getExcodigo().toUpperCase() + "%");
			}
			where.append(" AND t2.EXCODIGO IS NOT NULL");
		}
		if (santramexp != null && santramexp.getTrcodigo() != null) {
			where.append(" AND UPPER(t1.TRCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(santramexp.getTrcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + santramexp.getTrcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.TRCODIGO IS NOT NULL");
		}
		if (santramexp != null && santramexp.getTrcodigorel() != null) {
			where.append(" AND UPPER(t1.TRCODIGOREL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(santramexp.getTrcodigorel().toUpperCase() + "%");
			} else {
				params.add("%" + santramexp.getTrcodigorel().toUpperCase() + "%");
			}
			where.append(" AND t1.TRCODIGOREL IS NOT NULL");
		}
		if (santramexp != null && santramexp.getTrfecini() != null) {
			where.append(" AND t1.TRFECINI = ?");
			params.add(santramexp.getTrfecini());
		}
		if (santramexp != null && santramexp.getTrfecfin() != null) {
			where.append(" AND t1.TRFECFIN = ?");
			params.add(santramexp.getTrfecfin());
		}

		if (santramexp != null && santramexp.getCensoMonitor() != null
				&& santramexp.getCensoMonitor().getMocodigo() != null) {
			where.append(" AND UPPER(t1.TRMOCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(santramexp.getCensoMonitor().getMocodigo().toUpperCase() + "%");
			} else {
				params.add("%" + santramexp.getCensoMonitor().getMocodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.TRMOCODIGO IS NOT NULL");
		}

		if (santramexp != null && santramexp.getTrtridrel() != null) {
			where.append(" AND t1.TRTRIDREL = ?");
			params.add(santramexp.getTrtridrel());
		}
		if (santramexp != null && santramexp.getTrfecacini() != null) {
			where.append(" AND t1.TRFECACINI = ?");
			params.add(santramexp.getTrfecacini());
		}
		if (santramexp != null && santramexp.getTrresultado() != null) {
			where.append(" AND t2.TRRESULTADO = ?");
			params.add(santramexp.getTrresultado());
		}
		if (santramexp != null && santramexp.getTrestimacion() != null) {
			where.append(" AND UPPER(t1.TRESTIMACION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(santramexp.getTrestimacion().toUpperCase() + "%");
			} else {
				params.add("%" + santramexp.getTrestimacion().toUpperCase() + "%");
			}
			where.append(" AND t1.TRESTIMACION IS NOT NULL");
		}
		if (santramexp != null && santramexp.getTrresofecha() != null) {
			where.append(" AND t1.TRRESOFECHA = ?");
			params.add(santramexp.getTrresofecha());
		}
		if (santramexp != null && santramexp.getTrresotipo() != null) {
			where.append(" AND t1.TRRESOTIPO = ?");
			params.add(santramexp.getTrresultado());

		}
		if (santramexp != null && santramexp.getTrresosan() != null) {
			where.append(" AND t1.TRRESOSAN = ?");
			params.add(santramexp.getTrresultado());
		}
		if (santramexp != null && santramexp.getTrresoimporte() != null) {

			where.append(" AND t1.TRRESOIMPORTE = ?");
			params.add(santramexp.getTrresoimporte());

		}
		if (santramexp != null && santramexp.getTrfecregs() != null) {
			where.append(" AND t1.TRFECREGS = ?");
			params.add(santramexp.getTrfecregs());
		}
		if (santramexp != null && santramexp.getTrestadoacuse() != null) {
			where.append(" AND UPPER(t1.TRESTADOACUSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(santramexp.getTrestadoacuse().toUpperCase() + "%");
			} else {
				params.add("%" + santramexp.getTrestadoacuse().toUpperCase() + "%");
			}
			where.append(" AND t1.TRESTADOACUSE IS NOT NULL");
		}
		if (santramexp != null && santramexp.getTrnumregs() != null) {
			where.append(" AND UPPER(t1.TRNUMREGS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(santramexp.getTrnumregs().toUpperCase() + "%");
			} else {
				params.add("%" + santramexp.getTrnumregs().toUpperCase() + "%");
			}
			where.append(" AND t1.TRNUMREGS IS NOT NULL");
		}
		if (santramexp != null && santramexp.getTrnumrege() != null) {
			where.append(" AND UPPER(t1.TRNUMREGE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(santramexp.getTrnumrege().toUpperCase() + "%");
			} else {
				params.add("%" + santramexp.getTrnumrege().toUpperCase() + "%");
			}
			where.append(" AND t1.TRNUMREGE IS NOT NULL");
		}
		if (santramexp != null && santramexp.getTrtipocom() != null) {
			where.append(" AND UPPER(t1.TRTIPOCOM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(santramexp.getTrtipocom().toUpperCase() + "%");
			} else {
				params.add("%" + santramexp.getTrtipocom().toUpperCase() + "%");
			}
			where.append(" AND t1.TRTIPOCOM IS NOT NULL");
		}

		if (santramexp != null && santramexp.getTrfecenvio() != null) {
			where.append(" AND t1.TRFECENVIO = ?");
			params.add(santramexp.getTrfecenvio());
		}

		if (santramexp != null && santramexp.getTrfeccierre() != null) {
			where.append(" AND t1.TRFECCIERRE = ?");
			params.add(santramexp.getTrfeccierre());
		}
		if (santramexp != null && santramexp.getTrfecalta() != null) {
			where.append(" AND t1.TRFECALTA = ?");
			params.add(santramexp.getTrfecalta());
		}
		if (santramexp != null && santramexp.getTrfecmodif() != null) {
			where.append(" AND t1.TRFECMODIF = ?");
			params.add(santramexp.getTrfecmodif());
		}
		if (santramexp != null && santramexp.getTrusualta() != null) {
			where.append(" AND UPPER(t1.TRUSUALTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(santramexp.getTrusualta().toUpperCase() + "%");
			} else {
				params.add("%" + santramexp.getTrusualta().toUpperCase() + "%");
			}
			where.append(" AND t1.TRUSUALTA IS NOT NULL");
		}
		if (santramexp != null && santramexp.getTrusumodif() != null) {
			where.append(" AND UPPER(t1.TRUSUMODIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(santramexp.getTrusumodif().toUpperCase() + "%");
			} else {
				params.add("%" + santramexp.getTrusumodif().toUpperCase() + "%");
			}
			where.append(" AND t1.TRUSUMODIF IS NOT NULL");
		}

		if (santramexp != null && santramexp.getTrcodrem() != null) {
			where.append(" AND t1.TRCODREM = ?");
			params.add(santramexp.getTrcodrem());
		}

		if (santramexp != null && santramexp.getTrenvrem() != null) {
			where.append(" AND t1.TRENVREM = ?");
			params.add(santramexp.getTrenvrem());
		}

		if (santramexp != null && santramexp.getTipoDestOrigen() != null) {
			where.append(" AND t1.TRDESTORIGEN = ?");
			params.add(santramexp.getTipoDestOrigen());
		}

		if (santramexp != null && santramexp.getTrrespuesta() != null) {
			where.append(" AND t1.TRRESPUESTA = ?");
			params.add(santramexp.getTrrespuesta());
		}

		// if (santramexp != null && santramexp.getTrresumenalegaciones() !=
		// null) {
		// where.append(" AND t1.TRRESUMENALEGACIONES = ?");
		// params.add(santramexp.getTrresumenalegaciones());
		// }

		if (santramexp != null && santramexp.getTristelematica() != null) {
			where.append(" AND t1.TRISTELEMATICA = ?");
			params.add(santramexp.getTristelematica());
		}

		if (santramexp != null && santramexp.getTrIsSir() != null) {
			where.append(" AND t1.TRISSIR = ?");
			params.add(santramexp.getTrIsSir());
		}

		if (santramexp != null && santramexp.getTrIsSirConNumRegEntOri() != null) {
			where.append(" AND t1.TRISSIRCONNUMREGENTORI = ?");
			params.add(santramexp.getTrIsSirConNumRegEntOri());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Devuelve el numero de una secuencia
	 * 
	 * @return Integer
	 */
	public String currentValue() {
		String query = "SELECT L21U2Q00.CURRVAL FROM DUAL";
		List<Object> params = new ArrayList<Object>();
		Integer aux = this.jdbcTemplate.queryForInt(query.toString(), params.toArray());
		return new String(aux.toString());
	}

	/**
	 * Get a New PK.
	 * 
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long getNewPK() {
		try {
			List<Object> params = new ArrayList<Object>();

			StringBuffer query = new StringBuffer("SELECT L21U2Q00.NEXTVAL FROM  DUAL ");
			return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
		} catch (Exception e) {
			SantramexpDaoImpl.logger.debug(e.getMessage());
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Updates a single row in the TramiteHecho table.
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @return Santramexp
	 */
	public Santramexp updateIdNotificacionPlatea(Santramexp santramexp) {
		String query = "UPDATE SANTRAMEXP SET TRIDNOTIFPLATEA=? WHERE TRID=?";

		this.jdbcTemplate.update(query, santramexp.getTridnotifplatea(), santramexp.getTrid());
		return santramexp;
	}

	/**
	 * Finds a single row in the NotificacionAcuseRecibo table.
	 * 
	 * @param notificacionAcuseRecibo
	 *            NotificacionAcuseRecibo
	 * @return NotificacionAcuseRecibo
	 */
	@Transactional(readOnly = true)
	public NotificacionAcuseRecibo findNotificacionAcuseRecibo(NotificacionAcuseRecibo notificacionAcuseRecibo) {
		String query = "SELECT EHIDNOTIFICACIONPLATEA EHIDNOTIFICACIONPLATEA, EHCODIGOACUSE EHCODIGOACUSE, EHPCODIGO EHPCODIGO FROM NOTIFICACION_ACUSERECIBO WHERE EHIDNOTIFICACIONPLATEA = ?";

		List<NotificacionAcuseRecibo> notificacionAcuseReciboList = this.jdbcTemplate.query(query,
				this.rwMapNotificacionAcuseRecibo, notificacionAcuseRecibo.getEhidnotificacionplatea());
		return (NotificacionAcuseRecibo) DataAccessUtils.uniqueResult(notificacionAcuseReciboList);
	}

	/**
	 * Inserts a single row in the NotificacionAcuseRecibo table.
	 * 
	 * @param notificacionAcuseRecibo
	 *            NotificacionAcuseRecibo
	 * @return NotificacionAcuseRecibo
	 */
	public NotificacionAcuseRecibo addNotificacionAcuseRecibo(NotificacionAcuseRecibo notificacionAcuseRecibo) {
		String query = "INSERT INTO NOTIFICACION_ACUSERECIBO (EHIDNOTIFICACIONPLATEA, EHCODIGOACUSE, EHPCODIGO) VALUES (?,?,?)";
		this.jdbcTemplate.update(query, notificacionAcuseRecibo.getEhidnotificacionplatea(),
				notificacionAcuseRecibo.getEhcodigoacuse(), notificacionAcuseRecibo.getEhpcodigo());
		return notificacionAcuseRecibo;
	}

	/**
	 * Completa acuse recibo.
	 * 
	 * @param tramitehechoAcuse
	 *            the tramitehecho acuse
	 * @param situacionNotificacion
	 *            the situacion notificacion
	 * @param deliveredNotificationInfo
	 *            the delivered notification info
	 * @return the tramite hecho
	 * @throws Exception
	 *             the exception
	 */
	public Santramexp completaAcuseRecibo(Santramexp tramitehechoAcuse, String situacionNotificacion,
			DeliveredNotificationInfo deliveredNotificationInfo) throws Exception {
		try {
			SantramexpDaoImpl.logger.info("completaAcuseRecibo. Inicio");

			Date today = new Date();
			Date todayWithZeroTime = Y41bUtils.parseDate(today, new Locale(Y41bConstantes.CASTELLANO));

			SantramexpDaoImpl.logger.info("completaAcuseRecibo. Paso1: " + todayWithZeroTime + ".");
			tramitehechoAcuse.setTrfecfin(todayWithZeroTime);
			tramitehechoAcuse.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
			tramitehechoAcuse.setTrestadoacuse(situacionNotificacion);
			SantramexpDaoImpl.logger.info("completaAcuseRecibo. Paso2: " + todayWithZeroTime + ".");
			if (Y41bUtils.isFilled(deliveredNotificationInfo.getDeliveryTimestamp())) {
				try {
					SimpleDateFormat formatterAcuseRecibo = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
					Date dateAcuseRecibo = formatterAcuseRecibo.parse(deliveredNotificationInfo.getDeliveryTimestamp());
					SantramexpDaoImpl.logger.info("completaAcuseRecibo. Paso3: " + dateAcuseRecibo + ".");
					;
					tramitehechoAcuse.setTrfecacuse(dateAcuseRecibo);
				} catch (Exception e) {
					SantramexpDaoImpl.logger.error("Error producido al parsear la fecha del acuse: ", e);
					// Si falla el parseo meto la fecha de hoy
					tramitehechoAcuse.setTrfecacuse(todayWithZeroTime);
				}
			} else {
				tramitehechoAcuse.setTrfecacuse(todayWithZeroTime);
			}
			SantramexpDaoImpl.logger.info("completaAcuseRecibo. Paso4: ANTES DEL UPDATE.");
			this.update(tramitehechoAcuse);
			SantramexpDaoImpl.logger.info("completaAcuseRecibo. Fin");
			return tramitehechoAcuse;
		} catch (Exception e) {
			SantramexpDaoImpl.logger.error("completaAcuseRecibo. ERROR" + e.getMessage());
			throw e;

		} finally {
			SantramexpDaoImpl.logger.info("completaAcuseRecibo. Fin");
		}
	}

	/**
	 * Updates a single row in the TramiteHecho table.
	 * 
	 * @param tramitehecho
	 *            Pagination
	 * @return TramiteHecho
	 */
	public Santramexp updateMatarEspera(Santramexp tramitehecho) {
		String query = "UPDATE SANTRAMEXP SET TRMATARESPERA=? WHERE TRID=?";

		this.jdbcTemplate.update(query, tramitehecho.getTrmatarespera(), tramitehecho.getTrid());
		return tramitehecho;
	}

	/**
	 * Finds a single row in the Santramexp table.
	 * 
	 * @param santramexp
	 *            Pagination
	 * @return Santramexp
	 */
	@Transactional(readOnly = true)
	public Santramexp findFichaTramite(Santramexp santramexp) {
		String sqlCompleta = "";
		try {
			// String query =
			// TRTEXTO SE COGE EN OTRO METODO*/
			String query = "SELECT TRID, TRCODIGO, TREXCODIGO, TRFECINI, TRFECFIN, TRNOMTRAMES, TRMOCODIGO, TRMOCODIGOEJ, TRTRIDREL, TRFECACINI, TRRESULTADO, TRESTIMACION, TRRESOFECHA, TRRESOTIPO, TRRESOSAN, TRRESOIMPORTE, TRFECENVIO, TRFECCIERRE, TRFCODIGO, TRTIPONOT, TRTIPONOTPLATEA, TRESTADO, TRFECALTA, TRFECMODIF, TRUSUALTA, TRUSUMODIF, TRNUMDIAS, TRFECBOPV, TRFECINITABL, TRFECNOTIF, TRUAIDINTERV, TRCODIGOREL, TRIDNOTIFPLATEA, TRNUMREGE, TRFECREGS, TRFECREGE, TRTIPOCOM, TRESTADOACUSE, TRNUMREGS, TRFECACUSE, TRIDESPERAPLATEA, TRMATARESPERA, TRASUNTOCOMUNICACION, TRTIPONOTPLATEA, TRFECACUSE, TRFECNOTIF, TRSEDE, TRCODREM, TRENVREM, TRIDMAILORIGEN, TRMAILORIGEN,TRIDMAILDESTINO,TRMAILDESTINO,TRFECHAENVIOBOPVBOE,TRPROCEEDINGSIDPLATEA, TRIMPORTEINICIAL, TRFECSOLRED, TRPRONTOPAGO, TRRECONOCIMIENTO, "
					+ " TROBSERVES, TRTEXTO, TRACUSEREINTENTADO, TRAUTOMATICO, TRDESTORIGEN, TRRESPUESTA, TRRESUMENALEGACIONES, TRISTELEMATICA, TRISSIR, TRISSIRCONNUMREGENTORI, "
					// # INICIO #
					// ADAPTACIONES LEY 39 - COMUNICACION POSTAL INICIO AL
					// SANCIONADO
					+ " TRISCOMUNICACIONINICIO, "
					// # FIN #
					+ " TRISNOTIFICACIONINCOACION, "
					// EVOLUTIVO 0135083 2.4
					+ " TRDOCREQEUS, " + " t4.MONOMBRE MONOMBRE, t5.MONOMBRE MONOMBREEJ"
					+ " FROM SANTRAMEXP , CENSO_MONITOR t4, CENSO_MONITOR t5 "
					+ " WHERE 1=1 AND TRID = ? AND TRMOCODIGO = t4.MOCODIGO(+) AND TRMOCODIGOEJ = t5.MOCODIGO(+) ";

			Object[] params = { santramexp.getTrid().toString() };
			sqlCompleta = Y41bUtils.dameSQL(query, params);

			List<Santramexp> santramexpList = this.jdbcTemplate.query(query, this.rwMapFichaTramite,
					santramexp.getTrid().toString());
			Santramexp resultado = (Santramexp) DataAccessUtils.uniqueResult(santramexpList);
			return resultado;
		} catch (Exception e) {
			e.printStackTrace();
			SantramexpDaoImpl.logger
					.error("Error producido en find de Santramexpdaoimpl: " + e.getMessage() + sqlCompleta, e);
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Generar Tramite automatico de Acuse de Recibo.
	 * 
	 * @param exCodigo
	 *            the ex codigo
	 * @param fechaInicio
	 *            the fecha inicio
	 * @param censoMonitor
	 *            the censo monitor
	 * @param observaciones
	 *            the observaciones
	 * @return TramiteHecho
	 */

	public Santramexp generarTramiteAperturaoAutomatico(String exCodigo, Date fechaInicio, CensoMonitor censoMonitor,
			String observaciones) {
		try {
			Santramexp tramiteNuevo = new Santramexp();

			tramiteNuevo.setTrid(this.getNewPK().toString());
			tramiteNuevo.setExpedien(new Expedien(exCodigo));
			tramiteNuevo.setTrcodigo((Y41bConstantes.TRAMITE_SANCIONES_APERTURA));
			tramiteNuevo.setTrobserves(Y41bUtils.stringToClob(observaciones));
			tramiteNuevo.setTrfecini(fechaInicio);
			tramiteNuevo.setTrfecfin(fechaInicio);
			tramiteNuevo.setCensoMonitor(censoMonitor);
			tramiteNuevo.setCensoMonitorEj(censoMonitor);
			tramiteNuevo.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
			tramiteNuevo.setFase(new Fase(Y41bConstantes.FASE_REGISTRO_SANCION));

			// Se inserta el tramite
			this.add(tramiteNuevo);

			return tramiteNuevo;
		} catch (Exception e) {
			e.printStackTrace();
			SantramexpDaoImpl.logger.error("Error producido en generarTramiteAperturaoAutomatico: " + e.getMessage(),
					e);
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Updates a single row in the TramiteHecho table.
	 * 
	 * @param tramitehecho
	 *            Pagination
	 * @return TramiteHecho
	 */
	public Santramexp updateReferenciaLiquidacion(Santramexp tramitehecho) {
		String query = "UPDATE SANTRAMEXP SET TRREFERENCIA=? WHERE TRID=?";

		this.jdbcTemplate.update(query, tramitehecho.getTrreferencia(), tramitehecho.getTrid());
		return tramitehecho;
	}

	/**
	 * Finds a single row in the Santramexp table.
	 * 
	 * @param excodigo
	 *            the excodigo
	 * @return Santramexp
	 */
	@Transactional(readOnly = true)
	public Santramexp dameUltimoTramiteEnCurso(String excodigo) {
		try {

			String query2 = "SELECT TRID, TRCODIGO,  TRNOMTRAMES, TRNOMBRE, TRNOMBREE, TRFECINI, TRFECFIN, TRFCODIGO FROM (SELECT A.TRID,  A.TRCODIGO, A.TRNOMTRAMES, B.TRNOMBRE, B.TRNOMBREE, A.TRFECINI, A.TRFECFIN, A.TRFCODIGO FROM SANTRAMEXP A, TRAMITE B WHERE A.TRCODIGO = B.TRCODIGO AND A.TREXCODIGO = ? ORDER BY A.TRFECALTA DESC, A.TRID DESC)  WHERE ROWNUM = 1 ";
			List<Santramexp> santramexpList = this.jdbcTemplate.query(query2, this.rwMapTRID, excodigo);
			Santramexp resultado = (Santramexp) DataAccessUtils.uniqueResult(santramexpList);

			return resultado;

		} catch (Exception e) {
			e.printStackTrace();
			SantramexpDaoImpl.logger.error("Error producido en find de Santramexpdaoimpl: " + e.getMessage(), e);
			throw new Y41bUDAException("error.generico", true, e);
		}

	}

	/**
	 * Finds a single row in the Santramexp table.
	 * 
	 * @param excodigo
	 *            the excodigo
	 * @return Santramexp
	 */
	@Transactional(readOnly = true)
	public Santramexp dameUltimoTramiteTramitado(String excodigo) {
		try {

			String query2 = "SELECT MAX(TRID) AS TRID, '' TRCODIGO,  '' TRNOMTRAMES, '' TRNOMBRE, '' TRNOMBREE, '' TRFECINI, '' TRFECFIN, MAX(TRFCODIGO) AS TRFCODIGO FROM SANTRAMEXP WHERE TREXCODIGO = ?  AND TRESTADO='T'  ";
			List<Santramexp> santramexpList = this.jdbcTemplate.query(query2, this.rwMapTRID, excodigo);
			return (Santramexp) DataAccessUtils.uniqueResult(santramexpList);

		} catch (Exception e) {
			e.printStackTrace();
			SantramexpDaoImpl.logger.error("Error producido en find de Santramexpdaoimpl: " + e.getMessage(), e);
			throw new Y41bUDAException("error.generico", true, e);
		}

	}

	/**
	 * Finds a single row in the Santramexp table.
	 * 
	 * @param tipoTramite
	 *            the tipo tramite
	 * @return Santramexp
	 */

	public Date dameFechanotificacionTramite(String tipoTramite, String excodigo) {
		Santramexp tramite = new Santramexp();
		tramite.setExpedien(new Expedien(excodigo));
		tramite.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_NOTIFICACION);
		tramite.setTrcodigorel(tipoTramite);
		tramite.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		Pagination pagination = new Pagination();
		pagination.setSord("DESC");
		pagination.setSort("TRFECINI");
		List<Santramexp> listaTramite = this.findAll(tramite, pagination);
		if (listaTramite != null && listaTramite.size() > 0) {
			/* cojo el ultimo */
			tramite = listaTramite.get(0);
			return tramite.getTrfecnotif();
		} else {
			return null;
		}
	}

	/**
	 * Finds a single row in the Santramexp table.
	 * 
	 * @param tipoTramite
	 *            the tipo tramite
	 * @return Santramexp
	 */

	public Date dameFechaAcuseTramite(String tipoTramite, String excodigo) {
		Santramexp tramite = new Santramexp();
		tramite.setExpedien(new Expedien(excodigo));
		tramite.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_NOTIFICACION);
		tramite.setTrcodigorel(tipoTramite);
		tramite.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		Pagination pagination = new Pagination();
		pagination.setSord("DESC");
		pagination.setSort("TRFECINI");
		List<Santramexp> listaTramite = this.findAll(tramite, pagination);
		if (listaTramite != null && listaTramite.size() > 0) {
			/* cojo el ultimo */
			tramite = listaTramite.get(0);
			Santramexp tramite2 = new Santramexp();
			tramite2.setExpedien(new Expedien(excodigo));
			tramite2.setTrcodigo(Y41bConstantes.TRAMITE_SANCIONES_ACUSERECIBO);
			tramite2.setTrtridrel(tramite.getTrid());
			tramite2.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
			listaTramite = this.findAll(tramite2, pagination);
			if (listaTramite != null && listaTramite.size() > 0) {
				tramite = listaTramite.get(0);
				if (Y41bConstantes.ESTADO_ACUSE_ACEPTADO.equalsIgnoreCase(tramite.getTrestadoacuse())
						|| Y41bConstantes.ESTADO_ACUSE_RECHAZADO.equalsIgnoreCase(tramite.getTrestadoacuse())) {
					return tramite.getTrfecacuse();
				} else {
					return null;
				}
			} else {
				return null;
			}
		} else {
			return null;
		}
	}

	/**
	 * Dame tramite por tipo.
	 * 
	 * @param trcodigo
	 *            the trcodigo
	 * @param excodigo
	 *            the excodigo
	 * @return the santramexp
	 */
	public Santramexp dameTramitePorTipo(String trcodigo, String excodigo) {
		Santramexp tramite = new Santramexp();
		tramite.setTrcodigo(trcodigo);
		tramite.setExpedien(new Expedien(excodigo));
		Pagination pagination = new Pagination();
		pagination.setSord("DESC");
		pagination.setSort("TRFECINI");
		List<Santramexp> listaTramite = this.findAll(tramite, pagination);
		if (listaTramite != null && listaTramite.size() > 0) {
			/* cojo el ultimo */
			return listaTramite.get(0);
		} else {
			return null;
		}
	}

	/**
	 * Finds a single row in the TramiteHecho table.
	 * 
	 * @param tramiteHecho
	 *            TramiteHecho
	 * @return TramiteHecho
	 */
	@Transactional(readOnly = true)
	public List<NotificacionesComunicacionesBusqueda> findBlobTablaDocumentosHecho(
			NotificacionesComunicacionesBusqueda notifiComuni) {
		try {
			String query = "SELECT T2.TRCODREM DHCODREM, T2.TRID DHTRCODIGO, T1.U5CODOCUMENTO DHCODDOC, T1.U5DATAFILE DHDATAFILE, NULL DHFECHA, T1.U5IDDOCUMENTUM "
					+ " FROM SANDOCTEMP T1, SANTRAMEXP T2, SANDOCTRAMITE T3 WHERE T3.EHCODIGO = T2.TRID AND T3.TRPCODIGO=? AND T1.U5CODOCUMENTO = T3.CODOCUMENTO AND T2.TRCODREM = ?";

			return (List<NotificacionesComunicacionesBusqueda>) this.jdbcTemplate.query(query.toString(),
					new RowMapper<NotificacionesComunicacionesBusqueda>() {
						public NotificacionesComunicacionesBusqueda mapRow(ResultSet resultSet, int rowNum)
								throws SQLException {
							return new NotificacionesComunicacionesBusqueda(resultSet.getString("DHCODREM"),
									resultSet.getString("DHTRCODIGO"), resultSet.getString("DHCODDOC"),
									resultSet.getBlob("DHDATAFILE"), resultSet.getString("U5IDDOCUMENTUM"));
						}
					}, notifiComuni.getRmtipoExpediente(), notifiComuni.getRmcodigo());

		} catch (EmptyResultDataAccessException e) {
			return null;
		}
	}

	/**
	 * Updates a single row in the TramiteHecho table.
	 * 
	 * @param tramite
	 *            Santramexp
	 * @return Santramexp
	 */
	public Santramexp updateProceedingsIdPlatea(Santramexp tramite) {
		String query = "UPDATE SANTRAMEXP SET TRPROCEEDINGSIDPLATEA=? WHERE TRID=?";

		this.jdbcTemplate.update(query, tramite.getTrproceedingsidplatea(), tramite.getTrid());
		return tramite;
	}

	/**
	 * Updates a single row in the TramiteHecho table.
	 * 
	 * @param tramite
	 *            Santramexp
	 * @return Santramexp
	 */
	public Santramexp updateRegistroSalidaPlatea(Santramexp tramite) {
		String query = "UPDATE SANTRAMEXP SET TRNUMREGS=?, TRFECREGS=? WHERE TRID=?";

		this.jdbcTemplate.update(query, tramite.getTrnumregs(), tramite.getTrfecregs(), tramite.getTrid());
		return tramite;
	}

	/**
	 * Finds a List of rows in the TramiteHecho table.
	 * 
	 * @param notificacionComunicacionDetalle
	 *            NotificacionesComunicacionesBusqueda
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<NotificacionesComunicacionesBusqueda> findAllNotifiComuni(
			NotificacionesComunicacionesBusqueda notificacionComunicacionDetalle, Pagination pagination) {
		// Nota: en la sql idtramite es el codigo del expediente y codexpediente
		// es el id del tramite
		StringBuilder query = new StringBuilder(
				"SELECT " + "t1.TRID, " + "T4.EXCOOR||' '||T4.EXNRAN||' '||T4.EXNROR idTramite, " + "T4.EXCOOR, "
						+ "T4.EXNRAN, " + "T4.EXNROR, " + "T4.EXCODIGO, " + "T1.TRID CODEXPEDIENTE, " + "T1.TRFECINI, "
						+ "T1.TRFECINI EHFECHAINICIO, " + "T1.TRNUMREGS EHNUMREGISTROSALIDA, "
						// + "T1.TRASUNTOCOMUNICACION ASUNTO, "
						// + "T1.TRASUNTOCOMUNICACION ACTO, "
						+ "T9.TRESTADO EHESTADOTRAMITE, " + "T1.TRTIPONOTPLATEA ACTO, " + "T1.TRUAIDINTERV UAIDINTERV, "
						+ "T1.TRUAIDINTERV AS EHIDDESTINATARIO, " + "T1.TRMOCODIGOEJ, "
						+ "T1.TRTIPONOTPLATEA EHTIPONOTIFICACIONPLATEA, " + "T2.UANOMBRE UANOMBRE, T2.UANIF NIF, "
						+ "TRIM(T2.UANOMBRE ||' '||T2.UAAPELLIDO1||' '||T2.UAAPELLIDO2) AS NOMBREDESTINATARIO, "
						+ "T2.UANOCO AS NOMBRECOMERCIALDESTINATARIO, " + "T2.UACP_ID AS NOMBRE_CP, "
						+ "(SELECT DS_O FROM T17I.T17_PROVINCIA WHERE T2.UAPROV_ID = ID) AS NOMBRE_PROVINCIA, "
						+ "(SELECT DS_O FROM T17I.T17_MUNICIPIO WHERE T2.UAPROV_ID = PROVINCIA_ID AND T2.UAMUN_ID = ID) AS NOMBRE_MUNICIPIO, "
						+ "(SELECT DS_O FROM T17I.T17_LOCALIDAD WHERE T2.UALOC_ID = ID) AS NOMBRE_LOCALIDAD, "
						+ "(SELECT TIPO_VIA||' '||DS_O FROM T17I.T17_CALLE WHERE T2.UACALLE_ID = ID) AS NOMBRE_CALLE, "
						+ "(SELECT NUMERO||(CASE WHEN BIS IS NULL THEN '' ELSE '-' || BIS END) FROM T17I.T17_PORTAL WHERE T2.UAPORTAL_ID = ID) AS NOMBREPORTAL, "
						+ "T2.UANOMBRE_PISO AS NOMBREPISO, "
						+ "(SELECT DS_O FROM T17I.T17_PAIS WHERE T2.UAPAIS_ID = ID) AS NOMBREPAIS, "
						+ "((SELECT TIPO_VIA||' '||DS_O FROM T17I.T17_CALLE WHERE T2.UACALLE_ID = ID)||' '||(SELECT NUMERO||(CASE WHEN BIS IS NULL THEN '' ELSE '-' || BIS END) FROM T17I.T17_PORTAL WHERE T2.UAPORTAL_ID = ID)) AS DIRECCION1, "
						+ "T2.UACP_ID||' '||(SELECT DS_O FROM T17I.T17_LOCALIDAD WHERE T2.UALOC_ID = ID) AS DIRECCION2, "
						+ "T2.UADIRE_NOCAPV AS DIRECCIONNOCAPV, " + "T2.UADIRE_ANT AS DIRECCIONANTIGUA, "
						+ "DECODE(T2.UAPAIS_ID," + Y41bConstantes.COD_PAIS_ESTADO + ",'" + Y41bConstantes.NO + "','"
						+ Y41bConstantes.SI + "') AS EXTRANJERO, " + "T1.TRSEDE EHSEDE, " + "T2.UAESCODIGO ESCODIGO, "
						+ "T5.MONOMBRE MONOMBRE, T1.TRASUNTOCOMUNICACION, "

						+ " T7.COD_ORG CODORG, T7.NOMBRE_ES NOMBREES, T7.NOMBRE_EU NOMBREEU,  T7.NORA_PROVINCIA_ID NORAPROVINCIAID, T7.NOMBRE_PROVINCIA NOMBREPROVINCIAORG, T7.NORA_MUNICIPIO_ID NORAMUNICIPIOID, T7.NOMBRE_MUNICIPIO NOMBREMUNICIPIOORG, "
						+ " T7.NORA_LOCALIDAD_ID NORALOCALIDADID, T7.NOMBRE_LOCALIDAD NOMBRELOCALIDADORG, T7.NORA_CALLE_ID NORACALLEID, T7.NOMBRE_CALLE NOMBRECALLEORG, T7.NORA_CP_ID NORACPID, T7.NOMBRE_CP NOMBRECPORG, T7.NORA_PORTAL_ID NORAPORTALID, "
						+ " T7.NOMBRE_PORTAL NOMBREPORTALORG, T7.TELEFONO TELEFONOORGANISMO, T7.FAX FAXORGANISMO, T7.EMAIL EMAILORGANISMO, T7.URL WEBORGANISMO, "
						+ " T1.TRCODIGO TRCODIGO, T1.TRID EHCODIGO, T2.UATIPOINTERV TIPOINTERVINIENTE, T5.USUARIOXLNET USUARIOXLNET, T5.PUESTOXLNET PUESTOXLNET, "
						+ " T8.ENVCESTADO ENVCESTADO, T8.ENVCDESERRORES ENVCDESERRORES, T8.ENVCDESERROREU ENVCDESERROREU, T8.ENVC_ID_ENVIO ENVCIDENVIO, T8.ENVCCOD_SIT_CORREOS ENVCCODSITCORREOS, T8.ENVCDES_SIT_CORREOS_ES ENVCDESSITCORREOSES, T8.ENVCDES_SIT_CORREOS_EU ENVCDESSITCORREOSEU, "
						+ " T8.ENVFECHAACTUALIZACION ENVFECHAACTUALIZACION,T8.ENVCCODBARRAS ENVCCODBARRAS, "
						+ " T9.TRID IDTRAMITEACUSERELACIONADO, T9.TRESTADOACUSE EHACUSERECIBORECIBIDO");

		StringBuilder from = new StringBuilder(
				" FROM SANTRAMEXP T1, SANINTERV T2, SANEXP T3, EXPEDIEN T4, CENSO_MONITOR T5, ORGANISMO T7, ENVIOS_POR_REMESA T8, SANTRAMEXP T9 ");

		query.append(from);

		Map<String, ?> mapaWhere = this.getWhereMapNotifiComunica(notificacionComunicacionDetalle);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND T1.TRUAIDINTERV=T2.UAIDINTERV AND T3.EXCODIGO = T1.TREXCODIGO AND T3.EXCODIGO = T4.EXCODIGO AND T1.TRMOCODIGOEJ = T5.MOCODIGO AND t4.EXCOOR= t7.COD_ORG  AND T1.TRCODIGO IN ('"
						+ Y41bConstantes.TRAMITE_SANCIONES_NOTIFICACION + "','"
						+ Y41bConstantes.TRAMITE_SANCIONES_COMUNICACION + "') "
						+ " AND to_char(T1.TRID) = T8.EHCODIGO(+) "
						+ "AND T1.TRID = T9.TRTRIDREL(+) AND t9.TRCODIGO(+) = '"
						+ Y41bConstantes.TRAMITE_SANCIONES_ACUSERECIBO + "' ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<NotificacionesComunicacionesBusqueda>) this.jdbcTemplate.query(query.toString(),
				this.rwMapNotifiComunica, params.toArray());
	}

	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMapNotifiComunica(
			NotificacionesComunicacionesBusqueda notificacionComunicacionDetalle) {

		StringBuilder where = new StringBuilder(SantramexpDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (notificacionComunicacionDetalle != null && notificacionComunicacionDetalle.getRmcodigo() == null) {
			where.append(" AND T1.TRENVREM=? ");
			params.add(Y41bConstantes.SI);

			where.append(" AND T1.TRESTADO=? ");
			params.add(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

			where.append(" AND T1.TRCODREM IS NULL ");
		}
		if (notificacionComunicacionDetalle != null && notificacionComunicacionDetalle.getRmcodigo() != null) {
			where.append(" AND T1.TRCODREM = ? ");
			params.add(notificacionComunicacionDetalle.getRmcodigo());

		}
		if (notificacionComunicacionDetalle.getRmtipo() != null
				&& notificacionComunicacionDetalle.getModoRemesa() != null
				&& notificacionComunicacionDetalle.getModoRemesa().equalsIgnoreCase(Y41bConstantes.MODO_POPUP_ALTA)) {
			String tipo = notificacionComunicacionDetalle.getRmtipo();
			if (tipo.contains(Y41bConstantes.TRAMITE_NOTIFICACION)) {
				if (notificacionComunicacionDetalle.isCompatibleAA66()) {
					if (tipo.equalsIgnoreCase(Y41bConstantes.TRAMITE_NOTIFICACION_ELECTRONICA)) {
						where.append(" AND (T2.UAPAIS_ID IS NULL OR T2.UAPAIS_ID = '");
						where.append(Y41bConstantes.COD_PAIS_ESTADO);
						where.append("')");
					} else {
						where.append(" AND T2.UAPAIS_ID<> '");
						where.append(Y41bConstantes.COD_PAIS_ESTADO);
						where.append("' ");
					}
				}
				tipo = Y41bConstantes.TRAMITE_NOTIFICACION;
			}
			where.append(" AND T1.TRCODIGO = '");
			if (tipo.equals(Y41bConstantes.TRAMITE_COMUNICACION)) {
				where.append(Y41bConstantes.TRAMITE_SANCIONES_COMUNICACION);
			} else if (tipo.equals(Y41bConstantes.TRAMITE_NOTIFICACION)) {
				where.append(Y41bConstantes.TRAMITE_SANCIONES_NOTIFICACION);
			} else if (tipo.equalsIgnoreCase(Y41bConstantes.TRAMITE_NOTIFICACION_ELECTRONICA)) {
				where.append(Y41bConstantes.TRAMITE_SANCIONES_NOTIFICACION);
			}
			where.append("'");
		}

		if (notificacionComunicacionDetalle != null && notificacionComunicacionDetalle.isRmcapv() != null) {
			where.append(" AND T2.UAPROV_ID IN ('48','01','20') ");
		}
		if (notificacionComunicacionDetalle != null
				/* && notificacionComunicacionDetalle.getRmorganico() != null */
				&& !Y41bUtils.esNullOCadenaVacia(notificacionComunicacionDetalle.getRmorganico())) {
			where.append(" AND T3.EXCOORACTUAL = ? ");
			params.add(notificacionComunicacionDetalle.getRmorganico());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	/**
	 * Counts rows in the TramiteHecho table.
	 * 
	 * @param notificacionComunicacionDetalle
	 *            NotificacionesComunicacionesBusqueda
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllNotifiComuniCount(NotificacionesComunicacionesBusqueda notificacionComunicacionDetalle) {

		StringBuilder query = new StringBuilder("SELECT COUNT(1) ");

		StringBuilder from = new StringBuilder(
				" FROM SANTRAMEXP T1, SANINTERV T2, SANEXP T3, EXPEDIEN T4, CENSO_MONITOR T5 ");

		query.append(from);

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMapNotifiComunica(notificacionComunicacionDetalle);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND T1.TRUAIDINTERV=T2.UAIDINTERV AND T3.EXCODIGO = T1.TREXCODIGO AND T3.EXCODIGO = T4.EXCODIGO AND T1.TRMOCODIGOEJ = T5.MOCODIGO AND T1.TRCODIGO IN ('"
						+ Y41bConstantes.TRAMITE_SANCIONES_NOTIFICACION + "','"
						+ Y41bConstantes.TRAMITE_SANCIONES_COMUNICACION + "') ");

		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/*
	 * 
	 * @param santramexp the santramexp
	 */
	public void set(Santramexp santramexp) {

		if (!this.exists(santramexp)) {
			this.add(santramexp);
		} else {
			this.update(santramexp);
		}

	}

	/**
	 * Finds a single row in the Santramexp table.
	 * 
	 * @param santramexp
	 *            Pagination
	 * @return Santramexp
	 */
	@Transactional(readOnly = true)
	public boolean exists(Santramexp santramexp) {
		try {
			String query = "SELECT COUNT(1) FROM SANTRAMEXP WHERE 1=1 AND TRID = ?";

			List<String> params = new ArrayList<String>();
			if (santramexp.getTrid() == null) {
				return false;
			}
			params.add(santramexp.getTrid().toString());

			Long numResultado = this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
			if (numResultado == null) {
				return false;
			} else {
				return numResultado > 0;
			}

		} catch (Exception e) {
			e.printStackTrace();
			logger.error("Error producido en find de Santramexpdaoimpl: " + e.getMessage(), e);
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Mtodo para actualizar el reintento del acuse
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @return Santramexp
	 */
	public Santramexp updateAcuseReintentado(Santramexp santramexp) {
		String query = "UPDATE SANTRAMEXP SET TRACUSEREINTENTADO=? WHERE TRID=?";

		this.jdbcTemplate.update(query, santramexp.getTracusereintentado(), santramexp.getTrid());
		return santramexp;
	}

	/**
	 * Updates a single row in the SANTRAMEXP table.
	 * 
	 * @param tramitehecho
	 *            Pagination
	 * @return TramiteHecho
	 */
	public Santramexp updateRemesa(Santramexp santramexp) {
		String query = "UPDATE SANTRAMEXP SET TRCODREM=? WHERE TRID=?";

		this.jdbcTemplate.update(query, santramexp.getTrcodrem(), santramexp.getTrid().toString());
		return santramexp;
	}

	/**
	 * 
	 * @param codRemesa
	 */
	public void removeRemesaFromTramites(String codRemesa) {

		String query = "UPDATE SANTRAMEXP SET TRCODREM = NULL WHERE TRCODREM=?";

		this.jdbcTemplate.update(query, codRemesa);

	}

	/**
	 * Updates a single row in the Santramexp table.
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @return Santramexp
	 */
	public Santramexp updateReabrirTramite(Santramexp santramexp) {
		String query = "UPDATE SANTRAMEXP SET TRESTADO=?, TRFECFIN=null, TRMOCODIGOEJ=null WHERE TRID=?";

		this.jdbcTemplate.update(query, santramexp.getTrestado(), santramexp.getTrid());
		return santramexp;
	}

	/**
	 * Updates a single row in the TramiteHecho table.
	 * 
	 * @param santramexp
	 *            Pagination
	 * @return Santramexp
	 */
	public Santramexp updateDenegacionTramite(Santramexp santramexp) {
		String query = "UPDATE SANTRAMEXP SET TROBSERVES=?,TRESTADO=? WHERE TRID=?";

		this.jdbcTemplate.update(query, Y41bUtils.clobToString(santramexp.getTrobserves()), santramexp.getTrestado(),
				santramexp.getTrid());
		return santramexp;
	}

	/**
	 * Updates a single row in the TramiteHecho table.
	 * 
	 * @param santramexp
	 *            Pagination
	 * @return Santramexp
	 */
	public Santramexp updateCensoMonitorNoTramitados(Santramexp santramexp) {
		String query = "UPDATE SANTRAMEXP SET TRMOCODIGO=? WHERE TREXCODIGO=? AND TRESTADO!='T'";

		this.jdbcTemplate.update(query, santramexp.getCensoMonitor().getMocodigo(),
				santramexp.getExpedien().getExcodigo());
		return santramexp;
	}

	/**
	 * Finds a single row in the Santramexp table.
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @return Santramexp
	 */
	@Transactional(readOnly = true)
	public Santramexp findUltimoTramiteExpedientePorTipoTramite(Santramexp santramexp) {
		try {
			String query2 = "SELECT TRID, TRCODIGO,  TRNOMTRAMES, TRNOMBRE, TRNOMBREE, TRFECINI,TRFECFIN,TRFCODIGO FROM (SELECT A.TRID,  A.TRCODIGO, A.TRNOMTRAMES, B.TRNOMBRE, B.TRNOMBREE, A.TRFECINI, A.TRFECFIN, A.TRFCODIGO  FROM SANTRAMEXP A, TRAMITE B WHERE A.TRCODIGO = B.TRCODIGO AND A.TREXCODIGO = ? AND A.TRCODIGO=? ORDER BY A.TRFECALTA DESC, A.TRID DESC)  WHERE ROWNUM = 1 ";
			List<Santramexp> santramexpList = this.jdbcTemplate.query(query2, this.rwMapTRID,
					santramexp.getExpedien().getExcodigo(), santramexp.getTrcodigo());
			Santramexp resultado = (Santramexp) DataAccessUtils.uniqueResult(santramexpList);

			return resultado;
		} catch (EmptyResultDataAccessException e) {
			return new Santramexp();
		}
	}

	public void removeRemesaFromTramitesByEhcodigo(String trcodigo) {

		String query = "UPDATE SANTRAMEXP SET trcodrem = NULL WHERE trid=?";

		this.jdbcTemplate.update(query, trcodigo);

	}

	/**
	 * Get a New PK. Proceedings Platea
	 * 
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long getNewPKProceedingsPlatea() {
		try {
			List<Object> params = new ArrayList<Object>();

			StringBuffer query = new StringBuffer("SELECT SEQ_L21U2Q01.NEXTVAL FROM  DUAL ");
			return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
		} catch (Exception e) {
			SantramexpDaoImpl.logger.debug(e.getMessage());
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Finds a single row in the Santramexp table.
	 * 
	 * @param notifiComuni
	 *            NotificacionesComunicacionesBusqueda
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findSumSizeBlobNotifiComuni(NotificacionesComunicacionesBusqueda notifiComuni) {

		String query = "SELECT SUM(T1.U5SIZEFILE) TAMANO "
				+ " FROM SANDOCTEMP T1, SANTRAMEXP T2, SANDOCTRAMITE T3 WHERE T3.EHCODIGO = T2.TRID AND T3.TRPCODIGO=? AND T1.U5CODOCUMENTO = T3.CODOCUMENTO AND T2.TRCODREM = ? ";

		List<Object> params = new ArrayList<Object>();
		params.add(notifiComuni.getRmtipoExpediente());
		params.add(notifiComuni.getRmcodigo());

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

}
