package com.ejie.y41b.dao;

//import java.math.BigDecimal;
import java.util.*;

import org.springframework.transaction.annotation.Transactional;

import com.ejie.horizontalSystemOfNotification.xml.DeliveredNotificationInfoDocument.DeliveredNotificationInfo;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.*;

/**
 * SantramexpDao  
 * 
 *  
 */

public interface SantramexpDao {

	/**
	 * Inserts a single row in the Santramexp table.
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @return Santramexp
	 */
	Santramexp add(Santramexp santramexp);

	/**
	 * Updates a single row in the Santramexp table.
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @return Santramexp
	 */
	Santramexp update(Santramexp santramexp);

	/**
	 * Finds a single row in the Santramexp table.
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @return Santramexp
	 */
	Santramexp find(Santramexp santramexp);

	/**
	 * Finds a single row in the Santramexp table.
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @return Santramexp
	 */
	Santramexp findUltimoTramiteConFase(Santramexp santramexp);

	/**
	 * Finds a single row in the Santramexp table.
	 * 
	 * @param idExpediente
	 *            the id expediente
	 * @return Santramexp
	 */
	Santramexp findUltimoCerradoResolucionComplementaria(String idExpediente);

	/**
	 * Deletes a single row in the Santramexp table.
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @return
	 */
	void remove(Santramexp santramexp);

	/**
	 * Finds a List of rows in the Santramexp table.
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Santramexp> findAll(Santramexp santramexp, Pagination pagination);

	/**
	 * Counts rows in the Santramexp table.
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @return Long
	 */
	Long findAllCount(Santramexp santramexp);

	/**
	 * Finds rows in the Santramexp table using like.
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Santramexp> findAllLike(Santramexp santramexp, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Santramexp table using like.
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Santramexp santramexp, Boolean startsWith);

	/**
	 * 
	 * @return Integer
	 */
	public String currentValue();

	/**
	 * Get a New PK.
	 * 
	 * @return Long
	 */
	Long getNewPK();

	/**
	 * Updates a single row in the TramiteHecho table.
	 * 
	 * @param tramitehecho
	 *            Pagination
	 * @return TramiteHecho
	 */
	public Santramexp updateIdNotificacionPlatea(Santramexp tramitehecho);

	/**
	 * Finds a single row in the NotificacionAcuseRecibo table.
	 * 
	 * @param notificacionAcuseRecibo
	 *            NotificacionAcuseRecibo
	 * @return NotificacionAcuseRecibo
	 */
	@Transactional(readOnly = true)
	public NotificacionAcuseRecibo findNotificacionAcuseRecibo(
			NotificacionAcuseRecibo notificacionAcuseRecibo);

	/**
	 * Inserts a single row in the NotificacionAcuseRecibo table.
	 * 
	 * @param notificacionAcuseRecibo
	 *            NotificacionAcuseRecibo
	 * @return NotificacionAcuseRecibo
	 */
	public NotificacionAcuseRecibo addNotificacionAcuseRecibo(
			NotificacionAcuseRecibo notificacionAcuseRecibo);

	/**
	 * Completa acuse recibo.
	 * 
	 * @param tramitehechoAcuse
	 *            the tramitehecho acuse
	 * @param situacionNotificacion
	 *            the situacion notificacion
	 * @param deliveredNotificationInfo
	 *            the delivered notification info
	 * @return the tramite hecho
	 * @throws Exception
	 *             the exception
	 */
	public Santramexp completaAcuseRecibo(Santramexp tramitehechoAcuse,
			String situacionNotificacion,
			DeliveredNotificationInfo deliveredNotificationInfo)
			throws Exception;

	/**
	 * Updates a single row in the TramiteHecho table.
	 * 
	 * @param tramitehecho
	 *            Pagination
	 * @return TramiteHecho
	 */
	public Santramexp updateMatarEspera(Santramexp tramitehecho);

	/**
	 * Finds a single row in the Santramexp table.
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @return Santramexp
	 */
	Santramexp findFichaTramite(Santramexp santramexp);

	/**
	 * Generar Tramite automatico de Acuse de Recibo.
	 * 
	 * @param exCodigo
	 *            the ex codigo
	 * @param fechaInicio
	 *            the fecha inicio
	 * @param censoMonitor
	 *            the censo monitor
	 * @param observaciones
	 *            the observaciones
	 * @return TramiteHecho
	 */

	public Santramexp generarTramiteAperturaoAutomatico(String exCodigo,
			Date fechaInicio, CensoMonitor censoMonitor, String observaciones);

	/**
	 * 
	 * @param tramitehecho
	 *            Santramexp
	 * @return Santramexp
	 */
	Santramexp updateReferenciaLiquidacion(Santramexp tramitehecho);

	/**
	 * Finds a single row in the Santramexp table.
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @return Santramexp
	 */
	Santramexp dameUltimoTramiteEnCurso(String excodigo);

	/**
	 * Finds a single row in the Santramexp table.
	 * 
	 * @param excodigo
	 *            the excodigo
	 * @return Santramexp
	 */
	public Santramexp dameUltimoTramiteTramitado(String excodigo);

	/**
	 * Finds a single row in the Santramexp table.
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @return Santramexp
	 */

	public Date dameFechanotificacionTramite(String tipoTramite, String excodigo);

	/**
	 * Finds a single row in the Santramexp table.
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @return Santramexp
	 */

	public Date dameFechaAcuseTramite(String tipoTramite, String excodigo);

	/**
	 * Dame tramite por tipo.
	 * 
	 * @param trcodigo
	 *            the trcodigo
	 * @return the santramexp
	 */
	public Santramexp dameTramitePorTipo(String trcodigo, String excodigo);

	/**
	 * Updates a single row in the TramiteHecho table.
	 * 
	 * @param tramite
	 *            Santramexp
	 * @return Santramexp
	 */
	public Santramexp updateProceedingsIdPlatea(Santramexp tramite);

	/**
	 * Updates a single row in the TramiteHecho table.
	 * 
	 * @param tramite
	 *            Santramexp
	 * @return Santramexp
	 */
	public Santramexp updateRegistroSalidaPlatea(Santramexp tramite);

	/**
	 * Finds a List of rows in the TramiteHecho table.
	 * 
	 * @param notificacionComunicacionDetalle
	 *            NotificacionesComunicacionesBusqueda
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<NotificacionesComunicacionesBusqueda> findAllNotifiComuni(
			NotificacionesComunicacionesBusqueda notificacionComunicacionDetalle,
			Pagination pagination);

	/**
	 * Counts rows in the TramiteHecho table.
	 * 
	 * @param notificacionComunicacionDetalle
	 *            NotificacionesComunicacionesBusqueda
	 * @return Long
	 */
	public Long findAllNotifiComuniCount(
			NotificacionesComunicacionesBusqueda notificacionComunicacionDetalle);

	/**
	 * Finds a single row in the TramiteHecho table.
	 * 
	 * @param tramiteHecho
	 *            TramiteHecho
	 * @return TramiteHecho
	 */
	@Transactional(readOnly = true)
	public List<NotificacionesComunicacionesBusqueda> findBlobTablaDocumentosHecho(
			NotificacionesComunicacionesBusqueda notifiComuni);

	/**
	 * Sets the.
	 * 
	 * @param santramexp
	 *            the santramexp
	 */
	public void set(Santramexp santramexp);

	/**
	 * updateRemesa
	 * 
	 * @param santramexp
	 * @return
	 */
	public Santramexp updateRemesa(Santramexp santramexp);

	/**
	 * 
	 * @param codRemesa
	 */
	public void removeRemesaFromTramites(String codRemesa);

	/**
	 * Updates a single row in the Santramexp table.
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @return Santramexp
	 */
	public Santramexp updateReabrirTramite(Santramexp santramexp);

	/**
	 * @param santramexp
	 * @return
	 */
	Santramexp updateDenegacionTramite(Santramexp santramexp);

	/**
	 * @param santramexpTram
	 * @return
	 */
	Santramexp updateCensoMonitorNoTramitados(Santramexp santramexpTram);

	/**
	 * @param santramexp
	 * @return
	 */
	Santramexp findUltimoTramiteExpedientePorTipoTramite(Santramexp santramexp);

	/**
	 * 
	 * @param trcodigo
	 *            String
	 */
	void removeRemesaFromTramitesByEhcodigo(String trcodigo);

	/**
	 * Get a New PK. Proceedings Platea
	 * 
	 * @return Long
	 */
	Long getNewPKProceedingsPlatea();

	/**
	 * Finds a single row in the Arbtramexp table.
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @return boolean
	 */
	boolean exists(Santramexp santramexp);

	/**
	 * Mtodo para actualizar el reintento del acuse
	 * 
	 * @param tramitehecho
	 *            Santramexp
	 * @return Santramexp
	 */
	Santramexp updateAcuseReintentado(Santramexp tramitehecho);

	/**
	 * Finds a single row in the Santramexp table.
	 * 
	 * @param notifiComuni
	 *            NotificacionesComunicacionesBusqueda
	 * @return Long
	 */
	public Long findSumSizeBlobNotifiComuni(
			NotificacionesComunicacionesBusqueda notifiComuni);
}
