package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Santipsanacc;

/**
 * SantipsanaccDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class SantipsanaccDaoImpl implements SantipsanaccDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Santipsanacc> rwMap = new RowMapper<Santipsanacc>() {
		public Santipsanacc mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Santipsanacc(resultSet.getLong("TAID"),
					resultSet.getString("TADESCES"),
					resultSet.getString("TADESCEU"),
					resultSet.getDate("TAFECALTA"),
					resultSet.getDate("TAFECMODIF"),
					resultSet.getString("TAUSUALTA"),
					resultSet.getString("TAUSUMODIF"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Santipsanacc table.
	 * 
	 * @param santipsanacc
	 *            Pagination
	 * @return Santipsanacc
	 */
	public Santipsanacc add(Santipsanacc santipsanacc) {
		String query = "INSERT INTO SANTIPSANACC (TAID, TADESCES, TADESCEU, TAFECALTA, TAFECMODIF, TAUSUALTA, TAUSUMODIF) VALUES (?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, santipsanacc.getTaid(),
				santipsanacc.getTadesces(), santipsanacc.getTadesceu(),
				santipsanacc.getTafecalta(), santipsanacc.getTafecmodif(),
				santipsanacc.getTausualta(), santipsanacc.getTausumodif());
		return santipsanacc;
	}

	/**
	 * Updates a single row in the Santipsanacc table.
	 * 
	 * @param santipsanacc
	 *            Pagination
	 * @return Santipsanacc
	 */
	public Santipsanacc update(Santipsanacc santipsanacc) {
		String query = "UPDATE SANTIPSANACC SET TADESCES=?, TADESCEU=?, TAFECALTA=?, TAFECMODIF=?, TAUSUALTA=?, TAUSUMODIF=? WHERE TAID=?";
		this.jdbcTemplate.update(query, santipsanacc.getTadesces(),
				santipsanacc.getTadesceu(), santipsanacc.getTafecalta(),
				santipsanacc.getTafecmodif(), santipsanacc.getTausualta(),
				santipsanacc.getTausumodif(), santipsanacc.getTaid());
		return santipsanacc;
	}

	/**
	 * Finds a single row in the Santipsanacc table.
	 * 
	 * @param santipsanacc
	 *            Pagination
	 * @return Santipsanacc
	 */
	@Transactional(readOnly = true)
	public Santipsanacc find(Santipsanacc santipsanacc) {
		String query = "SELECT t1.TAID TAID, t1.TADESCES TADESCES, t1.TADESCEU TADESCEU, t1.TAFECALTA TAFECALTA, t1.TAFECMODIF TAFECMODIF, t1.TAUSUALTA TAUSUALTA, t1.TAUSUMODIF TAUSUMODIF FROM SANTIPSANACC t1  WHERE t1.TAID = ?  ";

		List<Santipsanacc> santipsanaccList = this.jdbcTemplate.query(query,
				this.rwMap, santipsanacc.getTaid());
		return (Santipsanacc) DataAccessUtils.uniqueResult(santipsanaccList);
	}

	/**
	 * Removes a single row in the Santipsanacc table.
	 * 
	 * @param santipsanacc
	 *            Pagination
	 * @return
	 */
	public void remove(Santipsanacc santipsanacc) {
		String query = "DELETE FROM SANTIPSANACC WHERE TAID=?";
		this.jdbcTemplate.update(query, santipsanacc.getTaid());
	}

	/**
	 * Finds a List of rows in the Santipsanacc table.
	 * 
	 * @param santipsanacc
	 *            Santipsanacc
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Santipsanacc> findAll(Santipsanacc santipsanacc,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.TAID TAID,t1.TADESCES TADESCES,NVL(t1.TADESCEU,t1.TADESCES) TADESCEU,t1.TAFECALTA TAFECALTA,t1.TAFECMODIF TAFECMODIF,t1.TAUSUALTA TAUSUALTA,t1.TAUSUMODIF TAUSUMODIF ");
		query.append("FROM SANTIPSANACC t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(santipsanacc);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Santipsanacc>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Santipsanacc table.
	 * 
	 * @param santipsanacc
	 *            Santipsanacc
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Santipsanacc santipsanacc) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM SANTIPSANACC t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(santipsanacc);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Santipsanacc table using like.
	 * 
	 * @param santipsanacc
	 *            Santipsanacc
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Santipsanacc> findAllLike(Santipsanacc santipsanacc,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.TAID TAID,t1.TADESCES TADESCES,NVL(t1.TADESCEU,t1.TADESCES) TADESCEU,t1.TAFECALTA TAFECALTA,t1.TAFECMODIF TAFECMODIF,t1.TAUSUALTA TAUSUALTA,t1.TAUSUMODIF TAUSUMODIF ");
		query.append("FROM SANTIPSANACC t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(santipsanacc,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Santipsanacc>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Santipsanacc table using like.
	 * 
	 * @param santipsanacc
	 *            Santipsanacc
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Santipsanacc santipsanacc, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM SANTIPSANACC t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(santipsanacc,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Santipsanacc entity
	 * 
	 * @param santipsanacc
	 *            Santipsanacc Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Santipsanacc santipsanacc) {

		StringBuilder where = new StringBuilder(
				SantipsanaccDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (santipsanacc != null && santipsanacc.getTaid() != null) {
			where.append(" AND t1.TAID = ?");
			params.add(santipsanacc.getTaid());
		}
		if (santipsanacc != null && santipsanacc.getTadesces() != null) {
			where.append(" AND t1.TADESCES = ?");
			params.add(santipsanacc.getTadesces());
		}
		if (santipsanacc != null && santipsanacc.getTadesceu() != null) {
			where.append(" AND t1.TADESCEU = ?");
			params.add(santipsanacc.getTadesceu());
		}
		if (santipsanacc != null && santipsanacc.getTafecalta() != null) {
			where.append(" AND t1.TAFECALTA = ?");
			params.add(santipsanacc.getTafecalta());
		}
		if (santipsanacc != null && santipsanacc.getTafecmodif() != null) {
			where.append(" AND t1.TAFECMODIF = ?");
			params.add(santipsanacc.getTafecmodif());
		}
		if (santipsanacc != null && santipsanacc.getTausualta() != null) {
			where.append(" AND t1.TAUSUALTA = ?");
			params.add(santipsanacc.getTausualta());
		}
		if (santipsanacc != null && santipsanacc.getTausumodif() != null) {
			where.append(" AND t1.TAUSUMODIF = ?");
			params.add(santipsanacc.getTausumodif());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Santipsanacc entity
	 * 
	 * @param santipsanacc
	 *            Santipsanacc Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Santipsanacc santipsanacc,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				SantipsanaccDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (santipsanacc != null && santipsanacc.getTaid() != null) {
			where.append(" AND t1.TAID = ?");
			params.add(santipsanacc.getTaid());
		}
		if (santipsanacc != null && santipsanacc.getTadesces() != null) {
			where.append(" AND UPPER(t1.TADESCES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(santipsanacc.getTadesces().toUpperCase() + "%");
			} else {
				params.add("%" + santipsanacc.getTadesces().toUpperCase() + "%");
			}
			where.append(" AND t1.TADESCES IS NOT NULL");
		}
		if (santipsanacc != null && santipsanacc.getTadesceu() != null) {
			where.append(" AND UPPER(t1.TADESCEU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(santipsanacc.getTadesceu().toUpperCase() + "%");
			} else {
				params.add("%" + santipsanacc.getTadesceu().toUpperCase() + "%");
			}
			where.append(" AND t1.TADESCEU IS NOT NULL");
		}
		if (santipsanacc != null && santipsanacc.getTafecalta() != null) {
			where.append(" AND t1.TAFECALTA = ?");
			params.add(santipsanacc.getTafecalta());
		}
		if (santipsanacc != null && santipsanacc.getTafecmodif() != null) {
			where.append(" AND t1.TAFECMODIF = ?");
			params.add(santipsanacc.getTafecmodif());
		}
		if (santipsanacc != null && santipsanacc.getTausualta() != null) {
			where.append(" AND UPPER(t1.TAUSUALTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(santipsanacc.getTausualta().toUpperCase() + "%");
			} else {
				params.add("%" + santipsanacc.getTausualta().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TAUSUALTA IS NOT NULL");
		}
		if (santipsanacc != null && santipsanacc.getTausumodif() != null) {
			where.append(" AND UPPER(t1.TAUSUMODIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(santipsanacc.getTausumodif().toUpperCase() + "%");
			} else {
				params.add("%" + santipsanacc.getTausumodif().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TAUSUMODIF IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
