package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Santipresul;

/**
 * SantipresulDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class SantipresulDaoImpl implements SantipresulDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Santipresul> rwMap = new RowMapper<Santipresul>() {
		public Santipresul mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Santipresul(resultSet.getLong("TRID"),
					resultSet.getString("TRDESCES"),
					resultSet.getString("TRDESCEU"),
					resultSet.getDate("TRFECALTA"),
					resultSet.getDate("TRFECMODIF"),
					resultSet.getString("TRUSUALTA"),
					resultSet.getString("TRUSUMODIF"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Santipresul table.
	 * 
	 * @param santipresul
	 *            Pagination
	 * @return Santipresul
	 */
	public Santipresul add(Santipresul santipresul) {
		String query = "INSERT INTO SANTIPRESUL (TRID, TRDESCES, TRDESCEU, TRFECALTA, TRFECMODIF, TRUSUALTA, TRUSUMODIF) VALUES (?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, santipresul.getTrid(),
				santipresul.getTrdesces(), santipresul.getTrdesceu(),
				santipresul.getTrfecalta(), santipresul.getTrfecmodif(),
				santipresul.getTrusualta(), santipresul.getTrusumodif());
		return santipresul;
	}

	/**
	 * Updates a single row in the Santipresul table.
	 * 
	 * @param santipresul
	 *            Pagination
	 * @return Santipresul
	 */
	public Santipresul update(Santipresul santipresul) {
		String query = "UPDATE SANTIPRESUL SET TRDESCES=?, TRDESCEU=?, TRFECALTA=?, TRFECMODIF=?, TRUSUALTA=?, TRUSUMODIF=? WHERE TRID=?";
		this.jdbcTemplate.update(query, santipresul.getTrdesces(),
				santipresul.getTrdesceu(), santipresul.getTrfecalta(),
				santipresul.getTrfecmodif(), santipresul.getTrusualta(),
				santipresul.getTrusumodif(), santipresul.getTrid());
		return santipresul;
	}

	/**
	 * Finds a single row in the Santipresul table.
	 * 
	 * @param santipresul
	 *            Pagination
	 * @return Santipresul
	 */
	@Transactional(readOnly = true)
	public Santipresul find(Santipresul santipresul) {
		String query = "SELECT t1.TRID TRID, t1.TRDESCES TRDESCES, t1.TRDESCEU TRDESCEU, t1.TRFECALTA TRFECALTA, t1.TRFECMODIF TRFECMODIF, t1.TRUSUALTA TRUSUALTA, t1.TRUSUMODIF TRUSUMODIF FROM SANTIPRESUL t1  WHERE t1.TRID = ?  ";

		List<Santipresul> santipresulList = this.jdbcTemplate.query(query,
				this.rwMap, santipresul.getTrid());
		return (Santipresul) DataAccessUtils.uniqueResult(santipresulList);
	}

	/**
	 * Removes a single row in the Santipresul table.
	 * 
	 * @param santipresul
	 *            Pagination
	 * @return
	 */
	public void remove(Santipresul santipresul) {
		String query = "DELETE FROM SANTIPRESUL WHERE TRID=?";
		this.jdbcTemplate.update(query, santipresul.getTrid());
	}

	/**
	 * Finds a List of rows in the Santipresul table.
	 * 
	 * @param santipresul
	 *            Santipresul
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Santipresul> findAll(Santipresul santipresul,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.TRID TRID,t1.TRDESCES TRDESCES,NVL(t1.TRDESCEU,t1.TRDESCES) TRDESCEU,t1.TRFECALTA TRFECALTA,t1.TRFECMODIF TRFECMODIF,t1.TRUSUALTA TRUSUALTA,t1.TRUSUMODIF TRUSUMODIF ");
		query.append("FROM SANTIPRESUL t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(santipresul);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Santipresul>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Santipresul table.
	 * 
	 * @param santipresul
	 *            Santipresul
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Santipresul santipresul) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM SANTIPRESUL t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(santipresul);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Santipresul table using like.
	 * 
	 * @param santipresul
	 *            Santipresul
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Santipresul> findAllLike(Santipresul santipresul,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.TRID TRID,t1.TRDESCES TRDESCES,NVL(t1.TRDESCEU,t1.TRDESCES) TRDESCEU,t1.TRFECALTA TRFECALTA,t1.TRFECMODIF TRFECMODIF,t1.TRUSUALTA TRUSUALTA,t1.TRUSUMODIF TRUSUMODIF ");
		query.append("FROM SANTIPRESUL t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(santipresul, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Santipresul>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Santipresul table using like.
	 * 
	 * @param santipresul
	 *            Santipresul
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Santipresul santipresul, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM SANTIPRESUL t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(santipresul, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Santipresul entity
	 * 
	 * @param santipresul
	 *            Santipresul Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Santipresul santipresul) {

		StringBuilder where = new StringBuilder(
				SantipresulDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (santipresul != null && santipresul.getTrid() != null) {
			where.append(" AND t1.TRID = ?");
			params.add(santipresul.getTrid());
		}
		if (santipresul != null && santipresul.getTrdesces() != null) {
			where.append(" AND t1.TRDESCES = ?");
			params.add(santipresul.getTrdesces());
		}
		if (santipresul != null && santipresul.getTrdesceu() != null) {
			where.append(" AND t1.TRDESCEU = ?");
			params.add(santipresul.getTrdesceu());
		}
		if (santipresul != null && santipresul.getTrfecalta() != null) {
			where.append(" AND t1.TRFECALTA = ?");
			params.add(santipresul.getTrfecalta());
		}
		if (santipresul != null && santipresul.getTrfecmodif() != null) {
			where.append(" AND t1.TRFECMODIF = ?");
			params.add(santipresul.getTrfecmodif());
		}
		if (santipresul != null && santipresul.getTrusualta() != null) {
			where.append(" AND t1.TRUSUALTA = ?");
			params.add(santipresul.getTrusualta());
		}
		if (santipresul != null && santipresul.getTrusumodif() != null) {
			where.append(" AND t1.TRUSUMODIF = ?");
			params.add(santipresul.getTrusumodif());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Santipresul entity
	 * 
	 * @param santipresul
	 *            Santipresul Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Santipresul santipresul,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				SantipresulDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (santipresul != null && santipresul.getTrid() != null) {
			where.append(" AND t1.TRID = ?");
			params.add(santipresul.getTrid());
		}
		if (santipresul != null && santipresul.getTrdesces() != null) {
			where.append(" AND UPPER(t1.TRDESCES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(santipresul.getTrdesces().toUpperCase() + "%");
			} else {
				params.add("%" + santipresul.getTrdesces().toUpperCase() + "%");
			}
			where.append(" AND t1.TRDESCES IS NOT NULL");
		}
		if (santipresul != null && santipresul.getTrdesceu() != null) {
			where.append(" AND UPPER(t1.TRDESCEU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(santipresul.getTrdesceu().toUpperCase() + "%");
			} else {
				params.add("%" + santipresul.getTrdesceu().toUpperCase() + "%");
			}
			where.append(" AND t1.TRDESCEU IS NOT NULL");
		}
		if (santipresul != null && santipresul.getTrfecalta() != null) {
			where.append(" AND t1.TRFECALTA = ?");
			params.add(santipresul.getTrfecalta());
		}
		if (santipresul != null && santipresul.getTrfecmodif() != null) {
			where.append(" AND t1.TRFECMODIF = ?");
			params.add(santipresul.getTrfecmodif());
		}
		if (santipresul != null && santipresul.getTrusualta() != null) {
			where.append(" AND UPPER(t1.TRUSUALTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(santipresul.getTrusualta().toUpperCase() + "%");
			} else {
				params.add("%" + santipresul.getTrusualta().toUpperCase() + "%");
			}
			where.append(" AND t1.TRUSUALTA IS NOT NULL");
		}
		if (santipresul != null && santipresul.getTrusumodif() != null) {
			where.append(" AND UPPER(t1.TRUSUMODIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(santipresul.getTrusumodif().toUpperCase() + "%");
			} else {
				params.add("%" + santipresul.getTrusumodif().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TRUSUMODIF IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
