package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.Santipresul;

/**
 * SantipresulDao  
 *  
 */

public interface SantipresulDao {
    
    /**
     * Inserts a single row in the Santipresul table.
     *
     * @param santipresul Santipresul
     * @return Santipresul
     */
    Santipresul add(Santipresul santipresul);

    /**
     * Updates a single row in the Santipresul table.
     *
     * @param santipresul Santipresul
     * @return Santipresul
     */
    Santipresul update(Santipresul santipresul);

    /**
     * Finds a single row in the Santipresul table.
     *
     * @param santipresul Santipresul
     * @return Santipresul
     */
    Santipresul find(Santipresul santipresul);

    /**
     * Deletes a single row in the Santipresul table.
     *
     * @param santipresul Santipresul
     * @return 
     */
    void remove(Santipresul santipresul);

    /**
     * Finds a List of rows in the Santipresul table.
     *
     * @param santipresul Santipresul
     * @param pagination Pagination
     * @return List
     */
    List<Santipresul> findAll(Santipresul santipresul, Pagination pagination);

    /**
     * Counts rows in the Santipresul table.
     *
     * @param santipresul Santipresul
     * @return Long
     */
    Long findAllCount(Santipresul santipresul);
	
	/**
     * Finds rows in the Santipresul table using like.
     *
     * @param santipresul Santipresul
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List
     */
	List<Santipresul> findAllLike(Santipresul santipresul, Pagination pagination, Boolean startsWith);
	
    /**
     * Counts rows in the Santipresul table using like.
     *
     * @param santipresul Santipresul
     * @param startsWith Boolean
     * @return Long
     */
    Long findAllLikeCount(Santipresul santipresul, Boolean startsWith);
}

