package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Santipinffrec;
import com.ejie.y41b.model.SantipinffrecDetalle;

/**
 * SantipinffrecDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class SantipinffrecDaoImpl implements SantipinffrecDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Santipinffrec> rwMap = new RowMapper<Santipinffrec>() {
		public Santipinffrec mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Santipinffrec(resultSet.getString("IFID"),
					resultSet.getString("IFDESCES"),
					resultSet.getString("IFDESCEU"),
					resultSet.getString("IFTTICODIGO"),
					resultSet.getDate("IFFECALTA"),
					resultSet.getDate("IFFECMODIF"),
					resultSet.getString("IFUSUALTA"),
					resultSet.getString("IFUSUMODIF"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Santipinffrec table.
	 * 
	 * @param santipinffrec
	 *            Pagination
	 * @return Santipinffrec
	 */
	public Santipinffrec add(Santipinffrec santipinffrec) {
		String query = "INSERT INTO SANTIPINFFREC (IFID, IFDESCES, IFDESCEU, IFTTICODIGO, IFFECALTA, IFFECMODIF, IFUSUALTA, IFUSUMODIF) VALUES (?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, santipinffrec.getIfid(),
				santipinffrec.getIfdesces(), santipinffrec.getIfdesceu(),
				santipinffrec.getIftticodigo(), santipinffrec.getIffecalta(),
				santipinffrec.getIffecmodif(), santipinffrec.getIfusualta(),
				santipinffrec.getIfusumodif());
		return santipinffrec;
	}

	/**
	 * Updates a single row in the Santipinffrec table.
	 * 
	 * @param santipinffrec
	 *            Pagination
	 * @return Santipinffrec
	 */
	public Santipinffrec update(Santipinffrec santipinffrec) {
		String query = "UPDATE SANTIPINFFREC SET IFDESCES=?, IFDESCEU=?, IFTTICODIGO=?, IFFECALTA=?, IFFECMODIF=?, IFUSUALTA=?, IFUSUMODIF=? WHERE IFID=?";
		this.jdbcTemplate.update(query, santipinffrec.getIfdesces(),
				santipinffrec.getIfdesceu(), santipinffrec.getIftticodigo(),
				santipinffrec.getIffecalta(), santipinffrec.getIffecmodif(),
				santipinffrec.getIfusualta(), santipinffrec.getIfusumodif(),
				santipinffrec.getIfid());
		return santipinffrec;
	}

	/**
	 * Finds a single row in the Santipinffrec table.
	 * 
	 * @param santipinffrec
	 *            Pagination
	 * @return Santipinffrec
	 */
	@Transactional(readOnly = true)
	public Santipinffrec find(Santipinffrec santipinffrec) {
		String query = "SELECT t1.IFID IFID, t1.IFDESCES IFDESCES, t1.IFDESCEU IFDESCEU, t1.IFTTICODIGO IFTTICODIGO, t1.IFFECALTA IFFECALTA, t1.IFFECMODIF IFFECMODIF, t1.IFUSUALTA IFUSUALTA, t1.IFUSUMODIF IFUSUMODIF FROM SANTIPINFFREC t1  WHERE t1.IFID = ?  ";

		List<Santipinffrec> santipinffrecList = this.jdbcTemplate.query(query,
				this.rwMap, santipinffrec.getIfid());
		return (Santipinffrec) DataAccessUtils.uniqueResult(santipinffrecList);
	}

	/**
	 * Finds a single row in the Santipinffrec table.
	 * 
	 * @param santipinffrec
	 *            Pagination
	 * @return SantipinffrecDetalle
	 */
	@Transactional(readOnly = true)
	public SantipinffrecDetalle findSantipinffrec(Santipinffrec santipinffrec) {
		String query = "SELECT t1.IFID IFID, t1.IFDESCES IFDESCES, t1.IFDESCEU IFDESCEU, t1.IFTTICODIGO IFTTICODIGO, t2.TTICODIGO TTICODIGO,t2.TTINOMBRE TTINOMBRE,t2.TTINOMBREE TTINOMBREE, t1.IFFECALTA IFFECALTA, t1.IFFECMODIF IFFECMODIF, t1.IFUSUALTA IFUSUALTA, t1.IFUSUMODIF IFUSUMODIF FROM SANTIPINFFREC t1,TIP_REQ_NORMATIVO t2 WHERE 1=1 AND t1.IFTTICODIGO = t2.TTICODIGO AND t1.IFID = ? ";

		List<SantipinffrecDetalle> santipinffrecList = this.jdbcTemplate.query(
				query, new RowMapper<SantipinffrecDetalle>() {
					public SantipinffrecDetalle mapRow(ResultSet resultSet,
							int rowNum) throws SQLException {
						return new SantipinffrecDetalle(resultSet
								.getString("IFID"), resultSet
								.getString("IFDESCES"), resultSet
								.getString("IFDESCEU"), resultSet
								.getString("IFTTICODIGO"), resultSet
								.getString("TTINOMBRE"), resultSet
								.getString("TTINOMBREE"), resultSet
								.getDate("IFFECALTA"), resultSet
								.getDate("IFFECMODIF"), resultSet
								.getString("IFUSUALTA"), resultSet
								.getString("IFUSUMODIF"));
					}
				}, santipinffrec.getIfid());
		return (SantipinffrecDetalle) DataAccessUtils
				.uniqueResult(santipinffrecList);
	}

	/**
	 * Removes a single row in the Santipinffrec table.
	 * 
	 * @param santipinffrec
	 *            Pagination
	 * @return
	 */
	public void remove(Santipinffrec santipinffrec) {
		String query = "DELETE FROM SANTIPINFFREC WHERE IFID=?";
		this.jdbcTemplate.update(query, santipinffrec.getIfid());
	}

	/**
	 * Finds a List of rows in the Santipinffrec table.
	 * 
	 * @param santipinffrec
	 *            Santipinffrec
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Santipinffrec> findAll(Santipinffrec santipinffrec,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IFID IFID,t1.IFDESCES IFDESCES,t1.IFDESCEU IFDESCEU,t1.IFTTICODIGO IFTTICODIGO,t1.IFFECALTA IFFECALTA,t1.IFFECMODIF IFFECMODIF,t1.IFUSUALTA IFUSUALTA,t1.IFUSUMODIF IFUSUMODIF ");
		query.append("FROM SANTIPINFFREC t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(santipinffrec);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Santipinffrec>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Santipinffrec table.
	 * 
	 * @param santipinffrec
	 *            Santipinffrec
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Santipinffrec santipinffrec) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM SANTIPINFFREC t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(santipinffrec);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Santipinffrec table using like.
	 * 
	 * @param santipinffrec
	 *            Santipinffrec
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Santipinffrec> findAllLike(Santipinffrec santipinffrec,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IFID IFID,t1.IFDESCES IFDESCES,t1.IFDESCEU IFDESCEU,t1.IFTTICODIGO IFTTICODIGO,t1.IFFECALTA IFFECALTA,t1.IFFECMODIF IFFECMODIF,t1.IFUSUALTA IFUSUALTA,t1.IFUSUMODIF IFUSUMODIF ");
		query.append("FROM SANTIPINFFREC t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(santipinffrec,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Santipinffrec>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Santipinffrec table using like.
	 * 
	 * @param santipinffrec
	 *            Santipinffrec
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Santipinffrec santipinffrec, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM SANTIPINFFREC t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(santipinffrec,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Santipinffrec entity
	 * 
	 * @param santipinffrec
	 *            Santipinffrec Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Santipinffrec santipinffrec) {

		StringBuilder where = new StringBuilder(
				SantipinffrecDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (santipinffrec != null && santipinffrec.getIfid() != null) {
			where.append(" AND t1.IFID = ?");
			params.add(santipinffrec.getIfid());
		}
		if (santipinffrec != null && santipinffrec.getIfdesces() != null) {
			where.append(" AND t1.IFDESCES = ?");
			params.add(santipinffrec.getIfdesces());
		}
		if (santipinffrec != null && santipinffrec.getIfdesceu() != null) {
			where.append(" AND t1.IFDESCEU = ?");
			params.add(santipinffrec.getIfdesceu());
		}
		if (santipinffrec != null && santipinffrec.getIftticodigo() != null) {
			where.append(" AND t1.IFTTICODIGO = ?");
			params.add(santipinffrec.getIftticodigo());
		}
		if (santipinffrec != null && santipinffrec.getIffecalta() != null) {
			where.append(" AND t1.IFFECALTA = ?");
			params.add(santipinffrec.getIffecalta());
		}
		if (santipinffrec != null && santipinffrec.getIffecmodif() != null) {
			where.append(" AND t1.IFFECMODIF = ?");
			params.add(santipinffrec.getIffecmodif());
		}
		if (santipinffrec != null && santipinffrec.getIfusualta() != null) {
			where.append(" AND t1.IFUSUALTA = ?");
			params.add(santipinffrec.getIfusualta());
		}
		if (santipinffrec != null && santipinffrec.getIfusumodif() != null) {
			where.append(" AND t1.IFUSUMODIF = ?");
			params.add(santipinffrec.getIfusumodif());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Santipinffrec entity
	 * 
	 * @param santipinffrec
	 *            Santipinffrec Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Santipinffrec santipinffrec,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				SantipinffrecDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (santipinffrec != null && santipinffrec.getIfid() != null) {
			where.append(" AND UPPER(t1.IFID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(santipinffrec.getIfid().toUpperCase() + "%");
			} else {
				params.add("%" + santipinffrec.getIfid().toUpperCase() + "%");
			}
			where.append(" AND t1.IFID IS NOT NULL");
		}
		if (santipinffrec != null && santipinffrec.getIfdesces() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.IFDESCES),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(santipinffrec.getIfdesces().toUpperCase()
						.replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O")
						.replaceAll("", "U")
						+ "%");
			} else {
				params.add("%"
						+ santipinffrec.getIfdesces().toUpperCase()
								.replaceAll("", "A").replaceAll("", "E")
								.replaceAll("", "I").replaceAll("", "O")
								.replaceAll("", "U") + "%");
			}
			where.append(" AND t1.IFDESCES IS NOT NULL");
		}
		if (santipinffrec != null && santipinffrec.getIfdesceu() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.IFDESCEU),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(santipinffrec.getIfdesceu().toUpperCase()
						.replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O")
						.replaceAll("", "U")
						+ "%");
			} else {
				params.add("%"
						+ santipinffrec.getIfdesceu().toUpperCase()
								.replaceAll("", "A").replaceAll("", "E")
								.replaceAll("", "I").replaceAll("", "O")
								.replaceAll("", "U") + "%");
			}
			where.append(" AND t1.IFDESCEU IS NOT NULL");
		}
		if (santipinffrec != null && santipinffrec.getIftticodigo() != null) {
			where.append(" AND UPPER(t1.IFTTICODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(santipinffrec.getIftticodigo().toUpperCase() + "%");
			} else {
				params.add("%" + santipinffrec.getIftticodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.IFTTICODIGO IS NOT NULL");
		}
		if (santipinffrec != null && santipinffrec.getIffecalta() != null) {
			where.append(" AND t1.IFFECALTA = ?");
			params.add(santipinffrec.getIffecalta());
		}
		if (santipinffrec != null && santipinffrec.getIffecmodif() != null) {
			where.append(" AND t1.IFFECMODIF = ?");
			params.add(santipinffrec.getIffecmodif());
		}
		if (santipinffrec != null && santipinffrec.getIfusualta() != null) {
			where.append(" AND UPPER(t1.IFUSUALTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(santipinffrec.getIfusualta().toUpperCase() + "%");
			} else {
				params.add("%" + santipinffrec.getIfusualta().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.IFUSUALTA IS NOT NULL");
		}
		if (santipinffrec != null && santipinffrec.getIfusumodif() != null) {
			where.append(" AND UPPER(t1.IFUSUMODIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(santipinffrec.getIfusumodif().toUpperCase() + "%");
			} else {
				params.add("%" + santipinffrec.getIfusumodif().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.IFUSUMODIF IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	@Transactional(readOnly = true)
	public List<Santipinffrec> findAllMaterias(Santipinffrec santipinffrec,
			Pagination pagination, List<String> materiasAniadidas) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1 = 1 ");

		StringBuffer query = new StringBuffer(
				"SELECT t1.IFID IFID,t1.IFDESCES IFDESCES,t1.IFDESCEU IFDESCEU,t1.IFTTICODIGO IFTTICODIGO,t1.IFFECALTA IFFECALTA,t1.IFFECMODIF IFFECMODIF,t1.IFUSUALTA IFUSUALTA,t1.IFUSUMODIF IFUSUMODIF "
						+ " FROM SANTIPINFFREC t1 ");
		if (santipinffrec != null && santipinffrec.getIfdesces() != null) {
			where.append(" AND UPPER(t1.IFDESCES) like ? ESCAPE  '\\'");
			params.add("%" + santipinffrec.getIfdesces().toUpperCase() + "%");
			where.append(" AND t1.IFDESCES IS NOT NULL");
		}

		if (santipinffrec != null && santipinffrec.getIfdesceu() != null) {
			where.append(" AND UPPER(t1.IFDESCEU) like ? ESCAPE  '\\'");
			params.add("%" + santipinffrec.getIfdesceu().toUpperCase() + "%");
			where.append(" AND t1.IFDESCEU IS NOT NULL");
		}

		if (materiasAniadidas != null) {
			for (String cod : materiasAniadidas) {
				if (cod.contains("~")) {
					where.append(" AND t1.IFID != ?");
					params.add(cod.split("~")[1]);
				} else {
					where.append(" AND t1.IFTTICODIGO != ?");
					params.add(cod);
				}
			}
		}

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Santipinffrec>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	@Transactional(readOnly = true)
	public Long findAllMateriasCount(Santipinffrec santipinffrec,
			List<String> materiasAniadidas) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1 = 1 ");

		if (santipinffrec != null && santipinffrec.getIfdesces() != null) {
			where.append(" AND UPPER(t1.IFDESCES) like ? ESCAPE  '\\'");
			params.add("%" + santipinffrec.getIfdesces().toUpperCase() + "%");
			where.append(" AND t1.IFDESCES IS NOT NULL");
		}

		if (santipinffrec != null && santipinffrec.getIfdesceu() != null) {
			where.append(" AND UPPER(t1.IFDESCEU) like ? ESCAPE  '\\'");
			params.add("%" + santipinffrec.getIfdesceu().toUpperCase() + "%");
			where.append(" AND t1.IFDESCEU IS NOT NULL");
		}

		if (materiasAniadidas != null) {
			for (String cod : materiasAniadidas) {
				where.append(" AND t1.IFTTICODIGO != ?");
				params.add(cod);
			}
		}

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM SANTIPINFFREC t1 ");

		if (santipinffrec != null && santipinffrec.getIfdesces() != null) {
			where.append(" AND UPPER(t1.IFDESCES) like ? ESCAPE  '\\'");
			params.add("%" + santipinffrec.getIfdesces().toUpperCase() + "%");
			where.append(" AND t1.IFDESCES IS NOT NULL");
		}

		if (santipinffrec != null && santipinffrec.getIfdesceu() != null) {
			where.append(" AND UPPER(t1.IFDESCEU) like ? ESCAPE  '\\'");
			params.add("%" + santipinffrec.getIfdesceu().toUpperCase() + "%");
			where.append(" AND t1.IFDESCEU IS NOT NULL");
		}

		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}
}
