package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Santipestim;

/**
 * SantipestimDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class SantipestimDaoImpl implements SantipestimDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Santipestim> rwMap = new RowMapper<Santipestim>() {
		public Santipestim mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Santipestim(resultSet.getString("TEID"),
					resultSet.getString("TEDESCES"),
					resultSet.getString("TEDESCEU"),
					resultSet.getDate("TEFECALTA"),
					resultSet.getDate("TEFECMODIF"),
					resultSet.getString("TEUSUALTA"),
					resultSet.getString("TEUSUMODIF"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Santipestim table.
	 * 
	 * @param santipestim
	 *            Pagination
	 * @return Santipestim
	 */
	public Santipestim add(Santipestim santipestim) {
		String query = "INSERT INTO SANTIPESTIM (TEDESCES, TEDESCEU) VALUES (?,?)";
		this.jdbcTemplate.update(query, santipestim.getTedesces(),
				santipestim.getTedesceu());
		return santipestim;
	}

	/**
	 * Updates a single row in the Santipestim table.
	 * 
	 * @param santipestim
	 *            Pagination
	 * @return Santipestim
	 */
	public Santipestim update(Santipestim santipestim) {
		String query = "UPDATE SANTIPESTIM SET TEDESCES=?, TEDESCEU=? WHERE TEID=?";
		this.jdbcTemplate.update(query, santipestim.getTedesces(),
				santipestim.getTedesceu(), santipestim.getTeid());
		return santipestim;
	}

	/**
	 * Finds a single row in the Santipestim table.
	 * 
	 * @param santipestim
	 *            Pagination
	 * @return Santipestim
	 */
	@Transactional(readOnly = true)
	public Santipestim find(Santipestim santipestim) {
		String query = "SELECT t1.TEID TEID, t1.TEDESCES TEDESCES, t1.TEDESCEU TEDESCEU, t1.TEFECALTA TEFECALTA, t1.TEFECMODIF TEFECMODIF, t1.TEUSUALTA TEUSUALTA, t1.TEUSUMODIF TEUSUMODIF FROM SANTIPESTIM t1  WHERE t1.TEID = ?  ";

		List<Santipestim> santipestimList = this.jdbcTemplate.query(query,
				this.rwMap, santipestim.getTeid());
		return (Santipestim) DataAccessUtils.uniqueResult(santipestimList);
	}

	/**
	 * Removes a single row in the Santipestim table.
	 * 
	 * @param santipestim
	 *            Pagination
	 * @return
	 */
	public void remove(Santipestim santipestim) {
		// String query = "DELETE FROM SANTIPESTIM WHERE TEID=?";
		String query = "UPDATE SANTIPESTIM SET TEFECBAJA = SYSDATE WHERE TEID = ?";
		this.jdbcTemplate.update(query, santipestim.getTeid());
	}

	/**
	 * Finds a List of rows in the Santipestim table.
	 * 
	 * @param santipestim
	 *            Santipestim
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Santipestim> findAll(Santipestim santipestim,
			Pagination pagination, Boolean incluirBajas) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.TEID TEID,t1.TEDESCES TEDESCES,NVL(t1.TEDESCEU,t1.TEDESCES) TEDESCEU,t1.TEFECALTA TEFECALTA,t1.TEFECMODIF TEFECMODIF,t1.TEUSUALTA TEUSUALTA,t1.TEUSUMODIF TEUSUMODIF ");
		query.append("FROM SANTIPESTIM t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(santipestim);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));

		if (!incluirBajas) {
			where.append("AND TEFECBAJA IS NULL ");
		}
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Santipestim>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Santipestim table.
	 * 
	 * @param santipestim
	 *            Santipestim
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Santipestim santipestim, Boolean incluirBajas) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM SANTIPESTIM t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(santipestim);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));

		if (!incluirBajas) {
			where.append("AND TEFECBAJA IS NULL ");
		}
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Santipestim table using like.
	 * 
	 * @param santipestim
	 *            Santipestim
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Santipestim> findAllLike(Santipestim santipestim,
			Pagination pagination, Boolean startsWith, Boolean incluirBajas) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.TEID TEID,t1.TEDESCES TEDESCES,NVL(t1.TEDESCEU,t1.TEDESCES) TEDESCEU,t1.TEFECALTA TEFECALTA,t1.TEFECMODIF TEFECMODIF,t1.TEUSUALTA TEUSUALTA,t1.TEUSUMODIF TEUSUMODIF ");
		query.append("FROM SANTIPESTIM t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(santipestim, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		if (!incluirBajas) {
			where.append(" AND TEFECBAJA IS NULL ");
		}

		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Santipestim>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Santipestim table using like.
	 * 
	 * @param santipestim
	 *            Santipestim
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Santipestim santipestim, Boolean startsWith,
			Boolean incluirBajas) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM SANTIPESTIM t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(santipestim, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		if (!incluirBajas) {
			where.append(" AND TEFECBAJA IS NULL ");
		}
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Santipestim entity
	 * 
	 * @param santipestim
	 *            Santipestim Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Santipestim santipestim) {

		StringBuilder where = new StringBuilder(
				SantipestimDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (santipestim != null && santipestim.getTeid() != null) {
			where.append(" AND t1.TEID = ?");
			params.add(santipestim.getTeid());
		}
		if (santipestim != null && santipestim.getTedesces() != null) {
			where.append(" AND t1.TEDESCES = ?");
			params.add(santipestim.getTedesces());
		}
		if (santipestim != null && santipestim.getTedesceu() != null) {
			where.append(" AND t1.TEDESCEU = ?");
			params.add(santipestim.getTedesceu());
		}
		if (santipestim != null && santipestim.getTefecalta() != null) {
			where.append(" AND t1.TEFECALTA = ?");
			params.add(santipestim.getTefecalta());
		}
		if (santipestim != null && santipestim.getTefecmodif() != null) {
			where.append(" AND t1.TEFECMODIF = ?");
			params.add(santipestim.getTefecmodif());
		}
		if (santipestim != null && santipestim.getTeusualta() != null) {
			where.append(" AND t1.TEUSUALTA = ?");
			params.add(santipestim.getTeusualta());
		}
		if (santipestim != null && santipestim.getTeusumodif() != null) {
			where.append(" AND t1.TEUSUMODIF = ?");
			params.add(santipestim.getTeusumodif());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Santipestim entity
	 * 
	 * @param santipestim
	 *            Santipestim Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Santipestim santipestim,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				SantipestimDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (santipestim != null && santipestim.getTeid() != null) {
			where.append(" AND UPPER(t1.TEID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(santipestim.getTeid().toUpperCase() + "%");
			} else {
				params.add("%" + santipestim.getTeid().toUpperCase() + "%");
			}
			where.append(" AND t1.TEID IS NOT NULL");
		}
		if (santipestim != null && santipestim.getTedesces() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.TEDESCES),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(santipestim.getTedesces().toUpperCase()
						.replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O")
						.replaceAll("", "U")
						+ "%");
			} else {
				params.add("%"
						+ santipestim.getTedesces().toUpperCase()
								.replaceAll("", "A").replaceAll("", "E")
								.replaceAll("", "I").replaceAll("", "O")
								.replaceAll("", "U") + "%");
			}
			where.append(" AND t1.TEDESCES IS NOT NULL");
		}
		if (santipestim != null && santipestim.getTedesceu() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.TEDESCEU),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(santipestim.getTedesceu().toUpperCase()
						.replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O")
						.replaceAll("", "U")
						+ "%");
			} else {
				params.add("%"
						+ santipestim.getTedesceu().toUpperCase()
								.replaceAll("", "A").replaceAll("", "E")
								.replaceAll("", "I").replaceAll("", "O")
								.replaceAll("", "U") + "%");
			}
			where.append(" AND t1.TEDESCEU IS NOT NULL");
		}
		if (santipestim != null && santipestim.getTefecalta() != null) {
			where.append(" AND t1.TEFECALTA = ?");
			params.add(santipestim.getTefecalta());
		}
		if (santipestim != null && santipestim.getTefecmodif() != null) {
			where.append(" AND t1.TEFECMODIF = ?");
			params.add(santipestim.getTefecmodif());
		}
		if (santipestim != null && santipestim.getTeusualta() != null) {
			where.append(" AND UPPER(t1.TEUSUALTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(santipestim.getTeusualta().toUpperCase() + "%");
			} else {
				params.add("%" + santipestim.getTeusualta().toUpperCase() + "%");
			}
			where.append(" AND t1.TEUSUALTA IS NOT NULL");
		}
		if (santipestim != null && santipestim.getTeusumodif() != null) {
			where.append(" AND UPPER(t1.TEUSUMODIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(santipestim.getTeusumodif().toUpperCase() + "%");
			} else {
				params.add("%" + santipestim.getTeusumodif().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TEUSUMODIF IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
