package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.Santipestim;

/**
 * SantipestimDao  
 * 
 *  
 */

public interface SantipestimDao {

	/**
	 * Inserts a single row in the Santipestim table.
	 * 
	 * @param santipestim
	 *            Santipestim
	 * @return Santipestim
	 */
	Santipestim add(Santipestim santipestim);

	/**
	 * Updates a single row in the Santipestim table.
	 * 
	 * @param santipestim
	 *            Santipestim
	 * @return Santipestim
	 */
	Santipestim update(Santipestim santipestim);

	/**
	 * Finds a single row in the Santipestim table.
	 * 
	 * @param santipestim
	 *            Santipestim
	 * @return Santipestim
	 */
	Santipestim find(Santipestim santipestim);

	/**
	 * Deletes a single row in the Santipestim table.
	 * 
	 * @param santipestim
	 *            Santipestim
	 * @return
	 */
	void remove(Santipestim santipestim);

	/**
	 * Finds a List of rows in the Santipestim table.
	 * 
	 * @param santipestim
	 *            Santipestim
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Santipestim> findAll(Santipestim santipestim, Pagination pagination,
			Boolean incluirBaja);

	/**
	 * Counts rows in the Santipestim table.
	 * 
	 * @param santipestim
	 *            Santipestim
	 * @return Long
	 */
	Long findAllCount(Santipestim santipestim, Boolean mostrarDadosDeBaja);

	/**
	 * Finds rows in the Santipestim table using like.
	 * 
	 * @param santipestim
	 *            Santipestim
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Santipestim> findAllLike(Santipestim santipestim,
			Pagination pagination, Boolean startsWith,
			Boolean mostrarDadosDeBaja);

	/**
	 * Counts rows in the Santipestim table using like.
	 * 
	 * @param santipestim
	 *            Santipestim
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Santipestim santipestim, Boolean startsWith,
			Boolean mostrarDadosDeBaja);
}
