package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Santipdoc;

/**
 * SantipdocDaoImpl  
 *  
 */
 
@Repository
@Transactional
public class SantipdocDaoImpl implements SantipdocDao {
    private JdbcTemplate jdbcTemplate;
	private RowMapper<Santipdoc> rwMap = new RowMapper<Santipdoc>() {
		public Santipdoc mapRow(ResultSet resultSet, int rowNum) throws SQLException {
           return new Santipdoc(
               resultSet.getString("TDID"), resultSet.getString("IDTIPODOC"), resultSet.getString("TDNOMBRE"), resultSet.getString("TDNOMBREE"), resultSet.getString("TDPCODIGO"), resultSet.getDate("TDFECALTA"), resultSet.getDate("TDFECMODIF"), resultSet.getString("TDUSUALTA"), resultSet.getString("TDUSUMODIF"), resultSet.getString("TDTIPO")
           ); } } ;

	/**
     * Method use to set the datasource.
     *
     * @param dataSource DataSource
     * @return
     */
    @Resource
    public void setDataSource(DataSource dataSource) {
    	this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    /**
     * Inserts a single row in the Santipdoc table.
     *
     * @param santipdoc Pagination
     * @return Santipdoc
     */
	public Santipdoc add(Santipdoc santipdoc) {
    	String query = "INSERT INTO SANTIPDOC (TDID, ID_TIPODOC, TDNOMBRE, TDNOMBREE, TDPCODIGO, TDFECALTA, TDFECMODIF, TDUSUALTA, TDUSUMODIF, TDTIPO) VALUES (?,?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, santipdoc.getTdid(), santipdoc.getIdTipodoc(), santipdoc.getTdnombre(), santipdoc.getTdnombree(), santipdoc.getTdpcodigo(), santipdoc.getTdfecalta(), santipdoc.getTdfecmodif(), santipdoc.getTdusualta(), santipdoc.getTdusumodif(), santipdoc.getTdtipo());
		return santipdoc;
	}

    /**
     * Updates a single row in the Santipdoc table.
     *
     * @param santipdoc Pagination
     * @return Santipdoc
     */
    public Santipdoc update(Santipdoc santipdoc) {
		String query = "UPDATE SANTIPDOC SET ID_TIPODOC=?, TDNOMBRE=?, TDNOMBREE=?, TDPCODIGO=?, TDFECALTA=?, TDFECMODIF=?, TDUSUALTA=?, TDUSUMODIF=?, TDTIPO=? WHERE TDID=?";
		this.jdbcTemplate.update(query, santipdoc.getIdTipodoc(), santipdoc.getTdnombre(), santipdoc.getTdnombree(), santipdoc.getTdpcodigo(), santipdoc.getTdfecalta(), santipdoc.getTdfecmodif(), santipdoc.getTdusualta(), santipdoc.getTdusumodif(), santipdoc.getTdtipo(), santipdoc.getTdid());
		return santipdoc;
	}

    /**
     * Finds a single row in the Santipdoc table.
     *
     * @param santipdoc Pagination
     * @return Santipdoc
     */
    @Transactional (readOnly = true)
    public Santipdoc find(Santipdoc santipdoc) {
		String query = "SELECT t1.TDID TDID, t1.ID_TIPODOC IDTIPODOC, t1.TDNOMBRE TDNOMBRE, t1.TDNOMBREE TDNOMBREE, t1.TDPCODIGO TDPCODIGO, t1.TDFECALTA TDFECALTA, t1.TDFECMODIF TDFECMODIF, t1.TDUSUALTA TDUSUALTA, t1.TDUSUMODIF TDUSUMODIF, t1.TDTIPO TDTIPO FROM SANTIPDOC t1  WHERE t1.TDID = ?  ";
		
		List<Santipdoc> santipdocList = this.jdbcTemplate.query(query, this.rwMap, santipdoc.getTdid());
		return (Santipdoc) DataAccessUtils.uniqueResult(santipdocList);
    }

    /**
     * Removes a single row in the Santipdoc table.
     *
     * @param santipdoc Pagination
     * @return
     */
    public void remove(Santipdoc santipdoc) {
		String query = "DELETE FROM SANTIPDOC WHERE TDID=?";
		this.jdbcTemplate.update(query, santipdoc.getTdid());
    }
    
   /**
    * Finds a List of rows in the Santipdoc table.
    * 
    * @param santipdoc Santipdoc
    * @param pagination Pagination
    * @return List 
    */
	@Transactional (readOnly = true)
    public List<Santipdoc> findAll(Santipdoc santipdoc, Pagination pagination) {
		StringBuilder query = new StringBuilder("SELECT  t1.TDID TDID,t1.ID_TIPODOC IDTIPODOC,t1.TDNOMBRE TDNOMBRE,t1.TDNOMBREE TDNOMBREE,t1.TDPCODIGO TDPCODIGO,t1.TDFECALTA TDFECALTA,t1.TDFECMODIF TDFECMODIF,t1.TDUSUALTA TDUSUALTA,t1.TDUSUMODIF TDUSUMODIF,t1.TDTIPO TDTIPO "); 
		query.append("FROM SANTIPDOC t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(santipdoc); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		
		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		
		return (List<Santipdoc>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}
	
    /**
     * Counts rows in the Santipdoc table.
     * 
     * @param santipdoc Santipdoc
     * @return Long
     */
    @Transactional (readOnly = true)
    public Long findAllCount(Santipdoc santipdoc) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM SANTIPDOC t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(santipdoc); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);		
		
		List<?> params = (List<?>) mapaWhere.get("params");
		
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	
	/**
	 * Finds rows in the Santipdoc table using like.
     * 
     * @param santipdoc Santipdoc
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List 
     */
	@Transactional (readOnly = true)
    public List<Santipdoc> findAllLike(Santipdoc santipdoc, Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT  t1.TDID TDID,t1.ID_TIPODOC IDTIPODOC,t1.TDNOMBRE TDNOMBRE,t1.TDNOMBREE TDNOMBREE,t1.TDPCODIGO TDPCODIGO,t1.TDFECALTA TDFECALTA,t1.TDFECMODIF TDFECMODIF,t1.TDUSUALTA TDUSUALTA,t1.TDUSUMODIF TDUSUMODIF,t1.TDTIPO TDTIPO "); 
        query.append("FROM SANTIPDOC t1 ");
      	
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(santipdoc,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		
		return (List<Santipdoc>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}
	
	/**
	 * Counts rows in the Santipdoc table using like.
     * 
     * @param santipdoc Santipdoc
     * @param startsWith Boolean
     * @return Long 
     */
	@Transactional (readOnly = true)
    public Long findAllLikeCount(Santipdoc santipdoc, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM SANTIPDOC t1 ");

		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(santipdoc,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	
	/**
	 * Returns a map with the needed value to create the conditions to filter by 
	 * the Santipdoc entity 
	 * 
	 * @param santipdoc Santipdoc
	 *            Bean with the criteria values to filter by.
	 * @return Map created with two keys
	 *         key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap (Santipdoc santipdoc){
		
		StringBuilder where = new StringBuilder(SantipdocDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (santipdoc  != null  && santipdoc.getTdid() != null ) {
			where.append(" AND t1.TDID = ?");
			params.add(santipdoc.getTdid());
		}
		if (santipdoc  != null  && santipdoc.getIdTipodoc() != null ) {
			where.append(" AND t1.ID_TIPODOC = ?");
			params.add(santipdoc.getIdTipodoc());
		}
		if (santipdoc  != null  && santipdoc.getTdnombre() != null ) {
			where.append(" AND t1.TDNOMBRE = ?");
			params.add(santipdoc.getTdnombre());
		}
		if (santipdoc  != null  && santipdoc.getTdnombree() != null ) {
			where.append(" AND t1.TDNOMBREE = ?");
			params.add(santipdoc.getTdnombree());
		}
		if (santipdoc  != null  && santipdoc.getTdpcodigo() != null ) {
			where.append(" AND t1.TDPCODIGO = ?");
			params.add(santipdoc.getTdpcodigo());
		}
		if (santipdoc  != null  && santipdoc.getTdfecalta() != null ) {
			where.append(" AND t1.TDFECALTA = ?");
			params.add(santipdoc.getTdfecalta());
		}
		if (santipdoc  != null  && santipdoc.getTdfecmodif() != null ) {
			where.append(" AND t1.TDFECMODIF = ?");
			params.add(santipdoc.getTdfecmodif());
		}
		if (santipdoc  != null  && santipdoc.getTdusualta() != null ) {
			where.append(" AND t1.TDUSUALTA = ?");
			params.add(santipdoc.getTdusualta());
		}
		if (santipdoc  != null  && santipdoc.getTdusumodif() != null ) {
			where.append(" AND t1.TDUSUMODIF = ?");
			params.add(santipdoc.getTdusumodif());
		}
		if (santipdoc  != null  && santipdoc.getTdtipo() != null ) {
			where.append(" AND t1.TDTIPO = ?");
			params.add(santipdoc.getTdtipo());
		}

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		
		return mapWhere;		
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA
	
	/**
	 * Returns a map with the needed value to create the conditions to filter by  
	 * the Santipdoc entity 
	 * 
	 * @param santipdoc Santipdoc
	 *            Bean with the criteria values to filter by.
     * @param startsWith Boolean	 
	 * @return Map created with two keys
	 *         key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap (Santipdoc santipdoc, Boolean startsWith){
		
		StringBuilder where = new StringBuilder(SantipdocDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (santipdoc  != null  && santipdoc.getTdid() != null ) {
			where.append(" AND UPPER(t1.TDID) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(santipdoc.getTdid().toUpperCase() +"%");
			}else{
				params.add("%"+santipdoc.getTdid().toUpperCase() +"%");
			}
			where.append(" AND t1.TDID IS NOT NULL");
	     }			
		if (santipdoc  != null  && santipdoc.getIdTipodoc() != null ) {
			where.append(" AND UPPER(t1.ID_TIPODOC) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(santipdoc.getIdTipodoc().toUpperCase() +"%");
			}else{
				params.add("%"+santipdoc.getIdTipodoc().toUpperCase() +"%");
			}
			where.append(" AND t1.ID_TIPODOC IS NOT NULL");
	     }			
		if (santipdoc  != null  && santipdoc.getTdnombre() != null ) {
			where.append(" AND UPPER(t1.TDNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(santipdoc.getTdnombre().toUpperCase() +"%");
			}else{
				params.add("%"+santipdoc.getTdnombre().toUpperCase() +"%");
			}
			where.append(" AND t1.TDNOMBRE IS NOT NULL");
	     }			
		if (santipdoc  != null  && santipdoc.getTdnombree() != null ) {
			where.append(" AND UPPER(t1.TDNOMBREE) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(santipdoc.getTdnombree().toUpperCase() +"%");
			}else{
				params.add("%"+santipdoc.getTdnombree().toUpperCase() +"%");
			}
			where.append(" AND t1.TDNOMBREE IS NOT NULL");
	     }			
		if (santipdoc  != null  && santipdoc.getTdpcodigo() != null ) {
			where.append(" AND UPPER(t1.TDPCODIGO) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(santipdoc.getTdpcodigo().toUpperCase() +"%");
			}else{
				params.add("%"+santipdoc.getTdpcodigo().toUpperCase() +"%");
			}
			where.append(" AND t1.TDPCODIGO IS NOT NULL");
	     }			
		if (santipdoc  != null  && santipdoc.getTdfecalta() != null ) {
			where.append(" AND t1.TDFECALTA = ?");
			params.add(santipdoc.getTdfecalta());
	     }			
		if (santipdoc  != null  && santipdoc.getTdfecmodif() != null ) {
			where.append(" AND t1.TDFECMODIF = ?");
			params.add(santipdoc.getTdfecmodif());
	     }			
		if (santipdoc  != null  && santipdoc.getTdusualta() != null ) {
			where.append(" AND UPPER(t1.TDUSUALTA) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(santipdoc.getTdusualta().toUpperCase() +"%");
			}else{
				params.add("%"+santipdoc.getTdusualta().toUpperCase() +"%");
			}
			where.append(" AND t1.TDUSUALTA IS NOT NULL");
	     }			
		if (santipdoc  != null  && santipdoc.getTdusumodif() != null ) {
			where.append(" AND UPPER(t1.TDUSUMODIF) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(santipdoc.getTdusumodif().toUpperCase() +"%");
			}else{
				params.add("%"+santipdoc.getTdusumodif().toUpperCase() +"%");
			}
			where.append(" AND t1.TDUSUMODIF IS NOT NULL");
	     }			
		if (santipdoc  != null  && santipdoc.getTdtipo() != null ) {
			where.append(" AND UPPER(t1.TDTIPO) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(santipdoc.getTdtipo().toUpperCase() +"%");
			}else{
				params.add("%"+santipdoc.getTdtipo().toUpperCase() +"%");
			}
			where.append(" AND t1.TDTIPO IS NOT NULL");
	     }			

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		
		return mapWhere;		
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA
	
	/**
	 * StringBuilder initilization value
	 */
	 public static final int STRING_BUILDER_INIT = 4096;}

