package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.Santipdoc;

/**
 * SantipdocDao  
 *  
 */

public interface SantipdocDao {
    
    /**
     * Inserts a single row in the Santipdoc table.
     *
     * @param santipdoc Santipdoc
     * @return Santipdoc
     */
    Santipdoc add(Santipdoc santipdoc);

    /**
     * Updates a single row in the Santipdoc table.
     *
     * @param santipdoc Santipdoc
     * @return Santipdoc
     */
    Santipdoc update(Santipdoc santipdoc);

    /**
     * Finds a single row in the Santipdoc table.
     *
     * @param santipdoc Santipdoc
     * @return Santipdoc
     */
    Santipdoc find(Santipdoc santipdoc);

    /**
     * Deletes a single row in the Santipdoc table.
     *
     * @param santipdoc Santipdoc
     * @return 
     */
    void remove(Santipdoc santipdoc);

    /**
     * Finds a List of rows in the Santipdoc table.
     *
     * @param santipdoc Santipdoc
     * @param pagination Pagination
     * @return List
     */
    List<Santipdoc> findAll(Santipdoc santipdoc, Pagination pagination);

    /**
     * Counts rows in the Santipdoc table.
     *
     * @param santipdoc Santipdoc
     * @return Long
     */
    Long findAllCount(Santipdoc santipdoc);
	
	/**
     * Finds rows in the Santipdoc table using like.
     *
     * @param santipdoc Santipdoc
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List
     */
	List<Santipdoc> findAllLike(Santipdoc santipdoc, Pagination pagination, Boolean startsWith);
	
    /**
     * Counts rows in the Santipdoc table using like.
     *
     * @param santipdoc Santipdoc
     * @param startsWith Boolean
     * @return Long
     */
    Long findAllLikeCount(Santipdoc santipdoc, Boolean startsWith);
}

