package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Sanresulsen;

/**
 * SanresulsenDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class SanresulsenDaoImpl implements SanresulsenDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Sanresulsen> rwMap = new RowMapper<Sanresulsen>() {
		public Sanresulsen mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Sanresulsen(resultSet.getString("RSID"),
					resultSet.getString("RSDESCES"),
					resultSet.getString("RSDESCEU"),
					resultSet.getDate("RSFECALTA"),
					resultSet.getDate("RSFECMODIF"),
					resultSet.getString("RSUSUALTA"),
					resultSet.getString("RSUSUMODIF"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Sanresulsen table.
	 * 
	 * @param sanresulsen
	 *            Pagination
	 * @return Sanresulsen
	 */
	public Sanresulsen add(Sanresulsen sanresulsen) {
		String query = "INSERT INTO SANRESULSEN (RSID, RSDESCES, RSDESCEU, RSFECALTA, RSFECMODIF, RSUSUALTA, RSUSUMODIF) VALUES (?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, sanresulsen.getRsid(),
				sanresulsen.getRsdesces(), sanresulsen.getRsdesceu(),
				sanresulsen.getRsfecalta(), sanresulsen.getRsfecmodif(),
				sanresulsen.getRsusualta(), sanresulsen.getRsusumodif());
		return sanresulsen;
	}

	/**
	 * Updates a single row in the Sanresulsen table.
	 * 
	 * @param sanresulsen
	 *            Pagination
	 * @return Sanresulsen
	 */
	public Sanresulsen update(Sanresulsen sanresulsen) {
		String query = "UPDATE SANRESULSEN SET RSDESCES=?, RSDESCEU=?, RSFECALTA=?, RSFECMODIF=?, RSUSUALTA=?, RSUSUMODIF=? WHERE RSID=?";
		this.jdbcTemplate.update(query, sanresulsen.getRsdesces(),
				sanresulsen.getRsdesceu(), sanresulsen.getRsfecalta(),
				sanresulsen.getRsfecmodif(), sanresulsen.getRsusualta(),
				sanresulsen.getRsusumodif(), sanresulsen.getRsid());
		return sanresulsen;
	}

	/**
	 * Finds a single row in the Sanresulsen table.
	 * 
	 * @param sanresulsen
	 *            Pagination
	 * @return Sanresulsen
	 */
	@Transactional(readOnly = true)
	public Sanresulsen find(Sanresulsen sanresulsen) {
		String query = "SELECT t1.RSID RSID, t1.RSDESCES RSDESCES, t1.RSDESCEU RSDESCEU, t1.RSFECALTA RSFECALTA, t1.RSFECMODIF RSFECMODIF, t1.RSUSUALTA RSUSUALTA, t1.RSUSUMODIF RSUSUMODIF FROM SANRESULSEN t1  WHERE t1.RSID = ?  ";

		List<Sanresulsen> sanresulsenList = this.jdbcTemplate.query(query,
				this.rwMap, sanresulsen.getRsid());
		return (Sanresulsen) DataAccessUtils.uniqueResult(sanresulsenList);
	}

	/**
	 * Removes a single row in the Sanresulsen table.
	 * 
	 * @param sanresulsen
	 *            Pagination
	 * @return
	 */
	public void remove(Sanresulsen sanresulsen) {
		String query = "DELETE FROM SANRESULSEN WHERE RSID=?";
		this.jdbcTemplate.update(query, sanresulsen.getRsid());
	}

	/**
	 * Finds a List of rows in the Sanresulsen table.
	 * 
	 * @param sanresulsen
	 *            Sanresulsen
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Sanresulsen> findAll(Sanresulsen sanresulsen,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.RSID RSID,t1.RSDESCES RSDESCES,NVL(t1.RSDESCEU,t1.RSDESCES) RSDESCEU,t1.RSFECALTA RSFECALTA,t1.RSFECMODIF RSFECMODIF,t1.RSUSUALTA RSUSUALTA,t1.RSUSUMODIF RSUSUMODIF ");
		query.append("FROM SANRESULSEN t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(sanresulsen);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Sanresulsen>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Sanresulsen table.
	 * 
	 * @param sanresulsen
	 *            Sanresulsen
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Sanresulsen sanresulsen) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM SANRESULSEN t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(sanresulsen);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Sanresulsen table using like.
	 * 
	 * @param sanresulsen
	 *            Sanresulsen
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Sanresulsen> findAllLike(Sanresulsen sanresulsen,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.RSID RSID,t1.RSDESCES RSDESCES,NVL(t1.RSDESCEU,t1.RSDESCES) RSDESCEU,t1.RSFECALTA RSFECALTA,t1.RSFECMODIF RSFECMODIF,t1.RSUSUALTA RSUSUALTA,t1.RSUSUMODIF RSUSUMODIF ");
		query.append("FROM SANRESULSEN t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(sanresulsen, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Sanresulsen>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Sanresulsen table using like.
	 * 
	 * @param sanresulsen
	 *            Sanresulsen
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Sanresulsen sanresulsen, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM SANRESULSEN t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(sanresulsen, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Sanresulsen entity
	 * 
	 * @param sanresulsen
	 *            Sanresulsen Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Sanresulsen sanresulsen) {

		StringBuilder where = new StringBuilder(
				SanresulsenDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (sanresulsen != null && sanresulsen.getRsid() != null) {
			where.append(" AND t1.RSID = ?");
			params.add(sanresulsen.getRsid());
		}
		if (sanresulsen != null && sanresulsen.getRsdesces() != null) {
			where.append(" AND t1.RSDESCES = ?");
			params.add(sanresulsen.getRsdesces());
		}
		if (sanresulsen != null && sanresulsen.getRsdesceu() != null) {
			where.append(" AND t1.RSDESCEU = ?");
			params.add(sanresulsen.getRsdesceu());
		}
		if (sanresulsen != null && sanresulsen.getRsfecalta() != null) {
			where.append(" AND t1.RSFECALTA = ?");
			params.add(sanresulsen.getRsfecalta());
		}
		if (sanresulsen != null && sanresulsen.getRsfecmodif() != null) {
			where.append(" AND t1.RSFECMODIF = ?");
			params.add(sanresulsen.getRsfecmodif());
		}
		if (sanresulsen != null && sanresulsen.getRsusualta() != null) {
			where.append(" AND t1.RSUSUALTA = ?");
			params.add(sanresulsen.getRsusualta());
		}
		if (sanresulsen != null && sanresulsen.getRsusumodif() != null) {
			where.append(" AND t1.RSUSUMODIF = ?");
			params.add(sanresulsen.getRsusumodif());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Sanresulsen entity
	 * 
	 * @param sanresulsen
	 *            Sanresulsen Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Sanresulsen sanresulsen,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				SanresulsenDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (sanresulsen != null && sanresulsen.getRsid() != null) {
			where.append(" AND UPPER(t1.RSID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanresulsen.getRsid().toUpperCase() + "%");
			} else {
				params.add("%" + sanresulsen.getRsid().toUpperCase() + "%");
			}
			where.append(" AND t1.RSID IS NOT NULL");
		}
		if (sanresulsen != null && sanresulsen.getRsdesces() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.RSDESCES),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanresulsen.getRsdesces().toUpperCase()
						.replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O")
						.replaceAll("", "U")
						+ "%");
			} else {
				params.add("%"
						+ sanresulsen.getRsdesces().toUpperCase()
								.replaceAll("", "A").replaceAll("", "E")
								.replaceAll("", "I").replaceAll("", "O")
								.replaceAll("", "U") + "%");
			}
			where.append(" AND t1.RSDESCES IS NOT NULL");
		}
		if (sanresulsen != null && sanresulsen.getRsdesceu() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.RSDESCEU),'','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanresulsen.getRsdesceu().toUpperCase()
						.replaceAll("", "A").replaceAll("", "E")
						.replaceAll("", "I").replaceAll("", "O")
						.replaceAll("", "U")
						+ "%");
			} else {
				params.add("%"
						+ sanresulsen.getRsdesceu().toUpperCase()
								.replaceAll("", "A").replaceAll("", "E")
								.replaceAll("", "I").replaceAll("", "O")
								.replaceAll("", "U") + "%");
			}
			where.append(" AND t1.RSDESCEU IS NOT NULL");
		}
		if (sanresulsen != null && sanresulsen.getRsfecalta() != null) {
			where.append(" AND t1.RSFECALTA = ?");
			params.add(sanresulsen.getRsfecalta());
		}
		if (sanresulsen != null && sanresulsen.getRsfecmodif() != null) {
			where.append(" AND t1.RSFECMODIF = ?");
			params.add(sanresulsen.getRsfecmodif());
		}
		if (sanresulsen != null && sanresulsen.getRsusualta() != null) {
			where.append(" AND UPPER(t1.RSUSUALTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanresulsen.getRsusualta().toUpperCase() + "%");
			} else {
				params.add("%" + sanresulsen.getRsusualta().toUpperCase() + "%");
			}
			where.append(" AND t1.RSUSUALTA IS NOT NULL");
		}
		if (sanresulsen != null && sanresulsen.getRsusumodif() != null) {
			where.append(" AND UPPER(t1.RSUSUMODIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanresulsen.getRsusumodif().toUpperCase() + "%");
			} else {
				params.add("%" + sanresulsen.getRsusumodif().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.RSUSUMODIF IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
