package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.Sanresulsen;

/**
 * SanresulsenDao  
 * 
 *  
 */

public interface SanresulsenDao {

	/**
	 * Inserts a single row in the Sanresulsen table.
	 * 
	 * @param sanresulsen
	 *            Sanresulsen
	 * @return Sanresulsen
	 */
	Sanresulsen add(Sanresulsen sanresulsen);

	/**
	 * Updates a single row in the Sanresulsen table.
	 * 
	 * @param sanresulsen
	 *            Sanresulsen
	 * @return Sanresulsen
	 */
	Sanresulsen update(Sanresulsen sanresulsen);

	/**
	 * Finds a single row in the Sanresulsen table.
	 * 
	 * @param sanresulsen
	 *            Sanresulsen
	 * @return Sanresulsen
	 */
	Sanresulsen find(Sanresulsen sanresulsen);

	/**
	 * Deletes a single row in the Sanresulsen table.
	 * 
	 * @param sanresulsen
	 *            Sanresulsen
	 * @return
	 */
	void remove(Sanresulsen sanresulsen);

	/**
	 * Finds a List of rows in the Sanresulsen table.
	 * 
	 * @param sanresulsen
	 *            Sanresulsen
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Sanresulsen> findAll(Sanresulsen sanresulsen, Pagination pagination);

	/**
	 * Counts rows in the Sanresulsen table.
	 * 
	 * @param sanresulsen
	 *            Sanresulsen
	 * @return Long
	 */
	Long findAllCount(Sanresulsen sanresulsen);

	/**
	 * Finds rows in the Sanresulsen table using like.
	 * 
	 * @param sanresulsen
	 *            Sanresulsen
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Sanresulsen> findAllLike(Sanresulsen sanresulsen,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Sanresulsen table using like.
	 * 
	 * @param sanresulsen
	 *            Sanresulsen
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Sanresulsen sanresulsen, Boolean startsWith);
}
