package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Sancuesfondo;
import com.ejie.y41b.model.Sancuesproced;
import com.ejie.y41b.model.Sanresulsen;
import com.ejie.y41b.model.Tribunal;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Sanrecrca;
import com.ejie.y41b.utils.Y41bUtils;

/**
 * SanrecrcaDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class SanrecrcaDaoImpl implements SanrecrcaDao {
	private JdbcTemplate jdbcTemplate;

	private static final Logger logger = LoggerFactory
			.getLogger(SanrecrcaDaoImpl.class);

	private RowMapper<Sanrecrca> rwMap = new RowMapper<Sanrecrca>() {
		public Sanrecrca mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Sanrecrca(
					resultSet.getString("RECODIGO"),
					resultSet.getDate("RERCAFECENV"),
					resultSet.getString("RERCANUMSEN"),
					new Sanresulsen(resultSet.getString("RERCASEN"), null,
							null, null, null, null, null),
					new Tribunal(resultSet.getString("RERCATRIB"), null, null),
					resultSet.getString("RERCASALA"),
					resultSet.getString("RERCAACUE"),
					resultSet.getDate("RERCAFECDEV"),
					resultSet.getBigDecimal("RERCAIMPDEV") == null ? null
							: resultSet.getBigDecimal("RERCAIMPDEV").toString(),
					resultSet.getString("RERCAABO"), resultSet
							.getString("RERCANOTA"), resultSet
							.getDate("REFECALTA"), resultSet
							.getDate("REFECMODIF"), resultSet
							.getString("REUSUALTA"), resultSet
							.getString("REUSUMODIF"), new Sancuesfondo(
							resultSet.getString("SancuesfondoCFCODIGO"),
							resultSet.getString("SancuesfondoCFDESCES"),
							resultSet.getString("SancuesfondoCFDESCEU"),
							resultSet.getDate("SancuesfondoCFFECALTA"),
							resultSet.getDate("SancuesfondoCFFECMODIF"),
							resultSet.getString("SancuesfondoCFUSUALTA"),
							resultSet.getString("SancuesfondoCFUSUMODIF")),
					new Sancuesproced(resultSet
							.getString("SancuesprocedCPCODIGO"), resultSet
							.getString("SancuesprocedCPDESCES"), resultSet
							.getString("SancuesprocedCPDESCEU"), resultSet
							.getDate("SancuesprocedCPFECALTA"), resultSet
							.getDate("SancuesprocedCPFECMODIF"), resultSet
							.getString("SancuesprocedCPUSUALTA"), resultSet
							.getString("SancuesprocedCPUSUMODIF")));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Sanrecrca table.
	 * 
	 * @param sanrecrca
	 *            Pagination
	 * @return Sanrecrca
	 */
	public Sanrecrca add(Sanrecrca sanrecrca) {
		String query = "INSERT INTO SANRECRCA (RECODIGO, RERCACFON, RERCACPROC, RERCAFECENV, RERCANUMSEN, RERCASEN, RERCATRIB, RERCASALA, RERCAACUE, RERCAFECDEV, RERCAIMPDEV, RERCAABO, RERCANOTA, REFECALTA, REFECMODIF, REUSUALTA, REUSUMODIF) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		Object getSancuesfondoCfcodigoAux = null;
		if (sanrecrca.getSancuesfondo() != null
				&& sanrecrca.getSancuesfondo().getCfcodigo() != null) {
			getSancuesfondoCfcodigoAux = sanrecrca.getSancuesfondo()
					.getCfcodigo();
		}
		Object getSancuesprocedCpcodigoAux = null;
		if (sanrecrca.getSancuesproced() != null
				&& sanrecrca.getSancuesproced().getCpcodigo() != null) {
			getSancuesprocedCpcodigoAux = sanrecrca.getSancuesproced()
					.getCpcodigo();
		}
		Object getSantribunalTbcodigoAux = null;
		if (sanrecrca.getTribunal() != null
				&& sanrecrca.getTribunal().getTbcodigo() != null) {
			getSantribunalTbcodigoAux = sanrecrca.getTribunal().getTbcodigo();
		}
		this.jdbcTemplate.update(query, sanrecrca.getRecodigo(),
				getSancuesfondoCfcodigoAux, getSancuesprocedCpcodigoAux,
				sanrecrca.getRercafecenv(), sanrecrca.getRercanumsen(),
				sanrecrca.getSanresulsen().getRsid(),
				getSantribunalTbcodigoAux, sanrecrca.getRercasala(),
				sanrecrca.getRercaacue(), sanrecrca.getRercafecdev(),
				Y41bUtils.normalizarBigDecimal(sanrecrca.getRercaimpdev()),
				sanrecrca.getRercaabo(), sanrecrca.getRercanota(),
				sanrecrca.getRefecalta(), sanrecrca.getRefecmodif(),
				sanrecrca.getReusualta(), sanrecrca.getReusumodif());

		return sanrecrca;
	}

	/**
	 * Updates a single row in the Sanrecrca table.
	 * 
	 * @param sanrecrca
	 *            Pagination
	 * @return Sanrecrca
	 * @throws Exception
	 */
	public Sanrecrca update(Sanrecrca sanrecrca) {
		String query = "UPDATE SANRECRCA SET RERCACFON=?, RERCACPROC=?, RERCAFECENV=?, RERCANUMSEN=?, RERCASEN=?, RERCATRIB=?, RERCASALA=?, RERCAACUE=?, RERCAFECDEV=?, RERCAIMPDEV=?, RERCAABO=?, RERCANOTA=?, REFECALTA=?, REFECMODIF=?, REUSUALTA=?, REUSUMODIF=? WHERE RECODIGO=?";
		Object getSancuesfondoCfcodigoAux = null;
		if (sanrecrca.getSancuesfondo() != null
				&& sanrecrca.getSancuesfondo().getCfcodigo() != null) {
			getSancuesfondoCfcodigoAux = sanrecrca.getSancuesfondo()
					.getCfcodigo();
		}
		Object getSancuesprocedCpcodigoAux = null;
		if (sanrecrca.getSancuesproced() != null
				&& sanrecrca.getSancuesproced().getCpcodigo() != null) {
			getSancuesprocedCpcodigoAux = sanrecrca.getSancuesproced()
					.getCpcodigo();
		}
		Object getSantribunalTbcodigoAux = null;
		if (sanrecrca.getTribunal() != null
				&& sanrecrca.getTribunal().getTbcodigo() != null) {
			getSantribunalTbcodigoAux = sanrecrca.getTribunal().getTbcodigo();
		}
		Object[] params = { getSancuesfondoCfcodigoAux,
				getSancuesprocedCpcodigoAux, sanrecrca.getRercafecenv(),
				sanrecrca.getRercanumsen(),
				sanrecrca.getSanresulsen().getRsid(),
				getSantribunalTbcodigoAux, sanrecrca.getRercasala(),
				sanrecrca.getRercaacue(), sanrecrca.getRercafecdev(),
				Y41bUtils.normalizarBigDecimal(sanrecrca.getRercaimpdev()),
				sanrecrca.getRercaabo(), sanrecrca.getRercanota(),
				sanrecrca.getRefecalta(), sanrecrca.getRefecmodif(),
				sanrecrca.getReusualta(), sanrecrca.getReusumodif(),
				sanrecrca.getRecodigo() };
		try {
			this.logger.info(Y41bUtils.dameSQL(query, params));
		} catch (Exception e) {

		}
		this.jdbcTemplate.update(query, getSancuesfondoCfcodigoAux,
				getSancuesprocedCpcodigoAux, sanrecrca.getRercafecenv(),
				sanrecrca.getRercanumsen(), sanrecrca.getSanresulsen()
						.getRsid(), getSantribunalTbcodigoAux, sanrecrca
						.getRercasala(), sanrecrca.getRercaacue(), sanrecrca
						.getRercafecdev(), Y41bUtils
						.normalizarBigDecimal(sanrecrca.getRercaimpdev()),
				sanrecrca.getRercaabo(), sanrecrca.getRercanota(), sanrecrca
						.getRefecalta(), sanrecrca.getRefecmodif(), sanrecrca
						.getReusualta(), sanrecrca.getReusumodif(), sanrecrca
						.getRecodigo());
		return sanrecrca;
	}

	/**
	 * Finds a single row in the Sanrecrca table.
	 * 
	 * @param sanrecrca
	 *            Pagination
	 * @return Sanrecrca
	 */
	@Transactional(readOnly = true)
	public Sanrecrca find(Sanrecrca sanrecrca) {
		String query = "SELECT t1.RECODIGO RECODIGO, t1.RERCAFECENV RERCAFECENV, t1.RERCANUMSEN RERCANUMSEN,t1.RERCASEN RERCASEN, t1.RERCATRIB RERCATRIB, t1.RERCASALA RERCASALA, t1.RERCAACUE RERCAACUE, t1.RERCAFECDEV RERCAFECDEV, t1.RERCAIMPDEV RERCAIMPDEV, t1.RERCAABO RERCAABO, t1.RERCANOTA RERCANOTA, t1.REFECALTA REFECALTA, t1.REFECMODIF REFECMODIF, t1.REUSUALTA REUSUALTA, t1.REUSUMODIF REUSUMODIF, t2.CFCODIGO SANCUESFONDOCFCODIGO, t2.CFDESCES SANCUESFONDOCFDESCES, t2.CFDESCEU SANCUESFONDOCFDESCEU, t2.CFFECALTA SANCUESFONDOCFFECALTA, t2.CFFECMODIF SANCUESFONDOCFFECMODIF, t2.CFUSUALTA SANCUESFONDOCFUSUALTA, t2.CFUSUMODIF SANCUESFONDOCFUSUMODIF, t3.CPCODIGO SANCUESPROCEDCPCODIGO, t3.CPDESCES SANCUESPROCEDCPDESCES, t3.CPDESCEU SANCUESPROCEDCPDESCEU, t3.CPFECALTA SANCUESPROCEDCPFECALTA, t3.CPFECMODIF SANCUESPROCEDCPFECMODIF, t3.CPUSUALTA SANCUESPROCEDCPUSUALTA, t3.CPUSUMODIF SANCUESPROCEDCPUSUMODIF FROM SANRECRCA t1 , SANCUESFONDO t2 , SANCUESPROCED t3  WHERE t1.RECODIGO = ?   AND t1.RERCACFON= t2.CFCODIGO(+) AND t1.RERCACPROC= t3.CPCODIGO(+)";

		List<Sanrecrca> sanrecrcaList = this.jdbcTemplate.query(query,
				this.rwMap, sanrecrca.getRecodigo());
		return (Sanrecrca) DataAccessUtils.uniqueResult(sanrecrcaList);
	}

	/**
	 * Removes a single row in the Sanrecrca table.
	 * 
	 * @param sanrecrca
	 *            Pagination
	 * @return
	 */
	public void remove(Sanrecrca sanrecrca) {
		String query = "DELETE FROM SANRECRCA WHERE RECODIGO=?";
		this.jdbcTemplate.update(query, sanrecrca.getRecodigo());
	}

	/**
	 * Finds a List of rows in the Sanrecrca table.
	 * 
	 * @param sanrecrca
	 *            Sanrecrca
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Sanrecrca> findAll(Sanrecrca sanrecrca, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.RECODIGO RECODIGO,t1.RERCAFECENV RERCAFECENV,t1.RERCANUMSEN RERCANUMSEN,t1.RERCASEN RERCASEN,t1.RERCATRIB RERCATRIB,t1.RERCASALA RERCASALA,t1.RERCAACUE RERCAACUE,t1.RERCAFECDEV RERCAFECDEV,t1.RERCAIMPDEV RERCAIMPDEV,t1.RERCAABO RERCAABO,t1.RERCANOTA RERCANOTA,t1.REFECALTA REFECALTA,t1.REFECMODIF REFECMODIF,t1.REUSUALTA REUSUALTA,t1.REUSUMODIF REUSUMODIF,t2.CFCODIGO SANCUESFONDOCFCODIGO,t2.CFDESCES SANCUESFONDOCFDESCES,t2.CFDESCEU SANCUESFONDOCFDESCEU,t2.CFFECALTA SANCUESFONDOCFFECALTA,t2.CFFECMODIF SANCUESFONDOCFFECMODIF,t2.CFUSUALTA SANCUESFONDOCFUSUALTA,t2.CFUSUMODIF SANCUESFONDOCFUSUMODIF,t3.CPCODIGO SANCUESPROCEDCPCODIGO,t3.CPDESCES SANCUESPROCEDCPDESCES,t3.CPDESCEU SANCUESPROCEDCPDESCEU,t3.CPFECALTA SANCUESPROCEDCPFECALTA,t3.CPFECMODIF SANCUESPROCEDCPFECMODIF,t3.CPUSUALTA SANCUESPROCEDCPUSUALTA,t3.CPUSUMODIF SANCUESPROCEDCPUSUMODIF ");
		query.append("FROM SANRECRCA t1 ,SANCUESFONDO t2 ,SANCUESPROCED t3 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(sanrecrca);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.RERCACFON= t2.CFCODIGO(+) AND t1.RERCACPROC= t3.CPCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Sanrecrca>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Sanrecrca table.
	 * 
	 * @param sanrecrca
	 *            Sanrecrca
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Sanrecrca sanrecrca) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM SANRECRCA t1 , SANCUESFONDO t2 , SANCUESPROCED t3 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(sanrecrca);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.RERCACFON= t2.CFCODIGO(+) AND t1.RERCACPROC= t3.CPCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Sanrecrca table using like.
	 * 
	 * @param sanrecrca
	 *            Sanrecrca
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Sanrecrca> findAllLike(Sanrecrca sanrecrca,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.RECODIGO RECODIGO,t1.RERCAFECENV RERCAFECENV,t1.RERCANUMSEN RERCANUMSEN,t1.RERCASEN RERCASEN,t1.RERCATRIB RERCATRIB,t1.RERCASALA RERCASALA,t1.RERCAACUE RERCAACUE,t1.RERCAFECDEV RERCAFECDEV,t1.RERCAIMPDEV RERCAIMPDEV,t1.RERCAABO RERCAABO,t1.RERCANOTA RERCANOTA,t1.REFECALTA REFECALTA,t1.REFECMODIF REFECMODIF,t1.REUSUALTA REUSUALTA,t1.REUSUMODIF REUSUMODIF,t2.CFCODIGO SANCUESFONDOCFCODIGO,t2.CFDESCES SANCUESFONDOCFDESCES,t2.CFDESCEU SANCUESFONDOCFDESCEU,t2.CFFECALTA SANCUESFONDOCFFECALTA,t2.CFFECMODIF SANCUESFONDOCFFECMODIF,t2.CFUSUALTA SANCUESFONDOCFUSUALTA,t2.CFUSUMODIF SANCUESFONDOCFUSUMODIF,t3.CPCODIGO SANCUESPROCEDCPCODIGO,t3.CPDESCES SANCUESPROCEDCPDESCES,t3.CPDESCEU SANCUESPROCEDCPDESCEU,t3.CPFECALTA SANCUESPROCEDCPFECALTA,t3.CPFECMODIF SANCUESPROCEDCPFECMODIF,t3.CPUSUALTA SANCUESPROCEDCPUSUALTA,t3.CPUSUMODIF SANCUESPROCEDCPUSUMODIF ");
		query.append("FROM SANRECRCA t1 ,SANCUESFONDO t2 ,SANCUESPROCED t3 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(sanrecrca, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.RERCACFON= t2.CFCODIGO(+) AND t1.RERCACPROC= t3.CPCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Sanrecrca>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Sanrecrca table using like.
	 * 
	 * @param sanrecrca
	 *            Sanrecrca
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Sanrecrca sanrecrca, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM SANRECRCA t1 ,SANCUESFONDO t2 ,SANCUESPROCED t3 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(sanrecrca, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.RERCACFON= t2.CFCODIGO(+) AND t1.RERCACPROC= t3.CPCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Sanrecrca entity
	 * 
	 * @param sanrecrca
	 *            Sanrecrca Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Sanrecrca sanrecrca) {

		StringBuilder where = new StringBuilder(
				SanrecrcaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (sanrecrca != null && sanrecrca.getRecodigo() != null) {
			where.append(" AND t1.RECODIGO = ?");
			params.add(sanrecrca.getRecodigo());
		}
		if (sanrecrca != null && sanrecrca.getSancuesfondo() != null
				&& sanrecrca.getSancuesfondo().getCfcodigo() != null) {
			where.append(" AND t2.CFCODIGO = ?");
			params.add(sanrecrca.getSancuesfondo().getCfcodigo());
		}
		if (sanrecrca != null && sanrecrca.getSancuesfondo() != null
				&& sanrecrca.getSancuesfondo().getCfdesces() != null) {
			where.append(" AND t2.CFDESCES = ?");
			params.add(sanrecrca.getSancuesfondo().getCfdesces());
		}
		if (sanrecrca != null && sanrecrca.getSancuesfondo() != null
				&& sanrecrca.getSancuesfondo().getCfdesceu() != null) {
			where.append(" AND t2.CFDESCEU = ?");
			params.add(sanrecrca.getSancuesfondo().getCfdesceu());
		}
		if (sanrecrca != null && sanrecrca.getSancuesfondo() != null
				&& sanrecrca.getSancuesfondo().getCffecalta() != null) {
			where.append(" AND t2.CFFECALTA = ?");
			params.add(sanrecrca.getSancuesfondo().getCffecalta());
		}
		if (sanrecrca != null && sanrecrca.getSancuesfondo() != null
				&& sanrecrca.getSancuesfondo().getCffecmodif() != null) {
			where.append(" AND t2.CFFECMODIF = ?");
			params.add(sanrecrca.getSancuesfondo().getCffecmodif());
		}
		if (sanrecrca != null && sanrecrca.getSancuesfondo() != null
				&& sanrecrca.getSancuesfondo().getCfusualta() != null) {
			where.append(" AND t2.CFUSUALTA = ?");
			params.add(sanrecrca.getSancuesfondo().getCfusualta());
		}
		if (sanrecrca != null && sanrecrca.getSancuesfondo() != null
				&& sanrecrca.getSancuesfondo().getCfusumodif() != null) {
			where.append(" AND t2.CFUSUMODIF = ?");
			params.add(sanrecrca.getSancuesfondo().getCfusumodif());
		}
		if (sanrecrca != null && sanrecrca.getSancuesproced() != null
				&& sanrecrca.getSancuesproced().getCpcodigo() != null) {
			where.append(" AND t3.CPCODIGO = ?");
			params.add(sanrecrca.getSancuesproced().getCpcodigo());
		}
		if (sanrecrca != null && sanrecrca.getSancuesproced() != null
				&& sanrecrca.getSancuesproced().getCpdesces() != null) {
			where.append(" AND t3.CPDESCES = ?");
			params.add(sanrecrca.getSancuesproced().getCpdesces());
		}
		if (sanrecrca != null && sanrecrca.getSancuesproced() != null
				&& sanrecrca.getSancuesproced().getCpdesceu() != null) {
			where.append(" AND t3.CPDESCEU = ?");
			params.add(sanrecrca.getSancuesproced().getCpdesceu());
		}
		if (sanrecrca != null && sanrecrca.getSancuesproced() != null
				&& sanrecrca.getSancuesproced().getCpfecalta() != null) {
			where.append(" AND t3.CPFECALTA = ?");
			params.add(sanrecrca.getSancuesproced().getCpfecalta());
		}
		if (sanrecrca != null && sanrecrca.getSancuesproced() != null
				&& sanrecrca.getSancuesproced().getCpfecmodif() != null) {
			where.append(" AND t3.CPFECMODIF = ?");
			params.add(sanrecrca.getSancuesproced().getCpfecmodif());
		}
		if (sanrecrca != null && sanrecrca.getSancuesproced() != null
				&& sanrecrca.getSancuesproced().getCpusualta() != null) {
			where.append(" AND t3.CPUSUALTA = ?");
			params.add(sanrecrca.getSancuesproced().getCpusualta());
		}
		if (sanrecrca != null && sanrecrca.getSancuesproced() != null
				&& sanrecrca.getSancuesproced().getCpusumodif() != null) {
			where.append(" AND t3.CPUSUMODIF = ?");
			params.add(sanrecrca.getSancuesproced().getCpusumodif());
		}
		if (sanrecrca != null && sanrecrca.getRercafecenv() != null) {
			where.append(" AND t1.RERCAFECENV = ?");
			params.add(sanrecrca.getRercafecenv());
		}
		if (sanrecrca != null && sanrecrca.getSanresulsen() != null
				&& sanrecrca.getSanresulsen().getRsid() != null) {
			where.append(" AND t1.RERCASEN = ?");
			params.add(sanrecrca.getSanresulsen().getRsid());
		}
		if (sanrecrca != null && sanrecrca.getRercanumsen() != null) {
			where.append(" AND t1.RERCANUMSEN = ?");
			params.add(sanrecrca.getRercanumsen());
		}
		if (sanrecrca != null && sanrecrca.getTribunal() != null
				&& sanrecrca.getTribunal().getTbcodigo() != null) {
			where.append(" AND t1.RERCATRIB = ?");
			params.add(sanrecrca.getTribunal().getTbcodigo());
		}
		if (sanrecrca != null && sanrecrca.getRercasala() != null) {
			where.append(" AND t1.RERCASALA = ?");
			params.add(sanrecrca.getRercasala());
		}
		if (sanrecrca != null && sanrecrca.getRercaacue() != null) {
			where.append(" AND t1.RERCAACUE = ?");
			params.add(sanrecrca.getRercaacue());
		}
		if (sanrecrca != null && sanrecrca.getRercafecdev() != null) {
			where.append(" AND t1.RERCAFECDEV = ?");
			params.add(sanrecrca.getRercafecdev());
		}
		if (sanrecrca != null && sanrecrca.getRercaimpdev() != null) {
			where.append(" AND t1.RERCAIMPDEV = ?");
			params.add(Y41bUtils.normalizarBigDecimal(sanrecrca
					.getRercaimpdev()));
		}
		if (sanrecrca != null && sanrecrca.getRercaabo() != null) {
			where.append(" AND t1.RERCAABO = ?");
			params.add(sanrecrca.getRercaabo());
		}
		if (sanrecrca != null && sanrecrca.getRercanota() != null) {
			where.append(" AND t1.RERCANOTA = ?");
			params.add(sanrecrca.getRercanota());
		}
		if (sanrecrca != null && sanrecrca.getRefecalta() != null) {
			where.append(" AND t1.REFECALTA = ?");
			params.add(sanrecrca.getRefecalta());
		}
		if (sanrecrca != null && sanrecrca.getRefecmodif() != null) {
			where.append(" AND t1.REFECMODIF = ?");
			params.add(sanrecrca.getRefecmodif());
		}
		if (sanrecrca != null && sanrecrca.getReusualta() != null) {
			where.append(" AND t1.REUSUALTA = ?");
			params.add(sanrecrca.getReusualta());
		}
		if (sanrecrca != null && sanrecrca.getReusumodif() != null) {
			where.append(" AND t1.REUSUMODIF = ?");
			params.add(sanrecrca.getReusumodif());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Sanrecrca entity
	 * 
	 * @param sanrecrca
	 *            Sanrecrca Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Sanrecrca sanrecrca,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				SanrecrcaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (sanrecrca != null && sanrecrca.getRecodigo() != null) {
			where.append(" AND UPPER(t1.RECODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanrecrca.getRecodigo().toUpperCase() + "%");
			} else {
				params.add("%" + sanrecrca.getRecodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.RECODIGO IS NOT NULL");
		}
		if (sanrecrca != null && sanrecrca.getSancuesfondo() != null
				&& sanrecrca.getSancuesfondo().getCfcodigo() != null) {
			where.append(" AND t2.CFCODIGO = ?");
			params.add(sanrecrca.getSancuesfondo().getCfcodigo());
		}
		if (sanrecrca != null && sanrecrca.getSancuesfondo() != null
				&& sanrecrca.getSancuesfondo().getCfdesces() != null) {
			where.append(" AND UPPER(t2.CFDESCES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanrecrca.getSancuesfondo().getCfdesces()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanrecrca.getSancuesfondo().getCfdesces()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.CFDESCES IS NOT NULL");
		}
		if (sanrecrca != null && sanrecrca.getSancuesfondo() != null
				&& sanrecrca.getSancuesfondo().getCfdesceu() != null) {
			where.append(" AND UPPER(t2.CFDESCEU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanrecrca.getSancuesfondo().getCfdesceu()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanrecrca.getSancuesfondo().getCfdesceu()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.CFDESCEU IS NOT NULL");
		}
		if (sanrecrca != null && sanrecrca.getSancuesfondo() != null
				&& sanrecrca.getSancuesfondo().getCffecalta() != null) {
			where.append(" AND t2.CFFECALTA = ?");
			params.add(sanrecrca.getSancuesfondo().getCffecalta());
		}
		if (sanrecrca != null && sanrecrca.getSancuesfondo() != null
				&& sanrecrca.getSancuesfondo().getCffecmodif() != null) {
			where.append(" AND t2.CFFECMODIF = ?");
			params.add(sanrecrca.getSancuesfondo().getCffecmodif());
		}
		if (sanrecrca != null && sanrecrca.getSancuesfondo() != null
				&& sanrecrca.getSancuesfondo().getCfusualta() != null) {
			where.append(" AND UPPER(t2.CFUSUALTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanrecrca.getSancuesfondo().getCfusualta()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanrecrca.getSancuesfondo().getCfusualta()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.CFUSUALTA IS NOT NULL");
		}
		if (sanrecrca != null && sanrecrca.getSancuesfondo() != null
				&& sanrecrca.getSancuesfondo().getCfusumodif() != null) {
			where.append(" AND UPPER(t2.CFUSUMODIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanrecrca.getSancuesfondo().getCfusumodif()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanrecrca.getSancuesfondo().getCfusumodif()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.CFUSUMODIF IS NOT NULL");
		}
		if (sanrecrca != null && sanrecrca.getSancuesproced() != null
				&& sanrecrca.getSancuesproced().getCpcodigo() != null) {
			where.append(" AND t3.CPCODIGO = ?");
			params.add(sanrecrca.getSancuesproced().getCpcodigo());
		}
		if (sanrecrca != null && sanrecrca.getSancuesproced() != null
				&& sanrecrca.getSancuesproced().getCpdesces() != null) {
			where.append(" AND UPPER(t3.CPDESCES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanrecrca.getSancuesproced().getCpdesces()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanrecrca.getSancuesproced().getCpdesces()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.CPDESCES IS NOT NULL");
		}
		if (sanrecrca != null && sanrecrca.getSancuesproced() != null
				&& sanrecrca.getSancuesproced().getCpdesceu() != null) {
			where.append(" AND UPPER(t3.CPDESCEU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanrecrca.getSancuesproced().getCpdesceu()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanrecrca.getSancuesproced().getCpdesceu()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.CPDESCEU IS NOT NULL");
		}
		if (sanrecrca != null && sanrecrca.getSancuesproced() != null
				&& sanrecrca.getSancuesproced().getCpfecalta() != null) {
			where.append(" AND t3.CPFECALTA = ?");
			params.add(sanrecrca.getSancuesproced().getCpfecalta());
		}
		if (sanrecrca != null && sanrecrca.getSancuesproced() != null
				&& sanrecrca.getSancuesproced().getCpfecmodif() != null) {
			where.append(" AND t3.CPFECMODIF = ?");
			params.add(sanrecrca.getSancuesproced().getCpfecmodif());
		}
		if (sanrecrca != null && sanrecrca.getSancuesproced() != null
				&& sanrecrca.getSancuesproced().getCpusualta() != null) {
			where.append(" AND UPPER(t3.CPUSUALTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanrecrca.getSancuesproced().getCpusualta()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanrecrca.getSancuesproced().getCpusualta()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.CPUSUALTA IS NOT NULL");
		}
		if (sanrecrca != null && sanrecrca.getSancuesproced() != null
				&& sanrecrca.getSancuesproced().getCpusumodif() != null) {
			where.append(" AND UPPER(t3.CPUSUMODIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanrecrca.getSancuesproced().getCpusumodif()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanrecrca.getSancuesproced().getCpusumodif()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.CPUSUMODIF IS NOT NULL");
		}
		if (sanrecrca != null && sanrecrca.getRercafecenv() != null) {
			where.append(" AND t1.RERCAFECENV = ?");
			params.add(sanrecrca.getRercafecenv());
		}
		if (sanrecrca != null && sanrecrca.getRercanumsen() != null) {
			where.append(" AND UPPER(t1.RERCANUMSEN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanrecrca.getRercanumsen().toUpperCase() + "%");
			} else {
				params.add("%" + sanrecrca.getRercanumsen().toUpperCase() + "%");
			}
			where.append(" AND t1.RERCANUMSEN IS NOT NULL");
		}
		if (sanrecrca != null && sanrecrca.getSanresulsen() != null
				&& sanrecrca.getSanresulsen().getRsid() != null) {
			where.append(" AND UPPER(t1.RERCASEN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanrecrca.getSanresulsen().getRsid().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanrecrca.getSanresulsen().getRsid().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.RERCASEN IS NOT NULL");
		}
		if (sanrecrca != null && sanrecrca.getTribunal() != null
				&& sanrecrca.getTribunal().getTbcodigo() != null) {
			where.append(" AND UPPER(t1.RERCATRIB) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanrecrca.getTribunal().getTbcodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanrecrca.getTribunal().getTbcodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.RERCATRIB IS NOT NULL");
		}
		if (sanrecrca != null && sanrecrca.getRercasala() != null) {
			where.append(" AND UPPER(t1.RERCASALA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanrecrca.getRercasala().toUpperCase() + "%");
			} else {
				params.add("%" + sanrecrca.getRercasala().toUpperCase() + "%");
			}
			where.append(" AND t1.RERCASALA IS NOT NULL");
		}
		if (sanrecrca != null && sanrecrca.getRercaacue() != null) {
			where.append(" AND UPPER(t1.RERCAACUE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanrecrca.getRercaacue().toUpperCase() + "%");
			} else {
				params.add("%" + sanrecrca.getRercaacue().toUpperCase() + "%");
			}
			where.append(" AND t1.RERCAACUE IS NOT NULL");
		}
		if (sanrecrca != null && sanrecrca.getRercafecdev() != null) {
			where.append(" AND t1.RERCAFECDEV = ?");
			params.add(sanrecrca.getRercafecdev());
		}
		if (sanrecrca != null && sanrecrca.getRercaimpdev() != null) {
			where.append(" AND t1.RERCAIMPDEV = ?");
			params.add(Y41bUtils.normalizarBigDecimal(sanrecrca
					.getRercaimpdev()));
		}
		if (sanrecrca != null && sanrecrca.getRercaabo() != null) {
			where.append(" AND UPPER(t1.RERCAABO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanrecrca.getRercaabo().toUpperCase() + "%");
			} else {
				params.add("%" + sanrecrca.getRercaabo().toUpperCase() + "%");
			}
			where.append(" AND t1.RERCAABO IS NOT NULL");
		}
		if (sanrecrca != null && sanrecrca.getRercanota() != null) {
			where.append(" AND UPPER(t1.RERCANOTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanrecrca.getRercanota().toUpperCase() + "%");
			} else {
				params.add("%" + sanrecrca.getRercanota().toUpperCase() + "%");
			}
			where.append(" AND t1.RERCANOTA IS NOT NULL");
		}
		if (sanrecrca != null && sanrecrca.getRefecalta() != null) {
			where.append(" AND t1.REFECALTA = ?");
			params.add(sanrecrca.getRefecalta());
		}
		if (sanrecrca != null && sanrecrca.getRefecmodif() != null) {
			where.append(" AND t1.REFECMODIF = ?");
			params.add(sanrecrca.getRefecmodif());
		}
		if (sanrecrca != null && sanrecrca.getReusualta() != null) {
			where.append(" AND UPPER(t1.REUSUALTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanrecrca.getReusualta().toUpperCase() + "%");
			} else {
				params.add("%" + sanrecrca.getReusualta().toUpperCase() + "%");
			}
			where.append(" AND t1.REUSUALTA IS NOT NULL");
		}
		if (sanrecrca != null && sanrecrca.getReusumodif() != null) {
			where.append(" AND UPPER(t1.REUSUMODIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanrecrca.getReusumodif().toUpperCase() + "%");
			} else {
				params.add("%" + sanrecrca.getReusumodif().toUpperCase() + "%");
			}
			where.append(" AND t1.REUSUMODIF IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
