package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.Sanrecrca;

/**
 * SanrecrcaDao  
 *  
 */

public interface SanrecrcaDao {
    
    /**
     * Inserts a single row in the Sanrecrca table.
     *
     * @param sanrecrca Sanrecrca
     * @return Sanrecrca
     */
    Sanrecrca add(Sanrecrca sanrecrca);

    /**
     * Updates a single row in the Sanrecrca table.
     *
     * @param sanrecrca Sanrecrca
     * @return Sanrecrca
     */
    Sanrecrca update(Sanrecrca sanrecrca);

    /**
     * Finds a single row in the Sanrecrca table.
     *
     * @param sanrecrca Sanrecrca
     * @return Sanrecrca
     */
    Sanrecrca find(Sanrecrca sanrecrca);

    /**
     * Deletes a single row in the Sanrecrca table.
     *
     * @param sanrecrca Sanrecrca
     * @return 
     */
    void remove(Sanrecrca sanrecrca);

    /**
     * Finds a List of rows in the Sanrecrca table.
     *
     * @param sanrecrca Sanrecrca
     * @param pagination Pagination
     * @return List
     */
    List<Sanrecrca> findAll(Sanrecrca sanrecrca, Pagination pagination);

    /**
     * Counts rows in the Sanrecrca table.
     *
     * @param sanrecrca Sanrecrca
     * @return Long
     */
    Long findAllCount(Sanrecrca sanrecrca);
	
	/**
     * Finds rows in the Sanrecrca table using like.
     *
     * @param sanrecrca Sanrecrca
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List
     */
	List<Sanrecrca> findAllLike(Sanrecrca sanrecrca, Pagination pagination, Boolean startsWith);
	
    /**
     * Counts rows in the Sanrecrca table using like.
     *
     * @param sanrecrca Sanrecrca
     * @param startsWith Boolean
     * @return Long
     */
    Long findAllLikeCount(Sanrecrca sanrecrca, Boolean startsWith);
}

