package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Expedien;
import com.ejie.y41b.model.Sanexp;
import com.ejie.y41b.model.Saninterv;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Sanprue;

/**
 * SanprueDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class SanprueDaoImpl implements SanprueDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Sanprue> rwMap = new RowMapper<Sanprue>() {
		public Sanprue mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Sanprue(resultSet.getBigDecimal("PRID"),
					resultSet.getString("PRESID"),
					resultSet.getString("PRTIPOPRUE"),
					resultSet.getDate("PRFECPRUE"),
					resultSet.getString("PRRES"),
					resultSet.getDate("PRFECPRAC"),
					resultSet.getDate("PRFECALTA"),
					resultSet.getDate("PRFECMODIF"),
					resultSet.getString("PRUSUALTA"),
					resultSet.getString("PRUSUMODIF"), new Saninterv(
							resultSet.getBigDecimal("SanintervUAIDINTERV"),
							resultSet.getString("SanintervUANOMBRE"),
							resultSet.getString("SanintervUAAPELLIDO1"),
							resultSet.getString("SanintervUAAPELLIDO2"),
							resultSet.getString("SanintervUANIF"),
							resultSet.getString("SanintervUANRTEL"),
							resultSet.getString("SanintervUANRTEL2"),
							resultSet.getString("SanintervUAPROVID"),
							resultSet.getString("SanintervUAMUNID"),
							resultSet.getString("SanintervUALOCID"),
							resultSet.getString("SanintervUACALLEID"),
							resultSet.getString("SanintervUACPID"),
							resultSet.getString("SanintervUAPORTALID"),
							resultSet.getString("SanintervUANOMBREPISO"),
							resultSet.getString("SanintervUADIRENOCAPV"),
							resultSet.getString("SanintervUADIREANT"),
							resultSet.getString("SanintervUATIPOINTERV"),
							resultSet.getString("SanintervUADTCODIGO"),
							resultSet.getString("SanintervUAESCODIGO"),
							resultSet.getDate("SanintervUATRFECALTA"),
							resultSet.getDate("SanintervUATRFECMODIF"),
							resultSet.getString("SanintervUATRUSUALTA"),
							resultSet.getString("SanintervUATRUSUMODIF"),
							resultSet.getDate("SanintervUAFECALTA"),
							resultSet.getDate("SanintervUAFECMODIF"),
							resultSet.getString("SanintervUAUSUALTA"),
							resultSet.getString("SanintervUAUSUMODIF"),
							new Expedien(resultSet
									.getString("SanintervUAEXCODIGO"), null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null),
							null, null, null, null, null), new Expedien(
							resultSet.getString("ExpedienEXCODIGO"),
							resultSet.getString("ExpedienEXCOOR"),
							resultSet.getBigDecimal("ExpedienEXNRAN"),
							resultSet.getBigDecimal("ExpedienEXNROR"),
							resultSet.getDate("ExpedienEXFERE"),
							resultSet.getString("ExpedienEXCOIT"),
							resultSet.getString("ExpedienEXCOES"),
							resultSet.getDate("ExpedienEXFEACIN"),
							resultSet.getDate("ExpedienEXFEEMCA"),
							resultSet.getDate("ExpedienEXFEPLCA"),
							resultSet.getDate("ExpedienEXFPNOPC"),
							resultSet.getDate("ExpedienEXFEDE"),
							resultSet.getDate("ExpedienEXFECOAL"),
							resultSet.getDate("ExpedienEXFENOPR"),
							resultSet.getDate("ExpedienEXFEPUPR"),
							resultSet.getString("ExpedienEXCOOSPR"),
							resultSet.getDate("ExpedienEXFEALPR"),
							resultSet.getDate("ExpedienEXFEEL"),
							resultSet.getDate("ExpedienEXFERES"),
							resultSet.getDate("ExpedienEXFENORE"),
							resultSet.getDate("ExpedienEXFEPURE"),
							resultSet.getString("ExpedienEXCOOSRE"),
							resultSet.getString("ExpedienEXCOTTR"),
							resultSet.getBigDecimal("ExpedienEXCAMURE"),
							resultSet.getDate("ExpedienEXFETA"),
							resultSet.getString("ExpedienEXCOTSA"),
							resultSet.getDate("ExpedienEXFECROI"),
							resultSet.getDate("ExpedienEXFEAR"),
							resultSet.getString("ExpedienEXCOORIE"),
							resultSet.getString("ExpedienEXINRE"),
							resultSet.getString("ExpedienEXINCOCO"),
							resultSet.getString("ExpedienEXINEXVA"),
							resultSet.getDate("ExpedienEXFECIRC"),
							resultSet.getDate("ExpedienEXFENOAI"),
							resultSet.getDate("ExpedienEXFECOLM"),
							resultSet.getString("ExpedienEXNUINLM"),
							resultSet.getDate("ExpedienEXFEINMU"),
							resultSet.getDate("ExpedienEXFEAVMU"),
							resultSet.getDate("ExpedienEXFEIMCD"),
							resultSet.getDate("ExpedienEXFECEDE"),
							resultSet.getString("ExpedienEXCOPS"),
							resultSet.getString("ExpedienEXCOSE"), new Sanexp(
									resultSet.getString("ExpedienEXCODIGO")),
							null, null, null));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Sanprue table.
	 * 
	 * @param sanprue
	 *            Pagination
	 * @return Sanprue
	 */
	public Sanprue add(Sanprue sanprue) {
		String query = "INSERT INTO SANPRUE (PRID, PRINID, PREXCODIGO, PRESID, PRTIPOPRUE, PRFECPRUE, PRRES, PRFECPRAC) VALUES (?,?,?,?,?,?,?,?)";
		Object getSanintervUaidintervAux = null;
		if (sanprue.getSaninterv() != null
				&& sanprue.getSaninterv().getUaidinterv() != null) {
			getSanintervUaidintervAux = sanprue.getSaninterv().getUaidinterv();
		}
		Object getExpedienExcodigoAux = null;
		if (sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExcodigo() != null) {
			getExpedienExcodigoAux = sanprue.getExpedien().getExcodigo();
		}
		this.jdbcTemplate.update(query, sanprue.getPrid(),
				getSanintervUaidintervAux, getExpedienExcodigoAux,
				sanprue.getPresid(), sanprue.getPrtipoprue(),
				sanprue.getPrfecprue(), sanprue.getPrres(),
				sanprue.getPrfecprac());
		return sanprue;
	}

	/**
	 * Updates a single row in the Sanprue table.
	 * 
	 * @param sanprue
	 *            Pagination
	 * @return Sanprue
	 */
	public Sanprue update(Sanprue sanprue) {
		String query = "UPDATE SANPRUE SET PRINID=?, PREXCODIGO=?, PRESID=?, PRTIPOPRUE=?, PRFECPRUE=?, PRRES=?, PRFECPRAC=? WHERE PRID=?";
		Object getSanintervUaidintervAux = null;
		if (sanprue.getSaninterv() != null
				&& sanprue.getSaninterv().getUaidinterv() != null) {
			getSanintervUaidintervAux = sanprue.getSaninterv().getUaidinterv();
		}
		Object getExpedienExcodigoAux = null;
		if (sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExcodigo() != null) {
			getExpedienExcodigoAux = sanprue.getExpedien().getExcodigo();
		}
		this.jdbcTemplate.update(query, getSanintervUaidintervAux,
				getExpedienExcodigoAux, sanprue.getPresid(),
				sanprue.getPrtipoprue(), sanprue.getPrfecprue(),
				sanprue.getPrres(), sanprue.getPrfecprac(), sanprue.getPrid());
		return sanprue;
	}

	/**
	 * Finds a single row in the Sanprue table.
	 * 
	 * @param sanprue
	 *            Pagination
	 * @return Sanprue
	 */
	@Transactional(readOnly = true)
	public Sanprue find(Sanprue sanprue) {
		String query = "SELECT t1.PRID PRID, t1.PRESID PRESID, t1.PRTIPOPRUE PRTIPOPRUE, t1.PRFECPRUE PRFECPRUE, t1.PRRES PRRES, t1.PRFECPRAC PRFECPRAC, t1.PRFECALTA PRFECALTA, t1.PRFECMODIF PRFECMODIF, t1.PRUSUALTA PRUSUALTA, t1.PRUSUMODIF PRUSUMODIF, t2.UAIDINTERV SANINTERVUAIDINTERV, t2.UANOMBRE SANINTERVUANOMBRE,t2.UAAPELLIDO1 SANINTERVUAAPELLIDO1,t2.UAAPELLIDO2 SANINTERVUAAPELLIDO2, t2.UANIF SANINTERVUANIF, t2.UANRTEL SANINTERVUANRTEL, t2.UANRTEL2 SANINTERVUANRTEL2, t2.UAPROV_ID SANINTERVUAPROVID, t2.UAMUN_ID SANINTERVUAMUNID, t2.UALOC_ID SANINTERVUALOCID, t2.UACALLE_ID SANINTERVUACALLEID, t2.UACP_ID SANINTERVUACPID, t2.UAPORTAL_ID SANINTERVUAPORTALID, t2.UANOMBRE_PISO SANINTERVUANOMBREPISO, t2.UADIRE_NOCAPV SANINTERVUADIRENOCAPV, t2.UADIRE_ANT SANINTERVUADIREANT, t2.UATIPOINTERV SANINTERVUATIPOINTERV, t2.UADTCODIGO SANINTERVUADTCODIGO, t2.UAESCODIGO SANINTERVUAESCODIGO, t2.UATRFECALTA SANINTERVUATRFECALTA, t2.UATRFECMODIF SANINTERVUATRFECMODIF, t2.UATRUSUALTA SANINTERVUATRUSUALTA, t2.UATRUSUMODIF SANINTERVUATRUSUMODIF, t2.UAFECALTA SANINTERVUAFECALTA, t2.UAFECMODIF SANINTERVUAFECMODIF, t2.UAUSUALTA SANINTERVUAUSUALTA, t2.UAUSUMODIF SANINTERVUAUSUMODIF, t3.EXCODIGO EXPEDIENEXCODIGO, t3.EXCOOR EXPEDIENEXCOOR, t3.EXNRAN EXPEDIENEXNRAN, t3.EXNROR EXPEDIENEXNROR, t3.EXFERE EXPEDIENEXFERE, t3.EXCOIT EXPEDIENEXCOIT, t3.EXCOES EXPEDIENEXCOES, t3.EXFEACIN EXPEDIENEXFEACIN, t3.EXFEEMCA EXPEDIENEXFEEMCA, t3.EXFEPLCA EXPEDIENEXFEPLCA, t3.EXFPNOPC EXPEDIENEXFPNOPC, t3.EXFEDE EXPEDIENEXFEDE, t3.EXFECOAL EXPEDIENEXFECOAL, t3.EXFENOPR EXPEDIENEXFENOPR, t3.EXFEPUPR EXPEDIENEXFEPUPR, t3.EXCOOSPR EXPEDIENEXCOOSPR, t3.EXFEALPR EXPEDIENEXFEALPR, t3.EXFEEL EXPEDIENEXFEEL, t3.EXFERES EXPEDIENEXFERES, t3.EXFENORE EXPEDIENEXFENORE, t3.EXFEPURE EXPEDIENEXFEPURE, t3.EXCOOSRE EXPEDIENEXCOOSRE, t3.EXCOTTR EXPEDIENEXCOTTR, t3.EXCAMURE EXPEDIENEXCAMURE, t3.EXFETA EXPEDIENEXFETA, t3.EXCOTSA EXPEDIENEXCOTSA, t3.EXFECROI EXPEDIENEXFECROI, t3.EXFEAR EXPEDIENEXFEAR, t3.EXCOORIE EXPEDIENEXCOORIE, t3.EXINRE EXPEDIENEXINRE, t3.EXINCOCO EXPEDIENEXINCOCO, t3.EXINEXVA EXPEDIENEXINEXVA, t3.EXFECIRC EXPEDIENEXFECIRC, t3.EXFENOAI EXPEDIENEXFENOAI, t3.EXFECOLM EXPEDIENEXFECOLM, t3.EXNUINLM EXPEDIENEXNUINLM, t3.EXFEINMU EXPEDIENEXFEINMU, t3.EXFEAVMU EXPEDIENEXFEAVMU, t3.EXFEIMCD EXPEDIENEXFEIMCD, t3.EXFECEDE EXPEDIENEXFECEDE, t3.EXCOPS EXPEDIENEXCOPS, t3.EXCOSE EXPEDIENEXCOSE, t2.UAEXCODIGO SANINTERVUAEXCODIGO FROM SANPRUE t1 , SANINTERV t2 , EXPEDIEN t3  WHERE t1.PRID = ?   AND t1.PRINID= t2.UAIDINTERV(+) AND t1.PREXCODIGO= t3.EXCODIGO(+)";

		List<Sanprue> sanprueList = this.jdbcTemplate.query(query, this.rwMap,
				sanprue.getPrid());
		return (Sanprue) DataAccessUtils.uniqueResult(sanprueList);
	}

	/**
	 * Removes a single row in the Sanprue table.
	 * 
	 * @param sanprue
	 *            Pagination
	 * @return
	 */
	public void remove(Sanprue sanprue) {
		String query = "DELETE FROM SANPRUE WHERE PRID=?";
		this.jdbcTemplate.update(query, sanprue.getPrid());
	}

	/**
	 * Finds a List of rows in the Sanprue table.
	 * 
	 * @param sanprue
	 *            Sanprue
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Sanprue> findAll(Sanprue sanprue, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.PRID PRID,t1.PRESID PRESID,t1.PRTIPOPRUE PRTIPOPRUE,t1.PRFECPRUE PRFECPRUE,t1.PRRES PRRES,t1.PRFECPRAC PRFECPRAC,t1.PRFECALTA PRFECALTA,t1.PRFECMODIF PRFECMODIF,t1.PRUSUALTA PRUSUALTA,t1.PRUSUMODIF PRUSUMODIF,t2.UAIDINTERV SANINTERVUAIDINTERV,t2.UANOMBRE SANINTERVUANOMBRE,t2.UAAPELLIDO1 SANINTERVUAAPELLIDO1,t2.UAAPELLIDO2 SANINTERVUAAPELLIDO2,t2.UANIF SANINTERVUANIF,t2.UANRTEL SANINTERVUANRTEL,t2.UANRTEL2 SANINTERVUANRTEL2,t2.UAPROV_ID SANINTERVUAPROVID,t2.UAMUN_ID SANINTERVUAMUNID,t2.UALOC_ID SANINTERVUALOCID,t2.UACALLE_ID SANINTERVUACALLEID,t2.UACP_ID SANINTERVUACPID,t2.UAPORTAL_ID SANINTERVUAPORTALID,t2.UANOMBRE_PISO SANINTERVUANOMBREPISO,t2.UADIRE_NOCAPV SANINTERVUADIRENOCAPV,t2.UADIRE_ANT SANINTERVUADIREANT,t2.UATIPOINTERV SANINTERVUATIPOINTERV,t2.UADTCODIGO SANINTERVUADTCODIGO,t2.UAESCODIGO SANINTERVUAESCODIGO,t2.UATRFECALTA SANINTERVUATRFECALTA,t2.UATRFECMODIF SANINTERVUATRFECMODIF,t2.UATRUSUALTA SANINTERVUATRUSUALTA,t2.UATRUSUMODIF SANINTERVUATRUSUMODIF,t2.UAFECALTA SANINTERVUAFECALTA,t2.UAFECMODIF SANINTERVUAFECMODIF,t2.UAUSUALTA SANINTERVUAUSUALTA,t2.UAUSUMODIF SANINTERVUAUSUMODIF,t3.EXCODIGO EXPEDIENEXCODIGO,t3.EXCOOR EXPEDIENEXCOOR,t3.EXNRAN EXPEDIENEXNRAN,t3.EXNROR EXPEDIENEXNROR,t3.EXFERE EXPEDIENEXFERE,t3.EXCOIT EXPEDIENEXCOIT,t3.EXCOES EXPEDIENEXCOES,t3.EXFEACIN EXPEDIENEXFEACIN,t3.EXFEEMCA EXPEDIENEXFEEMCA,t3.EXFEPLCA EXPEDIENEXFEPLCA,t3.EXFPNOPC EXPEDIENEXFPNOPC,t3.EXFEDE EXPEDIENEXFEDE,t3.EXFECOAL EXPEDIENEXFECOAL,t3.EXFENOPR EXPEDIENEXFENOPR,t3.EXFEPUPR EXPEDIENEXFEPUPR,t3.EXCOOSPR EXPEDIENEXCOOSPR,t3.EXFEALPR EXPEDIENEXFEALPR,t3.EXFEEL EXPEDIENEXFEEL,t3.EXFERES EXPEDIENEXFERES,t3.EXFENORE EXPEDIENEXFENORE,t3.EXFEPURE EXPEDIENEXFEPURE,t3.EXCOOSRE EXPEDIENEXCOOSRE,t3.EXCOTTR EXPEDIENEXCOTTR,t3.EXCAMURE EXPEDIENEXCAMURE,t3.EXFETA EXPEDIENEXFETA,t3.EXCOTSA EXPEDIENEXCOTSA,t3.EXFECROI EXPEDIENEXFECROI,t3.EXFEAR EXPEDIENEXFEAR,t3.EXCOORIE EXPEDIENEXCOORIE,t3.EXINRE EXPEDIENEXINRE,t3.EXINCOCO EXPEDIENEXINCOCO,t3.EXINEXVA EXPEDIENEXINEXVA,t3.EXFECIRC EXPEDIENEXFECIRC,t3.EXFENOAI EXPEDIENEXFENOAI,t3.EXFECOLM EXPEDIENEXFECOLM,t3.EXNUINLM EXPEDIENEXNUINLM,t3.EXFEINMU EXPEDIENEXFEINMU,t3.EXFEAVMU EXPEDIENEXFEAVMU,t3.EXFEIMCD EXPEDIENEXFEIMCD,t3.EXFECEDE EXPEDIENEXFECEDE,t3.EXCOPS EXPEDIENEXCOPS,t3.EXCOSE EXPEDIENEXCOSE,t2.UAEXCODIGO SANINTERVUAEXCODIGO ");
		query.append("FROM SANPRUE t1 ,SANINTERV t2 ,EXPEDIEN t3 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(sanprue);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.PRINID= t2.UAIDINTERV(+) AND t1.PREXCODIGO= t3.EXCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Sanprue>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Sanprue table.
	 * 
	 * @param sanprue
	 *            Sanprue
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Sanprue sanprue) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM SANPRUE t1 , SANINTERV t2 , EXPEDIEN t3 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(sanprue);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.PRINID= t2.UAIDINTERV(+) AND t1.PREXCODIGO= t3.EXCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Sanprue table using like.
	 * 
	 * @param sanprue
	 *            Sanprue
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Sanprue> findAllLike(Sanprue sanprue, Pagination pagination,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.PRID PRID,t1.PRESID PRESID,t1.PRTIPOPRUE PRTIPOPRUE,t1.PRFECPRUE PRFECPRUE,t1.PRRES PRRES,t1.PRFECPRAC PRFECPRAC,t1.PRFECALTA PRFECALTA,t1.PRFECMODIF PRFECMODIF,t1.PRUSUALTA PRUSUALTA,t1.PRUSUMODIF PRUSUMODIF,t2.UAIDINTERV SANINTERVUAIDINTERV,t2.UANOMBRE SANINTERVUANOMBRE,t2.UAAPELLIDO1 SANINTERVUAAPELLIDO1,t2.UAAPELLIDO2 SANINTERVUAAPELLIDO2,t2.UANIF SANINTERVUANIF,t2.UANRTEL SANINTERVUANRTEL,t2.UANRTEL2 SANINTERVUANRTEL2,t2.UAPROV_ID SANINTERVUAPROVID,t2.UAMUN_ID SANINTERVUAMUNID,t2.UALOC_ID SANINTERVUALOCID,t2.UACALLE_ID SANINTERVUACALLEID,t2.UACP_ID SANINTERVUACPID,t2.UAPORTAL_ID SANINTERVUAPORTALID,t2.UANOMBRE_PISO SANINTERVUANOMBREPISO,t2.UADIRE_NOCAPV SANINTERVUADIRENOCAPV,t2.UADIRE_ANT SANINTERVUADIREANT,t2.UATIPOINTERV SANINTERVUATIPOINTERV,t2.UADTCODIGO SANINTERVUADTCODIGO,t2.UAESCODIGO SANINTERVUAESCODIGO,t2.UATRFECALTA SANINTERVUATRFECALTA,t2.UATRFECMODIF SANINTERVUATRFECMODIF,t2.UATRUSUALTA SANINTERVUATRUSUALTA,t2.UATRUSUMODIF SANINTERVUATRUSUMODIF,t2.UAFECALTA SANINTERVUAFECALTA,t2.UAFECMODIF SANINTERVUAFECMODIF,t2.UAUSUALTA SANINTERVUAUSUALTA,t2.UAUSUMODIF SANINTERVUAUSUMODIF,t3.EXCODIGO EXPEDIENEXCODIGO,t3.EXCOOR EXPEDIENEXCOOR,t3.EXNRAN EXPEDIENEXNRAN,t3.EXNROR EXPEDIENEXNROR,t3.EXFERE EXPEDIENEXFERE,t3.EXCOIT EXPEDIENEXCOIT,t3.EXCOES EXPEDIENEXCOES,t3.EXFEACIN EXPEDIENEXFEACIN,t3.EXFEEMCA EXPEDIENEXFEEMCA,t3.EXFEPLCA EXPEDIENEXFEPLCA,t3.EXFPNOPC EXPEDIENEXFPNOPC,t3.EXFEDE EXPEDIENEXFEDE,t3.EXFECOAL EXPEDIENEXFECOAL,t3.EXFENOPR EXPEDIENEXFENOPR,t3.EXFEPUPR EXPEDIENEXFEPUPR,t3.EXCOOSPR EXPEDIENEXCOOSPR,t3.EXFEALPR EXPEDIENEXFEALPR,t3.EXFEEL EXPEDIENEXFEEL,t3.EXFERES EXPEDIENEXFERES,t3.EXFENORE EXPEDIENEXFENORE,t3.EXFEPURE EXPEDIENEXFEPURE,t3.EXCOOSRE EXPEDIENEXCOOSRE,t3.EXCOTTR EXPEDIENEXCOTTR,t3.EXCAMURE EXPEDIENEXCAMURE,t3.EXFETA EXPEDIENEXFETA,t3.EXCOTSA EXPEDIENEXCOTSA,t3.EXFECROI EXPEDIENEXFECROI,t3.EXFEAR EXPEDIENEXFEAR,t3.EXCOORIE EXPEDIENEXCOORIE,t3.EXINRE EXPEDIENEXINRE,t3.EXINCOCO EXPEDIENEXINCOCO,t3.EXINEXVA EXPEDIENEXINEXVA,t3.EXFECIRC EXPEDIENEXFECIRC,t3.EXFENOAI EXPEDIENEXFENOAI,t3.EXFECOLM EXPEDIENEXFECOLM,t3.EXNUINLM EXPEDIENEXNUINLM,t3.EXFEINMU EXPEDIENEXFEINMU,t3.EXFEAVMU EXPEDIENEXFEAVMU,t3.EXFEIMCD EXPEDIENEXFEIMCD,t3.EXFECEDE EXPEDIENEXFECEDE,t3.EXCOPS EXPEDIENEXCOPS,t3.EXCOSE EXPEDIENEXCOSE,t2.UAEXCODIGO SANINTERVUAEXCODIGO ");
		query.append("FROM SANPRUE t1 ,SANINTERV t2 ,EXPEDIEN t3 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(sanprue, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.PRINID= t2.UAIDINTERV(+) AND t1.PREXCODIGO= t3.EXCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Sanprue>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Sanprue table using like.
	 * 
	 * @param sanprue
	 *            Sanprue
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Sanprue sanprue, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM SANPRUE t1 ,SANINTERV t2 ,EXPEDIEN t3 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(sanprue, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.PRINID= t2.UAIDINTERV(+) AND t1.PREXCODIGO= t3.EXCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Sanprue entity
	 * 
	 * @param sanprue
	 *            Sanprue Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Sanprue sanprue) {

		StringBuilder where = new StringBuilder(
				SanprueDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (sanprue != null && sanprue.getPrid() != null) {
			where.append(" AND t1.PRID = ?");
			params.add(sanprue.getPrid());
		}
		if (sanprue != null && sanprue.getSaninterv() != null
				&& sanprue.getSaninterv().getUaidinterv() != null) {
			where.append(" AND t2.UAIDINTERV = ?");
			params.add(sanprue.getSaninterv().getUaidinterv());
		}
		if (sanprue != null && sanprue.getSaninterv() != null
				&& sanprue.getSaninterv().getExpedien() != null
				&& sanprue.getSaninterv().getExpedien().getExcodigo() != null) {
			where.append(" AND t2.UAEXCODIGO = ?");
			params.add(sanprue.getSaninterv().getExpedien().getExcodigo());
		}
		if (sanprue != null && sanprue.getSaninterv() != null
				&& sanprue.getSaninterv().getUanombre() != null) {
			where.append(" AND t2.UANOMBRE = ?");
			params.add(sanprue.getSaninterv().getUanombre());
		}
		if (sanprue != null && sanprue.getSaninterv() != null
				&& sanprue.getSaninterv().getUaapellido1() != null) {
			where.append(" AND t2.UAAPELLIDO1 = ?");
			params.add(sanprue.getSaninterv().getUaapellido1());
		}
		if (sanprue != null && sanprue.getSaninterv() != null
				&& sanprue.getSaninterv().getUaapellido2() != null) {
			where.append(" AND t2.UAAPELLIDO2 = ?");
			params.add(sanprue.getSaninterv().getUaapellido2());
		}
		if (sanprue != null && sanprue.getSaninterv() != null
				&& sanprue.getSaninterv().getUanif() != null) {
			where.append(" AND t2.UANIF = ?");
			params.add(sanprue.getSaninterv().getUanif());
		}
		if (sanprue != null && sanprue.getSaninterv() != null
				&& sanprue.getSaninterv().getUanrtel() != null) {
			where.append(" AND t2.UANRTEL = ?");
			params.add(sanprue.getSaninterv().getUanrtel());
		}
		if (sanprue != null && sanprue.getSaninterv() != null
				&& sanprue.getSaninterv().getUanrtel2() != null) {
			where.append(" AND t2.UANRTEL2 = ?");
			params.add(sanprue.getSaninterv().getUanrtel2());
		}
		if (sanprue != null && sanprue.getSaninterv() != null
				&& sanprue.getSaninterv().getUaprovId() != null) {
			where.append(" AND t2.UAPROV_ID = ?");
			params.add(sanprue.getSaninterv().getUaprovId());
		}
		if (sanprue != null && sanprue.getSaninterv() != null
				&& sanprue.getSaninterv().getUamunId() != null) {
			where.append(" AND t2.UAMUN_ID = ?");
			params.add(sanprue.getSaninterv().getUamunId());
		}
		if (sanprue != null && sanprue.getSaninterv() != null
				&& sanprue.getSaninterv().getUalocId() != null) {
			where.append(" AND t2.UALOC_ID = ?");
			params.add(sanprue.getSaninterv().getUalocId());
		}
		if (sanprue != null && sanprue.getSaninterv() != null
				&& sanprue.getSaninterv().getUacalleId() != null) {
			where.append(" AND t2.UACALLE_ID = ?");
			params.add(sanprue.getSaninterv().getUacalleId());
		}
		if (sanprue != null && sanprue.getSaninterv() != null
				&& sanprue.getSaninterv().getUacpId() != null) {
			where.append(" AND t2.UACP_ID = ?");
			params.add(sanprue.getSaninterv().getUacpId());
		}
		if (sanprue != null && sanprue.getSaninterv() != null
				&& sanprue.getSaninterv().getUaportalId() != null) {
			where.append(" AND t2.UAPORTAL_ID = ?");
			params.add(sanprue.getSaninterv().getUaportalId());
		}
		if (sanprue != null && sanprue.getSaninterv() != null
				&& sanprue.getSaninterv().getUanombrePiso() != null) {
			where.append(" AND t2.UANOMBRE_PISO = ?");
			params.add(sanprue.getSaninterv().getUanombrePiso());
		}
		if (sanprue != null && sanprue.getSaninterv() != null
				&& sanprue.getSaninterv().getUadireNocapv() != null) {
			where.append(" AND t2.UADIRE_NOCAPV = ?");
			params.add(sanprue.getSaninterv().getUadireNocapv());
		}
		if (sanprue != null && sanprue.getSaninterv() != null
				&& sanprue.getSaninterv().getUadireAnt() != null) {
			where.append(" AND t2.UADIRE_ANT = ?");
			params.add(sanprue.getSaninterv().getUadireAnt());
		}
		if (sanprue != null && sanprue.getSaninterv() != null
				&& sanprue.getSaninterv().getUatipointerv() != null) {
			where.append(" AND t2.UATIPOINTERV = ?");
			params.add(sanprue.getSaninterv().getUatipointerv());
		}
		if (sanprue != null && sanprue.getSaninterv() != null
				&& sanprue.getSaninterv().getUadtcodigo() != null) {
			where.append(" AND t2.UADTCODIGO = ?");
			params.add(sanprue.getSaninterv().getUadtcodigo());
		}
		if (sanprue != null && sanprue.getSaninterv() != null
				&& sanprue.getSaninterv().getUaescodigo() != null) {
			where.append(" AND t2.UAESCODIGO = ?");
			params.add(sanprue.getSaninterv().getUaescodigo());
		}
		if (sanprue != null && sanprue.getSaninterv() != null
				&& sanprue.getSaninterv().getUatrfecalta() != null) {
			where.append(" AND t2.UATRFECALTA = ?");
			params.add(sanprue.getSaninterv().getUatrfecalta());
		}
		if (sanprue != null && sanprue.getSaninterv() != null
				&& sanprue.getSaninterv().getUatrfecmodif() != null) {
			where.append(" AND t2.UATRFECMODIF = ?");
			params.add(sanprue.getSaninterv().getUatrfecmodif());
		}
		if (sanprue != null && sanprue.getSaninterv() != null
				&& sanprue.getSaninterv().getUatrusualta() != null) {
			where.append(" AND t2.UATRUSUALTA = ?");
			params.add(sanprue.getSaninterv().getUatrusualta());
		}
		if (sanprue != null && sanprue.getSaninterv() != null
				&& sanprue.getSaninterv().getUatrusumodif() != null) {
			where.append(" AND t2.UATRUSUMODIF = ?");
			params.add(sanprue.getSaninterv().getUatrusumodif());
		}
		if (sanprue != null && sanprue.getSaninterv() != null
				&& sanprue.getSaninterv().getUafecalta() != null) {
			where.append(" AND t2.UAFECALTA = ?");
			params.add(sanprue.getSaninterv().getUafecalta());
		}
		if (sanprue != null && sanprue.getSaninterv() != null
				&& sanprue.getSaninterv().getUafecmodif() != null) {
			where.append(" AND t2.UAFECMODIF = ?");
			params.add(sanprue.getSaninterv().getUafecmodif());
		}
		if (sanprue != null && sanprue.getSaninterv() != null
				&& sanprue.getSaninterv().getUausualta() != null) {
			where.append(" AND t2.UAUSUALTA = ?");
			params.add(sanprue.getSaninterv().getUausualta());
		}
		if (sanprue != null && sanprue.getSaninterv() != null
				&& sanprue.getSaninterv().getUausumodif() != null) {
			where.append(" AND t2.UAUSUMODIF = ?");
			params.add(sanprue.getSaninterv().getUausumodif());
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExcodigo() != null) {
			where.append(" AND t3.EXCODIGO = ?");
			params.add(sanprue.getExpedien().getExcodigo());
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExcoor() != null) {
			where.append(" AND t3.EXCOOR = ?");
			params.add(sanprue.getExpedien().getExcoor());
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExnran() != null) {
			where.append(" AND t3.EXNRAN = ?");
			params.add(sanprue.getExpedien().getExnran());
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExnror() != null) {
			where.append(" AND t3.EXNROR = ?");
			params.add(sanprue.getExpedien().getExnror());
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExfere() != null) {
			where.append(" AND t3.EXFERE = ?");
			params.add(sanprue.getExpedien().getExfere());
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExcoit() != null) {
			where.append(" AND t3.EXCOIT = ?");
			params.add(sanprue.getExpedien().getExcoit());
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExcoes() != null) {
			where.append(" AND t3.EXCOES = ?");
			params.add(sanprue.getExpedien().getExcoes());
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExfeacin() != null) {
			where.append(" AND t3.EXFEACIN = ?");
			params.add(sanprue.getExpedien().getExfeacin());
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExfeemca() != null) {
			where.append(" AND t3.EXFEEMCA = ?");
			params.add(sanprue.getExpedien().getExfeemca());
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExfeplca() != null) {
			where.append(" AND t3.EXFEPLCA = ?");
			params.add(sanprue.getExpedien().getExfeplca());
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExfpnopc() != null) {
			where.append(" AND t3.EXFPNOPC = ?");
			params.add(sanprue.getExpedien().getExfpnopc());
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExfede() != null) {
			where.append(" AND t3.EXFEDE = ?");
			params.add(sanprue.getExpedien().getExfede());
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExfecoal() != null) {
			where.append(" AND t3.EXFECOAL = ?");
			params.add(sanprue.getExpedien().getExfecoal());
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExfenopr() != null) {
			where.append(" AND t3.EXFENOPR = ?");
			params.add(sanprue.getExpedien().getExfenopr());
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExfepupr() != null) {
			where.append(" AND t3.EXFEPUPR = ?");
			params.add(sanprue.getExpedien().getExfepupr());
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExcoospr() != null) {
			where.append(" AND t3.EXCOOSPR = ?");
			params.add(sanprue.getExpedien().getExcoospr());
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExfealpr() != null) {
			where.append(" AND t3.EXFEALPR = ?");
			params.add(sanprue.getExpedien().getExfealpr());
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExfeel() != null) {
			where.append(" AND t3.EXFEEL = ?");
			params.add(sanprue.getExpedien().getExfeel());
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExferes() != null) {
			where.append(" AND t3.EXFERES = ?");
			params.add(sanprue.getExpedien().getExferes());
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExfenore() != null) {
			where.append(" AND t3.EXFENORE = ?");
			params.add(sanprue.getExpedien().getExfenore());
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExfepure() != null) {
			where.append(" AND t3.EXFEPURE = ?");
			params.add(sanprue.getExpedien().getExfepure());
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExcoosre() != null) {
			where.append(" AND t3.EXCOOSRE = ?");
			params.add(sanprue.getExpedien().getExcoosre());
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExcottr() != null) {
			where.append(" AND t3.EXCOTTR = ?");
			params.add(sanprue.getExpedien().getExcottr());
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExcamure() != null) {
			where.append(" AND t3.EXCAMURE = ?");
			params.add(sanprue.getExpedien().getExcamure());
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExfeta() != null) {
			where.append(" AND t3.EXFETA = ?");
			params.add(sanprue.getExpedien().getExfeta());
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExcotsa() != null) {
			where.append(" AND t3.EXCOTSA = ?");
			params.add(sanprue.getExpedien().getExcotsa());
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExfecroi() != null) {
			where.append(" AND t3.EXFECROI = ?");
			params.add(sanprue.getExpedien().getExfecroi());
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExfear() != null) {
			where.append(" AND t3.EXFEAR = ?");
			params.add(sanprue.getExpedien().getExfear());
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExcoorie() != null) {
			where.append(" AND t3.EXCOORIE = ?");
			params.add(sanprue.getExpedien().getExcoorie());
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExinre() != null) {
			where.append(" AND t3.EXINRE = ?");
			params.add(sanprue.getExpedien().getExinre());
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExincoco() != null) {
			where.append(" AND t3.EXINCOCO = ?");
			params.add(sanprue.getExpedien().getExincoco());
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExinexva() != null) {
			where.append(" AND t3.EXINEXVA = ?");
			params.add(sanprue.getExpedien().getExinexva());
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExfecirc() != null) {
			where.append(" AND t3.EXFECIRC = ?");
			params.add(sanprue.getExpedien().getExfecirc());
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExfenoai() != null) {
			where.append(" AND t3.EXFENOAI = ?");
			params.add(sanprue.getExpedien().getExfenoai());
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExfecolm() != null) {
			where.append(" AND t3.EXFECOLM = ?");
			params.add(sanprue.getExpedien().getExfecolm());
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExnuinlm() != null) {
			where.append(" AND t3.EXNUINLM = ?");
			params.add(sanprue.getExpedien().getExnuinlm());
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExfeinmu() != null) {
			where.append(" AND t3.EXFEINMU = ?");
			params.add(sanprue.getExpedien().getExfeinmu());
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExfeavmu() != null) {
			where.append(" AND t3.EXFEAVMU = ?");
			params.add(sanprue.getExpedien().getExfeavmu());
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExfeimcd() != null) {
			where.append(" AND t3.EXFEIMCD = ?");
			params.add(sanprue.getExpedien().getExfeimcd());
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExfecede() != null) {
			where.append(" AND t3.EXFECEDE = ?");
			params.add(sanprue.getExpedien().getExfecede());
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExcops() != null) {
			where.append(" AND t3.EXCOPS = ?");
			params.add(sanprue.getExpedien().getExcops());
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExcose() != null) {
			where.append(" AND t3.EXCOSE = ?");
			params.add(sanprue.getExpedien().getExcose());
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getSanexp() != null
				&& sanprue.getExpedien().getSanexp().getExcodigo() != null) {
			where.append(" AND t3.EXCODIGO = ?");
			params.add(sanprue.getExpedien().getSanexp().getExcodigo());
		}
		if (sanprue != null && sanprue.getPresid() != null) {
			where.append(" AND t1.PRESID = ?");
			params.add(sanprue.getPresid());
		}
		if (sanprue != null && sanprue.getPrtipoprue() != null) {
			where.append(" AND t1.PRTIPOPRUE = ?");
			params.add(sanprue.getPrtipoprue());
		}
		if (sanprue != null && sanprue.getPrfecprue() != null) {
			where.append(" AND t1.PRFECPRUE = ?");
			params.add(sanprue.getPrfecprue());
		}
		if (sanprue != null && sanprue.getPrres() != null) {
			where.append(" AND t1.PRRES = ?");
			params.add(sanprue.getPrres());
		}
		if (sanprue != null && sanprue.getPrfecprac() != null) {
			where.append(" AND t1.PRFECPRAC = ?");
			params.add(sanprue.getPrfecprac());
		}
		if (sanprue != null && sanprue.getPrfecalta() != null) {
			where.append(" AND t1.PRFECALTA = ?");
			params.add(sanprue.getPrfecalta());
		}
		if (sanprue != null && sanprue.getPrfecmodif() != null) {
			where.append(" AND t1.PRFECMODIF = ?");
			params.add(sanprue.getPrfecmodif());
		}
		if (sanprue != null && sanprue.getPrusualta() != null) {
			where.append(" AND t1.PRUSUALTA = ?");
			params.add(sanprue.getPrusualta());
		}
		if (sanprue != null && sanprue.getPrusumodif() != null) {
			where.append(" AND t1.PRUSUMODIF = ?");
			params.add(sanprue.getPrusumodif());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Sanprue entity
	 * 
	 * @param sanprue
	 *            Sanprue Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Sanprue sanprue, Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				SanprueDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (sanprue != null && sanprue.getPrid() != null) {
			where.append(" AND t1.PRID = ?");
			params.add(sanprue.getPrid());
		}
		if (sanprue != null && sanprue.getSaninterv() != null
				&& sanprue.getSaninterv().getUaidinterv() != null) {
			where.append(" AND t2.UAIDINTERV = ?");
			params.add(sanprue.getSaninterv().getUaidinterv());
		}
		if (sanprue != null && sanprue.getSaninterv() != null
				&& sanprue.getSaninterv().getExpedien() != null
				&& sanprue.getSaninterv().getExpedien().getExcodigo() != null) {
			where.append(" AND UPPER(t2.UAEXCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanprue.getSaninterv().getExpedien().getExcodigo()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanprue.getSaninterv().getExpedien().getExcodigo()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.UAEXCODIGO IS NOT NULL");
		}
		if (sanprue != null && sanprue.getSaninterv() != null
				&& sanprue.getSaninterv().getUanombre() != null) {
			where.append(" AND UPPER(t2.UANOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanprue.getSaninterv().getUanombre().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanprue.getSaninterv().getUanombre().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.UANOMBRE IS NOT NULL");
		}
		if (sanprue != null && sanprue.getSaninterv() != null
				&& sanprue.getSaninterv().getUaapellido1() != null) {
			where.append(" AND UPPER(t2.UAAPELLIDO1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanprue.getSaninterv().getUaapellido1()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanprue.getSaninterv().getUaapellido1().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.UAAPELLIDO1 IS NOT NULL");
		}
		if (sanprue != null && sanprue.getSaninterv() != null
				&& sanprue.getSaninterv().getUaapellido2() != null) {
			where.append(" AND UPPER(t2.UAAPELLIDO2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanprue.getSaninterv().getUaapellido2()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanprue.getSaninterv().getUaapellido2().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.UAAPELLIDO2 IS NOT NULL");
		}
		if (sanprue != null && sanprue.getSaninterv() != null
				&& sanprue.getSaninterv().getUanif() != null) {
			where.append(" AND UPPER(t2.UANIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanprue.getSaninterv().getUanif().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanprue.getSaninterv().getUanif().toUpperCase() + "%");
			}
			where.append(" AND t2.UANIF IS NOT NULL");
		}
		if (sanprue != null && sanprue.getSaninterv() != null
				&& sanprue.getSaninterv().getUanrtel() != null) {
			where.append(" AND UPPER(t2.UANRTEL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanprue.getSaninterv().getUanrtel().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanprue.getSaninterv().getUanrtel().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.UANRTEL IS NOT NULL");
		}
		if (sanprue != null && sanprue.getSaninterv() != null
				&& sanprue.getSaninterv().getUanrtel2() != null) {
			where.append(" AND UPPER(t2.UANRTEL2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanprue.getSaninterv().getUanrtel2().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanprue.getSaninterv().getUanrtel2().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.UANRTEL2 IS NOT NULL");
		}
		if (sanprue != null && sanprue.getSaninterv() != null
				&& sanprue.getSaninterv().getUaprovId() != null) {
			where.append(" AND UPPER(t2.UAPROV_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanprue.getSaninterv().getUaprovId().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanprue.getSaninterv().getUaprovId().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.UAPROV_ID IS NOT NULL");
		}
		if (sanprue != null && sanprue.getSaninterv() != null
				&& sanprue.getSaninterv().getUamunId() != null) {
			where.append(" AND UPPER(t2.UAMUN_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanprue.getSaninterv().getUamunId().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanprue.getSaninterv().getUamunId().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.UAMUN_ID IS NOT NULL");
		}
		if (sanprue != null && sanprue.getSaninterv() != null
				&& sanprue.getSaninterv().getUalocId() != null) {
			where.append(" AND UPPER(t2.UALOC_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanprue.getSaninterv().getUalocId().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanprue.getSaninterv().getUalocId().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.UALOC_ID IS NOT NULL");
		}
		if (sanprue != null && sanprue.getSaninterv() != null
				&& sanprue.getSaninterv().getUacalleId() != null) {
			where.append(" AND UPPER(t2.UACALLE_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanprue.getSaninterv().getUacalleId().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanprue.getSaninterv().getUacalleId().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.UACALLE_ID IS NOT NULL");
		}
		if (sanprue != null && sanprue.getSaninterv() != null
				&& sanprue.getSaninterv().getUacpId() != null) {
			where.append(" AND UPPER(t2.UACP_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanprue.getSaninterv().getUacpId().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanprue.getSaninterv().getUacpId().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.UACP_ID IS NOT NULL");
		}
		if (sanprue != null && sanprue.getSaninterv() != null
				&& sanprue.getSaninterv().getUaportalId() != null) {
			where.append(" AND UPPER(t2.UAPORTAL_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanprue.getSaninterv().getUaportalId().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanprue.getSaninterv().getUaportalId().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.UAPORTAL_ID IS NOT NULL");
		}
		if (sanprue != null && sanprue.getSaninterv() != null
				&& sanprue.getSaninterv().getUanombrePiso() != null) {
			where.append(" AND UPPER(t2.UANOMBRE_PISO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanprue.getSaninterv().getUanombrePiso()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanprue.getSaninterv().getUanombrePiso()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.UANOMBRE_PISO IS NOT NULL");
		}
		if (sanprue != null && sanprue.getSaninterv() != null
				&& sanprue.getSaninterv().getUadireNocapv() != null) {
			where.append(" AND UPPER(t2.UADIRE_NOCAPV) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanprue.getSaninterv().getUadireNocapv()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanprue.getSaninterv().getUadireNocapv()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.UADIRE_NOCAPV IS NOT NULL");
		}
		if (sanprue != null && sanprue.getSaninterv() != null
				&& sanprue.getSaninterv().getUadireAnt() != null) {
			where.append(" AND UPPER(t2.UADIRE_ANT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanprue.getSaninterv().getUadireAnt().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanprue.getSaninterv().getUadireAnt().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.UADIRE_ANT IS NOT NULL");
		}
		if (sanprue != null && sanprue.getSaninterv() != null
				&& sanprue.getSaninterv().getUatipointerv() != null) {
			where.append(" AND UPPER(t2.UATIPOINTERV) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanprue.getSaninterv().getUatipointerv()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanprue.getSaninterv().getUatipointerv()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.UATIPOINTERV IS NOT NULL");
		}
		if (sanprue != null && sanprue.getSaninterv() != null
				&& sanprue.getSaninterv().getUadtcodigo() != null) {
			where.append(" AND UPPER(t2.UADTCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanprue.getSaninterv().getUadtcodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanprue.getSaninterv().getUadtcodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.UADTCODIGO IS NOT NULL");
		}
		if (sanprue != null && sanprue.getSaninterv() != null
				&& sanprue.getSaninterv().getUaescodigo() != null) {
			where.append(" AND UPPER(t2.UAESCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanprue.getSaninterv().getUaescodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanprue.getSaninterv().getUaescodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.UAESCODIGO IS NOT NULL");
		}
		if (sanprue != null && sanprue.getSaninterv() != null
				&& sanprue.getSaninterv().getUatrfecalta() != null) {
			where.append(" AND t2.UATRFECALTA = ?");
			params.add(sanprue.getSaninterv().getUatrfecalta());
		}
		if (sanprue != null && sanprue.getSaninterv() != null
				&& sanprue.getSaninterv().getUatrfecmodif() != null) {
			where.append(" AND t2.UATRFECMODIF = ?");
			params.add(sanprue.getSaninterv().getUatrfecmodif());
		}
		if (sanprue != null && sanprue.getSaninterv() != null
				&& sanprue.getSaninterv().getUatrusualta() != null) {
			where.append(" AND UPPER(t2.UATRUSUALTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanprue.getSaninterv().getUatrusualta()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanprue.getSaninterv().getUatrusualta().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.UATRUSUALTA IS NOT NULL");
		}
		if (sanprue != null && sanprue.getSaninterv() != null
				&& sanprue.getSaninterv().getUatrusumodif() != null) {
			where.append(" AND UPPER(t2.UATRUSUMODIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanprue.getSaninterv().getUatrusumodif()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanprue.getSaninterv().getUatrusumodif()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.UATRUSUMODIF IS NOT NULL");
		}
		if (sanprue != null && sanprue.getSaninterv() != null
				&& sanprue.getSaninterv().getUafecalta() != null) {
			where.append(" AND t2.UAFECALTA = ?");
			params.add(sanprue.getSaninterv().getUafecalta());
		}
		if (sanprue != null && sanprue.getSaninterv() != null
				&& sanprue.getSaninterv().getUafecmodif() != null) {
			where.append(" AND t2.UAFECMODIF = ?");
			params.add(sanprue.getSaninterv().getUafecmodif());
		}
		if (sanprue != null && sanprue.getSaninterv() != null
				&& sanprue.getSaninterv().getUausualta() != null) {
			where.append(" AND UPPER(t2.UAUSUALTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanprue.getSaninterv().getUausualta().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanprue.getSaninterv().getUausualta().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.UAUSUALTA IS NOT NULL");
		}
		if (sanprue != null && sanprue.getSaninterv() != null
				&& sanprue.getSaninterv().getUausumodif() != null) {
			where.append(" AND UPPER(t2.UAUSUMODIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanprue.getSaninterv().getUausumodif().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanprue.getSaninterv().getUausumodif().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.UAUSUMODIF IS NOT NULL");
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExcodigo() != null) {
			where.append(" AND t3.EXCODIGO = ?");
			params.add(sanprue.getExpedien().getExcodigo());
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExcoor() != null) {
			where.append(" AND UPPER(t3.EXCOOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanprue.getExpedien().getExcoor().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanprue.getExpedien().getExcoor().toUpperCase() + "%");
			}
			where.append(" AND t3.EXCOOR IS NOT NULL");
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExnran() != null) {
			where.append(" AND t3.EXNRAN = ?");
			params.add(sanprue.getExpedien().getExnran());
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExnror() != null) {
			where.append(" AND t3.EXNROR = ?");
			params.add(sanprue.getExpedien().getExnror());
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExfere() != null) {
			where.append(" AND t3.EXFERE = ?");
			params.add(sanprue.getExpedien().getExfere());
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExcoit() != null) {
			where.append(" AND UPPER(t3.EXCOIT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanprue.getExpedien().getExcoit().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanprue.getExpedien().getExcoit().toUpperCase() + "%");
			}
			where.append(" AND t3.EXCOIT IS NOT NULL");
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExcoes() != null) {
			where.append(" AND UPPER(t3.EXCOES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanprue.getExpedien().getExcoes().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanprue.getExpedien().getExcoes().toUpperCase() + "%");
			}
			where.append(" AND t3.EXCOES IS NOT NULL");
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExfeacin() != null) {
			where.append(" AND t3.EXFEACIN = ?");
			params.add(sanprue.getExpedien().getExfeacin());
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExfeemca() != null) {
			where.append(" AND t3.EXFEEMCA = ?");
			params.add(sanprue.getExpedien().getExfeemca());
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExfeplca() != null) {
			where.append(" AND t3.EXFEPLCA = ?");
			params.add(sanprue.getExpedien().getExfeplca());
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExfpnopc() != null) {
			where.append(" AND t3.EXFPNOPC = ?");
			params.add(sanprue.getExpedien().getExfpnopc());
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExfede() != null) {
			where.append(" AND t3.EXFEDE = ?");
			params.add(sanprue.getExpedien().getExfede());
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExfecoal() != null) {
			where.append(" AND t3.EXFECOAL = ?");
			params.add(sanprue.getExpedien().getExfecoal());
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExfenopr() != null) {
			where.append(" AND t3.EXFENOPR = ?");
			params.add(sanprue.getExpedien().getExfenopr());
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExfepupr() != null) {
			where.append(" AND t3.EXFEPUPR = ?");
			params.add(sanprue.getExpedien().getExfepupr());
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExcoospr() != null) {
			where.append(" AND UPPER(t3.EXCOOSPR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanprue.getExpedien().getExcoospr().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanprue.getExpedien().getExcoospr().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.EXCOOSPR IS NOT NULL");
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExfealpr() != null) {
			where.append(" AND t3.EXFEALPR = ?");
			params.add(sanprue.getExpedien().getExfealpr());
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExfeel() != null) {
			where.append(" AND t3.EXFEEL = ?");
			params.add(sanprue.getExpedien().getExfeel());
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExferes() != null) {
			where.append(" AND t3.EXFERES = ?");
			params.add(sanprue.getExpedien().getExferes());
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExfenore() != null) {
			where.append(" AND t3.EXFENORE = ?");
			params.add(sanprue.getExpedien().getExfenore());
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExfepure() != null) {
			where.append(" AND t3.EXFEPURE = ?");
			params.add(sanprue.getExpedien().getExfepure());
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExcoosre() != null) {
			where.append(" AND UPPER(t3.EXCOOSRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanprue.getExpedien().getExcoosre().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanprue.getExpedien().getExcoosre().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.EXCOOSRE IS NOT NULL");
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExcottr() != null) {
			where.append(" AND UPPER(t3.EXCOTTR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanprue.getExpedien().getExcottr().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanprue.getExpedien().getExcottr().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.EXCOTTR IS NOT NULL");
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExcamure() != null) {
			where.append(" AND t3.EXCAMURE = ?");
			params.add(sanprue.getExpedien().getExcamure());
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExfeta() != null) {
			where.append(" AND t3.EXFETA = ?");
			params.add(sanprue.getExpedien().getExfeta());
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExcotsa() != null) {
			where.append(" AND UPPER(t3.EXCOTSA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanprue.getExpedien().getExcotsa().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanprue.getExpedien().getExcotsa().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.EXCOTSA IS NOT NULL");
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExfecroi() != null) {
			where.append(" AND t3.EXFECROI = ?");
			params.add(sanprue.getExpedien().getExfecroi());
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExfear() != null) {
			where.append(" AND t3.EXFEAR = ?");
			params.add(sanprue.getExpedien().getExfear());
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExcoorie() != null) {
			where.append(" AND UPPER(t3.EXCOORIE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanprue.getExpedien().getExcoorie().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanprue.getExpedien().getExcoorie().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.EXCOORIE IS NOT NULL");
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExinre() != null) {
			where.append(" AND UPPER(t3.EXINRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanprue.getExpedien().getExinre().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanprue.getExpedien().getExinre().toUpperCase() + "%");
			}
			where.append(" AND t3.EXINRE IS NOT NULL");
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExincoco() != null) {
			where.append(" AND UPPER(t3.EXINCOCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanprue.getExpedien().getExincoco().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanprue.getExpedien().getExincoco().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.EXINCOCO IS NOT NULL");
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExinexva() != null) {
			where.append(" AND UPPER(t3.EXINEXVA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanprue.getExpedien().getExinexva().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanprue.getExpedien().getExinexva().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.EXINEXVA IS NOT NULL");
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExfecirc() != null) {
			where.append(" AND t3.EXFECIRC = ?");
			params.add(sanprue.getExpedien().getExfecirc());
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExfenoai() != null) {
			where.append(" AND t3.EXFENOAI = ?");
			params.add(sanprue.getExpedien().getExfenoai());
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExfecolm() != null) {
			where.append(" AND t3.EXFECOLM = ?");
			params.add(sanprue.getExpedien().getExfecolm());
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExnuinlm() != null) {
			where.append(" AND UPPER(t3.EXNUINLM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanprue.getExpedien().getExnuinlm().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanprue.getExpedien().getExnuinlm().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.EXNUINLM IS NOT NULL");
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExfeinmu() != null) {
			where.append(" AND t3.EXFEINMU = ?");
			params.add(sanprue.getExpedien().getExfeinmu());
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExfeavmu() != null) {
			where.append(" AND t3.EXFEAVMU = ?");
			params.add(sanprue.getExpedien().getExfeavmu());
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExfeimcd() != null) {
			where.append(" AND t3.EXFEIMCD = ?");
			params.add(sanprue.getExpedien().getExfeimcd());
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExfecede() != null) {
			where.append(" AND t3.EXFECEDE = ?");
			params.add(sanprue.getExpedien().getExfecede());
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExcops() != null) {
			where.append(" AND UPPER(t3.EXCOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanprue.getExpedien().getExcops().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanprue.getExpedien().getExcops().toUpperCase() + "%");
			}
			where.append(" AND t3.EXCOPS IS NOT NULL");
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getExcose() != null) {
			where.append(" AND UPPER(t3.EXCOSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanprue.getExpedien().getExcose().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanprue.getExpedien().getExcose().toUpperCase() + "%");
			}
			where.append(" AND t3.EXCOSE IS NOT NULL");
		}
		if (sanprue != null && sanprue.getExpedien() != null
				&& sanprue.getExpedien().getSanexp() != null
				&& sanprue.getExpedien().getSanexp().getExcodigo() != null) {
			where.append(" AND UPPER(t3.EXCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanprue.getExpedien().getSanexp().getExcodigo()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanprue.getExpedien().getSanexp().getExcodigo()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.EXCODIGO IS NOT NULL");
		}
		if (sanprue != null && sanprue.getPresid() != null) {
			where.append(" AND UPPER(t1.PRESID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanprue.getPresid().toUpperCase() + "%");
			} else {
				params.add("%" + sanprue.getPresid().toUpperCase() + "%");
			}
			where.append(" AND t1.PRESID IS NOT NULL");
		}
		if (sanprue != null && sanprue.getPrtipoprue() != null) {
			where.append(" AND UPPER(t1.PRTIPOPRUE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanprue.getPrtipoprue().toUpperCase() + "%");
			} else {
				params.add("%" + sanprue.getPrtipoprue().toUpperCase() + "%");
			}
			where.append(" AND t1.PRTIPOPRUE IS NOT NULL");
		}
		if (sanprue != null && sanprue.getPrfecprue() != null) {
			where.append(" AND t1.PRFECPRUE = ?");
			params.add(sanprue.getPrfecprue());
		}
		if (sanprue != null && sanprue.getPrres() != null) {
			where.append(" AND UPPER(t1.PRRES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanprue.getPrres().toUpperCase() + "%");
			} else {
				params.add("%" + sanprue.getPrres().toUpperCase() + "%");
			}
			where.append(" AND t1.PRRES IS NOT NULL");
		}
		if (sanprue != null && sanprue.getPrfecprac() != null) {
			where.append(" AND t1.PRFECPRAC = ?");
			params.add(sanprue.getPrfecprac());
		}
		if (sanprue != null && sanprue.getPrfecalta() != null) {
			where.append(" AND t1.PRFECALTA = ?");
			params.add(sanprue.getPrfecalta());
		}
		if (sanprue != null && sanprue.getPrfecmodif() != null) {
			where.append(" AND t1.PRFECMODIF = ?");
			params.add(sanprue.getPrfecmodif());
		}
		if (sanprue != null && sanprue.getPrusualta() != null) {
			where.append(" AND UPPER(t1.PRUSUALTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanprue.getPrusualta().toUpperCase() + "%");
			} else {
				params.add("%" + sanprue.getPrusualta().toUpperCase() + "%");
			}
			where.append(" AND t1.PRUSUALTA IS NOT NULL");
		}
		if (sanprue != null && sanprue.getPrusumodif() != null) {
			where.append(" AND UPPER(t1.PRUSUMODIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanprue.getPrusumodif().toUpperCase() + "%");
			} else {
				params.add("%" + sanprue.getPrusumodif().toUpperCase() + "%");
			}
			where.append(" AND t1.PRUSUMODIF IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
