package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.Sanprue;

/**
 * SanprueDao  
 *  
 */

public interface SanprueDao {
    
    /**
     * Inserts a single row in the Sanprue table.
     *
     * @param sanprue Sanprue
     * @return Sanprue
     */
    Sanprue add(Sanprue sanprue);

    /**
     * Updates a single row in the Sanprue table.
     *
     * @param sanprue Sanprue
     * @return Sanprue
     */
    Sanprue update(Sanprue sanprue);

    /**
     * Finds a single row in the Sanprue table.
     *
     * @param sanprue Sanprue
     * @return Sanprue
     */
    Sanprue find(Sanprue sanprue);

    /**
     * Deletes a single row in the Sanprue table.
     *
     * @param sanprue Sanprue
     * @return 
     */
    void remove(Sanprue sanprue);

    /**
     * Finds a List of rows in the Sanprue table.
     *
     * @param sanprue Sanprue
     * @param pagination Pagination
     * @return List
     */
    List<Sanprue> findAll(Sanprue sanprue, Pagination pagination);

    /**
     * Counts rows in the Sanprue table.
     *
     * @param sanprue Sanprue
     * @return Long
     */
    Long findAllCount(Sanprue sanprue);
	
	/**
     * Finds rows in the Sanprue table using like.
     *
     * @param sanprue Sanprue
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List
     */
	List<Sanprue> findAllLike(Sanprue sanprue, Pagination pagination, Boolean startsWith);
	
    /**
     * Counts rows in the Sanprue table using like.
     *
     * @param sanprue Sanprue
     * @param startsWith Boolean
     * @return Long
     */
    Long findAllLikeCount(Sanprue sanprue, Boolean startsWith);
}

