package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
//import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Establecimiento;
import com.ejie.y41b.model.Sanpropbandeja;
import com.ejie.y41b.model.TipoProcedimiento;

/**
 * SanpropbandejaDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class SanpropbandejaDaoImpl implements SanpropbandejaDao {
	private JdbcTemplate jdbcTemplate;
	@Resource()
	private ReloadableResourceBundleMessageSource appMessageSource;

	private RowMapper<Sanpropbandeja> rwMapDefecto = new RowMapper<Sanpropbandeja>() {
		public Sanpropbandeja mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			Sanpropbandeja sanpropbandeja = new Sanpropbandeja(
					resultSet.getLong("BAPRSANID"),
					resultSet.getString("BAPRSANEXCODIGO"),
					resultSet.getString("BAPRSANEXCODCOMPLETO"),
					resultSet.getString("BAPRSANPCODIGO"),
					resultSet.getDate("BAPRSANFEC"),
					resultSet.getString("BAPRSANSANCIONADO"),
					resultSet.getString("BAPRSANPROV"),
					resultSet.getString("BAPRSANMUNIC"),
					resultSet.getString("BAPRSANRESPEXP"),
					resultSet.getDate("BAPRSANFECALTA"),
					resultSet.getDate("BAPRSANFECMODIF"),
					resultSet.getString("BAPRSANUSUALTA"),
					resultSet.getString("BAPRSANUSUMODIF"));

			return sanpropbandeja;
		}
	};

	private RowMapper<Sanpropbandeja> rwMap = new RowMapper<Sanpropbandeja>() {
		public Sanpropbandeja mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			Establecimiento establecimiento = new Establecimiento(
					resultSet.getString("BAPRSANSANCIONADO"));
			establecimiento.setEsnoco(resultSet.getString("ESNOCO"));
			CensoMonitor monitor = new CensoMonitor();
			monitor.setMocodigo(resultSet.getString("BAPRSANRESPEXP"));
			monitor.setMonombre(resultSet.getString("MONOMBRE"));
			TipoProcedimiento tipoproc = new TipoProcedimiento();
			tipoproc.setPcodigo(resultSet.getString("BAPRSANPCODIGO"));
			tipoproc.setPnombre(resultSet.getString("PNOMBRE"));
			tipoproc.setPnombree(resultSet.getString("PNOMBREE"));
			return new Sanpropbandeja(resultSet.getLong("BAPRSANID"),
					resultSet.getString("BAPRSANEXCODIGO"),
					resultSet.getString("BAPRSANEXCODCOMPLETO"), tipoproc,
					resultSet.getDate("BAPRSANFEC"), establecimiento,
					resultSet.getString("MUNIPDS_O"),
					resultSet.getString("PROVDS_O"), monitor,
					resultSet.getDate("BAPRSANFECALTA"),
					resultSet.getDate("BAPRSANFECMODIF"),
					resultSet.getString("BAPRSANUSUALTA"),
					resultSet.getString("BAPRSANUSUMODIF"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Sanpropbandeja table.
	 * 
	 * @param sanpropbandeja
	 *            Pagination
	 * @return Sanpropbandeja
	 */
	public Sanpropbandeja add(Sanpropbandeja sanpropbandeja) {
		String query = "INSERT INTO SANPROPBANDEJA (BAPRSANEXCODIGO, BAPRSANFEC, BAPRSANSANCIONADO, BAPRSANPROV, BAPRSANMUNIC, BAPRSANRESPEXP, BAPRSANPCODIGO, BAPRSANEXCODCOMPLETO) VALUES (?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, sanpropbandeja.getBaprsanexcodigo(),
				sanpropbandeja.getBaprsanfec(),
				sanpropbandeja.getBaprsansancionado(),
				sanpropbandeja.getBaprsanprov(),
				sanpropbandeja.getBaprsanmunic(),
				sanpropbandeja.getBaprsanrespexp(),
				sanpropbandeja.getBaprsanpcodigo(),
				sanpropbandeja.getBaprsanexcodigocompleto());
		return sanpropbandeja;
	}

	/**
	 * Updates a single row in the Sanpropbandeja table.
	 * 
	 * @param sanpropbandeja
	 *            Pagination
	 * @return Sanpropbandeja
	 */
	public Sanpropbandeja update(Sanpropbandeja sanpropbandeja) {
		String query = "UPDATE SANPROPBANDEJA SET BAPRSANEXCODIGO=?, BAPRSANEXCODCOMPLETO=?, BAPRSANFEC=?, BAPRSANSANCIONADO=?, BAPRSANPROV=?, BAPRSANMUNIC=?, BAPRSANRESPEXP=? WHERE BAPRSANID=?";
		this.jdbcTemplate.update(query, sanpropbandeja.getBaprsanexcodigo(),
				sanpropbandeja.getBaprsanexcodigocompleto(),
				sanpropbandeja.getBaprsanfec(),
				sanpropbandeja.getBaprsansancionado(),
				sanpropbandeja.getBaprsanprov(),
				sanpropbandeja.getBaprsanmunic(),
				sanpropbandeja.getBaprsanrespexp(),
				sanpropbandeja.getBaprsanid());
		return sanpropbandeja;
	}

	/**
	 * Updates a single row in the Sanpropbandeja table.
	 * 
	 * @param escodigoBueno
	 *            Pagination
	 * @param escodigoAfusionar
	 *            Pagination
	 */
	public void updateEstablecimiento(String escodigoBueno,
			String escodigoAfusionar) {
		try {
			String query = "UPDATE SANPROPBANDEJA SET BAPRSANSANCIONADO =? WHERE BAPRSANSANCIONADO =? ";
			this.jdbcTemplate.update(query, escodigoBueno, escodigoAfusionar);
		} catch (Exception e) {

		}
	}

	/**
	 * Finds a single row in the Sanpropbandeja table.
	 * 
	 * @param sanpropbandeja
	 *            Pagination
	 * @return Sanpropbandeja
	 */
	@Transactional(readOnly = true)
	public Sanpropbandeja find(Sanpropbandeja sanpropbandeja) {
		String query = "SELECT t1.BAPRSANID BAPRSANID, t1.BAPRSANEXCODIGO BAPRSANEXCODIGO, t1.BAPRSANEXCODCOMPLETO BAPRSANEXCODCOMPLETO,t1.BAPRSANPCODIGO BAPRSANPCODIGO, t1.BAPRSANFEC BAPRSANFEC, t1.BAPRSANSANCIONADO BAPRSANSANCIONADO, t1.BAPRSANPROV BAPRSANPROV, t1.BAPRSANMUNIC BAPRSANMUNIC, t1.BAPRSANRESPEXP BAPRSANRESPEXP, t1.BAPRSANFECALTA BAPRSANFECALTA, t1.BAPRSANFECMODIF BAPRSANFECMODIF, t1.BAPRSANUSUALTA BAPRSANUSUALTA, t1.BAPRSANUSUMODIF BAPRSANUSUMODIF FROM SANPROPBANDEJA t1  WHERE t1.BAPRSANID = ?  ";

		List<Sanpropbandeja> sanpropbandejaList = this.jdbcTemplate.query(
				query, this.rwMapDefecto, sanpropbandeja.getBaprsanid());
		return (Sanpropbandeja) DataAccessUtils
				.uniqueResult(sanpropbandejaList);
	}

	/**
	 * Removes a single row in the Sanpropbandeja table.
	 * 
	 * @param sanpropbandeja
	 *            Pagination
	 * @return
	 */
	public void remove(Sanpropbandeja sanpropbandeja) {
		String query = "DELETE FROM SANPROPBANDEJA WHERE BAPRSANID=?";
		this.jdbcTemplate.update(query, sanpropbandeja.getBaprsanid());
	}

	/**
	 * Removes a single row in the Sanpropbandeja table.
	 * 
	 * @param sanpropbandeja
	 *            Pagination
	 * @return
	 */
	public void removeSolicitudes(Sanpropbandeja sanpropbandeja) {
		String query = "DELETE FROM SANPROPBANDEJA WHERE BAPRSANEXCODIGO=?";
		this.jdbcTemplate.update(query, sanpropbandeja.getBaprsanexcodigo());
	}

	/**
	 * Removes a single row in the Sanpropbandeja table.
	 * 
	 * @param sanpropbandeja
	 *            Pagination
	 * @return
	 */
	public void removeInspecciones(Sanpropbandeja sanpropbandeja) {
		String query = "DELETE FROM SANPROPBANDEJA WHERE BAPRSANEXCODIGO=? AND BAPRSANSANCIONADO=?";
		this.jdbcTemplate.update(query, sanpropbandeja.getBaprsanexcodigo(),
				sanpropbandeja.getBaprsansancionado());
	}

	/**
	 * Finds a List of rows in the Sanpropbandeja table.
	 * 
	 * @param sanpropbandeja
	 *            Sanpropbandeja
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Sanpropbandeja> findAll(Sanpropbandeja sanpropbandeja,
			Pagination pagination) {

		// 0150322 tratamos PNOMBRE para que pueda sacar Denuncia de empresas si
		// se da el caso
		StringBuilder query = new StringBuilder(
				"SELECT DISTINCT t1.BAPRSANID BAPRSANID,t1.BAPRSANEXCODIGO BAPRSANEXCODIGO, t1.BAPRSANEXCODCOMPLETO BAPRSANEXCODCOMPLETO, t1.BAPRSANPCODIGO BAPRSANPCODIGO, t1.BAPRSANFEC BAPRSANFEC,t1.BAPRSANSANCIONADO BAPRSANSANCIONADO,t2.ESNOCO ESNOCO,t1.BAPRSANPROV BAPRSANPROV, t1.BAPRSANMUNIC BAPRSANMUNIC, t4.DS_O MUNIPDS_O,t1.BAPRSANRESPEXP BAPRSANRESPEXP, T3.MONOMBRE MONOMBRE,t1.BAPRSANFECALTA BAPRSANFECALTA,t1.BAPRSANFECMODIF BAPRSANFECMODIF,t1.BAPRSANUSUALTA BAPRSANUSUALTA,t1.BAPRSANUSUMODIF BAPRSANUSUMODIF, T5.DS_O PROVDS_O, t6.PCODIGO PCODIGO,"
						+
						// // " t6.PNOMBRE PNOMBRE, t6.PNOMBREE PNOMBREE ");
						// " CASE WHEN (t7.HCCOOR = '"
						// + Y41bConstantes.CODIGO_ORGANISMO_BIZKAIA
						// + "' OR t7.HCCOOR = '"
						// + Y41bConstantes.CODIGO_ORGANISMO_GIPUZKOA
						// + "' OR t7.HCCOOR = '"
						// + Y41bConstantes.CODIGO_ORGANISMO_ARABA
						// + "' OR t7.HCCOOR IS NULL) THEN t6.PNOMBRE ELSE '"
						// + this.appMessageSource.getMessage(
						// "comun.denunciaEmpresa", null, new Locale(
						// Y41bConstantes.CASTELLANO))
						// + "' END AS PNOMBRE,"
						// +
						// // ", t6.PNOMBREE PNOMBREE ");
						// "CASE WHEN (t7.HCCOOR = '"
						// + Y41bConstantes.CODIGO_ORGANISMO_BIZKAIA
						// + "' OR t7.HCCOOR = '"
						// + Y41bConstantes.CODIGO_ORGANISMO_GIPUZKOA
						// + "' OR t7.HCCOOR = '"
						// + Y41bConstantes.CODIGO_ORGANISMO_ARABA
						// + "' OR t7.HCCOOR IS NULL) THEN t6.PNOMBRE ELSE '"
						// + this.appMessageSource.getMessage(
						// "comun.denunciaEmpresa", null, new Locale(
						// Y41bConstantes.EUSKERA))
						// + "' END AS PNOMBREE ");
						" CASE WHEN t9.HDDENUNCIAAACCEMPRESAS='S' THEN '"
						+ this.appMessageSource.getMessage(
								"comun.denunciaEmpresa", null, new Locale(
										Y41bConstantes.CASTELLANO))
						+ "' ELSE t6.PNOMBRE END AS PNOMBRE,"
						+ " CASE WHEN t9.HDDENUNCIAAACCEMPRESAS='S' THEN '"
						+ this.appMessageSource.getMessage(
								"comun.denunciaEmpresa", null, new Locale(
										Y41bConstantes.EUSKERA))
						+ "' ELSE t6.PNOMBREE END AS PNOMBREE ");
		query.append("FROM SANPROPBANDEJA t1, ESTABLECIMIENTO t2, CENSO_MONITOR t3, T17_MUNICIPIO t4, T17_PROVINCIA t5, TIPO_PROCEDIMIENTO t6, DECISION_HECHO t7,  ACTDEC t8, HECHO_DENUNCIADO t9 ");
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(sanpropbandeja);
		StringBuilder where = new StringBuilder(
				"WHERE 1=1 AND t1.BAPRSANEXCODIGO=t7.HCCOHD(+) AND t1.BAPRSANEXCODIGO=t8.ADCOAT(+) AND t1.BAPRSANSANCIONADO= t2.ESCODIGO(+) AND t1.BAPRSANRESPEXP = t3.MOCODIGO(+) AND t1.BAPRSANMUNIC = t4.ID(+) AND t1.BAPRSANPROV = t5.ID(+) AND t1.BAPRSANPROV = t4.PROVINCIA_ID(+) AND t1.BAPRSANPCODIGO=t6.PCODIGO AND t1.BAPRSANEXCODIGO=t9.HDCODIGO(+) ");

		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Sanpropbandeja>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Sanpropbandeja table.
	 * 
	 * @param sanpropbandeja
	 *            Sanpropbandeja
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Sanpropbandeja sanpropbandeja) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM SANPROPBANDEJA t1, DECISION_HECHO t7, ACTDEC t8  ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(sanpropbandeja);
		StringBuilder where = new StringBuilder(
				"WHERE 1=1 AND t1.BAPRSANEXCODIGO=t7.HCCOHD(+) AND t1.BAPRSANEXCODIGO=t8.ADCOAT(+)");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Sanpropbandeja table using like.
	 * 
	 * @param sanpropbandeja
	 *            Sanpropbandeja
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Sanpropbandeja> findAllLike(Sanpropbandeja sanpropbandeja,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.BAPRSANID BAPRSANID,t1.BAPRSANEXCODIGO BAPRSANEXCODIGO, t1.BAPRSANEXCODCOMPLETO BAPRSANEXCODCOMPLETO, t1.BAPRSANPCODIGO BAPRSANPCODIGO, t1.BAPRSANFEC BAPRSANFEC,t1.BAPRSANSANCIONADO BAPRSANSANCIONADO,t1.BAPRSANPROV BAPRSANPROV, t1.BAPRSANMUNIC BAPRSANMUNIC,t1.BAPRSANRESPEXP BAPRSANRESPEXP,t1.BAPRSANFECALTA BAPRSANFECALTA,t1.BAPRSANFECMODIF BAPRSANFECMODIF,t1.BAPRSANUSUALTA BAPRSANUSUALTA,t1.BAPRSANUSUMODIF BAPRSANUSUMODIF ");
		query.append("FROM SANPROPBANDEJA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(sanpropbandeja,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Sanpropbandeja>) this.jdbcTemplate.query(query.toString(),
				this.rwMapDefecto, params.toArray());
	}

	/**
	 * Counts rows in the Sanpropbandeja table using like.
	 * 
	 * @param sanpropbandeja
	 *            Sanpropbandeja
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Sanpropbandeja sanpropbandeja,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM SANPROPBANDEJA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(sanpropbandeja,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Sanpropbandeja entity
	 * 
	 * @param sanpropbandeja
	 *            Sanpropbandeja Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Sanpropbandeja sanpropbandeja) {

		StringBuilder where = new StringBuilder(
				SanpropbandejaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (sanpropbandeja != null && sanpropbandeja.getBaprsanid() != null) {
			where.append(" AND t1.BAPRSANID = ?");
			params.add(sanpropbandeja.getBaprsanid());
		}
		if (sanpropbandeja != null
				&& sanpropbandeja.getBaprsanexcodigo() != null) {
			where.append(" AND t1.BAPRSANEXCODIGO = ?");
			params.add(sanpropbandeja.getBaprsanexcodigo());
		}
		if (sanpropbandeja != null
				&& sanpropbandeja.getBaprsanexcodigocompleto() != null) {
			where.append(" AND t1.BAPRSANEXCODCOMPLETO = ?");
			params.add(sanpropbandeja.getBaprsanexcodigocompleto());
		}

		if (sanpropbandeja != null && sanpropbandeja.getBaprsanfec() != null) {
			where.append(" AND t1.BAPRSANFEC = ?");
			params.add(sanpropbandeja.getBaprsanfec());
		}
		if (sanpropbandeja != null
				&& sanpropbandeja.getBaprsansancionado() != null) {
			where.append(" AND t1.BAPRSANSANCIONADO = ?");
			params.add(sanpropbandeja.getBaprsansancionado());
		}
		if (sanpropbandeja != null && sanpropbandeja.getBaprsanprov() != null) {
			where.append(" AND t1.BAPRSANPROV = ?");
			params.add(sanpropbandeja.getBaprsanprov());
		}
		if (sanpropbandeja != null && sanpropbandeja.getBaprsanmunic() != null) {
			where.append(" AND t1.BAPRSANMUNIC = ?");
			params.add(sanpropbandeja.getBaprsanmunic());
		}
		if (sanpropbandeja != null
				&& sanpropbandeja.getBaprsanrespexp() != null) {
			where.append(" AND t1.BAPRSANRESPEXP = ?");
			params.add(sanpropbandeja.getBaprsanrespexp());
		}
		if (sanpropbandeja != null
				&& sanpropbandeja.getBaprsanfecalta() != null) {
			where.append(" AND t1.BAPRSANFECALTA = ?");
			params.add(sanpropbandeja.getBaprsanfecalta());
		}
		if (sanpropbandeja != null
				&& sanpropbandeja.getBaprsanfecmodif() != null) {
			where.append(" AND t1.BAPRSANFECMODIF = ?");
			params.add(sanpropbandeja.getBaprsanfecmodif());
		}
		if (sanpropbandeja != null
				&& sanpropbandeja.getBaprsanusualta() != null) {
			where.append(" AND t1.BAPRSANUSUALTA = ?");
			params.add(sanpropbandeja.getBaprsanusualta());
		}
		if (sanpropbandeja != null
				&& sanpropbandeja.getBaprsanusumodif() != null) {
			where.append(" AND t1.BAPRSANUSUMODIF = ?");
			params.add(sanpropbandeja.getBaprsanusumodif());
		}
		// 0150322
		if (sanpropbandeja != null
				&& sanpropbandeja.getCensoMonitor() != null
				&& sanpropbandeja.getCensoMonitor().getOrganismo() != null
				&& sanpropbandeja.getCensoMonitor().getOrganismo().getCodOrg() != null
				&& !Y41bConstantes.PERFIL_SUPERVISOR.equals(sanpropbandeja
						.getCensoMonitor().getPerfilSanciones().getIdPerfil())) {
			// where.append(" AND (( CASE WHEN t7.HCCOOR IN ('"
			// + Y41bConstantes.CODIGO_ORGANISMO_ARABA + "','"
			// + Y41bConstantes.CODIGO_ORGANISMO_BIZKAIA + "','"
			// + Y41bConstantes.CODIGO_ORGANISMO_GIPUZKOA
			// + "') THEN t7.HCCOOR ");
			// where.append(" WHEN t7.HCCOOR IS NOT NULL AND t1.BAPRSANPROV = '"
			// + Y41bConstantes.CODIGO_PROVINCIA_ARABA + "' THEN '"
			// + Y41bConstantes.CODIGO_ORGANISMO_ARABA + "' ");
			// where.append(" WHEN t7.HCCOOR IS NOT NULL AND t1.BAPRSANPROV = '"
			// + Y41bConstantes.CODIGO_PROVINCIA_BIZKAIA + "' THEN '"
			// + Y41bConstantes.CODIGO_ORGANISMO_BIZKAIA + "' ");
			// where.append(" WHEN t7.HCCOOR IS NOT NULL AND t1.BAPRSANPROV = '"
			// + Y41bConstantes.CODIGO_PROVINCIA_GIPUZKOA + "' THEN '"
			// + Y41bConstantes.CODIGO_ORGANISMO_GIPUZKOA + "' ");
			// where.append(" WHEN t7.HCCOOR IS NOT NULL THEN '"
			// + Y41bConstantes.CODIGO_ORGANISMO_ARABA + "' ");
			// where.append(" ELSE NULL END = ?) OR t7.HCCOOR IS NULL) ");
			// params.add(sanpropbandeja.getCensoMonitor().getOrganismo()
			// .getCodOrg());
			// where.append(" AND (( CASE WHEN t8.ADCOOR IN ('"
			// + Y41bConstantes.CODIGO_ORGANISMO_ARABA + "','"
			// + Y41bConstantes.CODIGO_ORGANISMO_BIZKAIA + "','"
			// + Y41bConstantes.CODIGO_ORGANISMO_GIPUZKOA
			// + "') THEN t8.ADCOOR ");
			// where.append(" WHEN t8.ADCOOR IS NOT NULL AND t1.BAPRSANPROV = '"
			// + Y41bConstantes.CODIGO_PROVINCIA_ARABA + "' THEN '"
			// + Y41bConstantes.CODIGO_ORGANISMO_ARABA + "' ");
			// where.append(" WHEN t8.ADCOOR IS NOT NULL AND t1.BAPRSANPROV = '"
			// + Y41bConstantes.CODIGO_PROVINCIA_BIZKAIA + "' THEN '"
			// + Y41bConstantes.CODIGO_ORGANISMO_BIZKAIA + "' ");
			// where.append(" WHEN t8.ADCOOR IS NOT NULL AND t1.BAPRSANPROV = '"
			// + Y41bConstantes.CODIGO_PROVINCIA_GIPUZKOA + "' THEN '"
			// + Y41bConstantes.CODIGO_ORGANISMO_GIPUZKOA + "' ");
			// where.append(" WHEN t8.ADCOOR IS NOT NULL THEN '"
			// + Y41bConstantes.CODIGO_ORGANISMO_ARABA + "' ");
			// where.append(" ELSE NULL END = ?) OR t8.ADCOOR IS NULL) ");
			// params.add(sanpropbandeja.getCensoMonitor().getOrganismo()
			// .getCodOrg());

			// 0160753: Bandeja de Sancionador - Cambio de orgnico
			where.append(" AND ( CASE WHEN t1.BAPRNUEVOORGANISMO IS NOT NULL AND t1.BAPRNUEVOORGANISMO = ? THEN 1 WHEN t1.BAPRNUEVOORGANISMO IS NULL");
			params.add(sanpropbandeja.getCensoMonitor().getOrganismo()
					.getCodOrg());

			where.append(" AND (");
			where.append(" (( CASE WHEN t7.HCCOOR IN ('"
					+ Y41bConstantes.CODIGO_ORGANISMO_ARABA + "','"
					+ Y41bConstantes.CODIGO_ORGANISMO_BIZKAIA + "','"
					+ Y41bConstantes.CODIGO_ORGANISMO_GIPUZKOA
					+ "') THEN t7.HCCOOR ");
			where.append(" WHEN t7.HCCOOR IS NOT NULL AND t1.BAPRSANPROV = '"
					+ Y41bConstantes.CODIGO_PROVINCIA_ARABA + "' THEN '"
					+ Y41bConstantes.CODIGO_ORGANISMO_ARABA + "' ");
			where.append(" WHEN t7.HCCOOR IS NOT NULL AND t1.BAPRSANPROV = '"
					+ Y41bConstantes.CODIGO_PROVINCIA_BIZKAIA + "' THEN '"
					+ Y41bConstantes.CODIGO_ORGANISMO_BIZKAIA + "' ");
			where.append(" WHEN t7.HCCOOR IS NOT NULL AND t1.BAPRSANPROV = '"
					+ Y41bConstantes.CODIGO_PROVINCIA_GIPUZKOA + "' THEN '"
					+ Y41bConstantes.CODIGO_ORGANISMO_GIPUZKOA + "' ");
			where.append(" WHEN t7.HCCOOR IS NOT NULL THEN '"
					+ Y41bConstantes.CODIGO_ORGANISMO_ARABA + "' ");
			where.append(" ELSE NULL END = ?) OR t7.HCCOOR IS NULL) ");
			params.add(sanpropbandeja.getCensoMonitor().getOrganismo()
					.getCodOrg());
			where.append(" AND (( CASE WHEN t8.ADCOOR IN ('"
					+ Y41bConstantes.CODIGO_ORGANISMO_ARABA + "','"
					+ Y41bConstantes.CODIGO_ORGANISMO_BIZKAIA + "','"
					+ Y41bConstantes.CODIGO_ORGANISMO_GIPUZKOA
					+ "') THEN t8.ADCOOR ");
			where.append(" WHEN t8.ADCOOR IS NOT NULL AND t1.BAPRSANPROV = '"
					+ Y41bConstantes.CODIGO_PROVINCIA_ARABA + "' THEN '"
					+ Y41bConstantes.CODIGO_ORGANISMO_ARABA + "' ");
			where.append(" WHEN t8.ADCOOR IS NOT NULL AND t1.BAPRSANPROV = '"
					+ Y41bConstantes.CODIGO_PROVINCIA_BIZKAIA + "' THEN '"
					+ Y41bConstantes.CODIGO_ORGANISMO_BIZKAIA + "' ");
			where.append(" WHEN t8.ADCOOR IS NOT NULL AND t1.BAPRSANPROV = '"
					+ Y41bConstantes.CODIGO_PROVINCIA_GIPUZKOA + "' THEN '"
					+ Y41bConstantes.CODIGO_ORGANISMO_GIPUZKOA + "' ");
			where.append(" WHEN t8.ADCOOR IS NOT NULL THEN '"
					+ Y41bConstantes.CODIGO_ORGANISMO_ARABA + "' ");
			where.append(" ELSE NULL END = ?) OR t8.ADCOOR IS NULL) ");
			params.add(sanpropbandeja.getCensoMonitor().getOrganismo()
					.getCodOrg());
			where.append(" ) THEN 1 ELSE 0 END = 1 ) ");
			// 0160753: Bandeja de Sancionador - Cambio de orgnico
		}
		// // EVOLUTIVO 0135083 2.11
		// if (sanpropbandeja != null && sanpropbandeja.getCodOrg() != null) {
		// where.append("AND (EXISTS (SELECT 1 FROM ACTDEC A  WHERE A.ADCOAT = t1.BAPRSANEXCODIGO AND  A.ADCOOR = ? ) ");
		// params.add(sanpropbandeja.getCodOrg());
		// where.append("OR EXISTS (SELECT 1 FROM DECISION_HECHO B WHERE B.HCCOHD = t1.BAPRSANEXCODIGO AND  B.HCCOOR= ? )");
		// params.add(sanpropbandeja.getCodOrg());
		// where.append("OR EXISTS (SELECT 1 FROM SOLARB C WHERE C.SACODIGO = t1.BAPRSANEXCODIGO AND  C.SACOJA= ? ))");
		// params.add(sanpropbandeja.getCodOrg());
		// }

		// 0160753: Bandeja de Sancionador - Cambio de orgnico
		if (sanpropbandeja != null && sanpropbandeja.getCodOrg() != null) {
			where.append(" AND ( CASE WHEN t1.BAPRNUEVOORGANISMO IS NOT NULL AND t1.BAPRNUEVOORGANISMO = ? THEN 1 WHEN t1.BAPRNUEVOORGANISMO IS NULL");
			params.add(sanpropbandeja.getCodOrg());
			where.append(" AND (EXISTS (SELECT 1 FROM ACTDEC A  WHERE A.ADCOAT = t1.BAPRSANEXCODIGO AND  A.ADCOOR = ? ) ");
			params.add(sanpropbandeja.getCodOrg());
			where.append(" OR EXISTS (SELECT 1 FROM DECISION_HECHO B WHERE B.HCCOHD = t1.BAPRSANEXCODIGO AND  B.HCCOOR= ? )");
			params.add(sanpropbandeja.getCodOrg());
			where.append(" OR EXISTS (SELECT 1 FROM SOLARB C WHERE C.SACODIGO = t1.BAPRSANEXCODIGO AND  C.SACOJA= ? ))");
			params.add(sanpropbandeja.getCodOrg());
			where.append("  THEN 1 ELSE 0 END = 1 ) ");
		}
		// 0160753: Bandeja de Sancionador - Cambio de orgnico
		// EVOLUTIVO 0135083 2.11

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Sanpropbandeja entity
	 * 
	 * @param sanpropbandeja
	 *            Sanpropbandeja Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Sanpropbandeja sanpropbandeja,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				SanpropbandejaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (sanpropbandeja != null && sanpropbandeja.getBaprsanid() != null) {
			where.append(" AND t1.BAPRSANID = ?");
			params.add(sanpropbandeja.getBaprsanid());
		}
		if (sanpropbandeja != null
				&& sanpropbandeja.getBaprsanexcodigo() != null) {
			where.append(" AND UPPER(t1.BAPRSANEXCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanpropbandeja.getBaprsanexcodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanpropbandeja.getBaprsanexcodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.BAPRSANEXCODIGO IS NOT NULL");
		}
		if (sanpropbandeja != null
				&& sanpropbandeja.getBaprsanexcodigocompleto() != null) {
			where.append(" AND UPPER(t1.BAPRSANEXCODCOMPLETO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanpropbandeja.getBaprsanexcodigocompleto()
						.toUpperCase() + "%");
			} else {
				params.add("%"
						+ sanpropbandeja.getBaprsanexcodigocompleto()
								.toUpperCase() + "%");
			}
			where.append(" AND t1.BAPRSANEXCODCOMPLETO IS NOT NULL");
		}
		if (sanpropbandeja != null && sanpropbandeja.getBaprsanfec() != null) {
			where.append(" AND t1.BAPRSANFEC = ?");
			params.add(sanpropbandeja.getBaprsanfec());
		}
		if (sanpropbandeja != null
				&& sanpropbandeja.getBaprsansancionado() != null) {
			where.append(" AND UPPER(t1.BAPRSANSANCIONADO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanpropbandeja.getBaprsansancionado().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanpropbandeja.getBaprsansancionado().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.BAPRSANSANCIONADO IS NOT NULL");
		}
		if (sanpropbandeja != null && sanpropbandeja.getBaprsanmunic() != null) {
			where.append(" AND UPPER(t1.BAPRSANMUNIC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanpropbandeja.getBaprsanmunic().toUpperCase() + "%");
			} else {
				params.add("%" + sanpropbandeja.getBaprsanmunic().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.BAPRSANMUNIC IS NOT NULL");
		}
		if (sanpropbandeja != null && sanpropbandeja.getBaprsanprov() != null) {
			where.append(" AND UPPER(t1.BAPRSANPROV) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanpropbandeja.getBaprsanprov().toUpperCase() + "%");
			} else {
				params.add("%" + sanpropbandeja.getBaprsanprov().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.BAPRSANPROV IS NOT NULL");
		}
		if (sanpropbandeja != null
				&& sanpropbandeja.getBaprsanrespexp() != null) {
			where.append(" AND UPPER(t1.BAPRSANRESPEXP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanpropbandeja.getBaprsanrespexp().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanpropbandeja.getBaprsanrespexp().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.BAPRSANRESPEXP IS NOT NULL");
		}
		if (sanpropbandeja != null
				&& sanpropbandeja.getBaprsanfecalta() != null) {
			where.append(" AND t1.BAPRSANFECALTA = ?");
			params.add(sanpropbandeja.getBaprsanfecalta());
		}
		if (sanpropbandeja != null
				&& sanpropbandeja.getBaprsanfecmodif() != null) {
			where.append(" AND t1.BAPRSANFECMODIF = ?");
			params.add(sanpropbandeja.getBaprsanfecmodif());
		}
		if (sanpropbandeja != null
				&& sanpropbandeja.getBaprsanusualta() != null) {
			where.append(" AND UPPER(t1.BAPRSANUSUALTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanpropbandeja.getBaprsanusualta().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanpropbandeja.getBaprsanusualta().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.BAPRSANUSUALTA IS NOT NULL");
		}
		if (sanpropbandeja != null
				&& sanpropbandeja.getBaprsanusumodif() != null) {
			where.append(" AND UPPER(t1.BAPRSANUSUMODIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(sanpropbandeja.getBaprsanusumodif().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ sanpropbandeja.getBaprsanusumodif().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.BAPRSANUSUMODIF IS NOT NULL");
		}
		// EVOLUTIVO 0135083 2.11
		if (sanpropbandeja != null && sanpropbandeja.getCodOrg() != null) {

			where.append("AND (EXISTS (SELECT 1 FROM ACTDEC A  WHERE A.ADCOAT = t1.BAPRSANEXCODIGO AND  A.ADCOOR = ? ) ");
			params.add(sanpropbandeja.getCodOrg());
			where.append("OR EXISTS (SELECT 1 FROM DECISION_HECHO B WHERE B.HCCOHD = t1.BAPRSANEXCODIGO AND  B.HCCOOR= ? )");
			params.add(sanpropbandeja.getCodOrg());
			where.append("OR EXISTS (SELECT 1 FROM SOLARB C WHERE C.SACODIGO = t1.BAPRSANEXCODIGO AND  C.SACOJA= ? ))");
			params.add(sanpropbandeja.getCodOrg());
		}

		// EVOLUTIVO 0135083 2.11
		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	// 0160753: Bandeja de Sancionador - Cambio de orgnico
	/**
	 * Updates a single row in the Sanpropbandeja table.
	 * 
	 * @param sanpropbandeja
	 *            Pagination
	 * @return Sanpropbandeja
	 */
	public Sanpropbandeja updateBaprNuevoOrganismo(Sanpropbandeja sanpropbandeja) {
		String query = "UPDATE SANPROPBANDEJA SET BAPRNUEVOORGANISMO=? WHERE BAPRSANID=?";
		this.jdbcTemplate.update(query, sanpropbandeja.getBaprNuevoOrganismo(),
				sanpropbandeja.getBaprsanid());
		return sanpropbandeja;
	}
}
