package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Sanplazos;

/**
 * SanplazosDaoImpl  
 *  
 */
 
@Repository
@Transactional
public class SanplazosDaoImpl implements SanplazosDao {
    private JdbcTemplate jdbcTemplate;
	private RowMapper<Sanplazos> rwMap = new RowMapper<Sanplazos>() {
		public Sanplazos mapRow(ResultSet resultSet, int rowNum) throws SQLException {
           return new Sanplazos(
               resultSet.getBigDecimal("COID"), resultSet.getString("CONOMBREES"), resultSet.getString("CONOMBREEU"), resultSet.getBigDecimal("COPLAZO"), resultSet.getString("COTIPOPLAZO"), resultSet.getString("COPRID"), resultSet.getDate("COFECALTA"), resultSet.getDate("COFECMODIF"), resultSet.getString("COUSUALTA"), resultSet.getString("COUSUMODIF")
           ); } } ;

	/**
     * Method use to set the datasource.
     *
     * @param dataSource DataSource
     * @return
     */
    @Resource
    public void setDataSource(DataSource dataSource) {
    	this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    /**
     * Inserts a single row in the Sanplazos table.
     *
     * @param sanplazos Pagination
     * @return Sanplazos
     */
	public Sanplazos add(Sanplazos sanplazos) {
    	String query = "INSERT INTO SANPLAZOS (COID, CONOMBRE_ES, CONOMBRE_EU, COPLAZO, COTIPOPLAZO, COPRID, COFECALTA, COFECMODIF, COUSUALTA, COUSUMODIF) VALUES (?,?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, sanplazos.getCoid(), sanplazos.getConombreEs(), sanplazos.getConombreEu(), sanplazos.getCoplazo(), sanplazos.getCotipoplazo(), sanplazos.getCoprid(), sanplazos.getCofecalta(), sanplazos.getCofecmodif(), sanplazos.getCousualta(), sanplazos.getCousumodif());
		return sanplazos;
	}

    /**
     * Updates a single row in the Sanplazos table.
     *
     * @param sanplazos Pagination
     * @return Sanplazos
     */
    public Sanplazos update(Sanplazos sanplazos) {
		String query = "UPDATE SANPLAZOS SET CONOMBRE_ES=?, CONOMBRE_EU=?, COPLAZO=?, COTIPOPLAZO=?, COPRID=?, COFECALTA=?, COFECMODIF=?, COUSUALTA=?, COUSUMODIF=? WHERE COID=?";
		this.jdbcTemplate.update(query, sanplazos.getConombreEs(), sanplazos.getConombreEu(), sanplazos.getCoplazo(), sanplazos.getCotipoplazo(), sanplazos.getCoprid(), sanplazos.getCofecalta(), sanplazos.getCofecmodif(), sanplazos.getCousualta(), sanplazos.getCousumodif(), sanplazos.getCoid());
		return sanplazos;
	}

    /**
     * Finds a single row in the Sanplazos table.
     *
     * @param sanplazos Pagination
     * @return Sanplazos
     */
    @Transactional (readOnly = true)
    public Sanplazos find(Sanplazos sanplazos) {
		String query = "SELECT t1.COID COID, t1.CONOMBRE_ES CONOMBREES, t1.CONOMBRE_EU CONOMBREEU, t1.COPLAZO COPLAZO, t1.COTIPOPLAZO COTIPOPLAZO, t1.COPRID COPRID, t1.COFECALTA COFECALTA, t1.COFECMODIF COFECMODIF, t1.COUSUALTA COUSUALTA, t1.COUSUMODIF COUSUMODIF FROM SANPLAZOS t1  WHERE t1.COID = ?  ";
		
		List<Sanplazos> sanplazosList = this.jdbcTemplate.query(query, this.rwMap, sanplazos.getCoid());
		return (Sanplazos) DataAccessUtils.uniqueResult(sanplazosList);
    }

    /**
     * Removes a single row in the Sanplazos table.
     *
     * @param sanplazos Pagination
     * @return
     */
    public void remove(Sanplazos sanplazos) {
		String query = "DELETE FROM SANPLAZOS WHERE COID=?";
		this.jdbcTemplate.update(query, sanplazos.getCoid());
    }
    
   /**
    * Finds a List of rows in the Sanplazos table.
    * 
    * @param sanplazos Sanplazos
    * @param pagination Pagination
    * @return List 
    */
	@Transactional (readOnly = true)
    public List<Sanplazos> findAll(Sanplazos sanplazos, Pagination pagination) {
		StringBuilder query = new StringBuilder("SELECT  t1.COID COID,t1.CONOMBRE_ES CONOMBREES,t1.CONOMBRE_EU CONOMBREEU,t1.COPLAZO COPLAZO,t1.COTIPOPLAZO COTIPOPLAZO,t1.COPRID COPRID,t1.COFECALTA COFECALTA,t1.COFECMODIF COFECMODIF,t1.COUSUALTA COUSUALTA,t1.COUSUMODIF COUSUMODIF "); 
		query.append("FROM SANPLAZOS t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(sanplazos); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		
		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		
		return (List<Sanplazos>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}
	
    /**
     * Counts rows in the Sanplazos table.
     * 
     * @param sanplazos Sanplazos
     * @return Long
     */
    @Transactional (readOnly = true)
    public Long findAllCount(Sanplazos sanplazos) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM SANPLAZOS t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(sanplazos); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);		
		
		List<?> params = (List<?>) mapaWhere.get("params");
		
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	
	/**
	 * Finds rows in the Sanplazos table using like.
     * 
     * @param sanplazos Sanplazos
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List 
     */
	@Transactional (readOnly = true)
    public List<Sanplazos> findAllLike(Sanplazos sanplazos, Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT  t1.COID COID,t1.CONOMBRE_ES CONOMBREES,t1.CONOMBRE_EU CONOMBREEU,t1.COPLAZO COPLAZO,t1.COTIPOPLAZO COTIPOPLAZO,t1.COPRID COPRID,t1.COFECALTA COFECALTA,t1.COFECMODIF COFECMODIF,t1.COUSUALTA COUSUALTA,t1.COUSUMODIF COUSUMODIF "); 
        query.append("FROM SANPLAZOS t1 ");
      	
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(sanplazos,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		
		return (List<Sanplazos>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}
	
	/**
	 * Counts rows in the Sanplazos table using like.
     * 
     * @param sanplazos Sanplazos
     * @param startsWith Boolean
     * @return Long 
     */
	@Transactional (readOnly = true)
    public Long findAllLikeCount(Sanplazos sanplazos, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM SANPLAZOS t1 ");

		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(sanplazos,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	
	/**
	 * Returns a map with the needed value to create the conditions to filter by 
	 * the Sanplazos entity 
	 * 
	 * @param sanplazos Sanplazos
	 *            Bean with the criteria values to filter by.
	 * @return Map created with two keys
	 *         key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap (Sanplazos sanplazos){
		
		StringBuilder where = new StringBuilder(SanplazosDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (sanplazos  != null  && sanplazos.getCoid() != null ) {
			where.append(" AND t1.COID = ?");
			params.add(sanplazos.getCoid());
		}
		if (sanplazos  != null  && sanplazos.getConombreEs() != null ) {
			where.append(" AND t1.CONOMBRE_ES = ?");
			params.add(sanplazos.getConombreEs());
		}
		if (sanplazos  != null  && sanplazos.getConombreEu() != null ) {
			where.append(" AND t1.CONOMBRE_EU = ?");
			params.add(sanplazos.getConombreEu());
		}
		if (sanplazos  != null  && sanplazos.getCoplazo() != null ) {
			where.append(" AND t1.COPLAZO = ?");
			params.add(sanplazos.getCoplazo());
		}
		if (sanplazos  != null  && sanplazos.getCotipoplazo() != null ) {
			where.append(" AND t1.COTIPOPLAZO = ?");
			params.add(sanplazos.getCotipoplazo());
		}
		if (sanplazos  != null  && sanplazos.getCoprid() != null ) {
			where.append(" AND t1.COPRID = ?");
			params.add(sanplazos.getCoprid());
		}
		if (sanplazos  != null  && sanplazos.getCofecalta() != null ) {
			where.append(" AND t1.COFECALTA = ?");
			params.add(sanplazos.getCofecalta());
		}
		if (sanplazos  != null  && sanplazos.getCofecmodif() != null ) {
			where.append(" AND t1.COFECMODIF = ?");
			params.add(sanplazos.getCofecmodif());
		}
		if (sanplazos  != null  && sanplazos.getCousualta() != null ) {
			where.append(" AND t1.COUSUALTA = ?");
			params.add(sanplazos.getCousualta());
		}
		if (sanplazos  != null  && sanplazos.getCousumodif() != null ) {
			where.append(" AND t1.COUSUMODIF = ?");
			params.add(sanplazos.getCousumodif());
		}

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		
		return mapWhere;		
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA
	
	/**
	 * Returns a map with the needed value to create the conditions to filter by  
	 * the Sanplazos entity 
	 * 
	 * @param sanplazos Sanplazos
	 *            Bean with the criteria values to filter by.
     * @param startsWith Boolean	 
	 * @return Map created with two keys
	 *         key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap (Sanplazos sanplazos, Boolean startsWith){
		
		StringBuilder where = new StringBuilder(SanplazosDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (sanplazos  != null  && sanplazos.getCoid() != null ) {
			where.append(" AND t1.COID = ?");
			params.add(sanplazos.getCoid());
	     }			
		if (sanplazos  != null  && sanplazos.getConombreEs() != null ) {
			where.append(" AND UPPER(t1.CONOMBRE_ES) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(sanplazos.getConombreEs().toUpperCase() +"%");
			}else{
				params.add("%"+sanplazos.getConombreEs().toUpperCase() +"%");
			}
			where.append(" AND t1.CONOMBRE_ES IS NOT NULL");
	     }			
		if (sanplazos  != null  && sanplazos.getConombreEu() != null ) {
			where.append(" AND UPPER(t1.CONOMBRE_EU) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(sanplazos.getConombreEu().toUpperCase() +"%");
			}else{
				params.add("%"+sanplazos.getConombreEu().toUpperCase() +"%");
			}
			where.append(" AND t1.CONOMBRE_EU IS NOT NULL");
	     }			
		if (sanplazos  != null  && sanplazos.getCoplazo() != null ) {
			where.append(" AND t1.COPLAZO = ?");
			params.add(sanplazos.getCoplazo());
	     }			
		if (sanplazos  != null  && sanplazos.getCotipoplazo() != null ) {
			where.append(" AND UPPER(t1.COTIPOPLAZO) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(sanplazos.getCotipoplazo().toUpperCase() +"%");
			}else{
				params.add("%"+sanplazos.getCotipoplazo().toUpperCase() +"%");
			}
			where.append(" AND t1.COTIPOPLAZO IS NOT NULL");
	     }			
		if (sanplazos  != null  && sanplazos.getCoprid() != null ) {
			where.append(" AND UPPER(t1.COPRID) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(sanplazos.getCoprid().toUpperCase() +"%");
			}else{
				params.add("%"+sanplazos.getCoprid().toUpperCase() +"%");
			}
			where.append(" AND t1.COPRID IS NOT NULL");
	     }			
		if (sanplazos  != null  && sanplazos.getCofecalta() != null ) {
			where.append(" AND t1.COFECALTA = ?");
			params.add(sanplazos.getCofecalta());
	     }			
		if (sanplazos  != null  && sanplazos.getCofecmodif() != null ) {
			where.append(" AND t1.COFECMODIF = ?");
			params.add(sanplazos.getCofecmodif());
	     }			
		if (sanplazos  != null  && sanplazos.getCousualta() != null ) {
			where.append(" AND UPPER(t1.COUSUALTA) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(sanplazos.getCousualta().toUpperCase() +"%");
			}else{
				params.add("%"+sanplazos.getCousualta().toUpperCase() +"%");
			}
			where.append(" AND t1.COUSUALTA IS NOT NULL");
	     }			
		if (sanplazos  != null  && sanplazos.getCousumodif() != null ) {
			where.append(" AND UPPER(t1.COUSUMODIF) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(sanplazos.getCousumodif().toUpperCase() +"%");
			}else{
				params.add("%"+sanplazos.getCousumodif().toUpperCase() +"%");
			}
			where.append(" AND t1.COUSUMODIF IS NOT NULL");
	     }			

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		
		return mapWhere;		
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA
	
	/**
	 * StringBuilder initilization value
	 */
	 public static final int STRING_BUILDER_INIT = 4096;}

