package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.Sanplazos;

/**
 * SanplazosDao  
 *  
 */

public interface SanplazosDao {
    
    /**
     * Inserts a single row in the Sanplazos table.
     *
     * @param sanplazos Sanplazos
     * @return Sanplazos
     */
    Sanplazos add(Sanplazos sanplazos);

    /**
     * Updates a single row in the Sanplazos table.
     *
     * @param sanplazos Sanplazos
     * @return Sanplazos
     */
    Sanplazos update(Sanplazos sanplazos);

    /**
     * Finds a single row in the Sanplazos table.
     *
     * @param sanplazos Sanplazos
     * @return Sanplazos
     */
    Sanplazos find(Sanplazos sanplazos);

    /**
     * Deletes a single row in the Sanplazos table.
     *
     * @param sanplazos Sanplazos
     * @return 
     */
    void remove(Sanplazos sanplazos);

    /**
     * Finds a List of rows in the Sanplazos table.
     *
     * @param sanplazos Sanplazos
     * @param pagination Pagination
     * @return List
     */
    List<Sanplazos> findAll(Sanplazos sanplazos, Pagination pagination);

    /**
     * Counts rows in the Sanplazos table.
     *
     * @param sanplazos Sanplazos
     * @return Long
     */
    Long findAllCount(Sanplazos sanplazos);
	
	/**
     * Finds rows in the Sanplazos table using like.
     *
     * @param sanplazos Sanplazos
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List
     */
	List<Sanplazos> findAllLike(Sanplazos sanplazos, Pagination pagination, Boolean startsWith);
	
    /**
     * Counts rows in the Sanplazos table using like.
     *
     * @param sanplazos Sanplazos
     * @param startsWith Boolean
     * @return Long
     */
    Long findAllLikeCount(Sanplazos sanplazos, Boolean startsWith);
}

