package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Expedien;
import com.ejie.y41b.model.Sanexp;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Saninterviniente;

/**
 * SanintervinienteDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class SanintervinienteDaoImpl implements SanintervinienteDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Saninterviniente> rwMap = new RowMapper<Saninterviniente>() {
		public Saninterviniente mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Saninterviniente(
					resultSet.getBigDecimal("IDINTERVINIENTE"),
					resultSet.getString("NOMBRE"), resultSet.getString("NIF"),
					resultSet.getString("NRTEL"),
					resultSet.getString("NRTEL2"),
					resultSet.getString("NORAPROVINCIAID"),
					resultSet.getString("NORAMUNICIPIOID"),
					resultSet.getString("NOMBREMUNICIPIO"),
					resultSet.getString("NORALOCALIDADID"),
					resultSet.getString("NOMBRELOCALIDAD"),
					resultSet.getString("NORACALLEID"),
					resultSet.getString("NOMBRECALLE"),
					resultSet.getString("NORACPID"),
					resultSet.getString("NOMBRECP"),
					resultSet.getString("NORAPORTALID"),
					resultSet.getString("NOMBREPORTAL"),
					resultSet.getString("NOMBREPISO"),
					resultSet.getString("DIRECCIONNOCAPV"),
					resultSet.getString("DIRECCIONANTIGUA"),
					resultSet.getString("TIPOINTERVINIENTE"),
					resultSet.getString("DTCODIGO"),
					resultSet.getString("ESCODIGO"), new Expedien(
							resultSet.getString("ExpedienEXCODIGO"),
							resultSet.getString("ExpedienEXCOOR"),
							resultSet.getBigDecimal("ExpedienEXNRAN"),
							resultSet.getBigDecimal("ExpedienEXNROR"),
							resultSet.getDate("ExpedienEXFERE"),
							resultSet.getString("ExpedienEXCOIT"),
							resultSet.getString("ExpedienEXCOES"),
							resultSet.getDate("ExpedienEXFEACIN"),
							resultSet.getDate("ExpedienEXFEEMCA"),
							resultSet.getDate("ExpedienEXFEPLCA"),
							resultSet.getDate("ExpedienEXFPNOPC"),
							resultSet.getDate("ExpedienEXFEDE"),
							resultSet.getDate("ExpedienEXFECOAL"),
							resultSet.getDate("ExpedienEXFENOPR"),
							resultSet.getDate("ExpedienEXFEPUPR"),
							resultSet.getString("ExpedienEXCOOSPR"),
							resultSet.getDate("ExpedienEXFEALPR"),
							resultSet.getDate("ExpedienEXFEEL"),
							resultSet.getDate("ExpedienEXFERES"),
							resultSet.getDate("ExpedienEXFENORE"),
							resultSet.getDate("ExpedienEXFEPURE"),
							resultSet.getString("ExpedienEXCOOSRE"),
							resultSet.getString("ExpedienEXCOTTR"),
							resultSet.getBigDecimal("ExpedienEXCAMURE"),
							resultSet.getDate("ExpedienEXFETA"),
							resultSet.getString("ExpedienEXCOTSA"),
							resultSet.getDate("ExpedienEXFECROI"),
							resultSet.getDate("ExpedienEXFEAR"),
							resultSet.getString("ExpedienEXCOORIE"),
							resultSet.getString("ExpedienEXINRE"),
							resultSet.getString("ExpedienEXINCOCO"),
							resultSet.getString("ExpedienEXINEXVA"),
							resultSet.getDate("ExpedienEXFECIRC"),
							resultSet.getDate("ExpedienEXFENOAI"),
							resultSet.getDate("ExpedienEXFECOLM"),
							resultSet.getString("ExpedienEXNUINLM"),
							resultSet.getDate("ExpedienEXFEINMU"),
							resultSet.getDate("ExpedienEXFEAVMU"),
							resultSet.getDate("ExpedienEXFEIMCD"),
							resultSet.getDate("ExpedienEXFECEDE"),
							resultSet.getString("ExpedienEXCOPS"),
							resultSet.getString("ExpedienEXCOSE"), new Sanexp(
									resultSet.getString("ExpedienEXCODIGO")),
							null, null, null));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Saninterviniente table.
	 * 
	 * @param saninterviniente
	 *            Pagination
	 * @return Saninterviniente
	 */
	public Saninterviniente add(Saninterviniente saninterviniente) {
		String query = "INSERT INTO SANINTERVINIENTE (IDINTERVINIENTE, EXCODIGO, NOMBRE, NIF, NRTEL, NRTEL2, NORA_PROVINCIA_ID, NORA_MUNICIPIO_ID, NOMBRE_MUNICIPIO, NORA_LOCALIDAD_ID, NOMBRE_LOCALIDAD, NORA_CALLE_ID, NOMBRE_CALLE, NORA_CP_ID, NOMBRE_CP, NORA_PORTAL_ID, NOMBRE_PORTAL, NOMBRE_PISO, DIRECCION_NOCAPV, DIRECCION_ANTIGUA, TIPO_INTERVINIENTE, DTCODIGO, ESCODIGO) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		Object getExpedienExcodigoAux = null;
		if (saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExcodigo() != null) {
			getExpedienExcodigoAux = saninterviniente.getExpedien()
					.getExcodigo();
		}
		this.jdbcTemplate.update(query, saninterviniente.getIdinterviniente(),
				getExpedienExcodigoAux, saninterviniente.getNombre(),
				saninterviniente.getNif(), saninterviniente.getNrtel(),
				saninterviniente.getNrtel2(),
				saninterviniente.getNoraProvinciaId(),
				saninterviniente.getNoraMunicipioId(),
				saninterviniente.getNombreMunicipio(),
				saninterviniente.getNoraLocalidadId(),
				saninterviniente.getNombreLocalidad(),
				saninterviniente.getNoraCalleId(),
				saninterviniente.getNombreCalle(),
				saninterviniente.getNoraCpId(), saninterviniente.getNombreCp(),
				saninterviniente.getNoraPortalId(),
				saninterviniente.getNombrePortal(),
				saninterviniente.getNombrePiso(),
				saninterviniente.getDireccionNocapv(),
				saninterviniente.getDireccionAntigua(),
				saninterviniente.getTipoInterviniente(),
				saninterviniente.getDtcodigo(), saninterviniente.getEscodigo());
		return saninterviniente;
	}

	/**
	 * Updates a single row in the Saninterviniente table.
	 * 
	 * @param saninterviniente
	 *            Pagination
	 * @return Saninterviniente
	 */
	public Saninterviniente update(Saninterviniente saninterviniente) {
		String query = "UPDATE SANINTERVINIENTE SET EXCODIGO=?, NOMBRE=?, NIF=?, NRTEL=?, NRTEL2=?, NORA_PROVINCIA_ID=?, NORA_MUNICIPIO_ID=?, NOMBRE_MUNICIPIO=?, NORA_LOCALIDAD_ID=?, NOMBRE_LOCALIDAD=?, NORA_CALLE_ID=?, NOMBRE_CALLE=?, NORA_CP_ID=?, NOMBRE_CP=?, NORA_PORTAL_ID=?, NOMBRE_PORTAL=?, NOMBRE_PISO=?, DIRECCION_NOCAPV=?, DIRECCION_ANTIGUA=?, TIPO_INTERVINIENTE=?, DTCODIGO=?, ESCODIGO=? WHERE IDINTERVINIENTE=?";
		Object getExpedienExcodigoAux = null;
		if (saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExcodigo() != null) {
			getExpedienExcodigoAux = saninterviniente.getExpedien()
					.getExcodigo();
		}
		this.jdbcTemplate.update(query, getExpedienExcodigoAux,
				saninterviniente.getNombre(), saninterviniente.getNif(),
				saninterviniente.getNrtel(), saninterviniente.getNrtel2(),
				saninterviniente.getNoraProvinciaId(),
				saninterviniente.getNoraMunicipioId(),
				saninterviniente.getNombreMunicipio(),
				saninterviniente.getNoraLocalidadId(),
				saninterviniente.getNombreLocalidad(),
				saninterviniente.getNoraCalleId(),
				saninterviniente.getNombreCalle(),
				saninterviniente.getNoraCpId(), saninterviniente.getNombreCp(),
				saninterviniente.getNoraPortalId(),
				saninterviniente.getNombrePortal(),
				saninterviniente.getNombrePiso(),
				saninterviniente.getDireccionNocapv(),
				saninterviniente.getDireccionAntigua(),
				saninterviniente.getTipoInterviniente(),
				saninterviniente.getDtcodigo(), saninterviniente.getEscodigo(),
				saninterviniente.getIdinterviniente());
		return saninterviniente;
	}

	/**
	 * Finds a single row in the Saninterviniente table.
	 * 
	 * @param saninterviniente
	 *            Pagination
	 * @return Saninterviniente
	 */
	@Transactional(readOnly = true)
	public Saninterviniente find(Saninterviniente saninterviniente) {
		String query = "SELECT t1.IDINTERVINIENTE IDINTERVINIENTE, t1.NOMBRE NOMBRE, t1.NIF NIF, t1.NRTEL NRTEL, t1.NRTEL2 NRTEL2, t1.NORA_PROVINCIA_ID NORAPROVINCIAID, t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID, t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO, t1.NORA_LOCALIDAD_ID NORALOCALIDADID, t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD, t1.NORA_CALLE_ID NORACALLEID, t1.NOMBRE_CALLE NOMBRECALLE, t1.NORA_CP_ID NORACPID, t1.NOMBRE_CP NOMBRECP, t1.NORA_PORTAL_ID NORAPORTALID, t1.NOMBRE_PORTAL NOMBREPORTAL, t1.NOMBRE_PISO NOMBREPISO, t1.DIRECCION_NOCAPV DIRECCIONNOCAPV, t1.DIRECCION_ANTIGUA DIRECCIONANTIGUA, t1.TIPO_INTERVINIENTE TIPOINTERVINIENTE, t1.DTCODIGO DTCODIGO, t1.ESCODIGO ESCODIGO, t2.EXCODIGO EXPEDIENEXCODIGO, t2.EXCOOR EXPEDIENEXCOOR, t2.EXNRAN EXPEDIENEXNRAN, t2.EXNROR EXPEDIENEXNROR, t2.EXFERE EXPEDIENEXFERE, t2.EXCOIT EXPEDIENEXCOIT, t2.EXCOES EXPEDIENEXCOES, t2.EXFEACIN EXPEDIENEXFEACIN, t2.EXFEEMCA EXPEDIENEXFEEMCA, t2.EXFEPLCA EXPEDIENEXFEPLCA, t2.EXFPNOPC EXPEDIENEXFPNOPC, t2.EXFEDE EXPEDIENEXFEDE, t2.EXFECOAL EXPEDIENEXFECOAL, t2.EXFENOPR EXPEDIENEXFENOPR, t2.EXFEPUPR EXPEDIENEXFEPUPR, t2.EXCOOSPR EXPEDIENEXCOOSPR, t2.EXFEALPR EXPEDIENEXFEALPR, t2.EXFEEL EXPEDIENEXFEEL, t2.EXFERES EXPEDIENEXFERES, t2.EXFENORE EXPEDIENEXFENORE, t2.EXFEPURE EXPEDIENEXFEPURE, t2.EXCOOSRE EXPEDIENEXCOOSRE, t2.EXCOTTR EXPEDIENEXCOTTR, t2.EXCAMURE EXPEDIENEXCAMURE, t2.EXFETA EXPEDIENEXFETA, t2.EXCOTSA EXPEDIENEXCOTSA, t2.EXFECROI EXPEDIENEXFECROI, t2.EXFEAR EXPEDIENEXFEAR, t2.EXCOORIE EXPEDIENEXCOORIE, t2.EXINRE EXPEDIENEXINRE, t2.EXINCOCO EXPEDIENEXINCOCO, t2.EXINEXVA EXPEDIENEXINEXVA, t2.EXFECIRC EXPEDIENEXFECIRC, t2.EXFENOAI EXPEDIENEXFENOAI, t2.EXFECOLM EXPEDIENEXFECOLM, t2.EXNUINLM EXPEDIENEXNUINLM, t2.EXFEINMU EXPEDIENEXFEINMU, t2.EXFEAVMU EXPEDIENEXFEAVMU, t2.EXFEIMCD EXPEDIENEXFEIMCD, t2.EXFECEDE EXPEDIENEXFECEDE, t2.EXCOPS EXPEDIENEXCOPS, t2.EXCOSE EXPEDIENEXCOSE "
				+ " FROM SANINTERVINIENTE t1 , EXPEDIEN t2 "
				+ " WHERE t1.IDINTERVINIENTE = ? AND t1.EXCODIGO= t2.EXCODIGO(+)";

		List<Saninterviniente> sanintervinienteList = this.jdbcTemplate.query(
				query, this.rwMap, saninterviniente.getIdinterviniente());
		return (Saninterviniente) DataAccessUtils
				.uniqueResult(sanintervinienteList);
	}

	/**
	 * Removes a single row in the Saninterviniente table.
	 * 
	 * @param saninterviniente
	 *            Pagination
	 * @return
	 */
	public void remove(Saninterviniente saninterviniente) {
		String query = "DELETE FROM SANINTERVINIENTE WHERE IDINTERVINIENTE=?";
		this.jdbcTemplate.update(query, saninterviniente.getIdinterviniente());
	}

	/**
	 * Finds a List of rows in the Saninterviniente table.
	 * 
	 * @param saninterviniente
	 *            Saninterviniente
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Saninterviniente> findAll(Saninterviniente saninterviniente,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDINTERVINIENTE IDINTERVINIENTE,t1.NOMBRE NOMBRE,t1.NIF NIF,t1.NRTEL NRTEL,t1.NRTEL2 NRTEL2,t1.NORA_PROVINCIA_ID NORAPROVINCIAID,t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID,t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO,t1.NORA_LOCALIDAD_ID NORALOCALIDADID,t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD,t1.NORA_CALLE_ID NORACALLEID,t1.NOMBRE_CALLE NOMBRECALLE,t1.NORA_CP_ID NORACPID,t1.NOMBRE_CP NOMBRECP,t1.NORA_PORTAL_ID NORAPORTALID,t1.NOMBRE_PORTAL NOMBREPORTAL,t1.NOMBRE_PISO NOMBREPISO,t1.DIRECCION_NOCAPV DIRECCIONNOCAPV,t1.DIRECCION_ANTIGUA DIRECCIONANTIGUA,t1.TIPO_INTERVINIENTE TIPOINTERVINIENTE,t1.DTCODIGO DTCODIGO,t1.ESCODIGO ESCODIGO,t2.EXCODIGO EXPEDIENEXCODIGO,t2.EXCOOR EXPEDIENEXCOOR,t2.EXNRAN EXPEDIENEXNRAN,t2.EXNROR EXPEDIENEXNROR,t2.EXFERE EXPEDIENEXFERE,t2.EXCOIT EXPEDIENEXCOIT,t2.EXCOES EXPEDIENEXCOES,t2.EXFEACIN EXPEDIENEXFEACIN,t2.EXFEEMCA EXPEDIENEXFEEMCA,t2.EXFEPLCA EXPEDIENEXFEPLCA,t2.EXFPNOPC EXPEDIENEXFPNOPC,t2.EXFEDE EXPEDIENEXFEDE,t2.EXFECOAL EXPEDIENEXFECOAL,t2.EXFENOPR EXPEDIENEXFENOPR,t2.EXFEPUPR EXPEDIENEXFEPUPR,t2.EXCOOSPR EXPEDIENEXCOOSPR,t2.EXFEALPR EXPEDIENEXFEALPR,t2.EXFEEL EXPEDIENEXFEEL,t2.EXFERES EXPEDIENEXFERES,t2.EXFENORE EXPEDIENEXFENORE,t2.EXFEPURE EXPEDIENEXFEPURE,t2.EXCOOSRE EXPEDIENEXCOOSRE,t2.EXCOTTR EXPEDIENEXCOTTR,t2.EXCAMURE EXPEDIENEXCAMURE,t2.EXFETA EXPEDIENEXFETA,t2.EXCOTSA EXPEDIENEXCOTSA,t2.EXFECROI EXPEDIENEXFECROI,t2.EXFEAR EXPEDIENEXFEAR,t2.EXCOORIE EXPEDIENEXCOORIE,t2.EXINRE EXPEDIENEXINRE,t2.EXINCOCO EXPEDIENEXINCOCO,t2.EXINEXVA EXPEDIENEXINEXVA,t2.EXFECIRC EXPEDIENEXFECIRC,t2.EXFENOAI EXPEDIENEXFENOAI,t2.EXFECOLM EXPEDIENEXFECOLM,t2.EXNUINLM EXPEDIENEXNUINLM,t2.EXFEINMU EXPEDIENEXFEINMU,t2.EXFEAVMU EXPEDIENEXFEAVMU,t2.EXFEIMCD EXPEDIENEXFEIMCD,t2.EXFECEDE EXPEDIENEXFECEDE,t2.EXCOPS EXPEDIENEXCOPS,t2.EXCOSE EXPEDIENEXCOSE ");
		query.append("FROM SANINTERVINIENTE t1 ,EXPEDIEN t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(saninterviniente);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.EXCODIGO= t2.EXCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Saninterviniente>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Saninterviniente table.
	 * 
	 * @param saninterviniente
	 *            Saninterviniente
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Saninterviniente saninterviniente) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM SANINTERVINIENTE t1 , EXPEDIEN t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(saninterviniente);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.EXCODIGO= t2.EXCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Saninterviniente table using like.
	 * 
	 * @param saninterviniente
	 *            Saninterviniente
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Saninterviniente> findAllLike(
			Saninterviniente saninterviniente, Pagination pagination,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDINTERVINIENTE IDINTERVINIENTE,t1.NOMBRE NOMBRE,t1.NIF NIF,t1.NRTEL NRTEL,t1.NRTEL2 NRTEL2,t1.NORA_PROVINCIA_ID NORAPROVINCIAID,t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID,t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO,t1.NORA_LOCALIDAD_ID NORALOCALIDADID,t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD,t1.NORA_CALLE_ID NORACALLEID,t1.NOMBRE_CALLE NOMBRECALLE,t1.NORA_CP_ID NORACPID,t1.NOMBRE_CP NOMBRECP,t1.NORA_PORTAL_ID NORAPORTALID,t1.NOMBRE_PORTAL NOMBREPORTAL,t1.NOMBRE_PISO NOMBREPISO,t1.DIRECCION_NOCAPV DIRECCIONNOCAPV,t1.DIRECCION_ANTIGUA DIRECCIONANTIGUA,t1.TIPO_INTERVINIENTE TIPOINTERVINIENTE,t1.DTCODIGO DTCODIGO,t1.ESCODIGO ESCODIGO,t2.EXCODIGO EXPEDIENEXCODIGO,t2.EXCOOR EXPEDIENEXCOOR,t2.EXNRAN EXPEDIENEXNRAN,t2.EXNROR EXPEDIENEXNROR,t2.EXFERE EXPEDIENEXFERE,t2.EXCOIT EXPEDIENEXCOIT,t2.EXCOES EXPEDIENEXCOES,t2.EXFEACIN EXPEDIENEXFEACIN,t2.EXFEEMCA EXPEDIENEXFEEMCA,t2.EXFEPLCA EXPEDIENEXFEPLCA,t2.EXFPNOPC EXPEDIENEXFPNOPC,t2.EXFEDE EXPEDIENEXFEDE,t2.EXFECOAL EXPEDIENEXFECOAL,t2.EXFENOPR EXPEDIENEXFENOPR,t2.EXFEPUPR EXPEDIENEXFEPUPR,t2.EXCOOSPR EXPEDIENEXCOOSPR,t2.EXFEALPR EXPEDIENEXFEALPR,t2.EXFEEL EXPEDIENEXFEEL,t2.EXFERES EXPEDIENEXFERES,t2.EXFENORE EXPEDIENEXFENORE,t2.EXFEPURE EXPEDIENEXFEPURE,t2.EXCOOSRE EXPEDIENEXCOOSRE,t2.EXCOTTR EXPEDIENEXCOTTR,t2.EXCAMURE EXPEDIENEXCAMURE,t2.EXFETA EXPEDIENEXFETA,t2.EXCOTSA EXPEDIENEXCOTSA,t2.EXFECROI EXPEDIENEXFECROI,t2.EXFEAR EXPEDIENEXFEAR,t2.EXCOORIE EXPEDIENEXCOORIE,t2.EXINRE EXPEDIENEXINRE,t2.EXINCOCO EXPEDIENEXINCOCO,t2.EXINEXVA EXPEDIENEXINEXVA,t2.EXFECIRC EXPEDIENEXFECIRC,t2.EXFENOAI EXPEDIENEXFENOAI,t2.EXFECOLM EXPEDIENEXFECOLM,t2.EXNUINLM EXPEDIENEXNUINLM,t2.EXFEINMU EXPEDIENEXFEINMU,t2.EXFEAVMU EXPEDIENEXFEAVMU,t2.EXFEIMCD EXPEDIENEXFEIMCD,t2.EXFECEDE EXPEDIENEXFECEDE,t2.EXCOPS EXPEDIENEXCOPS,t2.EXCOSE EXPEDIENEXCOSE ");
		query.append("FROM SANINTERVINIENTE t1 ,EXPEDIEN t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(saninterviniente,
				startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.EXCODIGO= t2.EXCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Saninterviniente>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Saninterviniente table using like.
	 * 
	 * @param saninterviniente
	 *            Saninterviniente
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Saninterviniente saninterviniente,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM SANINTERVINIENTE t1 ,EXPEDIEN t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(saninterviniente,
				startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.EXCODIGO= t2.EXCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Saninterviniente entity
	 * 
	 * @param saninterviniente
	 *            Saninterviniente Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Saninterviniente saninterviniente) {

		StringBuilder where = new StringBuilder(
				SanintervinienteDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (saninterviniente != null
				&& saninterviniente.getIdinterviniente() != null) {
			where.append(" AND t1.IDINTERVINIENTE = ?");
			params.add(saninterviniente.getIdinterviniente());
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExcodigo() != null) {
			where.append(" AND t2.EXCODIGO = ?");
			params.add(saninterviniente.getExpedien().getExcodigo());
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExcoor() != null) {
			where.append(" AND t2.EXCOOR = ?");
			params.add(saninterviniente.getExpedien().getExcoor());
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExnran() != null) {
			where.append(" AND t2.EXNRAN = ?");
			params.add(saninterviniente.getExpedien().getExnran());
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExnror() != null) {
			where.append(" AND t2.EXNROR = ?");
			params.add(saninterviniente.getExpedien().getExnror());
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExfere() != null) {
			where.append(" AND t2.EXFERE = ?");
			params.add(saninterviniente.getExpedien().getExfere());
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExcoit() != null) {
			where.append(" AND t2.EXCOIT = ?");
			params.add(saninterviniente.getExpedien().getExcoit());
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExcoes() != null) {
			where.append(" AND t2.EXCOES = ?");
			params.add(saninterviniente.getExpedien().getExcoes());
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExfeacin() != null) {
			where.append(" AND t2.EXFEACIN = ?");
			params.add(saninterviniente.getExpedien().getExfeacin());
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExfeemca() != null) {
			where.append(" AND t2.EXFEEMCA = ?");
			params.add(saninterviniente.getExpedien().getExfeemca());
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExfeplca() != null) {
			where.append(" AND t2.EXFEPLCA = ?");
			params.add(saninterviniente.getExpedien().getExfeplca());
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExfpnopc() != null) {
			where.append(" AND t2.EXFPNOPC = ?");
			params.add(saninterviniente.getExpedien().getExfpnopc());
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExfede() != null) {
			where.append(" AND t2.EXFEDE = ?");
			params.add(saninterviniente.getExpedien().getExfede());
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExfecoal() != null) {
			where.append(" AND t2.EXFECOAL = ?");
			params.add(saninterviniente.getExpedien().getExfecoal());
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExfenopr() != null) {
			where.append(" AND t2.EXFENOPR = ?");
			params.add(saninterviniente.getExpedien().getExfenopr());
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExfepupr() != null) {
			where.append(" AND t2.EXFEPUPR = ?");
			params.add(saninterviniente.getExpedien().getExfepupr());
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExcoospr() != null) {
			where.append(" AND t2.EXCOOSPR = ?");
			params.add(saninterviniente.getExpedien().getExcoospr());
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExfealpr() != null) {
			where.append(" AND t2.EXFEALPR = ?");
			params.add(saninterviniente.getExpedien().getExfealpr());
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExfeel() != null) {
			where.append(" AND t2.EXFEEL = ?");
			params.add(saninterviniente.getExpedien().getExfeel());
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExferes() != null) {
			where.append(" AND t2.EXFERES = ?");
			params.add(saninterviniente.getExpedien().getExferes());
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExfenore() != null) {
			where.append(" AND t2.EXFENORE = ?");
			params.add(saninterviniente.getExpedien().getExfenore());
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExfepure() != null) {
			where.append(" AND t2.EXFEPURE = ?");
			params.add(saninterviniente.getExpedien().getExfepure());
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExcoosre() != null) {
			where.append(" AND t2.EXCOOSRE = ?");
			params.add(saninterviniente.getExpedien().getExcoosre());
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExcottr() != null) {
			where.append(" AND t2.EXCOTTR = ?");
			params.add(saninterviniente.getExpedien().getExcottr());
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExcamure() != null) {
			where.append(" AND t2.EXCAMURE = ?");
			params.add(saninterviniente.getExpedien().getExcamure());
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExfeta() != null) {
			where.append(" AND t2.EXFETA = ?");
			params.add(saninterviniente.getExpedien().getExfeta());
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExcotsa() != null) {
			where.append(" AND t2.EXCOTSA = ?");
			params.add(saninterviniente.getExpedien().getExcotsa());
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExfecroi() != null) {
			where.append(" AND t2.EXFECROI = ?");
			params.add(saninterviniente.getExpedien().getExfecroi());
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExfear() != null) {
			where.append(" AND t2.EXFEAR = ?");
			params.add(saninterviniente.getExpedien().getExfear());
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExcoorie() != null) {
			where.append(" AND t2.EXCOORIE = ?");
			params.add(saninterviniente.getExpedien().getExcoorie());
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExinre() != null) {
			where.append(" AND t2.EXINRE = ?");
			params.add(saninterviniente.getExpedien().getExinre());
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExincoco() != null) {
			where.append(" AND t2.EXINCOCO = ?");
			params.add(saninterviniente.getExpedien().getExincoco());
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExinexva() != null) {
			where.append(" AND t2.EXINEXVA = ?");
			params.add(saninterviniente.getExpedien().getExinexva());
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExfecirc() != null) {
			where.append(" AND t2.EXFECIRC = ?");
			params.add(saninterviniente.getExpedien().getExfecirc());
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExfenoai() != null) {
			where.append(" AND t2.EXFENOAI = ?");
			params.add(saninterviniente.getExpedien().getExfenoai());
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExfecolm() != null) {
			where.append(" AND t2.EXFECOLM = ?");
			params.add(saninterviniente.getExpedien().getExfecolm());
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExnuinlm() != null) {
			where.append(" AND t2.EXNUINLM = ?");
			params.add(saninterviniente.getExpedien().getExnuinlm());
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExfeinmu() != null) {
			where.append(" AND t2.EXFEINMU = ?");
			params.add(saninterviniente.getExpedien().getExfeinmu());
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExfeavmu() != null) {
			where.append(" AND t2.EXFEAVMU = ?");
			params.add(saninterviniente.getExpedien().getExfeavmu());
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExfeimcd() != null) {
			where.append(" AND t2.EXFEIMCD = ?");
			params.add(saninterviniente.getExpedien().getExfeimcd());
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExfecede() != null) {
			where.append(" AND t2.EXFECEDE = ?");
			params.add(saninterviniente.getExpedien().getExfecede());
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExcops() != null) {
			where.append(" AND t2.EXCOPS = ?");
			params.add(saninterviniente.getExpedien().getExcops());
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExcose() != null) {
			where.append(" AND t2.EXCOSE = ?");
			params.add(saninterviniente.getExpedien().getExcose());
		}
		if (saninterviniente != null
				&& saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getSanexp() != null
				&& saninterviniente.getExpedien().getSanexp().getExcodigo() != null) {
			where.append(" AND t2.EXCODIGO = ?");
			params.add(saninterviniente.getExpedien().getSanexp().getExcodigo());
		}
		if (saninterviniente != null && saninterviniente.getNombre() != null) {
			where.append(" AND t1.NOMBRE = ?");
			params.add(saninterviniente.getNombre());
		}
		if (saninterviniente != null && saninterviniente.getNif() != null) {
			where.append(" AND t1.NIF = ?");
			params.add(saninterviniente.getNif());
		}
		if (saninterviniente != null && saninterviniente.getNrtel() != null) {
			where.append(" AND t1.NRTEL = ?");
			params.add(saninterviniente.getNrtel());
		}
		if (saninterviniente != null && saninterviniente.getNrtel2() != null) {
			where.append(" AND t1.NRTEL2 = ?");
			params.add(saninterviniente.getNrtel2());
		}
		if (saninterviniente != null
				&& saninterviniente.getNoraProvinciaId() != null) {
			where.append(" AND t1.NORA_PROVINCIA_ID = ?");
			params.add(saninterviniente.getNoraProvinciaId());
		}
		if (saninterviniente != null
				&& saninterviniente.getNoraMunicipioId() != null) {
			where.append(" AND t1.NORA_MUNICIPIO_ID = ?");
			params.add(saninterviniente.getNoraMunicipioId());
		}
		if (saninterviniente != null
				&& saninterviniente.getNombreMunicipio() != null) {
			where.append(" AND t1.NOMBRE_MUNICIPIO = ?");
			params.add(saninterviniente.getNombreMunicipio());
		}
		if (saninterviniente != null
				&& saninterviniente.getNoraLocalidadId() != null) {
			where.append(" AND t1.NORA_LOCALIDAD_ID = ?");
			params.add(saninterviniente.getNoraLocalidadId());
		}
		if (saninterviniente != null
				&& saninterviniente.getNombreLocalidad() != null) {
			where.append(" AND t1.NOMBRE_LOCALIDAD = ?");
			params.add(saninterviniente.getNombreLocalidad());
		}
		if (saninterviniente != null
				&& saninterviniente.getNoraCalleId() != null) {
			where.append(" AND t1.NORA_CALLE_ID = ?");
			params.add(saninterviniente.getNoraCalleId());
		}
		if (saninterviniente != null
				&& saninterviniente.getNombreCalle() != null) {
			where.append(" AND t1.NOMBRE_CALLE = ?");
			params.add(saninterviniente.getNombreCalle());
		}
		if (saninterviniente != null && saninterviniente.getNoraCpId() != null) {
			where.append(" AND t1.NORA_CP_ID = ?");
			params.add(saninterviniente.getNoraCpId());
		}
		if (saninterviniente != null && saninterviniente.getNombreCp() != null) {
			where.append(" AND t1.NOMBRE_CP = ?");
			params.add(saninterviniente.getNombreCp());
		}
		if (saninterviniente != null
				&& saninterviniente.getNoraPortalId() != null) {
			where.append(" AND t1.NORA_PORTAL_ID = ?");
			params.add(saninterviniente.getNoraPortalId());
		}
		if (saninterviniente != null
				&& saninterviniente.getNombrePortal() != null) {
			where.append(" AND t1.NOMBRE_PORTAL = ?");
			params.add(saninterviniente.getNombrePortal());
		}
		if (saninterviniente != null
				&& saninterviniente.getNombrePiso() != null) {
			where.append(" AND t1.NOMBRE_PISO = ?");
			params.add(saninterviniente.getNombrePiso());
		}
		if (saninterviniente != null
				&& saninterviniente.getDireccionNocapv() != null) {
			where.append(" AND t1.DIRECCION_NOCAPV = ?");
			params.add(saninterviniente.getDireccionNocapv());
		}
		if (saninterviniente != null
				&& saninterviniente.getDireccionAntigua() != null) {
			where.append(" AND t1.DIRECCION_ANTIGUA = ?");
			params.add(saninterviniente.getDireccionAntigua());
		}
		if (saninterviniente != null
				&& saninterviniente.getTipoInterviniente() != null) {
			where.append(" AND t1.TIPO_INTERVINIENTE = ?");
			params.add(saninterviniente.getTipoInterviniente());
		}
		if (saninterviniente != null && saninterviniente.getDtcodigo() != null) {
			where.append(" AND t1.DTCODIGO = ?");
			params.add(saninterviniente.getDtcodigo());
		}
		if (saninterviniente != null && saninterviniente.getEscodigo() != null) {
			where.append(" AND t1.ESCODIGO = ?");
			params.add(saninterviniente.getEscodigo());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Saninterviniente entity
	 * 
	 * @param saninterviniente
	 *            Saninterviniente Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Saninterviniente saninterviniente,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				SanintervinienteDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (saninterviniente != null
				&& saninterviniente.getIdinterviniente() != null) {
			where.append(" AND t1.IDINTERVINIENTE = ?");
			params.add(saninterviniente.getIdinterviniente());
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExcodigo() != null) {
			where.append(" AND t2.EXCODIGO = ?");
			params.add(saninterviniente.getExpedien().getExcodigo());
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExcoor() != null) {
			where.append(" AND UPPER(t2.EXCOOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(saninterviniente.getExpedien().getExcoor()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ saninterviniente.getExpedien().getExcoor()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.EXCOOR IS NOT NULL");
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExnran() != null) {
			where.append(" AND t2.EXNRAN = ?");
			params.add(saninterviniente.getExpedien().getExnran());
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExnror() != null) {
			where.append(" AND t2.EXNROR = ?");
			params.add(saninterviniente.getExpedien().getExnror());
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExfere() != null) {
			where.append(" AND t2.EXFERE = ?");
			params.add(saninterviniente.getExpedien().getExfere());
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExcoit() != null) {
			where.append(" AND UPPER(t2.EXCOIT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(saninterviniente.getExpedien().getExcoit()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ saninterviniente.getExpedien().getExcoit()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.EXCOIT IS NOT NULL");
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExcoes() != null) {
			where.append(" AND UPPER(t2.EXCOES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(saninterviniente.getExpedien().getExcoes()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ saninterviniente.getExpedien().getExcoes()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.EXCOES IS NOT NULL");
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExfeacin() != null) {
			where.append(" AND t2.EXFEACIN = ?");
			params.add(saninterviniente.getExpedien().getExfeacin());
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExfeemca() != null) {
			where.append(" AND t2.EXFEEMCA = ?");
			params.add(saninterviniente.getExpedien().getExfeemca());
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExfeplca() != null) {
			where.append(" AND t2.EXFEPLCA = ?");
			params.add(saninterviniente.getExpedien().getExfeplca());
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExfpnopc() != null) {
			where.append(" AND t2.EXFPNOPC = ?");
			params.add(saninterviniente.getExpedien().getExfpnopc());
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExfede() != null) {
			where.append(" AND t2.EXFEDE = ?");
			params.add(saninterviniente.getExpedien().getExfede());
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExfecoal() != null) {
			where.append(" AND t2.EXFECOAL = ?");
			params.add(saninterviniente.getExpedien().getExfecoal());
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExfenopr() != null) {
			where.append(" AND t2.EXFENOPR = ?");
			params.add(saninterviniente.getExpedien().getExfenopr());
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExfepupr() != null) {
			where.append(" AND t2.EXFEPUPR = ?");
			params.add(saninterviniente.getExpedien().getExfepupr());
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExcoospr() != null) {
			where.append(" AND UPPER(t2.EXCOOSPR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(saninterviniente.getExpedien().getExcoospr()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ saninterviniente.getExpedien().getExcoospr()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.EXCOOSPR IS NOT NULL");
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExfealpr() != null) {
			where.append(" AND t2.EXFEALPR = ?");
			params.add(saninterviniente.getExpedien().getExfealpr());
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExfeel() != null) {
			where.append(" AND t2.EXFEEL = ?");
			params.add(saninterviniente.getExpedien().getExfeel());
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExferes() != null) {
			where.append(" AND t2.EXFERES = ?");
			params.add(saninterviniente.getExpedien().getExferes());
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExfenore() != null) {
			where.append(" AND t2.EXFENORE = ?");
			params.add(saninterviniente.getExpedien().getExfenore());
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExfepure() != null) {
			where.append(" AND t2.EXFEPURE = ?");
			params.add(saninterviniente.getExpedien().getExfepure());
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExcoosre() != null) {
			where.append(" AND UPPER(t2.EXCOOSRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(saninterviniente.getExpedien().getExcoosre()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ saninterviniente.getExpedien().getExcoosre()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.EXCOOSRE IS NOT NULL");
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExcottr() != null) {
			where.append(" AND UPPER(t2.EXCOTTR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(saninterviniente.getExpedien().getExcottr()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ saninterviniente.getExpedien().getExcottr()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.EXCOTTR IS NOT NULL");
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExcamure() != null) {
			where.append(" AND t2.EXCAMURE = ?");
			params.add(saninterviniente.getExpedien().getExcamure());
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExfeta() != null) {
			where.append(" AND t2.EXFETA = ?");
			params.add(saninterviniente.getExpedien().getExfeta());
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExcotsa() != null) {
			where.append(" AND UPPER(t2.EXCOTSA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(saninterviniente.getExpedien().getExcotsa()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ saninterviniente.getExpedien().getExcotsa()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.EXCOTSA IS NOT NULL");
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExfecroi() != null) {
			where.append(" AND t2.EXFECROI = ?");
			params.add(saninterviniente.getExpedien().getExfecroi());
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExfear() != null) {
			where.append(" AND t2.EXFEAR = ?");
			params.add(saninterviniente.getExpedien().getExfear());
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExcoorie() != null) {
			where.append(" AND UPPER(t2.EXCOORIE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(saninterviniente.getExpedien().getExcoorie()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ saninterviniente.getExpedien().getExcoorie()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.EXCOORIE IS NOT NULL");
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExinre() != null) {
			where.append(" AND UPPER(t2.EXINRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(saninterviniente.getExpedien().getExinre()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ saninterviniente.getExpedien().getExinre()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.EXINRE IS NOT NULL");
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExincoco() != null) {
			where.append(" AND UPPER(t2.EXINCOCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(saninterviniente.getExpedien().getExincoco()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ saninterviniente.getExpedien().getExincoco()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.EXINCOCO IS NOT NULL");
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExinexva() != null) {
			where.append(" AND UPPER(t2.EXINEXVA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(saninterviniente.getExpedien().getExinexva()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ saninterviniente.getExpedien().getExinexva()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.EXINEXVA IS NOT NULL");
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExfecirc() != null) {
			where.append(" AND t2.EXFECIRC = ?");
			params.add(saninterviniente.getExpedien().getExfecirc());
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExfenoai() != null) {
			where.append(" AND t2.EXFENOAI = ?");
			params.add(saninterviniente.getExpedien().getExfenoai());
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExfecolm() != null) {
			where.append(" AND t2.EXFECOLM = ?");
			params.add(saninterviniente.getExpedien().getExfecolm());
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExnuinlm() != null) {
			where.append(" AND UPPER(t2.EXNUINLM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(saninterviniente.getExpedien().getExnuinlm()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ saninterviniente.getExpedien().getExnuinlm()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.EXNUINLM IS NOT NULL");
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExfeinmu() != null) {
			where.append(" AND t2.EXFEINMU = ?");
			params.add(saninterviniente.getExpedien().getExfeinmu());
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExfeavmu() != null) {
			where.append(" AND t2.EXFEAVMU = ?");
			params.add(saninterviniente.getExpedien().getExfeavmu());
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExfeimcd() != null) {
			where.append(" AND t2.EXFEIMCD = ?");
			params.add(saninterviniente.getExpedien().getExfeimcd());
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExfecede() != null) {
			where.append(" AND t2.EXFECEDE = ?");
			params.add(saninterviniente.getExpedien().getExfecede());
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExcops() != null) {
			where.append(" AND UPPER(t2.EXCOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(saninterviniente.getExpedien().getExcops()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ saninterviniente.getExpedien().getExcops()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.EXCOPS IS NOT NULL");
		}
		if (saninterviniente != null && saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getExcose() != null) {
			where.append(" AND UPPER(t2.EXCOSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(saninterviniente.getExpedien().getExcose()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ saninterviniente.getExpedien().getExcose()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.EXCOSE IS NOT NULL");
		}
		if (saninterviniente != null
				&& saninterviniente.getExpedien() != null
				&& saninterviniente.getExpedien().getSanexp() != null
				&& saninterviniente.getExpedien().getSanexp().getExcodigo() != null) {
			where.append(" AND UPPER(t2.EXCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(saninterviniente.getExpedien().getSanexp()
						.getExcodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ saninterviniente.getExpedien().getSanexp()
								.getExcodigo().toUpperCase() + "%");
			}
			where.append(" AND t2.EXCODIGO IS NOT NULL");
		}
		if (saninterviniente != null && saninterviniente.getNombre() != null) {
			where.append(" AND UPPER(t1.NOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(saninterviniente.getNombre().toUpperCase() + "%");
			} else {
				params.add("%" + saninterviniente.getNombre().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NOMBRE IS NOT NULL");
		}
		if (saninterviniente != null && saninterviniente.getNif() != null) {
			where.append(" AND UPPER(t1.NIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(saninterviniente.getNif().toUpperCase() + "%");
			} else {
				params.add("%" + saninterviniente.getNif().toUpperCase() + "%");
			}
			where.append(" AND t1.NIF IS NOT NULL");
		}
		if (saninterviniente != null && saninterviniente.getNrtel() != null) {
			where.append(" AND UPPER(t1.NRTEL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(saninterviniente.getNrtel().toUpperCase() + "%");
			} else {
				params.add("%" + saninterviniente.getNrtel().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NRTEL IS NOT NULL");
		}
		if (saninterviniente != null && saninterviniente.getNrtel2() != null) {
			where.append(" AND UPPER(t1.NRTEL2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(saninterviniente.getNrtel2().toUpperCase() + "%");
			} else {
				params.add("%" + saninterviniente.getNrtel2().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NRTEL2 IS NOT NULL");
		}
		if (saninterviniente != null
				&& saninterviniente.getNoraProvinciaId() != null) {
			where.append(" AND UPPER(t1.NORA_PROVINCIA_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(saninterviniente.getNoraProvinciaId().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ saninterviniente.getNoraProvinciaId().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NORA_PROVINCIA_ID IS NOT NULL");
		}
		if (saninterviniente != null
				&& saninterviniente.getNoraMunicipioId() != null) {
			where.append(" AND UPPER(t1.NORA_MUNICIPIO_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(saninterviniente.getNoraMunicipioId().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ saninterviniente.getNoraMunicipioId().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NORA_MUNICIPIO_ID IS NOT NULL");
		}
		if (saninterviniente != null
				&& saninterviniente.getNombreMunicipio() != null) {
			where.append(" AND UPPER(t1.NOMBRE_MUNICIPIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(saninterviniente.getNombreMunicipio().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ saninterviniente.getNombreMunicipio().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NOMBRE_MUNICIPIO IS NOT NULL");
		}
		if (saninterviniente != null
				&& saninterviniente.getNoraLocalidadId() != null) {
			where.append(" AND UPPER(t1.NORA_LOCALIDAD_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(saninterviniente.getNoraLocalidadId().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ saninterviniente.getNoraLocalidadId().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NORA_LOCALIDAD_ID IS NOT NULL");
		}
		if (saninterviniente != null
				&& saninterviniente.getNombreLocalidad() != null) {
			where.append(" AND UPPER(t1.NOMBRE_LOCALIDAD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(saninterviniente.getNombreLocalidad().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ saninterviniente.getNombreLocalidad().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NOMBRE_LOCALIDAD IS NOT NULL");
		}
		if (saninterviniente != null
				&& saninterviniente.getNoraCalleId() != null) {
			where.append(" AND UPPER(t1.NORA_CALLE_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(saninterviniente.getNoraCalleId().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ saninterviniente.getNoraCalleId().toUpperCase() + "%");
			}
			where.append(" AND t1.NORA_CALLE_ID IS NOT NULL");
		}
		if (saninterviniente != null
				&& saninterviniente.getNombreCalle() != null) {
			where.append(" AND UPPER(t1.NOMBRE_CALLE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(saninterviniente.getNombreCalle().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ saninterviniente.getNombreCalle().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE_CALLE IS NOT NULL");
		}
		if (saninterviniente != null && saninterviniente.getNoraCpId() != null) {
			where.append(" AND UPPER(t1.NORA_CP_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(saninterviniente.getNoraCpId().toUpperCase() + "%");
			} else {
				params.add("%" + saninterviniente.getNoraCpId().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NORA_CP_ID IS NOT NULL");
		}
		if (saninterviniente != null && saninterviniente.getNombreCp() != null) {
			where.append(" AND UPPER(t1.NOMBRE_CP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(saninterviniente.getNombreCp().toUpperCase() + "%");
			} else {
				params.add("%" + saninterviniente.getNombreCp().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NOMBRE_CP IS NOT NULL");
		}
		if (saninterviniente != null
				&& saninterviniente.getNoraPortalId() != null) {
			where.append(" AND UPPER(t1.NORA_PORTAL_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(saninterviniente.getNoraPortalId().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ saninterviniente.getNoraPortalId().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NORA_PORTAL_ID IS NOT NULL");
		}
		if (saninterviniente != null
				&& saninterviniente.getNombrePortal() != null) {
			where.append(" AND UPPER(t1.NOMBRE_PORTAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(saninterviniente.getNombrePortal().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ saninterviniente.getNombrePortal().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NOMBRE_PORTAL IS NOT NULL");
		}
		if (saninterviniente != null
				&& saninterviniente.getNombrePiso() != null) {
			where.append(" AND UPPER(t1.NOMBRE_PISO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(saninterviniente.getNombrePiso().toUpperCase() + "%");
			} else {
				params.add("%" + saninterviniente.getNombrePiso().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NOMBRE_PISO IS NOT NULL");
		}
		if (saninterviniente != null
				&& saninterviniente.getDireccionNocapv() != null) {
			where.append(" AND UPPER(t1.DIRECCION_NOCAPV) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(saninterviniente.getDireccionNocapv().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ saninterviniente.getDireccionNocapv().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.DIRECCION_NOCAPV IS NOT NULL");
		}
		if (saninterviniente != null
				&& saninterviniente.getDireccionAntigua() != null) {
			where.append(" AND UPPER(t1.DIRECCION_ANTIGUA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(saninterviniente.getDireccionAntigua().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ saninterviniente.getDireccionAntigua().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.DIRECCION_ANTIGUA IS NOT NULL");
		}
		if (saninterviniente != null
				&& saninterviniente.getTipoInterviniente() != null) {
			where.append(" AND UPPER(t1.TIPO_INTERVINIENTE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(saninterviniente.getTipoInterviniente()
						.toUpperCase() + "%");
			} else {
				params.add("%"
						+ saninterviniente.getTipoInterviniente().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TIPO_INTERVINIENTE IS NOT NULL");
		}
		if (saninterviniente != null && saninterviniente.getDtcodigo() != null) {
			where.append(" AND UPPER(t1.DTCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(saninterviniente.getDtcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + saninterviniente.getDtcodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.DTCODIGO IS NOT NULL");
		}
		if (saninterviniente != null && saninterviniente.getEscodigo() != null) {
			where.append(" AND UPPER(t1.ESCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(saninterviniente.getEscodigo().toUpperCase() + "%");
			} else {
				params.add("%" + saninterviniente.getEscodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ESCODIGO IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
