package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.Saninterviniente;

/**
 * SanintervinienteDao  
 *  
 */

public interface SanintervinienteDao {
    
    /**
     * Inserts a single row in the Saninterviniente table.
     *
     * @param saninterviniente Saninterviniente
     * @return Saninterviniente
     */
    Saninterviniente add(Saninterviniente saninterviniente);

    /**
     * Updates a single row in the Saninterviniente table.
     *
     * @param saninterviniente Saninterviniente
     * @return Saninterviniente
     */
    Saninterviniente update(Saninterviniente saninterviniente);

    /**
     * Finds a single row in the Saninterviniente table.
     *
     * @param saninterviniente Saninterviniente
     * @return Saninterviniente
     */
    Saninterviniente find(Saninterviniente saninterviniente);

    /**
     * Deletes a single row in the Saninterviniente table.
     *
     * @param saninterviniente Saninterviniente
     * @return 
     */
    void remove(Saninterviniente saninterviniente);

    /**
     * Finds a List of rows in the Saninterviniente table.
     *
     * @param saninterviniente Saninterviniente
     * @param pagination Pagination
     * @return List
     */
    List<Saninterviniente> findAll(Saninterviniente saninterviniente, Pagination pagination);

    /**
     * Counts rows in the Saninterviniente table.
     *
     * @param saninterviniente Saninterviniente
     * @return Long
     */
    Long findAllCount(Saninterviniente saninterviniente);
	
	/**
     * Finds rows in the Saninterviniente table using like.
     *
     * @param saninterviniente Saninterviniente
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List
     */
	List<Saninterviniente> findAllLike(Saninterviniente saninterviniente, Pagination pagination, Boolean startsWith);
	
    /**
     * Counts rows in the Saninterviniente table using like.
     *
     * @param saninterviniente Saninterviniente
     * @param startsWith Boolean
     * @return Long
     */
    Long findAllLikeCount(Saninterviniente saninterviniente, Boolean startsWith);
}

