package com.ejie.y41b.dao;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Expedien;
import com.ejie.y41b.model.Intervinientes;
import com.ejie.y41b.model.Organismo;
import com.ejie.y41b.model.Sanexp;
import com.ejie.y41b.model.Saninterv;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * SanintervDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class SanintervDaoImpl implements SanintervDao {
	private JdbcTemplate jdbcTemplate;

	private static final Logger logger = LoggerFactory
			.getLogger(SanintervDaoImpl.class);

	private RowMapper<Saninterv> rwMap = new RowMapper<Saninterv>() {
		public Saninterv mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			Saninterv saninterv = new Saninterv(
					resultSet.getBigDecimal("UAIDINTERV"),
					resultSet.getString("UANOMBRE"),
					resultSet.getString("UAAPELLIDO1"),
					resultSet.getString("UAAPELLIDO2"),
					resultSet.getString("UANIF"),
					resultSet.getString("UANRTEL"),
					resultSet.getString("UANRTEL2"),
					resultSet.getString("UAPROVID"),
					resultSet.getString("UAMUNID"),
					resultSet.getString("UALOCID"),
					resultSet.getString("UACALLEID"),
					resultSet.getString("UACPID"),
					resultSet.getString("UAPORTALID"),
					resultSet.getString("UANOMBREPISO"),
					resultSet.getString("UADIRENOCAPV"),
					resultSet.getString("UADIREANT"),
					resultSet.getString("UATIPOINTERV"),
					resultSet.getString("UADTCODIGO"),
					resultSet.getString("UAESCODIGO"),
					resultSet.getDate("UATRFECALTA"),
					resultSet.getDate("UATRFECMODIF"),
					resultSet.getString("UATRUSUALTA"),
					resultSet.getString("UATRUSUMODIF"),
					resultSet.getDate("UAFECALTA"),
					resultSet.getDate("UAFECMODIF"),
					resultSet.getString("UAUSUALTA"),
					resultSet.getString("UAUSUMODIF"), null,
					resultSet.getString("UANODIR"),
					resultSet.getString("UACOEM"), null, null,
					resultSet.getString("UAENTIDAD_ID"));

			Expedien expedien = new Expedien(
					resultSet.getString("EXPEDIENEXCODIGO"),
					resultSet.getString("ExpedienEXCOOR"),
					resultSet.getBigDecimal("ExpedienEXNRAN"),
					resultSet.getBigDecimal("ExpedienEXNROR"),
					resultSet.getDate("ExpedienEXFERE"),
					resultSet.getString("ExpedienEXCOIT"),
					resultSet.getString("ExpedienEXCOES"),
					resultSet.getDate("ExpedienEXFEACIN"),
					resultSet.getDate("ExpedienEXFEEMCA"),
					resultSet.getDate("ExpedienEXFEPLCA"),
					resultSet.getDate("ExpedienEXFPNOPC"),
					resultSet.getDate("ExpedienEXFEDE"),
					resultSet.getDate("ExpedienEXFECOAL"),
					resultSet.getDate("ExpedienEXFENOPR"),
					resultSet.getDate("ExpedienEXFEPUPR"),
					resultSet.getString("ExpedienEXCOOSPR"),
					resultSet.getDate("ExpedienEXFEALPR"),
					resultSet.getDate("ExpedienEXFEEL"),
					resultSet.getDate("ExpedienEXFERES"),
					resultSet.getDate("ExpedienEXFENORE"),
					resultSet.getDate("ExpedienEXFEPURE"),
					resultSet.getString("ExpedienEXCOOSRE"),
					resultSet.getString("ExpedienEXCOTTR"),
					resultSet.getBigDecimal("ExpedienEXCAMURE"),
					resultSet.getDate("ExpedienEXFETA"),
					resultSet.getString("ExpedienEXCOTSA"),
					resultSet.getDate("ExpedienEXFECROI"),
					resultSet.getDate("ExpedienEXFEAR"),
					resultSet.getString("ExpedienEXCOORIE"),
					resultSet.getString("ExpedienEXINRE"),
					resultSet.getString("ExpedienEXINCOCO"),
					resultSet.getString("ExpedienEXINEXVA"),
					resultSet.getDate("ExpedienEXFECIRC"),
					resultSet.getDate("ExpedienEXFENOAI"),
					resultSet.getDate("ExpedienEXFECOLM"),
					resultSet.getString("ExpedienEXNUINLM"),
					resultSet.getDate("ExpedienEXFEINMU"),
					resultSet.getDate("ExpedienEXFEAVMU"),
					resultSet.getDate("ExpedienEXFEIMCD"),
					resultSet.getDate("ExpedienEXFECEDE"),
					resultSet.getString("ExpedienEXCOPS"),
					resultSet.getString("ExpedienEXCOSE"), null, null, null,
					null);

			Sanexp sanexp = new Sanexp(resultSet.getString("EXPEDIENEXCODIGO"));

			expedien.setSanexp(sanexp);
			saninterv.setExpedien(expedien);
			saninterv.setUapaisId(resultSet.getString("UAPAIS_ID"));
			saninterv.setUanopeco(resultSet.getString("UANOPECO"));
			saninterv.setUaurl(resultSet.getString("UAURL"));
			saninterv.setUanoco(resultSet.getString("UANOCO"));
			saninterv.setUasecodigo(resultSet.getString("UASECODIGO"));
			saninterv.setUasenombre(resultSet.getString("UASENOMBRE"));
			saninterv.setUasenombree(resultSet.getString("UANOPECO"));
			saninterv.setUafecultmod(resultSet.getString("UAFECULTMOD"));
			saninterv.setUausuultmod(resultSet.getString("UAUSUULTMOD"));
			saninterv.setUsuarioxlnet(resultSet
					.getString("CENSOMONITORUSUARIOXLNET"));
			saninterv.setUaformanotificacion(resultSet
					.getString("UAFORMANOTIFICACION"));
			saninterv.setUasexo(resultSet.getString("UASEXO"));
			saninterv.setUaedad(resultSet.getString("UAEDAD"));
			saninterv.setUaidioma(resultSet.getString("UAIDIOMA"));
			saninterv.setUatipoidentificacion(resultSet
					.getString("UATIPOIDENTIFICACION"));
			return saninterv;
		}
	};

	private RowMapper<Intervinientes> rwMapInterviniente = new RowMapper<Intervinientes>() {
		public Intervinientes mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			Intervinientes interviniente = new Intervinientes();
			interviniente.setNombre(resultSet.getString("UANOMBRE"));
			interviniente.setApellido1(resultSet.getString("UAAPELLIDO1"));
			interviniente.setApellido2(resultSet.getString("UAAPELLIDO2"));
			interviniente.setIdinterviniente(resultSet.getString("UAIDINTERV"));
			return interviniente;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Saninterv table.
	 * 
	 * @param saninterv
	 *            Pagination
	 * @return Saninterv
	 */
	public Saninterv add(Saninterv saninterv) {
		try {
			String query = "INSERT INTO SANINTERV (UAEXCODIGO, UANOMBRE, UANIF, UANRTEL, UANRTEL2, UAPROV_ID, UAMUN_ID, UALOC_ID, UACALLE_ID, UACP_ID, UAPORTAL_ID, UANOMBRE_PISO, UADIRE_NOCAPV, UADIRE_ANT, UATIPOINTERV, UADTCODIGO, UAESCODIGO, UATRFECALTA, UATRFECMODIF, UATRUSUALTA, UATRUSUMODIF, UAFECALTA, UAFECMODIF, UAUSUALTA, UAUSUMODIF, UANODIR, UACOEM, UAPAIS_ID, UAENTIDAD_ID, UAAPELLIDO1, UAAPELLIDO2, UANOCO, UANOPECO, UAURL, UASECODIGO, UASENOMBRE, UASENOMBREE, UAFECULTMOD, UAUSUULTMOD, UAFORMANOTIFICACION,UASEXO,UAEDAD,UAIDIOMA,UATIPOIDENTIFICACION) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

			Object getExpedienExcodigoAux = null;
			if (saninterv.getExpedien() != null
					&& saninterv.getExpedien().getExcodigo() != null) {
				getExpedienExcodigoAux = saninterv.getExpedien().getExcodigo();
			}
			this.jdbcTemplate.update(query, getExpedienExcodigoAux,
					saninterv.getUanombre(), saninterv.getUanif(),
					saninterv.getUanrtel(), saninterv.getUanrtel2(),
					saninterv.getUaprovId(), saninterv.getUamunId(),
					saninterv.getUalocId(), saninterv.getUacalleId(),
					saninterv.getUacpId(), saninterv.getUaportalId(),
					saninterv.getUanombrePiso(), saninterv.getUadireNocapv(),
					saninterv.getUadireAnt(), saninterv.getUatipointerv(),
					saninterv.getUadtcodigo(), saninterv.getUaescodigo(),
					saninterv.getUatrfecalta(), saninterv.getUatrfecmodif(),
					saninterv.getUatrusualta(), saninterv.getUatrusumodif(),
					saninterv.getUafecalta(), saninterv.getUafecmodif(),
					saninterv.getUausualta(), saninterv.getUausumodif(),
					saninterv.getUanodir(), saninterv.getUacoem(),
					saninterv.getUapaisId(), saninterv.getUaentidad_id(),
					saninterv.getUaapellido1(), saninterv.getUaapellido2(),
					saninterv.getUanoco(), saninterv.getUanopeco(),
					saninterv.getUaurl(), saninterv.getUasecodigo(),
					saninterv.getUasenombre(), saninterv.getUasenombree(),
					saninterv.getUafecultmod(), saninterv.getUausuultmod(),
					saninterv.getUaformanotificacion(), saninterv.getUasexo(),
					saninterv.getUaedad(), saninterv.getUaidioma(),
					saninterv.getUatipoidentificacion());

			saninterv.setUaidinterv(new BigDecimal(this.currentValue()));
			return saninterv;
		} catch (Exception e) {
			e.printStackTrace();
			logger.error("Error producido en add SanInterv: " + e.getMessage(),
					e);
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Updates a single row in the Saninterv table.
	 * 
	 * @param saninterv
	 *            Pagination
	 * @return Saninterv
	 */
	public Saninterv update(Saninterv saninterv) {
		String query = "UPDATE SANINTERV SET UAEXCODIGO=?,UANOMBRE=? , UAAPELLIDO1=?, UAAPELLIDO2=? , UANIF=?, UANRTEL=?, UANRTEL2=?, UAPROV_ID=?, UAMUN_ID=?, UALOC_ID=?, UACALLE_ID=?, UACP_ID=?, UAPORTAL_ID=?, UANOMBRE_PISO=?, UADIRE_NOCAPV=?, UADIRE_ANT=?, UATIPOINTERV=?, UADTCODIGO=?, UAESCODIGO=?, UATRFECALTA=?, UATRFECMODIF=?, UATRUSUALTA=?, UATRUSUMODIF=?, UAFECALTA=?, UAFECMODIF=?, UAUSUALTA=?, UAUSUMODIF=?, UANODIR=?, UAENTIDAD_ID =?, UACOEM =?, UAPAIS_ID =?, UANOCO=?, UANOPECO=?, UAURL=?, UASECODIGO=?, UASENOMBRE=?, UASENOMBREE=?, UAFECULTMOD=?, UAUSUULTMOD=?, UAFORMANOTIFICACION=?,UASEXO=?,UAEDAD=?,UAIDIOMA=?,UATIPOIDENTIFICACION=? WHERE UAIDINTERV=?";
		Object getExpedienExcodigoAux = null;
		if (saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExcodigo() != null) {
			getExpedienExcodigoAux = saninterv.getExpedien().getExcodigo();
		}
		this.jdbcTemplate.update(query, getExpedienExcodigoAux,
				saninterv.getUanombre(), saninterv.getUaapellido1(),
				saninterv.getUaapellido2(), saninterv.getUanif(),
				saninterv.getUanrtel(), saninterv.getUanrtel2(),
				saninterv.getUaprovId(), saninterv.getUamunId(),
				saninterv.getUalocId(), saninterv.getUacalleId(),
				saninterv.getUacpId(), saninterv.getUaportalId(),
				saninterv.getUanombrePiso(), saninterv.getUadireNocapv(),
				saninterv.getUadireAnt(), saninterv.getUatipointerv(),
				saninterv.getUadtcodigo(), saninterv.getUaescodigo(),
				saninterv.getUatrfecalta(), saninterv.getUatrfecmodif(),
				saninterv.getUatrusualta(), saninterv.getUatrusumodif(),
				saninterv.getUafecalta(), saninterv.getUafecmodif(),
				saninterv.getUausualta(), saninterv.getUausumodif(),
				saninterv.getUanodir(), saninterv.getUaentidad_id(),
				saninterv.getUacoem(), saninterv.getUapaisId(),
				saninterv.getUanoco(), saninterv.getUanopeco(),
				saninterv.getUaurl(), saninterv.getUasecodigo(),
				saninterv.getUasenombre(), saninterv.getUasenombree(),
				saninterv.getUafecultmod(), saninterv.getUausuultmod(),
				saninterv.getUaformanotificacion(), saninterv.getUasexo(),
				saninterv.getUaedad(), saninterv.getUaidioma(),
				saninterv.getUatipoidentificacion(), saninterv.getUaidinterv());
		return saninterv;
	}

	/**
	 * Updates a single row in the Saninterv table.
	 * 
	 * @param escodigoBueno
	 *            Pagination
	 * @param escodigoAfusionar
	 *            Pagination
	 */
	public void updateEstablecimiento(String escodigoBueno,
			String escodigoAfusionar) {
		try {
			String query = "UPDATE SANINTERV SET UAESCODIGO=? WHERE UAESCODIGO=? ";
			this.jdbcTemplate.update(query, escodigoBueno, escodigoAfusionar);
		} catch (Exception e) {

		}
	}

	/**
	 * Updates a single row in the Saninterv table.
	 * 
	 * @param dtcodigoBueno
	 *            Pagination
	 * @param dtcodigoAfusionar
	 *            Pagination
	 */
	public void updateConsumidor(String dtcodigoBueno, String dtcodigoAfusionar) {
		try {
			String query = "UPDATE SANINTERV SET UADTCODIGO=? WHERE UADTCODIGO=? ";
			this.jdbcTemplate.update(query, dtcodigoBueno, dtcodigoAfusionar);
		} catch (Exception e) {

		}
	}

	/**
	 * Finds a single row in the Saninterv table.
	 * 
	 * @param saninterv
	 *            Pagination
	 * @return Saninterv
	 */
	@Transactional(readOnly = true)
	public Saninterv find(Saninterv saninterv) {
		String query = "SELECT t1.UAIDINTERV UAIDINTERV, t1.UANOMBRE UANOMBRE, t1.UAAPELLIDO1 UAAPELLIDO1, t1.UAAPELLIDO2 UAAPELLIDO2, t1.UANIF UANIF, t1.UANRTEL UANRTEL, t1.UANRTEL2 UANRTEL2, t1.UAPROV_ID UAPROVID, t1.UAMUN_ID UAMUNID, t1.UALOC_ID UALOCID, t1.UACALLE_ID UACALLEID, t1.UACP_ID UACPID, t1.UAPORTAL_ID UAPORTALID, t1.UANOMBRE_PISO UANOMBREPISO, t1.UADIRE_NOCAPV UADIRENOCAPV, t1.UADIRE_ANT UADIREANT, t1.UATIPOINTERV UATIPOINTERV, t1.UADTCODIGO UADTCODIGO, t1.UAESCODIGO UAESCODIGO, t1.UATRFECALTA UATRFECALTA, t1.UATRFECMODIF UATRFECMODIF, t1.UATRUSUALTA UATRUSUALTA, t1.UATRUSUMODIF UATRUSUMODIF, t1.UAFECALTA UAFECALTA, t1.UAFECMODIF UAFECMODIF, t1.UAUSUALTA UAUSUALTA, t1.UAUSUMODIF UAUSUMODIF, t1.UANODIR UANODIR, t1.UACOEM UACOEM, t1.UAENTIDAD_ID UAENTIDAD_ID, t1.UAPAIS_ID UAPAIS_ID, t1.UANOCO UANOCO, t1.UANOPECO UANOPECO, t1.UAURL UAURL, t1.UASECODIGO UASECODIGO, t1.UASENOMBRE UASENOMBRE, t1.UASENOMBREE UASENOMBREE,"
				+ " t2.EXCODIGO EXPEDIENEXCODIGO, t2.EXCOOR EXPEDIENEXCOOR, t2.EXNRAN EXPEDIENEXNRAN, t2.EXNROR EXPEDIENEXNROR, t2.EXFERE EXPEDIENEXFERE, t2.EXCOIT EXPEDIENEXCOIT, t2.EXCOES EXPEDIENEXCOES, t2.EXFEACIN EXPEDIENEXFEACIN, t2.EXFEEMCA EXPEDIENEXFEEMCA, t2.EXFEPLCA EXPEDIENEXFEPLCA, t2.EXFPNOPC EXPEDIENEXFPNOPC, t2.EXFEDE EXPEDIENEXFEDE, t2.EXFECOAL EXPEDIENEXFECOAL, t2.EXFENOPR EXPEDIENEXFENOPR, t2.EXFEPUPR EXPEDIENEXFEPUPR, t2.EXCOOSPR EXPEDIENEXCOOSPR, t2.EXFEALPR EXPEDIENEXFEALPR, t2.EXFEEL EXPEDIENEXFEEL, t2.EXFERES EXPEDIENEXFERES, t2.EXFENORE EXPEDIENEXFENORE, t2.EXFEPURE EXPEDIENEXFEPURE, t2.EXCOOSRE EXPEDIENEXCOOSRE, t2.EXCOTTR EXPEDIENEXCOTTR, t2.EXCAMURE EXPEDIENEXCAMURE, t2.EXFETA EXPEDIENEXFETA, t2.EXCOTSA EXPEDIENEXCOTSA, t2.EXFECROI EXPEDIENEXFECROI, t2.EXFEAR EXPEDIENEXFEAR, t2.EXCOORIE EXPEDIENEXCOORIE, t2.EXINRE EXPEDIENEXINRE, t2.EXINCOCO EXPEDIENEXINCOCO, t2.EXINEXVA EXPEDIENEXINEXVA, t2.EXFECIRC EXPEDIENEXFECIRC, t2.EXFENOAI EXPEDIENEXFENOAI, t2.EXFECOLM EXPEDIENEXFECOLM, t2.EXNUINLM EXPEDIENEXNUINLM, t2.EXFEINMU EXPEDIENEXFEINMU, t2.EXFEAVMU EXPEDIENEXFEAVMU, t2.EXFEIMCD EXPEDIENEXFEIMCD, t2.EXFECEDE EXPEDIENEXFECEDE, t2.EXCOPS EXPEDIENEXCOPS, t2.EXCOSE EXPEDIENEXCOSE "
				+ " , t1.UAFECULTMOD, t1.UAUSUULTMOD, t1.UAFORMANOTIFICACION, t3.USUARIOXLNET CENSOMONITORUSUARIOXLNET "
				+ " , t1.UASEXO, t1.UAEDAD, t1.UAIDIOMA, t1.UATIPOIDENTIFICACION "
				+ " FROM SANINTERV t1 , EXPEDIEN t2, CENSO_MONITOR t3 WHERE t1.UAIDINTERV = ?   AND t1.UAEXCODIGO= t2.EXCODIGO(+) AND t1.UAUSUULTMOD=t3.MOCODIGO(+)  ";

		List<Saninterv> sanintervList = this.jdbcTemplate.query(query,
				this.rwMap, saninterv.getUaidinterv());
		return (Saninterv) DataAccessUtils.uniqueResult(sanintervList);
	}

	/**
	 * Removes a single row in the Saninterv table.
	 * 
	 * @param saninterv
	 *            Pagination
	 * @return
	 */
	public void remove(Saninterv saninterv) {
		String query = "DELETE FROM SANINTERV WHERE UAIDINTERV=?";
		this.jdbcTemplate.update(query, saninterv.getUaidinterv());
	}

	/**
	 * Finds a List of rows in the Saninterv table.
	 * 
	 * @param saninterv
	 *            Saninterv
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Saninterv> findAll(Saninterv saninterv, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.UAIDINTERV UAIDINTERV,t1.UANOMBRE UANOMBRE, t1.UAAPELLIDO1 UAAPELLIDO1, t1.UAAPELLIDO2 UAAPELLIDO2,t1.UANIF UANIF,t1.UANRTEL UANRTEL,t1.UANRTEL2 UANRTEL2,t1.UAPROV_ID UAPROVID,t1.UAMUN_ID UAMUNID,t1.UALOC_ID UALOCID,t1.UACALLE_ID UACALLEID,t1.UACP_ID UACPID,t1.UAPORTAL_ID UAPORTALID,t1.UANOMBRE_PISO UANOMBREPISO,t1.UADIRE_NOCAPV UADIRENOCAPV,t1.UADIRE_ANT UADIREANT,t1.UATIPOINTERV UATIPOINTERV,t1.UADTCODIGO UADTCODIGO,t1.UAESCODIGO UAESCODIGO,t1.UATRFECALTA UATRFECALTA,t1.UATRFECMODIF UATRFECMODIF,t1.UATRUSUALTA UATRUSUALTA,t1.UATRUSUMODIF UATRUSUMODIF,t1.UAFECALTA UAFECALTA,t1.UAFECMODIF UAFECMODIF,t1.UAUSUALTA UAUSUALTA,t1.UAUSUMODIF UAUSUMODIF, t1.UANODIR UANODIR, t1.UACOEM UACOEM, t1.UAENTIDAD_ID UAENTIDAD_ID, t1.UAPAIS_ID UAPAIS_ID, t1.UANOCO UANOCO, t1.UANOPECO UANOPECO, t1.UAURL UAURL, t1.UASECODIGO UASECODIGO, t1.UASENOMBRE UASENOMBRE, t1.UASENOMBREE UASENOMBREE,"
						+ " t2.EXCODIGO EXPEDIENEXCODIGO,t2.EXCOOR EXPEDIENEXCOOR,t2.EXNRAN EXPEDIENEXNRAN,t2.EXNROR EXPEDIENEXNROR,t2.EXFERE EXPEDIENEXFERE,t2.EXCOIT EXPEDIENEXCOIT,t2.EXCOES EXPEDIENEXCOES,t2.EXFEACIN EXPEDIENEXFEACIN,t2.EXFEEMCA EXPEDIENEXFEEMCA,t2.EXFEPLCA EXPEDIENEXFEPLCA,t2.EXFPNOPC EXPEDIENEXFPNOPC,t2.EXFEDE EXPEDIENEXFEDE,t2.EXFECOAL EXPEDIENEXFECOAL,t2.EXFENOPR EXPEDIENEXFENOPR,t2.EXFEPUPR EXPEDIENEXFEPUPR,t2.EXCOOSPR EXPEDIENEXCOOSPR,t2.EXFEALPR EXPEDIENEXFEALPR,t2.EXFEEL EXPEDIENEXFEEL,t2.EXFERES EXPEDIENEXFERES,t2.EXFENORE EXPEDIENEXFENORE,t2.EXFEPURE EXPEDIENEXFEPURE,t2.EXCOOSRE EXPEDIENEXCOOSRE,t2.EXCOTTR EXPEDIENEXCOTTR,t2.EXCAMURE EXPEDIENEXCAMURE,t2.EXFETA EXPEDIENEXFETA,t2.EXCOTSA EXPEDIENEXCOTSA,t2.EXFECROI EXPEDIENEXFECROI,t2.EXFEAR EXPEDIENEXFEAR,t2.EXCOORIE EXPEDIENEXCOORIE,t2.EXINRE EXPEDIENEXINRE,t2.EXINCOCO EXPEDIENEXINCOCO,t2.EXINEXVA EXPEDIENEXINEXVA,t2.EXFECIRC EXPEDIENEXFECIRC,t2.EXFENOAI EXPEDIENEXFENOAI,t2.EXFECOLM EXPEDIENEXFECOLM,t2.EXNUINLM EXPEDIENEXNUINLM,t2.EXFEINMU EXPEDIENEXFEINMU,t2.EXFEAVMU EXPEDIENEXFEAVMU,t2.EXFEIMCD EXPEDIENEXFEIMCD,t2.EXFECEDE EXPEDIENEXFECEDE,t2.EXCOPS EXPEDIENEXCOPS,t2.EXCOSE EXPEDIENEXCOSE ");
		query.append(" , t1.UAFECULTMOD, t1.UAUSUULTMOD, t1.UAFORMANOTIFICACION, t1.UASEXO, t1.UAEDAD, t1.UAIDIOMA, t1.UATIPOIDENTIFICACION , t3.USUARIOXLNET CENSOMONITORUSUARIOXLNET ");
		query.append("FROM SANINTERV t1 ,EXPEDIEN t2, CENSO_MONITOR t3  ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(saninterv);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.UAEXCODIGO= t2.EXCODIGO(+) AND t1.UAUSUULTMOD=t3.MOCODIGO(+)  ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Saninterv>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds a List of rows in the Saninterv table.
	 * 
	 * @param saninterv
	 *            Saninterv
	 * @param pagination
	 *            Pagination
	 * @return List
	 */

	public List<Intervinientes> findAllIntervinientes(Intervinientes saninterv,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.UAIDINTERV UAIDINTERV,t1.UANOMBRE||' '||nvl(t1.UAAPELLIDO1,'')||' '||nvl(t1.UAAPELLIDO2,'') UANOMBRE,t1.UAAPELLIDO1 UAAPELLIDO1, t1.UAAPELLIDO2 UAAPELLIDO2 ");
		query.append(" FROM SANINTERV t1 ,EXPEDIEN t2 ");

		// Where clause & Params

		List<Object> params = new ArrayList<Object>();

		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.UAEXCODIGO= t2.EXCODIGO(+) AND t2.EXCODIGO = ? ");
		params.add(saninterv.getIdExpediente());

		if (saninterv.getTipoInterviniente() != null) {
			where.append(" AND t1.UATIPOINTERV = ?");
			params.add(saninterv.getTipoInterviniente());
		}
		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Intervinientes>) this.jdbcTemplate.query(query.toString(),
				this.rwMapInterviniente, params.toArray());
	}

	// EVOLUTIVO 0135083 2.2
	/**
	 * Finds a List of rows in the Saninterv table.
	 * 
	 * @param saninterv
	 *            Saninterv
	 * @param pagination
	 *            Pagination
	 * @return List
	 */

	public List<Intervinientes> findAllIntervinientesConCIF(
			Intervinientes saninterv, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT t1.UAIDINTERV UAIDINTERV,CASE WHEN t1.UATIPOINTERV='E' THEN t1.UANIF || CASE WHEN t1.UANIF IS NOT NULL THEN ' - ' ELSE '' END || t1.UANOMBRE || ' ' || NVL(t1.UAAPELLIDO1,'') || ' ' || NVL(t1.UAAPELLIDO2,'') ELSE  t1.UANOMBRE||' '||NVL(t1.UAAPELLIDO1,'')||' '||NVL(t1.UAAPELLIDO2,'') END UANOMBRE, t1.UAAPELLIDO1 UAAPELLIDO1, t1.UAAPELLIDO2 UAAPELLIDO2 ");
		query.append(" FROM SANINTERV t1 ,EXPEDIEN t2 ");

		// Where clause & Params

		List<Object> params = new ArrayList<Object>();

		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.UAEXCODIGO= t2.EXCODIGO(+) AND t2.EXCODIGO = ? ");
		params.add(saninterv.getIdExpediente());

		if (saninterv.getTipoInterviniente() != null) {
			where.append(" AND t1.UATIPOINTERV = ?");
			params.add(saninterv.getTipoInterviniente());
		}
		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Intervinientes>) this.jdbcTemplate.query(query.toString(),
				this.rwMapInterviniente, params.toArray());
	}

	// EVOLUTIVO 0135083 2.2
	/**
	 * Counts rows in the Saninterv table.
	 * 
	 * @param saninterv
	 *            Saninterv
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Saninterv saninterv) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM SANINTERV t1 , EXPEDIEN t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(saninterv);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.UAEXCODIGO= t2.EXCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Saninterv table using like.
	 * 
	 * @param saninterv
	 *            Saninterv
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Saninterv> findAllLike(Saninterv saninterv,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.UAIDINTERV UAIDINTERV,t1.UANOMBRE UANOMBRE, t1.UAAPELLIDO1 UAAPELLIDO1, t1.UAAPELLIDO2 UAAPELLIDO2,t1.UANIF UANIF,t1.UANRTEL UANRTEL,t1.UANRTEL2 UANRTEL2,t1.UAPROV_ID UAPROVID,t1.UAMUN_ID UAMUNID,t1.UALOC_ID UALOCID,t1.UACALLE_ID UACALLEID,t1.UACP_ID UACPID,t1.UAPORTAL_ID UAPORTALID,t1.UANOMBRE_PISO UANOMBREPISO,t1.UADIRE_NOCAPV UADIRENOCAPV,t1.UADIRE_ANT UADIREANT,t1.UATIPOINTERV UATIPOINTERV,t1.UADTCODIGO UADTCODIGO,t1.UAESCODIGO UAESCODIGO,t1.UATRFECALTA UATRFECALTA,t1.UATRFECMODIF UATRFECMODIF,t1.UATRUSUALTA UATRUSUALTA,t1.UATRUSUMODIF UATRUSUMODIF,t1.UAFECALTA UAFECALTA,t1.UAFECMODIF UAFECMODIF,t1.UAUSUALTA UAUSUALTA,t1.UAUSUMODIF UAUSUMODIF, t1.UANODIR UANODIR, t1.UACOEM UACOEM, t1.UAENTIDAD_ID UAENTIDAD_ID, t1.UAPAIS_ID UAPAIS_ID, t1.UANOCO UANOCO, t1.UANOPECO UANOPECO, t1.UAURL UAURL, t1.UASECODIGO UASECODIGO, t1.UASENOMBRE UASENOMBRE, t1.UASENOMBREE UASENOMBREE,"
						+ " t2.EXCODIGO EXPEDIENEXCODIGO,t2.EXCOOR EXPEDIENEXCOOR,t2.EXNRAN EXPEDIENEXNRAN,t2.EXNROR EXPEDIENEXNROR,t2.EXFERE EXPEDIENEXFERE,t2.EXCOIT EXPEDIENEXCOIT,t2.EXCOES EXPEDIENEXCOES,t2.EXFEACIN EXPEDIENEXFEACIN,t2.EXFEEMCA EXPEDIENEXFEEMCA,t2.EXFEPLCA EXPEDIENEXFEPLCA,t2.EXFPNOPC EXPEDIENEXFPNOPC,t2.EXFEDE EXPEDIENEXFEDE,t2.EXFECOAL EXPEDIENEXFECOAL,t2.EXFENOPR EXPEDIENEXFENOPR,t2.EXFEPUPR EXPEDIENEXFEPUPR,t2.EXCOOSPR EXPEDIENEXCOOSPR,t2.EXFEALPR EXPEDIENEXFEALPR,t2.EXFEEL EXPEDIENEXFEEL,t2.EXFERES EXPEDIENEXFERES,t2.EXFENORE EXPEDIENEXFENORE,t2.EXFEPURE EXPEDIENEXFEPURE,t2.EXCOOSRE EXPEDIENEXCOOSRE,t2.EXCOTTR EXPEDIENEXCOTTR,t2.EXCAMURE EXPEDIENEXCAMURE,t2.EXFETA EXPEDIENEXFETA,t2.EXCOTSA EXPEDIENEXCOTSA,t2.EXFECROI EXPEDIENEXFECROI,t2.EXFEAR EXPEDIENEXFEAR,t2.EXCOORIE EXPEDIENEXCOORIE,t2.EXINRE EXPEDIENEXINRE,t2.EXINCOCO EXPEDIENEXINCOCO,t2.EXINEXVA EXPEDIENEXINEXVA,t2.EXFECIRC EXPEDIENEXFECIRC,t2.EXFENOAI EXPEDIENEXFENOAI,t2.EXFECOLM EXPEDIENEXFECOLM,t2.EXNUINLM EXPEDIENEXNUINLM,t2.EXFEINMU EXPEDIENEXFEINMU,t2.EXFEAVMU EXPEDIENEXFEAVMU,t2.EXFEIMCD EXPEDIENEXFEIMCD,t2.EXFECEDE EXPEDIENEXFECEDE,t2.EXCOPS EXPEDIENEXCOPS,t2.EXCOSE EXPEDIENEXCOSE ");
		query.append(" , t1.UAFECULTMOD, t1.UAUSUULTMOD, t1.UAFORMANOTIFICACION, t1.UASEXO, t1.UAEDAD, t1.UAIDIOMA, t1.UATIPOIDENTIFICACION , t3.USUARIOXLNET CENSOMONITORUSUARIOXLNET ");
		query.append("FROM SANINTERV t1 ,EXPEDIEN t2 , CENSO_MONITOR t3 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(saninterv, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.UAEXCODIGO= t2.EXCODIGO(+) AND t1.UAUSUULTMOD=t3.MOCODIGO(+)   ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Saninterv>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Saninterv table using like.
	 * 
	 * @param saninterv
	 *            Saninterv
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Saninterv saninterv, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM SANINTERV t1 ,EXPEDIEN t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(saninterv, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.UAEXCODIGO= t2.EXCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Saninterv entity
	 * 
	 * @param saninterv
	 *            Saninterv Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Saninterv saninterv) {

		StringBuilder where = new StringBuilder(
				SanintervDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (saninterv != null && saninterv.getUaidinterv() != null) {
			where.append(" AND t1.UAIDINTERV = ?");
			params.add(saninterv.getUaidinterv());
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExcodigo() != null) {
			where.append(" AND t2.EXCODIGO = ?");
			params.add(saninterv.getExpedien().getExcodigo());
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExcoor() != null) {
			where.append(" AND t2.EXCOOR = ?");
			params.add(saninterv.getExpedien().getExcoor());
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExnran() != null) {
			where.append(" AND t2.EXNRAN = ?");
			params.add(saninterv.getExpedien().getExnran());
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExnror() != null) {
			where.append(" AND t2.EXNROR = ?");
			params.add(saninterv.getExpedien().getExnror());
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExfere() != null) {
			where.append(" AND t2.EXFERE = ?");
			params.add(saninterv.getExpedien().getExfere());
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExcoit() != null) {
			where.append(" AND t2.EXCOIT = ?");
			params.add(saninterv.getExpedien().getExcoit());
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExcoes() != null) {
			where.append(" AND t2.EXCOES = ?");
			params.add(saninterv.getExpedien().getExcoes());
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExfeacin() != null) {
			where.append(" AND t2.EXFEACIN = ?");
			params.add(saninterv.getExpedien().getExfeacin());
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExfeemca() != null) {
			where.append(" AND t2.EXFEEMCA = ?");
			params.add(saninterv.getExpedien().getExfeemca());
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExfeplca() != null) {
			where.append(" AND t2.EXFEPLCA = ?");
			params.add(saninterv.getExpedien().getExfeplca());
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExfpnopc() != null) {
			where.append(" AND t2.EXFPNOPC = ?");
			params.add(saninterv.getExpedien().getExfpnopc());
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExfede() != null) {
			where.append(" AND t2.EXFEDE = ?");
			params.add(saninterv.getExpedien().getExfede());
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExfecoal() != null) {
			where.append(" AND t2.EXFECOAL = ?");
			params.add(saninterv.getExpedien().getExfecoal());
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExfenopr() != null) {
			where.append(" AND t2.EXFENOPR = ?");
			params.add(saninterv.getExpedien().getExfenopr());
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExfepupr() != null) {
			where.append(" AND t2.EXFEPUPR = ?");
			params.add(saninterv.getExpedien().getExfepupr());
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExcoospr() != null) {
			where.append(" AND t2.EXCOOSPR = ?");
			params.add(saninterv.getExpedien().getExcoospr());
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExfealpr() != null) {
			where.append(" AND t2.EXFEALPR = ?");
			params.add(saninterv.getExpedien().getExfealpr());
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExfeel() != null) {
			where.append(" AND t2.EXFEEL = ?");
			params.add(saninterv.getExpedien().getExfeel());
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExferes() != null) {
			where.append(" AND t2.EXFERES = ?");
			params.add(saninterv.getExpedien().getExferes());
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExfenore() != null) {
			where.append(" AND t2.EXFENORE = ?");
			params.add(saninterv.getExpedien().getExfenore());
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExfepure() != null) {
			where.append(" AND t2.EXFEPURE = ?");
			params.add(saninterv.getExpedien().getExfepure());
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExcoosre() != null) {
			where.append(" AND t2.EXCOOSRE = ?");
			params.add(saninterv.getExpedien().getExcoosre());
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExcottr() != null) {
			where.append(" AND t2.EXCOTTR = ?");
			params.add(saninterv.getExpedien().getExcottr());
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExcamure() != null) {
			where.append(" AND t2.EXCAMURE = ?");
			params.add(saninterv.getExpedien().getExcamure());
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExfeta() != null) {
			where.append(" AND t2.EXFETA = ?");
			params.add(saninterv.getExpedien().getExfeta());
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExcotsa() != null) {
			where.append(" AND t2.EXCOTSA = ?");
			params.add(saninterv.getExpedien().getExcotsa());
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExfecroi() != null) {
			where.append(" AND t2.EXFECROI = ?");
			params.add(saninterv.getExpedien().getExfecroi());
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExfear() != null) {
			where.append(" AND t2.EXFEAR = ?");
			params.add(saninterv.getExpedien().getExfear());
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExcoorie() != null) {
			where.append(" AND t2.EXCOORIE = ?");
			params.add(saninterv.getExpedien().getExcoorie());
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExinre() != null) {
			where.append(" AND t2.EXINRE = ?");
			params.add(saninterv.getExpedien().getExinre());
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExincoco() != null) {
			where.append(" AND t2.EXINCOCO = ?");
			params.add(saninterv.getExpedien().getExincoco());
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExinexva() != null) {
			where.append(" AND t2.EXINEXVA = ?");
			params.add(saninterv.getExpedien().getExinexva());
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExfecirc() != null) {
			where.append(" AND t2.EXFECIRC = ?");
			params.add(saninterv.getExpedien().getExfecirc());
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExfenoai() != null) {
			where.append(" AND t2.EXFENOAI = ?");
			params.add(saninterv.getExpedien().getExfenoai());
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExfecolm() != null) {
			where.append(" AND t2.EXFECOLM = ?");
			params.add(saninterv.getExpedien().getExfecolm());
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExnuinlm() != null) {
			where.append(" AND t2.EXNUINLM = ?");
			params.add(saninterv.getExpedien().getExnuinlm());
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExfeinmu() != null) {
			where.append(" AND t2.EXFEINMU = ?");
			params.add(saninterv.getExpedien().getExfeinmu());
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExfeavmu() != null) {
			where.append(" AND t2.EXFEAVMU = ?");
			params.add(saninterv.getExpedien().getExfeavmu());
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExfeimcd() != null) {
			where.append(" AND t2.EXFEIMCD = ?");
			params.add(saninterv.getExpedien().getExfeimcd());
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExfecede() != null) {
			where.append(" AND t2.EXFECEDE = ?");
			params.add(saninterv.getExpedien().getExfecede());
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExcops() != null) {
			where.append(" AND t2.EXCOPS = ?");
			params.add(saninterv.getExpedien().getExcops());
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExcose() != null) {
			where.append(" AND t2.EXCOSE = ?");
			params.add(saninterv.getExpedien().getExcose());
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getSanexp() != null
				&& saninterv.getExpedien().getSanexp().getExcodigo() != null) {
			where.append(" AND t2.EXCODIGO = ?");
			params.add(saninterv.getExpedien().getSanexp().getExcodigo());
		}
		if (saninterv != null && saninterv.getUanombre() != null) {
			where.append(" AND t1.UANOMBRE = ?");
			params.add(saninterv.getUanombre());
		}
		if (saninterv != null && saninterv.getUaapellido1() != null) {
			where.append(" AND t1.UAAPELLIDO1 = ?");
			params.add(saninterv.getUaapellido1());
		}
		if (saninterv != null && saninterv.getUaapellido2() != null) {
			where.append(" AND t1.UAAPELLIDO2 = ?");
			params.add(saninterv.getUaapellido2());
		}
		if (saninterv != null && saninterv.getUanif() != null) {
			where.append(" AND t1.UANIF = ?");
			params.add(saninterv.getUanif());
		}
		if (saninterv != null && saninterv.getUanrtel() != null) {
			where.append(" AND t1.UANRTEL = ?");
			params.add(saninterv.getUanrtel());
		}
		if (saninterv != null && saninterv.getUanrtel2() != null) {
			where.append(" AND t1.UANRTEL2 = ?");
			params.add(saninterv.getUanrtel2());
		}
		if (saninterv != null && saninterv.getUaprovId() != null) {
			where.append(" AND t1.UAPROV_ID = ?");
			params.add(saninterv.getUaprovId());
		}
		if (saninterv != null && saninterv.getUamunId() != null) {
			where.append(" AND t1.UAMUN_ID = ?");
			params.add(saninterv.getUamunId());
		}
		if (saninterv != null && saninterv.getUalocId() != null) {
			where.append(" AND t1.UALOC_ID = ?");
			params.add(saninterv.getUalocId());
		}
		if (saninterv != null && saninterv.getUacalleId() != null) {
			where.append(" AND t1.UACALLE_ID = ?");
			params.add(saninterv.getUacalleId());
		}
		if (saninterv != null && saninterv.getUacpId() != null) {
			where.append(" AND t1.UACP_ID = ?");
			params.add(saninterv.getUacpId());
		}
		if (saninterv != null && saninterv.getUaportalId() != null) {
			where.append(" AND t1.UAPORTAL_ID = ?");
			params.add(saninterv.getUaportalId());
		}
		if (saninterv != null && saninterv.getUanombrePiso() != null) {
			where.append(" AND t1.UANOMBRE_PISO = ?");
			params.add(saninterv.getUanombrePiso());
		}
		if (saninterv != null && saninterv.getUadireNocapv() != null) {
			where.append(" AND t1.UADIRE_NOCAPV = ?");
			params.add(saninterv.getUadireNocapv());
		}
		if (saninterv != null && saninterv.getUadireAnt() != null) {
			where.append(" AND t1.UADIRE_ANT = ?");
			params.add(saninterv.getUadireAnt());
		}
		if (saninterv != null && saninterv.getUatipointerv() != null) {
			where.append(" AND t1.UATIPOINTERV = ?");
			params.add(saninterv.getUatipointerv());
		}
		if (saninterv != null && saninterv.getUadtcodigo() != null) {
			where.append(" AND t1.UADTCODIGO = ?");
			params.add(saninterv.getUadtcodigo());
		}
		if (saninterv != null && saninterv.getUaescodigo() != null) {
			where.append(" AND t1.UAESCODIGO = ?");
			params.add(saninterv.getUaescodigo());
		}
		if (saninterv != null && saninterv.getUatrfecalta() != null) {
			where.append(" AND t1.UATRFECALTA = ?");
			params.add(saninterv.getUatrfecalta());
		}
		if (saninterv != null && saninterv.getUatrfecmodif() != null) {
			where.append(" AND t1.UATRFECMODIF = ?");
			params.add(saninterv.getUatrfecmodif());
		}
		if (saninterv != null && saninterv.getUatrusualta() != null) {
			where.append(" AND t1.UATRUSUALTA = ?");
			params.add(saninterv.getUatrusualta());
		}
		if (saninterv != null && saninterv.getUatrusumodif() != null) {
			where.append(" AND t1.UATRUSUMODIF = ?");
			params.add(saninterv.getUatrusumodif());
		}
		if (saninterv != null && saninterv.getUafecalta() != null) {
			where.append(" AND t1.UAFECALTA = ?");
			params.add(saninterv.getUafecalta());
		}
		if (saninterv != null && saninterv.getUafecmodif() != null) {
			where.append(" AND t1.UAFECMODIF = ?");
			params.add(saninterv.getUafecmodif());
		}
		if (saninterv != null && saninterv.getUausualta() != null) {
			where.append(" AND t1.UAUSUALTA = ?");
			params.add(saninterv.getUausualta());
		}
		if (saninterv != null && saninterv.getUausumodif() != null) {
			where.append(" AND t1.UAUSUMODIF = ?");
			params.add(saninterv.getUausumodif());
		}
		if (saninterv != null && saninterv.getUaentidad_id() != null) {
			where.append(" AND t1.UAENTIDAD_ID = ?");
			params.add(saninterv.getUaentidad_id());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Saninterv entity
	 * 
	 * @param saninterv
	 *            Saninterv Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Saninterv saninterv,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				SanintervDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (saninterv != null && saninterv.getUaidinterv() != null) {
			where.append(" AND t1.UAIDINTERV = ?");
			params.add(saninterv.getUaidinterv());
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExcodigo() != null) {
			where.append(" AND t2.EXCODIGO = ?");
			params.add(saninterv.getExpedien().getExcodigo());
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExcoor() != null) {
			where.append(" AND UPPER(t2.EXCOOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(saninterv.getExpedien().getExcoor().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ saninterv.getExpedien().getExcoor().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.EXCOOR IS NOT NULL");
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExnran() != null) {
			where.append(" AND t2.EXNRAN = ?");
			params.add(saninterv.getExpedien().getExnran());
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExnror() != null) {
			where.append(" AND t2.EXNROR = ?");
			params.add(saninterv.getExpedien().getExnror());
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExfere() != null) {
			where.append(" AND t2.EXFERE = ?");
			params.add(saninterv.getExpedien().getExfere());
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExcoit() != null) {
			where.append(" AND UPPER(t2.EXCOIT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(saninterv.getExpedien().getExcoit().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ saninterv.getExpedien().getExcoit().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.EXCOIT IS NOT NULL");
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExcoes() != null) {
			where.append(" AND UPPER(t2.EXCOES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(saninterv.getExpedien().getExcoes().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ saninterv.getExpedien().getExcoes().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.EXCOES IS NOT NULL");
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExfeacin() != null) {
			where.append(" AND t2.EXFEACIN = ?");
			params.add(saninterv.getExpedien().getExfeacin());
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExfeemca() != null) {
			where.append(" AND t2.EXFEEMCA = ?");
			params.add(saninterv.getExpedien().getExfeemca());
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExfeplca() != null) {
			where.append(" AND t2.EXFEPLCA = ?");
			params.add(saninterv.getExpedien().getExfeplca());
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExfpnopc() != null) {
			where.append(" AND t2.EXFPNOPC = ?");
			params.add(saninterv.getExpedien().getExfpnopc());
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExfede() != null) {
			where.append(" AND t2.EXFEDE = ?");
			params.add(saninterv.getExpedien().getExfede());
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExfecoal() != null) {
			where.append(" AND t2.EXFECOAL = ?");
			params.add(saninterv.getExpedien().getExfecoal());
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExfenopr() != null) {
			where.append(" AND t2.EXFENOPR = ?");
			params.add(saninterv.getExpedien().getExfenopr());
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExfepupr() != null) {
			where.append(" AND t2.EXFEPUPR = ?");
			params.add(saninterv.getExpedien().getExfepupr());
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExcoospr() != null) {
			where.append(" AND UPPER(t2.EXCOOSPR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(saninterv.getExpedien().getExcoospr().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ saninterv.getExpedien().getExcoospr().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.EXCOOSPR IS NOT NULL");
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExfealpr() != null) {
			where.append(" AND t2.EXFEALPR = ?");
			params.add(saninterv.getExpedien().getExfealpr());
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExfeel() != null) {
			where.append(" AND t2.EXFEEL = ?");
			params.add(saninterv.getExpedien().getExfeel());
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExferes() != null) {
			where.append(" AND t2.EXFERES = ?");
			params.add(saninterv.getExpedien().getExferes());
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExfenore() != null) {
			where.append(" AND t2.EXFENORE = ?");
			params.add(saninterv.getExpedien().getExfenore());
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExfepure() != null) {
			where.append(" AND t2.EXFEPURE = ?");
			params.add(saninterv.getExpedien().getExfepure());
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExcoosre() != null) {
			where.append(" AND UPPER(t2.EXCOOSRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(saninterv.getExpedien().getExcoosre().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ saninterv.getExpedien().getExcoosre().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.EXCOOSRE IS NOT NULL");
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExcottr() != null) {
			where.append(" AND UPPER(t2.EXCOTTR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(saninterv.getExpedien().getExcottr().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ saninterv.getExpedien().getExcottr().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.EXCOTTR IS NOT NULL");
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExcamure() != null) {
			where.append(" AND t2.EXCAMURE = ?");
			params.add(saninterv.getExpedien().getExcamure());
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExfeta() != null) {
			where.append(" AND t2.EXFETA = ?");
			params.add(saninterv.getExpedien().getExfeta());
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExcotsa() != null) {
			where.append(" AND UPPER(t2.EXCOTSA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(saninterv.getExpedien().getExcotsa().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ saninterv.getExpedien().getExcotsa().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.EXCOTSA IS NOT NULL");
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExfecroi() != null) {
			where.append(" AND t2.EXFECROI = ?");
			params.add(saninterv.getExpedien().getExfecroi());
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExfear() != null) {
			where.append(" AND t2.EXFEAR = ?");
			params.add(saninterv.getExpedien().getExfear());
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExcoorie() != null) {
			where.append(" AND UPPER(t2.EXCOORIE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(saninterv.getExpedien().getExcoorie().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ saninterv.getExpedien().getExcoorie().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.EXCOORIE IS NOT NULL");
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExinre() != null) {
			where.append(" AND UPPER(t2.EXINRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(saninterv.getExpedien().getExinre().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ saninterv.getExpedien().getExinre().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.EXINRE IS NOT NULL");
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExincoco() != null) {
			where.append(" AND UPPER(t2.EXINCOCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(saninterv.getExpedien().getExincoco().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ saninterv.getExpedien().getExincoco().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.EXINCOCO IS NOT NULL");
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExinexva() != null) {
			where.append(" AND UPPER(t2.EXINEXVA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(saninterv.getExpedien().getExinexva().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ saninterv.getExpedien().getExinexva().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.EXINEXVA IS NOT NULL");
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExfecirc() != null) {
			where.append(" AND t2.EXFECIRC = ?");
			params.add(saninterv.getExpedien().getExfecirc());
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExfenoai() != null) {
			where.append(" AND t2.EXFENOAI = ?");
			params.add(saninterv.getExpedien().getExfenoai());
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExfecolm() != null) {
			where.append(" AND t2.EXFECOLM = ?");
			params.add(saninterv.getExpedien().getExfecolm());
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExnuinlm() != null) {
			where.append(" AND UPPER(t2.EXNUINLM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(saninterv.getExpedien().getExnuinlm().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ saninterv.getExpedien().getExnuinlm().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.EXNUINLM IS NOT NULL");
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExfeinmu() != null) {
			where.append(" AND t2.EXFEINMU = ?");
			params.add(saninterv.getExpedien().getExfeinmu());
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExfeavmu() != null) {
			where.append(" AND t2.EXFEAVMU = ?");
			params.add(saninterv.getExpedien().getExfeavmu());
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExfeimcd() != null) {
			where.append(" AND t2.EXFEIMCD = ?");
			params.add(saninterv.getExpedien().getExfeimcd());
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExfecede() != null) {
			where.append(" AND t2.EXFECEDE = ?");
			params.add(saninterv.getExpedien().getExfecede());
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExcops() != null) {
			where.append(" AND UPPER(t2.EXCOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(saninterv.getExpedien().getExcops().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ saninterv.getExpedien().getExcops().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.EXCOPS IS NOT NULL");
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getExcose() != null) {
			where.append(" AND UPPER(t2.EXCOSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(saninterv.getExpedien().getExcose().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ saninterv.getExpedien().getExcose().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.EXCOSE IS NOT NULL");
		}
		if (saninterv != null && saninterv.getExpedien() != null
				&& saninterv.getExpedien().getSanexp() != null
				&& saninterv.getExpedien().getSanexp().getExcodigo() != null) {
			where.append(" AND UPPER(t2.EXCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(saninterv.getExpedien().getSanexp().getExcodigo()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ saninterv.getExpedien().getSanexp().getExcodigo()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.EXCODIGO IS NOT NULL");
		}
		if (saninterv != null && saninterv.getUanombre() != null) {
			where.append(" AND UPPER(t1.UANOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(saninterv.getUanombre().toUpperCase() + "%");
			} else {
				params.add("%" + saninterv.getUanombre().toUpperCase() + "%");
			}
			where.append(" AND t1.UANOMBRE IS NOT NULL");
		}
		if (saninterv != null && saninterv.getUaapellido1() != null) {
			where.append(" AND UPPER(t1.UAAPELLIDO1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(saninterv.getUaapellido1().toUpperCase() + "%");
			} else {
				params.add("%" + saninterv.getUaapellido1().toUpperCase() + "%");
			}
			where.append(" AND t1.UAAPELLIDO1 IS NOT NULL");
		}
		if (saninterv != null && saninterv.getUaapellido2() != null) {
			where.append(" AND UPPER(t1.UAAPELLIDO2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(saninterv.getUaapellido2().toUpperCase() + "%");
			} else {
				params.add("%" + saninterv.getUaapellido2().toUpperCase() + "%");
			}
			where.append(" AND t1.UAAPELLIDO2 IS NOT NULL");
		}
		if (saninterv != null && saninterv.getUanif() != null) {
			where.append(" AND UPPER(t1.UANIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(saninterv.getUanif().toUpperCase() + "%");
			} else {
				params.add("%" + saninterv.getUanif().toUpperCase() + "%");
			}
			where.append(" AND t1.UANIF IS NOT NULL");
		}
		if (saninterv != null && saninterv.getUanrtel() != null) {
			where.append(" AND UPPER(t1.UANRTEL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(saninterv.getUanrtel().toUpperCase() + "%");
			} else {
				params.add("%" + saninterv.getUanrtel().toUpperCase() + "%");
			}
			where.append(" AND t1.UANRTEL IS NOT NULL");
		}
		if (saninterv != null && saninterv.getUanrtel2() != null) {
			where.append(" AND UPPER(t1.UANRTEL2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(saninterv.getUanrtel2().toUpperCase() + "%");
			} else {
				params.add("%" + saninterv.getUanrtel2().toUpperCase() + "%");
			}
			where.append(" AND t1.UANRTEL2 IS NOT NULL");
		}
		if (saninterv != null && saninterv.getUaprovId() != null) {
			where.append(" AND UPPER(t1.UAPROV_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(saninterv.getUaprovId().toUpperCase() + "%");
			} else {
				params.add("%" + saninterv.getUaprovId().toUpperCase() + "%");
			}
			where.append(" AND t1.UAPROV_ID IS NOT NULL");
		}
		if (saninterv != null && saninterv.getUamunId() != null) {
			where.append(" AND UPPER(t1.UAMUN_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(saninterv.getUamunId().toUpperCase() + "%");
			} else {
				params.add("%" + saninterv.getUamunId().toUpperCase() + "%");
			}
			where.append(" AND t1.UAMUN_ID IS NOT NULL");
		}
		if (saninterv != null && saninterv.getUalocId() != null) {
			where.append(" AND UPPER(t1.UALOC_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(saninterv.getUalocId().toUpperCase() + "%");
			} else {
				params.add("%" + saninterv.getUalocId().toUpperCase() + "%");
			}
			where.append(" AND t1.UALOC_ID IS NOT NULL");
		}
		if (saninterv != null && saninterv.getUacalleId() != null) {
			where.append(" AND UPPER(t1.UACALLE_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(saninterv.getUacalleId().toUpperCase() + "%");
			} else {
				params.add("%" + saninterv.getUacalleId().toUpperCase() + "%");
			}
			where.append(" AND t1.UACALLE_ID IS NOT NULL");
		}
		if (saninterv != null && saninterv.getUacpId() != null) {
			where.append(" AND UPPER(t1.UACP_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(saninterv.getUacpId().toUpperCase() + "%");
			} else {
				params.add("%" + saninterv.getUacpId().toUpperCase() + "%");
			}
			where.append(" AND t1.UACP_ID IS NOT NULL");
		}
		if (saninterv != null && saninterv.getUaportalId() != null) {
			where.append(" AND UPPER(t1.UAPORTAL_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(saninterv.getUaportalId().toUpperCase() + "%");
			} else {
				params.add("%" + saninterv.getUaportalId().toUpperCase() + "%");
			}
			where.append(" AND t1.UAPORTAL_ID IS NOT NULL");
		}
		if (saninterv != null && saninterv.getUanombrePiso() != null) {
			where.append(" AND UPPER(t1.UANOMBRE_PISO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(saninterv.getUanombrePiso().toUpperCase() + "%");
			} else {
				params.add("%" + saninterv.getUanombrePiso().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.UANOMBRE_PISO IS NOT NULL");
		}
		if (saninterv != null && saninterv.getUadireNocapv() != null) {
			where.append(" AND UPPER(t1.UADIRE_NOCAPV) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(saninterv.getUadireNocapv().toUpperCase() + "%");
			} else {
				params.add("%" + saninterv.getUadireNocapv().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.UADIRE_NOCAPV IS NOT NULL");
		}
		if (saninterv != null && saninterv.getUadireAnt() != null) {
			where.append(" AND UPPER(t1.UADIRE_ANT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(saninterv.getUadireAnt().toUpperCase() + "%");
			} else {
				params.add("%" + saninterv.getUadireAnt().toUpperCase() + "%");
			}
			where.append(" AND t1.UADIRE_ANT IS NOT NULL");
		}
		if (saninterv != null && saninterv.getUatipointerv() != null) {
			where.append(" AND UPPER(t1.UATIPOINTERV) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(saninterv.getUatipointerv().toUpperCase() + "%");
			} else {
				params.add("%" + saninterv.getUatipointerv().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.UATIPOINTERV IS NOT NULL");
		}
		if (saninterv != null && saninterv.getUadtcodigo() != null) {
			where.append(" AND UPPER(t1.UADTCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(saninterv.getUadtcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + saninterv.getUadtcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.UADTCODIGO IS NOT NULL");
		}
		if (saninterv != null && saninterv.getUaescodigo() != null) {
			where.append(" AND UPPER(t1.UAESCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(saninterv.getUaescodigo().toUpperCase() + "%");
			} else {
				params.add("%" + saninterv.getUaescodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.UAESCODIGO IS NOT NULL");
		}
		if (saninterv != null && saninterv.getUatrfecalta() != null) {
			where.append(" AND t1.UATRFECALTA = ?");
			params.add(saninterv.getUatrfecalta());
		}
		if (saninterv != null && saninterv.getUatrfecmodif() != null) {
			where.append(" AND t1.UATRFECMODIF = ?");
			params.add(saninterv.getUatrfecmodif());
		}
		if (saninterv != null && saninterv.getUatrusualta() != null) {
			where.append(" AND UPPER(t1.UATRUSUALTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(saninterv.getUatrusualta().toUpperCase() + "%");
			} else {
				params.add("%" + saninterv.getUatrusualta().toUpperCase() + "%");
			}
			where.append(" AND t1.UATRUSUALTA IS NOT NULL");
		}
		if (saninterv != null && saninterv.getUatrusumodif() != null) {
			where.append(" AND UPPER(t1.UATRUSUMODIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(saninterv.getUatrusumodif().toUpperCase() + "%");
			} else {
				params.add("%" + saninterv.getUatrusumodif().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.UATRUSUMODIF IS NOT NULL");
		}
		if (saninterv != null && saninterv.getUafecalta() != null) {
			where.append(" AND t1.UAFECALTA = ?");
			params.add(saninterv.getUafecalta());
		}
		if (saninterv != null && saninterv.getUafecmodif() != null) {
			where.append(" AND t1.UAFECMODIF = ?");
			params.add(saninterv.getUafecmodif());
		}
		if (saninterv != null && saninterv.getUausualta() != null) {
			where.append(" AND UPPER(t1.UAUSUALTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(saninterv.getUausualta().toUpperCase() + "%");
			} else {
				params.add("%" + saninterv.getUausualta().toUpperCase() + "%");
			}
			where.append(" AND t1.UAUSUALTA IS NOT NULL");
		}
		if (saninterv != null && saninterv.getUausumodif() != null) {
			where.append(" AND UPPER(t1.UAUSUMODIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(saninterv.getUausumodif().toUpperCase() + "%");
			} else {
				params.add("%" + saninterv.getUausumodif().toUpperCase() + "%");
			}
			where.append(" AND t1.UAUSUMODIF IS NOT NULL");
		}
		if (saninterv != null && saninterv.getUaentidad_id() != null) {
			where.append(" AND t1.UAENTIDAD_ID = ?");
			params.add(saninterv.getUaentidad_id());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Finds a List of rows in the Saninterv table.
	 * 
	 * @param expedien
	 *            Expedien
	 * @return List
	 */
	public List<Saninterv> findAllSancionados(Expedien expedien) {
		Saninterv saninterv = new Saninterv();
		saninterv.setExpedien(new Expedien(expedien.getExcodigo()));
		saninterv.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTE_SANCIONADO);
		return (List<Saninterv>) this.findAll(saninterv, null);
	}

	/**
	 * Devuelve todos los interesados del expediente sancionador Interesados
	 * son: Consumidor origen, establecimiento origen u organismo origen
	 * 
	 * @param expedien
	 *            Expedien
	 * @return List<Saninterv>
	 */
	public List<Saninterv> findAllInteresados(Expedien expedien) {
		List<Saninterv> resultado = null;
		Saninterv saninterv = new Saninterv();
		saninterv.setExpedien(new Expedien(expedien.getExcodigo()));
		// CONSUMIDOR ORIGEN
		saninterv.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTE_INTERESADO);
		resultado = (List<Saninterv>) this.findAll(saninterv, null);
		// OTROS ORIGEN
		saninterv
				.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTESAN_OTROS_ORIGEN);
		if (resultado == null) {
			resultado = (List<Saninterv>) this.findAll(saninterv, null);
		} else {
			resultado.addAll((List<Saninterv>) this.findAll(saninterv, null));
		}
		// ESTABLECIMIENTO ORIGEN
		saninterv
				.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTESAN_ESTABLECIMIENTO_ORIGEN);
		if (resultado == null) {
			resultado = (List<Saninterv>) this.findAll(saninterv, null);
		} else {
			resultado.addAll((List<Saninterv>) this.findAll(saninterv, null));
		}
		return resultado;
	}

	/**
	 * Finds a List of rows in the Saninterv table.
	 * 
	 * @param expedien
	 *            Expedien
	 * @param uatipointerv
	 *            String
	 * @return List
	 */
	public List<Saninterv> findAllByTipo(Expedien expedien, String uatipointerv) {
		Saninterv saninterv = new Saninterv();
		saninterv.setExpedien(new Expedien(expedien.getExcodigo()));
		saninterv.setUatipointerv(uatipointerv);
		return (List<Saninterv>) this.findAll(saninterv, null);
	}

	/**
	 * Finds a row in the Saninterv table.
	 * 
	 * @param expedien
	 *            Expedien
	 * @param uatipointerv
	 *            String
	 * @param entidadId
	 *            String
	 * @return Saninterv
	 */
	public Saninterv findByTipoCodigoEntidad(Expedien expedien,
			String uatipointerv, String entidadId) {
		Saninterv resultado = null;
		Saninterv saninterv = new Saninterv();
		saninterv.setExpedien(new Expedien(expedien.getExcodigo()));
		saninterv.setUatipointerv(uatipointerv);
		saninterv.setUaentidad_id(entidadId);
		List<Saninterv> lsaninterv = this.findAll(saninterv, null);
		if (lsaninterv != null && lsaninterv.size() > 0) {
			resultado = lsaninterv.get(0);
		}
		return resultado;
	}

	/**
	 * Aniadir denunciantes.
	 * 
	 * @param solicitudes
	 *            the solicitudes
	 * @param excodigoNuevo
	 *            the excodigo nuevo
	 * @param tipo
	 *            the tipo
	 */
	public void aniadirDenunciantes(String solicitudes, String excodigoNuevo,
			String tipo) {
		StringBuffer query = new StringBuffer();

		String[] arrayValores = solicitudes.split(",");
		ArrayList solicitudCenso = new ArrayList();
		ArrayList solicitudIntervinientes = new ArrayList();
		ArrayList solicitudEstablecimientos = new ArrayList();
		ArrayList solicitudOrganismos = new ArrayList();
		for (int i = 0; i < arrayValores.length; i++) {
			if (!Y41bUtils.esNullOCadenaVacia(arrayValores[i])) {
				query.delete(0, query.length());
				query.append(" SELECT HDTIPODENUNCIANTE "); // HDTIPODENUNCIANTE
				query.append(" FROM HECHO_DENUNCIADO t1 ");
				query.append(" WHERE t1.HDCODIGO = '");
				query.append(arrayValores[i]);
				query.append("'");
				String tipoInterviniente = null;
				try {
					tipoInterviniente = (String) this.jdbcTemplate
							.queryForObject(query.toString(), String.class);
				} catch (Exception e) {
					tipoInterviniente = null;
				}
				query.delete(0, query.length());
				query.append(" SELECT count(1) "); // UAESCODIGO
				query.append(" FROM INTERVINIENTES t1 ");
				query.append(" WHERE t1.TIPO_INTERVINIENTE='I' and t1.HDCODIGO = '");
				query.append(arrayValores[i]);
				query.append("'");
				boolean noExisteInterviniente = (this.jdbcTemplate
						.queryForLong(query.toString()) == 0);
				if (noExisteInterviniente) {
					solicitudCenso.add(arrayValores[i]);
				} else {
					// Consumidor
					if (tipoInterviniente == null) {
						solicitudIntervinientes.add(arrayValores[i]);
					} else if (Y41bConstantes.SOLICITUDES_TIPO_DENUNCIA_EMPRESAS
							.equals(tipoInterviniente)) {
						solicitudEstablecimientos.add(arrayValores[i]);
					} else {
						solicitudOrganismos.add(arrayValores[i]);
					}
				}
			}
		}

		// Insertamos desde interviniente
		if (solicitudIntervinientes.size() > 0) {
			query.delete(0, query.length());
			query.append("INSERT INTO SANINTERV (UAEXCODIGO, UANOMBRE, UAAPELLIDO1, UAAPELLIDO2, UANIF, UACOEM, UANRTEL, UANRTEL2, UAPROV_ID, UAMUN_ID, UALOC_ID, UACALLE_ID, UACP_ID, UAPORTAL_ID, UANOMBRE_PISO, UADIRE_NOCAPV, UANODIR, UAPAIS_ID, ");
			query.append("UADIRE_ANT, ");
			query.append("UATIPOINTERV, ");
			query.append("UADTCODIGO, UAESCODIGO, UAFECULTMOD, UAUSUULTMOD, UAFORMANOTIFICACION, UASEXO, UAEDAD, UAIDIOMA, UATIPOIDENTIFICACION )");
			query.append(" SELECT distinct '"
					+ excodigoNuevo
					+ "', t1.NOMBRE, t1.APELLIDO1, t1.APELLIDO2, t1.NIF, t1.COEM, t1.NRTEL, t1.NRTEL2, t1.NORA_PROVINCIA_ID,t1.NORA_MUNICIPIO_ID,t1.NORA_LOCALIDAD_ID, t1.NORA_CALLE_ID, t1.NOMBRE_CP,t1.NORA_PORTAL_ID, t1.NOMBRE_PISO, t1.DIRECCION_NOCAPV,t1.NOMBRE_PISO, DECODE (t1.EXTRANJERO,'S', t1.NORA_PAIS_ID,'108'), ");
			query.append("t1.DIRECCION_ANTIGUA,");// Dirección antigua
			query.append("'").append(tipo).append("',"); // Denunciante
															// eq
															// Interesado
			query.append("t1.DTCODIGO,");// UAESCODIGO,
			query.append("'', t1.INFEMOD, t1.INCOZS, '',t1.dtcosx, t1.dtrango_edad,t1.coidco,t1.dtintipid "); // UAFECULTMOD,
			// UAUSUULTMOD,UAFORMANOTIFICACION
			query.append(" FROM INTERVINIENTES t1 ");
			query.append(" WHERE t1.TIPO_INTERVINIENTE='I' ");
			query.append(" and (");
			for (int i = 0; i < solicitudIntervinientes.size(); i++) {
				if (i > 0) {
					query.append(" OR ");
				}
				query.append(" t1.HDCODIGO = '")
						.append(solicitudIntervinientes.get(i)).append("'");
			}
			query.append(")");
			query.append(
					" AND NOT EXISTS (SELECT 1 FROM SANINTERV WHERE UADTCODIGO=t1.DTCODIGO AND uaexcodigo='")
					.append(excodigoNuevo).append("')");
			this.jdbcTemplate.update(query.toString());
			// actualizacion del tipo por si el consumidor ya existia en el
			// expediente
			query.delete(0, query.length());
			query.append("UPDATE SANINTERV SET UATIPOINTERV='").append(tipo)
					.append("' WHERE UAEXCODIGO='");
			query.append(excodigoNuevo)
					.append("' AND UADTCODIGO IN (SELECT DTCODIGO FROM INTERVINIENTES t1 ");
			query.append(" WHERE t1.TIPO_INTERVINIENTE='I' ");
			query.append(" and (");
			for (int i = 0; i < solicitudIntervinientes.size(); i++) {
				if (i > 0) {
					query.append(" OR ");
				}
				query.append(" t1.HDCODIGO = '")
						.append(solicitudIntervinientes.get(i)).append("'");
			}
			query.append("))");

			this.jdbcTemplate.update(query.toString());
		}

		// Insertamos desde interviniente establecimiento
		if (solicitudEstablecimientos.size() > 0) {
			String tipoEstablecimiento = (Y41bConstantes.TIPO_INTERVINIENTE_INTERESADO
					.equals(tipo) ? Y41bConstantes.TIPO_INTERVINIENTESAN_ESTABLECIMIENTO_ORIGEN
					: Y41bConstantes.TIPO_INTERVINIENTESAN_ESTABLECIMIENTO);
			query.delete(0, query.length());
			query.append("INSERT INTO SANINTERV (UAEXCODIGO, UANOMBRE, UAAPELLIDO1, UAAPELLIDO2, UANIF, UACOEM, UANRTEL, UANRTEL2, UAPROV_ID, UAMUN_ID, UALOC_ID, UACALLE_ID, UACP_ID, UAPORTAL_ID, UANOMBRE_PISO, UADIRE_NOCAPV, UANODIR, UAPAIS_ID, ");
			query.append("UADIRE_ANT, ");
			query.append("UATIPOINTERV, ");
			query.append("UADTCODIGO, UAESCODIGO, UAFECULTMOD, UAUSUULTMOD, UAFORMANOTIFICACION, UASEXO, UAEDAD, UAIDIOMA, UATIPOIDENTIFICACION, UANOCO, UANOPECO, UASECODIGO, UASENOMBRE, UASENOMBREE )");
			query.append(" SELECT distinct '"
					+ excodigoNuevo
					+ "', t1.NOMBRE, t1.APELLIDO1, t1.APELLIDO2, t1.NIF, t1.COEM, t1.NRTEL, t1.NRTEL2, t1.NORA_PROVINCIA_ID,t1.NORA_MUNICIPIO_ID,t1.NORA_LOCALIDAD_ID, t1.NORA_CALLE_ID, t1.NOMBRE_CP,t1.NORA_PORTAL_ID, t1.NOMBRE_PISO, t1.DIRECCION_NOCAPV,t1.NOMBRE_PISO, DECODE (t1.EXTRANJERO,'S', t1.NORA_PAIS_ID,'108'), ");
			query.append("t1.DIRECCION_ANTIGUA,");// Direccion antigua
			query.append("'").append(tipoEstablecimiento).append("',"); // Denunciante
			query.append("'', t1.ESCODIGO, t1.INFEMOD, t1.INCOZS, '',t1.dtcosx, t1.dtrango_edad,t1.coidco,t1.dtintipid,t1.esnoco,t1.esnopeco,t1.secodigo,t1.senombre,t1.senombree "); // UAFECULTMOD,
			// UAUSUULTMOD,UAFORMANOTIFICACION
			query.append(" FROM INTERVINIENTES t1 ");
			query.append(" WHERE t1.TIPO_INTERVINIENTE='I' ");
			query.append(" and (");
			for (int i = 0; i < solicitudEstablecimientos.size(); i++) {
				if (i > 0) {
					query.append(" OR ");
				}
				query.append(" t1.HDCODIGO = '")
						.append(solicitudEstablecimientos.get(i)).append("'");
			}
			query.append(")");
			query.append(
					" AND NOT EXISTS (SELECT 1 FROM SANINTERV WHERE UAESCODIGO=t1.ESCODIGO AND uaexcodigo='")
					.append(excodigoNuevo).append("')");
			this.jdbcTemplate.update(query.toString());
			// actualizacion del tipo por si el establecimiento ya existia en el
			// expediente
			query.delete(0, query.length());
			query.append("UPDATE SANINTERV SET UATIPOINTERV='")
					.append(tipoEstablecimiento).append("' WHERE UAEXCODIGO='");
			query.append(excodigoNuevo)
					.append("' AND UAESCODIGO IN (SELECT ESCODIGO FROM INTERVINIENTES t1 ");
			query.append(" WHERE t1.TIPO_INTERVINIENTE='I' ");
			query.append(" and (");
			for (int i = 0; i < solicitudEstablecimientos.size(); i++) {
				if (i > 0) {
					query.append(" OR ");
				}
				query.append(" t1.HDCODIGO = '")
						.append(solicitudEstablecimientos.get(i)).append("'");
			}
			query.append("))");

			this.jdbcTemplate.update(query.toString());
		}

		// Insertamos desde interviniente Organismo
		if (solicitudOrganismos.size() > 0) {
			String tipoOrganismo = (Y41bConstantes.TIPO_INTERVINIENTE_INTERESADO
					.equals(tipo) ? Y41bConstantes.TIPO_INTERVINIENTESAN_OTROS_ORIGEN
					: Y41bConstantes.TIPO_INTERVINIENTESAN_OTROS);
			query.delete(0, query.length());
			query.append("INSERT INTO SANINTERV (UAEXCODIGO, UANOMBRE, UAAPELLIDO1, UAAPELLIDO2, UANIF, UACOEM, UANRTEL, UANRTEL2, UAPROV_ID, UAMUN_ID, UALOC_ID, UACALLE_ID, UACP_ID, UAPORTAL_ID, UANOMBRE_PISO, UADIRE_NOCAPV, UANODIR, UAPAIS_ID, ");
			query.append("UADIRE_ANT, ");
			query.append("UATIPOINTERV, ");
			query.append("UADTCODIGO, UAESCODIGO, UAENTIDAD_ID, UAFECULTMOD, UAUSUULTMOD, UAFORMANOTIFICACION, UASEXO, UAEDAD, UAIDIOMA, UATIPOIDENTIFICACION )");
			query.append(" SELECT distinct '"
					+ excodigoNuevo
					+ "', t1.NOMBRE, t1.APELLIDO1, t1.APELLIDO2, t1.NIF, t1.COEM, t1.NRTEL, t1.NRTEL2, t1.NORA_PROVINCIA_ID,t1.NORA_MUNICIPIO_ID,t1.NORA_LOCALIDAD_ID, t1.NORA_CALLE_ID, t1.NOMBRE_CP,t1.NORA_PORTAL_ID, t1.NOMBRE_PISO, t1.DIRECCION_NOCAPV,t1.NOMBRE_PISO, DECODE (t1.EXTRANJERO,'S', t1.NORA_PAIS_ID,'108'), ");
			query.append("t1.DIRECCION_ANTIGUA,");// Dirección antigua
			query.append("'").append(tipoOrganismo).append("',"); // Denunciante
			// eq
			// Interesado
			query.append("'','',");
			query.append(" t1.ENTIDAD_ID, t1.INFEMOD, t1.INCOZS, '',t1.dtcosx, t1.dtrango_edad,t1.coidco,t1.dtintipid "); // UAFECULTMOD,
			// UAUSUULTMOD,UAFORMANOTIFICACION
			query.append(" FROM INTERVINIENTES t1 ");
			query.append(" WHERE t1.TIPO_INTERVINIENTE='I' ");
			query.append(" and (");
			for (int i = 0; i < solicitudOrganismos.size(); i++) {
				if (i > 0) {
					query.append(" OR ");
				}
				query.append(" t1.HDCODIGO = '")
						.append(solicitudOrganismos.get(i)).append("'");
			}
			query.append(")");
			query.append(
					" AND NOT EXISTS (SELECT 1 FROM SANINTERV WHERE UAENTIDAD_ID=t1.ENTIDAD_ID AND uaexcodigo='")
					.append(excodigoNuevo).append("')");
			this.jdbcTemplate.update(query.toString());
			// actualizacion del tipo por si el organismo ya existia en el
			// expediente
			query.delete(0, query.length());
			query.append("UPDATE SANINTERV SET UATIPOINTERV='")
					.append(tipoOrganismo).append("' WHERE UAEXCODIGO='");
			query.append(excodigoNuevo)
					.append("' AND UAENTIDAD_ID IN (SELECT ENTIDAD_ID FROM INTERVINIENTES t1 ");
			query.append(" WHERE t1.TIPO_INTERVINIENTE='I' ");
			query.append(" and (");
			for (int i = 0; i < solicitudOrganismos.size(); i++) {
				if (i > 0) {
					query.append(" OR ");
				}
				query.append(" t1.HDCODIGO = '")
						.append(solicitudOrganismos.get(i)).append("'");
			}
			query.append("))");

			this.jdbcTemplate.update(query.toString());
		}

		// Para los que no existen en intervinientes, insertamos desde censo
		if (solicitudCenso.size() > 0) {
			query.delete(0, query.length());
			query.append("INSERT INTO SANINTERV (UAEXCODIGO, UANOMBRE, UAAPELLIDO1, UAAPELLIDO2, UANIF, UACOEM, UANRTEL, UANRTEL2, UAPROV_ID, UAMUN_ID, UALOC_ID, UACALLE_ID, UACP_ID, UAPORTAL_ID, UANOMBRE_PISO, UADIRE_NOCAPV, UANODIR, UAPAIS_ID, ");
			query.append("UADIRE_ANT, ");
			query.append("UATIPOINTERV, ");
			query.append("UADTCODIGO, UAESCODIGO, UAFECULTMOD, UAUSUULTMOD, UAFORMANOTIFICACION, UASEXO, UAEDAD, UAIDIOMA, UATIPOIDENTIFICACION )");
			query.append(" SELECT distinct '"
					+ excodigoNuevo
					+ "', t1.DTNOMBRE, t1.DTAPELLIDO1, t1.DTAPELLIDO2, t1.DTNIF, t1.DTTECOEM, t1.DTNRTEL, t1.DTNRTEL2, t1.DTNORA_PROVINCIA_ID,t1.DTNORA_MUNICIPIO_ID,t1.DTNORA_LOCALIDAD_ID, t1.DTNORA_CALLE_ID, t1.DTNOMBRE_CP,t1.DTNORA_PORTAL_ID, t1.DTNOMBRE_PISO, t1.DTDIRECCION_NOCAPV,t1.DTNOMBRE_PISO, DECODE (t1.DTEXTRANJERO,'S', t1.DTNORA_PAIS_ID,'108'), ");
			query.append("t1.DTNODIR,");// Dirección antigua
			query.append("'").append(tipo).append("',"); // Denunciante
															// eq
															// Interesado
			query.append("t1.DTCODIGO,");// UAESCODIGO,

			query.append("'', t1.DTFEMOD, t1.DTCOZS, '',t1.dtcosx, t1.dtrango_edad,t1.dtcoidco,t1.dtintipid  "); // UAFECULTMOD,UAUSUULTMOD,UAFORMANOTIFICACION

			query.append(" FROM CONSUMIDOR t1, DENUNCIA t2, HECHO_DENUNCIADO t3 ");
			query.append(" WHERE t1.DTCODIGO=t2.DECODT and t2.DECODIGO=t3.HDCODE ");

			query.append(" and (");
			for (int i = 0; i < solicitudCenso.size(); i++) {
				if (i > 0) {
					query.append(" OR ");
				}
				query.append(" t3.HDCODIGO = '").append(solicitudCenso.get(i))
						.append("'");
			}
			query.append(")");
			query.append(
					" AND NOT EXISTS (SELECT 1 FROM SANINTERV WHERE UADTCODIGO=t1.DTCODIGO AND uaexcodigo='")
					.append(excodigoNuevo).append("')");
			this.jdbcTemplate.update(query.toString());

			// actualizacion del tipo por si el consumidor ya existia en el
			// expediente
			query.delete(0, query.length());
			query.append("UPDATE SANINTERV SET UATIPOINTERV='").append(tipo)
					.append("'  WHERE UAEXCODIGO='");
			query.append(excodigoNuevo)
					.append("' AND UADTCODIGO IN (SELECT DTCODIGO FROM CONSUMIDOR t1, DENUNCIA t2, HECHO_DENUNCIADO t3 ");
			query.append(" WHERE t1.DTCODIGO=t2.DECODT and t2.DECODIGO=t3.HDCODE ");
			query.append(" and (");
			for (int i = 0; i < solicitudCenso.size(); i++) {
				if (i > 0) {
					query.append(" OR ");
				}
				query.append(" t3.HDCODIGO = '").append(solicitudCenso.get(i))
						.append("'");
			}
			query.append("))");

			this.jdbcTemplate.update(query.toString());
		}

	}

	/**
	 * Aniadir denunciantes.
	 * 
	 * @param solicitudes
	 *            String
	 * @param excodigoNuevo
	 *            the excodigo nuevo
	 * @param tipo
	 *            the tipo
	 */
	public void aniadirDenunciantesArb(String solicitudes,
			String excodigoNuevo, String tipo) {
		StringBuffer query = new StringBuffer();

		String[] arrayValores = solicitudes.split(",");
		ArrayList solicitudCenso = new ArrayList();
		ArrayList solicitudIntervinientes = new ArrayList();
		for (int i = 0; i < arrayValores.length; i++) {
			query.delete(0, query.length());
			query.append(" SELECT count(1) "); // UAESCODIGO
			query.append(" FROM ARBINTERV t1 ");
			query.append(" WHERE t1.UATIPOINTERV='I' and t1.UAEXCODIGO = '");
			query.append(arrayValores[i]);
			query.append("'");
			if (this.jdbcTemplate.queryForLong(query.toString()) == 0) {
				solicitudCenso.add(arrayValores[i]);
			} else {
				solicitudIntervinientes.add(arrayValores[i]);
			}
		}

		// Insertamos desde interviniente
		if (solicitudIntervinientes.size() > 0) {
			query.delete(0, query.length());
			query.append("INSERT INTO SANINTERV (UAEXCODIGO, UANOMBRE, UAAPELLIDO1, UAAPELLIDO2, UANIF, UACOEM, UANRTEL, UANRTEL2, UAPROV_ID, UAMUN_ID, UALOC_ID, UACALLE_ID, UACP_ID, UAPORTAL_ID, UANOMBRE_PISO, UADIRE_NOCAPV, UANODIR, UAPAIS_ID, ");
			query.append("UADIRE_ANT, ");
			query.append("UATIPOINTERV, ");
			query.append("UADTCODIGO, UAESCODIGO, UAFECULTMOD, UAUSUULTMOD, UAFORMANOTIFICACION, UASEXO, UAEDAD, UAIDIOMA, UATIPOIDENTIFICACION )");
			query.append(" SELECT distinct '"
					+ excodigoNuevo
					+ "', t1.UANOMBRE, t1.UAAPELLIDO1, t1.UAAPELLIDO2, t1.UANIF, t1.UACOEM, t1.UANRTEL, t1.UANRTEL2, t1.UAPROV_ID, t1.UAMUN_ID, t1.UALOC_ID, t1.UACALLE_ID, t1.UACP_ID, t1.UAPORTAL_ID, t1.UANOMBRE_PISO, t1.UADIRE_NOCAPV, t1.UANODIR, t1.UAPAIS_ID, ");
			query.append("t1.UADIRE_ANT, ");
			query.append("'").append(tipo).append("',");
			query.append("t1.UADTCODIGO, t1.UAESCODIGO, t1.UAFECULTMOD, t1.UAUSUULTMOD, t1.UAFORMANOTIFICACION, t1.UASEXO, t1.UAEDAD, t1.UAIDIOMA, t1.UATIPOIDENTIFICACION ");

			query.append(" FROM ARBINTERV t1 ");
			query.append(" WHERE t1.UATIPOINTERV='I' ");
			query.append(" and (");
			for (int i = 0; i < solicitudIntervinientes.size(); i++) {
				if (i > 0) {
					query.append(" OR ");
				}
				query.append(" t1.UAEXCODIGO = '")
						.append(solicitudIntervinientes.get(i)).append("'");
			}
			query.append(")");
			query.append(
					" AND NOT EXISTS (SELECT 1 FROM SANINTERV t2 WHERE t2.UADTCODIGO=t1.UADTCODIGO AND t2.uaexcodigo='")
					.append(excodigoNuevo).append("')");
			this.jdbcTemplate.update(query.toString());
			// actualizacion del tipo por si el consumidor ya existia en el
			// expediente
			query.delete(0, query.length());
			query.append("UPDATE SANINTERV SET UATIPOINTERV='").append(tipo)
					.append("' WHERE UAEXCODIGO='");
			query.append(excodigoNuevo)
					.append("' AND UADTCODIGO IN (SELECT t1.UADTCODIGO FROM ARBINTERV t1 ");
			query.append(" WHERE t1.UATIPOINTERV='I' ");
			query.append(" and (");
			for (int i = 0; i < solicitudIntervinientes.size(); i++) {
				if (i > 0) {
					query.append(" OR ");
				}
				query.append(" t1.UAEXCODIGO = '")
						.append(solicitudIntervinientes.get(i)).append("'");
			}
			query.append("))");

			this.jdbcTemplate.update(query.toString());
		}

		// Para los que no existen en intervinientes, insertamos desde censo
		if (solicitudCenso.size() > 0) {
			query.delete(0, query.length());
			query.append("INSERT INTO SANINTERV (UAEXCODIGO, UANOMBRE, UAAPELLIDO1, UAAPELLIDO2, UANIF, UACOEM, UANRTEL, UANRTEL2, UAPROV_ID, UAMUN_ID, UALOC_ID, UACALLE_ID, UACP_ID, UAPORTAL_ID, UANOMBRE_PISO, UADIRE_NOCAPV, UANODIR, UAPAIS_ID, ");
			query.append("UADIRE_ANT, ");
			query.append("UATIPOINTERV, ");
			query.append("UADTCODIGO, UAESCODIGO, UAFECULTMOD, UAUSUULTMOD, UAFORMANOTIFICACION, UASEXO, UAEDAD, UAIDIOMA, UATIPOIDENTIFICACION )");
			query.append(" SELECT distinct '"
					+ excodigoNuevo
					+ "', t1.DTNOMBRE, t1.DTAPELLIDO1, t1.DTAPELLIDO2, t1.DTNIF, t1.DTTECOEM, t1.DTNRTEL, t1.DTNRTEL2, t1.DTNORA_PROVINCIA_ID,t1.DTNORA_MUNICIPIO_ID,t1.DTNORA_LOCALIDAD_ID, t1.DTNORA_CALLE_ID, t1.DTNOMBRE_CP,t1.DTNORA_PORTAL_ID, t1.DTNOMBRE_PISO, t1.DTDIRECCION_NOCAPV,t1.DTNOMBRE_PISO, DECODE (t1.DTEXTRANJERO,'S', t1.DTNORA_PAIS_ID,'108'), ");
			query.append("t1.DTNODIR,");// Dirección antigua
			query.append("'").append(tipo).append("',"); // Denunciante
															// eq
															// Interesado
			query.append("t1.DTCODIGO,");// UAESCODIGO,

			query.append("'', t1.DTFEMOD, t1.DTCOZS, '',t1.dtcosx, t1.dtrango_edad,t1.dtcoidco,t1.dtintipid  "); // UAFECULTMOD,UAUSUULTMOD,UAFORMANOTIFICACION

			query.append(" FROM CONSUMIDOR t1, SOLARB t2, DTSA t3 ");
			query.append(" WHERE t1.DTCODIGO=t3.M9CODT and t3.M9COSA=t2.SACODIGO ");

			query.append(" and (");
			for (int i = 0; i < solicitudCenso.size(); i++) {
				if (i > 0) {
					query.append(" OR ");
				}
				query.append(" t2.SACODIGO = '").append(solicitudCenso.get(i))
						.append("'");
			}
			query.append(")");
			query.append(
					" AND NOT EXISTS (SELECT 1 FROM SANINTERV WHERE UADTCODIGO=t1.DTCODIGO AND uaexcodigo='")
					.append(excodigoNuevo).append("')");
			this.jdbcTemplate.update(query.toString());

			// actualizacion del tipo por si el consumidor ya existia en el
			// expediente
			query.delete(0, query.length());
			query.append("UPDATE SANINTERV SET UATIPOINTERV='").append(tipo)
					.append("' WHERE UAEXCODIGO='");
			query.append(excodigoNuevo)
					.append("' AND UADTCODIGO IN (SELECT DTCODIGO FROM CONSUMIDOR t1, SOLARB t2, DTSA t3 ");
			query.append(" WHERE t1.DTCODIGO=t3.M9CODT and t3.M9COSA=t2.SACODIGO ");
			query.append(" and (");
			for (int i = 0; i < solicitudCenso.size(); i++) {
				if (i > 0) {
					query.append(" OR ");
				}
				query.append(" t2.SACODIGO = '").append(solicitudCenso.get(i))
						.append("'");
			}
			query.append("))");

			this.jdbcTemplate.update(query.toString());
		}

	}

	/**
	 * Convierte organismo a san interv.
	 * 
	 * @param organismoAsesoria
	 *            the organismo asesoria
	 * @param expedien
	 *            the expedien
	 * @return the saninterv
	 */
	public Saninterv convierteOrganismoASanInterv(Organismo organismoAsesoria,
			Expedien expedien) {
		Saninterv intervinienteAsesoria = new Saninterv();
		intervinienteAsesoria.setUaentidad_id(organismoAsesoria.getEntidadId());
		intervinienteAsesoria.setExpedien(expedien);
		intervinienteAsesoria.setNombreMunicipio(organismoAsesoria
				.getNombreMunicipio());

		intervinienteAsesoria.setUanombre(organismoAsesoria.getNombreEs());
		intervinienteAsesoria.setUanif(organismoAsesoria.getCif());
		intervinienteAsesoria.setUanrtel(organismoAsesoria.getTelefono());

		intervinienteAsesoria.setUacoem(organismoAsesoria.getEmail());
		intervinienteAsesoria.setUaprovId(organismoAsesoria
				.getNoraProvinciaId());
		intervinienteAsesoria
				.setUamunId(organismoAsesoria.getNoraMunicipioId());
		intervinienteAsesoria
				.setUalocId(organismoAsesoria.getNoraLocalidadId());
		intervinienteAsesoria.setUacalleId(organismoAsesoria.getNoraCalleId());
		intervinienteAsesoria.setUacpId(organismoAsesoria.getNoraCpId());
		intervinienteAsesoria
				.setUaportalId(organismoAsesoria.getNoraPortalId());
		intervinienteAsesoria.setUanombrePiso(organismoAsesoria
				.getNombrePortal());
		intervinienteAsesoria
				.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTE_OTRO);
		return intervinienteAsesoria;

	}

	/**
	 * Devuelve el numero de una secuencia
	 * 
	 * @return Integer
	 */
	public Integer currentValue() {
		String query = "SELECT L21UAQ00.CURRVAL FROM DUAL";
		List<Object> params = new ArrayList<Object>();
		return this.jdbcTemplate
				.queryForInt(query.toString(), params.toArray());
	}

	/**
	 * Dame sancionado.
	 * 
	 * @param excodigo
	 *            String
	 * @return the saninterv
	 */
	public Saninterv dameSancionado(String excodigo) {
		{

			Saninterv saninterv = new Saninterv();
			saninterv.setExpedien(new Expedien(excodigo, null, null, null,
					null, null, null, null, null));
			saninterv
					.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTE_SANCIONADO);
			List<Saninterv> listaSaninterv = this.findAll(saninterv, null);
			if (listaSaninterv != null) {
				if (listaSaninterv.size() == 1) {
					saninterv = listaSaninterv.get(0);
					return saninterv;
				}
			}
			return null;

		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.y41b.dao.SanintervDao#updateFormaNotificacion(java.lang.String,
	 * java.lang.String, java.lang.String)
	 */
	@Override
	public void updateFormaNotificacion(String excodigo, String excoes,
			String formanotificacion) {
		String query = "UPDATE SANINTERV SET UAFORMANOTIFICACION=? WHERE UAEXCODIGO=? AND UAESCODIGO=? ";
		this.jdbcTemplate.update(query, formanotificacion, excodigo, excoes);
	}

	/**
	 * 
	 * @param santinerv
	 *            Saninterv
	 * @param tipo
	 *            String
	 */
	public void updateTipointervinienteAnterior(Saninterv santinerv, String tipo) {
		if (Y41bConstantes.TIPO_INTERVINIENTE_INTERESADO.equals(tipo)
				|| Y41bConstantes.TIPO_INTERVINIENTESAN_CONSUMIDOR.equals(tipo)) {
			String query = "UPDATE SANINTERV SET UATIPOINTERV=? WHERE UAEXCODIGO=? AND UADTCODIGO=? ";
			this.jdbcTemplate.update(query, santinerv.getUatipointerv(),
					santinerv.getExpedien().getExcodigo(),
					santinerv.getUadtcodigo());
		} else if (Y41bConstantes.TIPO_INTERVINIENTESAN_REPRESENTANTE_SANCIONADO
				.equals(tipo)
				|| Y41bConstantes.TIPO_INTERVINIENTESAN_REPRESENTANTE_SANCIONADO_NO_VALIDADO
						.equals(tipo)) {
			String query = "UPDATE SANINTERV SET UATIPOINTERV=? WHERE UAIDINTERV=? ";
			this.jdbcTemplate
					.update(query,
							Y41bConstantes.TIPO_INTERVINIENTESAN_REPRESENTANTE_SANCIONADO_ANTERIOR,
							santinerv.getUaidinterv());
		} else {
			String query = "UPDATE SANINTERV SET UATIPOINTERV=? WHERE UAEXCODIGO=? AND UAESCODIGO=? ";
			this.jdbcTemplate.update(query, santinerv.getUatipointerv(),
					santinerv.getExpedien().getExcodigo(),
					santinerv.getUaescodigo());
		}
	}

	/**
	 * 
	 * @param santinerv
	 *            Saninterv
	 * @param tipo
	 *            String
	 */
	public void updateTipointerviniente(Saninterv santinerv, String tipo) {
		String query = "UPDATE SANINTERV SET UATIPOINTERV=? WHERE UAIDINTERV=? ";
		this.jdbcTemplate.update(query, tipo, santinerv.getUaidinterv());
	}

	/**
	 * Metodo para coger el interviniente sancionador por tipo de interviniente
	 * 
	 * @param excodigo
	 *            String
	 * @param tipo
	 *            String
	 * @return Saninterv
	 */
	public Saninterv dameInterviniente(String excodigo, String tipo) {
		{
			Saninterv saninterv = new Saninterv();
			saninterv.setExpedien(new Expedien(excodigo));
			saninterv.setUatipointerv(tipo);
			List<Saninterv> listaSaninterv = this.findAll(saninterv, null);
			if (listaSaninterv != null) {
				if (listaSaninterv.size() > 0) {
					saninterv = listaSaninterv.get(0);
					return saninterv;
				}
			}
			return null;

		}
	}

}
