package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.Expedien;
import com.ejie.y41b.model.Intervinientes;
import com.ejie.y41b.model.Organismo;
import com.ejie.y41b.model.Saninterv;

/**
 * SanintervDao  
 * 
 *  
 */

public interface SanintervDao {

	/**
	 * Inserts a single row in the Saninterv table.
	 * 
	 * @param saninterv
	 *            Saninterv
	 * @return Saninterv
	 */
	Saninterv add(Saninterv saninterv);

	/**
	 * Updates a single row in the Saninterv table.
	 * 
	 * @param saninterv
	 *            Saninterv
	 * @return Saninterv
	 */
	Saninterv update(Saninterv saninterv);

	/**
	 * Updates a single row in the Saninterv table.
	 * 
	 * @param escodigoBueno
	 *            Pagination
	 * @param escodigoAfusionar
	 *            Pagination
	 */
	public void updateEstablecimiento(String escodigoBueno,
			String escodigoAfusionar);

	/**
	 * Updates a single row in the Saninterv table.
	 * 
	 * @param dtcodigoBueno
	 *            Pagination
	 * @param dtcodigoAfusionar
	 *            Pagination
	 */
	public void updateConsumidor(String dtcodigoBueno, String dtcodigoAfusionar);

	/**
	 * Finds a single row in the Saninterv table.
	 * 
	 * @param saninterv
	 *            Saninterv
	 * @return Saninterv
	 */
	Saninterv find(Saninterv saninterv);

	/**
	 * Deletes a single row in the Saninterv table.
	 * 
	 * @param saninterv
	 *            Saninterv
	 * @return
	 */
	void remove(Saninterv saninterv);

	/**
	 * Finds a List of rows in the Saninterv table.
	 * 
	 * @param saninterv
	 *            Saninterv
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Saninterv> findAll(Saninterv saninterv, Pagination pagination);

	/**
	 * Counts rows in the Saninterv table.
	 * 
	 * @param saninterv
	 *            Saninterv
	 * @return Long
	 */
	Long findAllCount(Saninterv saninterv);

	/**
	 * Finds rows in the Saninterv table using like.
	 * 
	 * @param saninterv
	 *            Saninterv
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Saninterv> findAllLike(Saninterv saninterv, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Saninterv table using like.
	 * 
	 * @param saninterv
	 *            Saninterv
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Saninterv saninterv, Boolean startsWith);

	/**
	 * Finds a List of rows in the Saninterv table.
	 * 
	 * @param expedien
	 *            Expedien
	 * @return List<Saninterv>
	 */
	public List<Saninterv> findAllSancionados(Expedien expedien);

	/**
	 * Finds a List of rows in the Saninterv table.
	 * 
	 * @param expedien
	 *            Expedien
	 * @return List<Saninterv>
	 */
	public List<Saninterv> findAllInteresados(Expedien expedien);

	/**
	 * Finds a List of rows in the Saninterv table.
	 * 
	 * @param expedien
	 *            Expedien
	 * @param uatipointerv
	 *            String
	 * @return List<Saninterv>
	 */
	public List<Saninterv> findAllByTipo(Expedien expedien, String uatipointerv);

	/**
	 * Finds a row in the Saninterv table.
	 * 
	 * @param expedien
	 *            Expedien
	 * @param uatipointerv
	 *            String
	 * @param entidadId
	 *            String
	 * @return Saninterv
	 */
	public Saninterv findByTipoCodigoEntidad(Expedien expedien,
			String uatipointerv, String entidadId);

	/**
	 * Aniadir denunciantes.
	 * 
	 * @param excodigo
	 *            the excodigo
	 * @param excodigoNuevo
	 *            the excodigo nuevo
	 * @param tipo
	 *            the tipo
	 */
	void aniadirDenunciantes(String excodigo, String excodigoNuevo, String tipo);

	/**
	 * Aniadir denunciantes.
	 * 
	 * @param excodigo
	 *            the excodigo
	 * @param excodigoNuevo
	 *            the excodigo nuevo
	 * @param tipo
	 *            the tipo
	 */
	void aniadirDenunciantesArb(String excodigo, String excodigoNuevo,
			String tipo);

	/**
	 * Convierte organismo a san interv.
	 * 
	 * @param organismoAsesoria
	 *            the organismo asesoria
	 * @param expedien
	 *            the expedien
	 * @return the saninterv
	 */
	public Saninterv convierteOrganismoASanInterv(Organismo organismoAsesoria,
			Expedien expedien);

	/**
	 * Devuelve el numero de una secuencia
	 * 
	 * @return Integer
	 */
	public Integer currentValue();

	/**
	 * Finds a List of rows in the Saninterv table.
	 * 
	 * @param saninterv
	 *            Saninterv
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Intervinientes> findAllIntervinientes(Intervinientes saninterv,
			Pagination pagination);

	// EVOLUTIVO 0135083 2.2
	/**
	 * Finds a List of rows in the Saninterv table.
	 * 
	 * @param saninterv
	 *            Saninterv
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Intervinientes> findAllIntervinientesConCIF(Intervinientes saninterv,
			Pagination pagination);

	// EVOLUTIVO 0135083 2.2
	/**
	 * Dame sancionado.
	 * 
	 * @param excodigo
	 *            String
	 * @return Saninterv
	 */
	public Saninterv dameSancionado(String excodigo);

	/**
	 * @param excodigo
	 *            String
	 * @param excoes
	 *            String
	 * @param formanotificacion
	 *            String
	 */
	void updateFormaNotificacion(String excodigo, String excoes,
			String formanotificacion);

	/**
	 * 
	 * @param santinerv
	 *            Saninterv
	 * @param tipo
	 *            String
	 */
	void updateTipointervinienteAnterior(Saninterv santinerv, String tipo);

	/**
	 * 
	 * @param santinerv
	 *            Saninterv
	 * @param tipo
	 *            String
	 */
	void updateTipointerviniente(Saninterv santinerv, String tipo);

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Metodo para coger el interviniente sancionador por tipo de interviniente
	 * 
	 * @param excodigo
	 *            String
	 * @param tipo
	 *            String
	 * @return Saninterv
	 */
	Saninterv dameInterviniente(String excodigo, String tipo);
}
